/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.math.matrix.algorithm.pca;

import Jama.Matrix;
import org.openimaj.math.matrix.ThinSingularValueDecomposition;
import org.openimaj.math.matrix.algorithm.pca.PrincipalComponentAnalysis;

public class ThinSvdPrincipalComponentAnalysis
extends PrincipalComponentAnalysis {
    int ndims;

    public ThinSvdPrincipalComponentAnalysis(int ndims) {
        this.ndims = ndims;
    }

    @Override
    public void learnBasisNorm(Matrix data) {
        ThinSingularValueDecomposition svd = new ThinSingularValueDecomposition(data, this.ndims);
        this.basis = svd.Vt.transpose();
        this.eigenvalues = svd.S;
        double normEig = 1.0 / (double)(data.getRowDimension() - 1);
        for (int i = 0; i < this.eigenvalues.length; ++i) {
            this.eigenvalues[i] = this.eigenvalues[i] * this.eigenvalues[i] * normEig;
        }
    }
}

