/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.metadata.exif;

import com.twelvemonkeys.imageio.metadata.CompoundDirectory;
import com.twelvemonkeys.imageio.metadata.Directory;
import com.twelvemonkeys.imageio.metadata.Entry;
import com.twelvemonkeys.imageio.metadata.MetadataReader;
import com.twelvemonkeys.imageio.metadata.exif.EXIFDirectory;
import com.twelvemonkeys.imageio.metadata.exif.EXIFEntry;
import com.twelvemonkeys.imageio.metadata.exif.IFD;
import com.twelvemonkeys.imageio.metadata.exif.Rational;
import com.twelvemonkeys.imageio.metadata.exif.TIFF;
import com.twelvemonkeys.imageio.metadata.exif.Unknown;
import com.twelvemonkeys.lang.StringUtil;
import com.twelvemonkeys.lang.Validate;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.imageio.IIOException;
import javax.imageio.ImageIO;
import javax.imageio.stream.ImageInputStream;

public final class EXIFReader
extends MetadataReader {
    static final boolean DEBUG = "true".equalsIgnoreCase(System.getProperty("com.twelvemonkeys.imageio.metadata.exif.debug"));
    static final Collection<Integer> KNOWN_IFDS = Collections.unmodifiableCollection(Arrays.asList(34665, 34853, 40965, 330));

    @Override
    public Directory read(ImageInputStream imageInputStream) throws IOException {
        Validate.notNull((Object)imageInputStream, (String)"input");
        byte[] byArray = new byte[2];
        imageInputStream.readFully(byArray);
        if (byArray[0] == 73 && byArray[1] == 73) {
            imageInputStream.setByteOrder(ByteOrder.LITTLE_ENDIAN);
        } else if (byArray[0] == 77 && byArray[1] == 77) {
            imageInputStream.setByteOrder(ByteOrder.BIG_ENDIAN);
        } else {
            throw new IIOException(String.format("Invalid TIFF byte order mark '%s', expected: 'II' or 'MM'", StringUtil.decode((byte[])byArray, (int)0, (int)byArray.length, (String)"ASCII")));
        }
        int n = imageInputStream.readUnsignedShort();
        if (n != 42) {
            throw new IIOException(String.format("Wrong TIFF magic in EXIF data: %04x, expected: %04x", n, 42));
        }
        long l = imageInputStream.readUnsignedInt();
        return this.readDirectory(imageInputStream, l, true);
    }

    protected Directory readDirectory(ImageInputStream imageInputStream, long l, boolean bl) throws IOException {
        int n;
        ArrayList<IFD> arrayList = new ArrayList<IFD>();
        ArrayList<Entry> arrayList2 = new ArrayList<Entry>();
        imageInputStream.seek(l);
        long l2 = -1L;
        try {
            n = imageInputStream.readUnsignedShort();
        }
        catch (EOFException eOFException) {
            n = 0;
        }
        for (int i = 0; i < n; ++i) {
            try {
                EXIFEntry eXIFEntry = this.readEntry(imageInputStream);
                if (eXIFEntry == null) continue;
                arrayList2.add(eXIFEntry);
                continue;
            }
            catch (IIOException iIOException) {
                break;
            }
        }
        if (bl) {
            if (l2 == -1L) {
                try {
                    l2 = imageInputStream.readUnsignedInt();
                }
                catch (EOFException eOFException) {
                    l2 = 0L;
                }
            }
            if (l2 != 0L) {
                CompoundDirectory compoundDirectory = (CompoundDirectory)this.readDirectory(imageInputStream, l2, true);
                for (int i = 0; i < compoundDirectory.directoryCount(); ++i) {
                    arrayList.add((IFD)compoundDirectory.getDirectory(i));
                }
            }
        }
        this.readSubdirectories(imageInputStream, arrayList2, Arrays.asList(34665, 34853, 40965, 330));
        arrayList.add(0, new IFD(arrayList2));
        return new EXIFDirectory((Collection<? extends Directory>)arrayList);
    }

    private void readSubdirectories(ImageInputStream imageInputStream, List<Entry> list, List<Integer> list2) throws IOException {
        if (list2 == null || list2.isEmpty()) {
            return;
        }
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            EXIFEntry eXIFEntry = (EXIFEntry)list.get(i);
            int n2 = (Integer)eXIFEntry.getIdentifier();
            if (!list2.contains(n2)) continue;
            try {
                if (!KNOWN_IFDS.contains(n2)) continue;
                long[] lArray = this.getPointerOffsets(eXIFEntry);
                ArrayList<IFD> arrayList = new ArrayList<IFD>(lArray.length);
                for (long l : lArray) {
                    CompoundDirectory compoundDirectory = (CompoundDirectory)this.readDirectory(imageInputStream, l, false);
                    for (int j = 0; j < compoundDirectory.directoryCount(); ++j) {
                        arrayList.add((IFD)compoundDirectory.getDirectory(j));
                    }
                }
                if (arrayList.size() == 1) {
                    list.set(i, new EXIFEntry(n2, arrayList.get(0), eXIFEntry.getType()));
                    continue;
                }
                list.set(i, new EXIFEntry(n2, arrayList.toArray(new IFD[arrayList.size()]), eXIFEntry.getType()));
                continue;
            }
            catch (IIOException iIOException) {
                if (!DEBUG) continue;
                System.err.println("Error parsing sub-IFD: " + n2);
                iIOException.printStackTrace();
            }
        }
    }

    private long[] getPointerOffsets(Entry entry) throws IIOException {
        long[] lArray;
        Object object = entry.getValue();
        if (object instanceof Byte) {
            lArray = new long[]{(Byte)object & 0xFF};
        } else if (object instanceof Short) {
            lArray = new long[]{(Short)object & 0xFFFF};
        } else if (object instanceof Integer) {
            lArray = new long[]{(long)((Integer)object).intValue() & 0xFFFFFFFFL};
        } else if (object instanceof Long) {
            lArray = new long[]{(Long)object};
        } else if (object instanceof long[]) {
            lArray = (long[])object;
        } else {
            throw new IIOException(String.format("Unknown pointer type: %s", object != null ? object.getClass() : null));
        }
        return lArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EXIFEntry readEntry(ImageInputStream imageInputStream) throws IOException {
        Object object;
        int n = imageInputStream.readUnsignedShort();
        short s = imageInputStream.readShort();
        int n2 = imageInputStream.readInt();
        if (n2 < 0) {
            throw new IIOException(String.format("Illegal count %d for tag %s type %s @%08x", n2, n, s, imageInputStream.getStreamPosition()));
        }
        if (s <= 0 || s > 13) {
            imageInputStream.skipBytes(4);
            long l = imageInputStream.getStreamPosition() - 12L;
            if (DEBUG) {
                System.err.printf("Bad EXIF data @%08x\n", imageInputStream.getStreamPosition());
                System.err.println("tagId: " + n + (n <= 0 ? " (INVALID)" : ""));
                System.err.println("type: " + s + " (INVALID)");
                System.err.println("count: " + n2);
                imageInputStream.mark();
                imageInputStream.seek(l);
                try {
                    byte[] byArray = new byte[8 + Math.min(120, Math.max(24, n2))];
                    int n3 = imageInputStream.read(byArray);
                    if (DEBUG) {
                        System.err.print(HexDump.dump(l, byArray, 0, n3));
                        System.err.println(n3 < n2 ? "[...]" : "");
                    }
                }
                finally {
                    imageInputStream.reset();
                }
            }
            return null;
        }
        int n4 = EXIFReader.getValueLength(s, n2);
        if (n4 > 0 && n4 <= 4) {
            object = this.readValueInLine(imageInputStream, s, n2);
            imageInputStream.skipBytes(4 - n4);
        } else {
            long l = imageInputStream.readUnsignedInt();
            object = this.readValueAt(imageInputStream, l, s, n2);
        }
        return new EXIFEntry(n, object, s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object readValueAt(ImageInputStream imageInputStream, long l, short s, int n) throws IOException {
        long l2 = imageInputStream.getStreamPosition();
        try {
            imageInputStream.seek(l);
            Object object = EXIFReader.readValue(imageInputStream, s, n);
            return object;
        }
        finally {
            imageInputStream.seek(l2);
        }
    }

    private Object readValueInLine(ImageInputStream imageInputStream, short s, int n) throws IOException {
        return EXIFReader.readValue(imageInputStream, s, n);
    }

    private static Object readValue(ImageInputStream imageInputStream, short s, int n) throws IOException {
        long l = imageInputStream.getStreamPosition();
        switch (s) {
            case 2: {
                if (n == 0) {
                    return "";
                }
                byte[] byArray = new byte[n];
                imageInputStream.readFully(byArray);
                int n2 = byArray[byArray.length - 1] == 0 ? byArray.length - 1 : byArray.length;
                return StringUtil.decode((byte[])byArray, (int)0, (int)n2, (String)"UTF-8");
            }
            case 1: {
                if (n == 1) {
                    return imageInputStream.readUnsignedByte();
                }
            }
            case 6: {
                if (n == 1) {
                    return imageInputStream.readByte();
                }
            }
            case 7: {
                byte[] byArray = new byte[n];
                imageInputStream.readFully(byArray);
                return byArray;
            }
            case 3: {
                if (n == 1) {
                    return imageInputStream.readUnsignedShort();
                }
            }
            case 8: {
                if (n == 1) {
                    return imageInputStream.readShort();
                }
                short[] sArray = new short[n];
                imageInputStream.readFully(sArray, 0, sArray.length);
                if (s == 3) {
                    int[] nArray = new int[n];
                    for (int i = 0; i < n; ++i) {
                        nArray[i] = sArray[i] & 0xFFFF;
                    }
                    return nArray;
                }
                return sArray;
            }
            case 4: 
            case 13: {
                if (n == 1) {
                    return imageInputStream.readUnsignedInt();
                }
            }
            case 9: {
                if (n == 1) {
                    return imageInputStream.readInt();
                }
                int[] nArray = new int[n];
                imageInputStream.readFully(nArray, 0, nArray.length);
                if (s == 4 || s == 13) {
                    long[] lArray = new long[n];
                    for (int i = 0; i < n; ++i) {
                        lArray[i] = (long)nArray[i] & 0xFFFFFFFFL;
                    }
                    return lArray;
                }
                return nArray;
            }
            case 11: {
                if (n == 1) {
                    return Float.valueOf(imageInputStream.readFloat());
                }
                float[] fArray = new float[n];
                imageInputStream.readFully(fArray, 0, fArray.length);
                return fArray;
            }
            case 12: {
                if (n == 1) {
                    return imageInputStream.readDouble();
                }
                double[] dArray = new double[n];
                imageInputStream.readFully(dArray, 0, dArray.length);
                return dArray;
            }
            case 5: {
                if (n == 1) {
                    return EXIFReader.createSafeRational(imageInputStream.readUnsignedInt(), imageInputStream.readUnsignedInt());
                }
                Rational[] rationalArray = new Rational[n];
                for (int i = 0; i < rationalArray.length; ++i) {
                    rationalArray[i] = EXIFReader.createSafeRational(imageInputStream.readUnsignedInt(), imageInputStream.readUnsignedInt());
                }
                return rationalArray;
            }
            case 10: {
                if (n == 1) {
                    return EXIFReader.createSafeRational(imageInputStream.readInt(), imageInputStream.readInt());
                }
                Rational[] rationalArray = new Rational[n];
                for (int i = 0; i < rationalArray.length; ++i) {
                    rationalArray[i] = EXIFReader.createSafeRational(imageInputStream.readInt(), imageInputStream.readInt());
                }
                return rationalArray;
            }
            case 16: 
            case 17: 
            case 18: {
                if (n == 1) {
                    long l2 = imageInputStream.readLong();
                    if (s != 17 && l2 < 0L) {
                        throw new IIOException(String.format("Value > %s", Long.MAX_VALUE));
                    }
                    return l2;
                }
                long[] lArray = new long[n];
                for (int i = 0; i < n; ++i) {
                    lArray[i] = imageInputStream.readLong();
                }
                return lArray;
            }
        }
        return new Unknown(s, n, l);
    }

    private static Rational createSafeRational(long l, long l2) throws IOException {
        if (l2 == 0L) {
            return Rational.NaN;
        }
        return new Rational(l, l2);
    }

    static int getValueLength(int n, int n2) {
        if (n > 0 && n < TIFF.TYPE_LENGTHS.length) {
            return TIFF.TYPE_LENGTHS[n] * n2;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) throws IOException {
        EXIFReader eXIFReader = new EXIFReader();
        ImageInputStream imageInputStream = ImageIO.createImageInputStream(new File(stringArray[0]));
        long l = 0L;
        if (stringArray.length > 1) {
            l = stringArray[1].startsWith("0x") ? (long)Integer.parseInt(stringArray[1].substring(2), 16) : Long.parseLong(stringArray[1]);
            imageInputStream.setByteOrder(l < 0L ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN);
            l = Math.abs(l);
            imageInputStream.seek(l);
        }
        try {
            Directory directory = stringArray.length > 1 ? eXIFReader.readDirectory(imageInputStream, l, false) : eXIFReader.read(imageInputStream);
            for (Entry entry : directory) {
                System.err.println(entry);
                Object object = entry.getValue();
                if (!(object instanceof byte[])) continue;
                byte[] byArray = (byte[])object;
                System.err.println(HexDump.dump(0L, byArray, 0, Math.min(byArray.length, 128)));
            }
        }
        finally {
            imageInputStream.close();
        }
    }

    public static class HexDump {
        private static final int WIDTH = 32;

        private HexDump() {
        }

        public static String dump(byte[] byArray) {
            return HexDump.dump(0L, byArray, 0, byArray.length);
        }

        public static String dump(long l, byte[] byArray, int n, int n2) {
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < n2; ++i) {
                if (i % 32 == 0) {
                    if (i > 0) {
                        stringBuilder.append("\n");
                    }
                    stringBuilder.append(String.format("%08x: ", (long)(i + n) + l));
                } else if (i > 0 && i % 2 == 0) {
                    stringBuilder.append(" ");
                }
                stringBuilder.append(String.format("%02x", byArray[i + n]));
                int n3 = i + 1;
                if (n3 % 32 != 0 && n3 != n2) continue;
                int n4 = (32 - n3 % 32) % 32;
                if (n4 != 0) {
                    int n5 = n4 / 2;
                    if (n2 % 2 != 0) {
                        stringBuilder.append("  ");
                    }
                    for (int j = 0; j < n5; ++j) {
                        stringBuilder.append("     ");
                    }
                }
                stringBuilder.append("  ");
                stringBuilder.append(HexDump.toAsciiString(byArray, n3 - (32 - n4) + n, n3 + n));
            }
            return stringBuilder.toString();
        }

        private static String toAsciiString(byte[] byArray, int n, int n2) {
            byte[] byArray2 = Arrays.copyOfRange(byArray, n, n2);
            for (int i = 0; i < byArray2.length; ++i) {
                if (byArray2[i] >= 32 && byArray2[i] <= 126) continue;
                byArray2[i] = 46;
            }
            return new String(byArray2, Charset.forName("ascii"));
        }
    }
}

