/*
 * Decompiled with CFR 0.152.
 */
package org.myworldgis.util;

import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.awt.image.BandedSampleModel;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferDouble;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;

public final class ValueColorModel
extends ColorModel {
    private final double _min;
    private final double _scale;

    public ValueColorModel(Raster raster) {
        super(DataBuffer.getDataTypeSize(5), new int[]{DataBuffer.getDataTypeSize(5)}, new ICC_ColorSpace(ICC_Profile.getInstance(1003)), false, false, 1, 5);
        double min = Double.MAX_VALUE;
        double max = -1.7976931348623157E308;
        DataBuffer buffer = raster.getDataBuffer();
        for (int i = 0; i < buffer.getSize(); ++i) {
            double d = buffer.getElemDouble(i);
            if (d < min) {
                min = d;
            }
            if (!(d > max)) continue;
            max = d;
        }
        this._min = min;
        this._scale = 1.0 / (max - min);
    }

    @Override
    public boolean isCompatibleRaster(Raster raster) {
        return raster.getDataBuffer().getDataType() == 5 && raster.getNumBands() == 1;
    }

    @Override
    public float[] getNormalizedComponents(Object pixel, float[] normComponents, int normOffset) {
        double value;
        if (normComponents == null) {
            normComponents = new float[normOffset + 1];
        }
        if (Double.isNaN(value = ((double[])pixel)[0])) {
            normComponents[normOffset] = 0.0f;
        } else {
            ColorSpace cs = this.getColorSpace();
            float min = cs.getMinValue(0);
            float max = cs.getMaxValue(0);
            normComponents[normOffset] = (float)((value - this._min) * this._scale * (double)(max - min) + (double)min);
        }
        return normComponents;
    }

    @Override
    public Object getDataElements(int rgb, Object pixel) {
        if (pixel == null) {
            pixel = new double[1];
        }
        double[] dpix = (double[])pixel;
        dpix[0] = rgb >> 24 == 0 ? Double.NaN : (double)(rgb & 0xFF) / 255.0 / this._scale + this._min;
        return pixel;
    }

    @Override
    public WritableRaster createCompatibleWritableRaster(int w, int h) {
        return Raster.createWritableRaster(this.createCompatibleSampleModel(w, h), new DataBufferDouble(w * h), null);
    }

    @Override
    public SampleModel createCompatibleSampleModel(int w, int h) {
        return new BandedSampleModel(5, w, h, 1);
    }

    @Override
    public boolean isCompatibleSampleModel(SampleModel sm) {
        return sm.getDataType() == 5 && sm.getNumBands() == 1;
    }

    @Override
    public int getRed(int pixel) {
        throw new IllegalArgumentException("values not representable as int");
    }

    @Override
    public int getGreen(int pixel) {
        throw new IllegalArgumentException("values not representable as int");
    }

    @Override
    public int getBlue(int pixel) {
        throw new IllegalArgumentException("values not representable as int");
    }

    @Override
    public int getAlpha(int pixel) {
        throw new IllegalArgumentException("values not representable as int");
    }
}

