/*
 * Decompiled with CFR 0.152.
 */
package org.ngs.ngunits.converter;

import org.ngs.ngunits.UnitConverter;
import org.ngs.ngunits.converter.AbstractUnitConverter;

public abstract class LogConverter
extends AbstractUnitConverter {
    protected final double _base;
    protected final double _logOfBase;

    protected LogConverter(double d) {
        this._base = d;
        this._logOfBase = Math.log(d);
    }

    public double getBase() {
        return this._base;
    }

    public boolean isLinear() {
        return false;
    }

    public static final class Exp
    extends LogConverter {
        public Exp(double d) {
            super(d);
        }

        public UnitConverter inverse() {
            return new Log(this._base);
        }

        public double convert(double d) {
            return Math.log(d) / this._logOfBase;
        }
    }

    public static final class Log
    extends LogConverter {
        public Log(double d) {
            super(d);
        }

        public UnitConverter inverse() {
            return new Exp(this._base);
        }

        public double convert(double d) {
            return Math.log(d) / this._logOfBase;
        }
    }
}

