/*
 * Decompiled with CFR 0.152.
 */
package sun.management;

import com.sun.management.UnixOperatingSystemMXBean;
import java.util.concurrent.TimeUnit;
import jdk.internal.platform.Container;
import jdk.internal.platform.Metrics;
import sun.management.BaseOperatingSystemImpl;
import sun.management.VMManagement;

class OperatingSystemImpl
extends BaseOperatingSystemImpl
implements UnixOperatingSystemMXBean {
    private static final int MAX_ATTEMPTS_NUMBER = 10;
    private final Metrics containerMetrics = Container.metrics();

    OperatingSystemImpl(VMManagement vMManagement) {
        super(vMManagement);
    }

    @Override
    public long getTotalSwapSpaceSize() {
        if (this.containerMetrics != null) {
            long l = this.containerMetrics.getMemoryAndSwapLimit();
            long l2 = this.containerMetrics.getMemoryLimit();
            if (l >= 0L && l2 >= 0L) {
                return l - l2;
            }
        }
        return this.getTotalSwapSpaceSize0();
    }

    @Override
    public long getFreeSwapSpaceSize() {
        if (this.containerMetrics != null) {
            long l = this.containerMetrics.getMemoryAndSwapLimit();
            long l2 = this.containerMetrics.getMemoryLimit();
            if (l >= 0L && l2 >= 0L) {
                for (int i = 0; i < 10; ++i) {
                    long l3 = this.containerMetrics.getMemoryAndSwapUsage();
                    long l4 = this.containerMetrics.getMemoryUsage();
                    if (l3 <= 0L || l4 <= 0L || l3 - l4 < 0L) continue;
                    return l - l2 - (l3 - l4);
                }
            }
        }
        return this.getFreeSwapSpaceSize0();
    }

    @Override
    public long getFreePhysicalMemorySize() {
        if (this.containerMetrics != null) {
            long l = this.containerMetrics.getMemoryUsage();
            long l2 = this.containerMetrics.getMemoryLimit();
            if (l > 0L && l2 >= 0L) {
                return l2 - l;
            }
        }
        return this.getFreePhysicalMemorySize0();
    }

    @Override
    public long getTotalPhysicalMemorySize() {
        long l;
        if (this.containerMetrics != null && (l = this.containerMetrics.getMemoryLimit()) >= 0L) {
            return l;
        }
        return this.getTotalPhysicalMemorySize0();
    }

    @Override
    public double getSystemCpuLoad() {
        if (this.containerMetrics != null) {
            long l = this.containerMetrics.getCpuQuota();
            if (l > 0L) {
                long l2 = this.containerMetrics.getCpuPeriod();
                long l3 = this.containerMetrics.getCpuNumPeriods();
                long l4 = this.containerMetrics.getCpuUsage();
                if (l2 > 0L && l3 > 0L && l4 > 0L) {
                    long l5 = TimeUnit.MICROSECONDS.toNanos(l2 * l3);
                    double d = (double)l4 / (double)l5;
                    d = Math.max(0.0, d);
                    d = Math.min(1.0, d);
                    return d;
                }
                return -1.0;
            }
            if (this.isCpuSetSameAsHostCpuSet()) {
                return this.getSystemCpuLoad0();
            }
            int[] nArray = this.containerMetrics.getEffectiveCpuSetCpus();
            if (nArray != null && nArray.length > 0) {
                double d = 0.0;
                for (int n : nArray) {
                    double d2 = this.getSingleCpuLoad0(n);
                    if (d2 < 0.0) {
                        return -1.0;
                    }
                    d += d2;
                }
                return d / (double)nArray.length;
            }
            return -1.0;
        }
        return this.getSystemCpuLoad0();
    }

    private boolean isCpuSetSameAsHostCpuSet() {
        if (this.containerMetrics != null) {
            return this.containerMetrics.getCpuSetCpus().length == this.getHostConfiguredCpuCount0();
        }
        return false;
    }

    @Override
    public native long getCommittedVirtualMemorySize();

    private native long getTotalSwapSpaceSize0();

    private native long getFreeSwapSpaceSize0();

    @Override
    public native long getProcessCpuTime();

    private native long getFreePhysicalMemorySize0();

    private native long getTotalPhysicalMemorySize0();

    @Override
    public native long getOpenFileDescriptorCount();

    @Override
    public native long getMaxFileDescriptorCount();

    private native double getSystemCpuLoad0();

    @Override
    public native double getProcessCpuLoad();

    private native double getSingleCpuLoad0(int var1);

    private native int getHostConfiguredCpuCount0();

    private static native void initialize();

    static {
        OperatingSystemImpl.initialize();
    }
}

