/*
 * Decompiled with CFR 0.152.
 */
package bsearch.representations;

import bsearch.representations.Chromosome;
import bsearch.space.ParameterSpec;
import bsearch.space.SearchSpace;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import org.nlogo.api.MersenneTwisterFast;

public strictfp abstract class BinaryChromosome
implements Chromosome {
    public static final int NUM_BITS_FOR_CONTINUOUS_PARAMETERS = 16;
    protected final boolean[] bitstring;
    protected final SearchSpace searchSpace;

    private static int numBitsRequired(long choiceCount) {
        if (choiceCount > 0L) {
            return (int)StrictMath.ceil(StrictMath.log(choiceCount) / StrictMath.log(2.0));
        }
        return 16;
    }

    public BinaryChromosome(SearchSpace searchSpace, MersenneTwisterFast rng) {
        this.searchSpace = searchSpace;
        List<ParameterSpec> paramSpecs = searchSpace.getParamSpecs();
        int bitstringLength = 0;
        for (ParameterSpec p : paramSpecs) {
            bitstringLength += BinaryChromosome.numBitsRequired(p.choiceCount());
        }
        this.bitstring = new boolean[bitstringLength];
        int offset = 0;
        for (ParameterSpec p : paramSpecs) {
            int numbits = BinaryChromosome.numBitsRequired(p.choiceCount());
            if (numbits <= 0) continue;
            this.binaryEncode(rng.nextLong(1L << numbits), this.bitstring, offset, numbits);
            offset += numbits;
        }
    }

    public BinaryChromosome(SearchSpace searchSpace, LinkedHashMap<String, Object> paramSettings) {
        this.searchSpace = searchSpace;
        List<ParameterSpec> paramSpecs = searchSpace.getParamSpecs();
        if (paramSpecs.size() != paramSettings.size()) {
            throw new IllegalStateException("# of parameter settings does not match search space parameter specifications.");
        }
        int bitstringLength = 0;
        for (ParameterSpec p : paramSpecs) {
            bitstringLength += BinaryChromosome.numBitsRequired(p.choiceCount());
        }
        this.bitstring = new boolean[bitstringLength];
        int offset = 0;
        for (int i = 0; i < paramSpecs.size(); ++i) {
            ParameterSpec p = paramSpecs.get(i);
            Object value = paramSettings.get(p.getParameterName());
            int numbits = BinaryChromosome.numBitsRequired(p.choiceCount());
            long choice = p.getChoiceIndexFromValue(value, 1L << numbits);
            if (numbits <= 0) continue;
            this.binaryEncode(choice, this.bitstring, offset, numbits);
            offset += numbits;
        }
    }

    protected BinaryChromosome(boolean[] bitstring, SearchSpace searchSpace) {
        this.bitstring = (boolean[])bitstring.clone();
        this.searchSpace = searchSpace;
    }

    public abstract void binaryEncode(long var1, boolean[] var3, int var4, int var5);

    public abstract long binaryDecode(boolean[] var1, int var2, int var3);

    static String toBinaryString(boolean[] bitstring) {
        String s = "";
        for (boolean b : bitstring) {
            s = (b ? (char)'1' : '0') + s;
        }
        return s;
    }

    public String getBinaryString() {
        return BinaryChromosome.toBinaryString(this.bitstring);
    }

    @Override
    public LinkedHashMap<String, Object> getParamSettings() {
        LinkedHashMap<String, Object> paramSettings = new LinkedHashMap<String, Object>();
        int offset = 0;
        for (ParameterSpec p : this.searchSpace.getParamSpecs()) {
            int numbits = BinaryChromosome.numBitsRequired(p.choiceCount());
            if (numbits > 0) {
                paramSettings.put(p.getParameterName(), p.getValueFromChoice(this.binaryDecode(this.bitstring, offset, numbits), 1L << numbits));
                offset += numbits;
                continue;
            }
            paramSettings.put(p.getParameterName(), p.getValueFromChoice(0L, 0L));
        }
        return paramSettings;
    }

    @Override
    public abstract BinaryChromosome clone();

    @Override
    public Chromosome mutate(double mutRate, MersenneTwisterFast rng) {
        BinaryChromosome bc = this.clone();
        for (int i = 0; i < bc.bitstring.length; ++i) {
            if (!(rng.nextDouble() < mutRate)) continue;
            bc.bitstring[i] = !bc.bitstring[i];
        }
        return bc;
    }

    @Override
    public Chromosome[] crossoverWith(Chromosome other, MersenneTwisterFast rng) {
        if (!(other instanceof BinaryChromosome)) {
            throw new IllegalStateException("Can't crossover different types of Chromosomes.");
        }
        BinaryChromosome parent0 = this;
        BinaryChromosome parent1 = (BinaryChromosome)other;
        Chromosome[] children = new BinaryChromosome[]{parent0.clone(), parent1.clone()};
        int len = parent1.bitstring.length;
        int splitPoint = 1 + rng.nextInt(len);
        for (int i = 0; i < len; ++i) {
            if (i < splitPoint) continue;
            ((BinaryChromosome)children[0]).bitstring[i] = parent1.bitstring[i];
            ((BinaryChromosome)children[1]).bitstring[i] = parent0.bitstring[i];
        }
        return children;
    }

    @Override
    public SearchSpace getSearchSpace() {
        return this.searchSpace;
    }

    public boolean equals(Object other) {
        if (other instanceof BinaryChromosome) {
            BinaryChromosome gbc = (BinaryChromosome)other;
            return Arrays.equals(this.bitstring, gbc.bitstring);
        }
        return false;
    }

    public int hashCode() {
        int hash = 0;
        for (boolean b : this.bitstring) {
            hash *= 2;
            hash += b ? 1 : 0;
        }
        return hash;
    }
}

