/*
 * Decompiled with CFR 0.152.
 */
package bsearch.fx;

import bsearch.algorithms.SearchParameterException;
import bsearch.app.BehaviorSearch;
import bsearch.app.SearchProtocol;
import bsearch.evaluation.ResultListener;
import bsearch.evaluation.SearchManager;
import bsearch.fx.MainController;
import bsearch.nlogolink.ModelRunResult;
import bsearch.nlogolink.ModelRunner;
import bsearch.representations.Chromosome;
import bsearch.space.SearchSpace;
import bsearch.util.GeneralUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.CancellationException;
import java.util.concurrent.FutureTask;
import javafx.application.Platform;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.chart.LineChart;
import javafx.scene.chart.XYChart;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressBar;
import javafx.scene.web.WebView;
import javafx.stage.Stage;

public class ProgressController {
    @FXML
    LineChart<Number, Number> progressLineChart;
    @FXML
    ProgressBar progressBar;
    @FXML
    Button cancelAndDoneButton;
    @FXML
    Label labelTimeRemaining;
    @FXML
    Label labelMessage;
    @FXML
    WebView infoTextWebView;
    private FutureTask<Void> task;
    private long taskStartTime;
    private boolean done = false;

    public void initialize() {
        this.progressLineChart.setTitle("Search Progress");
        this.progressLineChart.getXAxis().setLabel("# of model runs");
        this.progressLineChart.getYAxis().setLabel("Fitness");
        this.progressLineChart.setCreateSymbols(false);
        this.progressLineChart.getYAxis().setAutoRanging(true);
        this.progressLineChart.setAnimated(false);
        this.progressLineChart.getXAxis().setAnimated(true);
    }

    public void startSearchTask(SearchProtocol protocol, BehaviorSearch.RunOptions runOptions) {
        this.labelMessage.setText("Search 0 of " + runOptions.numSearches);
        this.taskStartTime = System.currentTimeMillis();
        final TaskWorker insideTask = new TaskWorker(protocol, runOptions);
        this.task = new FutureTask<Object>(insideTask, null);
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    ProgressController.this.task.run();
                    ProgressController.this.task.get();
                    if (insideTask.fatalException != null) {
                        throw insideTask.fatalException;
                    }
                }
                catch (CancellationException e) {
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            Alert alert = new Alert(Alert.AlertType.WARNING);
                            alert.setTitle("Cancelled");
                            alert.setContentText("You canceled the search.  \nPartial results may have been saved to output files.");
                            alert.showAndWait();
                        }
                    });
                }
                catch (ModelRunner.ModelRunnerException e) {
                    e.printStackTrace();
                    MainController.handleError("Error running the model:\n" + e.getMessage(), e);
                }
                catch (SearchParameterException e) {
                    e.printStackTrace();
                    MainController.handleError("Error setting search method parameters:\n" + e.getMessage(), e);
                }
                catch (IOException e) {
                    MainController.handleError("Error reading or writing files:\n" + e.getMessage(), e);
                    e.printStackTrace();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    MainController.handleError(e.getMessage(), e);
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    MainController.handleError("Serious Error: " + e.getMessage(), e);
                }
            }
        }).start();
    }

    public void doCancel(ActionEvent event) {
        if (this.done) {
            Node source = (Node)event.getSource();
            Stage thisStage = (Stage)source.getScene().getWindow();
            thisStage.close();
        } else {
            this.task.cancel(true);
            this.cancelAndDoneButton.setText("Done");
            this.done = true;
        }
    }

    class TaskWorker
    implements Runnable,
    ResultListener {
        private SearchProtocol protocol;
        private BehaviorSearch.RunOptions runOptions;
        protected Throwable fatalException = null;
        private double evaluationLimit;
        Chromosome overallBest = null;
        double overallBestFitness;
        double overallBestFitnessChecked;

        public TaskWorker(SearchProtocol protocol, BehaviorSearch.RunOptions runOptions) {
            this.protocol = protocol;
            this.runOptions = runOptions;
            this.evaluationLimit = protocol.evaluationLimit;
        }

        @Override
        public void initListener(SearchSpace space) {
        }

        @Override
        public void modelRunOccurred(SearchManager manager, Chromosome point, ModelRunResult result) {
            long currentTime = System.currentTimeMillis();
            long elapsed = currentTime - ProgressController.this.taskStartTime;
            final String elapsedStr = GeneralUtils.formatTimeNicely(elapsed);
            int searchesCompleted = manager.getSearchIDNumber() - this.runOptions.firstSearchNumber;
            int totalSearches = this.runOptions.numSearches;
            double runsCompleted = manager.getEvaluationCount() + manager.getAuxilliaryEvaluationCount();
            double totalRuns = this.protocol.evaluationLimit + manager.getAuxilliaryEvaluationCount();
            double searchProgress = ((double)searchesCompleted + runsCompleted / totalRuns) / (double)totalSearches;
            long remaining = (long)((double)elapsed / searchProgress - (double)elapsed);
            final String remainingStr = GeneralUtils.formatTimeNicely(remaining);
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    ProgressController.this.labelTimeRemaining.setText(" (" + elapsedStr + " elapsed - " + remainingStr + " remaining)");
                }
            });
        }

        @Override
        public void fitnessComputed(SearchManager manager, Chromosome point, double fitness) {
            final int searchNumber = manager.getSearchIDNumber();
            final double bestFitnessSoFar = this.protocol.useBestChecking() ? manager.getCurrentBestFitnessCheckedEstimate() : manager.getCurrentBestFitness();
            final int evaluationCount = manager.getEvaluationCount();
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    int itemCount;
                    XYChart.Series series;
                    ProgressController.this.progressBar.setProgress((double)evaluationCount / TaskWorker.this.evaluationLimit);
                    if (searchNumber - ((TaskWorker)TaskWorker.this).runOptions.firstSearchNumber + 1 > ProgressController.this.progressLineChart.getData().size()) {
                        series = new XYChart.Series();
                        series.setName("Search " + searchNumber);
                        ProgressController.this.progressLineChart.getData().addAll((Object[])new XYChart.Series[]{series});
                    }
                    if ((itemCount = (series = (XYChart.Series)ProgressController.this.progressLineChart.getData().get(searchNumber - ((TaskWorker)TaskWorker.this).runOptions.firstSearchNumber)).getData().size()) == 0) {
                        series.getData().add((Object)new XYChart.Data((Object)evaluationCount, (Object)bestFitnessSoFar));
                    } else {
                        XYChart.Data lastPoint = (XYChart.Data)series.getData().get(itemCount - 1);
                        if (evaluationCount > ((Number)lastPoint.getXValue()).intValue() || bestFitnessSoFar != ((Number)lastPoint.getYValue()).doubleValue()) {
                            if (itemCount > 1 && ((Number)lastPoint.getYValue()).doubleValue() == bestFitnessSoFar && ((Number)((XYChart.Data)series.getData().get(itemCount - 2)).getYValue()).doubleValue() == bestFitnessSoFar) {
                                series.getData().remove(itemCount - 1);
                            }
                            series.getData().add((Object)new XYChart.Data((Object)evaluationCount, (Object)bestFitnessSoFar));
                        }
                    }
                }
            });
        }

        @Override
        public void newBestFound(SearchManager manager) {
            this.updateInfoText("In Search #" + manager.getSearchIDNumber() + ":", manager.getCurrentBest(), manager.getCurrentBestFitness(), manager.getCurrentBestFitnessCheckedEstimate());
        }

        private void updateGUIForNextSearch(final int searchNum) {
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    ProgressController.this.labelMessage.setText("Performing search " + (searchNum - ((TaskWorker)TaskWorker.this).runOptions.firstSearchNumber + 1) + " of " + ((TaskWorker)TaskWorker.this).runOptions.numSearches + ":  ");
                }
            });
        }

        @Override
        public void searchStarting(SearchManager manager) {
            this.updateGUIForNextSearch(manager.getSearchIDNumber());
        }

        @Override
        public void searchFinished(SearchManager manager) {
            double bestFitness = manager.getCurrentBestFitness();
            if (this.overallBest == null || manager.fitnessStrictlyBetter(bestFitness, this.overallBestFitness)) {
                this.overallBest = manager.getCurrentBest();
                this.overallBestFitness = bestFitness;
                if (this.protocol.useBestChecking()) {
                    this.overallBestFitnessChecked = manager.getCurrentBestFitnessCheckedEstimate();
                }
            }
        }

        @Override
        public void allSearchesFinished() {
            this.updateInfoText("From all searches:", this.overallBest, this.overallBestFitness, this.overallBestFitnessChecked);
        }

        @Override
        public void searchesAborted() {
        }

        @Override
        public void run() {
            try {
                ArrayList<ResultListener> listeners = new ArrayList<ResultListener>();
                listeners.add(this);
                BehaviorSearch.runWithOptions(this.runOptions, this.protocol, listeners);
                this.updateGUIWhenFinished();
            }
            catch (Throwable e) {
                this.fatalException = e;
            }
        }

        public void updateGUIWhenFinished() {
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    ProgressController.this.labelMessage.setText("Finished search " + ((TaskWorker)TaskWorker.this).runOptions.numSearches + " of " + ((TaskWorker)TaskWorker.this).runOptions.numSearches + ":  ");
                    ProgressController.this.progressBar.setProgress(1.0);
                    ProgressController.this.cancelAndDoneButton.setText("Done");
                    ProgressController.this.done = true;
                }
            });
        }

        private void updateInfoText(String title, Chromosome c, double fitness, double checkedFitness) {
            String bestText = GeneralUtils.getParamSettingsTextHTML(c.getParamSettings());
            StringBuilder sb = new StringBuilder();
            sb.append("<p>");
            sb.append("<B><I>" + title + "</I></B>");
            sb.append("<BR><BR><B>Best found so far:</B><BR>");
            sb.append(bestText);
            sb.append("<BR><B>Fitness</B>=");
            sb.append(String.format("%10.6g", fitness));
            sb.append("<BR>");
            if (this.protocol.useBestChecking()) {
                sb.append("<B>(re-checked)</B>=");
                sb.append(String.format("%10.6g", checkedFitness));
                sb.append("<BR>");
            }
            sb.append("</p>");
            final String text = sb.toString();
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    ProgressController.this.infoTextWebView.getEngine().loadContent(text);
                }
            });
        }
    }
}

