/*
 * Decompiled with CFR 0.152.
 */
package bsearch.evaluation;

import bsearch.nlogolink.ModelRunResult;
import bsearch.representations.Chromosome;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class ResultsArchive {
    private HashMap<Chromosome, List<ModelRunResult>> cacheMap;

    public ResultsArchive(int initialCapacity) {
        this.cacheMap = new HashMap(initialCapacity);
    }

    public void clear() {
        this.cacheMap.clear();
    }

    public void add(Chromosome point, ModelRunResult result, int defaultNewListCapacity) {
        List<ModelRunResult> storedResults = this.cacheMap.get(point);
        if (storedResults == null) {
            storedResults = new ArrayList<ModelRunResult>(defaultNewListCapacity);
            storedResults.add(result);
            this.cacheMap.put(point, storedResults);
        } else {
            storedResults.add(result);
        }
    }

    public List<ModelRunResult> getResults(Chromosome point) {
        List<ModelRunResult> rlist = this.cacheMap.get(point);
        if (rlist != null) {
            return rlist;
        }
        return new ArrayList<ModelRunResult>(0);
    }

    public int getResultsCount(Chromosome point) {
        List<ModelRunResult> rlist = this.cacheMap.get(point);
        if (rlist != null) {
            return rlist.size();
        }
        return 0;
    }
}

