/*
 * Decompiled with CFR 0.152.
 */
package bsearch.app;

import bsearch.evaluation.ResultListener;
import bsearch.evaluation.SearchManager;
import bsearch.nlogolink.ModelRunResult;
import bsearch.representations.Chromosome;
import bsearch.space.SearchSpace;
import java.io.PrintStream;

public class ConsoleProgressListener
implements ResultListener {
    private String lastProgress;
    private int totalEvals;
    private PrintStream out;

    public ConsoleProgressListener(int totalEvals, PrintStream out) {
        this.totalEvals = totalEvals;
        this.out = out;
    }

    @Override
    public void modelRunOccurred(SearchManager manager, Chromosome point, ModelRunResult result) {
        String progress = String.format("Search %s: %.0f%%\n", manager.getSearchIDNumber(), (double)manager.getEvaluationCount() / (double)this.totalEvals * 100.0);
        if (!progress.equals(this.lastProgress)) {
            this.out.print(progress);
            this.lastProgress = progress;
        }
    }

    @Override
    public void fitnessComputed(SearchManager manager, Chromosome point, double fitness) {
    }

    @Override
    public void newBestFound(SearchManager manager) {
    }

    @Override
    public void searchStarting(SearchManager manager) {
        this.lastProgress = "N/A";
    }

    @Override
    public void searchFinished(SearchManager manager) {
    }

    @Override
    public void initListener(SearchSpace space) {
    }

    @Override
    public void allSearchesFinished() {
        this.out.printf("All searches completed.\n\n", new Object[0]);
    }

    @Override
    public void searchesAborted() {
        this.out.printf("Searches were aborted.\n\n", new Object[0]);
    }
}

