/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.audio;

import java.io.ByteArrayOutputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.TargetDataLine;
import org.openimaj.audio.AudioFormat;
import org.openimaj.audio.AudioGrabber;
import org.openimaj.audio.AudioGrabberListener;
import org.openimaj.audio.SampleChunk;

public class JavaSoundAudioGrabber
extends AudioGrabber {
    private final SampleChunk currentSample = new SampleChunk(this.getFormat());
    private TargetDataLine mLine = null;
    private boolean stopped = true;
    private int maxBufferSize = -1;

    public JavaSoundAudioGrabber(AudioFormat format) {
        this.setFormat(format);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.openJavaSound();
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            int numBytesRead = 0;
            byte[] data = new byte[this.calculateBufferSize()];
            this.mLine.start();
            this.stopped = false;
            while (!this.stopped) {
                numBytesRead = this.mLine.read(data, 0, data.length);
                out.write(data, 0, numBytesRead);
                SampleChunk sampleChunk = this.currentSample;
                synchronized (sampleChunk) {
                    this.currentSample.setSamples((byte[])data.clone());
                    this.currentSample.notify();
                }
                this.fireAudioAvailable();
            }
            this.closeJavaSound();
            System.out.println("Stopping java sound");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private int calculateBufferSize() {
        int nmax = this.maxBufferSize == -1 ? this.mLine.getBufferSize() / 4 : this.maxBufferSize;
        int[] FAC44100 = new int[]{7, 7, 5, 5, 3, 3, 2, 2};
        int nwad = 1;
        for (int i = 0; i < 8; ++i) {
            if (nwad * FAC44100[i] > nmax) continue;
            nwad *= FAC44100[i];
        }
        return nwad << this.getFormat().getNBits() / 8;
    }

    @Override
    public void stop() {
        this.stopped = true;
    }

    @Override
    public boolean isStopped() {
        return this.stopped;
    }

    @Override
    protected void fireAudioAvailable() {
        for (AudioGrabberListener l : this.listeners) {
            l.samplesAvailable(this.currentSample);
        }
    }

    @Override
    public void setFormat(AudioFormat format) {
        this.currentSample.setFormat(format);
        super.setFormat(format);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SampleChunk nextSampleChunk() {
        SampleChunk sampleChunk = this.currentSample;
        synchronized (sampleChunk) {
            if (this.isStopped()) {
                return null;
            }
            try {
                this.currentSample.wait();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            return this.currentSample;
        }
    }

    public void setMaxBufferSize(int maxBufferSize) {
        this.maxBufferSize = maxBufferSize;
    }

    private void openJavaSound() throws Exception {
        javax.sound.sampled.AudioFormat audioFormat = new javax.sound.sampled.AudioFormat((int)(this.getFormat().getSampleRateKHz() * 1000.0), this.getFormat().getNBits(), this.getFormat().getNumChannels(), this.getFormat().isSigned(), this.getFormat().isBigEndian());
        System.out.println("Creating Java Sound Line with " + this.getFormat());
        DataLine.Info info = new DataLine.Info(TargetDataLine.class, audioFormat);
        try {
            this.mLine = (TargetDataLine)AudioSystem.getLine(info);
            this.mLine.open(audioFormat);
        }
        catch (LineUnavailableException e) {
            throw new Exception("Could not open Java Sound audio line for the audio format " + this.getFormat());
        }
    }

    private void closeJavaSound() {
        if (this.mLine != null) {
            this.mLine.drain();
            this.mLine.close();
            this.mLine = null;
        }
    }

    @Override
    public long getLength() {
        return -1L;
    }
}

