/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.movtool.streaming.tracks;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.jcodec.common.AudioFormat;
import org.jcodec.containers.mp4.boxes.EndianBox;
import org.jcodec.containers.mp4.boxes.channel.Label;
import org.jcodec.movtool.streaming.AudioCodecMeta;
import org.jcodec.movtool.streaming.CodecMeta;
import org.jcodec.movtool.streaming.VirtualPacket;
import org.jcodec.movtool.streaming.VirtualTrack;
import org.jcodec.movtool.streaming.tracks.DownmixHelper;
import org.jcodec.movtool.streaming.tracks.PCMFlatternTrack;

public class StereoDownmixTrack
implements VirtualTrack {
    private static final int FRAMES_IN_OUT_PACKET = 20480;
    private VirtualTrack[] sources;
    private AudioCodecMeta[] sampleEntries;
    private int rate = -1;
    private int frameNo;
    private boolean[][] solo;
    private DownmixHelper downmix;

    public StereoDownmixTrack(VirtualTrack ... tracks) {
        this.sources = new VirtualTrack[tracks.length];
        this.sampleEntries = new AudioCodecMeta[this.sources.length];
        this.solo = new boolean[tracks.length][];
        for (int i = 0; i < tracks.length; ++i) {
            CodecMeta se = tracks[i].getCodecMeta();
            if (!(se instanceof AudioCodecMeta)) {
                throw new IllegalArgumentException("Non audio track");
            }
            AudioCodecMeta ase = (AudioCodecMeta)se;
            if (!ase.isPCM()) {
                throw new IllegalArgumentException("Non PCM audio track.");
            }
            AudioFormat format = ase.getFormat();
            if (this.rate != -1 && this.rate != format.getFrameRate()) {
                throw new IllegalArgumentException("Can not downmix tracks of different rate.");
            }
            this.rate = format.getFrameRate();
            this.sampleEntries[i] = ase;
            this.sources[i] = new PCMFlatternTrack(tracks[i], 20480);
            this.solo[i] = new boolean[format.getChannels()];
        }
        this.downmix = new DownmixHelper(this.sampleEntries, 20480, null);
    }

    public void soloTrack(int track, boolean s) {
        for (int ch = 0; ch < this.solo[track].length; ++ch) {
            this.solo[track][ch] = s;
        }
        this.downmix = new DownmixHelper(this.sampleEntries, 20480, this.solo);
    }

    public void soloChannel(int track, int channel, boolean s) {
        this.solo[track][channel] = s;
        this.downmix = new DownmixHelper(this.sampleEntries, 20480, this.solo);
    }

    public boolean isChannelMute(int track, int channel) {
        return this.solo[track][channel];
    }

    public boolean[][] bulkGetSolo() {
        return this.solo;
    }

    public void soloAll() {
        for (int i = 0; i < this.solo.length; ++i) {
            for (int j = 0; j < this.solo[i].length; ++j) {
                this.solo[i][j] = true;
            }
        }
    }

    public void muteAll() {
        for (int i = 0; i < this.solo.length; ++i) {
            for (int j = 0; j < this.solo[i].length; ++j) {
                this.solo[i][j] = false;
            }
        }
    }

    public void bulkSetSolo(boolean[][] solo) {
        this.solo = solo;
        this.downmix = new DownmixHelper(this.sampleEntries, 20480, solo);
    }

    @Override
    public VirtualPacket nextPacket() throws IOException {
        VirtualPacket[] packets = new VirtualPacket[this.sources.length];
        boolean allNull = true;
        for (int i = 0; i < packets.length; ++i) {
            packets[i] = this.sources[i].nextPacket();
            allNull &= packets[i] == null;
        }
        if (allNull) {
            return null;
        }
        DownmixVirtualPacket ret = new DownmixVirtualPacket(packets, this.frameNo);
        this.frameNo += 20480;
        return ret;
    }

    @Override
    public CodecMeta getCodecMeta() {
        return new AudioCodecMeta("sowt", 2, 2, this.rate, EndianBox.Endian.LITTLE_ENDIAN, true, new Label[]{Label.Left, Label.Right}, null);
    }

    @Override
    public void close() throws IOException {
        for (VirtualTrack virtualTrack : this.sources) {
            virtualTrack.close();
        }
    }

    @Override
    public VirtualTrack.VirtualEdit[] getEdits() {
        return null;
    }

    @Override
    public int getPreferredTimescale() {
        return this.rate;
    }

    protected class DownmixVirtualPacket
    implements VirtualPacket {
        private VirtualPacket[] packets;
        private int frameNo;

        public DownmixVirtualPacket(VirtualPacket[] packets, int pktNo) {
            this.packets = packets;
            this.frameNo = pktNo;
        }

        @Override
        public ByteBuffer getData() throws IOException {
            ByteBuffer[] data = new ByteBuffer[this.packets.length];
            for (int i = 0; i < data.length; ++i) {
                data[i] = this.packets[i] == null ? null : this.packets[i].getData();
            }
            ByteBuffer out = ByteBuffer.allocate(81920);
            StereoDownmixTrack.this.downmix.downmix(data, out);
            return out;
        }

        @Override
        public int getDataLen() {
            return 81920;
        }

        @Override
        public double getPts() {
            return (double)this.frameNo / (double)StereoDownmixTrack.this.rate;
        }

        @Override
        public double getDuration() {
            return 20480.0 / (double)StereoDownmixTrack.this.rate;
        }

        @Override
        public boolean isKeyframe() {
            return true;
        }

        @Override
        public int getFrameNo() {
            return this.frameNo;
        }
    }
}

