/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.movtool.streaming.tracks;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jcodec.movtool.streaming.CodecMeta;
import org.jcodec.movtool.streaming.VirtualPacket;
import org.jcodec.movtool.streaming.VirtualTrack;
import org.jcodec.movtool.streaming.tracks.VirtualPacketWrapper;

public class EditedFramesTrack
implements VirtualTrack {
    private VirtualTrack src;
    private List<VirtualPacket>[] buckets;
    private VirtualTrack.VirtualEdit[] edits;
    private int curEdit;
    private int curPkt;
    private int frameNo;
    private double pts;

    public EditedFramesTrack(VirtualTrack src) throws IOException {
        VirtualPacket pkt;
        this.src = src;
        this.edits = src.getEdits();
        this.buckets = new List[this.edits.length];
        for (int i = 0; i < this.edits.length; ++i) {
            this.buckets[i] = new ArrayList<VirtualPacket>();
        }
        while ((pkt = src.nextPacket()) != null) {
            if (!pkt.isKeyframe()) {
                throw new IllegalArgumentException("Can not apply edits to a track that has inter frames, this will result in decoding errors.");
            }
            for (int e = 0; e < this.edits.length; ++e) {
                VirtualTrack.VirtualEdit ed = this.edits[e];
                if (!(pkt.getPts() < ed.getIn() + ed.getDuration()) || !(pkt.getPts() + pkt.getDuration() > ed.getIn())) continue;
                this.buckets[e].add(pkt);
            }
        }
    }

    @Override
    public VirtualPacket nextPacket() throws IOException {
        if (this.curEdit >= this.edits.length) {
            return null;
        }
        VirtualPacket pkt = this.buckets[this.curEdit].get(this.curPkt);
        VirtualTrack.VirtualEdit edt = this.edits[this.curEdit];
        double duration = pkt.getDuration();
        double sticksFront = edt.getIn() - pkt.getPts();
        double sticksBack = pkt.getPts() + pkt.getDuration() - (edt.getIn() + edt.getDuration());
        EditedFramesPacket ret = new EditedFramesPacket(pkt, this.pts, duration -= Math.max(sticksFront, 0.0) + Math.max(sticksBack, 0.0), this.frameNo);
        ++this.curPkt;
        if (this.curPkt >= this.buckets[this.curEdit].size()) {
            ++this.curEdit;
            this.curPkt = 0;
        }
        ++this.frameNo;
        this.pts += duration;
        return ret;
    }

    @Override
    public CodecMeta getCodecMeta() {
        return this.src.getCodecMeta();
    }

    @Override
    public VirtualTrack.VirtualEdit[] getEdits() {
        return null;
    }

    @Override
    public void close() throws IOException {
        this.src.close();
    }

    @Override
    public int getPreferredTimescale() {
        return this.src.getPreferredTimescale();
    }

    public static class EditedFramesPacket
    extends VirtualPacketWrapper {
        private double pts;
        private double duration;
        private int frameNo;

        public EditedFramesPacket(VirtualPacket src, double pts, double duration, int frameNo) {
            super(src);
            this.pts = pts;
            this.duration = duration;
            this.frameNo = frameNo;
        }

        @Override
        public double getPts() {
            return this.pts;
        }

        @Override
        public double getDuration() {
            return this.duration;
        }

        @Override
        public boolean isKeyframe() {
            return true;
        }

        @Override
        public int getFrameNo() {
            return this.frameNo;
        }
    }
}

