/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.movtool.streaming;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Comparator;

public interface VirtualPacket {
    public static final Comparator<? super VirtualPacket> byPts = new Comparator<VirtualPacket>(){

        @Override
        public int compare(VirtualPacket o1, VirtualPacket o2) {
            if (o1 == null && o2 == null) {
                return 0;
            }
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            return o1.getPts() < o2.getPts() ? -1 : (o1.getPts() == o2.getPts() ? 0 : 1);
        }
    };

    public ByteBuffer getData() throws IOException;

    public int getDataLen() throws IOException;

    public double getPts();

    public double getDuration();

    public boolean isKeyframe();

    public int getFrameNo();
}

