/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.containers.mxf;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import org.jcodec.common.DemuxerTrackMeta;
import org.jcodec.common.NIOUtils;
import org.jcodec.common.SeekableByteChannel;
import org.jcodec.common.SeekableDemuxerTrack;
import org.jcodec.common.logging.Logger;
import org.jcodec.common.model.Packet;
import org.jcodec.common.model.Size;
import org.jcodec.common.model.TapeTimecode;
import org.jcodec.containers.mxf.MXFConst;
import org.jcodec.containers.mxf.model.FileDescriptor;
import org.jcodec.containers.mxf.model.GenericDescriptor;
import org.jcodec.containers.mxf.model.GenericPictureEssenceDescriptor;
import org.jcodec.containers.mxf.model.GenericSoundEssenceDescriptor;
import org.jcodec.containers.mxf.model.IndexSegment;
import org.jcodec.containers.mxf.model.KLV;
import org.jcodec.containers.mxf.model.MXFMetadata;
import org.jcodec.containers.mxf.model.MXFPartition;
import org.jcodec.containers.mxf.model.MXFUtil;
import org.jcodec.containers.mxf.model.TimecodeComponent;
import org.jcodec.containers.mxf.model.TimelineTrack;
import org.jcodec.containers.mxf.model.UL;
import org.jcodec.containers.mxf.model.WaveAudioDescriptor;

public class MXFDemuxer {
    protected List<MXFMetadata> metadata;
    protected MXFPartition header;
    protected List<MXFPartition> partitions;
    protected List<IndexSegment> indexSegments;
    protected SeekableByteChannel ch;
    protected MXFDemuxerTrack[] tracks;
    protected int totalFrames;
    protected double duration;
    protected TimecodeComponent timecode;

    public MXFDemuxer(SeekableByteChannel ch) throws IOException {
        this.ch = ch;
        ch.position(0L);
        this.parseHeader(ch);
        this.findIndex();
        this.tracks = this.findTracks();
        this.timecode = MXFUtil.findMeta(this.metadata, TimecodeComponent.class);
    }

    public OP getOp() {
        UL op = this.header.getPack().getOp();
        EnumSet<OP> allOf = EnumSet.allOf(OP.class);
        for (OP op2 : allOf) {
            if (op.get(12) != op2.major || op.get(13) != op2.minor) continue;
            return op2;
        }
        return OP.OPAtom;
    }

    private MXFDemuxerTrack[] findTracks() throws IOException {
        ArrayList<MXFDemuxerTrack> rt = new ArrayList<MXFDemuxerTrack>();
        List<TimelineTrack> tracks = MXFUtil.findAllMeta(this.metadata, TimelineTrack.class);
        List<FileDescriptor> descriptors = MXFUtil.findAllMeta(this.metadata, FileDescriptor.class);
        for (TimelineTrack track : tracks) {
            if (track.getTrackNumber() == 0) continue;
            int trackNumber = track.getTrackNumber();
            FileDescriptor descriptor = MXFDemuxer.findDescriptor(descriptors, track.getTrackId());
            if (descriptor == null) {
                Logger.warn("No generic descriptor for track: " + track.getTrackId());
                if (descriptors.size() == 1 && descriptors.get(0).getLinkedTrackId() == 0) {
                    descriptor = descriptors.get(0);
                }
            }
            if (descriptor == null) {
                Logger.warn("Track without descriptor: " + track.getTrackId());
                continue;
            }
            MXFDemuxerTrack dt = this.createTrack(new UL(6, 14, 43, 52, 1, 2, 1, 1, 13, 1, 3, 1, trackNumber >>> 24 & 0xFF, trackNumber >>> 16 & 0xFF, trackNumber >>> 8 & 0xFF, trackNumber & 0xFF), track, descriptor);
            if (dt.getCodec() == null && !(descriptor instanceof WaveAudioDescriptor)) continue;
            rt.add(dt);
        }
        return rt.toArray(new MXFDemuxerTrack[0]);
    }

    public static FileDescriptor findDescriptor(List<FileDescriptor> descriptors, int trackId) {
        for (FileDescriptor descriptor : descriptors) {
            if (descriptor.getLinkedTrackId() != trackId) continue;
            return descriptor;
        }
        return null;
    }

    protected MXFDemuxerTrack createTrack(UL ul, TimelineTrack track, GenericDescriptor descriptor) throws IOException {
        return new MXFDemuxerTrack(ul, track, descriptor);
    }

    public List<IndexSegment> getIndexes() {
        return this.indexSegments;
    }

    public List<MXFPartition> getEssencePartitions() {
        return this.partitions;
    }

    public TimecodeComponent getTimecode() {
        return this.timecode;
    }

    public void parseHeader(SeekableByteChannel ff) throws IOException {
        this.header = MXFDemuxer.readHeaderPartition(ff);
        this.metadata = new ArrayList<MXFMetadata>();
        this.partitions = new ArrayList<MXFPartition>();
        long nextPartition = ff.size();
        ff.position(this.header.getPack().getFooterPartition());
        do {
            long thisPartition = ff.position();
            KLV kl = KLV.readKL(ff);
            ByteBuffer fetchFrom = NIOUtils.fetchFrom(ff, (int)kl.len);
            this.header = MXFPartition.read(kl.key, fetchFrom, ff.position() - kl.offset, nextPartition);
            if (this.header.getPack().getNbEssenceContainers() > 0) {
                this.partitions.add(0, this.header);
            }
            this.metadata.addAll(0, MXFDemuxer.readPartitionMeta(ff, this.header));
            ff.position(this.header.getPack().getPrevPartition());
            nextPartition = thisPartition;
        } while (this.header.getPack().getThisPartition() != 0L);
    }

    public static List<MXFMetadata> readPartitionMeta(SeekableByteChannel ff, MXFPartition header) throws IOException {
        KLV kl;
        long basePos = ff.position();
        ArrayList<MXFMetadata> local = new ArrayList<MXFMetadata>();
        ByteBuffer metaBuffer = NIOUtils.fetchFrom(ff, (int)Math.max(0L, header.getEssenceFilePos() - basePos));
        while (metaBuffer.hasRemaining() && (kl = KLV.readKL(metaBuffer, basePos)) != null) {
            MXFMetadata meta = MXFDemuxer.parseMeta(kl.key, NIOUtils.read(metaBuffer, (int)kl.len));
            if (meta == null) continue;
            local.add(meta);
        }
        return local;
    }

    public static MXFPartition readHeaderPartition(SeekableByteChannel ff) throws IOException {
        KLV kl;
        MXFPartition header = null;
        while ((kl = KLV.readKL(ff)) != null) {
            if (MXFConst.HEADER_PARTITION_KLV.equals(kl.key)) {
                ByteBuffer data = NIOUtils.fetchFrom(ff, (int)kl.len);
                header = MXFPartition.read(kl.key, data, ff.position() - kl.offset, 0L);
                break;
            }
            ff.position(ff.position() + kl.len);
        }
        return header;
    }

    private static MXFMetadata parseMeta(UL ul, ByteBuffer _bb) {
        Class<? extends MXFMetadata> class1 = MXFConst.klMetadataMapping.get(ul);
        if (class1 == null) {
            Logger.warn("Unknown metadata piece: " + ul);
            return null;
        }
        try {
            MXFMetadata meta = class1.getConstructor(UL.class).newInstance(ul);
            meta.read(_bb);
            return meta;
        }
        catch (Exception exception) {
            Logger.warn("Unknown metadata piece: " + ul);
            return null;
        }
    }

    private void findIndex() {
        this.indexSegments = new ArrayList<IndexSegment>();
        for (MXFMetadata meta : this.metadata) {
            if (!(meta instanceof IndexSegment)) continue;
            IndexSegment is = (IndexSegment)meta;
            this.indexSegments.add(is);
            this.totalFrames = (int)((long)this.totalFrames + is.getIndexDuration());
            this.duration += (double)is.getIndexEditRateDen() * (double)is.getIndexDuration() / (double)is.getIndexEditRateNum();
        }
    }

    public MXFDemuxerTrack[] getTracks() {
        return this.tracks;
    }

    public MXFDemuxerTrack getVideoTrack() {
        for (MXFDemuxerTrack track : this.tracks) {
            if (!track.isVideo()) continue;
            return track;
        }
        return null;
    }

    public MXFDemuxerTrack[] getAudioTracks() {
        ArrayList<MXFDemuxerTrack> audio = new ArrayList<MXFDemuxerTrack>();
        for (MXFDemuxerTrack track : this.tracks) {
            if (!track.isAudio()) continue;
            audio.add(track);
        }
        return audio.toArray(new MXFDemuxerTrack[0]);
    }

    public static class Fast
    extends MXFDemuxer {
        public Fast(SeekableByteChannel ch) throws IOException {
            super(ch);
        }

        @Override
        public void parseHeader(SeekableByteChannel ff) throws IOException {
            this.partitions = new ArrayList();
            this.metadata = new ArrayList();
            this.header = Fast.readHeaderPartition(ff);
            this.metadata.addAll(Fast.readPartitionMeta(ff, this.header));
            this.partitions.add(this.header);
            ff.position(this.header.getPack().getFooterPartition());
            KLV kl = KLV.readKL(ff);
            ByteBuffer fetchFrom = NIOUtils.fetchFrom(ff, (int)kl.len);
            MXFPartition footer = MXFPartition.read(kl.key, fetchFrom, ff.position() - kl.offset, ff.size());
            this.metadata.addAll(Fast.readPartitionMeta(ff, footer));
        }
    }

    public static class MXFPacket
    extends Packet {
        private long offset;
        private int len;

        public MXFPacket(ByteBuffer data, long pts, long timescale, long duration, long frameNo, boolean keyFrame, TapeTimecode tapeTimecode, long offset, int len) {
            super(data, pts, timescale, duration, frameNo, keyFrame, tapeTimecode);
            this.offset = offset;
            this.len = len;
        }

        public long getOffset() {
            return this.offset;
        }

        public int getLen() {
            return this.len;
        }
    }

    public class MXFDemuxerTrack
    implements SeekableDemuxerTrack {
        private UL essenceUL;
        private int dataLen;
        private int indexSegmentIdx;
        private int indexSegmentSubIdx;
        private int frameNo;
        private long pts;
        private int partIdx;
        private long partEssenceOffset;
        private GenericDescriptor descriptor;
        private TimelineTrack track;
        private boolean video;
        private boolean audio;
        private MXFConst.MXFCodecMapping codec;
        private int audioFrameDuration;
        private int audioTimescale;

        public MXFDemuxerTrack(UL essenceUL, TimelineTrack track, GenericDescriptor descriptor) throws IOException {
            this.essenceUL = essenceUL;
            this.track = track;
            this.descriptor = descriptor;
            if (descriptor instanceof GenericPictureEssenceDescriptor) {
                this.video = true;
            } else if (descriptor instanceof GenericSoundEssenceDescriptor) {
                this.audio = true;
            }
            this.codec = this.resolveCodec();
            if (this.codec != null || descriptor instanceof WaveAudioDescriptor) {
                Logger.warn("Track type: " + this.video + ", " + this.audio);
                if (this.audio && descriptor instanceof WaveAudioDescriptor) {
                    WaveAudioDescriptor wave = (WaveAudioDescriptor)descriptor;
                    this.cacheAudioFrameSizes(MXFDemuxer.this.ch);
                    this.audioFrameDuration = this.dataLen / ((wave.getQuantizationBits() >> 3) * wave.getChannelCount());
                    this.audioTimescale = (int)wave.getAudioSamplingRate().scalar();
                }
            }
        }

        public boolean isAudio() {
            return this.audio;
        }

        public boolean isVideo() {
            return this.video;
        }

        public double getDuration() {
            return MXFDemuxer.this.duration;
        }

        public int getNumFrames() {
            return MXFDemuxer.this.totalFrames;
        }

        public String getName() {
            return this.track.getName();
        }

        private void cacheAudioFrameSizes(SeekableByteChannel ch) throws IOException {
            for (MXFPartition mxfPartition : MXFDemuxer.this.partitions) {
                KLV kl;
                if (mxfPartition.getEssenceLength() <= 0L) continue;
                ch.position(mxfPartition.getEssenceFilePos());
                while ((kl = KLV.readKL(ch)) != null) {
                    ch.position(ch.position() + kl.len);
                    if (!this.essenceUL.equals(kl.key)) continue;
                }
                if (!this.essenceUL.equals(kl.key)) continue;
                this.dataLen = (int)kl.len;
                break;
            }
        }

        @Override
        public Packet nextFrame() throws IOException {
            MXFPacket result;
            boolean kf;
            if (this.indexSegmentIdx >= MXFDemuxer.this.indexSegments.size()) {
                return null;
            }
            IndexSegment seg = MXFDemuxer.this.indexSegments.get(this.indexSegmentIdx);
            long[] off = seg.getIe().getFileOff();
            int erDen = seg.getIndexEditRateNum();
            int erNum = seg.getIndexEditRateDen();
            long frameEssenceOffset = off[this.indexSegmentSubIdx];
            byte toff = seg.getIe().getDisplayOff()[this.indexSegmentSubIdx];
            boolean bl = kf = seg.getIe().getKeyFrameOff()[this.indexSegmentSubIdx] == 0;
            while (frameEssenceOffset >= this.partEssenceOffset + MXFDemuxer.this.partitions.get(this.partIdx).getEssenceLength() && this.partIdx < MXFDemuxer.this.partitions.size() - 1) {
                this.partEssenceOffset += MXFDemuxer.this.partitions.get(this.partIdx).getEssenceLength();
                ++this.partIdx;
            }
            long frameFileOffset = frameEssenceOffset - this.partEssenceOffset + MXFDemuxer.this.partitions.get(this.partIdx).getEssenceFilePos();
            if (!this.audio) {
                result = this.readPacket(frameFileOffset, this.dataLen, this.pts + (long)(erNum * toff), erDen, erNum, this.frameNo++, kf);
                this.pts += (long)erNum;
            } else {
                result = this.readPacket(frameFileOffset, this.dataLen, this.pts, this.audioTimescale, this.audioFrameDuration, this.frameNo++, kf);
                this.pts += (long)this.audioFrameDuration;
            }
            ++this.indexSegmentSubIdx;
            if (this.indexSegmentSubIdx >= off.length) {
                ++this.indexSegmentIdx;
                this.indexSegmentSubIdx = 0;
                if (this.dataLen == 0 && this.indexSegmentIdx < MXFDemuxer.this.indexSegments.size()) {
                    IndexSegment nseg = MXFDemuxer.this.indexSegments.get(this.indexSegmentIdx);
                    this.pts = this.pts * (long)nseg.getIndexEditRateNum() / (long)erDen;
                }
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public MXFPacket readPacket(long off, int len, long pts, int timescale, int duration, int frameNo, boolean kf) throws IOException {
            SeekableByteChannel seekableByteChannel = MXFDemuxer.this.ch;
            synchronized (seekableByteChannel) {
                MXFDemuxer.this.ch.position(off);
                KLV kl = KLV.readKL(MXFDemuxer.this.ch);
                while (kl != null && !this.essenceUL.equals(kl.key)) {
                    MXFDemuxer.this.ch.position(MXFDemuxer.this.ch.position() + kl.len);
                    kl = KLV.readKL(MXFDemuxer.this.ch);
                }
                return kl != null && this.essenceUL.equals(kl.key) ? new MXFPacket(NIOUtils.fetchFrom(MXFDemuxer.this.ch, (int)kl.len), pts, timescale, duration, frameNo, kf, null, off, len) : null;
            }
        }

        @Override
        public boolean gotoFrame(long frameNo) {
            if (frameNo == (long)this.frameNo) {
                return true;
            }
            this.indexSegmentSubIdx = (int)frameNo;
            this.indexSegmentIdx = 0;
            while (this.indexSegmentIdx < MXFDemuxer.this.indexSegments.size() && (long)this.indexSegmentSubIdx >= MXFDemuxer.this.indexSegments.get(this.indexSegmentIdx).getIndexDuration()) {
                this.indexSegmentSubIdx = (int)((long)this.indexSegmentSubIdx - MXFDemuxer.this.indexSegments.get(this.indexSegmentIdx).getIndexDuration());
                ++this.indexSegmentIdx;
            }
            this.indexSegmentSubIdx = Math.min(this.indexSegmentSubIdx, (int)MXFDemuxer.this.indexSegments.get(this.indexSegmentIdx).getIndexDuration());
            return true;
        }

        @Override
        public boolean gotoSyncFrame(long frameNo) {
            if (!this.gotoFrame(frameNo)) {
                return false;
            }
            IndexSegment seg = MXFDemuxer.this.indexSegments.get(this.indexSegmentIdx);
            byte kfOff = seg.getIe().getKeyFrameOff()[this.indexSegmentSubIdx];
            return this.gotoFrame(frameNo + (long)kfOff);
        }

        @Override
        public long getCurFrame() {
            return this.frameNo;
        }

        @Override
        public void seek(double second) {
            throw new UnsupportedOperationException();
        }

        public UL getEssenceUL() {
            return this.essenceUL;
        }

        public GenericDescriptor getDescriptor() {
            return this.descriptor;
        }

        public MXFConst.MXFCodecMapping getCodec() {
            return this.codec;
        }

        private MXFConst.MXFCodecMapping resolveCodec() {
            UL codecUL;
            if (this.video) {
                codecUL = ((GenericPictureEssenceDescriptor)this.descriptor).getPictureEssenceCoding();
            } else if (this.audio) {
                codecUL = ((GenericSoundEssenceDescriptor)this.descriptor).getSoundEssenceCompression();
            } else {
                return null;
            }
            for (MXFConst.MXFCodecMapping codec : EnumSet.allOf(MXFConst.MXFCodecMapping.class)) {
                if (!codec.getUl().equals(codecUL, 65407)) continue;
                return codec;
            }
            Logger.warn("Unknown codec: " + codecUL);
            return null;
        }

        public int getTrackId() {
            return this.track.getTrackId();
        }

        @Override
        public DemuxerTrackMeta getMeta() {
            Size size = null;
            if (this.video) {
                GenericPictureEssenceDescriptor pd = (GenericPictureEssenceDescriptor)this.descriptor;
                size = new Size(pd.getStoredWidth(), pd.getStoredHeight());
            }
            return new DemuxerTrackMeta(this.video ? DemuxerTrackMeta.Type.VIDEO : (this.audio ? DemuxerTrackMeta.Type.AUDIO : DemuxerTrackMeta.Type.OTHER), null, MXFDemuxer.this.totalFrames, MXFDemuxer.this.duration, size);
        }
    }

    public static enum OP {
        OP1a(1, 1),
        OP1b(1, 2),
        OP1c(1, 3),
        OP2a(2, 1),
        OP2b(2, 2),
        OP2c(2, 3),
        OP3a(3, 1),
        OP3b(3, 2),
        OP3c(3, 3),
        OPAtom(16, 0);

        public int major;
        public int minor;

        private OP(int major, int minor) {
            this.major = major;
            this.minor = minor;
        }
    }
}

