/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.common.logging;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.jcodec.common.logging.OutLogSink;

public class Logger {
    private static List<LogSink> stageSinks = new LinkedList<LogSink>();
    private static List<LogSink> sinks;

    public static void debug(String message) {
        Logger.message(Level.DEBUG, message);
    }

    public static void info(String message) {
        Logger.message(Level.INFO, message);
    }

    public static void warn(String message) {
        Logger.message(Level.WARN, message);
    }

    public static void error(String message) {
        Logger.message(Level.ERROR, message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private static void message(Level level, String message) {
        if (sinks == null) {
            Class<Logger> clazz = Logger.class;
            // MONITORENTER : org.jcodec.common.logging.Logger.class
            if (sinks == null) {
                sinks = stageSinks;
                stageSinks = null;
                if (sinks.isEmpty()) {
                    sinks.add(new OutLogSink());
                }
            }
            // MONITOREXIT : clazz
        }
        StackTraceElement tr = Thread.currentThread().getStackTrace()[3];
        Message msg = new Message(level, tr.getFileName(), tr.getClassName(), tr.getMethodName(), tr.getLineNumber(), message);
        Iterator<LogSink> i$ = sinks.iterator();
        while (i$.hasNext()) {
            LogSink logSink = i$.next();
            logSink.postMessage(msg);
        }
    }

    public static void addSink(LogSink sink) {
        if (stageSinks == null) {
            throw new IllegalStateException("Logger already started");
        }
        stageSinks.add(sink);
    }

    public static interface LogSink {
        public void postMessage(Message var1);
    }

    public static class Message {
        private Level level;
        private String fileName;
        private String className;
        private int lineNumber;
        private String message;
        private String methodName;

        public Message(Level level, String fileName, String className, String methodName, int lineNumber, String message) {
            this.level = level;
            this.fileName = fileName;
            this.className = className;
            this.methodName = methodName;
            this.message = methodName;
            this.lineNumber = lineNumber;
            this.message = message;
        }

        public Level getLevel() {
            return this.level;
        }

        public String getFileName() {
            return this.fileName;
        }

        public String getClassName() {
            return this.className;
        }

        public String getMethodName() {
            return this.methodName;
        }

        public int getLineNumber() {
            return this.lineNumber;
        }

        public String getMessage() {
            return this.message;
        }
    }

    public static enum Level {
        DEBUG,
        INFO,
        WARN,
        ERROR;

    }
}

