/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.common;

import java.util.Arrays;

public class ByteArrayList {
    private static final int DEFAULT_GROW_AMOUNT = 2048;
    private byte[] storage;
    private int size;
    private int growAmount;

    public ByteArrayList() {
        this(2048);
    }

    public ByteArrayList(int growAmount) {
        this.growAmount = growAmount;
        this.storage = new byte[growAmount];
    }

    public byte[] toArray() {
        byte[] result = new byte[this.size];
        System.arraycopy(this.storage, 0, result, 0, this.size);
        return result;
    }

    public void add(byte val) {
        if (this.size >= this.storage.length) {
            byte[] ns = new byte[this.storage.length + this.growAmount];
            System.arraycopy(this.storage, 0, ns, 0, this.storage.length);
            this.storage = ns;
        }
        this.storage[this.size++] = val;
    }

    public void push(byte id) {
        this.add(id);
    }

    public void pop() {
        if (this.size == 0) {
            return;
        }
        --this.size;
    }

    public void set(int index, byte value) {
        this.storage[index] = value;
    }

    public byte get(int index) {
        return this.storage[index];
    }

    public void fill(int start, int end, byte val) {
        if (end > this.storage.length) {
            byte[] ns = new byte[end + this.growAmount];
            System.arraycopy(this.storage, 0, ns, 0, this.storage.length);
            this.storage = ns;
        }
        Arrays.fill(this.storage, start, end, val);
        this.size = Math.max(this.size, end);
    }

    public int size() {
        return this.size;
    }

    public void addAll(byte[] other) {
        if (this.size + other.length >= this.storage.length) {
            byte[] ns = new byte[this.size + this.growAmount + other.length];
            System.arraycopy(this.storage, 0, ns, 0, this.size);
            this.storage = ns;
        }
        System.arraycopy(other, 0, this.storage, this.size, other.length);
        this.size += other.length;
    }

    public boolean contains(byte needle) {
        for (int i = 0; i < this.size; ++i) {
            if (this.storage[i] != needle) continue;
            return true;
        }
        return false;
    }
}

