/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.api.specific;

import org.jcodec.api.FrameGrab;
import org.jcodec.api.specific.ContainerAdaptor;
import org.jcodec.codecs.h264.H264Decoder;
import org.jcodec.codecs.h264.H264Utils;
import org.jcodec.codecs.h264.io.model.Frame;
import org.jcodec.codecs.h264.io.model.SeqParameterSet;
import org.jcodec.codecs.h264.mp4.AvcCBox;
import org.jcodec.common.model.ColorSpace;
import org.jcodec.common.model.Packet;
import org.jcodec.common.model.Picture;
import org.jcodec.common.model.Size;
import org.jcodec.containers.mp4.MP4Packet;
import org.jcodec.containers.mp4.boxes.Box;
import org.jcodec.containers.mp4.boxes.NodeBox;
import org.jcodec.containers.mp4.boxes.PixelAspectExt;
import org.jcodec.containers.mp4.boxes.SampleEntry;
import org.jcodec.containers.mp4.boxes.VideoSampleEntry;
import org.jcodec.containers.mp4.demuxer.AbstractMP4DemuxerTrack;

public class AVCMP4Adaptor
implements ContainerAdaptor {
    private H264Decoder decoder;
    private SampleEntry[] ses;
    private AvcCBox avcCBox;
    private int curENo;
    private Size size;

    public AVCMP4Adaptor(SampleEntry[] ses) {
        this.ses = ses;
        this.curENo = -1;
        this.calcBufferSize();
    }

    private void calcBufferSize() {
        int w = Integer.MIN_VALUE;
        int h = Integer.MIN_VALUE;
        for (SampleEntry se : this.ses) {
            if (!"avc1".equals(se.getFourcc())) continue;
            AvcCBox avcC = H264Utils.parseAVCC((VideoSampleEntry)se);
            for (SeqParameterSet sps : H264Utils.readSPS(avcC.getSpsList())) {
                int hh;
                int ww = sps.pic_width_in_mbs_minus1 + 1;
                if (ww > w) {
                    w = ww;
                }
                if ((hh = H264Utils.getPicHeightInMbs(sps)) <= h) continue;
                h = hh;
            }
        }
        this.size = new Size(w << 4, h << 4);
    }

    public AVCMP4Adaptor(AbstractMP4DemuxerTrack vt) {
        this(vt.getSampleEntries());
    }

    @Override
    public Picture decodeFrame(Packet packet, int[][] data) {
        this.updateState(packet);
        Frame pic = this.decoder.decodeFrame(H264Utils.splitMOVPacket(packet.getData(), this.avcCBox), data);
        PixelAspectExt pasp = Box.findFirst((NodeBox)this.ses[this.curENo], PixelAspectExt.class, "pasp");
        if (pasp != null) {
            // empty if block
        }
        return pic;
    }

    private void updateState(Packet packet) {
        int eNo = ((MP4Packet)packet).getEntryNo();
        if (eNo != this.curENo) {
            this.curENo = eNo;
            this.avcCBox = H264Utils.parseAVCC((VideoSampleEntry)this.ses[this.curENo]);
            this.decoder = new H264Decoder();
            this.decoder.addSps(this.avcCBox.getSpsList());
            this.decoder.addPps(this.avcCBox.getPpsList());
        }
    }

    @Override
    public boolean canSeek(Packet pkt) {
        this.updateState(pkt);
        return H264Utils.idrSlice(H264Utils.splitMOVPacket(pkt.getData(), this.avcCBox));
    }

    @Override
    public int[][] allocatePicture() {
        return Picture.create(this.size.getWidth(), this.size.getHeight(), ColorSpace.YUV444).getData();
    }

    @Override
    public FrameGrab.MediaInfo getMediaInfo() {
        return new FrameGrab.MediaInfo(this.size);
    }
}

