/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.video;

import org.openimaj.image.Image;
import org.openimaj.video.Video;

public class ArrayBackedVideo<T extends Image<?, T>>
extends Video<T> {
    private T[] frames;
    private boolean loop;
    private double fps = 30.0;

    protected ArrayBackedVideo() {
    }

    public ArrayBackedVideo(T[] frames) {
        this.frames = frames;
        this.currentFrame = 0;
        this.fps = 30.0;
        this.loop = true;
    }

    public ArrayBackedVideo(T[] frames, double fps) {
        this.frames = frames;
        this.currentFrame = 0;
        this.fps = fps;
        this.loop = true;
    }

    public ArrayBackedVideo(T[] frames, double fps, boolean loop) {
        this.frames = frames;
        this.currentFrame = 0;
        this.fps = fps;
        this.loop = loop;
    }

    @Override
    public synchronized T getNextFrame() {
        T frame = this.frames[this.currentFrame % this.frames.length];
        this.incrementFrame();
        return frame;
    }

    @Override
    public synchronized T getCurrentFrame() {
        return this.frames[this.currentFrame % this.frames.length];
    }

    private void incrementFrame() {
        if (this.currentFrame + 1 < this.frames.length || this.loop) {
            ++this.currentFrame;
        }
    }

    @Override
    public synchronized void setCurrentFrameIndex(long newFrame) {
        this.currentFrame = !this.loop && newFrame >= (long)(this.frames.length - 1) ? this.frames.length - 1 : (int)newFrame;
    }

    @Override
    public synchronized boolean hasNextFrame() {
        return this.loop || this.currentFrame < this.frames.length;
    }

    @Override
    public int getWidth() {
        return this.getCurrentFrame().getWidth();
    }

    @Override
    public int getHeight() {
        return this.getCurrentFrame().getHeight();
    }

    @Override
    public long countFrames() {
        return this.frames.length;
    }

    @Override
    public void reset() {
        this.currentFrame = 0;
    }

    @Override
    public long getTimeStamp() {
        return (long)((double)(1000 * this.getCurrentFrameIndex()) / this.fps);
    }

    @Override
    public double getFPS() {
        return this.fps;
    }
}

