/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.mc;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URI;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import org.nlogo.mc.ModelingCommons;
import org.nlogo.swing.BrowserLauncher;

public strictfp class UploadSuccessDialog
extends JDialog {
    private JPanel topLevelContainer;
    private JButton OKButton;
    private JButton openModelButton;
    private JLabel successLabel;
    private JLabel errorLabel;
    private ModelingCommons communicator;
    private String uploadedModelName;
    private String uploadedModelURL;
    private Frame frame;

    public UploadSuccessDialog(Frame frame, ModelingCommons communicator, String errorLabelText, String uploadedModelURL, String uploadedModelName) {
        super(frame, "Upload To Modeling Commons Successful", true);
        this.frame = frame;
        this.communicator = communicator;
        this.uploadedModelURL = uploadedModelURL;
        this.uploadedModelName = uploadedModelName;
        this.initializeGUIComponents();
        this.successLabel.setText(String.format("Model '%s' created successfully", uploadedModelName));
        this.errorLabel.setText(errorLabelText);
        this.getRootPane().setDefaultButton(this.OKButton);
        this.openModelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UploadSuccessDialog.this.onOpenModel();
            }
        });
        this.OKButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UploadSuccessDialog.this.onClose();
            }
        });
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                UploadSuccessDialog.this.onClose();
            }
        });
        this.topLevelContainer.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UploadSuccessDialog.this.onClose();
            }
        }, KeyStroke.getKeyStroke(27, 0), 1);
        this.setModal(true);
        this.pack();
        this.setLocationRelativeTo(frame);
        this.setResizable(true);
    }

    private void onOpenModel() {
        URI uri = BrowserLauncher.makeURI(this.frame, this.uploadedModelURL);
        BrowserLauncher.openURI(this.frame, uri);
        this.dispose();
    }

    private void onClose() {
        this.dispose();
    }

    private void setMaxHeightToPreferredHeight(JComponent component) {
        component.setMaximumSize(new Dimension((int)component.getMaximumSize().getWidth(), (int)component.getPreferredSize().getHeight()));
    }

    private void initializeGUIComponents() {
        this.topLevelContainer = new JPanel();
        this.topLevelContainer.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.topLevelContainer.setLayout(new BoxLayout(this.topLevelContainer, 1));
        this.setContentPane(this.topLevelContainer);
        JPanel successPanel = new JPanel(new FlowLayout(3));
        JPanel errorPanel = new JPanel(new FlowLayout(3));
        JPanel buttonsPanel = new JPanel();
        buttonsPanel.setLayout(new BoxLayout(buttonsPanel, 0));
        this.topLevelContainer.add(successPanel);
        this.topLevelContainer.add(errorPanel);
        this.topLevelContainer.add(new Box.Filler(new Dimension(0, 0), new Dimension(400, 80), new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE)));
        this.topLevelContainer.add(buttonsPanel);
        this.successLabel = new JLabel();
        successPanel.add(this.successLabel);
        this.setMaxHeightToPreferredHeight(successPanel);
        this.errorLabel = new JLabel();
        this.errorLabel.setForeground(Color.RED);
        errorPanel.add(this.errorLabel);
        this.setMaxHeightToPreferredHeight(errorPanel);
        this.openModelButton = new JButton("Open Model");
        this.OKButton = new JButton("OK");
        buttonsPanel.add(Box.createHorizontalGlue());
        buttonsPanel.add(this.openModelButton);
        buttonsPanel.add(Box.createRigidArea(new Dimension(10, 0)));
        buttonsPanel.add(this.OKButton);
        this.setMaxHeightToPreferredHeight(buttonsPanel);
    }
}

