/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.headless;

import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.Serializable;
import org.nlogo.api.APIVersion$;
import org.nlogo.api.LabProtocol;
import org.nlogo.api.Version$;
import org.nlogo.core.WorldDimensions;
import org.nlogo.headless.BehaviorSpaceCoordinator$;
import org.nlogo.headless.HeadlessWorkspace;
import org.nlogo.headless.HeadlessWorkspace$;
import org.nlogo.nvm.LabInterface;
import org.nlogo.nvm.Workspace;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterator;
import scala.collection.immutable.$colon$colon;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

public final class Main$ {
    public static Main$ MODULE$;

    static {
        new Main$();
    }

    public void main(String[] args) {
        this.setHeadlessProperty();
        this.parseArgs(args).foreach((Function1<LabInterface.Settings, Object> & Serializable & scala.Serializable)settings -> {
            Main$.MODULE$.runExperiment(settings);
            return BoxedUnit.UNIT;
        });
    }

    public void runExperiment(LabInterface.Settings settings) {
        Option<LabProtocol> option;
        HeadlessWorkspace openWs = Main$.newWorkspace$1(settings);
        try {
            option = BehaviorSpaceCoordinator$.MODULE$.selectProtocol(settings, openWs);
        }
        finally {
            openWs.dispose();
        }
        Option<LabProtocol> proto = option;
        if (proto instanceof Some) {
            LabProtocol protocol = (LabProtocol)((Some)proto).value();
            HeadlessWorkspace$.MODULE$.newLab().run(settings, protocol, (Function0<Workspace>)(Function0<HeadlessWorkspace> & Serializable & scala.Serializable)() -> Main$.newWorkspace$1(settings));
            return;
        }
        if (None$.MODULE$.equals(proto)) {
            throw new IllegalArgumentException("Invalid run, specify experiment name or setup file");
        }
        throw new MatchError(proto);
    }

    public void setHeadlessProperty() {
        String p = "java.awt.headless";
        if (System.getProperty(p) == null) {
            System.setProperty(p, "true");
        }
    }

    private Option<LabInterface.Settings> parseArgs(String[] args) {
        $colon$colon<Nothing$> dimStrings;
        Option model = None$.MODULE$;
        Option minPxcor = None$.MODULE$;
        Option maxPxcor = None$.MODULE$;
        Option minPycor = None$.MODULE$;
        Option maxPycor = None$.MODULE$;
        Option setupFile = None$.MODULE$;
        Option experiment = None$.MODULE$;
        Option tableWriter = None$.MODULE$;
        Option spreadsheetWriter = None$.MODULE$;
        int threads = Runtime.getRuntime().availableProcessors();
        boolean suppressErrors = false;
        Iterator<Object> it = new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])args)).iterator();
        while (it.hasNext()) {
            String arg;
            String string2 = arg = (String)it.next();
            String string3 = "--version";
            if (string2 != null && string2.equals(string3)) {
                Predef$.MODULE$.println(Version$.MODULE$.version());
                return None$.MODULE$;
            }
            String string4 = arg;
            String string5 = "--extension-api-version";
            if (string4 != null && string4.equals(string5)) {
                Predef$.MODULE$.println(APIVersion$.MODULE$.version());
                return None$.MODULE$;
            }
            String string6 = arg;
            String string7 = "--builddate";
            if (string6 != null && string6.equals(string7)) {
                Predef$.MODULE$.println(Version$.MODULE$.buildDate());
                return None$.MODULE$;
            }
            String string8 = arg;
            String string9 = "--fullversion";
            if (string8 != null && string8.equals(string9)) {
                Predef$.MODULE$.println(Version$.MODULE$.fullVersion());
                return None$.MODULE$;
            }
            String string10 = arg;
            String string11 = "--model";
            if (string10 != null && string10.equals(string11)) {
                Main$.requireHasNext$1(it, arg);
                model = new Some<Object>(it.next());
                continue;
            }
            String string12 = arg;
            String string13 = "--min-pxcor";
            if (string12 != null && string12.equals(string13)) {
                Main$.requireHasNext$1(it, arg);
                minPxcor = new Some<Object>(it.next());
                continue;
            }
            String string14 = arg;
            String string15 = "--max-pxcor";
            if (string14 != null && string14.equals(string15)) {
                Main$.requireHasNext$1(it, arg);
                maxPxcor = new Some<Object>(it.next());
                continue;
            }
            String string16 = arg;
            String string17 = "--min-pycor";
            if (string16 != null && string16.equals(string17)) {
                Main$.requireHasNext$1(it, arg);
                minPycor = new Some<Object>(it.next());
                continue;
            }
            String string18 = arg;
            String string19 = "--max-pycor";
            if (string18 != null && string18.equals(string19)) {
                Main$.requireHasNext$1(it, arg);
                maxPycor = new Some<Object>(it.next());
                continue;
            }
            String string20 = arg;
            String string21 = "--setup-file";
            if (string20 != null && string20.equals(string21)) {
                Main$.requireHasNext$1(it, arg);
                setupFile = new Some<File>(new File((String)it.next()));
                continue;
            }
            String string22 = arg;
            String string23 = "--experiment";
            if (string22 != null && string22.equals(string23)) {
                Main$.requireHasNext$1(it, arg);
                experiment = new Some<Object>(it.next());
                continue;
            }
            String string24 = arg;
            String string25 = "--table";
            if (string24 != null && string24.equals(string25)) {
                Main$.requireHasNext$1(it, arg);
                tableWriter = new Some<PrintWriter>(Main$.path2writer$1((String)it.next()));
                continue;
            }
            String string26 = arg;
            String string27 = "--spreadsheet";
            if (string26 != null && string26.equals(string27)) {
                Main$.requireHasNext$1(it, arg);
                spreadsheetWriter = new Some<PrintWriter>(Main$.path2writer$1((String)it.next()));
                continue;
            }
            String string28 = arg;
            String string29 = "--threads";
            if (string28 != null && string28.equals(string29)) {
                Main$.requireHasNext$1(it, arg);
                threads = new StringOps(Predef$.MODULE$.augmentString((String)it.next())).toInt();
                continue;
            }
            String string30 = arg;
            String string31 = "--suppress-errors";
            if (string30 != null && string30.equals(string31)) {
                suppressErrors = true;
                continue;
            }
            Main$.die$1(new StringBuilder(18).append("unknown argument: ").append(arg).toString());
        }
        None$ none$ = model;
        None$ none$2 = None$.MODULE$;
        if (!(none$ != null ? !none$.equals(none$2) : none$2 != null)) {
            Main$.die$1("you must specify --model");
        }
        None$ none$3 = setupFile;
        None$ none$4 = None$.MODULE$;
        if (!(none$3 != null ? !none$3.equals(none$4) : none$4 != null)) {
            None$ none$5 = experiment;
            None$ none$6 = None$.MODULE$;
            if (!(none$5 != null ? !none$5.equals(none$6) : none$6 != null)) {
                Main$.die$1("you must specify either --setup-file or --experiment (or both)");
            }
        }
        if ((dimStrings = new $colon$colon<Nothing$>((Nothing$)((Object)minPxcor), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)maxPxcor), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)minPycor), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)maxPycor), Nil$.MODULE$))))).exists((Function1<Option, Object> & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean(x$1.isDefined())) && dimStrings.exists((Function1<Option, Object> & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean(Main$.$anonfun$parseArgs$2(x$2)))) {
            Main$.die$1("if any of min/max-px/ycor are specified, all four must be specified");
        }
        Option dims = dimStrings.forall((Function1<Option, Object> & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean(Main$.$anonfun$parseArgs$3(x$3))) ? None$.MODULE$ : new Some<WorldDimensions>(new WorldDimensions(new StringOps(Predef$.MODULE$.augmentString((String)((Option)minPxcor).get())).toInt(), new StringOps(Predef$.MODULE$.augmentString((String)((Option)maxPxcor).get())).toInt(), new StringOps(Predef$.MODULE$.augmentString((String)((Option)minPycor).get())).toInt(), new StringOps(Predef$.MODULE$.augmentString((String)maxPycor.get())).toInt()));
        return new Some<LabInterface.Settings>(new LabInterface.Settings((String)model.get(), experiment, setupFile, tableWriter, spreadsheetWriter, dims, threads, suppressErrors));
    }

    /*
     * WARNING - void declaration
     */
    private static final HeadlessWorkspace newWorkspace$1(LabInterface.Settings settings$1) {
        void var1_1;
        HeadlessWorkspace w = HeadlessWorkspace$.MODULE$.newInstance();
        w.open(settings$1.modelPath());
        return var1_1;
    }

    private static final void die$1(String msg) {
        System.err.println(msg);
        System.exit(1);
    }

    private static final PrintWriter path2writer$1(String path) {
        String string2 = path;
        String string3 = "-";
        if (string2 != null && string2.equals(string3)) {
            return new PrintWriter(){

                public void close() {
                }
            };
        }
        return new PrintWriter(new FileWriter(path.trim()));
    }

    private static final void requireHasNext$1(Iterator it$1, String arg$1) {
        if (!it$1.hasNext()) {
            Main$.die$1(new StringBuilder(23).append("missing argument after ").append(arg$1).toString());
        }
    }

    public static final /* synthetic */ boolean $anonfun$parseArgs$2(Option x$2) {
        return !x$2.isDefined();
    }

    public static final /* synthetic */ boolean $anonfun$parseArgs$3(Option x$3) {
        return !x$3.isDefined();
    }

    private Main$() {
        MODULE$ = this;
    }
}

