/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.gl.render;

import com.jogamp.opengl.GL2;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1$mcII$sp;
import scala.runtime.java8.JFunction1$mcZI$sp;

public final class TextureUtils$ {
    public static TextureUtils$ MODULE$;

    static {
        new TextureUtils$();
    }

    public void makeTexture(GL2 gl, int size) {
        gl.glTexImage2D(3553, 0, 6408, size, size, 0, 6408, 5121, null);
    }

    public int genTexture(GL2 gl) {
        int[] tmp = new int[]{0};
        gl.glGenTextures(1, IntBuffer.wrap(tmp));
        return tmp[0];
    }

    public int calculateTextureSize(GL2 gl, int width, int height) {
        String glRendererName = gl.glGetString(7937).toUpperCase();
        int maxTextureSize = glRendererName.startsWith("ATI RAGE") ? 256 : (glRendererName.startsWith("ATI RADEON 7500") ? 512 : (glRendererName.startsWith("ATI RADEON 9200") ? 512 : 3379));
        return BoxesRunTime.unboxToInt(scala.package$.MODULE$.Iterator().iterate(BoxesRunTime.boxToInteger(64), (JFunction1$mcII$sp & Serializable)x$1 -> x$1 * 2).dropWhile((JFunction1$mcZI$sp & Serializable)size -> (width > size || height > size) && size < (2 + maxTextureSize) / 2).next());
    }

    public byte[][] createTileArray(int width, int height, int textureSize) {
        int numTiles = (int)package$.MODULE$.ceil((double)width / (double)textureSize) * (int)package$.MODULE$.ceil((double)height / (double)textureSize);
        return (byte[][])Array$.MODULE$.fill(numTiles, (Function0<byte[]> & java.io.Serializable & Serializable)() -> (byte[])Array$.MODULE$.apply(Nil$.MODULE$, ClassTag$.MODULE$.Byte()), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE)));
    }

    public void setParameters(GL2 gl) {
        gl.glTexParameteri(3553, 10241, 9728);
        gl.glTexParameteri(3553, 10240, 9728);
        gl.glTexParameteri(3553, 10242, 10496);
        gl.glTexParameteri(3553, 10243, 10496);
    }

    public byte[] reuseTexture(GL2 gl, int tileWidth, int tileHeight, int xOffset, int yOffset, int width, int[] colors, byte[] _bytes) {
        int i = 0;
        int size = tileHeight * tileWidth * 4;
        byte[] bytes = (byte[])Option$.MODULE$.apply(_bytes).filter((Function1<byte[], Object> & java.io.Serializable & Serializable)x$2 -> BoxesRunTime.boxToBoolean(TextureUtils$.$anonfun$reuseTexture$1(size, x$2))).getOrElse((Function0<byte[]> & java.io.Serializable & Serializable)() -> new byte[size]);
        for (int x = xOffset; x < tileWidth + xOffset; ++x) {
            for (int y = yOffset; y < tileHeight + yOffset; ++y) {
                int rgb = colors[x + y * width];
                bytes[i] = (byte)(rgb >> 16);
                bytes[++i] = (byte)(rgb >> 8);
                bytes[++i] = (byte)rgb;
                bytes[++i] = (byte)(rgb >> 24);
                ++i;
            }
        }
        gl.glTexSubImage2D(3553, 0, 0, 0, tileHeight, tileWidth, 6408, 5121, (Buffer)ByteBuffer.wrap(bytes));
        return bytes;
    }

    public void renderEmptyPlane(GL2 gl, float _sideX, float _sideY, float _sideZ) {
        float sideX = _sideX * 0.15f;
        float sideY = _sideY * 0.15f;
        float sideZ = _sideZ * 0.15f;
        gl.glColor4f(0.0f, 0.0f, 0.0f, 0.5f);
        gl.glBegin(7);
        gl.glNormal3f(0.0f, 0.0f, -1.0f);
        gl.glVertex3f(-sideX, sideY, -sideZ);
        gl.glVertex3f(-sideX, -sideY, -sideZ);
        gl.glVertex3f(sideX, -sideY, -sideZ);
        gl.glVertex3f(sideX, sideY, -sideZ);
        gl.glEnd();
        gl.glColor4f(0.0f, 0.0f, 0.0f, 0.5f);
        gl.glBegin(7);
        gl.glNormal3f(0.0f, 0.0f, -1.0f);
        gl.glVertex3f(sideX, sideY, -sideZ);
        gl.glVertex3f(sideX, -sideY, -sideZ);
        gl.glVertex3f(-sideX, -sideY, -sideZ);
        gl.glVertex3f(-sideX, sideY, -sideZ);
        gl.glEnd();
    }

    public void renderInPlane(GL2 gl, float _sideX, float _sideY, float _sideZ, float width, float height, float size, float offsetX, float offsetY) {
        float sideX = _sideX * 0.15f;
        float sideY = _sideY * 0.15f;
        float sideZ = _sideZ * 0.15f;
        gl.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        float offsetStretchX = offsetX / size;
        float offsetStretchY = offsetY / size;
        float textureStretchX = width / size + offsetStretchX;
        float textureStretchY = height / size + offsetStretchY;
        gl.glBegin(7);
        gl.glNormal3f(0.0f, 0.0f, -1.0f);
        gl.glTexCoord2f(offsetStretchY, offsetStretchX);
        gl.glVertex3f(-sideX, sideY, -sideZ);
        gl.glTexCoord2f(textureStretchY, offsetStretchX);
        gl.glVertex3f(-sideX, -sideY, -sideZ);
        gl.glTexCoord2f(textureStretchY, textureStretchX);
        gl.glVertex3f(sideX, -sideY, -sideZ);
        gl.glTexCoord2f(offsetStretchY, textureStretchX);
        gl.glVertex3f(sideX, sideY, -sideZ);
        gl.glEnd();
    }

    public static final /* synthetic */ boolean $anonfun$reuseTexture$1(int size$1, byte[] x$2) {
        return new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(x$2)).size() == size$1;
    }

    private TextureUtils$() {
        MODULE$ = this;
    }
}

