/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.app.common;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.TextAction;
import org.nlogo.core.I18N;
import org.nlogo.swing.ButtonPanel;
import org.nlogo.swing.NonemptyTextFieldActionEnabler;
import org.nlogo.swing.NonemptyTextFieldButtonEnabler;
import org.nlogo.swing.TextField;
import org.nlogo.swing.TextFieldBox;
import org.nlogo.swing.UserAction;
import org.nlogo.swing.UserAction$KeyBindings$;
import org.nlogo.swing.Utils;

public strictfp class FindDialog
extends JDialog
implements ActionListener {
    private static FindDialog instance;
    public static final Action FIND_ACTION;
    public static final Action FIND_NEXT_ACTION;
    protected JTextComponent target;
    private final JButton nextButton;
    private final JButton prevButton;
    NonemptyTextFieldButtonEnabler nextEnabler;
    NonemptyTextFieldButtonEnabler prevEnabler;
    private final JButton replaceButton;
    private final JButton replaceAndFindButton;
    private final JButton replaceAllButton;
    NonemptyTextFieldButtonEnabler replaceEnabler;
    NonemptyTextFieldButtonEnabler replaceAndFindEnabler;
    NonemptyTextFieldButtonEnabler replaceAllEnabler;
    private final JCheckBox ignoreCaseCheckBox;
    private final JCheckBox wrapAroundCheckBox;
    private final JTextField findBox;
    private final JTextField replaceBox;
    private final JLabel replaceLabel;
    private final JLabel notFoundLabel;
    private final Frame owner;

    public static void init(Frame frame) {
        instance = new FindDialog(frame);
    }

    public static FindDialog getInstance() {
        if (instance == null) {
            throw new IllegalStateException("FindDialog was never initialized");
        }
        return instance;
    }

    public static void watch(JTextComponent target) {
        FIND_ACTION.setEnabled(true);
        FindDialog findInstance = FindDialog.getInstance();
        findInstance.target = target;
        findInstance.setReplaceEnabled(target.isEditable());
    }

    public static void dontWatch(JTextComponent target) {
        FindDialog findInstance = FindDialog.getInstance();
        findInstance.setVisible(false);
        FIND_ACTION.setEnabled(false);
    }

    private FindDialog(Frame owner) {
        super(owner, I18N.guiJ().get("dialog.find.title"), false);
        this.owner = owner;
        TextFieldBox findPanel = new TextFieldBox(2);
        this.findBox = new TextField(25);
        this.findBox.setEditable(true);
        findPanel.addField(I18N.guiJ().get("dialog.find.find"), (JComponent)this.findBox);
        this.replaceBox = new TextField(25);
        this.replaceBox.setEditable(true);
        this.replaceLabel = new JLabel(I18N.guiJ().get("dialog.find.replaceWith"));
        findPanel.addField(this.replaceLabel, (JComponent)this.replaceBox);
        JPanel optionsPanel = new JPanel();
        optionsPanel.setLayout(new BoxLayout(optionsPanel, 0));
        this.ignoreCaseCheckBox = new JCheckBox(I18N.guiJ().get("dialog.find.ignoreCase"), true);
        this.wrapAroundCheckBox = new JCheckBox(I18N.guiJ().get("dialog.find.wrapAround"), true);
        this.notFoundLabel = new JLabel(I18N.guiJ().get("dialog.find.notFound"));
        optionsPanel.add(this.ignoreCaseCheckBox);
        optionsPanel.add(Box.createHorizontalStrut(12));
        optionsPanel.add(this.wrapAroundCheckBox);
        optionsPanel.add(Box.createHorizontalStrut(24));
        optionsPanel.add(this.notFoundLabel);
        this.notFoundLabel.setVisible(false);
        this.nextButton = new JButton(I18N.guiJ().get("dialog.find.next"));
        this.prevButton = new JButton(I18N.guiJ().get("dialog.find.previous"));
        this.replaceAndFindButton = new JButton(I18N.guiJ().get("dialog.find.replaceAndFind"));
        this.replaceButton = new JButton(I18N.guiJ().get("dialog.find.replace"));
        this.replaceAllButton = new JButton(I18N.guiJ().get("dialog.find.replaceAll"));
        this.getRootPane().setDefaultButton(this.nextButton);
        this.nextButton.addActionListener(this);
        this.prevButton.addActionListener(this);
        this.replaceAndFindButton.addActionListener(this);
        this.replaceButton.addActionListener(this);
        this.replaceAllButton.addActionListener(this);
        this.nextEnabler = new NonemptyTextFieldButtonEnabler(this.nextButton);
        this.nextEnabler.addRequiredField(this.findBox);
        new NonemptyTextFieldActionEnabler(FIND_NEXT_ACTION).addRequiredField(this.findBox);
        this.prevEnabler = new NonemptyTextFieldButtonEnabler(this.prevButton);
        this.prevEnabler.addRequiredField(this.findBox);
        this.replaceEnabler = new NonemptyTextFieldButtonEnabler(this.replaceAndFindButton);
        this.replaceEnabler.addRequiredField(this.findBox);
        this.replaceAndFindEnabler = new NonemptyTextFieldButtonEnabler(this.replaceButton);
        this.replaceAndFindEnabler.addRequiredField(this.findBox);
        this.replaceAllEnabler = new NonemptyTextFieldButtonEnabler(this.replaceAllButton);
        this.replaceAllEnabler.addRequiredField(this.findBox);
        Utils.addEscKeyAction(this, (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FindDialog.this.setVisible(false);
            }
        });
        ButtonPanel buttonPanel = new ButtonPanel(new JComponent[]{this.nextButton, this.prevButton, this.replaceAndFindButton, this.replaceButton, this.replaceAllButton});
        optionsPanel.setBorder(new EmptyBorder(8, 8, 8, 8));
        findPanel.setBorder(new EmptyBorder(16, 8, 8, 8));
        buttonPanel.setBorder(new EmptyBorder(16, 8, 8, 8));
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)findPanel, "North");
        this.getContentPane().add((Component)optionsPanel, "Center");
        this.getContentPane().add((Component)buttonPanel, "South");
        this.pack();
        this.setResizable(false);
        this.setVisible(false);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String search = this.findBox.getText();
        if (e.getSource().equals(this.nextButton) || e.getSource().equals(this.findBox)) {
            if (!this.next(search, this.ignoreCaseCheckBox.isSelected(), this.wrapAroundCheckBox.isSelected())) {
                Toolkit.getDefaultToolkit().beep();
                this.notFoundLabel.setVisible(true);
            } else {
                this.notFoundLabel.setVisible(false);
            }
        } else if (e.getSource().equals(this.prevButton)) {
            boolean ok = this.prev(search, this.ignoreCaseCheckBox.isSelected(), this.wrapAroundCheckBox.isSelected());
            if (!ok) {
                Toolkit.getDefaultToolkit().beep();
                this.notFoundLabel.setVisible(true);
            } else {
                this.notFoundLabel.setVisible(false);
            }
        } else if (e.getSource().equals(this.replaceAndFindButton)) {
            boolean firstTime;
            boolean bl = this.target.getSelectedText() == null || this.target.getSelectedText() != null && !(!this.ignoreCaseCheckBox.isSelected() ? this.target.getSelectedText().equals(this.findBox.getText()) : this.target.getSelectedText().equalsIgnoreCase(this.findBox.getText())) ? true : (firstTime = false);
            if (!firstTime) {
                this.replace(this.replaceBox.getText());
            }
            if (!this.next(search, this.ignoreCaseCheckBox.isSelected(), this.wrapAroundCheckBox.isSelected())) {
                Toolkit.getDefaultToolkit().beep();
                this.notFoundLabel.setVisible(true);
            } else {
                this.notFoundLabel.setVisible(false);
            }
        } else if (e.getSource().equals(this.replaceButton)) {
            this.replace(this.replaceBox.getText());
        } else if (e.getSource().equals(this.replaceAllButton)) {
            this.replaceAll(search, this.ignoreCaseCheckBox.isSelected(), this.replaceBox.getText());
        } else {
            this.notFoundLabel.setVisible(false);
        }
    }

    private boolean next(String search, boolean ignoreCase, boolean wrapAround) {
        int start = this.target.getSelectionEnd();
        int matchIndex = -1;
        String text = this.getTargetText();
        if (ignoreCase) {
            search = search.toUpperCase();
            text = text.toUpperCase();
        }
        if ((matchIndex = text.indexOf(search, start)) == -1 && wrapAround) {
            text = text.substring(0, start);
            matchIndex = text.indexOf(search);
        }
        if (matchIndex > -1) {
            this.target.setSelectionStart(matchIndex);
            this.target.setSelectionEnd(matchIndex + search.length());
            return true;
        }
        return false;
    }

    private boolean prev(String search, boolean ignoreCase, boolean wrapAround) {
        int start = StrictMath.max(0, this.target.getSelectionStart() - 1);
        int matchIndex = -1;
        String text = this.getTargetText();
        if (ignoreCase) {
            search = search.toUpperCase();
            text = text.toUpperCase();
        }
        if ((matchIndex = text.lastIndexOf(search, start)) == -1 && wrapAround) {
            text = text.substring(start, text.length());
            if (matchIndex != -1) {
                matchIndex = start + text.lastIndexOf(search);
            }
        }
        if (matchIndex > -1) {
            this.target.setSelectionStart(matchIndex);
            this.target.setSelectionEnd(matchIndex + search.length());
            return true;
        }
        return false;
    }

    private void replace(String replacement) {
        if (this.target.getSelectedText() == null || this.target.getSelectedText().length() == 0) {
            Toolkit.getDefaultToolkit().beep();
            return;
        }
        try {
            this.target.getDocument().remove(this.target.getSelectionStart(), this.target.getSelectionEnd() - this.target.getSelectionStart());
            this.target.getDocument().insertString(this.target.getCaretPosition(), replacement, null);
        }
        catch (BadLocationException ex) {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    private int replaceAll(String search, boolean ignoreCase, String replacement) {
        this.target.setSelectionStart(0);
        this.target.setSelectionEnd(0);
        int j = 0;
        if (this.next(search, ignoreCase, false)) {
            j = 1;
            do {
                this.replace(replacement);
                if (++j <= 50000) continue;
                throw new IllegalStateException("Replace All replaced too many items.");
            } while (this.next(search, ignoreCase, false));
        }
        return j;
    }

    private String getTargetText() {
        String text;
        if (this.target instanceof JEditorPane) {
            try {
                text = this.target.getText(0, this.target.getDocument().getLength());
            }
            catch (BadLocationException ex) {
                throw new IllegalStateException(ex);
            }
        } else {
            text = this.target.getText();
        }
        return text;
    }

    protected void setReplaceEnabled(boolean enabled) {
        this.replaceEnabler.setEnabled(enabled);
        this.replaceAndFindEnabler.setEnabled(enabled);
        this.replaceAllEnabler.setEnabled(enabled);
        this.replaceBox.setEnabled(enabled);
        this.replaceLabel.setEnabled(enabled);
    }

    static {
        FIND_ACTION = new FindAction();
        FIND_NEXT_ACTION = new FindNextAction();
    }

    strictfp static class FocusListener
    implements java.awt.event.FocusListener {
        FocusListener() {
        }

        @Override
        public void focusGained(FocusEvent fe) {
            if (fe.getSource() instanceof JTextComponent) {
                FindDialog.watch((JTextComponent)fe.getSource());
            }
        }

        @Override
        public void focusLost(FocusEvent fe) {
            if (!fe.isTemporary() && fe.getSource() instanceof JTextComponent) {
                FindDialog.dontWatch((JTextComponent)fe.getSource());
            }
        }
    }

    public strictfp static class FindNextAction
    extends TextAction {
        FindNextAction() {
            super(I18N.guiJ().get("menu.edit.findNext"));
            this.putValue("SmallIcon", Utils.icon("/images/magnify.gif"));
            this.putValue(UserAction.ActionCategoryKey(), UserAction.EditCategory());
            this.putValue(UserAction.ActionGroupKey(), UserAction.EditFindGroup());
            this.putValue("AcceleratorKey", UserAction$KeyBindings$.MODULE$.keystroke(71, true, false, false));
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String search = FindDialog.getInstance().findBox.getText();
            if (!FindDialog.getInstance().next(search, FindDialog.getInstance().ignoreCaseCheckBox.isSelected(), FindDialog.getInstance().wrapAroundCheckBox.isSelected())) {
                Toolkit.getDefaultToolkit().beep();
            }
        }
    }

    public strictfp static class FindAction
    extends TextAction {
        FindAction() {
            super(I18N.guiJ().get("menu.edit.find"));
            this.putValue("SmallIcon", Utils.icon("/images/magnify.gif"));
            this.putValue(UserAction.ActionCategoryKey(), UserAction.EditCategory());
            this.putValue(UserAction.ActionGroupKey(), UserAction.EditFindGroup());
            this.putValue("AcceleratorKey", UserAction$KeyBindings$.MODULE$.keystroke(70, true, false, false));
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            FindDialog.getInstance().setVisible(true);
            FindDialog.getInstance().findBox.requestFocus();
            FindDialog.getInstance().findBox.selectAll();
            FindDialog findDialog = FindDialog.getInstance();
            String selectedText = findDialog.target.getSelectedText();
            if (selectedText != null) {
                FindDialog.getInstance().findBox.setText(selectedText);
            }
            FindDialog.getInstance().setLocation(((FindDialog)instance).owner.getLocation().x + instance.owner.getWidth() - instance.getPreferredSize().width, ((FindDialog)instance).owner.getLocation().y + instance.owner.getHeight() / 2 - instance.getPreferredSize().height / 2);
            FindDialog.getInstance().notFoundLabel.setVisible(false);
        }
    }
}

