/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.api;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import javax.imageio.ImageIO;
import org.nlogo.api.LocalFile;
import org.nlogo.api.Version$;
import org.nlogo.core.FileMode$Write$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterator;
import scala.collection.LinearSeqOptimized;
import scala.collection.immutable.List;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.io.Codec;
import scala.io.Codec$;
import scala.io.Source$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0$mcC$sp;
import scala.runtime.java8.JFunction0$mcI$sp;
import scala.runtime.java8.JFunction1$mcZI$sp;
import scala.util.matching.Regex;

public final class FileIO$ {
    public static FileIO$ MODULE$;

    static {
        new FileIO$();
    }

    public String file2String(String path) throws IOException {
        return Source$.MODULE$.fromFile(path, Codec$.MODULE$.fallbackSystemCodec()).mkString();
    }

    public String file2String(File file) throws IOException {
        return Source$.MODULE$.fromFile(file, Codec$.MODULE$.fallbackSystemCodec()).mkString();
    }

    public String fileToString(File file, Codec codec) throws IOException {
        return Source$.MODULE$.fromFile(file, codec).mkString();
    }

    public String fileToString(String path, Codec codec) throws IOException {
        return Source$.MODULE$.fromFile(path, codec).mkString();
    }

    public String fileToString(String path, String encoding) throws IOException {
        return Source$.MODULE$.fromFile(path, encoding).mkString();
    }

    public String url2String(String sampleURL) throws IOException {
        String badStart;
        if (sampleURL.startsWith("/")) {
            return this.getResourceAsString(sampleURL);
        }
        String massagedURL = !System.getProperty("os.name").startsWith("Mac") ? (sampleURL.indexOf(badStart = "file://") != -1 ? new java.lang.StringBuilder(6).append("file:/").append(new StringOps(Predef$.MODULE$.augmentString(sampleURL)).drop(new StringOps(Predef$.MODULE$.augmentString(badStart)).size())).toString() : sampleURL) : sampleURL;
        return this.reader2String(new InputStreamReader(new URL(massagedURL).openStream(), "UTF-8"));
    }

    public Iterator<String> getResourceLines(String path) {
        BufferedReader in = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream(path)));
        return package$.MODULE$.Iterator().continually((Function0<String> & Serializable & scala.Serializable)() -> in.readLine()).takeWhile((Function1<String, Object> & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean(FileIO$.$anonfun$getResourceLines$2(x$1)));
    }

    public String[] getResourceAsStringArray(String path) {
        return (String[])this.getResourceLines(path).toArray(ClassTag$.MODULE$.apply(String.class));
    }

    public String getResourceAsString(String path) {
        return this.getResourceLines(path).mkString("", "\n", "\n");
    }

    public void writeFile(String path, String text) throws IOException {
        this.writeFile(path, text, false);
    }

    public void writeImageFile(BufferedImage image, String filename, String format2) throws IOException {
        FileOutputStream stream = new FileOutputStream(new File(filename));
        ImageIO.write((RenderedImage)image, format2, stream);
        stream.close();
    }

    public String reader2String(Reader reader) throws IOException {
        return this.reader2String(reader, 8192);
    }

    public String reader2String(Reader reader, int bufferSize) {
        Predef$.MODULE$.assert(bufferSize > 0);
        StringBuilder sb = new StringBuilder();
        char[] buffer = (char[])Array$.MODULE$.fill(bufferSize, (JFunction0$mcC$sp & scala.Serializable)() -> '\u0000', ClassTag$.MODULE$.Char());
        package$.MODULE$.Iterator().continually((JFunction0$mcI$sp & scala.Serializable)() -> reader.read(buffer)).takeWhile((JFunction1$mcZI$sp & scala.Serializable)x$2 -> x$2 != -1).foreach((Function1<Object, StringBuilder> & Serializable & scala.Serializable)x$3 -> sb.appendAll(buffer, 0, BoxesRunTime.unboxToInt(x$3)));
        reader.close();
        return sb.toString();
    }

    public int reader2String$default$2() {
        return 8192;
    }

    public void writeFile(String path, String text, boolean convertToPlatformLineBreaks) throws IOException {
        LocalFile file = new LocalFile(path);
        try {
            file.open(FileMode$Write$.MODULE$);
            if (!convertToPlatformLineBreaks) {
                file.print(text);
            } else {
                BufferedReader lineReader = new BufferedReader(new StringReader(text));
                package$.MODULE$.Iterator().continually((Function0<String> & Serializable & scala.Serializable)() -> lineReader.readLine()).takeWhile((Function1<String, Object> & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean(FileIO$.$anonfun$writeFile$2(x$4))).foreach((Function1<String, Object> & Serializable & scala.Serializable)line -> {
                    file.println(line);
                    return BoxedUnit.UNIT;
                });
            }
            file.close(true);
        }
        finally {
            file.close(false);
        }
    }

    /*
     * WARNING - void declaration
     */
    public String perUserFile(String file, boolean createNecessaryDirs) {
        void var3_3;
        String res = this.perUserPath(file);
        if (createNecessaryDirs) {
            Files.createDirectories(Paths.get(res, new String[0]).getParent(), new FileAttribute[0]);
        }
        return var3_3;
    }

    public boolean perUserFile$default$2() {
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public String perUserDir(String dir, boolean create) {
        void var3_3;
        String res = this.perUserPath(dir);
        if (create) {
            Files.createDirectories(Paths.get(res, new String[0]), new FileAttribute[0]);
        }
        return var3_3;
    }

    public boolean perUserDir$default$2() {
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private String perUserPath(String path) {
        void var5_5;
        String string2;
        Regex minorVersionRegex = new StringOps(Predef$.MODULE$.augmentString("(\\d+\\.\\d+).*")).r();
        Option<List<String>> option = minorVersionRegex.unapplySeq(string2 = new StringOps(Predef$.MODULE$.augmentString(new StringOps(Predef$.MODULE$.augmentString(Version$.MODULE$.version())).stripPrefix("NetLogo "))).stripPrefix("3D "));
        if (option.isEmpty() || option.get() == null || ((LinearSeqOptimized)option.get()).lengthCompare(1) != 0) {
            throw new MatchError((Object)string2);
        }
        String version = (String)((LinearSeqOptimized)option.get()).apply(0);
        String os = System.getProperty("os.name").toUpperCase();
        String appData = os.contains("WIN") ? new java.lang.StringBuilder(8).append(System.getenv("APPDATA")).append("\\NetLogo").toString() : (os.contains("MAC") ? new java.lang.StringBuilder(36).append(System.getProperty("user.home")).append("/Library/Application Support/NetLogo").toString() : new java.lang.StringBuilder(9).append(System.getProperty("user.home")).append("/.netlogo").toString());
        return new java.lang.StringBuilder(0).append(appData).append(File.separator).append((String)var5_5).append(File.separator).append(path).toString();
    }

    public Option<Path> resolvePath(String name) {
        return this.resolvePath(name, None$.MODULE$);
    }

    public Option<Path> resolvePath(String name, Path peerFile) {
        return this.resolvePath(name, new Some<Path>(peerFile));
    }

    public Option<Path> resolvePath(String name, Option<Path> peerFile) {
        Option option;
        try {
            Path path = Paths.get(name, new String[0]);
            if (!path.isAbsolute()) {
                return peerFile.flatMap((Function1<Path, Option> & Serializable & scala.Serializable)p -> Option$.MODULE$.apply(p.toAbsolutePath().getParent()).map((Function1<Path, Path> & Serializable & scala.Serializable)x$5 -> x$5.resolve(name))).orElse((Function0<Some> & Serializable & scala.Serializable)() -> new Some<Path>(Paths.get(System.getProperty("user.home"), name))).map((Function1<Path, Path> & Serializable & scala.Serializable)x$6 -> x$6.toAbsolutePath());
            }
            option = new Some<Path>(path);
        }
        catch (InvalidPathException invalidPathException) {
            option = None$.MODULE$;
        }
        return option;
    }

    public String ensureExtension(String path, String extension) {
        if (path.endsWith(new java.lang.StringBuilder(1).append(".").append(extension).toString())) {
            return path;
        }
        return new java.lang.StringBuilder(1).append(path).append(".").append(extension).toString();
    }

    public static final /* synthetic */ boolean $anonfun$getResourceLines$2(String x$1) {
        return x$1 != null;
    }

    public static final /* synthetic */ boolean $anonfun$writeFile$2(String x$4) {
        return x$4 != null;
    }

    private FileIO$() {
        MODULE$ = this;
    }
}

