/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.agent;

import java.util.ArrayList;
import java.util.List;
import org.nlogo.agent.Agent;
import org.nlogo.agent.AgentSet;
import org.nlogo.agent.Patch3D;
import org.nlogo.agent.Protractor3D;
import org.nlogo.agent.Turtle;
import org.nlogo.agent.Turtle3D;
import org.nlogo.agent.World;
import org.nlogo.agent.World3D;
import org.nlogo.api.AgentException;
import org.nlogo.api.Vect;
import org.nlogo.core.AgentKindJ;

public strictfp class InRadiusOrCone3D
implements World.InRadiusOrCone {
    private final World3D world;

    InRadiusOrCone3D(World3D world) {
        this.world = world;
    }

    @Override
    public List<Agent> inRadius(Agent agent, AgentSet sourceSet, double radius, boolean wrap) {
        double startZ;
        double startY;
        double startX;
        Patch3D startPatch;
        int worldWidth = this.world.worldWidth();
        int worldHeight = this.world.worldHeight();
        int worldDepth = this.world.worldDepth();
        int maxPxcor = this.world.maxPxcor();
        int maxPycor = this.world.maxPycor();
        int minPxcor = this.world.minPxcor();
        int minPycor = this.world.minPycor();
        ArrayList<Agent> result = new ArrayList<Agent>();
        if (agent instanceof Turtle) {
            Turtle3D startTurtle = (Turtle3D)agent;
            startPatch = (Patch3D)startTurtle.getPatchHere();
            startX = startTurtle.xcor();
            startY = startTurtle.ycor();
            startZ = startTurtle.zcor();
        } else {
            startPatch = (Patch3D)agent;
            startX = startPatch.pxcor;
            startY = startPatch.pycor;
            startZ = startPatch.pzcor;
        }
        int dxmin = 0;
        int dxmax = 0;
        int dymin = 0;
        int dymax = 0;
        int dzmin = 0;
        int dzmax = 0;
        int r = (int)StrictMath.ceil(radius);
        if (this.world.wrappingAllowedInX()) {
            double width = (double)worldWidth / 2.0;
            if ((double)r < width) {
                dxmax = r;
                dxmin = -r;
            } else {
                dxmax = (int)StrictMath.floor(width);
                dxmin = -((int)StrictMath.ceil(width - 1.0));
            }
        } else {
            int xdiff = minPxcor - startPatch.pxcor;
            dxmin = StrictMath.abs(xdiff) < r ? xdiff : -r;
            dxmax = StrictMath.min(maxPxcor - startPatch.pxcor, r);
        }
        if (this.world.wrappingAllowedInY()) {
            double height = (double)worldHeight / 2.0;
            if ((double)r < height) {
                dymax = r;
                dymin = -r;
            } else {
                dymax = (int)StrictMath.floor(height);
                dymin = -((int)StrictMath.ceil(height - 1.0));
            }
        } else {
            int ydiff = minPycor - startPatch.pycor;
            dymin = StrictMath.abs(ydiff) < r ? ydiff : -r;
            dymax = StrictMath.min(maxPycor - startPatch.pycor, r);
        }
        double depth = (double)worldDepth / 2.0;
        if ((double)r < depth) {
            dzmax = r;
            dzmin = -r;
        } else {
            dzmax = (int)StrictMath.floor(depth);
            dzmin = -((int)StrictMath.ceil(depth - 1.0));
        }
        Protractor3D protractor = this.world.protractor();
        for (int dz = dzmin; dz <= dzmax; ++dz) {
            for (int dy = dymin; dy <= dymax; ++dy) {
                for (int dx = dxmin; dx <= dxmax; ++dx) {
                    Patch3D patch = null;
                    try {
                        patch = startPatch.getPatchAtOffsets(dx, dy, dz);
                    }
                    catch (AgentException ex) {
                        throw new IllegalStateException(ex);
                    }
                    if (sourceSet.kind() == AgentKindJ.Patch()) {
                        if (!(protractor.distance(patch.pxcor, patch.pycor, patch.pzcor, startX, startY, startZ, wrap) <= radius) || sourceSet != this.world.patches() && !sourceSet.contains(patch)) continue;
                        result.add(patch);
                        continue;
                    }
                    if (!(StrictMath.sqrt(dx * dx + dy * dy + dz * dz) <= radius + 1.733)) continue;
                    for (Turtle turtle : patch.turtlesHere()) {
                        if (sourceSet != this.world.turtles() && (!sourceSet.isBreedSet() || sourceSet != turtle.getBreed()) && (sourceSet.isBreedSet() || !sourceSet.contains(turtle)) || !(protractor.distance(turtle.xcor(), turtle.ycor(), ((Turtle3D)turtle).zcor(), startX, startY, startZ, wrap) <= radius)) continue;
                        result.add(turtle);
                    }
                }
            }
        }
        return result;
    }

    @Override
    public List<Agent> inCone(Turtle callingTurtle, AgentSet sourceSet, double radius, double angle, boolean wrap) {
        int worldWidth = this.world.worldWidth();
        int worldHeight = this.world.worldHeight();
        int worldDepth = this.world.worldDepth();
        int maxPxcor = this.world.maxPxcor();
        int maxPycor = this.world.maxPycor();
        int minPxcor = this.world.minPxcor();
        int minPycor = this.world.minPycor();
        int m = 0;
        int n = 0;
        int k = 0;
        Turtle3D startTurtle = (Turtle3D)callingTurtle;
        if (wrap) {
            m = this.world.wrappingAllowedInX() ? (int)StrictMath.ceil(radius / (double)worldWidth) : 0;
            n = this.world.wrappingAllowedInY() ? (int)StrictMath.ceil(radius / (double)worldHeight) : 0;
            k = this.world.wrappingAllowedInZ() ? (int)StrictMath.ceil(radius / (double)worldDepth) : 0;
        }
        ArrayList<Agent> result = new ArrayList<Agent>();
        Patch3D startPatch = (Patch3D)startTurtle.getPatchHere();
        double half = angle / 2.0;
        int dxmin = 0;
        int dxmax = 0;
        int dymin = 0;
        int dymax = 0;
        int dzmin = 0;
        int dzmax = 0;
        int r = (int)StrictMath.ceil(radius);
        if (this.world.wrappingAllowedInX()) {
            double width = (double)worldWidth / 2.0;
            if ((double)r < width) {
                dxmax = r;
                dxmin = -r;
            } else {
                dxmax = (int)StrictMath.floor(width);
                dxmin = -((int)StrictMath.ceil(width - 1.0));
            }
        } else {
            int xdiff = minPxcor - startPatch.pxcor;
            dxmin = StrictMath.abs(xdiff) < r ? xdiff : -r;
            dxmax = StrictMath.min(maxPxcor - startPatch.pxcor, r);
        }
        if (this.world.wrappingAllowedInY()) {
            double height = (double)worldHeight / 2.0;
            if ((double)r < height) {
                dymax = r;
                dymin = -r;
            } else {
                dymax = (int)StrictMath.floor(height);
                dymin = -((int)StrictMath.ceil(height - 1.0));
            }
        } else {
            int ydiff = minPycor - startPatch.pycor;
            dymin = StrictMath.abs(ydiff) < r ? ydiff : -r;
            dymax = StrictMath.min(maxPycor - startPatch.pycor, r);
        }
        double depth = (double)worldDepth / 2.0;
        if ((double)r < depth) {
            dzmax = r;
            dzmin = -r;
        } else {
            dzmax = (int)StrictMath.floor(depth);
            dzmin = -((int)StrictMath.ceil(depth - 1.0));
        }
        for (int dz = dzmin; dz <= dzmax; ++dz) {
            for (int dy = dymin; dy <= dymax; ++dy) {
                block2: for (int dx = dxmin; dx <= dxmax; ++dx) {
                    Patch3D patch = (Patch3D)this.world.getPatchAtWrap(startPatch.pxcor + dx, startPatch.pycor + dy, startPatch.pzcor + dz);
                    if (patch == null) continue;
                    if (sourceSet.kind() == AgentKindJ.Patch()) {
                        for (int worldOffsetX = -m; worldOffsetX <= m; ++worldOffsetX) {
                            for (int worldOffsetY = -n; worldOffsetY <= n; ++worldOffsetY) {
                                for (int worldOffsetZ = -k; worldOffsetZ <= k; ++worldOffsetZ) {
                                    if (sourceSet != this.world.patches() && !sourceSet.contains(patch) || !this.isInCone(patch.pxcor + worldWidth * worldOffsetX, patch.pycor + worldHeight * worldOffsetY, patch.pzcor + worldDepth * worldOffsetZ, startTurtle.xcor(), startTurtle.ycor(), startTurtle.zcor(), radius, half, startTurtle.heading(), startTurtle.pitch())) continue;
                                    result.add(patch);
                                    continue block2;
                                }
                            }
                        }
                        continue;
                    }
                    if (!(StrictMath.sqrt(dx * dx + dy * dy + dz * dz) <= radius + 1.733)) continue;
                    block6: for (Turtle turtle : patch.turtlesHere()) {
                        for (int worldOffsetX = -m; worldOffsetX <= m; ++worldOffsetX) {
                            for (int worldOffsetY = -n; worldOffsetY <= n; ++worldOffsetY) {
                                for (int worldOffsetZ = -k; worldOffsetZ <= k; ++worldOffsetZ) {
                                    if (sourceSet != this.world.turtles() && (!sourceSet.isBreedSet() || sourceSet != turtle.getBreed()) && (sourceSet.isBreedSet() || !sourceSet.contains(turtle)) || !this.isInCone(turtle.xcor() + (double)(worldWidth * worldOffsetX), turtle.ycor() + (double)(worldHeight * worldOffsetY), ((Turtle3D)turtle).zcor() + (double)(worldDepth * worldOffsetZ), startTurtle.xcor(), startTurtle.ycor(), startTurtle.zcor(), radius, half, startTurtle.heading(), startTurtle.pitch())) continue;
                                    result.add(turtle);
                                    continue block6;
                                }
                            }
                        }
                    }
                }
            }
        }
        return result;
    }

    private boolean isInCone(double x, double y, double z, double cx, double cy, double cz, double r, double half, double h, double p) {
        double halfRadians;
        Protractor3D protractor = this.world.protractor();
        if (x == cx && y == cy && z == cz) {
            return true;
        }
        if (protractor.distance(cx, cy, cz, x, y, z, false) > r) {
            return false;
        }
        Vect targetVect = new Vect(x - cx, y - cy, z - cz);
        Vect unitVect = Vect.toVectors(h, p, 0.0)[0];
        double angle = targetVect.angleTo(unitVect);
        return angle <= (halfRadians = StrictMath.toRadians(half)) || angle >= Math.PI * 2 - halfRadians;
    }
}

