/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.shape;

import com.sun.javafx.geom.Arc2D;
import com.sun.javafx.scene.DirtyBits;
import com.sun.javafx.sg.prism.NGArc;
import com.sun.javafx.sg.prism.NGNode;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.DoublePropertyBase;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.scene.paint.Paint;
import javafx.scene.shape.ArcType;
import javafx.scene.shape.Shape;

public class Arc
extends Shape {
    private final Arc2D shape = new Arc2D();
    private DoubleProperty centerX;
    private DoubleProperty centerY;
    private final DoubleProperty radiusX = new DoublePropertyBase(){

        @Override
        public void invalidated() {
            Arc.this.impl_markDirty(DirtyBits.NODE_GEOMETRY);
            Arc.this.impl_geomChanged();
        }

        @Override
        public Object getBean() {
            return Arc.this;
        }

        @Override
        public String getName() {
            return "radiusX";
        }
    };
    private final DoubleProperty radiusY = new DoublePropertyBase(){

        @Override
        public void invalidated() {
            Arc.this.impl_markDirty(DirtyBits.NODE_GEOMETRY);
            Arc.this.impl_geomChanged();
        }

        @Override
        public Object getBean() {
            return Arc.this;
        }

        @Override
        public String getName() {
            return "radiusY";
        }
    };
    private DoubleProperty startAngle;
    private final DoubleProperty length = new DoublePropertyBase(){

        @Override
        public void invalidated() {
            Arc.this.impl_markDirty(DirtyBits.NODE_GEOMETRY);
            Arc.this.impl_geomChanged();
        }

        @Override
        public Object getBean() {
            return Arc.this;
        }

        @Override
        public String getName() {
            return "length";
        }
    };
    private ObjectProperty<ArcType> type;

    public Arc() {
    }

    public Arc(double centerX, double centerY, double radiusX, double radiusY, double startAngle, double length) {
        this.setCenterX(centerX);
        this.setCenterY(centerY);
        this.setRadiusX(radiusX);
        this.setRadiusY(radiusY);
        this.setStartAngle(startAngle);
        this.setLength(length);
    }

    public final void setCenterX(double value) {
        if (this.centerX != null || value != 0.0) {
            this.centerXProperty().set(value);
        }
    }

    public final double getCenterX() {
        return this.centerX == null ? 0.0 : this.centerX.get();
    }

    public final DoubleProperty centerXProperty() {
        if (this.centerX == null) {
            this.centerX = new DoublePropertyBase(){

                @Override
                public void invalidated() {
                    Arc.this.impl_markDirty(DirtyBits.NODE_GEOMETRY);
                    Arc.this.impl_geomChanged();
                }

                @Override
                public Object getBean() {
                    return Arc.this;
                }

                @Override
                public String getName() {
                    return "centerX";
                }
            };
        }
        return this.centerX;
    }

    public final void setCenterY(double value) {
        if (this.centerY != null || value != 0.0) {
            this.centerYProperty().set(value);
        }
    }

    public final double getCenterY() {
        return this.centerY == null ? 0.0 : this.centerY.get();
    }

    public final DoubleProperty centerYProperty() {
        if (this.centerY == null) {
            this.centerY = new DoublePropertyBase(){

                @Override
                public void invalidated() {
                    Arc.this.impl_markDirty(DirtyBits.NODE_GEOMETRY);
                    Arc.this.impl_geomChanged();
                }

                @Override
                public Object getBean() {
                    return Arc.this;
                }

                @Override
                public String getName() {
                    return "centerY";
                }
            };
        }
        return this.centerY;
    }

    public final void setRadiusX(double value) {
        this.radiusX.set(value);
    }

    public final double getRadiusX() {
        return this.radiusX.get();
    }

    public final DoubleProperty radiusXProperty() {
        return this.radiusX;
    }

    public final void setRadiusY(double value) {
        this.radiusY.set(value);
    }

    public final double getRadiusY() {
        return this.radiusY.get();
    }

    public final DoubleProperty radiusYProperty() {
        return this.radiusY;
    }

    public final void setStartAngle(double value) {
        if (this.startAngle != null || value != 0.0) {
            this.startAngleProperty().set(value);
        }
    }

    public final double getStartAngle() {
        return this.startAngle == null ? 0.0 : this.startAngle.get();
    }

    public final DoubleProperty startAngleProperty() {
        if (this.startAngle == null) {
            this.startAngle = new DoublePropertyBase(){

                @Override
                public void invalidated() {
                    Arc.this.impl_markDirty(DirtyBits.NODE_GEOMETRY);
                    Arc.this.impl_geomChanged();
                }

                @Override
                public Object getBean() {
                    return Arc.this;
                }

                @Override
                public String getName() {
                    return "startAngle";
                }
            };
        }
        return this.startAngle;
    }

    public final void setLength(double value) {
        this.length.set(value);
    }

    public final double getLength() {
        return this.length.get();
    }

    public final DoubleProperty lengthProperty() {
        return this.length;
    }

    public final void setType(ArcType value) {
        if (this.type != null || value != ArcType.OPEN) {
            this.typeProperty().set(value);
        }
    }

    public final ArcType getType() {
        return this.type == null ? ArcType.OPEN : (ArcType)((Object)this.type.get());
    }

    public final ObjectProperty<ArcType> typeProperty() {
        if (this.type == null) {
            this.type = new ObjectPropertyBase<ArcType>(ArcType.OPEN){

                @Override
                public void invalidated() {
                    Arc.this.impl_markDirty(DirtyBits.NODE_GEOMETRY);
                    Arc.this.impl_geomChanged();
                }

                @Override
                public Object getBean() {
                    return Arc.this;
                }

                @Override
                public String getName() {
                    return "type";
                }
            };
        }
        return this.type;
    }

    @Override
    @Deprecated
    protected NGNode impl_createPeer() {
        return new NGArc();
    }

    @Override
    @Deprecated
    public Arc2D impl_configShape() {
        int tmpType;
        switch (this.getTypeInternal()) {
            case OPEN: {
                tmpType = 0;
                break;
            }
            case CHORD: {
                tmpType = 1;
                break;
            }
            default: {
                tmpType = 2;
            }
        }
        this.shape.setArc((float)(this.getCenterX() - this.getRadiusX()), (float)(this.getCenterY() - this.getRadiusY()), (float)(this.getRadiusX() * 2.0), (float)(this.getRadiusY() * 2.0), (float)this.getStartAngle(), (float)this.getLength(), tmpType);
        return this.shape;
    }

    private final ArcType getTypeInternal() {
        ArcType t = this.getType();
        return t == null ? ArcType.OPEN : t;
    }

    @Override
    @Deprecated
    public void impl_updatePeer() {
        super.impl_updatePeer();
        if (this.impl_isDirty(DirtyBits.NODE_GEOMETRY)) {
            NGArc peer = (NGArc)this.impl_getPeer();
            peer.updateArc((float)this.getCenterX(), (float)this.getCenterY(), (float)this.getRadiusX(), (float)this.getRadiusY(), (float)this.getStartAngle(), (float)this.getLength(), this.getTypeInternal());
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("Arc[");
        String id = this.getId();
        if (id != null) {
            sb.append("id=").append(id).append(", ");
        }
        sb.append("centerX=").append(this.getCenterX());
        sb.append(", centerY=").append(this.getCenterY());
        sb.append(", radiusX=").append(this.getRadiusX());
        sb.append(", radiusY=").append(this.getRadiusY());
        sb.append(", startAngle=").append(this.getStartAngle());
        sb.append(", length=").append(this.getLength());
        sb.append(", type=").append((Object)this.getType());
        sb.append(", fill=").append(this.getFill());
        Paint stroke = this.getStroke();
        if (stroke != null) {
            sb.append(", stroke=").append(stroke);
            sb.append(", strokeWidth=").append(this.getStrokeWidth());
        }
        return sb.append("]").toString();
    }
}

