/*
 * Decompiled with CFR 0.152.
 */
package javafx.geometry;

import javafx.beans.NamedArg;
import javafx.geometry.Point2D;

public class Rectangle2D {
    public static final Rectangle2D EMPTY = new Rectangle2D(0.0, 0.0, 0.0, 0.0);
    private double minX;
    private double minY;
    private double width;
    private double height;
    private double maxX;
    private double maxY;
    private int hash = 0;

    public double getMinX() {
        return this.minX;
    }

    public double getMinY() {
        return this.minY;
    }

    public double getWidth() {
        return this.width;
    }

    public double getHeight() {
        return this.height;
    }

    public double getMaxX() {
        return this.maxX;
    }

    public double getMaxY() {
        return this.maxY;
    }

    public Rectangle2D(@NamedArg(value="minX") double minX, @NamedArg(value="minY") double minY, @NamedArg(value="width") double width, @NamedArg(value="height") double height) {
        if (width < 0.0 || height < 0.0) {
            throw new IllegalArgumentException("Both width and height must be >= 0");
        }
        this.minX = minX;
        this.minY = minY;
        this.width = width;
        this.height = height;
        this.maxX = minX + width;
        this.maxY = minY + height;
    }

    public boolean contains(Point2D p) {
        if (p == null) {
            return false;
        }
        return this.contains(p.getX(), p.getY());
    }

    public boolean contains(double x, double y) {
        return x >= this.minX && x <= this.maxX && y >= this.minY && y <= this.maxY;
    }

    public boolean contains(Rectangle2D r) {
        if (r == null) {
            return false;
        }
        return r.minX >= this.minX && r.minY >= this.minY && r.maxX <= this.maxX && r.maxY <= this.maxY;
    }

    public boolean contains(double x, double y, double w, double h) {
        return x >= this.minX && y >= this.minY && w <= this.maxX - x && h <= this.maxY - y;
    }

    public boolean intersects(Rectangle2D r) {
        if (r == null) {
            return false;
        }
        return r.maxX > this.minX && r.maxY > this.minY && r.minX < this.maxX && r.minY < this.maxY;
    }

    public boolean intersects(double x, double y, double w, double h) {
        return x < this.maxX && y < this.maxY && x + w > this.minX && y + h > this.minY;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Rectangle2D) {
            Rectangle2D other = (Rectangle2D)obj;
            return this.minX == other.minX && this.minY == other.minY && this.width == other.width && this.height == other.height;
        }
        return false;
    }

    public int hashCode() {
        if (this.hash == 0) {
            long bits = 7L;
            bits = 31L * bits + Double.doubleToLongBits(this.minX);
            bits = 31L * bits + Double.doubleToLongBits(this.minY);
            bits = 31L * bits + Double.doubleToLongBits(this.width);
            bits = 31L * bits + Double.doubleToLongBits(this.height);
            this.hash = (int)(bits ^ bits >> 32);
        }
        return this.hash;
    }

    public String toString() {
        return "Rectangle2D [minX = " + this.minX + ", minY=" + this.minY + ", maxX=" + this.maxX + ", maxY=" + this.maxY + ", width=" + this.width + ", height=" + this.height + "]";
    }
}

