/*
 * Decompiled with CFR 0.152.
 */
package javafx.collections;

import java.lang.ref.WeakReference;
import javafx.beans.NamedArg;
import javafx.beans.WeakListener;
import javafx.collections.ListChangeListener;

public final class WeakListChangeListener<E>
implements ListChangeListener<E>,
WeakListener {
    private final WeakReference<ListChangeListener<E>> ref;

    public WeakListChangeListener(@NamedArg(value="listener") ListChangeListener<E> listener) {
        if (listener == null) {
            throw new NullPointerException("Listener must be specified.");
        }
        this.ref = new WeakReference<ListChangeListener<E>>(listener);
    }

    @Override
    public boolean wasGarbageCollected() {
        return this.ref.get() == null;
    }

    @Override
    public void onChanged(ListChangeListener.Change<? extends E> change) {
        ListChangeListener listener = (ListChangeListener)this.ref.get();
        if (listener != null) {
            listener.onChanged(change);
        } else {
            change.getList().removeListener(this);
        }
    }
}

