/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prism.impl.shape;

import com.sun.glass.utils.NativeLibLoader;
import com.sun.javafx.geom.Path2D;
import com.sun.javafx.geom.RectBounds;
import com.sun.javafx.geom.Shape;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.javafx.util.Logging;
import com.sun.prism.BasicStroke;
import com.sun.prism.impl.PrismSettings;
import com.sun.prism.impl.shape.MaskData;
import com.sun.prism.impl.shape.ShapeRasterizer;
import java.nio.ByteBuffer;
import java.security.AccessController;

public class NativePiscesRasterizer
implements ShapeRasterizer {
    private static MaskData emptyData = MaskData.create(new byte[1], 0, 0, 1, 1);
    private static final byte SEG_MOVETO = 0;
    private static final byte SEG_LINETO = 1;
    private static final byte SEG_QUADTO = 2;
    private static final byte SEG_CUBICTO = 3;
    private static final byte SEG_CLOSE = 4;
    private byte[] cachedMask;
    private ByteBuffer cachedBuffer;
    private MaskData cachedData;
    private int[] bounds = new int[4];
    private boolean lastAntialiasedShape;
    private boolean firstTimeAASetting = true;

    static native void init(int var0, int var1);

    static native void produceFillAlphas(float[] var0, byte[] var1, int var2, boolean var3, double var4, double var6, double var8, double var10, double var12, double var14, int[] var16, byte[] var17);

    static native void produceStrokeAlphas(float[] var0, byte[] var1, int var2, float var3, int var4, int var5, float var6, float[] var7, float var8, double var9, double var11, double var13, double var15, double var17, double var19, int[] var21, byte[] var22);

    @Override
    public MaskData getMaskData(Shape shape, BasicStroke stroke, RectBounds xformBounds, BaseTransform xform, boolean close, boolean antialiasedShape) {
        double mxt;
        double myt;
        double mxy;
        double myx;
        double mxx;
        double myy;
        Path2D p2d;
        if (this.firstTimeAASetting || this.lastAntialiasedShape != antialiasedShape) {
            int subpixelLgPositions = antialiasedShape ? 3 : 0;
            NativePiscesRasterizer.init(subpixelLgPositions, subpixelLgPositions);
            this.firstTimeAASetting = false;
            this.lastAntialiasedShape = antialiasedShape;
        }
        if (stroke != null && stroke.getType() != 0) {
            shape = stroke.createStrokedShape(shape);
            stroke = null;
        }
        if (xformBounds == null) {
            if (stroke != null) {
                shape = stroke.createStrokedShape(shape);
                stroke = null;
            }
            xformBounds = new RectBounds();
            xformBounds = (RectBounds)xform.transform(shape.getBounds(), xformBounds);
        }
        this.bounds[0] = (int)Math.floor(xformBounds.getMinX());
        this.bounds[1] = (int)Math.floor(xformBounds.getMinY());
        this.bounds[2] = (int)Math.ceil(xformBounds.getMaxX());
        this.bounds[3] = (int)Math.ceil(xformBounds.getMaxY());
        if (this.bounds[2] <= this.bounds[0] || this.bounds[3] <= this.bounds[1]) {
            return emptyData;
        }
        Path2D path2D = p2d = shape instanceof Path2D ? (Path2D)shape : new Path2D(shape);
        if (xform == null || xform.isIdentity()) {
            myy = 1.0;
            mxx = 1.0;
            myx = 0.0;
            mxy = 0.0;
            myt = 0.0;
            mxt = 0.0;
        } else {
            mxx = xform.getMxx();
            mxy = xform.getMxy();
            mxt = xform.getMxt();
            myx = xform.getMyx();
            myy = xform.getMyy();
            myt = xform.getMyt();
        }
        int x = this.bounds[0];
        int y = this.bounds[1];
        int w = this.bounds[2] - x;
        int h = this.bounds[3] - y;
        if (w <= 0 || h <= 0) {
            return emptyData;
        }
        if (this.cachedMask == null || w * h > this.cachedMask.length) {
            this.cachedMask = null;
            this.cachedBuffer = null;
            this.cachedData = new MaskData();
            int csize = w * h + 4095 & 0xFFFFF000;
            this.cachedMask = new byte[csize];
            this.cachedBuffer = ByteBuffer.wrap(this.cachedMask);
        }
        try {
            if (stroke != null) {
                NativePiscesRasterizer.produceStrokeAlphas(p2d.getFloatCoordsNoClone(), p2d.getCommandsNoClone(), p2d.getNumCommands(), stroke.getLineWidth(), stroke.getEndCap(), stroke.getLineJoin(), stroke.getMiterLimit(), stroke.getDashArray(), stroke.getDashPhase(), mxx, mxy, mxt, myx, myy, myt, this.bounds, this.cachedMask);
            } else {
                NativePiscesRasterizer.produceFillAlphas(p2d.getFloatCoordsNoClone(), p2d.getCommandsNoClone(), p2d.getNumCommands(), p2d.getWindingRule() == 1, mxx, mxy, mxt, myx, myy, myt, this.bounds, this.cachedMask);
            }
        }
        catch (Throwable ex) {
            if (PrismSettings.verbose) {
                ex.printStackTrace();
            }
            Logging.getJavaFXLogger().warning("Cannot rasterize Shape: " + ex.toString());
            return emptyData;
        }
        x = this.bounds[0];
        y = this.bounds[1];
        w = this.bounds[2] - x;
        h = this.bounds[3] - y;
        if (w <= 0 || h <= 0) {
            return emptyData;
        }
        this.cachedData.update(this.cachedBuffer, x, y, w, h);
        return this.cachedData;
    }

    static {
        AccessController.doPrivileged(() -> {
            String libName = "prism_common";
            if (PrismSettings.verbose) {
                System.out.println("Loading Prism common native library ...");
            }
            NativeLibLoader.loadLibrary(libName);
            if (PrismSettings.verbose) {
                System.out.println("\tsucceeded.");
            }
            return null;
        });
    }
}

