/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.behavior;

import com.sun.javafx.scene.control.behavior.TableCellBehaviorBase;
import java.util.Iterator;
import javafx.scene.Node;
import javafx.scene.control.TableColumnBase;
import javafx.scene.control.TablePositionBase;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeTableCell;
import javafx.scene.control.TreeTableColumn;
import javafx.scene.control.TreeTableView;
import javafx.scene.input.MouseButton;

public class TreeTableCellBehavior<S, T>
extends TableCellBehaviorBase<TreeItem<S>, T, TreeTableColumn<S, ?>, TreeTableCell<S, T>> {
    public TreeTableCellBehavior(TreeTableCell<S, T> control) {
        super(control);
    }

    @Override
    protected TreeTableView<S> getCellContainer() {
        return ((TreeTableCell)this.getControl()).getTreeTableView();
    }

    @Override
    protected TreeTableColumn<S, T> getTableColumn() {
        return ((TreeTableCell)this.getControl()).getTableColumn();
    }

    @Override
    protected int getItemCount() {
        return ((TreeTableView)this.getCellContainer()).getExpandedItemCount();
    }

    @Override
    protected TreeTableView.TreeTableViewSelectionModel<S> getSelectionModel() {
        return ((TreeTableView)this.getCellContainer()).getSelectionModel();
    }

    @Override
    protected TreeTableView.TreeTableViewFocusModel<S> getFocusModel() {
        return ((TreeTableView)this.getCellContainer()).getFocusModel();
    }

    @Override
    protected TablePositionBase getFocusedCell() {
        return ((TreeTableView)this.getCellContainer()).getFocusModel().getFocusedCell();
    }

    @Override
    protected boolean isTableRowSelected() {
        return ((TreeTableCell)this.getControl()).getTreeTableRow().isSelected();
    }

    @Override
    protected int getVisibleLeafIndex(TableColumnBase tc) {
        return ((TreeTableView)this.getCellContainer()).getVisibleLeafIndex((TreeTableColumn)tc);
    }

    @Override
    protected void focus(int row, TableColumnBase tc) {
        ((TreeTableView.TreeTableViewFocusModel)this.getFocusModel()).focus(row, (TreeTableColumn)tc);
    }

    @Override
    protected void edit(TreeTableCell<S, T> cell) {
        if (cell == null) {
            ((TreeTableView)this.getCellContainer()).edit(-1, null);
        } else {
            ((TreeTableView)this.getCellContainer()).edit(cell.getIndex(), cell.getTableColumn());
        }
    }

    @Override
    protected boolean handleDisclosureNode(double x, double y) {
        Node disclosureNode;
        TreeTableColumn treeColumn;
        TreeItem treeItem = ((TreeTableCell)this.getControl()).getTreeTableRow().getTreeItem();
        TreeTableView treeTableView = ((TreeTableCell)this.getControl()).getTreeTableView();
        TableColumnBase column = this.getTableColumn();
        TreeTableColumn treeTableColumn = treeColumn = treeTableView.getTreeColumn() == null ? treeTableView.getVisibleLeafColumn(0) : treeTableView.getTreeColumn();
        if (column == treeColumn && (disclosureNode = ((TreeTableCell)this.getControl()).getTreeTableRow().getDisclosureNode()) != null) {
            TreeTableColumn tc;
            double startX = 0.0;
            Iterator iterator = treeTableView.getVisibleLeafColumns().iterator();
            while (iterator.hasNext() && (tc = (TreeTableColumn)iterator.next()) != treeColumn) {
                startX += tc.getWidth();
            }
            double endX = disclosureNode.getBoundsInParent().getMaxX();
            if (x < endX - startX) {
                if (treeItem != null) {
                    treeItem.setExpanded(!treeItem.isExpanded());
                }
                return true;
            }
        }
        return false;
    }

    @Override
    protected void handleClicks(MouseButton button, int clickCount, boolean isAlreadySelected) {
        TreeItem treeItem = ((TreeTableCell)this.getControl()).getTreeTableRow().getTreeItem();
        if (button == MouseButton.PRIMARY) {
            if (clickCount == 1 && isAlreadySelected) {
                this.edit((TreeTableCell)this.getControl());
            } else if (clickCount == 1) {
                this.edit((TreeTableCell<S, T>)null);
            } else if (clickCount == 2 && treeItem.isLeaf()) {
                this.edit((TreeTableCell)this.getControl());
            } else if (clickCount % 2 == 0) {
                treeItem.setExpanded(!treeItem.isExpanded());
            }
        }
    }
}

