/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.ui;

import java.awt.Rectangle;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;

class Region
implements Cloneable,
Serializable {
    protected Vector rects = new Vector();

    public Region() {
    }

    public Region(Rectangle r) {
        this.addRectangle(r);
    }

    public Region(Rectangle r1, Rectangle r2) {
        this.addRectangle(r1);
        this.addRectangle(r2);
    }

    public boolean isEmpty() {
        return this.rects.isEmpty();
    }

    public int getNumRectangles() {
        return this.rects.size();
    }

    public Enumeration rectangles() {
        return this.rects.elements();
    }

    public Object clone() {
        Region r = new Region();
        r.rects = (Vector)this.rects.clone();
        return r;
    }

    public Rectangle getBounds() {
        Rectangle r = new Rectangle();
        int i2 = 0;
        while (i2 < this.rects.size()) {
            r = r.union((Rectangle)this.rects.elementAt(i2));
            ++i2;
        }
        return r;
    }

    public void addRectangle(Rectangle r) {
        int position = 0;
        while (position < this.rects.size()) {
            Rectangle current = (Rectangle)this.rects.elementAt(position);
            if (r.x > current.x && r.y > current.y && Region.right(r) <= Region.right(current) && Region.bottom(r) <= Region.bottom(current)) {
                return;
            }
            if (r.intersects(current)) {
                r = r.union(current);
                this.rects.removeElementAt(position);
                continue;
            }
            ++position;
        }
        this.rects.addElement(r);
    }

    public boolean intersects(Rectangle r) {
        int position = 0;
        while (position < this.rects.size()) {
            Rectangle rect = (Rectangle)this.rects.elementAt(position);
            if (rect.intersects(r)) {
                return true;
            }
            ++position;
        }
        return false;
    }

    public void intersect(Rectangle r) {
        int position = 0;
        while (position < this.rects.size()) {
            Rectangle rect = (Rectangle)this.rects.elementAt(position);
            if ((rect = rect.intersection(r)).isEmpty()) {
                this.rects.removeElementAt(position);
                continue;
            }
            this.rects.setElementAt(rect, position);
            ++position;
        }
    }

    public void addRegion(Region r) {
        Enumeration e2 = r.rectangles();
        while (e2.hasMoreElements()) {
            this.addRectangle((Rectangle)e2.nextElement());
        }
    }

    public void translate(int dx, int dy) {
        int p = 0;
        while (p < this.rects.size()) {
            Rectangle r = (Rectangle)this.rects.elementAt(p);
            r.translate(dx, dy);
            ++p;
        }
    }

    public String toString() {
        String s = this.getClass().getName() + " = [\n";
        Enumeration e2 = this.rectangles();
        while (e2.hasMoreElements()) {
            s = s + "(" + (Rectangle)e2.nextElement() + ")\n";
        }
        return s + "]";
    }

    public static int right(Rectangle r) {
        return r.x + r.width - 1;
    }

    public static int bottom(Rectangle r) {
        return r.y + r.height - 1;
    }
}

