/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jeuclid.elements.presentation.general;

import net.sourceforge.jeuclid.LayoutContext;
import net.sourceforge.jeuclid.context.Display;
import net.sourceforge.jeuclid.context.Parameter;
import net.sourceforge.jeuclid.elements.presentation.AbstractContainer;
import net.sourceforge.jeuclid.elements.support.attributes.AttributesHelper;
import org.apache.batik.dom.AbstractDocument;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Node;
import org.w3c.dom.mathml.MathMLStyleElement;

public final class Mstyle
extends AbstractContainer
implements MathMLStyleElement {
    public static final String ATTR_SCRIPTMINSIZE = "scriptminsize";
    public static final String ATTR_SCRIPTLEVEL = "scriptlevel";
    public static final String ATTR_SCRIPTSIZEMULTIPLIER = "scriptsizemultiplier";
    public static final String ATTR_DISPLAYSTYLE = "displaystyle";
    public static final String ELEMENT = "mstyle";
    private static final Log LOGGER = LogFactory.getLog(Mstyle.class);
    private static final long serialVersionUID = 1L;

    public Mstyle(String string, AbstractDocument abstractDocument) {
        super(string, abstractDocument);
        this.setDefaultMathAttribute(ATTR_DISPLAYSTYLE, "");
    }

    protected Node newNode() {
        return new Mstyle(this.nodeName, this.ownerDocument);
    }

    public String getScriptlevel() {
        return this.getMathAttribute(ATTR_SCRIPTLEVEL);
    }

    public void setScriptlevel(String string) {
        this.setAttribute(ATTR_SCRIPTLEVEL, string);
    }

    public String getScriptminsize() {
        return this.getMathAttribute(ATTR_SCRIPTMINSIZE);
    }

    public void setScriptminsize(String string) {
        this.setAttribute(ATTR_SCRIPTMINSIZE, string);
    }

    public LayoutContext getChildLayoutContext(int n, LayoutContext layoutContext) {
        return new StyleLayoutContext(layoutContext);
    }

    public String getBackground() {
        return this.getMathbackground();
    }

    public String getColor() {
        return this.getMathcolor();
    }

    public String getDisplaystyle() {
        return this.getMathAttribute(ATTR_DISPLAYSTYLE);
    }

    public String getScriptsizemultiplier() {
        return this.getMathAttribute(ATTR_SCRIPTSIZEMULTIPLIER);
    }

    public void setBackground(String string) {
        this.setMathbackground(string);
    }

    public void setColor(String string) {
        this.setMathcolor(string);
    }

    public void setDisplaystyle(String string) {
        this.setAttribute(ATTR_DISPLAYSTYLE, string);
    }

    public void setScriptsizemultiplier(String string) {
        this.setAttribute(ATTR_SCRIPTSIZEMULTIPLIER, string);
    }

    public String getMediummathspace() {
        throw new UnsupportedOperationException();
    }

    public String getNegativemediummathspace() {
        throw new UnsupportedOperationException();
    }

    public String getNegativethickmathspace() {
        throw new UnsupportedOperationException();
    }

    public String getNegativethinmathspace() {
        throw new UnsupportedOperationException();
    }

    public String getNegativeverythickmathspace() {
        throw new UnsupportedOperationException();
    }

    public String getNegativeverythinmathspace() {
        throw new UnsupportedOperationException();
    }

    public String getNegativeveryverythickmathspace() {
        throw new UnsupportedOperationException();
    }

    public String getNegativeveryverythinmathspace() {
        throw new UnsupportedOperationException();
    }

    public String getThickmathspace() {
        throw new UnsupportedOperationException();
    }

    public String getThinmathspace() {
        throw new UnsupportedOperationException();
    }

    public String getVerythickmathspace() {
        throw new UnsupportedOperationException();
    }

    public String getVerythinmathspace() {
        throw new UnsupportedOperationException();
    }

    public String getVeryverythickmathspace() {
        throw new UnsupportedOperationException();
    }

    public String getVeryverythinmathspace() {
        throw new UnsupportedOperationException();
    }

    public void setMediummathspace(String string) {
        throw new UnsupportedOperationException();
    }

    public void setNegativemediummathspace(String string) {
        throw new UnsupportedOperationException();
    }

    public void setNegativethickmathspace(String string) {
        throw new UnsupportedOperationException();
    }

    public void setNegativethinmathspace(String string) {
        throw new UnsupportedOperationException();
    }

    public void setNegativeverythickmathspace(String string) {
        throw new UnsupportedOperationException();
    }

    public void setNegativeverythinmathspace(String string) {
        throw new UnsupportedOperationException();
    }

    public void setNegativeveryverythickmathspace(String string) {
        throw new UnsupportedOperationException();
    }

    public void setNegativeveryverythinmathspace(String string) {
        throw new UnsupportedOperationException();
    }

    public void setThickmathspace(String string) {
        throw new UnsupportedOperationException();
    }

    public void setThinmathspace(String string) {
        throw new UnsupportedOperationException();
    }

    public void setVerythickmathspace(String string) {
        throw new UnsupportedOperationException();
    }

    public void setVerythinmathspace(String string) {
        throw new UnsupportedOperationException();
    }

    public void setVeryverythickmathspace(String string) {
        throw new UnsupportedOperationException();
    }

    public void setVeryverythinmathspace(String string) {
        throw new UnsupportedOperationException();
    }

    private class StyleLayoutContext
    implements LayoutContext {
        private final LayoutContext context;

        protected StyleLayoutContext(LayoutContext layoutContext) {
            this.context = layoutContext;
        }

        public Object getParameter(Parameter parameter) {
            Object object = Mstyle.this.applyLocalAttributesToContext(this.context).getParameter(parameter);
            if (Parameter.DISPLAY.equals((Object)parameter)) {
                object = this.applyDisplay(object);
            } else if (Parameter.SCRIPTLEVEL.equals((Object)parameter)) {
                object = this.applyScriptlevel(object);
            } else if (Parameter.SCRIPTMINSIZE.equals((Object)parameter)) {
                object = this.applyScriptMinsize(object);
            }
            return object;
        }

        private Object applyScriptMinsize(Object object) {
            String string = Mstyle.this.getScriptminsize();
            if (string != null && string.length() > 0) {
                return Float.valueOf(AttributesHelper.convertSizeToPt(string, this.context, "pt"));
            }
            return object;
        }

        private Object applyScriptlevel(Object object) {
            Object object2 = object;
            String string = Mstyle.this.getScriptlevel();
            if (string == null) {
                string = "";
            }
            if ((string = string.trim()).length() > 0) {
                char c = string.charAt(0);
                boolean bl = false;
                if (c == '+') {
                    bl = true;
                    string = string.substring(1);
                } else if (c == '-') {
                    bl = true;
                }
                try {
                    int n = Integer.parseInt(string);
                    object2 = bl ? Integer.valueOf((Integer)object2 + n) : Integer.valueOf(n);
                }
                catch (NumberFormatException numberFormatException) {
                    LOGGER.warn((Object)("Error in scriptlevel attribute for mstyle: " + string));
                }
            }
            return object2;
        }

        private Object applyDisplay(Object object) {
            Object object2 = object;
            String string = Mstyle.this.getDisplaystyle();
            if ("true".equalsIgnoreCase(string)) {
                object2 = Display.BLOCK;
            }
            if ("false".equalsIgnoreCase(string)) {
                object2 = Display.INLINE;
            }
            return object2;
        }
    }
}

