/*
 * Decompiled with CFR 0.152.
 */
package com.flickr4java.flickr.blogs;

import com.flickr4java.flickr.FlickrException;
import com.flickr4java.flickr.Response;
import com.flickr4java.flickr.Transport;
import com.flickr4java.flickr.blogs.Blog;
import com.flickr4java.flickr.blogs.Service;
import com.flickr4java.flickr.photos.Photo;
import com.flickr4java.flickr.util.XMLUtilities;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class BlogsInterface {
    private static final String METHOD_GET_SERVICES = "flickr.blogs.getServices";
    private static final String METHOD_GET_LIST = "flickr.blogs.getList";
    private static final String METHOD_POST_PHOTO = "flickr.blogs.postPhoto";
    private final String apiKey;
    private final String sharedSecret;
    private final Transport transportAPI;

    public BlogsInterface(String apiKey, String sharedSecret, Transport transport) {
        this.apiKey = apiKey;
        this.sharedSecret = sharedSecret;
        this.transportAPI = transport;
    }

    public Collection<Service> getServices() throws FlickrException {
        ArrayList<Service> list = new ArrayList<Service>();
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("method", METHOD_GET_SERVICES);
        Response response = this.transportAPI.get(this.transportAPI.getPath(), parameters, this.apiKey, this.sharedSecret);
        if (response.isError()) {
            throw new FlickrException(response.getErrorCode(), response.getErrorMessage());
        }
        Element servicesElement = response.getPayload();
        NodeList serviceNodes = servicesElement.getElementsByTagName("service");
        for (int i = 0; i < serviceNodes.getLength(); ++i) {
            Element serviceElement = (Element)serviceNodes.item(i);
            Service srv = new Service();
            srv.setId(serviceElement.getAttribute("id"));
            srv.setName(XMLUtilities.getValue(serviceElement));
            list.add(srv);
        }
        return list;
    }

    public void postPhoto(Photo photo, String blogId, String blogPassword) throws FlickrException {
        Response response;
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("method", METHOD_POST_PHOTO);
        parameters.put("blog_id", blogId);
        parameters.put("photo_id", photo.getId());
        parameters.put("title", photo.getTitle());
        parameters.put("description", photo.getDescription());
        if (blogPassword != null) {
            parameters.put("blog_password", blogPassword);
        }
        if ((response = this.transportAPI.post(this.transportAPI.getPath(), parameters, this.apiKey, this.sharedSecret)).isError()) {
            throw new FlickrException(response.getErrorCode(), response.getErrorMessage());
        }
    }

    public void postPhoto(Photo photo, String blogId) throws FlickrException {
        this.postPhoto(photo, blogId, null);
    }

    public Collection<Blog> getList() throws FlickrException {
        ArrayList<Blog> blogs = new ArrayList<Blog>();
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("method", METHOD_GET_LIST);
        Response response = this.transportAPI.post(this.transportAPI.getPath(), parameters, this.apiKey, this.sharedSecret);
        if (response.isError()) {
            throw new FlickrException(response.getErrorCode(), response.getErrorMessage());
        }
        Element blogsElement = response.getPayload();
        NodeList blogNodes = blogsElement.getElementsByTagName("blog");
        for (int i = 0; i < blogNodes.getLength(); ++i) {
            Element blogElement = (Element)blogNodes.item(i);
            Blog blog = new Blog();
            blog.setId(blogElement.getAttribute("id"));
            blog.setName(blogElement.getAttribute("name"));
            blog.setNeedPassword("1".equals(blogElement.getAttribute("needspassword")));
            blog.setUrl(blogElement.getAttribute("url"));
            blogs.add(blog);
        }
        return blogs;
    }
}

