/*
 * Decompiled with CFR 0.152.
 */
package com.flickr4java.flickr;

import com.flickr4java.flickr.Flickr;
import com.flickr4java.flickr.FlickrRuntimeException;
import com.flickr4java.flickr.RESTResponse;
import com.flickr4java.flickr.RequestContext;
import com.flickr4java.flickr.Response;
import com.flickr4java.flickr.Transport;
import com.flickr4java.flickr.auth.Auth;
import com.flickr4java.flickr.util.Base64;
import com.flickr4java.flickr.util.DebugInputStream;
import com.flickr4java.flickr.util.IOUtilities;
import com.flickr4java.flickr.util.UrlUtilities;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.Logger;
import org.scribe.builder.ServiceBuilder;
import org.scribe.builder.api.FlickrApi;
import org.scribe.model.OAuthRequest;
import org.scribe.model.Token;
import org.scribe.model.Verb;
import org.scribe.oauth.OAuthService;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class REST
extends Transport {
    private static final Logger logger = Logger.getLogger(REST.class);
    public static final String PATH = "/services/rest/";
    private static final String CHARSET_NAME = "UTF-8";
    private boolean proxyAuth = false;
    private String proxyUser = "";
    private String proxyPassword = "";
    private final DocumentBuilder builder;
    private static Object mutex = new Object();
    private Integer connectTimeoutMs;
    private Integer readTimeoutMs;

    public REST() {
        this.setTransportType("REST");
        this.setHost("api.flickr.com");
        this.setPath(PATH);
        this.setScheme("https");
        this.setResponseClass(RESTResponse.class);
        DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
        try {
            this.builder = builderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new FlickrRuntimeException(e);
        }
    }

    public REST(String host) {
        this();
        this.setHost(host);
    }

    public REST(String host, int port) {
        this();
        this.setHost(host);
        this.setPort(port);
    }

    public void setProxy(String proxyHost, int proxyPort) {
        System.setProperty("http.proxySet", "true");
        System.setProperty("http.proxyHost", proxyHost);
        System.setProperty("http.proxyPort", "" + proxyPort);
    }

    public void setProxy(String proxyHost, int proxyPort, String username, String password) {
        this.setProxy(proxyHost, proxyPort);
        this.proxyAuth = true;
        this.proxyUser = username;
        this.proxyPassword = password;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Response get(String path, Map<String, Object> parameters, String apiKey, String sharedSecret) {
        RequestContext requestContext;
        Auth auth;
        OAuthRequest request = new OAuthRequest(Verb.GET, this.getScheme() + "://" + this.getHost() + path);
        for (Map.Entry<String, Object> entry : parameters.entrySet()) {
            request.addQuerystringParameter(entry.getKey(), String.valueOf(entry.getValue()));
        }
        if (this.proxyAuth) {
            request.addHeader("Proxy-Authorization", "Basic " + this.getProxyCredentials());
        }
        if ((auth = (requestContext = RequestContext.getRequestContext()).getAuth()) != null) {
            Token requestToken = new Token(auth.getToken(), auth.getTokenSecret());
            OAuthService service = this.createOAuthService(parameters, apiKey, sharedSecret);
            service.signRequest(requestToken, request);
        } else if (!parameters.containsKey("api_key")) {
            request.addQuerystringParameter("api_key", apiKey);
        }
        if (Flickr.debugRequest) {
            logger.debug((Object)("GET: " + request.getCompleteUrl()));
        }
        this.setTimeouts(request);
        org.scribe.model.Response scribeResponse = request.send();
        try {
            Response response = null;
            Object object = mutex;
            synchronized (object) {
                String strXml = scribeResponse.getBody().trim();
                if (Flickr.debugStream) {
                    logger.debug((Object)strXml);
                }
                if (strXml.startsWith("oauth_problem=")) {
                    throw new FlickrRuntimeException(strXml);
                }
                Document document = this.builder.parse(new InputSource(new StringReader(strXml)));
                response = (Response)this.responseClass.newInstance();
                response.parse(document);
            }
            return response;
        }
        catch (IllegalAccessException e) {
            throw new FlickrRuntimeException(e);
        }
        catch (InstantiationException e) {
            throw new FlickrRuntimeException(e);
        }
        catch (SAXException e) {
            throw new FlickrRuntimeException(e);
        }
        catch (IOException e) {
            throw new FlickrRuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Response getNonOAuth(String path, Map<String, String> parameters) {
        Object object;
        InputStream in = null;
        try {
            URL url = UrlUtilities.buildUrl(this.getScheme(), this.getHost(), this.getPort(), path, parameters);
            if (Flickr.debugRequest) {
                logger.debug((Object)("GET: " + url));
            }
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("GET");
            if (this.proxyAuth) {
                conn.setRequestProperty("Proxy-Authorization", "Basic " + this.getProxyCredentials());
            }
            this.setTimeouts(conn);
            conn.connect();
            in = Flickr.debugStream ? new DebugInputStream(conn.getInputStream(), System.out) : conn.getInputStream();
            Response response = null;
            object = mutex;
            synchronized (object) {
                Document document = this.builder.parse(in);
                response = (Response)this.responseClass.newInstance();
                response.parse(document);
            }
            object = response;
        }
        catch (IllegalAccessException e) {
            try {
                throw new FlickrRuntimeException(e);
                catch (InstantiationException e2) {
                    throw new FlickrRuntimeException(e2);
                }
                catch (IOException e3) {
                    throw new FlickrRuntimeException(e3);
                }
                catch (SAXException e4) {
                    throw new FlickrRuntimeException(e4);
                }
            }
            catch (Throwable throwable) {
                IOUtilities.close(in);
                throw throwable;
            }
        }
        IOUtilities.close(in);
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Response post(String path, Map<String, Object> parameters, String apiKey, String sharedSecret, boolean multipart) {
        OAuthRequest request = new OAuthRequest(Verb.POST, this.getScheme() + "://" + this.getHost() + path);
        if (multipart) {
            this.buildMultipartRequest(parameters, request);
        } else {
            this.buildNormalPostRequest(parameters, request);
        }
        RequestContext requestContext = RequestContext.getRequestContext();
        Auth auth = requestContext.getAuth();
        if (auth != null) {
            Token requestToken = new Token(auth.getToken(), auth.getTokenSecret());
            OAuthService service = this.createOAuthService(parameters, apiKey, sharedSecret);
            service.signRequest(requestToken, request);
        }
        if (multipart) {
            parameters.putAll(request.getOauthParameters());
            request.addPayload(this.buildMultipartBody(parameters, this.getMultipartBoundary()));
        }
        if (this.proxyAuth) {
            request.addHeader("Proxy-Authorization", "Basic " + this.getProxyCredentials());
        }
        if (Flickr.debugRequest) {
            logger.debug((Object)("POST: " + request.getCompleteUrl()));
        }
        org.scribe.model.Response scribeResponse = request.send();
        try {
            Response response = null;
            Object object = mutex;
            synchronized (object) {
                String strXml = scribeResponse.getBody().trim();
                if (Flickr.debugStream) {
                    logger.debug((Object)strXml);
                }
                if (strXml.startsWith("oauth_problem=")) {
                    throw new FlickrRuntimeException(strXml);
                }
                Document document = this.builder.parse(new InputSource(new StringReader(strXml)));
                response = (Response)this.responseClass.newInstance();
                response.parse(document);
            }
            return response;
        }
        catch (IllegalAccessException e) {
            throw new FlickrRuntimeException(e);
        }
        catch (InstantiationException e) {
            throw new FlickrRuntimeException(e);
        }
        catch (SAXException e) {
            throw new FlickrRuntimeException(e);
        }
        catch (IOException e) {
            throw new FlickrRuntimeException(e);
        }
    }

    private OAuthService createOAuthService(Map<String, Object> parameters, String apiKey, String sharedSecret) {
        ServiceBuilder serviceBuilder = new ServiceBuilder().provider(FlickrApi.class).apiKey(apiKey).apiSecret(sharedSecret);
        if (Flickr.debugRequest) {
            serviceBuilder = serviceBuilder.debug();
        }
        return serviceBuilder.build();
    }

    private void buildNormalPostRequest(Map<String, Object> parameters, OAuthRequest request) {
        for (Map.Entry<String, Object> entry : parameters.entrySet()) {
            request.addBodyParameter(entry.getKey(), String.valueOf(entry.getValue()));
        }
    }

    private void buildMultipartRequest(Map<String, Object> parameters, OAuthRequest request) {
        request.addHeader("Content-Type", "multipart/form-data; boundary=" + this.getMultipartBoundary());
        for (Map.Entry<String, Object> entry : parameters.entrySet()) {
            String key = entry.getKey();
            if (key.equals("photo") || key.equals("filename") || key.equals("filemimetype")) continue;
            request.addQuerystringParameter(key, String.valueOf(entry.getValue()));
        }
    }

    private String getMultipartBoundary() {
        return "---------------------------7d273f7a0d3";
    }

    public boolean isProxyAuth() {
        return this.proxyAuth;
    }

    public String getProxyCredentials() {
        return new String(Base64.encode((this.proxyUser + ":" + this.proxyPassword).getBytes()));
    }

    private byte[] buildMultipartBody(Map<String, Object> parameters, String boundary) {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        try {
            String fileMimeType;
            String filename = (String)parameters.get("filename");
            if (filename == null) {
                filename = "image.jpg";
            }
            if ((fileMimeType = (String)parameters.get("filemimetype")) == null) {
                fileMimeType = "image/jpeg";
            }
            buffer.write(("--" + boundary + "\r\n").getBytes(CHARSET_NAME));
            for (Map.Entry<String, Object> entry : parameters.entrySet()) {
                String key = entry.getKey();
                if (key.equals("filename") || key.equals("filemimetype")) continue;
                this.writeParam(key, entry.getValue(), buffer, boundary, filename, fileMimeType);
            }
        }
        catch (IOException e) {
            throw new FlickrRuntimeException(e);
        }
        if (Flickr.debugRequest) {
            String output = new String(buffer.toByteArray());
            logger.debug((Object)("Multipart body:\n" + output));
        }
        return buffer.toByteArray();
    }

    private void writeParam(String name, Object value, ByteArrayOutputStream buffer, String boundary, String filename, String fileMimeType) throws IOException {
        if (value instanceof InputStream) {
            buffer.write(("Content-Disposition: form-data; name=\"" + name + "\"; filename=\"" + filename + "\";\r\n").getBytes(CHARSET_NAME));
            buffer.write(("Content-Type: " + fileMimeType + "\r\n\r\n").getBytes(CHARSET_NAME));
            InputStream in = (InputStream)value;
            byte[] buf = new byte[512];
            int res = -1;
            while ((res = in.read(buf)) != -1) {
                buffer.write(buf, 0, res);
            }
            buffer.write(("\r\n--" + boundary + "\r\n").getBytes(CHARSET_NAME));
        } else if (value instanceof byte[]) {
            buffer.write(("Content-Disposition: form-data; name=\"" + name + "\"; filename=\"" + filename + "\";\r\n").getBytes(CHARSET_NAME));
            buffer.write(("Content-Type: " + fileMimeType + "\r\n\r\n").getBytes(CHARSET_NAME));
            buffer.write((byte[])value);
            buffer.write(("\r\n--" + boundary + "\r\n").getBytes(CHARSET_NAME));
        } else {
            buffer.write(("Content-Disposition: form-data; name=\"" + name + "\"\r\n\r\n").getBytes(CHARSET_NAME));
            buffer.write(((String)value).getBytes(CHARSET_NAME));
            buffer.write(("\r\n--" + boundary + "\r\n").getBytes(CHARSET_NAME));
        }
    }

    private void setTimeouts(HttpURLConnection conn) {
        if (this.connectTimeoutMs != null) {
            conn.setConnectTimeout(this.connectTimeoutMs);
        }
        if (this.readTimeoutMs != null) {
            conn.setReadTimeout(this.readTimeoutMs);
        }
    }

    private void setTimeouts(OAuthRequest request) {
        if (this.connectTimeoutMs != null) {
            request.setConnectTimeout(this.connectTimeoutMs.intValue(), TimeUnit.MILLISECONDS);
        }
        if (this.readTimeoutMs != null) {
            request.setReadTimeout(this.readTimeoutMs.intValue(), TimeUnit.MILLISECONDS);
        }
    }

    public void setConnectTimeoutMs(Integer connectTimeoutMs) {
        this.connectTimeoutMs = connectTimeoutMs;
    }

    public void setReadTimeoutMs(Integer readTimeoutMs) {
        this.readTimeoutMs = readTimeoutMs;
    }
}

