/*
 * Decompiled with CFR 0.152.
 */
package org.la4j.factory;

import java.util.Arrays;
import java.util.Random;
import org.la4j.factory.AbstractFactory;
import org.la4j.factory.Factory;
import org.la4j.vector.Vector;
import org.la4j.vector.dense.BasicVector;
import org.la4j.vector.source.VectorSource;

public abstract class BasicFactory
extends AbstractFactory
implements Factory {
    private static final long serialVersionUID = 4071505L;

    @Override
    public Vector createVector() {
        return new BasicVector();
    }

    @Override
    public Vector createVector(int length) {
        return new BasicVector(length);
    }

    @Override
    public Vector createVector(double[] array) {
        return new BasicVector(array);
    }

    @Override
    public Vector createVector(Vector vector) {
        return new BasicVector(vector);
    }

    @Override
    public Vector createVector(VectorSource source) {
        return new BasicVector(source);
    }

    @Override
    public Vector createConstantVector(int length, double value) {
        double[] array = new double[length];
        Arrays.fill(array, value);
        return new BasicVector(array);
    }

    @Override
    public Vector createRandomVector(int length) {
        Random rnd = new Random();
        double[] array = new double[length];
        for (int i = 0; i < length; ++i) {
            array[i] = rnd.nextDouble();
        }
        return new BasicVector(array);
    }
}

