/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.util.stream.combine;

import java.util.List;
import org.openimaj.util.stream.AbstractStream;
import org.openimaj.util.stream.Stream;

public class RoundRobinStreamCombiner<T>
extends AbstractStream<T> {
    private List<Stream<T>> streams;
    private int currentStream;

    public RoundRobinStreamCombiner(List<Stream<T>> streams) {
        this.streams = streams;
        this.currentStream = 0;
    }

    @Override
    public boolean hasNext() {
        return this.streams.get(this.currentStream).hasNext();
    }

    @Override
    public T next() {
        Object toRet = this.streams.get(this.currentStream).next();
        this.nextStream();
        return (T)toRet;
    }

    private void nextStream() {
        ++this.currentStream;
        if (this.currentStream >= this.streams.size()) {
            this.currentStream = 0;
        }
    }
}

