/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.io.wrappers;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Scanner;
import org.openimaj.io.ReadWriteable;

public class ReadWriteableFloat
implements ReadWriteable,
Comparable<ReadWriteableFloat> {
    public float value;

    public ReadWriteableFloat(float value) {
        this.value = value;
    }

    public ReadWriteableFloat() {
        this.value = 0.0f;
    }

    @Override
    public void readBinary(DataInput in) throws IOException {
        this.value = in.readFloat();
    }

    @Override
    public void readASCII(Scanner in) throws IOException {
        this.value = in.nextFloat();
    }

    @Override
    public byte[] binaryHeader() {
        return new byte[0];
    }

    @Override
    public String asciiHeader() {
        return "";
    }

    @Override
    public void writeBinary(DataOutput out) throws IOException {
        out.writeFloat(this.value);
    }

    @Override
    public void writeASCII(PrintWriter out) throws IOException {
        out.print(this.value + "\n");
    }

    public boolean equals(Object o) {
        return o instanceof ReadWriteableFloat && ((ReadWriteableFloat)o).value == this.value;
    }

    public int hashCode() {
        return new Float(this.value).hashCode();
    }

    @Override
    public int compareTo(ReadWriteableFloat arg0) {
        return new Float(this.value).compareTo(Float.valueOf(arg0.value));
    }
}

