/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.data.dataset.cache;

import java.util.Collection;
import org.openimaj.data.dataset.GroupedDataset;
import org.openimaj.data.dataset.ListBackedDataset;
import org.openimaj.data.dataset.ListDataset;
import org.openimaj.data.dataset.MapBackedDataset;
import org.openimaj.data.dataset.cache.GroupedListCache;

public class InMemoryGroupedListCache<KEY, OBJECT>
implements GroupedListCache<KEY, OBJECT> {
    MapBackedDataset<KEY, ListDataset<OBJECT>, OBJECT> dataset = new MapBackedDataset();

    @Override
    public void add(Collection<KEY> keys, OBJECT object) {
        for (KEY key : keys) {
            ListBackedDataset<OBJECT> list = (ListBackedDataset<OBJECT>)this.dataset.getInstances(key);
            if (list == null) {
                list = new ListBackedDataset<OBJECT>();
                this.dataset.getMap().put(key, list);
            }
            list.add(object);
        }
    }

    @Override
    public void add(KEY key, OBJECT object) {
        ListBackedDataset<OBJECT> list = (ListBackedDataset<OBJECT>)this.dataset.getInstances(key);
        if (list == null) {
            list = new ListBackedDataset<OBJECT>();
            this.dataset.getMap().put(key, list);
        }
        list.add(object);
    }

    @Override
    public void add(KEY key, Collection<OBJECT> objects) {
        ListBackedDataset<OBJECT> list = (ListBackedDataset<OBJECT>)this.dataset.getInstances(key);
        if (list == null) {
            list = new ListBackedDataset<OBJECT>();
            this.dataset.getMap().put(key, list);
        }
        for (OBJECT object : objects) {
            list.add(object);
        }
    }

    @Override
    public GroupedDataset<KEY, ListDataset<OBJECT>, OBJECT> getDataset() {
        return this.dataset;
    }

    @Override
    public void reset() {
        this.dataset.getMap().clear();
    }
}

