/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.data;

import java.util.Iterator;
import java.util.Random;
import org.openimaj.data.DataSource;
import org.openimaj.data.RandomData;
import org.openimaj.util.array.ArrayIterator;

public class FloatArrayBackedDataSource
implements DataSource<float[]> {
    protected float[][] data;
    protected Random rng;

    public FloatArrayBackedDataSource(float[][] data) {
        this.data = data;
        this.rng = new Random();
    }

    public FloatArrayBackedDataSource(float[][] data, Random rng) {
        this.data = data;
        this.rng = rng;
    }

    public final void getData(int startRow, int stopRow, float[][] output) {
        int i = startRow;
        int j = 0;
        while (i < stopRow) {
            System.arraycopy(this.data[i], 0, output[j], 0, this.data[i].length);
            ++i;
            ++j;
        }
    }

    public final void getRandomRows(float[][] output) {
        int k = output.length;
        int[] ind = RandomData.getUniqueRandomInts(k, 0, this.data.length, this.rng);
        for (int i = 0; i < k; ++i) {
            System.arraycopy(this.data[ind[i]], 0, output[i], 0, this.data[ind[i]].length);
        }
    }

    @Override
    public int numDimensions() {
        return this.data[0].length;
    }

    @Override
    public int size() {
        return this.data.length;
    }

    @Override
    public float[] getData(int row) {
        return this.data[row];
    }

    @Override
    public Iterator<float[]> iterator() {
        return new ArrayIterator<float[]>((T[])this.data);
    }

    public float[][] createTemporaryArray(int size) {
        return new float[size][this.data[0].length];
    }
}

