/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.data;

import java.io.File;

public class DataUtils {
    private static final String DEFAULT_DATA_DIRECTORY_NAME = "Data";
    private static final String USER_HOME = "user.home";
    private static final String OPENIMAJ_DATA_DIR = "openimaj.data.dir";

    private DataUtils() {
    }

    public static File getDataDirectory() {
        File dataDir = null;
        if (System.getProperty(OPENIMAJ_DATA_DIR) != null) {
            dataDir = new File(System.getProperty(OPENIMAJ_DATA_DIR));
        } else {
            String userHome = System.getProperty(USER_HOME);
            dataDir = new File(userHome, DEFAULT_DATA_DIRECTORY_NAME);
        }
        return dataDir;
    }

    public static File getDataLocation(File relativePath) {
        return DataUtils.getDataLocation(relativePath.getPath());
    }

    public static File getDataLocation(String relativePath) {
        return new File(DataUtils.getDataDirectory(), relativePath);
    }
}

