/*
 * Decompiled with CFR 0.152.
 */
package org.opencv.aruco;

import org.opencv.aruco.Board;
import org.opencv.aruco.Dictionary;
import org.opencv.core.Mat;
import org.opencv.core.Size;

public class GridBoard
extends Board {
    protected GridBoard(long addr) {
        super(addr);
    }

    public static GridBoard __fromPtr__(long addr) {
        return new GridBoard(addr);
    }

    public static GridBoard create(int markersX, int markersY, float markerLength, float markerSeparation, Dictionary dictionary, int firstMarker) {
        GridBoard retVal = GridBoard.__fromPtr__(GridBoard.create_0(markersX, markersY, markerLength, markerSeparation, dictionary.getNativeObjAddr(), firstMarker));
        return retVal;
    }

    public static GridBoard create(int markersX, int markersY, float markerLength, float markerSeparation, Dictionary dictionary) {
        GridBoard retVal = GridBoard.__fromPtr__(GridBoard.create_1(markersX, markersY, markerLength, markerSeparation, dictionary.getNativeObjAddr()));
        return retVal;
    }

    public Size getGridSize() {
        Size retVal = new Size(GridBoard.getGridSize_0(this.nativeObj));
        return retVal;
    }

    public float getMarkerLength() {
        float retVal = GridBoard.getMarkerLength_0(this.nativeObj);
        return retVal;
    }

    public float getMarkerSeparation() {
        float retVal = GridBoard.getMarkerSeparation_0(this.nativeObj);
        return retVal;
    }

    public void draw(Size outSize, Mat img, int marginSize, int borderBits) {
        GridBoard.draw_0(this.nativeObj, outSize.width, outSize.height, img.nativeObj, marginSize, borderBits);
    }

    public void draw(Size outSize, Mat img, int marginSize) {
        GridBoard.draw_1(this.nativeObj, outSize.width, outSize.height, img.nativeObj, marginSize);
    }

    public void draw(Size outSize, Mat img) {
        GridBoard.draw_2(this.nativeObj, outSize.width, outSize.height, img.nativeObj);
    }

    @Override
    protected void finalize() throws Throwable {
        GridBoard.delete(this.nativeObj);
    }

    private static native long create_0(int var0, int var1, float var2, float var3, long var4, int var6);

    private static native long create_1(int var0, int var1, float var2, float var3, long var4);

    private static native double[] getGridSize_0(long var0);

    private static native float getMarkerLength_0(long var0);

    private static native float getMarkerSeparation_0(long var0);

    private static native void draw_0(long var0, double var2, double var4, long var6, int var8, int var9);

    private static native void draw_1(long var0, double var2, double var4, long var6, int var8);

    private static native void draw_2(long var0, double var2, double var4, long var6);

    private static native void delete(long var0);
}

