/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.typography;

import java.text.AttributedCharacterIterator;
import java.util.Map;
import org.openimaj.image.renderer.ImageRenderer;
import org.openimaj.image.typography.Font;
import org.openimaj.image.typography.FontRenderer;
import org.openimaj.image.typography.hershey.HersheyFont;

public class FontStyle<T> {
    public static final AttributedCharacterIterator.Attribute FONT = new FontStyleAttribute("font");
    public static final AttributedCharacterIterator.Attribute ITALIC = new FontStyleAttribute("italic");
    public static final AttributedCharacterIterator.Attribute ANGLE = new FontStyleAttribute("angle");
    public static final AttributedCharacterIterator.Attribute COLOUR = new FontStyleAttribute("colour");
    public static final AttributedCharacterIterator.Attribute HORIZONTAL_ALIGNMENT = new FontStyleAttribute("horizontalAlignment");
    public static final AttributedCharacterIterator.Attribute VERTICAL_ALIGNMENT = new FontStyleAttribute("verticalAlignment");
    public static final AttributedCharacterIterator.Attribute FONT_SIZE = new FontStyleAttribute("fontSize");
    private static final Font<?> DEFAULT_FONT = HersheyFont.ROMAN_SIMPLEX;
    protected Font<?> font;
    protected boolean italic;
    protected float angle;
    protected T colour;
    protected HorizontalAlignment horizontalAlignment = HorizontalAlignment.HORIZONTAL_LEFT;
    protected VerticalAlignment verticalAlignment = VerticalAlignment.VERTICAL_BOTTOM;
    protected int fontSize = 24;

    protected FontStyle(Font<?> font, ImageRenderer<T, ?> renderer) {
        this.colour = renderer.defaultForegroundColour();
        this.font = font;
    }

    public FontStyle(Font<?> font, T col) {
        this.colour = col;
        this.font = font;
    }

    public void parseAttributes(Map<? extends AttributedCharacterIterator.Attribute, Object> attrs) {
        if (attrs.containsKey(FONT)) {
            this.font = (Font)attrs.get(FONT);
        }
        if (attrs.containsKey(ITALIC)) {
            this.italic = (Boolean)attrs.get(ITALIC);
        }
        if (attrs.containsKey(ANGLE)) {
            this.angle = ((Number)attrs.get(ANGLE)).floatValue();
        }
        if (attrs.containsKey(COLOUR)) {
            this.colour = attrs.get(COLOUR);
        }
        if (attrs.containsKey(HORIZONTAL_ALIGNMENT)) {
            this.horizontalAlignment = (HorizontalAlignment)((Object)attrs.get(HORIZONTAL_ALIGNMENT));
        }
        if (attrs.containsKey(VERTICAL_ALIGNMENT)) {
            this.verticalAlignment = (VerticalAlignment)((Object)attrs.get(VERTICAL_ALIGNMENT));
        }
        if (attrs.containsKey(FONT_SIZE)) {
            this.fontSize = ((Number)attrs.get(FONT_SIZE)).intValue();
        }
    }

    public FontRenderer<T, FontStyle<T>> getRenderer(ImageRenderer<T, ?> renderer) {
        return this.font.getRenderer(renderer);
    }

    public static <T> FontStyle<T> parseAttributes(Map<? extends AttributedCharacterIterator.Attribute, Object> attrs, ImageRenderer<T, ?> renderer) {
        Font<?> fnt = (Font<?>)attrs.get(FONT);
        if (fnt == null) {
            fnt = DEFAULT_FONT;
        }
        FontStyle<T> sty = fnt.createStyle(renderer);
        sty.parseAttributes(attrs);
        return sty;
    }

    public Font<?> getFont() {
        return this.font;
    }

    public void setFont(Font<?> font) {
        this.font = font;
    }

    public boolean isItalic() {
        return this.italic;
    }

    public void setItalic(boolean italic) {
        this.italic = italic;
    }

    public float getAngle() {
        return this.angle;
    }

    public void setAngle(float angle) {
        this.angle = angle;
    }

    public T getColour() {
        return this.colour;
    }

    public void setColour(T colour) {
        this.colour = colour;
    }

    public HorizontalAlignment getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    public void setHorizontalAlignment(HorizontalAlignment horizontalAlignment) {
        this.horizontalAlignment = horizontalAlignment;
    }

    public VerticalAlignment getVerticalAlignment() {
        return this.verticalAlignment;
    }

    public void setVerticalAlignment(VerticalAlignment verticalAlignment) {
        this.verticalAlignment = verticalAlignment;
    }

    public int getFontSize() {
        return this.fontSize;
    }

    public void setFontSize(int fontSize) {
        this.fontSize = fontSize;
    }

    public static enum VerticalAlignment {
        VERTICAL_TOP,
        VERTICAL_HALF,
        VERTICAL_CAP,
        VERTICAL_BOTTOM;

    }

    public static enum HorizontalAlignment {
        HORIZONTAL_CENTER,
        HORIZONTAL_LEFT,
        HORIZONTAL_RIGHT;

    }

    public static class FontStyleAttribute
    extends AttributedCharacterIterator.Attribute {
        private static final long serialVersionUID = 1L;

        public FontStyleAttribute(String name) {
            super(name);
        }
    }
}

