/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.colour;

import org.openimaj.image.FImage;
import org.openimaj.image.ImageUtilities;
import org.openimaj.image.MBFImage;
import org.openimaj.image.colour.ColourSpace;
import org.openimaj.util.array.ArrayUtils;

public class Transforms {
    public static FImage calculateIntensity(MBFImage in) {
        if (in.colourSpace != ColourSpace.RGB && in.colourSpace != ColourSpace.RGBA) {
            throw new UnsupportedOperationException("Can only convert RGB or RGBA images");
        }
        FImage out = new FImage(in.getWidth(), in.getHeight());
        for (int r = 0; r < in.getHeight(); ++r) {
            for (int c = 0; c < in.getWidth(); ++c) {
                out.pixels[r][c] = (((FImage)in.getBand((int)0)).pixels[r][c] + ((FImage)in.getBand((int)1)).pixels[r][c] + ((FImage)in.getBand((int)2)).pixels[r][c]) / 3.0f;
            }
        }
        return out;
    }

    public static FImage calculateIntensity(MBFImage in, float wR, float wG, float wB) {
        if (in.colourSpace != ColourSpace.RGB && in.colourSpace != ColourSpace.RGBA) {
            throw new UnsupportedOperationException("Can only convert RGB or RGBA images");
        }
        FImage out = new FImage(in.getWidth(), in.getHeight());
        float[][] ra = ((FImage)in.getBand((int)0)).pixels;
        float[][] ga = ((FImage)in.getBand((int)1)).pixels;
        float[][] ba = ((FImage)in.getBand((int)2)).pixels;
        for (int rr = 0; rr < in.getHeight(); ++rr) {
            for (int c = 0; c < in.getWidth(); ++c) {
                double r = ra[rr][c];
                double g = ga[rr][c];
                double b = ba[rr][c];
                out.pixels[rr][c] = (float)((double)wR * r + (double)wG * g + (double)wB * b);
                if (!Float.isNaN(out.pixels[rr][c])) continue;
                out.pixels[rr][c] = 0.0f;
            }
        }
        return out;
    }

    public static FImage calculateIntensityNTSC(MBFImage in) {
        if (in.colourSpace != ColourSpace.RGB && in.colourSpace != ColourSpace.RGBA) {
            throw new UnsupportedOperationException("Can only convert RGB or RGBA images");
        }
        FImage out = new FImage(in.getWidth(), in.getHeight());
        for (int r = 0; r < in.getHeight(); ++r) {
            for (int c = 0; c < in.getWidth(); ++c) {
                out.pixels[r][c] = 0.299f * ((FImage)in.getBand((int)0)).pixels[r][c] + 0.587f * ((FImage)in.getBand((int)1)).pixels[r][c] + 0.114f * ((FImage)in.getBand((int)2)).pixels[r][c];
            }
        }
        return out;
    }

    public static FImage calculateIntensityNTSC_LUT(MBFImage in) {
        if (in.colourSpace != ColourSpace.RGB && in.colourSpace != ColourSpace.RGBA) {
            throw new UnsupportedOperationException("Can only convert RGB or RGBA images");
        }
        FImage out = new FImage(in.getWidth(), in.getHeight());
        for (int r = 0; r < in.getHeight(); ++r) {
            for (int c = 0; c < in.getWidth(); ++c) {
                out.pixels[r][c] = ImageUtilities.BYTE_TO_FLOAT_LUT[(int)(0.299f * (255.0f * ((FImage)in.getBand((int)0)).pixels[r][c]) + 0.587f * (255.0f * ((FImage)in.getBand((int)1)).pixels[r][c]) + 0.114f * (255.0f * ((FImage)in.getBand((int)2)).pixels[r][c]))];
            }
        }
        return out;
    }

    public static FImage calculateHue(MBFImage in) {
        if (in.colourSpace == ColourSpace.HSV) {
            return (FImage)in.getBand(0);
        }
        if (in.colourSpace != ColourSpace.RGB && in.colourSpace != ColourSpace.RGBA) {
            throw new IllegalArgumentException("RGB or RGBA colourspace is required");
        }
        FImage out = new FImage(in.getWidth(), in.getHeight());
        float[][] ra = ((FImage)in.getBand((int)0)).pixels;
        float[][] ga = ((FImage)in.getBand((int)1)).pixels;
        float[][] ba = ((FImage)in.getBand((int)2)).pixels;
        for (int rr = 0; rr < in.getHeight(); ++rr) {
            int c = 0;
            while (c < in.getWidth()) {
                double r = ra[rr][c];
                double g = ga[rr][c];
                double b = ba[rr][c];
                double i = (r + g + b) / 3.0;
                double num = 0.5 * (r - g + (r - b));
                double den = Math.sqrt((r - g) * (r - g) + (r - b) * (g - b));
                out.pixels[rr][c] = den == 0.0 ? 0.0f : (float)Math.acos(num / den);
                if (b / i > g / i) {
                    out.pixels[rr][c] = (float)(Math.PI * 2 - (double)out.pixels[rr][c]);
                }
                float[] fArray = out.pixels[rr];
                int n = c++;
                fArray[n] = (float)((double)fArray[n] / (Math.PI * 2));
            }
        }
        return out;
    }

    public static FImage calculateSaturation(MBFImage in) {
        if (in.colourSpace != ColourSpace.RGB && in.colourSpace != ColourSpace.RGBA) {
            throw new IllegalArgumentException("RGB or RGBA colourspace is required");
        }
        FImage out = new FImage(in.getWidth(), in.getHeight());
        float[][] ra = ((FImage)in.getBand((int)0)).pixels;
        float[][] ga = ((FImage)in.getBand((int)1)).pixels;
        float[][] ba = ((FImage)in.getBand((int)2)).pixels;
        for (int rr = 0; rr < in.getHeight(); ++rr) {
            for (int c = 0; c < in.getWidth(); ++c) {
                double r = ra[rr][c];
                double g = ga[rr][c];
                double b = ba[rr][c];
                out.pixels[rr][c] = (float)(1.0 - 3.0 / (r + g + b) * Math.min(r, Math.min(g, b)));
                if (!Float.isNaN(out.pixels[rr][c])) continue;
                out.pixels[rr][c] = 0.0f;
            }
        }
        return out;
    }

    public static MBFImage RGB_TO_HSI(MBFImage in) {
        if (in.colourSpace != ColourSpace.RGB && in.colourSpace != ColourSpace.RGBA) {
            throw new IllegalArgumentException("RGB or RGBA colourspace is required");
        }
        MBFImage out = new MBFImage(ColourSpace.HSI, new FImage[0]);
        out.addBand(Transforms.calculateHue(in));
        out.addBand(Transforms.calculateSaturation(in));
        out.addBand(Transforms.calculateIntensity(in));
        return out;
    }

    public static MBFImage RGB_TO_HSL(MBFImage in) {
        if (in.colourSpace != ColourSpace.RGB && in.colourSpace != ColourSpace.RGBA) {
            throw new IllegalArgumentException("RGB or RGBA colourspace is required");
        }
        MBFImage out = (MBFImage)in.clone();
        float[] pix = new float[in.numBands()];
        for (int y = 0; y < in.getHeight(); ++y) {
            for (int x = 0; x < in.getWidth(); ++x) {
                int b;
                for (b = 0; b < in.numBands(); ++b) {
                    pix[b] = ((FImage)in.getBand((int)b)).pixels[y][x];
                }
                Transforms.RGB_TO_HSL(pix, pix);
                for (b = 0; b < in.numBands(); ++b) {
                    ((FImage)out.getBand((int)b)).pixels[y][x] = pix[b];
                }
            }
        }
        out.colourSpace = ColourSpace.HSL;
        return out;
    }

    public static float[] RGB_TO_HSL(float[] rgb, float[] hsl) {
        float s;
        float r = rgb[0];
        float g = rgb[1];
        float b = rgb[2];
        float max = Math.max(r, Math.max(g, b));
        float min = Math.min(r, Math.min(g, b));
        float h = 0.0f;
        float l = (max + min) / 2.0f;
        if (max == min) {
            s = 0.0f;
            h = 0.0f;
        } else {
            float d = max - min;
            float f = s = l > 0.5f ? d / (2.0f - max - min) : d / (max + min);
            if (max == r) {
                h = (g - b) / d + (g < b ? 6.0f : 0.0f);
            } else if (max == g) {
                h = (b - r) / d + 2.0f;
            } else if (max == b) {
                h = (r - g) / d + 4.0f;
            }
            h /= 6.0f;
        }
        hsl[0] = h;
        hsl[1] = s;
        hsl[2] = l;
        return hsl;
    }

    public static float[] HSL_TO_RGB(float[] hsl, float[] rgb) {
        float r;
        float g;
        float b;
        float h = hsl[0];
        float s = hsl[1];
        float l = hsl[2];
        if (s == 0.0f) {
            g = b = l;
            r = b;
        } else {
            float q = l < 0.5f ? l * (1.0f + s) : l + s - l * s;
            float p = 2.0f * l - q;
            r = Transforms.hue2rgb(p, q, h + 0.33333334f);
            g = Transforms.hue2rgb(p, q, h);
            b = Transforms.hue2rgb(p, q, h - 0.33333334f);
        }
        rgb[0] = r;
        rgb[1] = g;
        rgb[2] = b;
        return rgb;
    }

    private static float hue2rgb(float p, float q, float t) {
        if (t < 0.0f) {
            t += 1.0f;
        }
        if (t > 1.0f) {
            t -= 1.0f;
        }
        if (t < 0.16666667f) {
            return p + (q - p) * 6.0f * t;
        }
        if (t < 0.5f) {
            return q;
        }
        if (t < 0.6666667f) {
            return p + (q - p) * (0.6666667f - t) * 6.0f;
        }
        return p;
    }

    public static MBFImage RGB_TO_HSY(MBFImage in) {
        if (in.colourSpace != ColourSpace.RGB && in.colourSpace != ColourSpace.RGBA) {
            throw new IllegalArgumentException("RGB or RGBA colourspace is required");
        }
        MBFImage out = new MBFImage(ColourSpace.HSY, new FImage[0]);
        out.addBand(Transforms.calculateHue(in));
        out.addBand(Transforms.calculateSaturation(in));
        out.addBand(Transforms.calculateIntensityNTSC(in));
        return out;
    }

    public static MBFImage RGB_TO_HS(MBFImage in) {
        if (in.colourSpace != ColourSpace.RGB && in.colourSpace != ColourSpace.RGBA) {
            throw new IllegalArgumentException("RGB or RGBA colourspace is required");
        }
        MBFImage out = new MBFImage();
        out.addBand(Transforms.calculateHue(in));
        out.addBand(Transforms.calculateSaturation(in));
        return out;
    }

    public static MBFImage RGB_TO_HS_2(MBFImage in) {
        MBFImage hsv = Transforms.RGB_TO_HSV(in);
        hsv.deleteBand(2);
        hsv.colourSpace = ColourSpace.HS;
        return hsv;
    }

    public static MBFImage projectHS(MBFImage in) {
        if (in.colourSpace != ColourSpace.HS && in.colourSpace != ColourSpace.HSI && in.colourSpace != ColourSpace.HSV && in.colourSpace != ColourSpace.HSY) {
            throw new IllegalArgumentException("HS* colourspace is required");
        }
        MBFImage out = (MBFImage)in.clone();
        float[][] h = ((FImage)in.getBand((int)0)).pixels;
        float[][] s = ((FImage)in.getBand((int)1)).pixels;
        float[][] o1 = ((FImage)out.getBand((int)0)).pixels;
        float[][] o2 = ((FImage)out.getBand((int)1)).pixels;
        for (int r = 0; r < in.getHeight(); ++r) {
            for (int c = 0; c < in.getWidth(); ++c) {
                o1[r][c] = (float)((double)s[r][c] * Math.cos(Math.PI * 2 * (double)h[r][c]));
                o2[r][c] = (float)((double)s[r][c] * Math.sin(Math.PI * 2 * (double)h[r][c]));
            }
        }
        out.colourSpace = ColourSpace.CUSTOM;
        return out;
    }

    public static MBFImage RGB_TO_HSV(MBFImage in) {
        if (in.colourSpace != ColourSpace.RGB && in.colourSpace != ColourSpace.RGBA) {
            throw new IllegalArgumentException("RGB or RGBA colourspace is required");
        }
        int width = in.getWidth();
        int height = in.getHeight();
        MBFImage out = new MBFImage(width, height, ColourSpace.HSV);
        float[][] R = ((FImage)in.getBand((int)0)).pixels;
        float[][] G = ((FImage)in.getBand((int)1)).pixels;
        float[][] B = ((FImage)in.getBand((int)2)).pixels;
        float[][] H = ((FImage)out.getBand((int)0)).pixels;
        float[][] S = ((FImage)out.getBand((int)1)).pixels;
        float[][] V = ((FImage)out.getBand((int)2)).pixels;
        float[] pIn = new float[3];
        float[] pOut = new float[3];
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                pIn[0] = R[y][x];
                pIn[1] = G[y][x];
                pIn[2] = B[y][x];
                Transforms.RGB_TO_HSV(pIn, pOut);
                H[y][x] = pOut[0];
                S[y][x] = pOut[1];
                V[y][x] = pOut[2];
            }
        }
        return out;
    }

    static float[] RGB_TO_HSV(float[] rgb, float[] hsv) {
        float H;
        float S;
        float V;
        float R = rgb[0];
        float B = rgb[2];
        float G = rgb[1];
        if (B > G && B > R) {
            V = B;
            if (V != 0.0f) {
                float min = R > G ? G : R;
                float delta = V - min;
                if (delta != 0.0f) {
                    S = delta / V;
                    H = 4.0f + (R - G) / delta;
                } else {
                    S = 0.0f;
                    H = 4.0f + (R - G);
                }
                H *= 60.0f;
                if (H < 0.0f) {
                    H += 360.0f;
                }
                H /= 360.0f;
            } else {
                S = 0.0f;
                H = 0.0f;
            }
        } else if (G > R) {
            V = G;
            if (V != 0.0f) {
                float min = R > B ? B : R;
                float delta = V - min;
                if (delta != 0.0f) {
                    S = delta / V;
                    H = 2.0f + (B - R) / delta;
                } else {
                    S = 0.0f;
                    H = 2.0f + (B - R);
                }
                H *= 60.0f;
                if (H < 0.0f) {
                    H += 360.0f;
                }
                H /= 360.0f;
            } else {
                S = 0.0f;
                H = 0.0f;
            }
        } else {
            V = R;
            if (V != 0.0f) {
                float min = G > B ? B : G;
                float delta = V - min;
                if (delta != 0.0f) {
                    S = delta / V;
                    H = (G - B) / delta;
                } else {
                    S = 0.0f;
                    H = G - B;
                }
                H *= 60.0f;
                if (H < 0.0f) {
                    H += 360.0f;
                }
                H /= 360.0f;
            } else {
                S = 0.0f;
                H = 0.0f;
            }
        }
        hsv[0] = H;
        hsv[1] = S;
        hsv[2] = V;
        return hsv;
    }

    public static MBFImage HSV_TO_RGB(MBFImage in) {
        if (in.colourSpace != ColourSpace.HSV) {
            throw new IllegalArgumentException("HSV colourspace is required");
        }
        int width = in.getWidth();
        int height = in.getHeight();
        MBFImage out = new MBFImage(width, height, ColourSpace.RGB);
        float[][] H = ((FImage)in.getBand((int)0)).pixels;
        float[][] S = ((FImage)in.getBand((int)1)).pixels;
        float[][] V = ((FImage)in.getBand((int)2)).pixels;
        float[][] R = ((FImage)out.getBand((int)0)).pixels;
        float[][] G = ((FImage)out.getBand((int)1)).pixels;
        float[][] B = ((FImage)out.getBand((int)2)).pixels;
        for (int y = 0; y < height; ++y) {
            block11: for (int x = 0; x < width; ++x) {
                if (V[y][x] == 0.0f) {
                    R[y][x] = 0.0f;
                    G[y][x] = 0.0f;
                    B[y][x] = 0.0f;
                    continue;
                }
                if (S[y][x] == 0.0f) {
                    R[y][x] = V[y][x];
                    G[y][x] = V[y][x];
                    B[y][x] = V[y][x];
                    continue;
                }
                float hf = H[y][x] * 360.0f / 60.0f;
                int i = (int)Math.floor(hf);
                float f = hf - (float)i;
                float pv = V[y][x] * (1.0f - S[y][x]);
                float qv = V[y][x] * (1.0f - S[y][x] * f);
                float tv = V[y][x] * (1.0f - S[y][x] * (1.0f - f));
                switch (i) {
                    case 0: {
                        R[y][x] = V[y][x];
                        G[y][x] = tv;
                        B[y][x] = pv;
                        continue block11;
                    }
                    case 1: {
                        R[y][x] = qv;
                        G[y][x] = V[y][x];
                        B[y][x] = pv;
                        continue block11;
                    }
                    case 2: {
                        R[y][x] = pv;
                        G[y][x] = V[y][x];
                        B[y][x] = tv;
                        continue block11;
                    }
                    case 3: {
                        R[y][x] = pv;
                        G[y][x] = qv;
                        B[y][x] = V[y][x];
                        continue block11;
                    }
                    case 4: {
                        R[y][x] = tv;
                        G[y][x] = pv;
                        B[y][x] = V[y][x];
                        continue block11;
                    }
                    case 5: {
                        R[y][x] = V[y][x];
                        G[y][x] = pv;
                        B[y][x] = qv;
                        continue block11;
                    }
                    case 6: {
                        R[y][x] = V[y][x];
                        G[y][x] = tv;
                        B[y][x] = pv;
                        continue block11;
                    }
                    case -1: {
                        R[y][x] = V[y][x];
                        G[y][x] = pv;
                        B[y][x] = qv;
                        continue block11;
                    }
                    default: {
                        System.out.println(" Unknown colour " + hf);
                    }
                }
            }
        }
        return out;
    }

    public static MBFImage H_TO_H1H2(FImage in) {
        int width = in.getWidth();
        int height = in.getHeight();
        MBFImage out = new MBFImage(width, height, ColourSpace.H1H2);
        float[][] H = in.pixels;
        float[][] H1 = ((FImage)out.getBand((int)0)).pixels;
        float[][] H2 = ((FImage)out.getBand((int)1)).pixels;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                if (H[y][x] > 0.5f) {
                    H2[y][x] = (H[y][x] - 0.5f) / 0.5f;
                    if ((double)H[y][x] > 0.75) {
                        H1[y][x] = (H[y][x] - 0.75f) / 0.5f;
                        continue;
                    }
                    H1[y][x] = 1.0f - (H[y][x] - 0.25f) / 0.5f;
                    continue;
                }
                H2[y][x] = 1.0f - H[y][x] / 0.5f;
                H1[y][x] = H[y][x] > 0.25f ? 1.0f - (H[y][x] - 0.25f) / 0.5f : 0.5f + H[y][x] / 0.5f;
            }
        }
        return out;
    }

    public static MBFImage HSV_TO_H2SV(MBFImage in) {
        if (in.colourSpace != ColourSpace.HSV) {
            throw new IllegalArgumentException("HSV colourspace is required");
        }
        MBFImage out = Transforms.H_TO_H1H2((FImage)in.getBand(0));
        out.addBand(in.getBand(1));
        out.addBand(in.getBand(2));
        return out;
    }

    public static MBFImage RGB_TO_H2SV(MBFImage in) {
        if (in.colourSpace != ColourSpace.RGB && in.colourSpace != ColourSpace.RGBA) {
            throw new IllegalArgumentException("RGB or RGBA colourspace is required");
        }
        MBFImage HSV = Transforms.RGB_TO_HSV(in);
        return Transforms.HSV_TO_H2SV(HSV);
    }

    public static MBFImage RGB_TO_H2S(MBFImage in) {
        if (in.colourSpace != ColourSpace.RGB && in.colourSpace != ColourSpace.RGBA) {
            throw new IllegalArgumentException("RGB or RGBA colourspace is required");
        }
        MBFImage H2S = Transforms.RGB_TO_H2SV(in);
        H2S.deleteBand(3);
        H2S.colourSpace = ColourSpace.H2S;
        return H2S;
    }

    public static MBFImage H_TO_H1H2_2(FImage in) {
        int width = in.getWidth();
        int height = in.getHeight();
        MBFImage out = new MBFImage(width, height, ColourSpace.H1H2_2);
        float[][] H = in.pixels;
        float[][] H1 = ((FImage)out.getBand((int)0)).pixels;
        float[][] H2 = ((FImage)out.getBand((int)1)).pixels;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                if (H[y][x] > 0.33333334f) {
                    H2[y][x] = (H[y][x] - 0.33333334f) / 0.6666667f;
                    if (H[y][x] > 0.6666667f) {
                        H1[y][x] = (H[y][x] - 0.6666667f) / 0.5f;
                        continue;
                    }
                    H1[y][x] = 1.0f - (H[y][x] - 0.16666667f) / 0.5f;
                    continue;
                }
                H2[y][x] = 1.0f - H[y][x] / 0.33333334f;
                H1[y][x] = H[y][x] > 0.16666667f ? 1.0f - (H[y][x] - 0.16666667f) / 0.5f : 0.6666667f + H[y][x] / 0.5f;
            }
        }
        return out;
    }

    public static MBFImage H2SV_TO_HSV_Simple(MBFImage in) {
        MBFImage out = new MBFImage(in.getWidth(), in.getHeight(), ColourSpace.HSV);
        float[][] H = ((FImage)out.getBand((int)0)).pixels;
        float[][] H1 = ((FImage)in.getBand((int)0)).pixels;
        float[][] H2 = ((FImage)in.getBand((int)1)).pixels;
        int width = in.getWidth();
        int height = in.getHeight();
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                if ((double)H1[y][x] > 0.5) {
                    if ((double)H2[y][x] > 0.5) {
                        H[y][x] = 0.5f * H1[y][x] - 0.25f;
                        continue;
                    }
                    H[y][x] = 0.25f + 0.5f * (1.0f - H1[y][x]);
                    continue;
                }
                H[y][x] = (double)H2[y][x] <= 0.5 ? 0.25f + 0.5f * (1.0f - H1[y][x]) : 0.75f + 0.5f * H1[y][x];
            }
        }
        out.addBand(in.getBand(2));
        out.addBand(in.getBand(3));
        return out;
    }

    public static MBFImage H2SV2_TO_HSV_Simple(MBFImage in) {
        MBFImage out = new MBFImage(in.getWidth(), in.getHeight(), ColourSpace.HSV);
        float[][] H = ((FImage)out.getBand((int)0)).pixels;
        float[][] H1 = ((FImage)in.getBand((int)0)).pixels;
        float[][] H2 = ((FImage)in.getBand((int)1)).pixels;
        int width = in.getWidth();
        int height = in.getHeight();
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                if ((double)H1[y][x] > 0.6666666666666666) {
                    if ((double)H2[y][x] > 0.5) {
                        H[y][x] = 0.5f * H1[y][x] - 0.33333334f;
                        continue;
                    }
                    H[y][x] = 0.16666667f + 0.5f * (1.0f - H1[y][x]);
                    continue;
                }
                H[y][x] = (double)H2[y][x] <= 0.5 ? 0.33333334f + 0.5f * (1.0f - H1[y][x]) : 0.6666667f + 0.5f * H1[y][x];
            }
        }
        out.addBand(in.getBand(2));
        out.addBand(in.getBand(3));
        return out;
    }

    public static MBFImage HSV_TO_H2SV_2(MBFImage in) {
        if (in.colourSpace != ColourSpace.HSV) {
            throw new IllegalArgumentException("HSV colourspace is required");
        }
        MBFImage out = Transforms.H_TO_H1H2_2((FImage)in.getBand(0));
        out.addBand(in.getBand(1));
        out.addBand(in.getBand(2));
        out.colourSpace = ColourSpace.H2SV_2;
        return out;
    }

    public static MBFImage RGB_TO_H2SV_2(MBFImage in) {
        if (in.colourSpace != ColourSpace.RGB && in.colourSpace != ColourSpace.RGBA) {
            throw new IllegalArgumentException("RGB or RGBA colourspace is required");
        }
        MBFImage HSV = Transforms.RGB_TO_HSV(in);
        return Transforms.HSV_TO_H2SV_2(HSV);
    }

    public static MBFImage RGB_TO_H2S_2(MBFImage in) {
        if (in.colourSpace != ColourSpace.RGB && in.colourSpace != ColourSpace.RGBA) {
            throw new IllegalArgumentException("RGB or RGBA colourspace is required");
        }
        MBFImage H2S = Transforms.RGB_TO_H2SV_2(in);
        H2S.deleteBand(3);
        H2S.colourSpace = ColourSpace.H2S_2;
        return H2S;
    }

    public static MBFImage RGB_TO_RGB_NORMALISED(MBFImage in) {
        int r = in.getHeight();
        int c = in.getWidth();
        MBFImage out = new MBFImage(c, r, ColourSpace.RGB_INTENSITY_NORMALISED);
        float max = (float)Math.sqrt(3.0);
        float grey = 1.0f / max;
        for (int j = 0; j < r; ++j) {
            for (int i = 0; i < c; ++i) {
                Float[] pixin = in.getPixel(i, j);
                if (pixin[0] == pixin[1] && pixin[1] == pixin[2] && (double)pixin[0].floatValue() == 0.0) {
                    out.setPixel(i, j, new Float[]{Float.valueOf(grey), Float.valueOf(grey), Float.valueOf(grey)});
                    continue;
                }
                if (pixin[0] == pixin[1] && pixin[1] == pixin[2] && (double)pixin[0].floatValue() == 1.0) {
                    out.setPixel(i, j, new Float[]{Float.valueOf(grey), Float.valueOf(grey), Float.valueOf(grey)});
                    continue;
                }
                float length = (float)Math.sqrt(pixin[0].floatValue() * pixin[0].floatValue() + pixin[1].floatValue() * pixin[1].floatValue() + pixin[2].floatValue() * pixin[2].floatValue());
                out.setPixel(i, j, new Float[]{Float.valueOf(pixin[0].floatValue() / length), Float.valueOf(pixin[1].floatValue() / length), Float.valueOf(pixin[2].floatValue() / length)});
            }
        }
        return out;
    }

    public static MBFImage RGB_TO_CIEXYZ(MBFImage in) {
        int height = in.getHeight();
        int width = in.getWidth();
        MBFImage out = new MBFImage(width, height, ColourSpace.CIE_XYZ);
        FImage Rb = (FImage)in.getBand(0);
        FImage Gb = (FImage)in.getBand(1);
        FImage Bb = (FImage)in.getBand(2);
        FImage Xb = (FImage)out.getBand(0);
        FImage Yb = (FImage)out.getBand(1);
        FImage Zb = (FImage)out.getBand(2);
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                float R = Rb.pixels[y][x];
                float G = Gb.pixels[y][x];
                float B = Bb.pixels[y][x];
                double r = (double)R <= 0.04045 ? (double)R / 12.92 : Math.pow(((double)R + 0.055) / 1.055, 2.4);
                double g = (double)G <= 0.04045 ? (double)G / 12.92 : Math.pow(((double)G + 0.055) / 1.055, 2.4);
                double b = (double)B <= 0.04045 ? (double)B / 12.92 : Math.pow(((double)B + 0.055) / 1.055, 2.4);
                Xb.pixels[y][x] = (float)(r * 0.4124564 + g * 0.3575761 + b * 0.1804375);
                Yb.pixels[y][x] = (float)(r * 0.2126729 + g * 0.7151522 + b * 0.072175);
                Zb.pixels[y][x] = (float)(r * 0.0193339 + g * 0.119192 + b * 0.9503041);
            }
        }
        return out;
    }

    public static MBFImage CIEXYZ_TO_RGB(MBFImage in) {
        return Transforms.CIEXYZ_TO_RGB(in, false);
    }

    public static MBFImage CIEXYZ_TO_RGB(MBFImage in, boolean inPlace) {
        MBFImage out;
        int height = in.getHeight();
        int width = in.getWidth();
        if (inPlace) {
            out = in;
            out.colourSpace = ColourSpace.RGB;
        } else {
            out = new MBFImage(width, height, ColourSpace.RGB);
        }
        FImage Xb = (FImage)in.getBand(0);
        FImage Yb = (FImage)in.getBand(1);
        FImage Zb = (FImage)in.getBand(2);
        FImage Rb = (FImage)out.getBand(0);
        FImage Gb = (FImage)out.getBand(1);
        FImage Bb = (FImage)out.getBand(2);
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                float X = Xb.pixels[y][x];
                float Y = Yb.pixels[y][x];
                float Z = Zb.pixels[y][x];
                double r = (double)X * 3.2404542 + (double)Y * -1.5371385 + (double)Z * -0.4985314;
                double g = (double)X * -0.969266 + (double)Y * 1.8760108 + (double)Z * 0.041556;
                double b = (double)X * 0.0556434 + (double)Y * -0.2040259 + (double)Z * 1.0572252;
                Rb.pixels[y][x] = (float)(r <= 0.0031308 ? r * 12.92 : 1.055 * Math.pow(r, 0.4166666666666667) - 0.055);
                Gb.pixels[y][x] = (float)(g <= 0.0031308 ? g * 12.92 : 1.055 * Math.pow(g, 0.4166666666666667) - 0.055);
                Bb.pixels[y][x] = (float)(b <= 0.0031308 ? b * 12.92 : 1.055 * Math.pow(b, 0.4166666666666667) - 0.055);
            }
        }
        return out;
    }

    public static MBFImage CIEXYZ_TO_CIELab(MBFImage input) {
        return Transforms.CIEXYZ_TO_CIELab(input, false);
    }

    public static MBFImage CIEXYZ_TO_CIELab(MBFImage input, boolean inPlace) {
        return Transforms.CIEXYZ_TO_CIELab(input, inPlace, false);
    }

    private static MBFImage CIEXYZ_TO_CIELab(MBFImage input, boolean inPlace, boolean norm) {
        MBFImage out;
        double epsilon = 0.008856;
        double kappa = 903.3;
        double Xr = 0.950456;
        double Yr = 1.0;
        double Zr = 1.088754;
        int height = input.getHeight();
        int width = input.getWidth();
        if (inPlace) {
            out = input;
            out.colourSpace = ColourSpace.CIE_Lab;
        } else {
            out = new MBFImage(width, height, ColourSpace.CIE_Lab);
        }
        FImage Xb = (FImage)input.getBand(0);
        FImage Yb = (FImage)input.getBand(1);
        FImage Zb = (FImage)input.getBand(2);
        FImage Lb = (FImage)out.getBand(0);
        FImage ab = (FImage)out.getBand(1);
        FImage bb = (FImage)out.getBand(2);
        float Lscale = norm ? 0.01f : 1.0f;
        float ascale = norm ? 0.00390625f : 1.0f;
        float bscale = norm ? 0.00390625f : 1.0f;
        float abdelta = norm ? 127.0f : 0.0f;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                float X = Xb.pixels[y][x];
                float Y = Yb.pixels[y][x];
                float Z = Zb.pixels[y][x];
                double xr = (double)X / 0.950456;
                double yr = (double)Y / 1.0;
                double zr = (double)Z / 1.088754;
                double fx = xr > 0.008856 ? Math.pow(xr, 0.3333333333333333) : (903.3 * xr + 16.0) / 116.0;
                double fy = yr > 0.008856 ? Math.pow(yr, 0.3333333333333333) : (903.3 * yr + 16.0) / 116.0;
                double fz = zr > 0.008856 ? Math.pow(zr, 0.3333333333333333) : (903.3 * zr + 16.0) / 116.0;
                Lb.pixels[y][x] = (float)(116.0 * fy - 16.0) * Lscale;
                ab.pixels[y][x] = ((float)(500.0 * (fx - fy)) + abdelta) * ascale;
                bb.pixels[y][x] = ((float)(200.0 * (fy - fz)) + abdelta) * bscale;
            }
        }
        return out;
    }

    public static MBFImage RGB_TO_CIELab(MBFImage input) {
        return Transforms.CIEXYZ_TO_CIELab(Transforms.RGB_TO_CIEXYZ(input), true);
    }

    public static MBFImage CIELab_TO_CIEXYZ(MBFImage input) {
        return Transforms.CIELab_TO_CIEXYZ(input, false);
    }

    private static MBFImage CIELab_TO_CIEXYZ(MBFImage input, boolean norm) {
        double epsilon = 0.008856;
        double kappa = 903.3;
        double Xr = 0.950456;
        double Yr = 1.0;
        double Zr = 1.088754;
        int height = input.getHeight();
        int width = input.getWidth();
        MBFImage out = new MBFImage(width, height, ColourSpace.CIE_XYZ);
        FImage Lb = (FImage)input.getBand(0);
        FImage ab = (FImage)input.getBand(1);
        FImage bb = (FImage)input.getBand(2);
        FImage Xb = (FImage)out.getBand(0);
        FImage Yb = (FImage)out.getBand(1);
        FImage Zb = (FImage)out.getBand(2);
        float Lscale = norm ? 100.0f : 1.0f;
        float ascale = norm ? 256.0f : 1.0f;
        float bscale = norm ? 256.0f : 1.0f;
        float abdelta = norm ? -127.0f : 0.0f;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                float L = Lb.pixels[y][x] * Lscale;
                float a = ab.pixels[y][x] * ascale + abdelta;
                float b = bb.pixels[y][x] * bscale + abdelta;
                double fy = (L + 16.0f) / 116.0f;
                double fx = (double)(a / 500.0f) + fy;
                double fz = fy - (double)(b / 200.0f);
                double fx3 = fx * fx * fx;
                double fz3 = fz * fz * fz;
                double xr = fx3 > 0.008856 ? fx3 : (116.0 * fx - 16.0) / 903.3;
                double yr = (double)L > 7.9996247999999985 ? Math.pow((L + 16.0f) / 116.0f, 3.0) : (double)L / 903.3;
                double zr = fz3 > 0.008856 ? fz3 : (116.0 * fz - 16.0) / 903.3;
                Xb.pixels[y][x] = (float)(0.950456 * xr);
                Yb.pixels[y][x] = (float)(1.0 * yr);
                Zb.pixels[y][x] = (float)(1.088754 * zr);
            }
        }
        return out;
    }

    public static MBFImage CIELab_TO_RGB(MBFImage input) {
        return Transforms.CIEXYZ_TO_RGB(Transforms.CIELab_TO_CIEXYZ(input), true);
    }

    public static MBFImage RGB_TO_CIELabNormalised(MBFImage input) {
        return Transforms.CIEXYZ_TO_CIELab(Transforms.RGB_TO_CIEXYZ(input), true, true);
    }

    public static MBFImage CIELabNormalised_TO_RGB(MBFImage input) {
        return Transforms.CIEXYZ_TO_RGB(Transforms.CIELab_TO_CIEXYZ(input, true), true);
    }

    public static MBFImage CIEXYZ_TO_CIELUV(MBFImage input) {
        return Transforms.CIEXYZ_TO_CIELUV(input, false);
    }

    public static MBFImage CIEXYZ_TO_CIELUV(MBFImage input, boolean inPlace) {
        MBFImage out;
        int width = input.getWidth();
        int height = input.getHeight();
        if (inPlace) {
            out = input;
            out.colourSpace = ColourSpace.CIE_Luv;
        } else {
            out = new MBFImage(width, height, ColourSpace.CIE_Luv);
        }
        FImage Xb = (FImage)input.getBand(0);
        FImage Yb = (FImage)input.getBand(1);
        FImage Zb = (FImage)input.getBand(2);
        FImage Lb = (FImage)out.getBand(0);
        FImage ub = (FImage)out.getBand(1);
        FImage vb = (FImage)out.getBand(2);
        double Xr = 0.950456;
        double Yr = 1.0;
        double Zr = 1.088754;
        double epsilon = 0.008856;
        double kappa = 903.3;
        for (int r = 0; r < height; ++r) {
            for (int c = 0; c < width; ++c) {
                float X = Xb.pixels[r][c];
                float Y = Yb.pixels[r][c];
                float Z = Zb.pixels[r][c];
                double yr = (double)Y / 1.0;
                float L = yr > 0.008856 ? (float)(116.0 * Math.cbrt(yr) - 16.0) : (float)(903.3 * yr);
                double up = 4.0f * X / (X + 15.0f * Y + 3.0f * Z);
                double urp = 0.1978394091129303;
                float u = (float)((double)(13.0f * L) * (up - 0.1978394091129303));
                double vp = 9.0f * Y / (X + 15.0f * Y + 3.0f * Z);
                double vrp = 0.46834220078579497;
                float v = (float)((double)(13.0f * L) * (vp - 0.46834220078579497));
                Lb.pixels[r][c] = L;
                ub.pixels[r][c] = u;
                vb.pixels[r][c] = v;
            }
        }
        return out;
    }

    public static MBFImage RGB_TO_CIELUV(MBFImage input) {
        return Transforms.CIEXYZ_TO_CIELUV(Transforms.RGB_TO_CIEXYZ(input), true);
    }

    public static MBFImage CIELUV_TO_CIEXYZ(MBFImage input) {
        double epsilon = 0.008856;
        double kappa = 903.3;
        double Xr = 0.950456;
        double Yr = 1.0;
        double Zr = 1.088754;
        int height = input.getHeight();
        int width = input.getWidth();
        MBFImage out = new MBFImage(width, height, ColourSpace.CIE_XYZ);
        FImage Lb = (FImage)input.getBand(0);
        FImage ub = (FImage)input.getBand(1);
        FImage vb = (FImage)input.getBand(2);
        FImage Xb = (FImage)out.getBand(0);
        FImage Yb = (FImage)out.getBand(1);
        FImage Zb = (FImage)out.getBand(2);
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                float L = Lb.pixels[y][x];
                float u = ub.pixels[y][x];
                float v = vb.pixels[y][x];
                double Y = (double)L > 7.9996247999999985 ? 1.0 * Math.pow((L + 16.0f) / 116.0f, 3.0) : 1.0 * (double)L / 903.3;
                double u0 = 0.19783940212891712;
                double v0 = 0.46834220078579497;
                double a = 0.3333333333333333 * ((double)(52.0f * L) / ((double)u + (double)(13.0f * L) * 0.19783940212891712) - 1.0);
                double b = -5.0 * Y;
                double c = -0.3333333333333333;
                double d = Y * ((double)(39.0f * L) / ((double)v + (double)(13.0f * L) * 0.46834220078579497) - 5.0);
                double X = (d - b) / (a - -0.3333333333333333);
                double Z = X * a + b;
                Xb.pixels[y][x] = (float)X;
                Yb.pixels[y][x] = (float)Y;
                Zb.pixels[y][x] = (float)Z;
            }
        }
        return out;
    }

    public static MBFImage CIELUV_TO_RGB(MBFImage input) {
        return Transforms.CIEXYZ_TO_RGB(Transforms.CIELUV_TO_CIEXYZ(input));
    }

    public static MBFImage RGB_TO_YUV(MBFImage input) {
        return Transforms.RGB_TO_YUV(input, false, false);
    }

    public static MBFImage RGB_TO_YUVNormalised(MBFImage input) {
        return Transforms.RGB_TO_YUV(input, false, true);
    }

    public static MBFImage RGB_TO_YUV(MBFImage input, boolean inPlace, boolean norm) {
        int width = input.getWidth();
        int height = input.getHeight();
        MBFImage out = null;
        if (inPlace) {
            out = input;
            out.colourSpace = norm ? ColourSpace.YUV_Norm : ColourSpace.YUV;
        } else {
            out = new MBFImage(width, height, norm ? ColourSpace.YUV_Norm : ColourSpace.YUV);
        }
        float[][] Rb = ((FImage)input.getBand((int)0)).pixels;
        float[][] Gb = ((FImage)input.getBand((int)1)).pixels;
        float[][] Bb = ((FImage)input.getBand((int)2)).pixels;
        float[][] Yb = ((FImage)out.getBand((int)0)).pixels;
        float[][] Ub = ((FImage)out.getBand((int)1)).pixels;
        float[][] Vb = ((FImage)out.getBand((int)2)).pixels;
        double Wr = 0.299;
        double Wb = 0.114;
        double Wg = 0.587;
        double Umax = 0.436;
        double Vmax = 0.615;
        double deltaU = norm ? -0.436 : 0.0;
        double deltaV = norm ? -0.615 : 0.0;
        double Unorm = norm ? 0.872 : 1.0;
        double Vnorm = norm ? 1.23 : 1.0;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                double R = Rb[y][x];
                double G = Gb[y][x];
                double B = Bb[y][x];
                double Y = 0.299 * R + 0.587 * G + 0.114 * B;
                double U = 0.436 * ((B - Y) / 0.886);
                double V = 0.615 * ((R - Y) / 0.7010000000000001);
                U = (U - deltaU) / Unorm;
                V = (V - deltaV) / Vnorm;
                Yb[y][x] = (float)Y;
                Ub[y][x] = (float)U;
                Vb[y][x] = (float)V;
            }
        }
        return out;
    }

    public static MBFImage YUVNormalised_TO_RGB(MBFImage input) {
        return Transforms.YUV_TO_RGB(input, false, true);
    }

    public static MBFImage YUV_TO_RGB(MBFImage input) {
        return Transforms.YUV_TO_RGB(input, false, false);
    }

    public static MBFImage YUV_TO_RGB(MBFImage input, boolean inPlace, boolean norm) {
        int width = input.getWidth();
        int height = input.getHeight();
        MBFImage out = null;
        if (inPlace) {
            out = input;
            out.colourSpace = ColourSpace.RGB;
        } else {
            out = new MBFImage(width, height, ColourSpace.RGB);
        }
        float[][] Yb = ((FImage)input.getBand((int)0)).pixels;
        float[][] Ub = ((FImage)input.getBand((int)1)).pixels;
        float[][] Vb = ((FImage)input.getBand((int)2)).pixels;
        float[][] Rb = ((FImage)out.getBand((int)0)).pixels;
        float[][] Gb = ((FImage)out.getBand((int)1)).pixels;
        float[][] Bb = ((FImage)out.getBand((int)2)).pixels;
        double Wr = 0.299;
        double Wb = 0.114;
        double Wg = 0.587;
        double Umax = 0.436;
        double Vmax = 0.615;
        double deltaU = norm ? -0.436 : 0.0;
        double deltaV = norm ? -0.615 : 0.0;
        double Unorm = norm ? 0.872 : 1.0;
        double Vnorm = norm ? 1.23 : 1.0;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                double Y = Yb[y][x];
                double U = (double)Ub[y][x] * Unorm + deltaU;
                double V = (double)Vb[y][x] * Vnorm + deltaV;
                double R = Y + V * 1.1398373983739838;
                double G = Y - U * 0.3946517043589704 - V * 0.5805986066674977;
                double B = Y + U * 2.032110091743119;
                Rb[y][x] = (float)R;
                Gb[y][x] = (float)G;
                Bb[y][x] = (float)B;
            }
        }
        return out;
    }

    public static double[] kelvinToRGB(double temperature) {
        temperature /= 100.0;
        double r = 0.0;
        if (temperature <= 66.0) {
            r = 255.0;
        } else {
            r = temperature - 60.0;
            if ((r = 329.698727446 * Math.pow(r, -0.1332047592)) < 0.0) {
                r = 0.0;
            }
            if (r > 255.0) {
                r = 255.0;
            }
        }
        double g = 0.0;
        if (temperature <= 66.0) {
            g = temperature;
            if ((g = 99.4708025861 * Math.log(g) - 161.1195681661) < 0.0) {
                g = 0.0;
            }
            if (g > 255.0) {
                g = 255.0;
            }
        } else {
            g = temperature - 60.0;
            if ((g = 288.1221695283 * Math.pow(g, -0.0755148492)) < 0.0) {
                g = 0.0;
            }
            if (g > 255.0) {
                g = 255.0;
            }
        }
        double b = 0.0;
        if (temperature >= 66.0) {
            b = 255.0;
        } else if (temperature <= 19.0) {
            b = 0.0;
        } else {
            b = temperature - 10.0;
            if ((b = 138.5177312231 * Math.log(b) - 305.0447927307) < 0.0) {
                b = 0.0;
            }
            if (b > 255.0) {
                b = 255.0;
            }
        }
        return new double[]{r / 255.0, g / 255.0, b / 255.0};
    }

    public static MBFImage colourTemperatureCorrection(MBFImage image, double colourTemperature, double strength) {
        if (image.colourSpace != ColourSpace.RGB) {
            throw new IllegalArgumentException("Colour correction only available for RGB images. Try using the colour transforms to convert to RGB.");
        }
        double[] rgb = Transforms.kelvinToRGB(colourTemperature);
        float[] pix = new float[image.numBands()];
        float[] oPix = new float[image.numBands()];
        for (int y = 0; y < image.getHeight(); ++y) {
            for (int x = 0; x < image.getWidth(); ++x) {
                int b;
                for (b = 0; b < image.numBands(); ++b) {
                    float f;
                    oPix[b] = f = ((FImage)image.getBand((int)b)).pixels[y][x];
                    pix[b] = f = (float)((double)f * strength + rgb[b] * (1.0 - strength));
                }
                Transforms.RGB_TO_HSL(pix, pix);
                pix[2] = (ArrayUtils.maxValue((float[])oPix) + ArrayUtils.minValue((float[])oPix)) / 2.0f;
                Transforms.HSL_TO_RGB(pix, pix);
                for (b = 0; b < image.numBands(); ++b) {
                    ((FImage)image.getBand((int)b)).pixels[y][x] = pix[b];
                }
            }
        }
        return image;
    }
}

