/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image;

import org.openimaj.image.Image;
import org.openimaj.image.processor.KernelProcessor;
import org.openimaj.image.processor.SinglebandImageProcessor;
import org.openimaj.image.processor.SinglebandKernelProcessor;

public abstract class SingleBandImage<Q extends Comparable<Q>, I extends SingleBandImage<Q, I>>
extends Image<Q, I>
implements SinglebandImageProcessor.Processable<Q, I, I>,
SinglebandKernelProcessor.Processable<Q, I, I> {
    private static final long serialVersionUID = 1L;
    public int height;
    public int width;

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public I process(KernelProcessor<Q, I> p) {
        return (I)this.process((KernelProcessor)p, false);
    }

    @Override
    public I process(KernelProcessor<Q, I> p, boolean pad) {
        SingleBandImage newImage = (SingleBandImage)this.newInstance(this.width, this.height);
        SingleBandImage tmp = (SingleBandImage)this.newInstance(p.getKernelWidth(), p.getKernelHeight());
        int hh = p.getKernelHeight() / 2;
        int hw = p.getKernelWidth() / 2;
        if (!pad) {
            for (int y = hh; y < this.getHeight() - (p.getKernelHeight() - hh); ++y) {
                for (int x = hw; x < this.getWidth() - (p.getKernelWidth() - hw); ++x) {
                    newImage.setPixel(x, y, p.processKernel(this.extractROI(x, y, tmp)));
                }
            }
        } else {
            for (int y = 0; y < this.getHeight(); ++y) {
                for (int x = 0; x < this.getWidth(); ++x) {
                    newImage.setPixel(x, y, p.processKernel(this.extractROI(x, y, tmp)));
                }
            }
        }
        return (I)newImage;
    }

    @Override
    public I process(SinglebandKernelProcessor<Q, I> p) {
        return (I)this.process((SinglebandKernelProcessor)p, false);
    }

    @Override
    public I process(SinglebandKernelProcessor<Q, I> p, boolean pad) {
        SingleBandImage newImage = (SingleBandImage)this.newInstance(this.width, this.height);
        SingleBandImage tmp = (SingleBandImage)this.newInstance(p.getKernelWidth(), p.getKernelHeight());
        int hh = p.getKernelHeight() / 2;
        int hw = p.getKernelWidth() / 2;
        if (!pad) {
            for (int y = hh; y < this.getHeight() - (p.getKernelHeight() - hh); ++y) {
                for (int x = hw; x < this.getWidth() - (p.getKernelWidth() - hw); ++x) {
                    newImage.setPixel(x, y, p.processKernel(this.extractROI(x, y, tmp)));
                }
            }
        } else {
            for (int y = 0; y < this.getHeight(); ++y) {
                for (int x = 0; x < this.getWidth(); ++x) {
                    newImage.setPixel(x, y, p.processKernel(this.extractROI(x, y, tmp)));
                }
            }
        }
        return (I)newImage;
    }

    @Override
    public I processInplace(SinglebandKernelProcessor<Q, I> p) {
        return (I)this.processInplace((SinglebandKernelProcessor)p, false);
    }

    @Override
    public I processInplace(SinglebandKernelProcessor<Q, I> p, boolean pad) {
        Image newImage = this.process((SinglebandKernelProcessor)p, pad);
        this.internalAssign(newImage);
        return (I)this;
    }

    @Override
    public I process(SinglebandImageProcessor<Q, I> p) {
        Image newImage = this.clone();
        ((SingleBandImage)newImage).processInplace((SinglebandImageProcessor)p);
        return (I)newImage;
    }

    @Override
    public I processInplace(SinglebandImageProcessor<Q, I> p) {
        p.processImage(this);
        return (I)this;
    }

    @Override
    public I fill(Q colour) {
        for (int y = 0; y < this.getHeight(); ++y) {
            for (int x = 0; x < this.getWidth(); ++x) {
                this.setPixel(x, y, colour);
            }
        }
        return (I)this;
    }

    @Override
    public abstract I clone();

    public boolean equals(Object obj) {
        SingleBandImage that = (SingleBandImage)obj;
        for (int y = 0; y < this.getHeight(); ++y) {
            for (int x = 0; x < this.getWidth(); ++x) {
                boolean fail;
                boolean bl = fail = !((Comparable)this.getPixel(x, y)).equals(that.getPixel(x, y));
                if (!fail) continue;
                return false;
            }
        }
        return true;
    }
}

