/*
 * Decompiled with CFR 0.152.
 */
package org.tinfour.voronoi;

import java.awt.geom.Rectangle2D;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.tinfour.common.Circumcircle;
import org.tinfour.common.IIncrementalTin;
import org.tinfour.common.IQuadEdge;
import org.tinfour.common.Vertex;
import org.tinfour.edge.EdgePool;
import org.tinfour.edge.QuadEdge;
import org.tinfour.utils.TinInstantiationUtility;
import org.tinfour.utils.Tincalc;
import org.tinfour.utils.VertexColorizerKempe6;
import org.tinfour.voronoi.BoundedVoronoiBuildOptions;
import org.tinfour.voronoi.PerimeterVertex;
import org.tinfour.voronoi.ThiessenPolygon;

public class BoundedVoronoiDiagram {
    private final Rectangle2D bounds;
    double xmin;
    double xmax;
    double ymin;
    double ymax;
    private final Rectangle2D sampleBounds;
    private final EdgePool edgePool;
    private final List<Vertex> circleList = new ArrayList<Vertex>();
    private final List<ThiessenPolygon> polygons = new ArrayList<ThiessenPolygon>();
    private double maxRadius = -1.0;

    private BoundedVoronoiDiagram() {
        this.sampleBounds = null;
        this.bounds = null;
        this.edgePool = null;
    }

    public BoundedVoronoiDiagram(List<Vertex> vertexList, BoundedVoronoiBuildOptions options) {
        if (vertexList == null) {
            throw new IllegalArgumentException("Null input not allowed for constructor");
        }
        int nVertices = vertexList.size();
        if (nVertices < 3) {
            throw new IllegalArgumentException("Insufficent input size, at least 3 vertices are required");
        }
        this.sampleBounds = new Rectangle2D.Double(vertexList.get(0).getX(), vertexList.get(0).getY(), 0.0, 0.0);
        for (Vertex v : vertexList) {
            this.sampleBounds.add(v.getX(), v.getY());
        }
        double area = this.sampleBounds.getWidth() * this.sampleBounds.getHeight();
        double nominalPointSpacing = Tincalc.sampleSpacing(area, nVertices);
        TinInstantiationUtility maker = new TinInstantiationUtility(0.25, vertexList.size());
        IIncrementalTin tin = maker.constructInstance(nominalPointSpacing);
        tin.add(vertexList, null);
        if (!tin.isBootstrapped()) {
            throw new IllegalArgumentException("Input vertex geometry is insufficient to establish a Voronoi Diagram");
        }
        this.bounds = new Rectangle2D.Double(this.sampleBounds.getX(), this.sampleBounds.getY(), this.sampleBounds.getWidth(), this.sampleBounds.getHeight());
        this.edgePool = new EdgePool();
        BoundedVoronoiBuildOptions pOptions = options;
        if (options == null) {
            pOptions = new BoundedVoronoiBuildOptions();
        }
        this.buildStructure(tin, pOptions);
        if (pOptions.enableAutomaticColorAssignment) {
            VertexColorizerKempe6 kempe6 = new VertexColorizerKempe6();
            kempe6.assignColorsToVertices(tin);
        }
        tin.dispose();
    }

    public BoundedVoronoiDiagram(IIncrementalTin delaunayTriangulation) {
        if (delaunayTriangulation == null) {
            throw new IllegalArgumentException("Null input is not allowed for TIN");
        }
        this.sampleBounds = delaunayTriangulation.getBounds();
        if (!delaunayTriangulation.isBootstrapped() || this.sampleBounds == null) {
            throw new IllegalArgumentException("Input TIN is not bootstrapped (populated)");
        }
        this.bounds = new Rectangle2D.Double(this.sampleBounds.getX(), this.sampleBounds.getY(), this.sampleBounds.getWidth(), this.sampleBounds.getHeight());
        this.edgePool = new EdgePool();
        BoundedVoronoiBuildOptions pOptions = new BoundedVoronoiBuildOptions();
        this.buildStructure(delaunayTriangulation, pOptions);
    }

    private void buildPart(IQuadEdge e, Vertex[] center, IQuadEdge[] part) {
        int outcode1;
        IQuadEdge d = e.getDual();
        int eIndex = e.getIndex();
        int dIndex = d.getIndex();
        Vertex v0 = center[dIndex];
        Vertex v1 = center[eIndex];
        if (v0 == null || v1 == null) {
            return;
        }
        int outcode0 = v0.getAuxiliaryIndex();
        if ((outcode0 & (outcode1 = v1.getAuxiliaryIndex())) != 0) {
            return;
        }
        if ((outcode0 | outcode1) == 0) {
            QuadEdge n = this.edgePool.allocateEdge(v0, v1);
            part[eIndex] = n;
            part[dIndex] = n.getDual();
            return;
        }
        IQuadEdge n = this.liangBarsky(v0, v1);
        if (n != null) {
            part[eIndex] = n;
            part[dIndex] = n.getDual();
        }
    }

    private IQuadEdge liangBarsky(Vertex v0, Vertex v1) {
        Vertex p1;
        double z;
        double y;
        double x;
        Vertex p0;
        double x0 = v0.getX();
        double y0 = v0.getY();
        double x1 = v1.getX();
        double y1 = v1.getY();
        double t0 = 0.0;
        double t1 = 1.0;
        int iBorder0 = -1;
        int iBorder1 = -1;
        double xDelta = x1 - x0;
        double yDelta = y1 - y0;
        for (int iBorder = 0; iBorder < 4; ++iBorder) {
            double q;
            double p;
            switch (iBorder) {
                case 0: {
                    p = -yDelta;
                    q = -(this.ymin - y0);
                    break;
                }
                case 1: {
                    p = xDelta;
                    q = this.xmax - x0;
                    break;
                }
                case 2: {
                    p = yDelta;
                    q = this.ymax - y0;
                    break;
                }
                default: {
                    p = -xDelta;
                    q = -(this.xmin - x0);
                }
            }
            if (p == 0.0) {
                if (!(q < 0.0)) continue;
                return null;
            }
            double r = q / p;
            if (p < 0.0) {
                if (r > t1) {
                    return null;
                }
                if (!(r > t0)) continue;
                t0 = r;
                iBorder0 = iBorder;
                continue;
            }
            if (r < t0) {
                return null;
            }
            if (!(r < t1)) continue;
            t1 = r;
            iBorder1 = iBorder;
        }
        if (iBorder0 == -1) {
            p0 = v0;
        } else {
            x = x0 + t0 * xDelta;
            y = y0 + t0 * yDelta;
            z = this.computePerimeterParameter(iBorder0, x, y);
            p0 = new PerimeterVertex(x, y, z, v0.getIndex());
            p0.setSynthetic(true);
        }
        if (iBorder1 == -1) {
            p1 = v1;
        } else {
            x = x0 + t1 * xDelta;
            y = y0 + t1 * yDelta;
            z = this.computePerimeterParameter(iBorder1, x, y);
            p1 = new PerimeterVertex(x, y, z, v1.getIndex());
            p1.setSynthetic(true);
        }
        return this.edgePool.allocateEdge(p0, p1);
    }

    private double computePerimeterParameter(double x, double y) {
        if (y == this.ymin) {
            if (this.xmin <= x && x <= this.xmax) {
                return (x - this.xmin) / (this.xmax - this.xmin);
            }
        } else if (x == this.xmax) {
            if (this.ymin <= y && y <= this.ymax) {
                return 1.0 + (y - this.ymin) / (this.ymax - this.ymin);
            }
        } else if (y == this.ymax) {
            if (this.xmin <= x && x <= this.xmax) {
                return 3.0 - (x - this.xmin) / (this.xmax - this.xmin);
            }
        } else if (x == this.xmin && this.ymin <= y && y <= this.ymin) {
            return 4.0 - (y - this.ymin) / (this.ymax - this.ymin);
        }
        return Double.NaN;
    }

    private double computePerimeterParameter(int iBoarder, double x, double y) {
        switch (iBoarder) {
            case 0: {
                return (x - this.xmin) / (this.xmax - this.xmin);
            }
            case 1: {
                return 1.0 + (y - this.ymin) / (this.ymax - this.ymin);
            }
            case 2: {
                return 3.0 - (x - this.xmin) / (this.xmax - this.xmin);
            }
        }
        return 4.0 - (y - this.ymin) / (this.ymax - this.ymin);
    }

    private int insertRayVertex(int nBuild, Vertex[] vBuild, double[] tBuild, double t, Vertex v) {
        int index = nBuild;
        int i = nBuild - 1;
        while (i >= 0 && t < tBuild[i]) {
            tBuild[i + 1] = tBuild[i];
            vBuild[i + 1] = vBuild[i];
            index = i--;
        }
        tBuild[index] = t;
        vBuild[index] = v;
        return nBuild + 1;
    }

    private void buildPerimeterRay(IQuadEdge e, Vertex[] center, IQuadEdge[] part) {
        PerimeterVertex v;
        double z;
        double t;
        int index = e.getIndex();
        Vertex vCenter = center[index];
        Vertex A = e.getA();
        Vertex B = e.getB();
        double x0 = this.bounds.getMinX();
        double x1 = this.bounds.getMaxX();
        double y0 = this.bounds.getMinY();
        double y1 = this.bounds.getMaxY();
        int nBuild = 0;
        double[] tBuild = new double[5];
        Vertex[] vBuild = new Vertex[5];
        int outcode = vCenter.getAuxiliaryIndex();
        if (outcode == 0) {
            vBuild[0] = vCenter;
            tBuild[0] = 0.0;
            nBuild = 1;
        }
        double eX = B.getX() - A.getX();
        double eY = B.getY() - A.getY();
        double u = Math.sqrt(eX * eX + eY * eY);
        double uX = eY / u;
        double uY = -eX / u;
        double cX = vCenter.getX();
        double cY = vCenter.getY();
        if (uX != 0.0) {
            t = (x0 - cX) / uX;
            double y = t * uY + cY;
            if (t >= 0.0 && y0 <= y && y <= y1) {
                z = 4.0 - (y - y0) / (y1 - y0);
                v = new PerimeterVertex(x0, y, z, -vCenter.getIndex());
                nBuild = this.insertRayVertex(nBuild, vBuild, tBuild, t, v);
            }
            t = (x1 - cX) / uX;
            y = t * uY + cY;
            if (t >= 0.0 && y0 <= y && y <= y1) {
                z = 1.0 + (y - y0) / (y1 - y0);
                v = new PerimeterVertex(x1, y, z, -vCenter.getIndex());
                nBuild = this.insertRayVertex(nBuild, vBuild, tBuild, t, v);
            }
        }
        if (uY != 0.0) {
            t = (y0 - cY) / uY;
            double x = t * uX + cX;
            if (t >= 0.0 && x0 <= x && x <= x1) {
                z = (x - x0) / (x1 - x0);
                v = new PerimeterVertex(x, y0, z, -vCenter.getIndex());
                nBuild = this.insertRayVertex(nBuild, vBuild, tBuild, t, v);
            }
            t = (y1 - cY) / uY;
            x = t * uX + cX;
            if (t >= 0.0 && x0 <= x && x <= x1) {
                z = 3.0 - (x - x0) / (x1 - x0);
                v = new PerimeterVertex(x, y1, z, -vCenter.getIndex());
                nBuild = this.insertRayVertex(nBuild, vBuild, tBuild, t, v);
            }
        }
        if (nBuild >= 2) {
            QuadEdge n = this.edgePool.allocateEdge(vBuild[1], vBuild[0]);
            part[index] = n;
            part[index ^ 1] = n.getDual();
        }
    }

    private void computeAndSetOutcode(Vertex c) {
        double x = c.getX();
        double y = c.getY();
        int code = x <= this.xmin ? 1 : (x >= this.xmax ? 2 : 0);
        if (y <= this.ymin) {
            code |= 4;
        } else if (y >= this.ymax) {
            code |= 8;
        }
        c.setAuxiliaryIndex(code);
    }

    private int mindex(IQuadEdge e, IQuadEdge f, IQuadEdge r) {
        int index = e.getIndex();
        if (f.getIndex() < index) {
            index = f.getIndex();
        }
        if (r.getIndex() < index) {
            return r.getIndex();
        }
        return index;
    }

    private void buildCenter(Circumcircle cCircle, IQuadEdge e, Vertex[] centers) {
        int index = e.getIndex();
        if (centers[index] == null) {
            Vertex A = e.getA();
            Vertex B = e.getB();
            IQuadEdge f = e.getForward();
            IQuadEdge r = e.getReverse();
            Vertex C = e.getForward().getB();
            if (C != null) {
                double y;
                if (!cCircle.compute(A, B, C)) {
                    throw new IllegalStateException("Internal error, triangle does not yield circumcircle");
                }
                double x = cCircle.getX();
                double z = this.computePerimeterParameter(x, y = cCircle.getY());
                Vertex v = Double.isNaN(z) ? new Vertex(x, y, z, this.mindex(e, f, r)) : new PerimeterVertex(x, y, z, this.mindex(e, f, r));
                centers[e.getIndex()] = v;
                centers[f.getIndex()] = v;
                centers[r.getIndex()] = v;
                this.circleList.add(v);
                double radius = cCircle.getRadius();
                if (radius > this.maxRadius) {
                    this.maxRadius = radius;
                }
                this.bounds.add(x, y);
            }
        }
    }

    private void buildStructure(IIncrementalTin tin, BoundedVoronoiBuildOptions pOptions) {
        Object e;
        int maxEdgeIndex = tin.getMaximumEdgeAllocationIndex() + 1;
        boolean[] visited = new boolean[maxEdgeIndex];
        Vertex[] centers = new Vertex[maxEdgeIndex];
        IQuadEdge[] parts = new QuadEdge[maxEdgeIndex];
        ArrayList<IQuadEdge> scratch = new ArrayList<IQuadEdge>();
        List<IQuadEdge> perimeter = tin.getPerimeter();
        Circumcircle cCircle = new Circumcircle();
        Iterator<IQuadEdge> edgeIterator = tin.getEdgeIterator();
        double sumEdgeLength = 0.0;
        int nEdgeLength = 0;
        while (edgeIterator.hasNext()) {
            IQuadEdge e2 = edgeIterator.next();
            if (e2.getA() == null || e2.getB() == null) {
                int index = e2.getIndex();
                visited[index] = true;
                visited[index ^ 1] = true;
                continue;
            }
            sumEdgeLength += e2.getLength();
            ++nEdgeLength;
            this.buildCenter(cCircle, e2, centers);
            this.buildCenter(cCircle, e2.getDual(), centers);
        }
        if (pOptions.bounds == null) {
            double avgLen = nEdgeLength == 0 ? 0.0 : sumEdgeLength / (double)nEdgeLength;
            this.xmin = this.sampleBounds.getMinX() - avgLen / 4.0;
            this.xmax = this.sampleBounds.getMaxX() + avgLen / 4.0;
            this.ymin = this.sampleBounds.getMinY() - avgLen / 4.0;
            this.ymax = this.sampleBounds.getMaxY() + avgLen / 4.0;
            this.bounds.setRect(this.xmin, this.ymin, this.xmax - this.xmin, this.ymax - this.ymin);
        } else {
            if (!pOptions.bounds.contains(this.sampleBounds)) {
                throw new IllegalArgumentException("Optional bounds specification does not entirely contain the sample set");
            }
            this.xmin = pOptions.bounds.getMinX();
            this.xmax = pOptions.bounds.getMaxX();
            this.ymin = pOptions.bounds.getMinY();
            this.ymax = pOptions.bounds.getMaxY();
            this.bounds.setRect(this.xmin, this.ymin, this.xmax - this.xmin, this.ymax - this.ymin);
        }
        for (Vertex circumcircle : this.circleList) {
            this.computeAndSetOutcode(circumcircle);
        }
        for (IQuadEdge p : perimeter) {
            visited[p.getIndex()] = true;
            this.buildPerimeterRay(p, centers, parts);
        }
        edgeIterator = tin.getEdgeIterator();
        while (edgeIterator.hasNext()) {
            e = edgeIterator.next();
            IQuadEdge d = e.getDual();
            int eIndex = e.getIndex();
            int dIndex = d.getIndex();
            if (visited[eIndex]) continue;
            visited[eIndex] = true;
            visited[dIndex] = true;
            this.buildPart((IQuadEdge)e, centers, parts);
        }
        Arrays.fill(visited, false);
        for (IQuadEdge e3 : perimeter) {
            IQuadEdge f = e3.getForwardFromDual();
            int index = f.getIndex();
            visited[index] = true;
            visited[index ^ 1] = true;
        }
        for (IQuadEdge e4 : perimeter) {
            int index = e4.getIndex();
            if (visited[index]) continue;
            this.buildPolygon(e4, visited, (QuadEdge[])parts, scratch);
        }
        edgeIterator = tin.getEdgeIterator();
        while (edgeIterator.hasNext()) {
            e = edgeIterator.next();
            int index = e.getIndex();
            Vertex hub = e.getA();
            if (hub == null) {
                visited[index] = true;
            } else if (!visited[index]) {
                this.buildPolygon((IQuadEdge)e, visited, (QuadEdge[])parts, scratch);
            }
            IQuadEdge d = e.getDual();
            index = d.getIndex();
            hub = d.getA();
            if (hub == null) {
                visited[index] = true;
                continue;
            }
            if (visited[index]) continue;
            this.buildPolygon(d, visited, (QuadEdge[])parts, scratch);
        }
    }

    private void buildPolygon(IQuadEdge e, boolean[] visited, QuadEdge[] parts, List<IQuadEdge> scratch) {
        scratch.clear();
        QuadEdge prior = null;
        QuadEdge first = null;
        boolean ghostEdgeFound = false;
        Vertex hub = e.getA();
        for (IQuadEdge p : e.pinwheel()) {
            QuadEdge q;
            int index = p.getIndex();
            visited[index] = true;
            if (p.getB() == null) {
                ghostEdgeFound = true;
            }
            if ((q = parts[p.getIndex()]) == null) continue;
            if (first == null) {
                first = q;
                prior = q;
                continue;
            }
            this.linkEdges(prior, q, scratch);
            prior = q;
        }
        if (prior == null && first == null) {
            return;
        }
        this.linkEdges(prior, first, scratch);
        this.polygons.add(new ThiessenPolygon(hub, scratch, ghostEdgeFound));
    }

    private void linkEdges(QuadEdge xprior, QuadEdge q, List<IQuadEdge> scratch) {
        QuadEdge prior = xprior;
        Vertex v0 = prior.getB();
        Vertex v1 = q.getA();
        double z0 = v0.getZ();
        double z1 = v1.getZ();
        if (Double.isNaN(z0)) {
            scratch.add(q);
            prior.setForward(q);
            return;
        }
        double test = Math.abs(z0 - z1);
        if (test < 1.0E-9 || test > 3.999999999) {
            scratch.add(q);
            prior.setForward(q);
            return;
        }
        int iFirst = (int)z1;
        int iLast = (int)z0;
        if (iFirst < iLast) {
            iFirst += 4;
        }
        for (int i = iLast + 1; i <= iFirst; ++i) {
            double y;
            double x;
            int iCorner = i & 3;
            switch (iCorner) {
                case 0: {
                    x = this.xmin;
                    y = this.ymin;
                    break;
                }
                case 1: {
                    x = this.xmax;
                    y = this.ymin;
                    break;
                }
                case 2: {
                    x = this.xmax;
                    y = this.ymax;
                    break;
                }
                default: {
                    x = this.xmin;
                    y = this.ymax;
                }
            }
            Vertex v = new Vertex(x, y, Double.NaN, iCorner);
            v.setSynthetic(true);
            QuadEdge n = this.edgePool.allocateEdge(v0, v);
            n.setSynthetic(true);
            v0 = v;
            scratch.add(n);
            n.setReverse(prior);
            prior = n;
        }
        QuadEdge n = this.edgePool.allocateEdge(v0, v1);
        n.setSynthetic(true);
        scratch.add(n);
        scratch.add(q);
        n.setReverse(prior);
        q.setReverse(n);
    }

    public void printDiagnostics(PrintStream ps) {
        int nClosed = 0;
        double sumArea = 0.0;
        for (ThiessenPolygon p : this.polygons) {
            double a = p.getArea();
            if (Double.isInfinite(a)) continue;
            sumArea += a;
            ++nClosed;
        }
        int nOpen = this.polygons.size() - nClosed;
        double avgArea = sumArea / (double)(nClosed > 0 ? nClosed : 1);
        ps.format("Bounded Voronoi Diagram%n", new Object[0]);
        ps.format("   Polygons:   %8d%n", this.polygons.size());
        ps.format("     Open:     %8d%n", nOpen);
        ps.format("     Closed:   %8d%n", nClosed);
        ps.format("     Avg Area: %13.4f%n", avgArea);
        ps.format("   Vertices:   %8d%n", this.circleList.size());
        ps.format("   Edges:      %8d%n", this.edgePool.size());
        ps.format("   Voronoi Bounds%n", new Object[0]);
        ps.format("      x min:  %16.4f%n", this.bounds.getMinX());
        ps.format("      y min:  %16.4f%n", this.bounds.getMinY());
        ps.format("      x max:  %16.4f%n", this.bounds.getMaxX());
        ps.format("      y max:  %16.4f%n", this.bounds.getMaxY());
        ps.format("   Max Circumcircle Radius:  %6.4f%n", this.maxRadius);
        ps.format("   Data Sample Bounds%n", new Object[0]);
        ps.format("      x min:  %16.4f%n", this.sampleBounds.getMinX());
        ps.format("      y min:  %16.4f%n", this.sampleBounds.getMinY());
        ps.format("      x max:  %16.4f%n", this.sampleBounds.getMaxX());
        ps.format("      y max:  %16.4f%n", this.sampleBounds.getMaxY());
    }

    public Rectangle2D getBounds() {
        return new Rectangle2D.Double(this.bounds.getX(), this.bounds.getY(), this.bounds.getWidth(), this.bounds.getHeight());
    }

    public Rectangle2D getSampleBounds() {
        return new Rectangle2D.Double(this.sampleBounds.getX(), this.sampleBounds.getY(), this.sampleBounds.getWidth(), this.sampleBounds.getHeight());
    }

    public List<IQuadEdge> getEdges() {
        return this.edgePool.getEdges();
    }

    public List<Vertex> getVertices() {
        ArrayList<Vertex> vList = new ArrayList<Vertex>(this.polygons.size());
        for (ThiessenPolygon p : this.polygons) {
            vList.add(p.getVertex());
        }
        return vList;
    }

    public List<Vertex> getVoronoiVertices() {
        ArrayList<Vertex> list = new ArrayList<Vertex>(this.circleList.size());
        list.addAll(this.circleList);
        return list;
    }

    public List<ThiessenPolygon> getPolygons() {
        ArrayList<ThiessenPolygon> list = new ArrayList<ThiessenPolygon>(this.polygons.size());
        list.addAll(this.polygons);
        return list;
    }

    public ThiessenPolygon getContainingPolygon(double x, double y) {
        ThiessenPolygon minP = null;
        if (this.bounds.contains(x, y)) {
            double minD = Double.POSITIVE_INFINITY;
            for (ThiessenPolygon p : this.polygons) {
                Vertex v = p.getVertex();
                double d = v.getDistanceSq(x, y);
                if (!(d < minD)) continue;
                minD = d;
                minP = p;
            }
        }
        return minP;
    }

    public int getMaximumEdgeAllocationIndex() {
        return this.edgePool.getMaximumAllocationIndex();
    }
}

