package rbd

import (
	"github.com/stretchr/testify/assert"
	"testing"
)

func TestRbdOptions(t *testing.T) {
	var i uint64
	var s string
	var err error

	options := NewRbdImageOptions()
	defer options.Destroy()

	err = options.SetUint64(ImageOptionFormat, 1)
	assert.NoError(t, err)
	err = options.SetString(ImageOptionFormat, "string not allowed")
	assert.Error(t, err)
	i, err = options.GetUint64(ImageOptionFormat)
	assert.NoError(t, err)
	assert.True(t, i == 1)
	_, err = options.GetString(ImageOptionFormat)
	assert.Error(t, err)
	set, err := options.IsSet(ImageOptionFormat)
	assert.NoError(t, err)
	assert.True(t, set)
	err = options.Unset(ImageOptionFormat)
	assert.NoError(t, err)

	err = options.SetUint64(ImageOptionFeatures, 1)
	assert.NoError(t, err)
	err = options.SetString(ImageOptionFeatures, "string not allowed")
	assert.Error(t, err)
	i, err = options.GetUint64(ImageOptionFeatures)
	assert.NoError(t, err)
	assert.True(t, i == 1)
	_, err = options.GetString(ImageOptionFeatures)
	assert.Error(t, err)
	set, err = options.IsSet(ImageOptionFeatures)
	assert.NoError(t, err)
	assert.True(t, set)
	err = options.Unset(ImageOptionFeatures)
	assert.NoError(t, err)

	err = options.SetUint64(ImageOptionOrder, 1)
	assert.NoError(t, err)
	err = options.SetString(ImageOptionOrder, "string not allowed")
	assert.Error(t, err)
	i, err = options.GetUint64(ImageOptionOrder)
	assert.NoError(t, err)
	assert.True(t, i == 1)
	_, err = options.GetString(ImageOptionOrder)
	assert.Error(t, err)
	set, err = options.IsSet(ImageOptionOrder)
	assert.NoError(t, err)
	assert.True(t, set)
	err = options.Unset(ImageOptionOrder)
	assert.NoError(t, err)

	err = options.SetUint64(ImageOptionStripeUnit, 1)
	assert.NoError(t, err)
	err = options.SetString(ImageOptionStripeUnit, "string not allowed")
	assert.Error(t, err)
	i, err = options.GetUint64(ImageOptionStripeUnit)
	assert.NoError(t, err)
	assert.True(t, i == 1)
	_, err = options.GetString(ImageOptionStripeUnit)
	assert.Error(t, err)
	set, err = options.IsSet(ImageOptionStripeUnit)
	assert.NoError(t, err)
	assert.True(t, set)
	err = options.Unset(ImageOptionStripeUnit)
	assert.NoError(t, err)

	err = options.SetUint64(ImageOptionStripeCount, 1)
	assert.NoError(t, err)
	err = options.SetString(ImageOptionStripeCount, "string not allowed")
	assert.Error(t, err)
	i, err = options.GetUint64(ImageOptionStripeCount)
	assert.NoError(t, err)
	assert.True(t, i == 1)
	_, err = options.GetString(ImageOptionStripeCount)
	assert.Error(t, err)
	set, err = options.IsSet(ImageOptionStripeCount)
	assert.NoError(t, err)
	assert.True(t, set)
	err = options.Unset(ImageOptionStripeCount)
	assert.NoError(t, err)

	err = options.SetUint64(ImageOptionJournalOrder, 1)
	assert.NoError(t, err)
	err = options.SetString(ImageOptionJournalOrder, "string not allowed")
	assert.Error(t, err)
	i, err = options.GetUint64(ImageOptionJournalOrder)
	assert.NoError(t, err)
	assert.True(t, i == 1)
	_, err = options.GetString(ImageOptionJournalOrder)
	assert.Error(t, err)
	set, err = options.IsSet(ImageOptionJournalOrder)
	assert.NoError(t, err)
	assert.True(t, set)
	err = options.Unset(ImageOptionJournalOrder)
	assert.NoError(t, err)

	err = options.SetUint64(ImageOptionJournalSplayWidth, 1)
	assert.NoError(t, err)
	err = options.SetString(ImageOptionJournalSplayWidth, "string not allowed")
	assert.Error(t, err)
	i, err = options.GetUint64(ImageOptionJournalSplayWidth)
	assert.NoError(t, err)
	assert.True(t, i == 1)
	_, err = options.GetString(ImageOptionJournalSplayWidth)
	assert.Error(t, err)
	set, err = options.IsSet(ImageOptionJournalSplayWidth)
	assert.NoError(t, err)
	assert.True(t, set)
	err = options.Unset(ImageOptionJournalSplayWidth)
	assert.NoError(t, err)

	err = options.SetUint64(ImageOptionJournalPool, 1)
	assert.Error(t, err)
	err = options.SetString(ImageOptionJournalPool, "journal")
	assert.NoError(t, err)
	_, err = options.GetUint64(ImageOptionJournalPool)
	assert.Error(t, err)
	s, err = options.GetString(ImageOptionJournalPool)
	assert.NoError(t, err)
	assert.True(t, s == "journal")
	set, err = options.IsSet(ImageOptionJournalPool)
	assert.NoError(t, err)
	assert.True(t, set)
	err = options.Unset(ImageOptionJournalPool)
	assert.NoError(t, err)

	err = options.SetUint64(ImageOptionFeaturesSet, 1)
	assert.NoError(t, err)
	err = options.SetString(ImageOptionFeaturesSet, "string not allowed")
	assert.Error(t, err)
	i, err = options.GetUint64(ImageOptionFeaturesSet)
	assert.NoError(t, err)
	assert.True(t, i == 1)
	_, err = options.GetString(ImageOptionFeaturesSet)
	assert.Error(t, err)
	set, err = options.IsSet(ImageOptionFeaturesSet)
	assert.NoError(t, err)
	assert.True(t, set)
	err = options.Unset(ImageOptionFeaturesSet)
	assert.NoError(t, err)

	err = options.SetUint64(ImageOptionFeaturesClear, 1)
	assert.NoError(t, err)
	err = options.SetString(ImageOptionFeaturesClear, "string not allowed")
	assert.Error(t, err)
	i, err = options.GetUint64(ImageOptionFeaturesClear)
	assert.NoError(t, err)
	assert.True(t, i == 1)
	_, err = options.GetString(ImageOptionFeaturesClear)
	assert.Error(t, err)
	set, err = options.IsSet(ImageOptionFeaturesClear)
	assert.NoError(t, err)
	assert.True(t, set)
	err = options.Unset(ImageOptionFeaturesClear)
	assert.NoError(t, err)

	err = options.SetUint64(ImageOptionDataPool, 1)
	assert.Error(t, err)
	err = options.SetString(ImageOptionDataPool, "data")
	assert.NoError(t, err)
	_, err = options.GetUint64(ImageOptionDataPool)
	assert.Error(t, err)
	s, err = options.GetString(ImageOptionDataPool)
	assert.NoError(t, err)
	assert.True(t, s == "data")
	set, err = options.IsSet(ImageOptionDataPool)
	assert.NoError(t, err)
	assert.True(t, set)
	err = options.Unset(ImageOptionDataPool)
	assert.NoError(t, err)

	/* introduced with Ceph Mimic, can not be tested on Luminous
	err = options.SetUint64(RbdImageOptionFlatten, 1)
	assert.NoError(t, err)
	err = options.SetString(RbdImageOptionFlatten, "string not allowed")
	assert.Error(t, err)
	i, err = options.GetUint64(RbdImageOptionFlatten)
	assert.NoError(t, err)
	assert.True(t, i == 1)
	_, err = options.GetString(RbdImageOptionFlatten)
	assert.Error(t, err)
	set, err = options.IsSet(RbdImageOptionFlatten)
	assert.NoError(t, err)
	assert.True(t, set)
	err = options.Unset(RbdImageOptionFlatten)
	assert.NoError(t, err)
	*/
}

func TestRbdOptionsClear(t *testing.T) {
	options := NewRbdImageOptions()

	// set at least one option
	err := options.SetUint64(ImageOptionFormat, 1)
	assert.NoError(t, err)

	empty := options.IsEmpty()
	assert.False(t, empty)

	options.Clear()
	empty = options.IsEmpty()
	assert.True(t, empty)

	options.Destroy()
}

func TestInvalidRbdOption(t *testing.T) {
	options := NewRbdImageOptions()

	err := options.SetUint64(ImageOption(-1), 1)
	assert.Error(t, err)

	_, err = options.IsSet(ImageOption(-1))
	assert.Error(t, err)

	err = options.Unset(ImageOption(-1))
	assert.Error(t, err)

	options.Destroy()
}
