// Code generated by github.com/99designs/gqlgen, DO NOT EDIT.

package followschema

import (
	"bytes"
	"context"
	"embed"
	"errors"
	"fmt"
	"sync/atomic"

	"github.com/99designs/gqlgen/graphql"
	"github.com/99designs/gqlgen/graphql/introspection"
	gqlparser "github.com/vektah/gqlparser/v2"
	"github.com/vektah/gqlparser/v2/ast"
)

// NewExecutableSchema creates an ExecutableSchema from the ResolverRoot interface.
func NewExecutableSchema(cfg Config) graphql.ExecutableSchema {
	return &executableSchema{
		schema:     cfg.Schema,
		resolvers:  cfg.Resolvers,
		directives: cfg.Directives,
		complexity: cfg.Complexity,
	}
}

type Config struct {
	Schema     *ast.Schema
	Resolvers  ResolverRoot
	Directives DirectiveRoot
	Complexity ComplexityRoot
}

type ResolverRoot interface {
	BackedByInterface() BackedByInterfaceResolver
	DeferModel() DeferModelResolver
	Errors() ErrorsResolver
	ForcedResolver() ForcedResolverResolver
	ModelMethods() ModelMethodsResolver
	Mutation() MutationResolver
	OverlappingFields() OverlappingFieldsResolver
	Panics() PanicsResolver
	Pet() PetResolver
	Primitive() PrimitiveResolver
	PrimitiveString() PrimitiveStringResolver
	Query() QueryResolver
	Subscription() SubscriptionResolver
	User() UserResolver
	WrappedMap() WrappedMapResolver
	WrappedSlice() WrappedSliceResolver
	FieldsOrderInput() FieldsOrderInputResolver
}

type DirectiveRoot struct {
	Custom        func(ctx context.Context, obj interface{}, next graphql.Resolver) (res interface{}, err error)
	Defer         func(ctx context.Context, obj interface{}, next graphql.Resolver, ifArg *bool, label *string) (res interface{}, err error)
	Directive1    func(ctx context.Context, obj interface{}, next graphql.Resolver) (res interface{}, err error)
	Directive2    func(ctx context.Context, obj interface{}, next graphql.Resolver) (res interface{}, err error)
	Directive3    func(ctx context.Context, obj interface{}, next graphql.Resolver) (res interface{}, err error)
	Length        func(ctx context.Context, obj interface{}, next graphql.Resolver, min int, max *int, message *string) (res interface{}, err error)
	Logged        func(ctx context.Context, obj interface{}, next graphql.Resolver, id string) (res interface{}, err error)
	MakeNil       func(ctx context.Context, obj interface{}, next graphql.Resolver) (res interface{}, err error)
	MakeTypedNil  func(ctx context.Context, obj interface{}, next graphql.Resolver) (res interface{}, err error)
	Order1        func(ctx context.Context, obj interface{}, next graphql.Resolver, location string) (res interface{}, err error)
	Order2        func(ctx context.Context, obj interface{}, next graphql.Resolver, location string) (res interface{}, err error)
	Range         func(ctx context.Context, obj interface{}, next graphql.Resolver, min *int, max *int) (res interface{}, err error)
	ToNull        func(ctx context.Context, obj interface{}, next graphql.Resolver) (res interface{}, err error)
	Unimplemented func(ctx context.Context, obj interface{}, next graphql.Resolver) (res interface{}, err error)
}

type ComplexityRoot struct {
	A struct {
		ID func(childComplexity int) int
	}

	AIt struct {
		ID func(childComplexity int) int
	}

	AbIt struct {
		ID func(childComplexity int) int
	}

	Autobind struct {
		IdInt func(childComplexity int) int
		IdStr func(childComplexity int) int
		Int   func(childComplexity int) int
		Int32 func(childComplexity int) int
		Int64 func(childComplexity int) int
	}

	B struct {
		ID func(childComplexity int) int
	}

	BackedByInterface struct {
		ID                      func(childComplexity int) int
		ThisShouldBind          func(childComplexity int) int
		ThisShouldBindWithError func(childComplexity int) int
	}

	Cat struct {
		CatBreed func(childComplexity int) int
		Size     func(childComplexity int) int
		Species  func(childComplexity int) int
	}

	CheckIssue896 struct {
		ID func(childComplexity int) int
	}

	Circle struct {
		Area        func(childComplexity int) int
		Coordinates func(childComplexity int) int
		Radius      func(childComplexity int) int
	}

	ConcreteNodeA struct {
		Child func(childComplexity int) int
		ID    func(childComplexity int) int
		Name  func(childComplexity int) int
	}

	ConcreteNodeInterface struct {
		Child func(childComplexity int) int
		ID    func(childComplexity int) int
	}

	Content_Post struct {
		Foo func(childComplexity int) int
	}

	Content_User struct {
		Foo func(childComplexity int) int
	}

	Coordinates struct {
		X func(childComplexity int) int
		Y func(childComplexity int) int
	}

	DefaultParametersMirror struct {
		FalsyBoolean  func(childComplexity int) int
		TruthyBoolean func(childComplexity int) int
	}

	DeferModel struct {
		ID     func(childComplexity int) int
		Name   func(childComplexity int) int
		Values func(childComplexity int) int
	}

	Dog struct {
		DogBreed func(childComplexity int) int
		Size     func(childComplexity int) int
		Species  func(childComplexity int) int
	}

	EmbeddedCase1 struct {
		ExportedEmbeddedPointerExportedMethod func(childComplexity int) int
	}

	EmbeddedCase2 struct {
		UnexportedEmbeddedPointerExportedMethod func(childComplexity int) int
	}

	EmbeddedCase3 struct {
		UnexportedEmbeddedInterfaceExportedMethod func(childComplexity int) int
	}

	EmbeddedDefaultScalar struct {
		Value func(childComplexity int) int
	}

	EmbeddedPointer struct {
		ID    func(childComplexity int) int
		Title func(childComplexity int) int
	}

	Error struct {
		ErrorOnNonRequiredField func(childComplexity int) int
		ErrorOnRequiredField    func(childComplexity int) int
		ID                      func(childComplexity int) int
		NilOnRequiredField      func(childComplexity int) int
	}

	Errors struct {
		A func(childComplexity int) int
		B func(childComplexity int) int
		C func(childComplexity int) int
		D func(childComplexity int) int
		E func(childComplexity int) int
	}

	FieldsOrderPayload struct {
		FirstFieldValue func(childComplexity int) int
	}

	ForcedResolver struct {
		Field func(childComplexity int) int
	}

	InnerObject struct {
		ID func(childComplexity int) int
	}

	InvalidIdentifier struct {
		ID func(childComplexity int) int
	}

	It struct {
		ID func(childComplexity int) int
	}

	LoopA struct {
		B func(childComplexity int) int
	}

	LoopB struct {
		A func(childComplexity int) int
	}

	Map struct {
		ID func(childComplexity int) int
	}

	MapNested struct {
		Value func(childComplexity int) int
	}

	MapStringInterfaceType struct {
		A      func(childComplexity int) int
		B      func(childComplexity int) int
		C      func(childComplexity int) int
		Nested func(childComplexity int) int
	}

	ModelMethods struct {
		NoContext     func(childComplexity int) int
		ResolverField func(childComplexity int) int
		WithContext   func(childComplexity int) int
	}

	Mutation struct {
		DefaultInput          func(childComplexity int, input DefaultInput) int
		OverrideValueViaInput func(childComplexity int, input FieldsOrderInput) int
		UpdatePtrToPtr        func(childComplexity int, input UpdatePtrToPtrOuter) int
		UpdateSomething       func(childComplexity int, input SpecialInput) int
	}

	ObjectDirectives struct {
		NullableText func(childComplexity int) int
		Order        func(childComplexity int) int
		Text         func(childComplexity int) int
	}

	ObjectDirectivesWithCustomGoModel struct {
		NullableText func(childComplexity int) int
	}

	OuterObject struct {
		Inner func(childComplexity int) int
	}

	OverlappingFields struct {
		Foo    func(childComplexity int) int
		NewFoo func(childComplexity int) int
		OldFoo func(childComplexity int) int
	}

	Panics struct {
		ArgUnmarshal       func(childComplexity int, u []MarshalPanic) int
		FieldFuncMarshal   func(childComplexity int, u []MarshalPanic) int
		FieldScalarMarshal func(childComplexity int) int
	}

	Pet struct {
		Friends func(childComplexity int, limit *int) int
		ID      func(childComplexity int) int
	}

	Primitive struct {
		Squared func(childComplexity int) int
		Value   func(childComplexity int) int
	}

	PrimitiveString struct {
		Doubled func(childComplexity int) int
		Len     func(childComplexity int) int
		Value   func(childComplexity int) int
	}

	PtrToAnyContainer struct {
		Binding  func(childComplexity int) int
		PtrToAny func(childComplexity int) int
	}

	PtrToPtrInner struct {
		Key   func(childComplexity int) int
		Value func(childComplexity int) int
	}

	PtrToPtrOuter struct {
		Inner       func(childComplexity int) int
		Name        func(childComplexity int) int
		StupidInner func(childComplexity int) int
	}

	PtrToSliceContainer struct {
		PtrToSlice func(childComplexity int) int
	}

	Query struct {
		Animal                           func(childComplexity int) int
		Autobind                         func(childComplexity int) int
		Collision                        func(childComplexity int) int
		DefaultParameters                func(childComplexity int, falsyBoolean *bool, truthyBoolean *bool) int
		DefaultScalar                    func(childComplexity int, arg string) int
		DeferCase1                       func(childComplexity int) int
		DeferCase2                       func(childComplexity int) int
		DeprecatedField                  func(childComplexity int) int
		DirectiveArg                     func(childComplexity int, arg string) int
		DirectiveDouble                  func(childComplexity int) int
		DirectiveField                   func(childComplexity int) int
		DirectiveFieldDef                func(childComplexity int, ret string) int
		DirectiveInput                   func(childComplexity int, arg InputDirectives) int
		DirectiveInputNullable           func(childComplexity int, arg *InputDirectives) int
		DirectiveInputType               func(childComplexity int, arg InnerInput) int
		DirectiveNullableArg             func(childComplexity int, arg *int, arg2 *int, arg3 *string) int
		DirectiveObject                  func(childComplexity int) int
		DirectiveObjectWithCustomGoModel func(childComplexity int) int
		DirectiveUnimplemented           func(childComplexity int) int
		Dog                              func(childComplexity int) int
		EmbeddedCase1                    func(childComplexity int) int
		EmbeddedCase2                    func(childComplexity int) int
		EmbeddedCase3                    func(childComplexity int) int
		EnumInInput                      func(childComplexity int, input *InputWithEnumValue) int
		ErrorBubble                      func(childComplexity int) int
		ErrorBubbleList                  func(childComplexity int) int
		ErrorList                        func(childComplexity int) int
		Errors                           func(childComplexity int) int
		Fallback                         func(childComplexity int, arg FallbackToStringEncoding) int
		Infinity                         func(childComplexity int) int
		InputNullableSlice               func(childComplexity int, arg []string) int
		InputOmittable                   func(childComplexity int, arg OmittableInput) int
		InputSlice                       func(childComplexity int, arg []string) int
		Invalid                          func(childComplexity int) int
		InvalidIdentifier                func(childComplexity int) int
		Issue896a                        func(childComplexity int) int
		MapInput                         func(childComplexity int, input map[string]interface{}) int
		MapNestedStringInterface         func(childComplexity int, in *NestedMapInput) int
		MapStringInterface               func(childComplexity int, in map[string]interface{}) int
		ModelMethods                     func(childComplexity int) int
		NestedInputs                     func(childComplexity int, input [][]*OuterInput) int
		NestedOutputs                    func(childComplexity int) int
		NoShape                          func(childComplexity int) int
		NoShapeTypedNil                  func(childComplexity int) int
		Node                             func(childComplexity int) int
		NotAnInterface                   func(childComplexity int) int
		NullableArg                      func(childComplexity int, arg *int) int
		OptionalUnion                    func(childComplexity int) int
		Overlapping                      func(childComplexity int) int
		Panics                           func(childComplexity int) int
		PrimitiveObject                  func(childComplexity int) int
		PrimitiveStringObject            func(childComplexity int) int
		PtrToAnyContainer                func(childComplexity int) int
		PtrToSliceContainer              func(childComplexity int) int
		Recursive                        func(childComplexity int, input *RecursiveInputSlice) int
		ScalarSlice                      func(childComplexity int) int
		ShapeUnion                       func(childComplexity int) int
		Shapes                           func(childComplexity int) int
		Slices                           func(childComplexity int) int
		StringFromContextFunction        func(childComplexity int) int
		StringFromContextInterface       func(childComplexity int) int
		User                             func(childComplexity int, id int) int
		VOkCaseNil                       func(childComplexity int) int
		VOkCaseValue                     func(childComplexity int) int
		Valid                            func(childComplexity int) int
		ValidType                        func(childComplexity int) int
		VariadicModel                    func(childComplexity int) int
		WrappedMap                       func(childComplexity int) int
		WrappedScalar                    func(childComplexity int) int
		WrappedSlice                     func(childComplexity int) int
		WrappedStruct                    func(childComplexity int) int
	}

	Rectangle struct {
		Area        func(childComplexity int) int
		Coordinates func(childComplexity int) int
		Length      func(childComplexity int) int
		Width       func(childComplexity int) int
	}

	Size struct {
		Height func(childComplexity int) int
		Weight func(childComplexity int) int
	}

	Slices struct {
		Test1 func(childComplexity int) int
		Test2 func(childComplexity int) int
		Test3 func(childComplexity int) int
		Test4 func(childComplexity int) int
	}

	Subscription struct {
		DirectiveArg           func(childComplexity int, arg string) int
		DirectiveDouble        func(childComplexity int) int
		DirectiveNullableArg   func(childComplexity int, arg *int, arg2 *int, arg3 *string) int
		DirectiveUnimplemented func(childComplexity int) int
		ErrorRequired          func(childComplexity int) int
		InitPayload            func(childComplexity int) int
		Issue896b              func(childComplexity int) int
		Updated                func(childComplexity int) int
	}

	User struct {
		Created func(childComplexity int) int
		Friends func(childComplexity int) int
		ID      func(childComplexity int) int
		Pets    func(childComplexity int, limit *int) int
		Updated func(childComplexity int) int
	}

	VOkCaseNil struct {
		Value func(childComplexity int) int
	}

	VOkCaseValue struct {
		Value func(childComplexity int) int
	}

	ValidType struct {
		DifferentCase      func(childComplexity int) int
		DifferentCaseOld   func(childComplexity int) int
		ValidArgs          func(childComplexity int, breakArg string, defaultArg string, funcArg string, interfaceArg string, selectArg string, caseArg string, deferArg string, goArg string, mapArg string, structArg string, chanArg string, elseArg string, gotoArg string, packageArg string, switchArg string, constArg string, fallthroughArg string, ifArg string, rangeArg string, typeArg string, continueArg string, forArg string, importArg string, returnArg string, varArg string, _ string) int
		ValidInputKeywords func(childComplexity int, input *ValidInput) int
	}

	VariadicModel struct {
		Value func(childComplexity int, rank int) int
	}

	WrappedMap struct {
		Get func(childComplexity int, key string) int
	}

	WrappedSlice struct {
		Get func(childComplexity int, idx int) int
	}

	WrappedStruct struct {
		Desc func(childComplexity int) int
		Name func(childComplexity int) int
	}

	XXIt struct {
		ID func(childComplexity int) int
	}

	XxIt struct {
		ID func(childComplexity int) int
	}

	AsdfIt struct {
		ID func(childComplexity int) int
	}

	IIt struct {
		ID func(childComplexity int) int
	}
}

type executableSchema struct {
	schema     *ast.Schema
	resolvers  ResolverRoot
	directives DirectiveRoot
	complexity ComplexityRoot
}

func (e *executableSchema) Schema() *ast.Schema {
	if e.schema != nil {
		return e.schema
	}
	return parsedSchema
}

func (e *executableSchema) Complexity(typeName, field string, childComplexity int, rawArgs map[string]interface{}) (int, bool) {
	ec := executionContext{nil, e, 0, 0, nil}
	_ = ec
	switch typeName + "." + field {

	case "A.id":
		if e.complexity.A.ID == nil {
			break
		}

		return e.complexity.A.ID(childComplexity), true

	case "AIt.id":
		if e.complexity.AIt.ID == nil {
			break
		}

		return e.complexity.AIt.ID(childComplexity), true

	case "AbIt.id":
		if e.complexity.AbIt.ID == nil {
			break
		}

		return e.complexity.AbIt.ID(childComplexity), true

	case "Autobind.idInt":
		if e.complexity.Autobind.IdInt == nil {
			break
		}

		return e.complexity.Autobind.IdInt(childComplexity), true

	case "Autobind.idStr":
		if e.complexity.Autobind.IdStr == nil {
			break
		}

		return e.complexity.Autobind.IdStr(childComplexity), true

	case "Autobind.int":
		if e.complexity.Autobind.Int == nil {
			break
		}

		return e.complexity.Autobind.Int(childComplexity), true

	case "Autobind.int32":
		if e.complexity.Autobind.Int32 == nil {
			break
		}

		return e.complexity.Autobind.Int32(childComplexity), true

	case "Autobind.int64":
		if e.complexity.Autobind.Int64 == nil {
			break
		}

		return e.complexity.Autobind.Int64(childComplexity), true

	case "B.id":
		if e.complexity.B.ID == nil {
			break
		}

		return e.complexity.B.ID(childComplexity), true

	case "BackedByInterface.id":
		if e.complexity.BackedByInterface.ID == nil {
			break
		}

		return e.complexity.BackedByInterface.ID(childComplexity), true

	case "BackedByInterface.thisShouldBind":
		if e.complexity.BackedByInterface.ThisShouldBind == nil {
			break
		}

		return e.complexity.BackedByInterface.ThisShouldBind(childComplexity), true

	case "BackedByInterface.thisShouldBindWithError":
		if e.complexity.BackedByInterface.ThisShouldBindWithError == nil {
			break
		}

		return e.complexity.BackedByInterface.ThisShouldBindWithError(childComplexity), true

	case "Cat.catBreed":
		if e.complexity.Cat.CatBreed == nil {
			break
		}

		return e.complexity.Cat.CatBreed(childComplexity), true

	case "Cat.size":
		if e.complexity.Cat.Size == nil {
			break
		}

		return e.complexity.Cat.Size(childComplexity), true

	case "Cat.species":
		if e.complexity.Cat.Species == nil {
			break
		}

		return e.complexity.Cat.Species(childComplexity), true

	case "CheckIssue896.id":
		if e.complexity.CheckIssue896.ID == nil {
			break
		}

		return e.complexity.CheckIssue896.ID(childComplexity), true

	case "Circle.area":
		if e.complexity.Circle.Area == nil {
			break
		}

		return e.complexity.Circle.Area(childComplexity), true

	case "Circle.coordinates":
		if e.complexity.Circle.Coordinates == nil {
			break
		}

		return e.complexity.Circle.Coordinates(childComplexity), true

	case "Circle.radius":
		if e.complexity.Circle.Radius == nil {
			break
		}

		return e.complexity.Circle.Radius(childComplexity), true

	case "ConcreteNodeA.child":
		if e.complexity.ConcreteNodeA.Child == nil {
			break
		}

		return e.complexity.ConcreteNodeA.Child(childComplexity), true

	case "ConcreteNodeA.id":
		if e.complexity.ConcreteNodeA.ID == nil {
			break
		}

		return e.complexity.ConcreteNodeA.ID(childComplexity), true

	case "ConcreteNodeA.name":
		if e.complexity.ConcreteNodeA.Name == nil {
			break
		}

		return e.complexity.ConcreteNodeA.Name(childComplexity), true

	case "ConcreteNodeInterface.child":
		if e.complexity.ConcreteNodeInterface.Child == nil {
			break
		}

		return e.complexity.ConcreteNodeInterface.Child(childComplexity), true

	case "ConcreteNodeInterface.id":
		if e.complexity.ConcreteNodeInterface.ID == nil {
			break
		}

		return e.complexity.ConcreteNodeInterface.ID(childComplexity), true

	case "Content_Post.foo":
		if e.complexity.Content_Post.Foo == nil {
			break
		}

		return e.complexity.Content_Post.Foo(childComplexity), true

	case "Content_User.foo":
		if e.complexity.Content_User.Foo == nil {
			break
		}

		return e.complexity.Content_User.Foo(childComplexity), true

	case "Coordinates.x":
		if e.complexity.Coordinates.X == nil {
			break
		}

		return e.complexity.Coordinates.X(childComplexity), true

	case "Coordinates.y":
		if e.complexity.Coordinates.Y == nil {
			break
		}

		return e.complexity.Coordinates.Y(childComplexity), true

	case "DefaultParametersMirror.falsyBoolean":
		if e.complexity.DefaultParametersMirror.FalsyBoolean == nil {
			break
		}

		return e.complexity.DefaultParametersMirror.FalsyBoolean(childComplexity), true

	case "DefaultParametersMirror.truthyBoolean":
		if e.complexity.DefaultParametersMirror.TruthyBoolean == nil {
			break
		}

		return e.complexity.DefaultParametersMirror.TruthyBoolean(childComplexity), true

	case "DeferModel.id":
		if e.complexity.DeferModel.ID == nil {
			break
		}

		return e.complexity.DeferModel.ID(childComplexity), true

	case "DeferModel.name":
		if e.complexity.DeferModel.Name == nil {
			break
		}

		return e.complexity.DeferModel.Name(childComplexity), true

	case "DeferModel.values":
		if e.complexity.DeferModel.Values == nil {
			break
		}

		return e.complexity.DeferModel.Values(childComplexity), true

	case "Dog.dogBreed":
		if e.complexity.Dog.DogBreed == nil {
			break
		}

		return e.complexity.Dog.DogBreed(childComplexity), true

	case "Dog.size":
		if e.complexity.Dog.Size == nil {
			break
		}

		return e.complexity.Dog.Size(childComplexity), true

	case "Dog.species":
		if e.complexity.Dog.Species == nil {
			break
		}

		return e.complexity.Dog.Species(childComplexity), true

	case "EmbeddedCase1.exportedEmbeddedPointerExportedMethod":
		if e.complexity.EmbeddedCase1.ExportedEmbeddedPointerExportedMethod == nil {
			break
		}

		return e.complexity.EmbeddedCase1.ExportedEmbeddedPointerExportedMethod(childComplexity), true

	case "EmbeddedCase2.unexportedEmbeddedPointerExportedMethod":
		if e.complexity.EmbeddedCase2.UnexportedEmbeddedPointerExportedMethod == nil {
			break
		}

		return e.complexity.EmbeddedCase2.UnexportedEmbeddedPointerExportedMethod(childComplexity), true

	case "EmbeddedCase3.unexportedEmbeddedInterfaceExportedMethod":
		if e.complexity.EmbeddedCase3.UnexportedEmbeddedInterfaceExportedMethod == nil {
			break
		}

		return e.complexity.EmbeddedCase3.UnexportedEmbeddedInterfaceExportedMethod(childComplexity), true

	case "EmbeddedDefaultScalar.value":
		if e.complexity.EmbeddedDefaultScalar.Value == nil {
			break
		}

		return e.complexity.EmbeddedDefaultScalar.Value(childComplexity), true

	case "EmbeddedPointer.ID":
		if e.complexity.EmbeddedPointer.ID == nil {
			break
		}

		return e.complexity.EmbeddedPointer.ID(childComplexity), true

	case "EmbeddedPointer.Title":
		if e.complexity.EmbeddedPointer.Title == nil {
			break
		}

		return e.complexity.EmbeddedPointer.Title(childComplexity), true

	case "Error.errorOnNonRequiredField":
		if e.complexity.Error.ErrorOnNonRequiredField == nil {
			break
		}

		return e.complexity.Error.ErrorOnNonRequiredField(childComplexity), true

	case "Error.errorOnRequiredField":
		if e.complexity.Error.ErrorOnRequiredField == nil {
			break
		}

		return e.complexity.Error.ErrorOnRequiredField(childComplexity), true

	case "Error.id":
		if e.complexity.Error.ID == nil {
			break
		}

		return e.complexity.Error.ID(childComplexity), true

	case "Error.nilOnRequiredField":
		if e.complexity.Error.NilOnRequiredField == nil {
			break
		}

		return e.complexity.Error.NilOnRequiredField(childComplexity), true

	case "Errors.a":
		if e.complexity.Errors.A == nil {
			break
		}

		return e.complexity.Errors.A(childComplexity), true

	case "Errors.b":
		if e.complexity.Errors.B == nil {
			break
		}

		return e.complexity.Errors.B(childComplexity), true

	case "Errors.c":
		if e.complexity.Errors.C == nil {
			break
		}

		return e.complexity.Errors.C(childComplexity), true

	case "Errors.d":
		if e.complexity.Errors.D == nil {
			break
		}

		return e.complexity.Errors.D(childComplexity), true

	case "Errors.e":
		if e.complexity.Errors.E == nil {
			break
		}

		return e.complexity.Errors.E(childComplexity), true

	case "FieldsOrderPayload.firstFieldValue":
		if e.complexity.FieldsOrderPayload.FirstFieldValue == nil {
			break
		}

		return e.complexity.FieldsOrderPayload.FirstFieldValue(childComplexity), true

	case "ForcedResolver.field":
		if e.complexity.ForcedResolver.Field == nil {
			break
		}

		return e.complexity.ForcedResolver.Field(childComplexity), true

	case "InnerObject.id":
		if e.complexity.InnerObject.ID == nil {
			break
		}

		return e.complexity.InnerObject.ID(childComplexity), true

	case "InvalidIdentifier.id":
		if e.complexity.InvalidIdentifier.ID == nil {
			break
		}

		return e.complexity.InvalidIdentifier.ID(childComplexity), true

	case "It.id":
		if e.complexity.It.ID == nil {
			break
		}

		return e.complexity.It.ID(childComplexity), true

	case "LoopA.b":
		if e.complexity.LoopA.B == nil {
			break
		}

		return e.complexity.LoopA.B(childComplexity), true

	case "LoopB.a":
		if e.complexity.LoopB.A == nil {
			break
		}

		return e.complexity.LoopB.A(childComplexity), true

	case "Map.id":
		if e.complexity.Map.ID == nil {
			break
		}

		return e.complexity.Map.ID(childComplexity), true

	case "MapNested.value":
		if e.complexity.MapNested.Value == nil {
			break
		}

		return e.complexity.MapNested.Value(childComplexity), true

	case "MapStringInterfaceType.a":
		if e.complexity.MapStringInterfaceType.A == nil {
			break
		}

		return e.complexity.MapStringInterfaceType.A(childComplexity), true

	case "MapStringInterfaceType.b":
		if e.complexity.MapStringInterfaceType.B == nil {
			break
		}

		return e.complexity.MapStringInterfaceType.B(childComplexity), true

	case "MapStringInterfaceType.c":
		if e.complexity.MapStringInterfaceType.C == nil {
			break
		}

		return e.complexity.MapStringInterfaceType.C(childComplexity), true

	case "MapStringInterfaceType.nested":
		if e.complexity.MapStringInterfaceType.Nested == nil {
			break
		}

		return e.complexity.MapStringInterfaceType.Nested(childComplexity), true

	case "ModelMethods.noContext":
		if e.complexity.ModelMethods.NoContext == nil {
			break
		}

		return e.complexity.ModelMethods.NoContext(childComplexity), true

	case "ModelMethods.resolverField":
		if e.complexity.ModelMethods.ResolverField == nil {
			break
		}

		return e.complexity.ModelMethods.ResolverField(childComplexity), true

	case "ModelMethods.withContext":
		if e.complexity.ModelMethods.WithContext == nil {
			break
		}

		return e.complexity.ModelMethods.WithContext(childComplexity), true

	case "Mutation.defaultInput":
		if e.complexity.Mutation.DefaultInput == nil {
			break
		}

		args, err := ec.field_Mutation_defaultInput_args(context.TODO(), rawArgs)
		if err != nil {
			return 0, false
		}

		return e.complexity.Mutation.DefaultInput(childComplexity, args["input"].(DefaultInput)), true

	case "Mutation.overrideValueViaInput":
		if e.complexity.Mutation.OverrideValueViaInput == nil {
			break
		}

		args, err := ec.field_Mutation_overrideValueViaInput_args(context.TODO(), rawArgs)
		if err != nil {
			return 0, false
		}

		return e.complexity.Mutation.OverrideValueViaInput(childComplexity, args["input"].(FieldsOrderInput)), true

	case "Mutation.updatePtrToPtr":
		if e.complexity.Mutation.UpdatePtrToPtr == nil {
			break
		}

		args, err := ec.field_Mutation_updatePtrToPtr_args(context.TODO(), rawArgs)
		if err != nil {
			return 0, false
		}

		return e.complexity.Mutation.UpdatePtrToPtr(childComplexity, args["input"].(UpdatePtrToPtrOuter)), true

	case "Mutation.updateSomething":
		if e.complexity.Mutation.UpdateSomething == nil {
			break
		}

		args, err := ec.field_Mutation_updateSomething_args(context.TODO(), rawArgs)
		if err != nil {
			return 0, false
		}

		return e.complexity.Mutation.UpdateSomething(childComplexity, args["input"].(SpecialInput)), true

	case "ObjectDirectives.nullableText":
		if e.complexity.ObjectDirectives.NullableText == nil {
			break
		}

		return e.complexity.ObjectDirectives.NullableText(childComplexity), true

	case "ObjectDirectives.order":
		if e.complexity.ObjectDirectives.Order == nil {
			break
		}

		return e.complexity.ObjectDirectives.Order(childComplexity), true

	case "ObjectDirectives.text":
		if e.complexity.ObjectDirectives.Text == nil {
			break
		}

		return e.complexity.ObjectDirectives.Text(childComplexity), true

	case "ObjectDirectivesWithCustomGoModel.nullableText":
		if e.complexity.ObjectDirectivesWithCustomGoModel.NullableText == nil {
			break
		}

		return e.complexity.ObjectDirectivesWithCustomGoModel.NullableText(childComplexity), true

	case "OuterObject.inner":
		if e.complexity.OuterObject.Inner == nil {
			break
		}

		return e.complexity.OuterObject.Inner(childComplexity), true

	case "OverlappingFields.oneFoo", "OverlappingFields.twoFoo":
		if e.complexity.OverlappingFields.Foo == nil {
			break
		}

		return e.complexity.OverlappingFields.Foo(childComplexity), true

	case "OverlappingFields.newFoo", "OverlappingFields.new_foo":
		if e.complexity.OverlappingFields.NewFoo == nil {
			break
		}

		return e.complexity.OverlappingFields.NewFoo(childComplexity), true

	case "OverlappingFields.oldFoo":
		if e.complexity.OverlappingFields.OldFoo == nil {
			break
		}

		return e.complexity.OverlappingFields.OldFoo(childComplexity), true

	case "Panics.argUnmarshal":
		if e.complexity.Panics.ArgUnmarshal == nil {
			break
		}

		args, err := ec.field_Panics_argUnmarshal_args(context.TODO(), rawArgs)
		if err != nil {
			return 0, false
		}

		return e.complexity.Panics.ArgUnmarshal(childComplexity, args["u"].([]MarshalPanic)), true

	case "Panics.fieldFuncMarshal":
		if e.complexity.Panics.FieldFuncMarshal == nil {
			break
		}

		args, err := ec.field_Panics_fieldFuncMarshal_args(context.TODO(), rawArgs)
		if err != nil {
			return 0, false
		}

		return e.complexity.Panics.FieldFuncMarshal(childComplexity, args["u"].([]MarshalPanic)), true

	case "Panics.fieldScalarMarshal":
		if e.complexity.Panics.FieldScalarMarshal == nil {
			break
		}

		return e.complexity.Panics.FieldScalarMarshal(childComplexity), true

	case "Pet.friends":
		if e.complexity.Pet.Friends == nil {
			break
		}

		args, err := ec.field_Pet_friends_args(context.TODO(), rawArgs)
		if err != nil {
			return 0, false
		}

		return e.complexity.Pet.Friends(childComplexity, args["limit"].(*int)), true

	case "Pet.id":
		if e.complexity.Pet.ID == nil {
			break
		}

		return e.complexity.Pet.ID(childComplexity), true

	case "Primitive.squared":
		if e.complexity.Primitive.Squared == nil {
			break
		}

		return e.complexity.Primitive.Squared(childComplexity), true

	case "Primitive.value":
		if e.complexity.Primitive.Value == nil {
			break
		}

		return e.complexity.Primitive.Value(childComplexity), true

	case "PrimitiveString.doubled":
		if e.complexity.PrimitiveString.Doubled == nil {
			break
		}

		return e.complexity.PrimitiveString.Doubled(childComplexity), true

	case "PrimitiveString.len":
		if e.complexity.PrimitiveString.Len == nil {
			break
		}

		return e.complexity.PrimitiveString.Len(childComplexity), true

	case "PrimitiveString.value":
		if e.complexity.PrimitiveString.Value == nil {
			break
		}

		return e.complexity.PrimitiveString.Value(childComplexity), true

	case "PtrToAnyContainer.binding":
		if e.complexity.PtrToAnyContainer.Binding == nil {
			break
		}

		return e.complexity.PtrToAnyContainer.Binding(childComplexity), true

	case "PtrToAnyContainer.ptrToAny":
		if e.complexity.PtrToAnyContainer.PtrToAny == nil {
			break
		}

		return e.complexity.PtrToAnyContainer.PtrToAny(childComplexity), true

	case "PtrToPtrInner.key":
		if e.complexity.PtrToPtrInner.Key == nil {
			break
		}

		return e.complexity.PtrToPtrInner.Key(childComplexity), true

	case "PtrToPtrInner.value":
		if e.complexity.PtrToPtrInner.Value == nil {
			break
		}

		return e.complexity.PtrToPtrInner.Value(childComplexity), true

	case "PtrToPtrOuter.inner":
		if e.complexity.PtrToPtrOuter.Inner == nil {
			break
		}

		return e.complexity.PtrToPtrOuter.Inner(childComplexity), true

	case "PtrToPtrOuter.name":
		if e.complexity.PtrToPtrOuter.Name == nil {
			break
		}

		return e.complexity.PtrToPtrOuter.Name(childComplexity), true

	case "PtrToPtrOuter.stupidInner":
		if e.complexity.PtrToPtrOuter.StupidInner == nil {
			break
		}

		return e.complexity.PtrToPtrOuter.StupidInner(childComplexity), true

	case "PtrToSliceContainer.ptrToSlice":
		if e.complexity.PtrToSliceContainer.PtrToSlice == nil {
			break
		}

		return e.complexity.PtrToSliceContainer.PtrToSlice(childComplexity), true

	case "Query.animal":
		if e.complexity.Query.Animal == nil {
			break
		}

		return e.complexity.Query.Animal(childComplexity), true

	case "Query.autobind":
		if e.complexity.Query.Autobind == nil {
			break
		}

		return e.complexity.Query.Autobind(childComplexity), true

	case "Query.collision":
		if e.complexity.Query.Collision == nil {
			break
		}

		return e.complexity.Query.Collision(childComplexity), true

	case "Query.defaultParameters":
		if e.complexity.Query.DefaultParameters == nil {
			break
		}

		args, err := ec.field_Query_defaultParameters_args(context.TODO(), rawArgs)
		if err != nil {
			return 0, false
		}

		return e.complexity.Query.DefaultParameters(childComplexity, args["falsyBoolean"].(*bool), args["truthyBoolean"].(*bool)), true

	case "Query.defaultScalar":
		if e.complexity.Query.DefaultScalar == nil {
			break
		}

		args, err := ec.field_Query_defaultScalar_args(context.TODO(), rawArgs)
		if err != nil {
			return 0, false
		}

		return e.complexity.Query.DefaultScalar(childComplexity, args["arg"].(string)), true

	case "Query.deferCase1":
		if e.complexity.Query.DeferCase1 == nil {
			break
		}

		return e.complexity.Query.DeferCase1(childComplexity), true

	case "Query.deferCase2":
		if e.complexity.Query.DeferCase2 == nil {
			break
		}

		return e.complexity.Query.DeferCase2(childComplexity), true

	case "Query.deprecatedField":
		if e.complexity.Query.DeprecatedField == nil {
			break
		}

		return e.complexity.Query.DeprecatedField(childComplexity), true

	case "Query.directiveArg":
		if e.complexity.Query.DirectiveArg == nil {
			break
		}

		args, err := ec.field_Query_directiveArg_args(context.TODO(), rawArgs)
		if err != nil {
			return 0, false
		}

		return e.complexity.Query.DirectiveArg(childComplexity, args["arg"].(string)), true

	case "Query.directiveDouble":
		if e.complexity.Query.DirectiveDouble == nil {
			break
		}

		return e.complexity.Query.DirectiveDouble(childComplexity), true

	case "Query.directiveField":
		if e.complexity.Query.DirectiveField == nil {
			break
		}

		return e.complexity.Query.DirectiveField(childComplexity), true

	case "Query.directiveFieldDef":
		if e.complexity.Query.DirectiveFieldDef == nil {
			break
		}

		args, err := ec.field_Query_directiveFieldDef_args(context.TODO(), rawArgs)
		if err != nil {
			return 0, false
		}

		return e.complexity.Query.DirectiveFieldDef(childComplexity, args["ret"].(string)), true

	case "Query.directiveInput":
		if e.complexity.Query.DirectiveInput == nil {
			break
		}

		args, err := ec.field_Query_directiveInput_args(context.TODO(), rawArgs)
		if err != nil {
			return 0, false
		}

		return e.complexity.Query.DirectiveInput(childComplexity, args["arg"].(InputDirectives)), true

	case "Query.directiveInputNullable":
		if e.complexity.Query.DirectiveInputNullable == nil {
			break
		}

		args, err := ec.field_Query_directiveInputNullable_args(context.TODO(), rawArgs)
		if err != nil {
			return 0, false
		}

		return e.complexity.Query.DirectiveInputNullable(childComplexity, args["arg"].(*InputDirectives)), true

	case "Query.directiveInputType":
		if e.complexity.Query.DirectiveInputType == nil {
			break
		}

		args, err := ec.field_Query_directiveInputType_args(context.TODO(), rawArgs)
		if err != nil {
			return 0, false
		}

		return e.complexity.Query.DirectiveInputType(childComplexity, args["arg"].(InnerInput)), true

	case "Query.directiveNullableArg":
		if e.complexity.Query.DirectiveNullableArg == nil {
			break
		}

		args, err := ec.field_Query_directiveNullableArg_args(context.TODO(), rawArgs)
		if err != nil {
			return 0, false
		}

		return e.complexity.Query.DirectiveNullableArg(childComplexity, args["arg"].(*int), args["arg2"].(*int), args["arg3"].(*string)), true

	case "Query.directiveObject":
		if e.complexity.Query.DirectiveObject == nil {
			break
		}

		return e.complexity.Query.DirectiveObject(childComplexity), true

	case "Query.directiveObjectWithCustomGoModel":
		if e.complexity.Query.DirectiveObjectWithCustomGoModel == nil {
			break
		}

		return e.complexity.Query.DirectiveObjectWithCustomGoModel(childComplexity), true

	case "Query.directiveUnimplemented":
		if e.complexity.Query.DirectiveUnimplemented == nil {
			break
		}

		return e.complexity.Query.DirectiveUnimplemented(childComplexity), true

	case "Query.dog":
		if e.complexity.Query.Dog == nil {
			break
		}

		return e.complexity.Query.Dog(childComplexity), true

	case "Query.embeddedCase1":
		if e.complexity.Query.EmbeddedCase1 == nil {
			break
		}

		return e.complexity.Query.EmbeddedCase1(childComplexity), true

	case "Query.embeddedCase2":
		if e.complexity.Query.EmbeddedCase2 == nil {
			break
		}

		return e.complexity.Query.EmbeddedCase2(childComplexity), true

	case "Query.embeddedCase3":
		if e.complexity.Query.EmbeddedCase3 == nil {
			break
		}

		return e.complexity.Query.EmbeddedCase3(childComplexity), true

	case "Query.enumInInput":
		if e.complexity.Query.EnumInInput == nil {
			break
		}

		args, err := ec.field_Query_enumInInput_args(context.TODO(), rawArgs)
		if err != nil {
			return 0, false
		}

		return e.complexity.Query.EnumInInput(childComplexity, args["input"].(*InputWithEnumValue)), true

	case "Query.errorBubble":
		if e.complexity.Query.ErrorBubble == nil {
			break
		}

		return e.complexity.Query.ErrorBubble(childComplexity), true

	case "Query.errorBubbleList":
		if e.complexity.Query.ErrorBubbleList == nil {
			break
		}

		return e.complexity.Query.ErrorBubbleList(childComplexity), true

	case "Query.errorList":
		if e.complexity.Query.ErrorList == nil {
			break
		}

		return e.complexity.Query.ErrorList(childComplexity), true

	case "Query.errors":
		if e.complexity.Query.Errors == nil {
			break
		}

		return e.complexity.Query.Errors(childComplexity), true

	case "Query.fallback":
		if e.complexity.Query.Fallback == nil {
			break
		}

		args, err := ec.field_Query_fallback_args(context.TODO(), rawArgs)
		if err != nil {
			return 0, false
		}

		return e.complexity.Query.Fallback(childComplexity, args["arg"].(FallbackToStringEncoding)), true

	case "Query.infinity":
		if e.complexity.Query.Infinity == nil {
			break
		}

		return e.complexity.Query.Infinity(childComplexity), true

	case "Query.inputNullableSlice":
		if e.complexity.Query.InputNullableSlice == nil {
			break
		}

		args, err := ec.field_Query_inputNullableSlice_args(context.TODO(), rawArgs)
		if err != nil {
			return 0, false
		}

		return e.complexity.Query.InputNullableSlice(childComplexity, args["arg"].([]string)), true

	case "Query.inputOmittable":
		if e.complexity.Query.InputOmittable == nil {
			break
		}

		args, err := ec.field_Query_inputOmittable_args(context.TODO(), rawArgs)
		if err != nil {
			return 0, false
		}

		return e.complexity.Query.InputOmittable(childComplexity, args["arg"].(OmittableInput)), true

	case "Query.inputSlice":
		if e.complexity.Query.InputSlice == nil {
			break
		}

		args, err := ec.field_Query_inputSlice_args(context.TODO(), rawArgs)
		if err != nil {
			return 0, false
		}

		return e.complexity.Query.InputSlice(childComplexity, args["arg"].([]string)), true

	case "Query.invalid":
		if e.complexity.Query.Invalid == nil {
			break
		}

		return e.complexity.Query.Invalid(childComplexity), true

	case "Query.invalidIdentifier":
		if e.complexity.Query.InvalidIdentifier == nil {
			break
		}

		return e.complexity.Query.InvalidIdentifier(childComplexity), true

	case "Query.issue896a":
		if e.complexity.Query.Issue896a == nil {
			break
		}

		return e.complexity.Query.Issue896a(childComplexity), true

	case "Query.mapInput":
		if e.complexity.Query.MapInput == nil {
			break
		}

		args, err := ec.field_Query_mapInput_args(context.TODO(), rawArgs)
		if err != nil {
			return 0, false
		}

		return e.complexity.Query.MapInput(childComplexity, args["input"].(map[string]interface{})), true

	case "Query.mapNestedStringInterface":
		if e.complexity.Query.MapNestedStringInterface == nil {
			break
		}

		args, err := ec.field_Query_mapNestedStringInterface_args(context.TODO(), rawArgs)
		if err != nil {
			return 0, false
		}

		return e.complexity.Query.MapNestedStringInterface(childComplexity, args["in"].(*NestedMapInput)), true

	case "Query.mapStringInterface":
		if e.complexity.Query.MapStringInterface == nil {
			break
		}

		args, err := ec.field_Query_mapStringInterface_args(context.TODO(), rawArgs)
		if err != nil {
			return 0, false
		}

		return e.complexity.Query.MapStringInterface(childComplexity, args["in"].(map[string]interface{})), true

	case "Query.modelMethods":
		if e.complexity.Query.ModelMethods == nil {
			break
		}

		return e.complexity.Query.ModelMethods(childComplexity), true

	case "Query.nestedInputs":
		if e.complexity.Query.NestedInputs == nil {
			break
		}

		args, err := ec.field_Query_nestedInputs_args(context.TODO(), rawArgs)
		if err != nil {
			return 0, false
		}

		return e.complexity.Query.NestedInputs(childComplexity, args["input"].([][]*OuterInput)), true

	case "Query.nestedOutputs":
		if e.complexity.Query.NestedOutputs == nil {
			break
		}

		return e.complexity.Query.NestedOutputs(childComplexity), true

	case "Query.noShape":
		if e.complexity.Query.NoShape == nil {
			break
		}

		return e.complexity.Query.NoShape(childComplexity), true

	case "Query.noShapeTypedNil":
		if e.complexity.Query.NoShapeTypedNil == nil {
			break
		}

		return e.complexity.Query.NoShapeTypedNil(childComplexity), true

	case "Query.node":
		if e.complexity.Query.Node == nil {
			break
		}

		return e.complexity.Query.Node(childComplexity), true

	case "Query.notAnInterface":
		if e.complexity.Query.NotAnInterface == nil {
			break
		}

		return e.complexity.Query.NotAnInterface(childComplexity), true

	case "Query.nullableArg":
		if e.complexity.Query.NullableArg == nil {
			break
		}

		args, err := ec.field_Query_nullableArg_args(context.TODO(), rawArgs)
		if err != nil {
			return 0, false
		}

		return e.complexity.Query.NullableArg(childComplexity, args["arg"].(*int)), true

	case "Query.optionalUnion":
		if e.complexity.Query.OptionalUnion == nil {
			break
		}

		return e.complexity.Query.OptionalUnion(childComplexity), true

	case "Query.overlapping":
		if e.complexity.Query.Overlapping == nil {
			break
		}

		return e.complexity.Query.Overlapping(childComplexity), true

	case "Query.panics":
		if e.complexity.Query.Panics == nil {
			break
		}

		return e.complexity.Query.Panics(childComplexity), true

	case "Query.primitiveObject":
		if e.complexity.Query.PrimitiveObject == nil {
			break
		}

		return e.complexity.Query.PrimitiveObject(childComplexity), true

	case "Query.primitiveStringObject":
		if e.complexity.Query.PrimitiveStringObject == nil {
			break
		}

		return e.complexity.Query.PrimitiveStringObject(childComplexity), true

	case "Query.ptrToAnyContainer":
		if e.complexity.Query.PtrToAnyContainer == nil {
			break
		}

		return e.complexity.Query.PtrToAnyContainer(childComplexity), true

	case "Query.ptrToSliceContainer":
		if e.complexity.Query.PtrToSliceContainer == nil {
			break
		}

		return e.complexity.Query.PtrToSliceContainer(childComplexity), true

	case "Query.recursive":
		if e.complexity.Query.Recursive == nil {
			break
		}

		args, err := ec.field_Query_recursive_args(context.TODO(), rawArgs)
		if err != nil {
			return 0, false
		}

		return e.complexity.Query.Recursive(childComplexity, args["input"].(*RecursiveInputSlice)), true

	case "Query.scalarSlice":
		if e.complexity.Query.ScalarSlice == nil {
			break
		}

		return e.complexity.Query.ScalarSlice(childComplexity), true

	case "Query.shapeUnion":
		if e.complexity.Query.ShapeUnion == nil {
			break
		}

		return e.complexity.Query.ShapeUnion(childComplexity), true

	case "Query.shapes":
		if e.complexity.Query.Shapes == nil {
			break
		}

		return e.complexity.Query.Shapes(childComplexity), true

	case "Query.slices":
		if e.complexity.Query.Slices == nil {
			break
		}

		return e.complexity.Query.Slices(childComplexity), true

	case "Query.stringFromContextFunction":
		if e.complexity.Query.StringFromContextFunction == nil {
			break
		}

		return e.complexity.Query.StringFromContextFunction(childComplexity), true

	case "Query.stringFromContextInterface":
		if e.complexity.Query.StringFromContextInterface == nil {
			break
		}

		return e.complexity.Query.StringFromContextInterface(childComplexity), true

	case "Query.user":
		if e.complexity.Query.User == nil {
			break
		}

		args, err := ec.field_Query_user_args(context.TODO(), rawArgs)
		if err != nil {
			return 0, false
		}

		return e.complexity.Query.User(childComplexity, args["id"].(int)), true

	case "Query.vOkCaseNil":
		if e.complexity.Query.VOkCaseNil == nil {
			break
		}

		return e.complexity.Query.VOkCaseNil(childComplexity), true

	case "Query.vOkCaseValue":
		if e.complexity.Query.VOkCaseValue == nil {
			break
		}

		return e.complexity.Query.VOkCaseValue(childComplexity), true

	case "Query.valid":
		if e.complexity.Query.Valid == nil {
			break
		}

		return e.complexity.Query.Valid(childComplexity), true

	case "Query.validType":
		if e.complexity.Query.ValidType == nil {
			break
		}

		return e.complexity.Query.ValidType(childComplexity), true

	case "Query.variadicModel":
		if e.complexity.Query.VariadicModel == nil {
			break
		}

		return e.complexity.Query.VariadicModel(childComplexity), true

	case "Query.wrappedMap":
		if e.complexity.Query.WrappedMap == nil {
			break
		}

		return e.complexity.Query.WrappedMap(childComplexity), true

	case "Query.wrappedScalar":
		if e.complexity.Query.WrappedScalar == nil {
			break
		}

		return e.complexity.Query.WrappedScalar(childComplexity), true

	case "Query.wrappedSlice":
		if e.complexity.Query.WrappedSlice == nil {
			break
		}

		return e.complexity.Query.WrappedSlice(childComplexity), true

	case "Query.wrappedStruct":
		if e.complexity.Query.WrappedStruct == nil {
			break
		}

		return e.complexity.Query.WrappedStruct(childComplexity), true

	case "Rectangle.area":
		if e.complexity.Rectangle.Area == nil {
			break
		}

		return e.complexity.Rectangle.Area(childComplexity), true

	case "Rectangle.coordinates":
		if e.complexity.Rectangle.Coordinates == nil {
			break
		}

		return e.complexity.Rectangle.Coordinates(childComplexity), true

	case "Rectangle.length":
		if e.complexity.Rectangle.Length == nil {
			break
		}

		return e.complexity.Rectangle.Length(childComplexity), true

	case "Rectangle.width":
		if e.complexity.Rectangle.Width == nil {
			break
		}

		return e.complexity.Rectangle.Width(childComplexity), true

	case "Size.height":
		if e.complexity.Size.Height == nil {
			break
		}

		return e.complexity.Size.Height(childComplexity), true

	case "Size.weight":
		if e.complexity.Size.Weight == nil {
			break
		}

		return e.complexity.Size.Weight(childComplexity), true

	case "Slices.test1":
		if e.complexity.Slices.Test1 == nil {
			break
		}

		return e.complexity.Slices.Test1(childComplexity), true

	case "Slices.test2":
		if e.complexity.Slices.Test2 == nil {
			break
		}

		return e.complexity.Slices.Test2(childComplexity), true

	case "Slices.test3":
		if e.complexity.Slices.Test3 == nil {
			break
		}

		return e.complexity.Slices.Test3(childComplexity), true

	case "Slices.test4":
		if e.complexity.Slices.Test4 == nil {
			break
		}

		return e.complexity.Slices.Test4(childComplexity), true

	case "Subscription.directiveArg":
		if e.complexity.Subscription.DirectiveArg == nil {
			break
		}

		args, err := ec.field_Subscription_directiveArg_args(context.TODO(), rawArgs)
		if err != nil {
			return 0, false
		}

		return e.complexity.Subscription.DirectiveArg(childComplexity, args["arg"].(string)), true

	case "Subscription.directiveDouble":
		if e.complexity.Subscription.DirectiveDouble == nil {
			break
		}

		return e.complexity.Subscription.DirectiveDouble(childComplexity), true

	case "Subscription.directiveNullableArg":
		if e.complexity.Subscription.DirectiveNullableArg == nil {
			break
		}

		args, err := ec.field_Subscription_directiveNullableArg_args(context.TODO(), rawArgs)
		if err != nil {
			return 0, false
		}

		return e.complexity.Subscription.DirectiveNullableArg(childComplexity, args["arg"].(*int), args["arg2"].(*int), args["arg3"].(*string)), true

	case "Subscription.directiveUnimplemented":
		if e.complexity.Subscription.DirectiveUnimplemented == nil {
			break
		}

		return e.complexity.Subscription.DirectiveUnimplemented(childComplexity), true

	case "Subscription.errorRequired":
		if e.complexity.Subscription.ErrorRequired == nil {
			break
		}

		return e.complexity.Subscription.ErrorRequired(childComplexity), true

	case "Subscription.initPayload":
		if e.complexity.Subscription.InitPayload == nil {
			break
		}

		return e.complexity.Subscription.InitPayload(childComplexity), true

	case "Subscription.issue896b":
		if e.complexity.Subscription.Issue896b == nil {
			break
		}

		return e.complexity.Subscription.Issue896b(childComplexity), true

	case "Subscription.updated":
		if e.complexity.Subscription.Updated == nil {
			break
		}

		return e.complexity.Subscription.Updated(childComplexity), true

	case "User.created":
		if e.complexity.User.Created == nil {
			break
		}

		return e.complexity.User.Created(childComplexity), true

	case "User.friends":
		if e.complexity.User.Friends == nil {
			break
		}

		return e.complexity.User.Friends(childComplexity), true

	case "User.id":
		if e.complexity.User.ID == nil {
			break
		}

		return e.complexity.User.ID(childComplexity), true

	case "User.pets":
		if e.complexity.User.Pets == nil {
			break
		}

		args, err := ec.field_User_pets_args(context.TODO(), rawArgs)
		if err != nil {
			return 0, false
		}

		return e.complexity.User.Pets(childComplexity, args["limit"].(*int)), true

	case "User.updated":
		if e.complexity.User.Updated == nil {
			break
		}

		return e.complexity.User.Updated(childComplexity), true

	case "VOkCaseNil.value":
		if e.complexity.VOkCaseNil.Value == nil {
			break
		}

		return e.complexity.VOkCaseNil.Value(childComplexity), true

	case "VOkCaseValue.value":
		if e.complexity.VOkCaseValue.Value == nil {
			break
		}

		return e.complexity.VOkCaseValue.Value(childComplexity), true

	case "ValidType.differentCase":
		if e.complexity.ValidType.DifferentCase == nil {
			break
		}

		return e.complexity.ValidType.DifferentCase(childComplexity), true

	case "ValidType.different_case":
		if e.complexity.ValidType.DifferentCaseOld == nil {
			break
		}

		return e.complexity.ValidType.DifferentCaseOld(childComplexity), true

	case "ValidType.validArgs":
		if e.complexity.ValidType.ValidArgs == nil {
			break
		}

		args, err := ec.field_ValidType_validArgs_args(context.TODO(), rawArgs)
		if err != nil {
			return 0, false
		}

		return e.complexity.ValidType.ValidArgs(childComplexity, args["break"].(string), args["default"].(string), args["func"].(string), args["interface"].(string), args["select"].(string), args["case"].(string), args["defer"].(string), args["go"].(string), args["map"].(string), args["struct"].(string), args["chan"].(string), args["else"].(string), args["goto"].(string), args["package"].(string), args["switch"].(string), args["const"].(string), args["fallthrough"].(string), args["if"].(string), args["range"].(string), args["type"].(string), args["continue"].(string), args["for"].(string), args["import"].(string), args["return"].(string), args["var"].(string), args["_"].(string)), true

	case "ValidType.validInputKeywords":
		if e.complexity.ValidType.ValidInputKeywords == nil {
			break
		}

		args, err := ec.field_ValidType_validInputKeywords_args(context.TODO(), rawArgs)
		if err != nil {
			return 0, false
		}

		return e.complexity.ValidType.ValidInputKeywords(childComplexity, args["input"].(*ValidInput)), true

	case "VariadicModel.value":
		if e.complexity.VariadicModel.Value == nil {
			break
		}

		args, err := ec.field_VariadicModel_value_args(context.TODO(), rawArgs)
		if err != nil {
			return 0, false
		}

		return e.complexity.VariadicModel.Value(childComplexity, args["rank"].(int)), true

	case "WrappedMap.get":
		if e.complexity.WrappedMap.Get == nil {
			break
		}

		args, err := ec.field_WrappedMap_get_args(context.TODO(), rawArgs)
		if err != nil {
			return 0, false
		}

		return e.complexity.WrappedMap.Get(childComplexity, args["key"].(string)), true

	case "WrappedSlice.get":
		if e.complexity.WrappedSlice.Get == nil {
			break
		}

		args, err := ec.field_WrappedSlice_get_args(context.TODO(), rawArgs)
		if err != nil {
			return 0, false
		}

		return e.complexity.WrappedSlice.Get(childComplexity, args["idx"].(int)), true

	case "WrappedStruct.desc":
		if e.complexity.WrappedStruct.Desc == nil {
			break
		}

		return e.complexity.WrappedStruct.Desc(childComplexity), true

	case "WrappedStruct.name":
		if e.complexity.WrappedStruct.Name == nil {
			break
		}

		return e.complexity.WrappedStruct.Name(childComplexity), true

	case "XXIt.id":
		if e.complexity.XXIt.ID == nil {
			break
		}

		return e.complexity.XXIt.ID(childComplexity), true

	case "XxIt.id":
		if e.complexity.XxIt.ID == nil {
			break
		}

		return e.complexity.XxIt.ID(childComplexity), true

	case "asdfIt.id":
		if e.complexity.AsdfIt.ID == nil {
			break
		}

		return e.complexity.AsdfIt.ID(childComplexity), true

	case "iIt.id":
		if e.complexity.IIt.ID == nil {
			break
		}

		return e.complexity.IIt.ID(childComplexity), true

	}
	return 0, false
}

func (e *executableSchema) Exec(ctx context.Context) graphql.ResponseHandler {
	rc := graphql.GetOperationContext(ctx)
	ec := executionContext{rc, e, 0, 0, make(chan graphql.DeferredResult)}
	inputUnmarshalMap := graphql.BuildUnmarshalerMap(
		ec.unmarshalInputChanges,
		ec.unmarshalInputDefaultInput,
		ec.unmarshalInputFieldsOrderInput,
		ec.unmarshalInputInnerDirectives,
		ec.unmarshalInputInnerInput,
		ec.unmarshalInputInputDirectives,
		ec.unmarshalInputInputWithEnumValue,
		ec.unmarshalInputMapNestedInput,
		ec.unmarshalInputMapStringInterfaceInput,
		ec.unmarshalInputNestedInput,
		ec.unmarshalInputNestedMapInput,
		ec.unmarshalInputOmittableInput,
		ec.unmarshalInputOuterInput,
		ec.unmarshalInputRecursiveInputSlice,
		ec.unmarshalInputSpecialInput,
		ec.unmarshalInputUpdatePtrToPtrInner,
		ec.unmarshalInputUpdatePtrToPtrOuter,
		ec.unmarshalInputValidInput,
	)
	first := true

	switch rc.Operation.Operation {
	case ast.Query:
		return func(ctx context.Context) *graphql.Response {
			var response graphql.Response
			var data graphql.Marshaler
			if first {
				first = false
				ctx = graphql.WithUnmarshalerMap(ctx, inputUnmarshalMap)
				data = ec._Query(ctx, rc.Operation.SelectionSet)
			} else {
				if atomic.LoadInt32(&ec.pendingDeferred) > 0 {
					result := <-ec.deferredResults
					atomic.AddInt32(&ec.pendingDeferred, -1)
					data = result.Result
					response.Path = result.Path
					response.Label = result.Label
					response.Errors = result.Errors
				} else {
					return nil
				}
			}
			var buf bytes.Buffer
			data.MarshalGQL(&buf)
			response.Data = buf.Bytes()
			if atomic.LoadInt32(&ec.deferred) > 0 {
				hasNext := atomic.LoadInt32(&ec.pendingDeferred) > 0
				response.HasNext = &hasNext
			}

			return &response
		}
	case ast.Mutation:
		return func(ctx context.Context) *graphql.Response {
			if !first {
				return nil
			}
			first = false
			ctx = graphql.WithUnmarshalerMap(ctx, inputUnmarshalMap)
			data := ec._Mutation(ctx, rc.Operation.SelectionSet)
			var buf bytes.Buffer
			data.MarshalGQL(&buf)

			return &graphql.Response{
				Data: buf.Bytes(),
			}
		}
	case ast.Subscription:
		next := ec._Subscription(ctx, rc.Operation.SelectionSet)

		var buf bytes.Buffer
		return func(ctx context.Context) *graphql.Response {
			buf.Reset()
			data := next(ctx)

			if data == nil {
				return nil
			}
			data.MarshalGQL(&buf)

			return &graphql.Response{
				Data: buf.Bytes(),
			}
		}

	default:
		return graphql.OneShot(graphql.ErrorResponse(ctx, "unsupported GraphQL operation"))
	}
}

type executionContext struct {
	*graphql.OperationContext
	*executableSchema
	deferred        int32
	pendingDeferred int32
	deferredResults chan graphql.DeferredResult
}

func (ec *executionContext) processDeferredGroup(dg graphql.DeferredGroup) {
	atomic.AddInt32(&ec.pendingDeferred, 1)
	go func() {
		ctx := graphql.WithFreshResponseContext(dg.Context)
		dg.FieldSet.Dispatch(ctx)
		ds := graphql.DeferredResult{
			Path:   dg.Path,
			Label:  dg.Label,
			Result: dg.FieldSet,
			Errors: graphql.GetErrors(ctx),
		}
		// null fields should bubble up
		if dg.FieldSet.Invalids > 0 {
			ds.Result = graphql.Null
		}
		ec.deferredResults <- ds
	}()
}

func (ec *executionContext) introspectSchema() (*introspection.Schema, error) {
	if ec.DisableIntrospection {
		return nil, errors.New("introspection disabled")
	}
	return introspection.WrapSchema(ec.Schema()), nil
}

func (ec *executionContext) introspectType(name string) (*introspection.Type, error) {
	if ec.DisableIntrospection {
		return nil, errors.New("introspection disabled")
	}
	return introspection.WrapTypeFromDef(ec.Schema(), ec.Schema().Types[name]), nil
}

//go:embed "builtinscalar.graphql" "complexity.graphql" "defaults.graphql" "defer.graphql" "directive.graphql" "embedded.graphql" "enum.graphql" "fields_order.graphql" "interfaces.graphql" "issue896.graphql" "loops.graphql" "maps.graphql" "mutation_with_custom_scalar.graphql" "nulls.graphql" "panics.graphql" "primitive_objects.graphql" "ptr_to_any.graphql" "ptr_to_ptr_input.graphql" "ptr_to_slice.graphql" "scalar_context.graphql" "scalar_default.graphql" "schema.graphql" "slices.graphql" "typefallback.graphql" "useptr.graphql" "v-ok.graphql" "validtypes.graphql" "variadic.graphql" "weird_type_cases.graphql" "wrapped_type.graphql"
var sourcesFS embed.FS

func sourceData(filename string) string {
	data, err := sourcesFS.ReadFile(filename)
	if err != nil {
		panic(fmt.Sprintf("codegen problem: %s not available", filename))
	}
	return string(data)
}

var sources = []*ast.Source{
	{Name: "builtinscalar.graphql", Input: sourceData("builtinscalar.graphql"), BuiltIn: false},
	{Name: "complexity.graphql", Input: sourceData("complexity.graphql"), BuiltIn: false},
	{Name: "defaults.graphql", Input: sourceData("defaults.graphql"), BuiltIn: false},
	{Name: "defer.graphql", Input: sourceData("defer.graphql"), BuiltIn: false},
	{Name: "directive.graphql", Input: sourceData("directive.graphql"), BuiltIn: false},
	{Name: "embedded.graphql", Input: sourceData("embedded.graphql"), BuiltIn: false},
	{Name: "enum.graphql", Input: sourceData("enum.graphql"), BuiltIn: false},
	{Name: "fields_order.graphql", Input: sourceData("fields_order.graphql"), BuiltIn: false},
	{Name: "interfaces.graphql", Input: sourceData("interfaces.graphql"), BuiltIn: false},
	{Name: "issue896.graphql", Input: sourceData("issue896.graphql"), BuiltIn: false},
	{Name: "loops.graphql", Input: sourceData("loops.graphql"), BuiltIn: false},
	{Name: "maps.graphql", Input: sourceData("maps.graphql"), BuiltIn: false},
	{Name: "mutation_with_custom_scalar.graphql", Input: sourceData("mutation_with_custom_scalar.graphql"), BuiltIn: false},
	{Name: "nulls.graphql", Input: sourceData("nulls.graphql"), BuiltIn: false},
	{Name: "panics.graphql", Input: sourceData("panics.graphql"), BuiltIn: false},
	{Name: "primitive_objects.graphql", Input: sourceData("primitive_objects.graphql"), BuiltIn: false},
	{Name: "ptr_to_any.graphql", Input: sourceData("ptr_to_any.graphql"), BuiltIn: false},
	{Name: "ptr_to_ptr_input.graphql", Input: sourceData("ptr_to_ptr_input.graphql"), BuiltIn: false},
	{Name: "ptr_to_slice.graphql", Input: sourceData("ptr_to_slice.graphql"), BuiltIn: false},
	{Name: "scalar_context.graphql", Input: sourceData("scalar_context.graphql"), BuiltIn: false},
	{Name: "scalar_default.graphql", Input: sourceData("scalar_default.graphql"), BuiltIn: false},
	{Name: "schema.graphql", Input: sourceData("schema.graphql"), BuiltIn: false},
	{Name: "slices.graphql", Input: sourceData("slices.graphql"), BuiltIn: false},
	{Name: "typefallback.graphql", Input: sourceData("typefallback.graphql"), BuiltIn: false},
	{Name: "useptr.graphql", Input: sourceData("useptr.graphql"), BuiltIn: false},
	{Name: "v-ok.graphql", Input: sourceData("v-ok.graphql"), BuiltIn: false},
	{Name: "validtypes.graphql", Input: sourceData("validtypes.graphql"), BuiltIn: false},
	{Name: "variadic.graphql", Input: sourceData("variadic.graphql"), BuiltIn: false},
	{Name: "weird_type_cases.graphql", Input: sourceData("weird_type_cases.graphql"), BuiltIn: false},
	{Name: "wrapped_type.graphql", Input: sourceData("wrapped_type.graphql"), BuiltIn: false},
}
var parsedSchema = gqlparser.MustLoadSchema(sources...)
