//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::cell::UnsafeCell;
use core::ffi::*;
use core::marker::{PhantomData, PhantomPinned};
use core::ptr::NonNull;
use objc2::__framework_prelude::*;
#[cfg(feature = "objc2-core-foundation")]
use objc2_core_foundation::*;
#[cfg(feature = "objc2-core-midi")]
use objc2_core_midi::*;

use crate::*;

/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kmusiceventtype_null?language=objc)
pub const kMusicEventType_NULL: u32 = 0;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kmusiceventtype_extendednote?language=objc)
pub const kMusicEventType_ExtendedNote: u32 = 1;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kmusiceventtype_extendedtempo?language=objc)
pub const kMusicEventType_ExtendedTempo: u32 = 3;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kmusiceventtype_user?language=objc)
pub const kMusicEventType_User: u32 = 4;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kmusiceventtype_meta?language=objc)
pub const kMusicEventType_Meta: u32 = 5;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kmusiceventtype_midinotemessage?language=objc)
pub const kMusicEventType_MIDINoteMessage: u32 = 6;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kmusiceventtype_midichannelmessage?language=objc)
pub const kMusicEventType_MIDIChannelMessage: u32 = 7;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kmusiceventtype_midirawdata?language=objc)
pub const kMusicEventType_MIDIRawData: u32 = 8;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kmusiceventtype_parameter?language=objc)
pub const kMusicEventType_Parameter: u32 = 9;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kmusiceventtype_aupreset?language=objc)
pub const kMusicEventType_AUPreset: u32 = 10;

/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/musiceventtype?language=objc)
pub type MusicEventType = u32;

/// Flags used to customise loading behaviour
///
/// If this flag is set the resultant Sequence will contain:
/// a tempo track
/// a track for each track found in the SMF
/// This is the default behavior
///
/// If this flag is set the resultant Sequence will contain:
/// a tempo track
/// 1 track for each MIDI Channel that is found in the SMF
/// 1 track for SysEx or MetaEvents - this will be the last track
/// in the sequence after the LoadSMFWithFlags calls
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/musicsequenceloadflags?language=objc)
// NS_OPTIONS
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct MusicSequenceLoadFlags(pub u32);
bitflags::bitflags! {
    impl MusicSequenceLoadFlags: u32 {
        #[doc(alias = "kMusicSequenceLoadSMF_PreserveTracks")]
        const SMF_PreserveTracks = 0;
        #[doc(alias = "kMusicSequenceLoadSMF_ChannelsToTracks")]
        const SMF_ChannelsToTracks = 1<<0;
    }
}

unsafe impl Encode for MusicSequenceLoadFlags {
    const ENCODING: Encoding = u32::ENCODING;
}

unsafe impl RefEncode for MusicSequenceLoadFlags {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// A sequence type
///
/// Different sequence types to describe the basic mode of operation of a sequence's time line
/// You cannot change a music sequence's type to samples/seconds if there are tempo events
/// The type will also define how the sequence is saved to a MIDI file:
/// Beats - normal midi file
/// Seconds - midi file with SMPTE time
/// Samples - cannot be saved to a midi file
///
/// The default/normal type of a sequence.
/// Tempo track defines the number of beats per second and can have multiple tempo events
///
/// A music sequence with a single 60bpm tempo event
///
/// A music sequence with a single tempo event that represents the audio sample rate
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/musicsequencetype?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct MusicSequenceType(pub u32);
impl MusicSequenceType {
    #[doc(alias = "kMusicSequenceType_Beats")]
    pub const Beats: Self = Self(0x62656174);
    #[doc(alias = "kMusicSequenceType_Seconds")]
    pub const Seconds: Self = Self(0x73656373);
    #[doc(alias = "kMusicSequenceType_Samples")]
    pub const Samples: Self = Self(0x73616d70);
}

unsafe impl Encode for MusicSequenceType {
    const ENCODING: Encoding = u32::ENCODING;
}

unsafe impl RefEncode for MusicSequenceType {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// describes different types of files that can be parsed by a music sequence
///
/// let the system read iMelody files and read and write MIDI files (and any future types)
///
/// read and write MIDI files
///
/// read iMelody files
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/musicsequencefiletypeid?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct MusicSequenceFileTypeID(pub u32);
impl MusicSequenceFileTypeID {
    #[doc(alias = "kMusicSequenceFile_AnyType")]
    pub const AnyType: Self = Self(0);
    #[doc(alias = "kMusicSequenceFile_MIDIType")]
    pub const MIDIType: Self = Self(0x6d696469);
    #[doc(alias = "kMusicSequenceFile_iMelodyType")]
    pub const iMelodyType: Self = Self(0x696d656c);
}

unsafe impl Encode for MusicSequenceFileTypeID {
    const ENCODING: Encoding = u32::ENCODING;
}

unsafe impl RefEncode for MusicSequenceFileTypeID {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// controls the behaviour of the create file calls
///
/// Does not overwrite existing files.  Attempts to save over an existing file
/// will return kAudio_FilePermissionError
///
/// Erase an existing file when creating a new file
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/musicsequencefileflags?language=objc)
// NS_OPTIONS
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct MusicSequenceFileFlags(pub u32);
bitflags::bitflags! {
    impl MusicSequenceFileFlags: u32 {
        #[doc(alias = "kMusicSequenceFileFlags_Default")]
        const Default = 0;
        #[doc(alias = "kMusicSequenceFileFlags_EraseFile")]
        const EraseFile = 1;
    }
}

unsafe impl Encode for MusicSequenceFileFlags {
    const ENCODING: Encoding = u32::ENCODING;
}

unsafe impl RefEncode for MusicSequenceFileFlags {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// The type used to refer to time values in a music sequence
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/musictimestamp?language=objc)
pub type MusicTimeStamp = f64;

/// The parameters to specify a MIDI note
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/midinotemessage?language=objc)
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct MIDINoteMessage {
    pub channel: u8,
    pub note: u8,
    pub velocity: u8,
    pub releaseVelocity: u8,
    pub duration: f32,
}

unsafe impl Encode for MIDINoteMessage {
    const ENCODING: Encoding = Encoding::Struct(
        "MIDINoteMessage",
        &[
            <u8>::ENCODING,
            <u8>::ENCODING,
            <u8>::ENCODING,
            <u8>::ENCODING,
            <f32>::ENCODING,
        ],
    );
}

unsafe impl RefEncode for MIDINoteMessage {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// The parameters to specify a MIDI channel message
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/midichannelmessage?language=objc)
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct MIDIChannelMessage {
    pub status: u8,
    pub data1: u8,
    pub data2: u8,
    pub reserved: u8,
}

unsafe impl Encode for MIDIChannelMessage {
    const ENCODING: Encoding = Encoding::Struct(
        "MIDIChannelMessage",
        &[
            <u8>::ENCODING,
            <u8>::ENCODING,
            <u8>::ENCODING,
            <u8>::ENCODING,
        ],
    );
}

unsafe impl RefEncode for MIDIChannelMessage {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// Generally used to represent a MIDI SysEx message
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/midirawdata?language=objc)
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct MIDIRawData {
    pub length: u32,
    pub data: [u8; 1],
}

unsafe impl Encode for MIDIRawData {
    const ENCODING: Encoding =
        Encoding::Struct("MIDIRawData", &[<u32>::ENCODING, <[u8; 1]>::ENCODING]);
}

unsafe impl RefEncode for MIDIRawData {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// The parameters to specify a MIDI meta event
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/midimetaevent?language=objc)
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct MIDIMetaEvent {
    pub metaEventType: u8,
    pub unused1: u8,
    pub unused2: u8,
    pub unused3: u8,
    pub dataLength: u32,
    pub data: [u8; 1],
}

unsafe impl Encode for MIDIMetaEvent {
    const ENCODING: Encoding = Encoding::Struct(
        "MIDIMetaEvent",
        &[
            <u8>::ENCODING,
            <u8>::ENCODING,
            <u8>::ENCODING,
            <u8>::ENCODING,
            <u32>::ENCODING,
            <[u8; 1]>::ENCODING,
        ],
    );
}

unsafe impl RefEncode for MIDIMetaEvent {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// Provides a general struct for specifying a user defined event.
///
/// the size in bytes of the data
///
/// size bytes of user defined event data
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/musiceventuserdata?language=objc)
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct MusicEventUserData {
    pub length: u32,
    pub data: [u8; 1],
}

unsafe impl Encode for MusicEventUserData {
    const ENCODING: Encoding = Encoding::Struct(
        "MusicEventUserData",
        &[<u32>::ENCODING, <[u8; 1]>::ENCODING],
    );
}

unsafe impl RefEncode for MusicEventUserData {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// The parameters to specify an extended note on event
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/extendednoteonevent?language=objc)
#[cfg(all(feature = "AUComponent", feature = "MusicDevice"))]
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct ExtendedNoteOnEvent {
    pub instrumentID: MusicDeviceInstrumentID,
    pub groupID: MusicDeviceGroupID,
    pub duration: f32,
    pub extendedParams: MusicDeviceNoteParams,
}

#[cfg(all(feature = "AUComponent", feature = "MusicDevice"))]
unsafe impl Encode for ExtendedNoteOnEvent {
    const ENCODING: Encoding = Encoding::Struct(
        "ExtendedNoteOnEvent",
        &[
            <MusicDeviceInstrumentID>::ENCODING,
            <MusicDeviceGroupID>::ENCODING,
            <f32>::ENCODING,
            <MusicDeviceNoteParams>::ENCODING,
        ],
    );
}

#[cfg(all(feature = "AUComponent", feature = "MusicDevice"))]
unsafe impl RefEncode for ExtendedNoteOnEvent {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// The parameters to specify a parameter event to an audio unit.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/parameterevent?language=objc)
#[cfg(feature = "AUComponent")]
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct ParameterEvent {
    pub parameterID: AudioUnitParameterID,
    pub scope: AudioUnitScope,
    pub element: AudioUnitElement,
    pub value: AudioUnitParameterValue,
}

#[cfg(feature = "AUComponent")]
unsafe impl Encode for ParameterEvent {
    const ENCODING: Encoding = Encoding::Struct(
        "ParameterEvent",
        &[
            <AudioUnitParameterID>::ENCODING,
            <AudioUnitScope>::ENCODING,
            <AudioUnitElement>::ENCODING,
            <AudioUnitParameterValue>::ENCODING,
        ],
    );
}

#[cfg(feature = "AUComponent")]
unsafe impl RefEncode for ParameterEvent {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// specifies the value for a tempo in beats per minute
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/extendedtempoevent?language=objc)
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct ExtendedTempoEvent {
    pub bpm: f64,
}

unsafe impl Encode for ExtendedTempoEvent {
    const ENCODING: Encoding = Encoding::Struct("ExtendedTempoEvent", &[<f64>::ENCODING]);
}

unsafe impl RefEncode for ExtendedTempoEvent {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// The parameters to specify a preset for an audio unit.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/aupresetevent?language=objc)
#[cfg(all(feature = "AUComponent", feature = "objc2-core-foundation"))]
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct AUPresetEvent {
    pub scope: AudioUnitScope,
    pub element: AudioUnitElement,
    pub preset: NonNull<CFPropertyList>,
}

#[cfg(all(feature = "AUComponent", feature = "objc2-core-foundation"))]
unsafe impl Encode for AUPresetEvent {
    const ENCODING: Encoding = Encoding::Struct(
        "AUPresetEvent",
        &[
            <AudioUnitScope>::ENCODING,
            <AudioUnitElement>::ENCODING,
            <NonNull<CFPropertyList>>::ENCODING,
        ],
    );
}

#[cfg(all(feature = "AUComponent", feature = "objc2-core-foundation"))]
unsafe impl RefEncode for AUPresetEvent {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// A display representation of a musical time in beats.
///
/// A clock's internal representation of musical time is in beats based on the
/// beginning of the timeline. Normally, such times should be displayed to the user
/// in terms of bars, beats, and subbeats (sometimes called "units" or "parts per
/// quarter" [PPQ]). This data structure is such a display representation.
///
/// By convention, bar 1 is the beginning of the sequence. Beat 1 is the first beat
/// of the measure. In 4/4 time, beat will have a value from 1 to 4. Music
/// applications often use beat divisions such as 480 and 960.
///
///
/// A measure number.
///
/// A beat number (1..n).
///
/// The numerator of the fractional number of beats.
///
/// The denominator of the fractional number of beats.
///
/// Must be 0.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/cabarbeattime?language=objc)
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct CABarBeatTime {
    pub bar: i32,
    pub beat: u16,
    pub subbeat: u16,
    pub subbeatDivisor: u16,
    pub reserved: u16,
}

unsafe impl Encode for CABarBeatTime {
    const ENCODING: Encoding = Encoding::Struct(
        "CABarBeatTime",
        &[
            <i32>::ENCODING,
            <u16>::ENCODING,
            <u16>::ENCODING,
            <u16>::ENCODING,
            <u16>::ENCODING,
        ],
    );
}

unsafe impl RefEncode for CABarBeatTime {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/opaquemusicplayer?language=objc)
#[repr(C)]
#[derive(Debug)]
pub struct OpaqueMusicPlayer {
    inner: [u8; 0],
    _p: UnsafeCell<PhantomData<(*const UnsafeCell<()>, PhantomPinned)>>,
}

unsafe impl RefEncode for OpaqueMusicPlayer {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Encoding::Struct("OpaqueMusicPlayer", &[]));
}

/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/musicplayer?language=objc)
pub type MusicPlayer = *mut OpaqueMusicPlayer;

/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/opaquemusicsequence?language=objc)
#[repr(C)]
#[derive(Debug)]
pub struct OpaqueMusicSequence {
    inner: [u8; 0],
    _p: UnsafeCell<PhantomData<(*const UnsafeCell<()>, PhantomPinned)>>,
}

unsafe impl RefEncode for OpaqueMusicSequence {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Encoding::Struct("OpaqueMusicSequence", &[]));
}

/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/musicsequence?language=objc)
pub type MusicSequence = *mut OpaqueMusicSequence;

/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/opaquemusictrack?language=objc)
#[repr(C)]
#[derive(Debug)]
pub struct OpaqueMusicTrack {
    inner: [u8; 0],
    _p: UnsafeCell<PhantomData<(*const UnsafeCell<()>, PhantomPinned)>>,
}

unsafe impl RefEncode for OpaqueMusicTrack {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Encoding::Struct("OpaqueMusicTrack", &[]));
}

/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/musictrack?language=objc)
pub type MusicTrack = *mut OpaqueMusicTrack;

/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/opaquemusiceventiterator?language=objc)
#[repr(C)]
#[derive(Debug)]
pub struct OpaqueMusicEventIterator {
    inner: [u8; 0],
    _p: UnsafeCell<PhantomData<(*const UnsafeCell<()>, PhantomPinned)>>,
}

unsafe impl RefEncode for OpaqueMusicEventIterator {
    const ENCODING_REF: Encoding =
        Encoding::Pointer(&Encoding::Struct("OpaqueMusicEventIterator", &[]));
}

/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/musiceventiterator?language=objc)
pub type MusicEventIterator = *mut OpaqueMusicEventIterator;

/// See MusicSequenceSetUserCallback
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/musicsequenceusercallback?language=objc)
pub type MusicSequenceUserCallback = Option<
    unsafe extern "C-unwind" fn(
        *mut c_void,
        MusicSequence,
        MusicTrack,
        MusicTimeStamp,
        NonNull<MusicEventUserData>,
        MusicTimeStamp,
        MusicTimeStamp,
    ),
>;

/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiotoolboxerr_invalidsequencetype?language=objc)
pub const kAudioToolboxErr_InvalidSequenceType: OSStatus = -10846;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiotoolboxerr_trackindexerror?language=objc)
pub const kAudioToolboxErr_TrackIndexError: OSStatus = -10859;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiotoolboxerr_tracknotfound?language=objc)
pub const kAudioToolboxErr_TrackNotFound: OSStatus = -10858;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiotoolboxerr_endoftrack?language=objc)
pub const kAudioToolboxErr_EndOfTrack: OSStatus = -10857;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiotoolboxerr_startoftrack?language=objc)
pub const kAudioToolboxErr_StartOfTrack: OSStatus = -10856;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiotoolboxerr_illegaltrackdestination?language=objc)
pub const kAudioToolboxErr_IllegalTrackDestination: OSStatus = -10855;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiotoolboxerr_nosequence?language=objc)
pub const kAudioToolboxErr_NoSequence: OSStatus = -10854;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiotoolboxerr_invalideventtype?language=objc)
pub const kAudioToolboxErr_InvalidEventType: OSStatus = -10853;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiotoolboxerr_invalidplayerstate?language=objc)
pub const kAudioToolboxErr_InvalidPlayerState: OSStatus = -10852;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiotoolboxerr_cannotdoincurrentcontext?language=objc)
pub const kAudioToolboxErr_CannotDoInCurrentContext: OSStatus = -10863;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiotoolboxerror_notrackdestination?language=objc)
pub const kAudioToolboxError_NoTrackDestination: OSStatus = -66720;

/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/ksequencetrackproperty_loopinfo?language=objc)
pub const kSequenceTrackProperty_LoopInfo: u32 = 0;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/ksequencetrackproperty_offsettime?language=objc)
pub const kSequenceTrackProperty_OffsetTime: u32 = 1;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/ksequencetrackproperty_mutestatus?language=objc)
pub const kSequenceTrackProperty_MuteStatus: u32 = 2;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/ksequencetrackproperty_solostatus?language=objc)
pub const kSequenceTrackProperty_SoloStatus: u32 = 3;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/ksequencetrackproperty_automatedparameters?language=objc)
pub const kSequenceTrackProperty_AutomatedParameters: u32 = 4;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/ksequencetrackproperty_tracklength?language=objc)
pub const kSequenceTrackProperty_TrackLength: u32 = 5;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/ksequencetrackproperty_timeresolution?language=objc)
pub const kSequenceTrackProperty_TimeResolution: u32 = 6;

/// Used to control the looping behaviour of a track
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/musictrackloopinfo?language=objc)
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct MusicTrackLoopInfo {
    pub loopDuration: MusicTimeStamp,
    pub numberOfLoops: i32,
}

unsafe impl Encode for MusicTrackLoopInfo {
    const ENCODING: Encoding = Encoding::Struct(
        "MusicTrackLoopInfo",
        &[<MusicTimeStamp>::ENCODING, <i32>::ENCODING],
    );
}

unsafe impl RefEncode for MusicTrackLoopInfo {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

extern "C-unwind" {
    /// Create a new music player
    ///
    /// A music player is used to play a sequence back. This call is used to create a player
    /// When a sequence is to be played by a player, it can play to either an AUGraph, a MIDI Destination or a
    /// mixture/combination of both.
    ///
    /// Parameter `outPlayer`: the newly created player
    pub fn NewMusicPlayer(out_player: NonNull<MusicPlayer>) -> OSStatus;
}

extern "C-unwind" {
    /// Dispose a music player
    ///
    /// Parameter `inPlayer`: the player to dispose
    pub fn DisposeMusicPlayer(in_player: MusicPlayer) -> OSStatus;
}

extern "C-unwind" {
    /// Set the sequence for the player to play
    ///
    /// A Sequence cannot be set on a player while it is playing. Setting a sequence
    /// will overide the currently set sequence.
    ///
    /// Parameter `inPlayer`: the player
    ///
    /// Parameter `inSequence`: the sequence for the player to play
    pub fn MusicPlayerSetSequence(in_player: MusicPlayer, in_sequence: MusicSequence) -> OSStatus;
}

extern "C-unwind" {
    /// Get the sequence attached to a player
    ///
    /// If the player does not have a sequence set, this will return the _NoSequence error
    ///
    /// Parameter `inPlayer`: the player
    ///
    /// Parameter `outSequence`: the sequence currently set on the player
    pub fn MusicPlayerGetSequence(
        in_player: MusicPlayer,
        out_sequence: NonNull<MusicSequence>,
    ) -> OSStatus;
}

extern "C-unwind" {
    /// Set the current time on the player
    ///
    /// The Get and Set Time calls take a specification of time as beats. This positions the player
    /// to the specified time based on the currently set sequence. No range checking on the time value
    /// is done. This can be set on a playing player (in which case playing will be resumed from the
    /// new time).
    ///
    /// Parameter `inPlayer`: the player
    ///
    /// Parameter `inTime`: the new time value
    pub fn MusicPlayerSetTime(in_player: MusicPlayer, in_time: MusicTimeStamp) -> OSStatus;
}

extern "C-unwind" {
    /// Get the current time of the player
    ///
    /// The Get and Set Time calls take a specification of time as beats. This retrieves the player's
    /// current time. If it is playing this time is the time of the player at the time the call was made.
    ///
    /// Parameter `inPlayer`: the player
    ///
    /// Parameter `outTime`: the current time value
    pub fn MusicPlayerGetTime(
        in_player: MusicPlayer,
        out_time: NonNull<MusicTimeStamp>,
    ) -> OSStatus;
}

extern "C-unwind" {
    /// Returns the host time that will be (or was) played at the specified beat.
    ///
    /// This call is only valid if the player is playing and will return an error if the player is not playing
    /// or if the starting position of the player (its "starting beat") was after the specified beat.
    /// For general translation of beats to time in a sequence, see the MusicSequence calls for beat
    /// <
    /// ->seconds.
    ///
    /// The call uses the player's sequence's tempo map to translate a beat time from the starting time and beat
    /// of the player.
    ///
    /// Parameter `inPlayer`: the player
    ///
    /// Parameter `inBeats`: the specified beat-time value
    ///
    /// Parameter `outHostTime`: the corresponding host time
    pub fn MusicPlayerGetHostTimeForBeats(
        in_player: MusicPlayer,
        in_beats: MusicTimeStamp,
        out_host_time: NonNull<u64>,
    ) -> OSStatus;
}

extern "C-unwind" {
    /// Returns the beat that will be (or was) played at the specified host time.
    ///
    /// This call is only valid if the player is playing and will return an error if the player is not playing
    /// or if the starting time of the player was after the specified host time.
    /// For general translation of beats to time in a sequence, see the MusicSequence calls for beat
    /// <
    /// ->seconds.
    ///
    /// The call uses the player's sequence's tempo map to retrieve a beat time from the starting and specified host time.
    ///
    ///
    /// Parameter `inPlayer`: the player
    ///
    /// Parameter `inHostTime`: the specified host time value
    ///
    /// Parameter `outBeats`: the corresponding beat time
    pub fn MusicPlayerGetBeatsForHostTime(
        in_player: MusicPlayer,
        in_host_time: u64,
        out_beats: NonNull<MusicTimeStamp>,
    ) -> OSStatus;
}

extern "C-unwind" {
    /// Prepare the player for playing
    ///
    /// Allows the player to prepare its state so that starting is has a lower latency. If a player is started without
    /// being prerolled, the player will pre-roll itself and then start.
    ///
    /// Parameter `inPlayer`: the player
    pub fn MusicPlayerPreroll(in_player: MusicPlayer) -> OSStatus;
}

extern "C-unwind" {
    /// Start the player
    ///
    /// If the player has not been prerolled, it will pre-roll itself and then start.
    ///
    /// Parameter `inPlayer`: the player
    pub fn MusicPlayerStart(in_player: MusicPlayer) -> OSStatus;
}

extern "C-unwind" {
    /// Stop the player
    ///
    /// Parameter `inPlayer`: the player
    pub fn MusicPlayerStop(in_player: MusicPlayer) -> OSStatus;
}

extern "C-unwind" {
    /// Returns the playing state of the player. "Is it playing?"
    ///
    /// This call returns a non-zero value in outIsPlaying if the player has been
    /// started and not stopped. It may have "played" past the events of the attached
    /// MusicSequence, but it is still considered to be playing (and its time value increasing)
    /// until it is explicitly stopped
    ///
    /// Parameter `inPlayer`: the player
    ///
    /// Parameter `outIsPlaying`: false if not, true (non-zero) if is playing
    pub fn MusicPlayerIsPlaying(
        in_player: MusicPlayer,
        out_is_playing: NonNull<Boolean>,
    ) -> OSStatus;
}

extern "C-unwind" {
    /// Scale the playback rate of the player
    ///
    /// Parameter `inPlayer`: the player
    ///
    /// Parameter `inScaleRate`: a scalar that will be applied to the playback rate. If 2, playback is twice as fast, if
    /// 0.5 it is half as fast. As a scalar, the value must be greater than zero.
    pub fn MusicPlayerSetPlayRateScalar(in_player: MusicPlayer, in_scale_rate: f64) -> OSStatus;
}

extern "C-unwind" {
    /// Get the playback rate scalar of the player
    ///
    /// Parameter `inPlayer`: the player
    ///
    /// Parameter `outScaleRate`: the current scalar being applied to the player. Default value is 1.0
    pub fn MusicPlayerGetPlayRateScalar(
        in_player: MusicPlayer,
        out_scale_rate: NonNull<f64>,
    ) -> OSStatus;
}

extern "C-unwind" {
    /// Create a new empty sequence
    ///
    /// A new music sequence will only have a tempo track (with a default tempo of 120 bpm),
    /// and the default type is beat based.
    ///
    /// When a sequence is to be played by a player, it can play to either an AUGraph, a MIDI Destination or a
    /// mixture/combination of both. See MusicSequenceSetAUGraph and MusicSequenceSetMIDIEndpoint for the generic
    /// destination assignments. Specific tracks can also be assigned nodes of a graph or a MIDI endpoint as targets
    /// for the events that they contain; see MusicTrackSetDestNode and MusicTrackSetDestMIDIEndpoint.
    ///
    ///
    /// Parameter `outSequence`: the new sequence
    pub fn NewMusicSequence(out_sequence: NonNull<MusicSequence>) -> OSStatus;
}

extern "C-unwind" {
    /// Dispose the sequence
    ///
    /// A sequence cannot be disposed while a MusicPlayer has it.
    ///
    /// Parameter `inSequence`: the sequence
    pub fn DisposeMusicSequence(in_sequence: MusicSequence) -> OSStatus;
}

extern "C-unwind" {
    /// Add a new (empty) track to the sequence
    ///
    /// Parameter `inSequence`: the sequence
    ///
    /// Parameter `outTrack`: the new track (it is always appended to any existing tracks)
    pub fn MusicSequenceNewTrack(
        in_sequence: MusicSequence,
        out_track: NonNull<MusicTrack>,
    ) -> OSStatus;
}

extern "C-unwind" {
    /// Remove and dispose a track from a sequence
    ///
    /// Parameter `inSequence`: the sequence
    ///
    /// Parameter `inTrack`: the track to remove and dispose
    pub fn MusicSequenceDisposeTrack(in_sequence: MusicSequence, in_track: MusicTrack) -> OSStatus;
}

extern "C-unwind" {
    /// The number of tracks in a sequence.
    /// The track count and accessors exclude the tempo track (which is treated as a special case)
    ///
    /// Parameter `inSequence`: the sequence
    ///
    /// Parameter `outNumberOfTracks`: the number of tracks
    pub fn MusicSequenceGetTrackCount(
        in_sequence: MusicSequence,
        out_number_of_tracks: NonNull<u32>,
    ) -> OSStatus;
}

extern "C-unwind" {
    /// Get a track at the specified index
    ///
    /// Index is zero based. It will return kAudio_ParamError if index is not in the range: 0
    /// <
    /// TrackCount
    /// The track count and accessors exclude the tempo track (which is treated as a special case)
    ///
    /// Parameter `inSequence`: the sequence
    ///
    /// Parameter `inTrackIndex`: the index
    ///
    /// Parameter `outTrack`: the track at that index
    pub fn MusicSequenceGetIndTrack(
        in_sequence: MusicSequence,
        in_track_index: u32,
        out_track: NonNull<MusicTrack>,
    ) -> OSStatus;
}

extern "C-unwind" {
    /// Get the index for a specific track
    ///
    /// Index is zero based. It will return an error if the track is not a member of the sequence.
    /// The track count and accessors exclude the tempo track (which is treated as a special case)
    ///
    /// Parameter `inSequence`: the sequence
    ///
    /// Parameter `inTrack`: the track
    ///
    /// Parameter `outTrackIndex`: the index of the track
    pub fn MusicSequenceGetTrackIndex(
        in_sequence: MusicSequence,
        in_track: MusicTrack,
        out_track_index: NonNull<u32>,
    ) -> OSStatus;
}

extern "C-unwind" {
    /// Get the tempo track of the sequence
    ///
    /// Each sequence has a single tempo track. All tempo events are placed into this tempo track (as well
    /// as other appropriate events (time sig for instance from a MIDI file). The tempo track, once retrieved
    /// can be edited and iterated upon as any other track. Non-tempo events in a tempo track are ignored.
    ///
    /// Parameter `inSequence`: the sequence
    ///
    /// Parameter `outTrack`: the tempo track of the sequence
    pub fn MusicSequenceGetTempoTrack(
        in_sequence: MusicSequence,
        out_track: NonNull<MusicTrack>,
    ) -> OSStatus;
}

extern "C-unwind" {
    /// Set the graph to be associated with the sequence
    ///
    /// A sequence can be associated with an AUGraph and this graph will be used to render the events as
    /// controlled by the sequence when it is played. By default, all of the tracks of a sequence will
    /// find the first AUNode that is an instance of an Apple MusicDevice audio unit (see MusicSequenceGetAUGraph).
    /// Specific nodes of the graph can be targeted for different tracks (see MusicTrackSetDestNode).  To render a
    /// multi-track GM MIDI sequence on iOS, create a custom graph with a MIDISynth audio unit as the MusicDevice.
    /// If inGraph is set to NULL, the sequence will reset to use the default graph.
    ///
    /// Parameter `inSequence`: the sequence
    ///
    /// Parameter `inGraph`: the graph
    #[cfg(feature = "AUGraph")]
    pub fn MusicSequenceSetAUGraph(in_sequence: MusicSequence, in_graph: AUGraph) -> OSStatus;
}

extern "C-unwind" {
    /// Gets the graph currently associated with a sequence
    ///
    /// By default if no graph is assigned to a sequence then the sequence will create a default graph.
    /// This default graph contains a MusicDevice and a DynamicsProcessor and all tracks will be targeted
    /// to the MusicDevice.  On macOS, this MusicDevice is an instance of a software synthesizer that is
    /// compatible with the GM and GS MIDI standards.  On iOS, it is an instance of a monotimbral software
    /// synthesizer designed to render events from a single MIDI channel.  To render multi-track GM MIDI
    /// sequences on iOS, create a custom graph with a MIDISynth audio unit as the MusicDevice.
    ///
    /// This call will thus either return the graph as set by the user, or this default graph.
    ///
    /// Parameter `inSequence`: the sequence
    ///
    /// Parameter `outGraph`: the graph
    #[cfg(feature = "AUGraph")]
    pub fn MusicSequenceGetAUGraph(
        in_sequence: MusicSequence,
        out_graph: NonNull<AUGraph>,
    ) -> OSStatus;
}

extern "C-unwind" {
    /// Makes the target of all of the tracks in the sequence a MIDI endpoint
    ///
    /// This is a convenience function, and is equivalent to iterating through all of the tracks in a sequence
    /// and targeting each track to the MIDI endpoint
    ///
    ///
    /// Parameter `inSequence`: the sequence
    ///
    /// Parameter `inEndpoint`: the MIDI endpoint
    #[cfg(feature = "objc2-core-midi")]
    pub fn MusicSequenceSetMIDIEndpoint(
        in_sequence: MusicSequence,
        in_endpoint: MIDIEndpointRef,
    ) -> OSStatus;
}

extern "C-unwind" {
    /// Set the sequence type (the default is beats)
    ///
    /// These two calls allow you to get and set a MusicSequence type; specifying
    /// kMusicSequenceType_Beats        = 'beat',
    /// kMusicSequenceType_Seconds        = 'secs',
    /// kMusicSequenceType_Samples        = 'samp'
    ///
    /// The sequence type can be set to beats at any time. The sequence type can only be set to
    /// seconds or samples if there are NO tempo events already in the sequence.
    ///
    /// For beats - it can have as many tempo events as you want
    /// For Samples and Seconds - you should add a single tempo event after setting the type
    /// Samples - the tempo is the desired sample rate - e.g. 44100 and each "beat" in the sequence will be
    /// interpreted as a sample count at that sample rate (so beat == 44100 is a second)
    /// Seconds - the tempo should be set to 60 - a beat is a second.
    ///
    /// Beats is the default (and is the behaviour on pre 10.5 systems)
    ///
    /// A meta event of interest for Seconds based MIDI files is the SMPTE Offset meta event - stored in the tempo track.
    /// The sequence doesn't do anything with this event (except store/write it)
    ///
    /// Parameter `inSequence`: the sequence
    ///
    /// Parameter `inType`: the sequence type
    pub fn MusicSequenceSetSequenceType(
        in_sequence: MusicSequence,
        in_type: MusicSequenceType,
    ) -> OSStatus;
}

extern "C-unwind" {
    /// Get the sequence type
    ///
    /// See SetSequence for a full description
    ///
    /// Parameter `inSequence`: the sequence
    ///
    /// Parameter `outType`: the type
    pub fn MusicSequenceGetSequenceType(
        in_sequence: MusicSequence,
        out_type: NonNull<MusicSequenceType>,
    ) -> OSStatus;
}

extern "C-unwind" {
    /// Load the data contained within the referenced file to the sequence
    ///
    /// This function will parse the file referenced by the URL and add the events to the sequence.
    ///
    /// Parameter `inSequence`: the sequence
    ///
    /// Parameter `inFileRef`: a file:// URL that references a file
    ///
    /// Parameter `inFileTypeHint`: provides a hint to the sequence on the file type being imported. Can be zero in many cases.
    ///
    /// Parameter `inFlags`: flags that can control how the data is parsed in the file and laid out in the tracks
    /// that will be created and added to the sequence in this operation
    #[cfg(feature = "objc2-core-foundation")]
    pub fn MusicSequenceFileLoad(
        in_sequence: MusicSequence,
        in_file_ref: &CFURL,
        in_file_type_hint: MusicSequenceFileTypeID,
        in_flags: MusicSequenceLoadFlags,
    ) -> OSStatus;
}

extern "C-unwind" {
    /// Load the data to the sequence
    ///
    /// This function will parse the data and add the events to the sequence. The data provided needs to
    /// be of a particular file type as specified by the fileTypeHint.
    ///
    /// Parameter `inSequence`: the sequence
    ///
    /// Parameter `inData`: the contents of a valid file loaded into a CFData object
    ///
    /// Parameter `inFileTypeHint`: provides a hint to the sequence on the file type being imported. Can be zero in many cases.
    ///
    /// Parameter `inFlags`: flags that can control how the data is parsed in the file and laid out in the tracks
    /// that will be created and added to the sequence in this operation
    #[cfg(feature = "objc2-core-foundation")]
    pub fn MusicSequenceFileLoadData(
        in_sequence: MusicSequence,
        in_data: &CFData,
        in_file_type_hint: MusicSequenceFileTypeID,
        in_flags: MusicSequenceLoadFlags,
    ) -> OSStatus;
}

// TODO: pub fn MusicSequenceSetSMPTEResolution(fps: SignedByte,ticks: Byte,) -> i16;

// TODO: pub fn MusicSequenceGetSMPTEResolution(in_res: i16,fps: NonNull<SignedByte>,ticks: NonNull<Byte>,);

extern "C-unwind" {
    /// Create a file from a sequence
    ///
    /// This function can be (and is most commonly) used to create a MIDI file from the events in a sequence.
    /// Only MIDI based events are used when creating the MIDI file. MIDI files are normally beat based, but
    /// can also have a SMPTE (or real-time rather than beat time) representation.
    ///
    /// inResolution is relationship between "tick" and quarter note for saving to Standard MIDI File
    /// - pass in zero to use default - this will be the value that is currently set on the tempo track
    /// - see the comments for the set track property's time resolution
    ///
    /// The different Sequence types determine the kinds of files that can be created:
    ///
    /// Beats
    /// When saving a MIDI file, it saves a beats (PPQ) based axis
    ///
    /// Seconds
    /// When saving a MIDI file, it will save it as a SMPTE resolution - so you should specify this resolution
    /// when creating the MIDI file.
    /// If zero is specified, 25 fps and 40 ticks/frame is used (a time scale of a millisecond)
    ///
    /// Samples
    /// You cannot save to a MIDI file with this sequence type
    ///
    /// The complete meaning of the 16-bit "division" field in a MIDI File's MThd chunk.
    ///
    /// If it is positive, then a tick represents 1/D quarter notes.
    ///
    /// If it negative:
    ///
    /// bits 14-8 are a signed 7-bit number representing the SMPTE format:
    /// -24, -25, -29 (drop), -30
    /// bits 7-0 represents the number of ticks per SMPTE frame
    /// typical values: 4, 10, 80, 100
    ///
    /// You can obtain millisecond resolution by specifying 25 frames/sec and 40 divisions/frame.
    ///
    /// 30 fps with 80 bits (ticks) per frame: 0xE250  ((char)0xE2 == -30)
    ///
    ///
    /// Parameter `inSequence`: the sequence
    ///
    /// Parameter `inFileRef`: the location of the file to create
    ///
    /// Parameter `inFileType`: the type of file to create
    ///
    /// Parameter `inFlags`: flags to control the file creation
    ///
    /// Parameter `inResolution`: the resolution (depending on file type and sequence type)
    #[cfg(feature = "objc2-core-foundation")]
    pub fn MusicSequenceFileCreate(
        in_sequence: MusicSequence,
        in_file_ref: &CFURL,
        in_file_type: MusicSequenceFileTypeID,
        in_flags: MusicSequenceFileFlags,
        in_resolution: i16,
    ) -> OSStatus;
}

extern "C-unwind" {
    /// Create a data object from a sequence
    ///
    /// The same basic parameters apply to this as with the MusicSequenceFileCreate function. The difference
    /// being that that function will create a file on disk, whereas this one will create a CFData object
    /// that is a file in memory. The CFData object should be released by the caller.
    ///
    /// Parameter `inSequence`: the sequence
    ///
    /// Parameter `inFileType`: the type of file to create
    ///
    /// Parameter `inFlags`: flags to control the file creation
    ///
    /// Parameter `inResolution`: the resolution (depending on file type and sequence type)
    ///
    /// Parameter `outData`: the resulting data object
    #[cfg(feature = "objc2-core-foundation")]
    pub fn MusicSequenceFileCreateData(
        in_sequence: MusicSequence,
        in_file_type: MusicSequenceFileTypeID,
        in_flags: MusicSequenceFileFlags,
        in_resolution: i16,
        out_data: NonNull<*const CFData>,
    ) -> OSStatus;
}

extern "C-unwind" {
    /// Reverse in time all events in a sequence, including the tempo events
    ///
    /// Parameter `inSequence`: the sequence
    pub fn MusicSequenceReverse(in_sequence: MusicSequence) -> OSStatus;
}

extern "C-unwind" {
    /// Returns a seconds value that would correspond to the supplied beats
    ///
    /// Uses the sequence's tempo events
    ///
    /// Parameter `inSequence`: the sequence
    ///
    /// Parameter `inBeats`: the beats
    ///
    /// Parameter `outSeconds`: the seconds (time from 0 beat)
    pub fn MusicSequenceGetSecondsForBeats(
        in_sequence: MusicSequence,
        in_beats: MusicTimeStamp,
        out_seconds: NonNull<f64>,
    ) -> OSStatus;
}

extern "C-unwind" {
    /// Returns a beat value that would correspond to the supplied seconds from zero.
    ///
    /// Uses the sequence's tempo events
    ///
    /// Parameter `inSequence`: the sequence
    ///
    /// Parameter `inSeconds`: the seconds
    ///
    /// Parameter `outBeats`: the corresponding beat
    pub fn MusicSequenceGetBeatsForSeconds(
        in_sequence: MusicSequence,
        in_seconds: f64,
        out_beats: NonNull<MusicTimeStamp>,
    ) -> OSStatus;
}

extern "C-unwind" {
    /// Establish a user callback for a sequence
    ///
    /// This call is used to register (or remove if inCallback is NULL) a callback
    /// that the MusicSequence will call for ANY UserEvents that are added to any of the
    /// tracks of the sequence.
    ///
    /// If there is a callback registered, then UserEvents will be chased when
    /// MusicPlayerSetTime is called. In that case the inStartSliceBeat and inEndSliceBeat
    /// will both be the same value and will be the beat that the player is chasing too.
    ///
    /// In normal cases, where the sequence data is being scheduled for playback, the
    /// following will apply:
    /// inStartSliceBeat
    /// <
    /// = inEventTime
    /// <
    /// inEndSliceBeat
    ///
    /// The only exception to this is if the track that owns the MusicEvent is looping.
    /// In this case the start beat will still be less than the end beat (so your callback
    /// can still determine that it is playing, and what beats are currently being scheduled),
    /// however, the inEventTime will be the original time-stamped time of the user event.
    ///
    /// Parameter `inSequence`: the sequence
    ///
    /// Parameter `inCallback`: the callback
    ///
    /// Parameter `inClientData`: client (user supplied) data provided back to the callback when it is called by the sequence
    pub fn MusicSequenceSetUserCallback(
        in_sequence: MusicSequence,
        in_callback: MusicSequenceUserCallback,
        in_client_data: *mut c_void,
    ) -> OSStatus;
}

extern "C-unwind" {
    /// Convenience function to format a sequence's beat time to its bar-beat time
    ///
    /// The sequence's tempo track Time Sig events are used to
    /// to calculate the bar-beat representation. If there are no Time Sig events added to the sequence
    /// 4/4 is assumed. A Time Sig event is a MIDI Meta Event as specified for MIDI files.
    ///
    /// Parameter `inSequence`: the sequence
    ///
    /// Parameter `inBeats`: the beat which should be represented by the bar-beat
    ///
    /// Parameter `inSubbeatDivisor`: The denominator of the fractional number of beats.
    ///
    /// Parameter `outBarBeatTime`: the formatted bar/beat time
    pub fn MusicSequenceBeatsToBarBeatTime(
        in_sequence: MusicSequence,
        in_beats: MusicTimeStamp,
        in_subbeat_divisor: u32,
        out_bar_beat_time: NonNull<CABarBeatTime>,
    ) -> OSStatus;
}

extern "C-unwind" {
    /// Convenience function to format a bar-beat time to a sequence's beat time
    ///
    /// The sequence's tempo track Time Sig events are used to
    /// to calculate the bar-beat representation. If there are no Time Sig events added to the sequence
    /// 4/4 is assumed. A Time Sig event is a MIDI Meta Event as specified for MIDI files.
    ///
    /// Parameter `inSequence`: the sequence
    ///
    /// Parameter `inBarBeatTime`: the bar-beat time
    ///
    /// Parameter `outBeats`: the sequence's beat time for that bar-beat time
    pub fn MusicSequenceBarBeatTimeToBeats(
        in_sequence: MusicSequence,
        in_bar_beat_time: NonNull<CABarBeatTime>,
        out_beats: NonNull<MusicTimeStamp>,
    ) -> OSStatus;
}

/// Returns a dictionary containing meta-data derived from a sequence
///
/// The dictionary can contain one or more of the kAFInfoDictionary_*
/// keys specified in
/// <AudioToolbox
/// /AudioFile.h>
///
/// The caller should release the returned dictionary. If the call fails it will return NULL
///
///
/// Parameter `inSequence`: the sequence
///
/// Returns: a CFDictionary or NULL if the call fails.
#[cfg(feature = "objc2-core-foundation")]
#[inline]
pub unsafe extern "C-unwind" fn MusicSequenceGetInfoDictionary(
    in_sequence: MusicSequence,
) -> CFRetained<CFDictionary> {
    extern "C-unwind" {
        fn MusicSequenceGetInfoDictionary(
            in_sequence: MusicSequence,
        ) -> Option<NonNull<CFDictionary>>;
    }
    let ret = unsafe { MusicSequenceGetInfoDictionary(in_sequence) };
    let ret = ret.expect("function was marked as returning non-null, but actually returned NULL");
    unsafe { CFRetained::retain(ret) }
}

extern "C-unwind" {
    /// Gets the sequence which the track is a member of
    ///
    /// Parameter `inTrack`: the track
    ///
    /// Parameter `outSequence`: the track's sequence
    pub fn MusicTrackGetSequence(
        in_track: MusicTrack,
        out_sequence: NonNull<MusicSequence>,
    ) -> OSStatus;
}

extern "C-unwind" {
    /// Sets the track's target to the specified AUNode
    ///
    /// The node must be a member of the graph that the track's sequence is using. When played, the track
    /// will send all of its events to that node.
    ///
    /// Parameter `inTrack`: the track
    ///
    /// Parameter `inNode`: the new node
    #[cfg(feature = "AUGraph")]
    pub fn MusicTrackSetDestNode(in_track: MusicTrack, in_node: AUNode) -> OSStatus;
}

extern "C-unwind" {
    /// Sets the track's target to the specified MIDI endpoint
    ///
    /// When played, the track will send all of its events to the specified MIDI Endpoint.
    ///
    /// Parameter `inTrack`: the track
    ///
    /// Parameter `inEndpoint`: the new MIDI endpoint
    #[cfg(feature = "objc2-core-midi")]
    pub fn MusicTrackSetDestMIDIEndpoint(
        in_track: MusicTrack,
        in_endpoint: MIDIEndpointRef,
    ) -> OSStatus;
}

extern "C-unwind" {
    /// Gets the track's target if it is an AUNode
    ///
    /// Returns kAudioToolboxErr_IllegalTrackDestination if the track's target is a MIDIEndpointRef
    /// and NOT an AUNode
    ///
    /// Parameter `inTrack`: the track
    ///
    /// Parameter `outNode`: the node target for the track
    #[cfg(feature = "AUGraph")]
    pub fn MusicTrackGetDestNode(in_track: MusicTrack, out_node: NonNull<AUNode>) -> OSStatus;
}

extern "C-unwind" {
    /// Gets the track's target if it is a MIDI Endpoint
    ///
    /// Returns kAudioToolboxErr_IllegalTrackDestination if the track's target is an AUNode
    /// and NOT a MIDI Endpoint
    ///
    /// Parameter `inTrack`: the track
    ///
    /// Parameter `outEndpoint`: the MIDI Endpoint target for the track
    #[cfg(feature = "objc2-core-midi")]
    pub fn MusicTrackGetDestMIDIEndpoint(
        in_track: MusicTrack,
        out_endpoint: NonNull<MIDIEndpointRef>,
    ) -> OSStatus;
}

extern "C-unwind" {
    /// Sets the specified property value
    ///
    /// Property values are always get and set by reference
    ///
    /// Parameter `inTrack`: the track
    ///
    /// Parameter `inPropertyID`: the property ID
    ///
    /// Parameter `inData`: the new property value
    ///
    /// Parameter `inLength`: the size of the property value being set
    pub fn MusicTrackSetProperty(
        in_track: MusicTrack,
        in_property_id: u32,
        in_data: NonNull<c_void>,
        in_length: u32,
    ) -> OSStatus;
}

extern "C-unwind" {
    /// Gets the specified property value
    ///
    /// If outData is NULL, then the size of the data will be passed back in ioLength
    /// This allows the client to allocate a buffer of the correct size (useful for variable
    /// length properties -- currently all properties have fixed size)
    /// Property values are always get and set by reference
    ///
    /// Parameter `inTrack`: the track
    ///
    /// Parameter `inPropertyID`: the property ID
    ///
    /// Parameter `outData`: if not NULL, points to data of size ioLength
    ///
    /// Parameter `ioLength`: on input the available size of outData, on output the size of the valid data that outData
    /// will then point too.
    pub fn MusicTrackGetProperty(
        in_track: MusicTrack,
        in_property_id: u32,
        out_data: NonNull<c_void>,
        io_length: NonNull<u32>,
    ) -> OSStatus;
}

extern "C-unwind" {
    /// Move events in a track
    ///
    /// Moves all of the events in the specified time range by the moveTime. MoveTime maybe negative to
    /// move events backwards (towards zero).
    ///
    /// All time ranges are [starttime
    /// <
    /// endtime]
    ///
    ///
    /// Parameter `inTrack`: the track
    ///
    /// Parameter `inStartTime`: the start time for the range of events
    ///
    /// Parameter `inEndTime`: the end time up to which will form the range of the events to move
    ///
    /// Parameter `inMoveTime`: amount of beats to move the selected events.
    pub fn MusicTrackMoveEvents(
        in_track: MusicTrack,
        in_start_time: MusicTimeStamp,
        in_end_time: MusicTimeStamp,
        in_move_time: MusicTimeStamp,
    ) -> OSStatus;
}

extern "C-unwind" {
    /// Removes all events within the specified range
    ///
    /// All time ranges are [starttime
    /// <
    /// endtime]
    ///
    /// Parameter `inTrack`: the track
    ///
    /// Parameter `inStartTime`: the start time for the range of events
    ///
    /// Parameter `inEndTime`: the end time up to which will form the range of the events to clear
    pub fn MusicTrackClear(
        in_track: MusicTrack,
        in_start_time: MusicTimeStamp,
        in_end_time: MusicTimeStamp,
    ) -> OSStatus;
}

extern "C-unwind" {
    /// Removes all the events within the specified range
    ///
    /// Events that fall past the specified range will be moved back by the specified range time.
    ///
    /// All time ranges are [starttime
    /// <
    /// endtime]
    ///
    ///
    /// Parameter `inTrack`: the track
    ///
    /// Parameter `inStartTime`: the start time for the range of events
    ///
    /// Parameter `inEndTime`: the end time up to which will form the range of the events to cut out
    pub fn MusicTrackCut(
        in_track: MusicTrack,
        in_start_time: MusicTimeStamp,
        in_end_time: MusicTimeStamp,
    ) -> OSStatus;
}

extern "C-unwind" {
    /// Copies events from one track and inserts them into another
    ///
    /// Copies all of the events with the specified time range of the source track. It then inserts
    /// those events into the destination track. All events at and after inDestInsertTime in inDestTrack
    /// are moved forward by the range's duration
    ///
    /// All time ranges are [starttime
    /// <
    /// endtime]
    ///
    ///
    /// Parameter `inSourceTrack`: the source track
    ///
    /// Parameter `inSourceStartTime`: the start time for the range of events
    ///
    /// Parameter `inSourceEndTime`: the end time up to which will form the range of the events to copy from the source track
    ///
    /// Parameter `inDestTrack`: the destination track to copy too
    ///
    /// Parameter `inDestInsertTime`: the time at which the copied events will be inserted.
    pub fn MusicTrackCopyInsert(
        in_source_track: MusicTrack,
        in_source_start_time: MusicTimeStamp,
        in_source_end_time: MusicTimeStamp,
        in_dest_track: MusicTrack,
        in_dest_insert_time: MusicTimeStamp,
    ) -> OSStatus;
}

extern "C-unwind" {
    /// Copies events from one track and merges them into another
    ///
    /// Copies all of the events with the specified time range of the source track. It then merges
    /// those events into the destination track starting at inDestInsertTime.
    ///
    /// All time ranges are [starttime
    /// <
    /// endtime]
    ///
    ///
    /// Parameter `inSourceTrack`: the source track
    ///
    /// Parameter `inSourceStartTime`: the start time for the range of events
    ///
    /// Parameter `inSourceEndTime`: the end time up to which will form the range of the events to copy from the source track
    ///
    /// Parameter `inDestTrack`: the destination track to copy too
    ///
    /// Parameter `inDestInsertTime`: the time at which the copied events will be merged.
    pub fn MusicTrackMerge(
        in_source_track: MusicTrack,
        in_source_start_time: MusicTimeStamp,
        in_source_end_time: MusicTimeStamp,
        in_dest_track: MusicTrack,
        in_dest_insert_time: MusicTimeStamp,
    ) -> OSStatus;
}

extern "C-unwind" {
    /// Adds a MIDINoteMessage event to a track
    ///
    /// The event is added at the specified time stamp. The time stamp should not be less than zero.
    ///
    /// Parameter `inTrack`: the track
    ///
    /// Parameter `inTimeStamp`: the time stamp
    ///
    /// Parameter `inMessage`: the event
    pub fn MusicTrackNewMIDINoteEvent(
        in_track: MusicTrack,
        in_time_stamp: MusicTimeStamp,
        in_message: NonNull<MIDINoteMessage>,
    ) -> OSStatus;
}

extern "C-unwind" {
    /// Adds a MIDIChannelMessage event to a track
    ///
    /// The event is added at the specified time stamp. The time stamp should not be less than zero.
    ///
    /// Parameter `inTrack`: the track
    ///
    /// Parameter `inTimeStamp`: the time stamp
    ///
    /// Parameter `inMessage`: the event
    pub fn MusicTrackNewMIDIChannelEvent(
        in_track: MusicTrack,
        in_time_stamp: MusicTimeStamp,
        in_message: NonNull<MIDIChannelMessage>,
    ) -> OSStatus;
}

extern "C-unwind" {
    /// Adds a MIDIRawData event to a track
    ///
    /// The event is added at the specified time stamp. The time stamp should not be less than zero.
    ///
    /// Parameter `inTrack`: the track
    ///
    /// Parameter `inTimeStamp`: the time stamp
    ///
    /// Parameter `inRawData`: the event
    pub fn MusicTrackNewMIDIRawDataEvent(
        in_track: MusicTrack,
        in_time_stamp: MusicTimeStamp,
        in_raw_data: NonNull<MIDIRawData>,
    ) -> OSStatus;
}

extern "C-unwind" {
    /// Adds a ExtendedNoteOnEvent to a track
    ///
    /// The event is added at the specified time stamp. The time stamp should not be less than zero.
    ///
    /// Parameter `inTrack`: the track
    ///
    /// Parameter `inTimeStamp`: the time stamp
    ///
    /// Parameter `inInfo`: the event
    #[cfg(all(feature = "AUComponent", feature = "MusicDevice"))]
    pub fn MusicTrackNewExtendedNoteEvent(
        in_track: MusicTrack,
        in_time_stamp: MusicTimeStamp,
        in_info: NonNull<ExtendedNoteOnEvent>,
    ) -> OSStatus;
}

extern "C-unwind" {
    /// Adds a ParameterEvent to a track
    ///
    /// The event is added at the specified time stamp. The time stamp should not be less than zero.
    ///
    /// Parameter `inTrack`: the track
    ///
    /// Parameter `inTimeStamp`: the time stamp
    ///
    /// Parameter `inInfo`: the event
    #[cfg(feature = "AUComponent")]
    pub fn MusicTrackNewParameterEvent(
        in_track: MusicTrack,
        in_time_stamp: MusicTimeStamp,
        in_info: NonNull<ParameterEvent>,
    ) -> OSStatus;
}

extern "C-unwind" {
    /// Adds a tempo event to a track
    ///
    /// The event is added at the specified time stamp. The time stamp should not be less than zero.
    ///
    /// Parameter `inTrack`: the track
    ///
    /// Parameter `inTimeStamp`: the time stamp
    ///
    /// Parameter `inBPM`: the event
    pub fn MusicTrackNewExtendedTempoEvent(
        in_track: MusicTrack,
        in_time_stamp: MusicTimeStamp,
        in_bpm: f64,
    ) -> OSStatus;
}

extern "C-unwind" {
    /// Adds a MIDIMetaEvent to a track
    ///
    /// The event is added at the specified time stamp. The time stamp should not be less than zero.
    ///
    /// Parameter `inTrack`: the track
    ///
    /// Parameter `inTimeStamp`: the time stamp
    ///
    /// Parameter `inMetaEvent`: the event
    pub fn MusicTrackNewMetaEvent(
        in_track: MusicTrack,
        in_time_stamp: MusicTimeStamp,
        in_meta_event: NonNull<MIDIMetaEvent>,
    ) -> OSStatus;
}

extern "C-unwind" {
    /// Adds a MusicEventUserData event to a track
    ///
    /// The event is added at the specified time stamp. The time stamp should not be less than zero.
    ///
    /// Parameter `inTrack`: the track
    ///
    /// Parameter `inTimeStamp`: the time stamp
    ///
    /// Parameter `inUserData`: the event
    pub fn MusicTrackNewUserEvent(
        in_track: MusicTrack,
        in_time_stamp: MusicTimeStamp,
        in_user_data: NonNull<MusicEventUserData>,
    ) -> OSStatus;
}

extern "C-unwind" {
    /// Adds a AUPresetEvent to a track
    ///
    /// The event is added at the specified time stamp. The time stamp should not be less than zero.
    ///
    /// Parameter `inTrack`: the track
    ///
    /// Parameter `inTimeStamp`: the time stamp
    ///
    /// Parameter `inPresetEvent`: the event
    #[cfg(all(feature = "AUComponent", feature = "objc2-core-foundation"))]
    pub fn MusicTrackNewAUPresetEvent(
        in_track: MusicTrack,
        in_time_stamp: MusicTimeStamp,
        in_preset_event: NonNull<AUPresetEvent>,
    ) -> OSStatus;
}

extern "C-unwind" {
    /// Creates an iterator to iterator over a track's events
    ///
    /// The iterator should be considered invalid if a track is edited. In that case you should create a new
    /// iterator and seek it to the desired position.
    ///
    ///
    /// Parameter `inTrack`: the track upon which to iterate
    ///
    /// Parameter `outIterator`: the new iterator
    pub fn NewMusicEventIterator(
        in_track: MusicTrack,
        out_iterator: NonNull<MusicEventIterator>,
    ) -> OSStatus;
}

extern "C-unwind" {
    /// Dispose an iterator
    ///
    /// Parameter `inIterator`: the iterator
    pub fn DisposeMusicEventIterator(in_iterator: MusicEventIterator) -> OSStatus;
}

extern "C-unwind" {
    /// Move the iterator to an event at the specified time
    ///
    /// If there is no event at the specified time, the iterator will point to the first event after
    /// that time.
    /// By specifying kMusicTimeStamp_EndOfTrack you will position the iterator to the end of track
    /// (which is pointing to the space just AFTER the last event). You can use MusicEventIteratorPreviousEvent
    /// to backup to the last event.
    /// By specifying 0, you will position the iterator at the first event
    ///
    /// Parameter `inIterator`: the iterator
    ///
    /// Parameter `inTimeStamp`: the time stamp to seek too
    pub fn MusicEventIteratorSeek(
        in_iterator: MusicEventIterator,
        in_time_stamp: MusicTimeStamp,
    ) -> OSStatus;
}

extern "C-unwind" {
    /// Move the iterator to the next event
    ///
    /// If the iterator was at the last event, then it will move past the last event and will no longer point
    /// to an event. You can use check MusicEventIteratorHasCurrentEvent to see if there is an event at the
    /// iterator's current position. See also MusicEventIteratorHasNextEvent.
    ///
    /// Typically this call is used to move the iterator forwards through the track's events.
    ///
    /// Parameter `inIterator`: the iterator
    pub fn MusicEventIteratorNextEvent(in_iterator: MusicEventIterator) -> OSStatus;
}

extern "C-unwind" {
    /// Move the iterator to the previous event
    ///
    /// If the iterator was at the first event, then it will leave the iterator unchanged and return an error.
    /// See also MusicEventIteratorHasPreviousEvent
    ///
    /// Typically this call is used to move the iterator backwards through the track's events.
    ///
    /// Parameter `inIterator`: the iterator
    pub fn MusicEventIteratorPreviousEvent(in_iterator: MusicEventIterator) -> OSStatus;
}

extern "C-unwind" {
    /// Retrieves the event data at the iterator.
    ///
    /// Retrieves the event and other information from the iterator's current position.
    ///
    /// If you do not want specific information (eg, the time stamp) pass in NULL for that parameter.
    ///
    ///
    /// Parameter `inIterator`: the iterator
    ///
    /// Parameter `outTimeStamp`: the time stamp of the event
    ///
    /// Parameter `outEventType`: one of kMusicEventType_XXX that indicates what kind of event type the iterator
    /// is currently pointing too
    ///
    /// Parameter `outEventData`: a reference to the event data. The type of data is described by the eventType. This data
    /// is read only and should not be edited in place.
    ///
    /// Parameter `outEventDataSize`: the size of the data referenced by outEventData
    pub fn MusicEventIteratorGetEventInfo(
        in_iterator: MusicEventIterator,
        out_time_stamp: NonNull<MusicTimeStamp>,
        out_event_type: NonNull<MusicEventType>,
        out_event_data: NonNull<*const c_void>,
        out_event_data_size: NonNull<u32>,
    ) -> OSStatus;
}

extern "C-unwind" {
    /// Changes the type or value of an event
    ///
    /// Allows you to change either the event type, or the values of the event data, that the iterator is
    /// currently pointing too. You cannot change the event's time (to do that you should use
    /// MusicEventIteratorSetEventTime).
    ///
    ///
    /// Parameter `inIterator`: the iterator
    ///
    /// Parameter `inEventType`: the new (or existing) type of the event you are changing
    ///
    /// Parameter `inEventData`: the new event data. The size and type of this event data must match the inEventType
    pub fn MusicEventIteratorSetEventInfo(
        in_iterator: MusicEventIterator,
        in_event_type: MusicEventType,
        in_event_data: NonNull<c_void>,
    ) -> OSStatus;
}

extern "C-unwind" {
    /// Set a new time for an event
    ///
    /// The iterator will still be pointing to the same event, but as the event will have moved,
    /// it may or may not have a next or previous event now (depending of course on the time
    /// you moved it too).
    ///
    ///
    /// Parameter `inIterator`: the iterator
    ///
    /// Parameter `inTimeStamp`: the new time stamp of the event
    pub fn MusicEventIteratorSetEventTime(
        in_iterator: MusicEventIterator,
        in_time_stamp: MusicTimeStamp,
    ) -> OSStatus;
}

extern "C-unwind" {
    /// Deletes the event pointed to by the iterator
    ///
    /// The iterator will reference the next event after the event has been deleted.
    ///
    ///
    /// Parameter `inIterator`: the iterator
    pub fn MusicEventIteratorDeleteEvent(in_iterator: MusicEventIterator) -> OSStatus;
}

extern "C-unwind" {
    /// Does the track have an event previous to the event the iterator is pointing to?
    ///
    /// To use the iterator going backwards through a track:
    /// iter = New Iterator (points at first event)
    /// MusicEventIteratorSeek (iter, kMusicTimeStamp_EndOfTrack) // will point it past the last event
    /// bool hasPreviousEvent;
    /// MusicEventIteratorHasPreviousEvent (iter,
    /// &hasPreviousEvent
    /// )
    /// while (hasPreviousEvent) {
    /// MusicEventIteratorPreviousEvent (iter)
    /// //     do work... MusicEventIteratorGetEventInfo (iter, ...
    ///
    /// MusicEventIteratorHasPreviousEvent (iter,
    /// &hasPreviousEvent
    /// );
    /// }
    ///
    /// Parameter `inIterator`: the iterator
    ///
    /// Parameter `outHasPrevEvent`: true if there is a previous event, false if not
    pub fn MusicEventIteratorHasPreviousEvent(
        in_iterator: MusicEventIterator,
        out_has_prev_event: NonNull<Boolean>,
    ) -> OSStatus;
}

extern "C-unwind" {
    /// Does the track have an event past the event the iterator is pointing too?
    ///
    /// To use the iterator going forwards through a track:
    /// iter = New Iterator (points at first event)
    /// bool hasCurrentEvent;
    /// MusicEventIteratorHasCurrentEvent(iter,
    /// &hasCurrentEvent
    /// );
    /// while (hasCurrentEvent) {
    /// // do work... MusicEventIteratorGetEventInfo (iter, ...
    ///
    /// MusicEventIteratorNextEvent (iter)
    /// MusicEventIteratorHasCurrentEvent(iter,
    /// &hasCurrentEvent
    /// );
    /// }
    ///
    ///
    /// Parameter `inIterator`: the iterator
    ///
    /// Parameter `outHasNextEvent`: true if there is a next event, false if not
    pub fn MusicEventIteratorHasNextEvent(
        in_iterator: MusicEventIterator,
        out_has_next_event: NonNull<Boolean>,
    ) -> OSStatus;
}

extern "C-unwind" {
    /// Is there an event at the iterator's current position?
    ///
    /// Parameter `inIterator`: the iterator
    ///
    /// Parameter `outHasCurEvent`: true if there is an event, false if not
    pub fn MusicEventIteratorHasCurrentEvent(
        in_iterator: MusicEventIterator,
        out_has_cur_event: NonNull<Boolean>,
    ) -> OSStatus;
}

extern "C-unwind" {
    #[cfg(feature = "objc2-core-foundation")]
    #[deprecated = "no longer supported"]
    pub fn MusicSequenceLoadSMFDataWithFlags(
        in_sequence: MusicSequence,
        in_data: &CFData,
        in_flags: MusicSequenceLoadFlags,
    ) -> OSStatus;
}

extern "C-unwind" {
    #[cfg(feature = "objc2-core-foundation")]
    #[deprecated = "no longer supported"]
    pub fn MusicSequenceSaveSMFData(
        in_sequence: MusicSequence,
        out_data: NonNull<*const CFData>,
        in_resolution: u16,
    ) -> OSStatus;
}

extern "C-unwind" {
    #[deprecated = "no longer supported"]
    pub fn NewMusicTrackFrom(
        in_source_track: MusicTrack,
        in_source_start_time: MusicTimeStamp,
        in_source_end_time: MusicTimeStamp,
        out_new_track: NonNull<MusicTrack>,
    ) -> OSStatus;
}

/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kmusiceventtype_extendedcontrol?language=objc)
pub const kMusicEventType_ExtendedControl: c_uint = 2;

/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/extendedcontrolevent?language=objc)
#[cfg(all(feature = "AUComponent", feature = "MusicDevice"))]
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct ExtendedControlEvent {
    pub groupID: MusicDeviceGroupID,
    pub controlID: AudioUnitParameterID,
    pub value: AudioUnitParameterValue,
}

#[cfg(all(feature = "AUComponent", feature = "MusicDevice"))]
unsafe impl Encode for ExtendedControlEvent {
    const ENCODING: Encoding = Encoding::Struct(
        "ExtendedControlEvent",
        &[
            <MusicDeviceGroupID>::ENCODING,
            <AudioUnitParameterID>::ENCODING,
            <AudioUnitParameterValue>::ENCODING,
        ],
    );
}

#[cfg(all(feature = "AUComponent", feature = "MusicDevice"))]
unsafe impl RefEncode for ExtendedControlEvent {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

extern "C-unwind" {
    #[cfg(all(feature = "AUComponent", feature = "MusicDevice"))]
    #[deprecated = "no longer supported"]
    pub fn MusicTrackNewExtendedControlEvent(
        in_track: MusicTrack,
        in_time_stamp: MusicTimeStamp,
        in_info: NonNull<ExtendedControlEvent>,
    ) -> OSStatus;
}
