// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package cleanrooms

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opBatchGetCollaborationAnalysisTemplate = "BatchGetCollaborationAnalysisTemplate"

// BatchGetCollaborationAnalysisTemplateRequest generates a "aws/request.Request" representing the
// client's request for the BatchGetCollaborationAnalysisTemplate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchGetCollaborationAnalysisTemplate for more information on using the BatchGetCollaborationAnalysisTemplate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the BatchGetCollaborationAnalysisTemplateRequest method.
//	req, resp := client.BatchGetCollaborationAnalysisTemplateRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/BatchGetCollaborationAnalysisTemplate
func (c *CleanRooms) BatchGetCollaborationAnalysisTemplateRequest(input *BatchGetCollaborationAnalysisTemplateInput) (req *request.Request, output *BatchGetCollaborationAnalysisTemplateOutput) {
	op := &request.Operation{
		Name:       opBatchGetCollaborationAnalysisTemplate,
		HTTPMethod: "POST",
		HTTPPath:   "/collaborations/{collaborationIdentifier}/batch-analysistemplates",
	}

	if input == nil {
		input = &BatchGetCollaborationAnalysisTemplateInput{}
	}

	output = &BatchGetCollaborationAnalysisTemplateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchGetCollaborationAnalysisTemplate API operation for AWS Clean Rooms Service.
//
// Retrieves multiple analysis templates within a collaboration by their Amazon
// Resource Names (ARNs).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Clean Rooms Service's
// API operation BatchGetCollaborationAnalysisTemplate for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     Request references a resource which does not exist.
//
//   - InternalServerException
//     Unexpected error during processing of request.
//
//   - ValidationException
//     The input fails to satisfy the specified constraints.
//
//   - ThrottlingException
//     Request was denied due to request throttling.
//
//   - AccessDeniedException
//     Caller does not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/BatchGetCollaborationAnalysisTemplate
func (c *CleanRooms) BatchGetCollaborationAnalysisTemplate(input *BatchGetCollaborationAnalysisTemplateInput) (*BatchGetCollaborationAnalysisTemplateOutput, error) {
	req, out := c.BatchGetCollaborationAnalysisTemplateRequest(input)
	return out, req.Send()
}

// BatchGetCollaborationAnalysisTemplateWithContext is the same as BatchGetCollaborationAnalysisTemplate with the addition of
// the ability to pass a context and additional request options.
//
// See BatchGetCollaborationAnalysisTemplate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CleanRooms) BatchGetCollaborationAnalysisTemplateWithContext(ctx aws.Context, input *BatchGetCollaborationAnalysisTemplateInput, opts ...request.Option) (*BatchGetCollaborationAnalysisTemplateOutput, error) {
	req, out := c.BatchGetCollaborationAnalysisTemplateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opBatchGetSchema = "BatchGetSchema"

// BatchGetSchemaRequest generates a "aws/request.Request" representing the
// client's request for the BatchGetSchema operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchGetSchema for more information on using the BatchGetSchema
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the BatchGetSchemaRequest method.
//	req, resp := client.BatchGetSchemaRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/BatchGetSchema
func (c *CleanRooms) BatchGetSchemaRequest(input *BatchGetSchemaInput) (req *request.Request, output *BatchGetSchemaOutput) {
	op := &request.Operation{
		Name:       opBatchGetSchema,
		HTTPMethod: "POST",
		HTTPPath:   "/collaborations/{collaborationIdentifier}/batch-schema",
	}

	if input == nil {
		input = &BatchGetSchemaInput{}
	}

	output = &BatchGetSchemaOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchGetSchema API operation for AWS Clean Rooms Service.
//
// Retrieves multiple schemas by their identifiers.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Clean Rooms Service's
// API operation BatchGetSchema for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     Request references a resource which does not exist.
//
//   - InternalServerException
//     Unexpected error during processing of request.
//
//   - ValidationException
//     The input fails to satisfy the specified constraints.
//
//   - ThrottlingException
//     Request was denied due to request throttling.
//
//   - AccessDeniedException
//     Caller does not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/BatchGetSchema
func (c *CleanRooms) BatchGetSchema(input *BatchGetSchemaInput) (*BatchGetSchemaOutput, error) {
	req, out := c.BatchGetSchemaRequest(input)
	return out, req.Send()
}

// BatchGetSchemaWithContext is the same as BatchGetSchema with the addition of
// the ability to pass a context and additional request options.
//
// See BatchGetSchema for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CleanRooms) BatchGetSchemaWithContext(ctx aws.Context, input *BatchGetSchemaInput, opts ...request.Option) (*BatchGetSchemaOutput, error) {
	req, out := c.BatchGetSchemaRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opBatchGetSchemaAnalysisRule = "BatchGetSchemaAnalysisRule"

// BatchGetSchemaAnalysisRuleRequest generates a "aws/request.Request" representing the
// client's request for the BatchGetSchemaAnalysisRule operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchGetSchemaAnalysisRule for more information on using the BatchGetSchemaAnalysisRule
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the BatchGetSchemaAnalysisRuleRequest method.
//	req, resp := client.BatchGetSchemaAnalysisRuleRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/BatchGetSchemaAnalysisRule
func (c *CleanRooms) BatchGetSchemaAnalysisRuleRequest(input *BatchGetSchemaAnalysisRuleInput) (req *request.Request, output *BatchGetSchemaAnalysisRuleOutput) {
	op := &request.Operation{
		Name:       opBatchGetSchemaAnalysisRule,
		HTTPMethod: "POST",
		HTTPPath:   "/collaborations/{collaborationIdentifier}/batch-schema-analysis-rule",
	}

	if input == nil {
		input = &BatchGetSchemaAnalysisRuleInput{}
	}

	output = &BatchGetSchemaAnalysisRuleOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchGetSchemaAnalysisRule API operation for AWS Clean Rooms Service.
//
// Retrieves multiple analysis rule schemas.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Clean Rooms Service's
// API operation BatchGetSchemaAnalysisRule for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     Request references a resource which does not exist.
//
//   - InternalServerException
//     Unexpected error during processing of request.
//
//   - ValidationException
//     The input fails to satisfy the specified constraints.
//
//   - ThrottlingException
//     Request was denied due to request throttling.
//
//   - AccessDeniedException
//     Caller does not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/BatchGetSchemaAnalysisRule
func (c *CleanRooms) BatchGetSchemaAnalysisRule(input *BatchGetSchemaAnalysisRuleInput) (*BatchGetSchemaAnalysisRuleOutput, error) {
	req, out := c.BatchGetSchemaAnalysisRuleRequest(input)
	return out, req.Send()
}

// BatchGetSchemaAnalysisRuleWithContext is the same as BatchGetSchemaAnalysisRule with the addition of
// the ability to pass a context and additional request options.
//
// See BatchGetSchemaAnalysisRule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CleanRooms) BatchGetSchemaAnalysisRuleWithContext(ctx aws.Context, input *BatchGetSchemaAnalysisRuleInput, opts ...request.Option) (*BatchGetSchemaAnalysisRuleOutput, error) {
	req, out := c.BatchGetSchemaAnalysisRuleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateAnalysisTemplate = "CreateAnalysisTemplate"

// CreateAnalysisTemplateRequest generates a "aws/request.Request" representing the
// client's request for the CreateAnalysisTemplate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateAnalysisTemplate for more information on using the CreateAnalysisTemplate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateAnalysisTemplateRequest method.
//	req, resp := client.CreateAnalysisTemplateRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/CreateAnalysisTemplate
func (c *CleanRooms) CreateAnalysisTemplateRequest(input *CreateAnalysisTemplateInput) (req *request.Request, output *CreateAnalysisTemplateOutput) {
	op := &request.Operation{
		Name:       opCreateAnalysisTemplate,
		HTTPMethod: "POST",
		HTTPPath:   "/memberships/{membershipIdentifier}/analysistemplates",
	}

	if input == nil {
		input = &CreateAnalysisTemplateInput{}
	}

	output = &CreateAnalysisTemplateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateAnalysisTemplate API operation for AWS Clean Rooms Service.
//
// Creates a new analysis template.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Clean Rooms Service's
// API operation CreateAnalysisTemplate for usage and error information.
//
// Returned Error Types:
//
//   - ConflictException
//     Updating or deleting a resource can cause an inconsistent state.
//
//   - ServiceQuotaExceededException
//     Request denied because service quota has been exceeded.
//
//   - ResourceNotFoundException
//     Request references a resource which does not exist.
//
//   - InternalServerException
//     Unexpected error during processing of request.
//
//   - ValidationException
//     The input fails to satisfy the specified constraints.
//
//   - ThrottlingException
//     Request was denied due to request throttling.
//
//   - AccessDeniedException
//     Caller does not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/CreateAnalysisTemplate
func (c *CleanRooms) CreateAnalysisTemplate(input *CreateAnalysisTemplateInput) (*CreateAnalysisTemplateOutput, error) {
	req, out := c.CreateAnalysisTemplateRequest(input)
	return out, req.Send()
}

// CreateAnalysisTemplateWithContext is the same as CreateAnalysisTemplate with the addition of
// the ability to pass a context and additional request options.
//
// See CreateAnalysisTemplate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CleanRooms) CreateAnalysisTemplateWithContext(ctx aws.Context, input *CreateAnalysisTemplateInput, opts ...request.Option) (*CreateAnalysisTemplateOutput, error) {
	req, out := c.CreateAnalysisTemplateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateCollaboration = "CreateCollaboration"

// CreateCollaborationRequest generates a "aws/request.Request" representing the
// client's request for the CreateCollaboration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateCollaboration for more information on using the CreateCollaboration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateCollaborationRequest method.
//	req, resp := client.CreateCollaborationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/CreateCollaboration
func (c *CleanRooms) CreateCollaborationRequest(input *CreateCollaborationInput) (req *request.Request, output *CreateCollaborationOutput) {
	op := &request.Operation{
		Name:       opCreateCollaboration,
		HTTPMethod: "POST",
		HTTPPath:   "/collaborations",
	}

	if input == nil {
		input = &CreateCollaborationInput{}
	}

	output = &CreateCollaborationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateCollaboration API operation for AWS Clean Rooms Service.
//
// Creates a new collaboration.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Clean Rooms Service's
// API operation CreateCollaboration for usage and error information.
//
// Returned Error Types:
//
//   - ServiceQuotaExceededException
//     Request denied because service quota has been exceeded.
//
//   - InternalServerException
//     Unexpected error during processing of request.
//
//   - ValidationException
//     The input fails to satisfy the specified constraints.
//
//   - ThrottlingException
//     Request was denied due to request throttling.
//
//   - AccessDeniedException
//     Caller does not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/CreateCollaboration
func (c *CleanRooms) CreateCollaboration(input *CreateCollaborationInput) (*CreateCollaborationOutput, error) {
	req, out := c.CreateCollaborationRequest(input)
	return out, req.Send()
}

// CreateCollaborationWithContext is the same as CreateCollaboration with the addition of
// the ability to pass a context and additional request options.
//
// See CreateCollaboration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CleanRooms) CreateCollaborationWithContext(ctx aws.Context, input *CreateCollaborationInput, opts ...request.Option) (*CreateCollaborationOutput, error) {
	req, out := c.CreateCollaborationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateConfiguredAudienceModelAssociation = "CreateConfiguredAudienceModelAssociation"

// CreateConfiguredAudienceModelAssociationRequest generates a "aws/request.Request" representing the
// client's request for the CreateConfiguredAudienceModelAssociation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateConfiguredAudienceModelAssociation for more information on using the CreateConfiguredAudienceModelAssociation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateConfiguredAudienceModelAssociationRequest method.
//	req, resp := client.CreateConfiguredAudienceModelAssociationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/CreateConfiguredAudienceModelAssociation
func (c *CleanRooms) CreateConfiguredAudienceModelAssociationRequest(input *CreateConfiguredAudienceModelAssociationInput) (req *request.Request, output *CreateConfiguredAudienceModelAssociationOutput) {
	op := &request.Operation{
		Name:       opCreateConfiguredAudienceModelAssociation,
		HTTPMethod: "POST",
		HTTPPath:   "/memberships/{membershipIdentifier}/configuredaudiencemodelassociations",
	}

	if input == nil {
		input = &CreateConfiguredAudienceModelAssociationInput{}
	}

	output = &CreateConfiguredAudienceModelAssociationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateConfiguredAudienceModelAssociation API operation for AWS Clean Rooms Service.
//
// Provides the details necessary to create a configured audience model association.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Clean Rooms Service's
// API operation CreateConfiguredAudienceModelAssociation for usage and error information.
//
// Returned Error Types:
//
//   - ConflictException
//     Updating or deleting a resource can cause an inconsistent state.
//
//   - ServiceQuotaExceededException
//     Request denied because service quota has been exceeded.
//
//   - ResourceNotFoundException
//     Request references a resource which does not exist.
//
//   - InternalServerException
//     Unexpected error during processing of request.
//
//   - ValidationException
//     The input fails to satisfy the specified constraints.
//
//   - ThrottlingException
//     Request was denied due to request throttling.
//
//   - AccessDeniedException
//     Caller does not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/CreateConfiguredAudienceModelAssociation
func (c *CleanRooms) CreateConfiguredAudienceModelAssociation(input *CreateConfiguredAudienceModelAssociationInput) (*CreateConfiguredAudienceModelAssociationOutput, error) {
	req, out := c.CreateConfiguredAudienceModelAssociationRequest(input)
	return out, req.Send()
}

// CreateConfiguredAudienceModelAssociationWithContext is the same as CreateConfiguredAudienceModelAssociation with the addition of
// the ability to pass a context and additional request options.
//
// See CreateConfiguredAudienceModelAssociation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CleanRooms) CreateConfiguredAudienceModelAssociationWithContext(ctx aws.Context, input *CreateConfiguredAudienceModelAssociationInput, opts ...request.Option) (*CreateConfiguredAudienceModelAssociationOutput, error) {
	req, out := c.CreateConfiguredAudienceModelAssociationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateConfiguredTable = "CreateConfiguredTable"

// CreateConfiguredTableRequest generates a "aws/request.Request" representing the
// client's request for the CreateConfiguredTable operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateConfiguredTable for more information on using the CreateConfiguredTable
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateConfiguredTableRequest method.
//	req, resp := client.CreateConfiguredTableRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/CreateConfiguredTable
func (c *CleanRooms) CreateConfiguredTableRequest(input *CreateConfiguredTableInput) (req *request.Request, output *CreateConfiguredTableOutput) {
	op := &request.Operation{
		Name:       opCreateConfiguredTable,
		HTTPMethod: "POST",
		HTTPPath:   "/configuredTables",
	}

	if input == nil {
		input = &CreateConfiguredTableInput{}
	}

	output = &CreateConfiguredTableOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateConfiguredTable API operation for AWS Clean Rooms Service.
//
// Creates a new configured table resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Clean Rooms Service's
// API operation CreateConfiguredTable for usage and error information.
//
// Returned Error Types:
//
//   - ConflictException
//     Updating or deleting a resource can cause an inconsistent state.
//
//   - ServiceQuotaExceededException
//     Request denied because service quota has been exceeded.
//
//   - ResourceNotFoundException
//     Request references a resource which does not exist.
//
//   - InternalServerException
//     Unexpected error during processing of request.
//
//   - ValidationException
//     The input fails to satisfy the specified constraints.
//
//   - ThrottlingException
//     Request was denied due to request throttling.
//
//   - AccessDeniedException
//     Caller does not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/CreateConfiguredTable
func (c *CleanRooms) CreateConfiguredTable(input *CreateConfiguredTableInput) (*CreateConfiguredTableOutput, error) {
	req, out := c.CreateConfiguredTableRequest(input)
	return out, req.Send()
}

// CreateConfiguredTableWithContext is the same as CreateConfiguredTable with the addition of
// the ability to pass a context and additional request options.
//
// See CreateConfiguredTable for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CleanRooms) CreateConfiguredTableWithContext(ctx aws.Context, input *CreateConfiguredTableInput, opts ...request.Option) (*CreateConfiguredTableOutput, error) {
	req, out := c.CreateConfiguredTableRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateConfiguredTableAnalysisRule = "CreateConfiguredTableAnalysisRule"

// CreateConfiguredTableAnalysisRuleRequest generates a "aws/request.Request" representing the
// client's request for the CreateConfiguredTableAnalysisRule operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateConfiguredTableAnalysisRule for more information on using the CreateConfiguredTableAnalysisRule
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateConfiguredTableAnalysisRuleRequest method.
//	req, resp := client.CreateConfiguredTableAnalysisRuleRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/CreateConfiguredTableAnalysisRule
func (c *CleanRooms) CreateConfiguredTableAnalysisRuleRequest(input *CreateConfiguredTableAnalysisRuleInput) (req *request.Request, output *CreateConfiguredTableAnalysisRuleOutput) {
	op := &request.Operation{
		Name:       opCreateConfiguredTableAnalysisRule,
		HTTPMethod: "POST",
		HTTPPath:   "/configuredTables/{configuredTableIdentifier}/analysisRule",
	}

	if input == nil {
		input = &CreateConfiguredTableAnalysisRuleInput{}
	}

	output = &CreateConfiguredTableAnalysisRuleOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateConfiguredTableAnalysisRule API operation for AWS Clean Rooms Service.
//
// Creates a new analysis rule for a configured table. Currently, only one analysis
// rule can be created for a given configured table.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Clean Rooms Service's
// API operation CreateConfiguredTableAnalysisRule for usage and error information.
//
// Returned Error Types:
//
//   - ConflictException
//     Updating or deleting a resource can cause an inconsistent state.
//
//   - ResourceNotFoundException
//     Request references a resource which does not exist.
//
//   - InternalServerException
//     Unexpected error during processing of request.
//
//   - ValidationException
//     The input fails to satisfy the specified constraints.
//
//   - ThrottlingException
//     Request was denied due to request throttling.
//
//   - AccessDeniedException
//     Caller does not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/CreateConfiguredTableAnalysisRule
func (c *CleanRooms) CreateConfiguredTableAnalysisRule(input *CreateConfiguredTableAnalysisRuleInput) (*CreateConfiguredTableAnalysisRuleOutput, error) {
	req, out := c.CreateConfiguredTableAnalysisRuleRequest(input)
	return out, req.Send()
}

// CreateConfiguredTableAnalysisRuleWithContext is the same as CreateConfiguredTableAnalysisRule with the addition of
// the ability to pass a context and additional request options.
//
// See CreateConfiguredTableAnalysisRule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CleanRooms) CreateConfiguredTableAnalysisRuleWithContext(ctx aws.Context, input *CreateConfiguredTableAnalysisRuleInput, opts ...request.Option) (*CreateConfiguredTableAnalysisRuleOutput, error) {
	req, out := c.CreateConfiguredTableAnalysisRuleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateConfiguredTableAssociation = "CreateConfiguredTableAssociation"

// CreateConfiguredTableAssociationRequest generates a "aws/request.Request" representing the
// client's request for the CreateConfiguredTableAssociation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateConfiguredTableAssociation for more information on using the CreateConfiguredTableAssociation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateConfiguredTableAssociationRequest method.
//	req, resp := client.CreateConfiguredTableAssociationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/CreateConfiguredTableAssociation
func (c *CleanRooms) CreateConfiguredTableAssociationRequest(input *CreateConfiguredTableAssociationInput) (req *request.Request, output *CreateConfiguredTableAssociationOutput) {
	op := &request.Operation{
		Name:       opCreateConfiguredTableAssociation,
		HTTPMethod: "POST",
		HTTPPath:   "/memberships/{membershipIdentifier}/configuredTableAssociations",
	}

	if input == nil {
		input = &CreateConfiguredTableAssociationInput{}
	}

	output = &CreateConfiguredTableAssociationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateConfiguredTableAssociation API operation for AWS Clean Rooms Service.
//
// Creates a configured table association. A configured table association links
// a configured table with a collaboration.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Clean Rooms Service's
// API operation CreateConfiguredTableAssociation for usage and error information.
//
// Returned Error Types:
//
//   - ConflictException
//     Updating or deleting a resource can cause an inconsistent state.
//
//   - ServiceQuotaExceededException
//     Request denied because service quota has been exceeded.
//
//   - ResourceNotFoundException
//     Request references a resource which does not exist.
//
//   - InternalServerException
//     Unexpected error during processing of request.
//
//   - ValidationException
//     The input fails to satisfy the specified constraints.
//
//   - ThrottlingException
//     Request was denied due to request throttling.
//
//   - AccessDeniedException
//     Caller does not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/CreateConfiguredTableAssociation
func (c *CleanRooms) CreateConfiguredTableAssociation(input *CreateConfiguredTableAssociationInput) (*CreateConfiguredTableAssociationOutput, error) {
	req, out := c.CreateConfiguredTableAssociationRequest(input)
	return out, req.Send()
}

// CreateConfiguredTableAssociationWithContext is the same as CreateConfiguredTableAssociation with the addition of
// the ability to pass a context and additional request options.
//
// See CreateConfiguredTableAssociation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CleanRooms) CreateConfiguredTableAssociationWithContext(ctx aws.Context, input *CreateConfiguredTableAssociationInput, opts ...request.Option) (*CreateConfiguredTableAssociationOutput, error) {
	req, out := c.CreateConfiguredTableAssociationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateIdMappingTable = "CreateIdMappingTable"

// CreateIdMappingTableRequest generates a "aws/request.Request" representing the
// client's request for the CreateIdMappingTable operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateIdMappingTable for more information on using the CreateIdMappingTable
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateIdMappingTableRequest method.
//	req, resp := client.CreateIdMappingTableRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/CreateIdMappingTable
func (c *CleanRooms) CreateIdMappingTableRequest(input *CreateIdMappingTableInput) (req *request.Request, output *CreateIdMappingTableOutput) {
	op := &request.Operation{
		Name:       opCreateIdMappingTable,
		HTTPMethod: "POST",
		HTTPPath:   "/memberships/{membershipIdentifier}/idmappingtables",
	}

	if input == nil {
		input = &CreateIdMappingTableInput{}
	}

	output = &CreateIdMappingTableOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateIdMappingTable API operation for AWS Clean Rooms Service.
//
// Creates an ID mapping table.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Clean Rooms Service's
// API operation CreateIdMappingTable for usage and error information.
//
// Returned Error Types:
//
//   - ConflictException
//     Updating or deleting a resource can cause an inconsistent state.
//
//   - ServiceQuotaExceededException
//     Request denied because service quota has been exceeded.
//
//   - ResourceNotFoundException
//     Request references a resource which does not exist.
//
//   - InternalServerException
//     Unexpected error during processing of request.
//
//   - ValidationException
//     The input fails to satisfy the specified constraints.
//
//   - ThrottlingException
//     Request was denied due to request throttling.
//
//   - AccessDeniedException
//     Caller does not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/CreateIdMappingTable
func (c *CleanRooms) CreateIdMappingTable(input *CreateIdMappingTableInput) (*CreateIdMappingTableOutput, error) {
	req, out := c.CreateIdMappingTableRequest(input)
	return out, req.Send()
}

// CreateIdMappingTableWithContext is the same as CreateIdMappingTable with the addition of
// the ability to pass a context and additional request options.
//
// See CreateIdMappingTable for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CleanRooms) CreateIdMappingTableWithContext(ctx aws.Context, input *CreateIdMappingTableInput, opts ...request.Option) (*CreateIdMappingTableOutput, error) {
	req, out := c.CreateIdMappingTableRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateMembership = "CreateMembership"

// CreateMembershipRequest generates a "aws/request.Request" representing the
// client's request for the CreateMembership operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateMembership for more information on using the CreateMembership
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateMembershipRequest method.
//	req, resp := client.CreateMembershipRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/CreateMembership
func (c *CleanRooms) CreateMembershipRequest(input *CreateMembershipInput) (req *request.Request, output *CreateMembershipOutput) {
	op := &request.Operation{
		Name:       opCreateMembership,
		HTTPMethod: "POST",
		HTTPPath:   "/memberships",
	}

	if input == nil {
		input = &CreateMembershipInput{}
	}

	output = &CreateMembershipOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateMembership API operation for AWS Clean Rooms Service.
//
// Creates a membership for a specific collaboration identifier and joins the
// collaboration.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Clean Rooms Service's
// API operation CreateMembership for usage and error information.
//
// Returned Error Types:
//
//   - ConflictException
//     Updating or deleting a resource can cause an inconsistent state.
//
//   - ServiceQuotaExceededException
//     Request denied because service quota has been exceeded.
//
//   - ResourceNotFoundException
//     Request references a resource which does not exist.
//
//   - InternalServerException
//     Unexpected error during processing of request.
//
//   - ValidationException
//     The input fails to satisfy the specified constraints.
//
//   - ThrottlingException
//     Request was denied due to request throttling.
//
//   - AccessDeniedException
//     Caller does not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/CreateMembership
func (c *CleanRooms) CreateMembership(input *CreateMembershipInput) (*CreateMembershipOutput, error) {
	req, out := c.CreateMembershipRequest(input)
	return out, req.Send()
}

// CreateMembershipWithContext is the same as CreateMembership with the addition of
// the ability to pass a context and additional request options.
//
// See CreateMembership for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CleanRooms) CreateMembershipWithContext(ctx aws.Context, input *CreateMembershipInput, opts ...request.Option) (*CreateMembershipOutput, error) {
	req, out := c.CreateMembershipRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreatePrivacyBudgetTemplate = "CreatePrivacyBudgetTemplate"

// CreatePrivacyBudgetTemplateRequest generates a "aws/request.Request" representing the
// client's request for the CreatePrivacyBudgetTemplate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreatePrivacyBudgetTemplate for more information on using the CreatePrivacyBudgetTemplate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreatePrivacyBudgetTemplateRequest method.
//	req, resp := client.CreatePrivacyBudgetTemplateRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/CreatePrivacyBudgetTemplate
func (c *CleanRooms) CreatePrivacyBudgetTemplateRequest(input *CreatePrivacyBudgetTemplateInput) (req *request.Request, output *CreatePrivacyBudgetTemplateOutput) {
	op := &request.Operation{
		Name:       opCreatePrivacyBudgetTemplate,
		HTTPMethod: "POST",
		HTTPPath:   "/memberships/{membershipIdentifier}/privacybudgettemplates",
	}

	if input == nil {
		input = &CreatePrivacyBudgetTemplateInput{}
	}

	output = &CreatePrivacyBudgetTemplateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreatePrivacyBudgetTemplate API operation for AWS Clean Rooms Service.
//
// Creates a privacy budget template for a specified membership. Each membership
// can have only one privacy budget template, but it can be deleted and recreated.
// If you need to change the privacy budget template for a membership, use the
// UpdatePrivacyBudgetTemplate operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Clean Rooms Service's
// API operation CreatePrivacyBudgetTemplate for usage and error information.
//
// Returned Error Types:
//
//   - ConflictException
//     Updating or deleting a resource can cause an inconsistent state.
//
//   - ResourceNotFoundException
//     Request references a resource which does not exist.
//
//   - InternalServerException
//     Unexpected error during processing of request.
//
//   - ValidationException
//     The input fails to satisfy the specified constraints.
//
//   - ThrottlingException
//     Request was denied due to request throttling.
//
//   - AccessDeniedException
//     Caller does not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/CreatePrivacyBudgetTemplate
func (c *CleanRooms) CreatePrivacyBudgetTemplate(input *CreatePrivacyBudgetTemplateInput) (*CreatePrivacyBudgetTemplateOutput, error) {
	req, out := c.CreatePrivacyBudgetTemplateRequest(input)
	return out, req.Send()
}

// CreatePrivacyBudgetTemplateWithContext is the same as CreatePrivacyBudgetTemplate with the addition of
// the ability to pass a context and additional request options.
//
// See CreatePrivacyBudgetTemplate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CleanRooms) CreatePrivacyBudgetTemplateWithContext(ctx aws.Context, input *CreatePrivacyBudgetTemplateInput, opts ...request.Option) (*CreatePrivacyBudgetTemplateOutput, error) {
	req, out := c.CreatePrivacyBudgetTemplateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteAnalysisTemplate = "DeleteAnalysisTemplate"

// DeleteAnalysisTemplateRequest generates a "aws/request.Request" representing the
// client's request for the DeleteAnalysisTemplate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteAnalysisTemplate for more information on using the DeleteAnalysisTemplate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteAnalysisTemplateRequest method.
//	req, resp := client.DeleteAnalysisTemplateRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/DeleteAnalysisTemplate
func (c *CleanRooms) DeleteAnalysisTemplateRequest(input *DeleteAnalysisTemplateInput) (req *request.Request, output *DeleteAnalysisTemplateOutput) {
	op := &request.Operation{
		Name:       opDeleteAnalysisTemplate,
		HTTPMethod: "DELETE",
		HTTPPath:   "/memberships/{membershipIdentifier}/analysistemplates/{analysisTemplateIdentifier}",
	}

	if input == nil {
		input = &DeleteAnalysisTemplateInput{}
	}

	output = &DeleteAnalysisTemplateOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteAnalysisTemplate API operation for AWS Clean Rooms Service.
//
// Deletes an analysis template.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Clean Rooms Service's
// API operation DeleteAnalysisTemplate for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     Request references a resource which does not exist.
//
//   - InternalServerException
//     Unexpected error during processing of request.
//
//   - ValidationException
//     The input fails to satisfy the specified constraints.
//
//   - ThrottlingException
//     Request was denied due to request throttling.
//
//   - AccessDeniedException
//     Caller does not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/DeleteAnalysisTemplate
func (c *CleanRooms) DeleteAnalysisTemplate(input *DeleteAnalysisTemplateInput) (*DeleteAnalysisTemplateOutput, error) {
	req, out := c.DeleteAnalysisTemplateRequest(input)
	return out, req.Send()
}

// DeleteAnalysisTemplateWithContext is the same as DeleteAnalysisTemplate with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteAnalysisTemplate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CleanRooms) DeleteAnalysisTemplateWithContext(ctx aws.Context, input *DeleteAnalysisTemplateInput, opts ...request.Option) (*DeleteAnalysisTemplateOutput, error) {
	req, out := c.DeleteAnalysisTemplateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteCollaboration = "DeleteCollaboration"

// DeleteCollaborationRequest generates a "aws/request.Request" representing the
// client's request for the DeleteCollaboration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteCollaboration for more information on using the DeleteCollaboration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteCollaborationRequest method.
//	req, resp := client.DeleteCollaborationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/DeleteCollaboration
func (c *CleanRooms) DeleteCollaborationRequest(input *DeleteCollaborationInput) (req *request.Request, output *DeleteCollaborationOutput) {
	op := &request.Operation{
		Name:       opDeleteCollaboration,
		HTTPMethod: "DELETE",
		HTTPPath:   "/collaborations/{collaborationIdentifier}",
	}

	if input == nil {
		input = &DeleteCollaborationInput{}
	}

	output = &DeleteCollaborationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteCollaboration API operation for AWS Clean Rooms Service.
//
// Deletes a collaboration. It can only be called by the collaboration owner.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Clean Rooms Service's
// API operation DeleteCollaboration for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     Unexpected error during processing of request.
//
//   - ValidationException
//     The input fails to satisfy the specified constraints.
//
//   - ThrottlingException
//     Request was denied due to request throttling.
//
//   - AccessDeniedException
//     Caller does not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/DeleteCollaboration
func (c *CleanRooms) DeleteCollaboration(input *DeleteCollaborationInput) (*DeleteCollaborationOutput, error) {
	req, out := c.DeleteCollaborationRequest(input)
	return out, req.Send()
}

// DeleteCollaborationWithContext is the same as DeleteCollaboration with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteCollaboration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CleanRooms) DeleteCollaborationWithContext(ctx aws.Context, input *DeleteCollaborationInput, opts ...request.Option) (*DeleteCollaborationOutput, error) {
	req, out := c.DeleteCollaborationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteConfiguredAudienceModelAssociation = "DeleteConfiguredAudienceModelAssociation"

// DeleteConfiguredAudienceModelAssociationRequest generates a "aws/request.Request" representing the
// client's request for the DeleteConfiguredAudienceModelAssociation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteConfiguredAudienceModelAssociation for more information on using the DeleteConfiguredAudienceModelAssociation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteConfiguredAudienceModelAssociationRequest method.
//	req, resp := client.DeleteConfiguredAudienceModelAssociationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/DeleteConfiguredAudienceModelAssociation
func (c *CleanRooms) DeleteConfiguredAudienceModelAssociationRequest(input *DeleteConfiguredAudienceModelAssociationInput) (req *request.Request, output *DeleteConfiguredAudienceModelAssociationOutput) {
	op := &request.Operation{
		Name:       opDeleteConfiguredAudienceModelAssociation,
		HTTPMethod: "DELETE",
		HTTPPath:   "/memberships/{membershipIdentifier}/configuredaudiencemodelassociations/{configuredAudienceModelAssociationIdentifier}",
	}

	if input == nil {
		input = &DeleteConfiguredAudienceModelAssociationInput{}
	}

	output = &DeleteConfiguredAudienceModelAssociationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteConfiguredAudienceModelAssociation API operation for AWS Clean Rooms Service.
//
// Provides the information necessary to delete a configured audience model
// association.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Clean Rooms Service's
// API operation DeleteConfiguredAudienceModelAssociation for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     Request references a resource which does not exist.
//
//   - InternalServerException
//     Unexpected error during processing of request.
//
//   - ValidationException
//     The input fails to satisfy the specified constraints.
//
//   - ThrottlingException
//     Request was denied due to request throttling.
//
//   - AccessDeniedException
//     Caller does not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/DeleteConfiguredAudienceModelAssociation
func (c *CleanRooms) DeleteConfiguredAudienceModelAssociation(input *DeleteConfiguredAudienceModelAssociationInput) (*DeleteConfiguredAudienceModelAssociationOutput, error) {
	req, out := c.DeleteConfiguredAudienceModelAssociationRequest(input)
	return out, req.Send()
}

// DeleteConfiguredAudienceModelAssociationWithContext is the same as DeleteConfiguredAudienceModelAssociation with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteConfiguredAudienceModelAssociation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CleanRooms) DeleteConfiguredAudienceModelAssociationWithContext(ctx aws.Context, input *DeleteConfiguredAudienceModelAssociationInput, opts ...request.Option) (*DeleteConfiguredAudienceModelAssociationOutput, error) {
	req, out := c.DeleteConfiguredAudienceModelAssociationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteConfiguredTable = "DeleteConfiguredTable"

// DeleteConfiguredTableRequest generates a "aws/request.Request" representing the
// client's request for the DeleteConfiguredTable operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteConfiguredTable for more information on using the DeleteConfiguredTable
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteConfiguredTableRequest method.
//	req, resp := client.DeleteConfiguredTableRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/DeleteConfiguredTable
func (c *CleanRooms) DeleteConfiguredTableRequest(input *DeleteConfiguredTableInput) (req *request.Request, output *DeleteConfiguredTableOutput) {
	op := &request.Operation{
		Name:       opDeleteConfiguredTable,
		HTTPMethod: "DELETE",
		HTTPPath:   "/configuredTables/{configuredTableIdentifier}",
	}

	if input == nil {
		input = &DeleteConfiguredTableInput{}
	}

	output = &DeleteConfiguredTableOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteConfiguredTable API operation for AWS Clean Rooms Service.
//
// Deletes a configured table.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Clean Rooms Service's
// API operation DeleteConfiguredTable for usage and error information.
//
// Returned Error Types:
//
//   - ConflictException
//     Updating or deleting a resource can cause an inconsistent state.
//
//   - ResourceNotFoundException
//     Request references a resource which does not exist.
//
//   - InternalServerException
//     Unexpected error during processing of request.
//
//   - ValidationException
//     The input fails to satisfy the specified constraints.
//
//   - ThrottlingException
//     Request was denied due to request throttling.
//
//   - AccessDeniedException
//     Caller does not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/DeleteConfiguredTable
func (c *CleanRooms) DeleteConfiguredTable(input *DeleteConfiguredTableInput) (*DeleteConfiguredTableOutput, error) {
	req, out := c.DeleteConfiguredTableRequest(input)
	return out, req.Send()
}

// DeleteConfiguredTableWithContext is the same as DeleteConfiguredTable with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteConfiguredTable for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CleanRooms) DeleteConfiguredTableWithContext(ctx aws.Context, input *DeleteConfiguredTableInput, opts ...request.Option) (*DeleteConfiguredTableOutput, error) {
	req, out := c.DeleteConfiguredTableRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteConfiguredTableAnalysisRule = "DeleteConfiguredTableAnalysisRule"

// DeleteConfiguredTableAnalysisRuleRequest generates a "aws/request.Request" representing the
// client's request for the DeleteConfiguredTableAnalysisRule operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteConfiguredTableAnalysisRule for more information on using the DeleteConfiguredTableAnalysisRule
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteConfiguredTableAnalysisRuleRequest method.
//	req, resp := client.DeleteConfiguredTableAnalysisRuleRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/DeleteConfiguredTableAnalysisRule
func (c *CleanRooms) DeleteConfiguredTableAnalysisRuleRequest(input *DeleteConfiguredTableAnalysisRuleInput) (req *request.Request, output *DeleteConfiguredTableAnalysisRuleOutput) {
	op := &request.Operation{
		Name:       opDeleteConfiguredTableAnalysisRule,
		HTTPMethod: "DELETE",
		HTTPPath:   "/configuredTables/{configuredTableIdentifier}/analysisRule/{analysisRuleType}",
	}

	if input == nil {
		input = &DeleteConfiguredTableAnalysisRuleInput{}
	}

	output = &DeleteConfiguredTableAnalysisRuleOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteConfiguredTableAnalysisRule API operation for AWS Clean Rooms Service.
//
// Deletes a configured table analysis rule.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Clean Rooms Service's
// API operation DeleteConfiguredTableAnalysisRule for usage and error information.
//
// Returned Error Types:
//
//   - ConflictException
//     Updating or deleting a resource can cause an inconsistent state.
//
//   - ResourceNotFoundException
//     Request references a resource which does not exist.
//
//   - InternalServerException
//     Unexpected error during processing of request.
//
//   - ValidationException
//     The input fails to satisfy the specified constraints.
//
//   - ThrottlingException
//     Request was denied due to request throttling.
//
//   - AccessDeniedException
//     Caller does not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/DeleteConfiguredTableAnalysisRule
func (c *CleanRooms) DeleteConfiguredTableAnalysisRule(input *DeleteConfiguredTableAnalysisRuleInput) (*DeleteConfiguredTableAnalysisRuleOutput, error) {
	req, out := c.DeleteConfiguredTableAnalysisRuleRequest(input)
	return out, req.Send()
}

// DeleteConfiguredTableAnalysisRuleWithContext is the same as DeleteConfiguredTableAnalysisRule with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteConfiguredTableAnalysisRule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CleanRooms) DeleteConfiguredTableAnalysisRuleWithContext(ctx aws.Context, input *DeleteConfiguredTableAnalysisRuleInput, opts ...request.Option) (*DeleteConfiguredTableAnalysisRuleOutput, error) {
	req, out := c.DeleteConfiguredTableAnalysisRuleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteConfiguredTableAssociation = "DeleteConfiguredTableAssociation"

// DeleteConfiguredTableAssociationRequest generates a "aws/request.Request" representing the
// client's request for the DeleteConfiguredTableAssociation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteConfiguredTableAssociation for more information on using the DeleteConfiguredTableAssociation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteConfiguredTableAssociationRequest method.
//	req, resp := client.DeleteConfiguredTableAssociationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/DeleteConfiguredTableAssociation
func (c *CleanRooms) DeleteConfiguredTableAssociationRequest(input *DeleteConfiguredTableAssociationInput) (req *request.Request, output *DeleteConfiguredTableAssociationOutput) {
	op := &request.Operation{
		Name:       opDeleteConfiguredTableAssociation,
		HTTPMethod: "DELETE",
		HTTPPath:   "/memberships/{membershipIdentifier}/configuredTableAssociations/{configuredTableAssociationIdentifier}",
	}

	if input == nil {
		input = &DeleteConfiguredTableAssociationInput{}
	}

	output = &DeleteConfiguredTableAssociationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteConfiguredTableAssociation API operation for AWS Clean Rooms Service.
//
// Deletes a configured table association.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Clean Rooms Service's
// API operation DeleteConfiguredTableAssociation for usage and error information.
//
// Returned Error Types:
//
//   - ConflictException
//     Updating or deleting a resource can cause an inconsistent state.
//
//   - ResourceNotFoundException
//     Request references a resource which does not exist.
//
//   - InternalServerException
//     Unexpected error during processing of request.
//
//   - ValidationException
//     The input fails to satisfy the specified constraints.
//
//   - ThrottlingException
//     Request was denied due to request throttling.
//
//   - AccessDeniedException
//     Caller does not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/DeleteConfiguredTableAssociation
func (c *CleanRooms) DeleteConfiguredTableAssociation(input *DeleteConfiguredTableAssociationInput) (*DeleteConfiguredTableAssociationOutput, error) {
	req, out := c.DeleteConfiguredTableAssociationRequest(input)
	return out, req.Send()
}

// DeleteConfiguredTableAssociationWithContext is the same as DeleteConfiguredTableAssociation with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteConfiguredTableAssociation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CleanRooms) DeleteConfiguredTableAssociationWithContext(ctx aws.Context, input *DeleteConfiguredTableAssociationInput, opts ...request.Option) (*DeleteConfiguredTableAssociationOutput, error) {
	req, out := c.DeleteConfiguredTableAssociationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteIdMappingTable = "DeleteIdMappingTable"

// DeleteIdMappingTableRequest generates a "aws/request.Request" representing the
// client's request for the DeleteIdMappingTable operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteIdMappingTable for more information on using the DeleteIdMappingTable
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteIdMappingTableRequest method.
//	req, resp := client.DeleteIdMappingTableRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/DeleteIdMappingTable
func (c *CleanRooms) DeleteIdMappingTableRequest(input *DeleteIdMappingTableInput) (req *request.Request, output *DeleteIdMappingTableOutput) {
	op := &request.Operation{
		Name:       opDeleteIdMappingTable,
		HTTPMethod: "DELETE",
		HTTPPath:   "/memberships/{membershipIdentifier}/idmappingtables/{idMappingTableIdentifier}",
	}

	if input == nil {
		input = &DeleteIdMappingTableInput{}
	}

	output = &DeleteIdMappingTableOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteIdMappingTable API operation for AWS Clean Rooms Service.
//
// Deletes an ID mapping table.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Clean Rooms Service's
// API operation DeleteIdMappingTable for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     Request references a resource which does not exist.
//
//   - InternalServerException
//     Unexpected error during processing of request.
//
//   - ValidationException
//     The input fails to satisfy the specified constraints.
//
//   - ThrottlingException
//     Request was denied due to request throttling.
//
//   - AccessDeniedException
//     Caller does not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/DeleteIdMappingTable
func (c *CleanRooms) DeleteIdMappingTable(input *DeleteIdMappingTableInput) (*DeleteIdMappingTableOutput, error) {
	req, out := c.DeleteIdMappingTableRequest(input)
	return out, req.Send()
}

// DeleteIdMappingTableWithContext is the same as DeleteIdMappingTable with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteIdMappingTable for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CleanRooms) DeleteIdMappingTableWithContext(ctx aws.Context, input *DeleteIdMappingTableInput, opts ...request.Option) (*DeleteIdMappingTableOutput, error) {
	req, out := c.DeleteIdMappingTableRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteIdNamespaceAssociation = "DeleteIdNamespaceAssociation"

// DeleteIdNamespaceAssociationRequest generates a "aws/request.Request" representing the
// client's request for the DeleteIdNamespaceAssociation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteIdNamespaceAssociation for more information on using the DeleteIdNamespaceAssociation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteIdNamespaceAssociationRequest method.
//	req, resp := client.DeleteIdNamespaceAssociationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/DeleteIdNamespaceAssociation
func (c *CleanRooms) DeleteIdNamespaceAssociationRequest(input *DeleteIdNamespaceAssociationInput) (req *request.Request, output *DeleteIdNamespaceAssociationOutput) {
	op := &request.Operation{
		Name:       opDeleteIdNamespaceAssociation,
		HTTPMethod: "DELETE",
		HTTPPath:   "/memberships/{membershipIdentifier}/idnamespaceassociations/{idNamespaceAssociationIdentifier}",
	}

	if input == nil {
		input = &DeleteIdNamespaceAssociationInput{}
	}

	output = &DeleteIdNamespaceAssociationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteIdNamespaceAssociation API operation for AWS Clean Rooms Service.
//
// Deletes an ID namespace association.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Clean Rooms Service's
// API operation DeleteIdNamespaceAssociation for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     Request references a resource which does not exist.
//
//   - InternalServerException
//     Unexpected error during processing of request.
//
//   - ValidationException
//     The input fails to satisfy the specified constraints.
//
//   - ThrottlingException
//     Request was denied due to request throttling.
//
//   - AccessDeniedException
//     Caller does not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/DeleteIdNamespaceAssociation
func (c *CleanRooms) DeleteIdNamespaceAssociation(input *DeleteIdNamespaceAssociationInput) (*DeleteIdNamespaceAssociationOutput, error) {
	req, out := c.DeleteIdNamespaceAssociationRequest(input)
	return out, req.Send()
}

// DeleteIdNamespaceAssociationWithContext is the same as DeleteIdNamespaceAssociation with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteIdNamespaceAssociation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CleanRooms) DeleteIdNamespaceAssociationWithContext(ctx aws.Context, input *DeleteIdNamespaceAssociationInput, opts ...request.Option) (*DeleteIdNamespaceAssociationOutput, error) {
	req, out := c.DeleteIdNamespaceAssociationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteMember = "DeleteMember"

// DeleteMemberRequest generates a "aws/request.Request" representing the
// client's request for the DeleteMember operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteMember for more information on using the DeleteMember
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteMemberRequest method.
//	req, resp := client.DeleteMemberRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/DeleteMember
func (c *CleanRooms) DeleteMemberRequest(input *DeleteMemberInput) (req *request.Request, output *DeleteMemberOutput) {
	op := &request.Operation{
		Name:       opDeleteMember,
		HTTPMethod: "DELETE",
		HTTPPath:   "/collaborations/{collaborationIdentifier}/member/{accountId}",
	}

	if input == nil {
		input = &DeleteMemberInput{}
	}

	output = &DeleteMemberOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteMember API operation for AWS Clean Rooms Service.
//
// Removes the specified member from a collaboration. The removed member is
// placed in the Removed status and can't interact with the collaboration. The
// removed member's data is inaccessible to active members of the collaboration.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Clean Rooms Service's
// API operation DeleteMember for usage and error information.
//
// Returned Error Types:
//
//   - ConflictException
//     Updating or deleting a resource can cause an inconsistent state.
//
//   - ResourceNotFoundException
//     Request references a resource which does not exist.
//
//   - InternalServerException
//     Unexpected error during processing of request.
//
//   - ValidationException
//     The input fails to satisfy the specified constraints.
//
//   - ThrottlingException
//     Request was denied due to request throttling.
//
//   - AccessDeniedException
//     Caller does not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/DeleteMember
func (c *CleanRooms) DeleteMember(input *DeleteMemberInput) (*DeleteMemberOutput, error) {
	req, out := c.DeleteMemberRequest(input)
	return out, req.Send()
}

// DeleteMemberWithContext is the same as DeleteMember with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteMember for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CleanRooms) DeleteMemberWithContext(ctx aws.Context, input *DeleteMemberInput, opts ...request.Option) (*DeleteMemberOutput, error) {
	req, out := c.DeleteMemberRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteMembership = "DeleteMembership"

// DeleteMembershipRequest generates a "aws/request.Request" representing the
// client's request for the DeleteMembership operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteMembership for more information on using the DeleteMembership
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteMembershipRequest method.
//	req, resp := client.DeleteMembershipRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/DeleteMembership
func (c *CleanRooms) DeleteMembershipRequest(input *DeleteMembershipInput) (req *request.Request, output *DeleteMembershipOutput) {
	op := &request.Operation{
		Name:       opDeleteMembership,
		HTTPMethod: "DELETE",
		HTTPPath:   "/memberships/{membershipIdentifier}",
	}

	if input == nil {
		input = &DeleteMembershipInput{}
	}

	output = &DeleteMembershipOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteMembership API operation for AWS Clean Rooms Service.
//
// Deletes a specified membership. All resources under a membership must be
// deleted.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Clean Rooms Service's
// API operation DeleteMembership for usage and error information.
//
// Returned Error Types:
//
//   - ConflictException
//     Updating or deleting a resource can cause an inconsistent state.
//
//   - ResourceNotFoundException
//     Request references a resource which does not exist.
//
//   - InternalServerException
//     Unexpected error during processing of request.
//
//   - ValidationException
//     The input fails to satisfy the specified constraints.
//
//   - ThrottlingException
//     Request was denied due to request throttling.
//
//   - AccessDeniedException
//     Caller does not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/DeleteMembership
func (c *CleanRooms) DeleteMembership(input *DeleteMembershipInput) (*DeleteMembershipOutput, error) {
	req, out := c.DeleteMembershipRequest(input)
	return out, req.Send()
}

// DeleteMembershipWithContext is the same as DeleteMembership with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteMembership for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CleanRooms) DeleteMembershipWithContext(ctx aws.Context, input *DeleteMembershipInput, opts ...request.Option) (*DeleteMembershipOutput, error) {
	req, out := c.DeleteMembershipRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeletePrivacyBudgetTemplate = "DeletePrivacyBudgetTemplate"

// DeletePrivacyBudgetTemplateRequest generates a "aws/request.Request" representing the
// client's request for the DeletePrivacyBudgetTemplate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeletePrivacyBudgetTemplate for more information on using the DeletePrivacyBudgetTemplate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeletePrivacyBudgetTemplateRequest method.
//	req, resp := client.DeletePrivacyBudgetTemplateRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/DeletePrivacyBudgetTemplate
func (c *CleanRooms) DeletePrivacyBudgetTemplateRequest(input *DeletePrivacyBudgetTemplateInput) (req *request.Request, output *DeletePrivacyBudgetTemplateOutput) {
	op := &request.Operation{
		Name:       opDeletePrivacyBudgetTemplate,
		HTTPMethod: "DELETE",
		HTTPPath:   "/memberships/{membershipIdentifier}/privacybudgettemplates/{privacyBudgetTemplateIdentifier}",
	}

	if input == nil {
		input = &DeletePrivacyBudgetTemplateInput{}
	}

	output = &DeletePrivacyBudgetTemplateOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeletePrivacyBudgetTemplate API operation for AWS Clean Rooms Service.
//
// Deletes a privacy budget template for a specified membership.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Clean Rooms Service's
// API operation DeletePrivacyBudgetTemplate for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     Request references a resource which does not exist.
//
//   - InternalServerException
//     Unexpected error during processing of request.
//
//   - ValidationException
//     The input fails to satisfy the specified constraints.
//
//   - ThrottlingException
//     Request was denied due to request throttling.
//
//   - AccessDeniedException
//     Caller does not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/DeletePrivacyBudgetTemplate
func (c *CleanRooms) DeletePrivacyBudgetTemplate(input *DeletePrivacyBudgetTemplateInput) (*DeletePrivacyBudgetTemplateOutput, error) {
	req, out := c.DeletePrivacyBudgetTemplateRequest(input)
	return out, req.Send()
}

// DeletePrivacyBudgetTemplateWithContext is the same as DeletePrivacyBudgetTemplate with the addition of
// the ability to pass a context and additional request options.
//
// See DeletePrivacyBudgetTemplate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CleanRooms) DeletePrivacyBudgetTemplateWithContext(ctx aws.Context, input *DeletePrivacyBudgetTemplateInput, opts ...request.Option) (*DeletePrivacyBudgetTemplateOutput, error) {
	req, out := c.DeletePrivacyBudgetTemplateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetAnalysisTemplate = "GetAnalysisTemplate"

// GetAnalysisTemplateRequest generates a "aws/request.Request" representing the
// client's request for the GetAnalysisTemplate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetAnalysisTemplate for more information on using the GetAnalysisTemplate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetAnalysisTemplateRequest method.
//	req, resp := client.GetAnalysisTemplateRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/GetAnalysisTemplate
func (c *CleanRooms) GetAnalysisTemplateRequest(input *GetAnalysisTemplateInput) (req *request.Request, output *GetAnalysisTemplateOutput) {
	op := &request.Operation{
		Name:       opGetAnalysisTemplate,
		HTTPMethod: "GET",
		HTTPPath:   "/memberships/{membershipIdentifier}/analysistemplates/{analysisTemplateIdentifier}",
	}

	if input == nil {
		input = &GetAnalysisTemplateInput{}
	}

	output = &GetAnalysisTemplateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetAnalysisTemplate API operation for AWS Clean Rooms Service.
//
// Retrieves an analysis template.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Clean Rooms Service's
// API operation GetAnalysisTemplate for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     Request references a resource which does not exist.
//
//   - InternalServerException
//     Unexpected error during processing of request.
//
//   - ValidationException
//     The input fails to satisfy the specified constraints.
//
//   - ThrottlingException
//     Request was denied due to request throttling.
//
//   - AccessDeniedException
//     Caller does not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/GetAnalysisTemplate
func (c *CleanRooms) GetAnalysisTemplate(input *GetAnalysisTemplateInput) (*GetAnalysisTemplateOutput, error) {
	req, out := c.GetAnalysisTemplateRequest(input)
	return out, req.Send()
}

// GetAnalysisTemplateWithContext is the same as GetAnalysisTemplate with the addition of
// the ability to pass a context and additional request options.
//
// See GetAnalysisTemplate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CleanRooms) GetAnalysisTemplateWithContext(ctx aws.Context, input *GetAnalysisTemplateInput, opts ...request.Option) (*GetAnalysisTemplateOutput, error) {
	req, out := c.GetAnalysisTemplateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetCollaboration = "GetCollaboration"

// GetCollaborationRequest generates a "aws/request.Request" representing the
// client's request for the GetCollaboration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetCollaboration for more information on using the GetCollaboration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetCollaborationRequest method.
//	req, resp := client.GetCollaborationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/GetCollaboration
func (c *CleanRooms) GetCollaborationRequest(input *GetCollaborationInput) (req *request.Request, output *GetCollaborationOutput) {
	op := &request.Operation{
		Name:       opGetCollaboration,
		HTTPMethod: "GET",
		HTTPPath:   "/collaborations/{collaborationIdentifier}",
	}

	if input == nil {
		input = &GetCollaborationInput{}
	}

	output = &GetCollaborationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetCollaboration API operation for AWS Clean Rooms Service.
//
// Returns metadata about a collaboration.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Clean Rooms Service's
// API operation GetCollaboration for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     Unexpected error during processing of request.
//
//   - ValidationException
//     The input fails to satisfy the specified constraints.
//
//   - ThrottlingException
//     Request was denied due to request throttling.
//
//   - AccessDeniedException
//     Caller does not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/GetCollaboration
func (c *CleanRooms) GetCollaboration(input *GetCollaborationInput) (*GetCollaborationOutput, error) {
	req, out := c.GetCollaborationRequest(input)
	return out, req.Send()
}

// GetCollaborationWithContext is the same as GetCollaboration with the addition of
// the ability to pass a context and additional request options.
//
// See GetCollaboration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CleanRooms) GetCollaborationWithContext(ctx aws.Context, input *GetCollaborationInput, opts ...request.Option) (*GetCollaborationOutput, error) {
	req, out := c.GetCollaborationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetCollaborationAnalysisTemplate = "GetCollaborationAnalysisTemplate"

// GetCollaborationAnalysisTemplateRequest generates a "aws/request.Request" representing the
// client's request for the GetCollaborationAnalysisTemplate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetCollaborationAnalysisTemplate for more information on using the GetCollaborationAnalysisTemplate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetCollaborationAnalysisTemplateRequest method.
//	req, resp := client.GetCollaborationAnalysisTemplateRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/GetCollaborationAnalysisTemplate
func (c *CleanRooms) GetCollaborationAnalysisTemplateRequest(input *GetCollaborationAnalysisTemplateInput) (req *request.Request, output *GetCollaborationAnalysisTemplateOutput) {
	op := &request.Operation{
		Name:       opGetCollaborationAnalysisTemplate,
		HTTPMethod: "GET",
		HTTPPath:   "/collaborations/{collaborationIdentifier}/analysistemplates/{analysisTemplateArn}",
	}

	if input == nil {
		input = &GetCollaborationAnalysisTemplateInput{}
	}

	output = &GetCollaborationAnalysisTemplateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetCollaborationAnalysisTemplate API operation for AWS Clean Rooms Service.
//
// Retrieves an analysis template within a collaboration.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Clean Rooms Service's
// API operation GetCollaborationAnalysisTemplate for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     Request references a resource which does not exist.
//
//   - InternalServerException
//     Unexpected error during processing of request.
//
//   - ValidationException
//     The input fails to satisfy the specified constraints.
//
//   - ThrottlingException
//     Request was denied due to request throttling.
//
//   - AccessDeniedException
//     Caller does not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/GetCollaborationAnalysisTemplate
func (c *CleanRooms) GetCollaborationAnalysisTemplate(input *GetCollaborationAnalysisTemplateInput) (*GetCollaborationAnalysisTemplateOutput, error) {
	req, out := c.GetCollaborationAnalysisTemplateRequest(input)
	return out, req.Send()
}

// GetCollaborationAnalysisTemplateWithContext is the same as GetCollaborationAnalysisTemplate with the addition of
// the ability to pass a context and additional request options.
//
// See GetCollaborationAnalysisTemplate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CleanRooms) GetCollaborationAnalysisTemplateWithContext(ctx aws.Context, input *GetCollaborationAnalysisTemplateInput, opts ...request.Option) (*GetCollaborationAnalysisTemplateOutput, error) {
	req, out := c.GetCollaborationAnalysisTemplateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetCollaborationConfiguredAudienceModelAssociation = "GetCollaborationConfiguredAudienceModelAssociation"

// GetCollaborationConfiguredAudienceModelAssociationRequest generates a "aws/request.Request" representing the
// client's request for the GetCollaborationConfiguredAudienceModelAssociation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetCollaborationConfiguredAudienceModelAssociation for more information on using the GetCollaborationConfiguredAudienceModelAssociation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetCollaborationConfiguredAudienceModelAssociationRequest method.
//	req, resp := client.GetCollaborationConfiguredAudienceModelAssociationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/GetCollaborationConfiguredAudienceModelAssociation
func (c *CleanRooms) GetCollaborationConfiguredAudienceModelAssociationRequest(input *GetCollaborationConfiguredAudienceModelAssociationInput) (req *request.Request, output *GetCollaborationConfiguredAudienceModelAssociationOutput) {
	op := &request.Operation{
		Name:       opGetCollaborationConfiguredAudienceModelAssociation,
		HTTPMethod: "GET",
		HTTPPath:   "/collaborations/{collaborationIdentifier}/configuredaudiencemodelassociations/{configuredAudienceModelAssociationIdentifier}",
	}

	if input == nil {
		input = &GetCollaborationConfiguredAudienceModelAssociationInput{}
	}

	output = &GetCollaborationConfiguredAudienceModelAssociationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetCollaborationConfiguredAudienceModelAssociation API operation for AWS Clean Rooms Service.
//
// Retrieves a configured audience model association within a collaboration.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Clean Rooms Service's
// API operation GetCollaborationConfiguredAudienceModelAssociation for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     Request references a resource which does not exist.
//
//   - InternalServerException
//     Unexpected error during processing of request.
//
//   - ValidationException
//     The input fails to satisfy the specified constraints.
//
//   - ThrottlingException
//     Request was denied due to request throttling.
//
//   - AccessDeniedException
//     Caller does not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/GetCollaborationConfiguredAudienceModelAssociation
func (c *CleanRooms) GetCollaborationConfiguredAudienceModelAssociation(input *GetCollaborationConfiguredAudienceModelAssociationInput) (*GetCollaborationConfiguredAudienceModelAssociationOutput, error) {
	req, out := c.GetCollaborationConfiguredAudienceModelAssociationRequest(input)
	return out, req.Send()
}

// GetCollaborationConfiguredAudienceModelAssociationWithContext is the same as GetCollaborationConfiguredAudienceModelAssociation with the addition of
// the ability to pass a context and additional request options.
//
// See GetCollaborationConfiguredAudienceModelAssociation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CleanRooms) GetCollaborationConfiguredAudienceModelAssociationWithContext(ctx aws.Context, input *GetCollaborationConfiguredAudienceModelAssociationInput, opts ...request.Option) (*GetCollaborationConfiguredAudienceModelAssociationOutput, error) {
	req, out := c.GetCollaborationConfiguredAudienceModelAssociationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetCollaborationPrivacyBudgetTemplate = "GetCollaborationPrivacyBudgetTemplate"

// GetCollaborationPrivacyBudgetTemplateRequest generates a "aws/request.Request" representing the
// client's request for the GetCollaborationPrivacyBudgetTemplate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetCollaborationPrivacyBudgetTemplate for more information on using the GetCollaborationPrivacyBudgetTemplate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetCollaborationPrivacyBudgetTemplateRequest method.
//	req, resp := client.GetCollaborationPrivacyBudgetTemplateRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/GetCollaborationPrivacyBudgetTemplate
func (c *CleanRooms) GetCollaborationPrivacyBudgetTemplateRequest(input *GetCollaborationPrivacyBudgetTemplateInput) (req *request.Request, output *GetCollaborationPrivacyBudgetTemplateOutput) {
	op := &request.Operation{
		Name:       opGetCollaborationPrivacyBudgetTemplate,
		HTTPMethod: "GET",
		HTTPPath:   "/collaborations/{collaborationIdentifier}/privacybudgettemplates/{privacyBudgetTemplateIdentifier}",
	}

	if input == nil {
		input = &GetCollaborationPrivacyBudgetTemplateInput{}
	}

	output = &GetCollaborationPrivacyBudgetTemplateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetCollaborationPrivacyBudgetTemplate API operation for AWS Clean Rooms Service.
//
// Returns details about a specified privacy budget template.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Clean Rooms Service's
// API operation GetCollaborationPrivacyBudgetTemplate for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     Request references a resource which does not exist.
//
//   - InternalServerException
//     Unexpected error during processing of request.
//
//   - ValidationException
//     The input fails to satisfy the specified constraints.
//
//   - ThrottlingException
//     Request was denied due to request throttling.
//
//   - AccessDeniedException
//     Caller does not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/GetCollaborationPrivacyBudgetTemplate
func (c *CleanRooms) GetCollaborationPrivacyBudgetTemplate(input *GetCollaborationPrivacyBudgetTemplateInput) (*GetCollaborationPrivacyBudgetTemplateOutput, error) {
	req, out := c.GetCollaborationPrivacyBudgetTemplateRequest(input)
	return out, req.Send()
}

// GetCollaborationPrivacyBudgetTemplateWithContext is the same as GetCollaborationPrivacyBudgetTemplate with the addition of
// the ability to pass a context and additional request options.
//
// See GetCollaborationPrivacyBudgetTemplate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CleanRooms) GetCollaborationPrivacyBudgetTemplateWithContext(ctx aws.Context, input *GetCollaborationPrivacyBudgetTemplateInput, opts ...request.Option) (*GetCollaborationPrivacyBudgetTemplateOutput, error) {
	req, out := c.GetCollaborationPrivacyBudgetTemplateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetConfiguredAudienceModelAssociation = "GetConfiguredAudienceModelAssociation"

// GetConfiguredAudienceModelAssociationRequest generates a "aws/request.Request" representing the
// client's request for the GetConfiguredAudienceModelAssociation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetConfiguredAudienceModelAssociation for more information on using the GetConfiguredAudienceModelAssociation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetConfiguredAudienceModelAssociationRequest method.
//	req, resp := client.GetConfiguredAudienceModelAssociationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/GetConfiguredAudienceModelAssociation
func (c *CleanRooms) GetConfiguredAudienceModelAssociationRequest(input *GetConfiguredAudienceModelAssociationInput) (req *request.Request, output *GetConfiguredAudienceModelAssociationOutput) {
	op := &request.Operation{
		Name:       opGetConfiguredAudienceModelAssociation,
		HTTPMethod: "GET",
		HTTPPath:   "/memberships/{membershipIdentifier}/configuredaudiencemodelassociations/{configuredAudienceModelAssociationIdentifier}",
	}

	if input == nil {
		input = &GetConfiguredAudienceModelAssociationInput{}
	}

	output = &GetConfiguredAudienceModelAssociationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetConfiguredAudienceModelAssociation API operation for AWS Clean Rooms Service.
//
// Returns information about a configured audience model association.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Clean Rooms Service's
// API operation GetConfiguredAudienceModelAssociation for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     Request references a resource which does not exist.
//
//   - InternalServerException
//     Unexpected error during processing of request.
//
//   - ValidationException
//     The input fails to satisfy the specified constraints.
//
//   - ThrottlingException
//     Request was denied due to request throttling.
//
//   - AccessDeniedException
//     Caller does not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/GetConfiguredAudienceModelAssociation
func (c *CleanRooms) GetConfiguredAudienceModelAssociation(input *GetConfiguredAudienceModelAssociationInput) (*GetConfiguredAudienceModelAssociationOutput, error) {
	req, out := c.GetConfiguredAudienceModelAssociationRequest(input)
	return out, req.Send()
}

// GetConfiguredAudienceModelAssociationWithContext is the same as GetConfiguredAudienceModelAssociation with the addition of
// the ability to pass a context and additional request options.
//
// See GetConfiguredAudienceModelAssociation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CleanRooms) GetConfiguredAudienceModelAssociationWithContext(ctx aws.Context, input *GetConfiguredAudienceModelAssociationInput, opts ...request.Option) (*GetConfiguredAudienceModelAssociationOutput, error) {
	req, out := c.GetConfiguredAudienceModelAssociationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetConfiguredTable = "GetConfiguredTable"

// GetConfiguredTableRequest generates a "aws/request.Request" representing the
// client's request for the GetConfiguredTable operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetConfiguredTable for more information on using the GetConfiguredTable
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetConfiguredTableRequest method.
//	req, resp := client.GetConfiguredTableRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/GetConfiguredTable
func (c *CleanRooms) GetConfiguredTableRequest(input *GetConfiguredTableInput) (req *request.Request, output *GetConfiguredTableOutput) {
	op := &request.Operation{
		Name:       opGetConfiguredTable,
		HTTPMethod: "GET",
		HTTPPath:   "/configuredTables/{configuredTableIdentifier}",
	}

	if input == nil {
		input = &GetConfiguredTableInput{}
	}

	output = &GetConfiguredTableOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetConfiguredTable API operation for AWS Clean Rooms Service.
//
// Retrieves a configured table.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Clean Rooms Service's
// API operation GetConfiguredTable for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     Request references a resource which does not exist.
//
//   - InternalServerException
//     Unexpected error during processing of request.
//
//   - ValidationException
//     The input fails to satisfy the specified constraints.
//
//   - ThrottlingException
//     Request was denied due to request throttling.
//
//   - AccessDeniedException
//     Caller does not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/GetConfiguredTable
func (c *CleanRooms) GetConfiguredTable(input *GetConfiguredTableInput) (*GetConfiguredTableOutput, error) {
	req, out := c.GetConfiguredTableRequest(input)
	return out, req.Send()
}

// GetConfiguredTableWithContext is the same as GetConfiguredTable with the addition of
// the ability to pass a context and additional request options.
//
// See GetConfiguredTable for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CleanRooms) GetConfiguredTableWithContext(ctx aws.Context, input *GetConfiguredTableInput, opts ...request.Option) (*GetConfiguredTableOutput, error) {
	req, out := c.GetConfiguredTableRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetConfiguredTableAnalysisRule = "GetConfiguredTableAnalysisRule"

// GetConfiguredTableAnalysisRuleRequest generates a "aws/request.Request" representing the
// client's request for the GetConfiguredTableAnalysisRule operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetConfiguredTableAnalysisRule for more information on using the GetConfiguredTableAnalysisRule
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetConfiguredTableAnalysisRuleRequest method.
//	req, resp := client.GetConfiguredTableAnalysisRuleRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/GetConfiguredTableAnalysisRule
func (c *CleanRooms) GetConfiguredTableAnalysisRuleRequest(input *GetConfiguredTableAnalysisRuleInput) (req *request.Request, output *GetConfiguredTableAnalysisRuleOutput) {
	op := &request.Operation{
		Name:       opGetConfiguredTableAnalysisRule,
		HTTPMethod: "GET",
		HTTPPath:   "/configuredTables/{configuredTableIdentifier}/analysisRule/{analysisRuleType}",
	}

	if input == nil {
		input = &GetConfiguredTableAnalysisRuleInput{}
	}

	output = &GetConfiguredTableAnalysisRuleOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetConfiguredTableAnalysisRule API operation for AWS Clean Rooms Service.
//
// Retrieves a configured table analysis rule.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Clean Rooms Service's
// API operation GetConfiguredTableAnalysisRule for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     Request references a resource which does not exist.
//
//   - InternalServerException
//     Unexpected error during processing of request.
//
//   - ValidationException
//     The input fails to satisfy the specified constraints.
//
//   - ThrottlingException
//     Request was denied due to request throttling.
//
//   - AccessDeniedException
//     Caller does not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/GetConfiguredTableAnalysisRule
func (c *CleanRooms) GetConfiguredTableAnalysisRule(input *GetConfiguredTableAnalysisRuleInput) (*GetConfiguredTableAnalysisRuleOutput, error) {
	req, out := c.GetConfiguredTableAnalysisRuleRequest(input)
	return out, req.Send()
}

// GetConfiguredTableAnalysisRuleWithContext is the same as GetConfiguredTableAnalysisRule with the addition of
// the ability to pass a context and additional request options.
//
// See GetConfiguredTableAnalysisRule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CleanRooms) GetConfiguredTableAnalysisRuleWithContext(ctx aws.Context, input *GetConfiguredTableAnalysisRuleInput, opts ...request.Option) (*GetConfiguredTableAnalysisRuleOutput, error) {
	req, out := c.GetConfiguredTableAnalysisRuleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetConfiguredTableAssociation = "GetConfiguredTableAssociation"

// GetConfiguredTableAssociationRequest generates a "aws/request.Request" representing the
// client's request for the GetConfiguredTableAssociation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetConfiguredTableAssociation for more information on using the GetConfiguredTableAssociation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetConfiguredTableAssociationRequest method.
//	req, resp := client.GetConfiguredTableAssociationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/GetConfiguredTableAssociation
func (c *CleanRooms) GetConfiguredTableAssociationRequest(input *GetConfiguredTableAssociationInput) (req *request.Request, output *GetConfiguredTableAssociationOutput) {
	op := &request.Operation{
		Name:       opGetConfiguredTableAssociation,
		HTTPMethod: "GET",
		HTTPPath:   "/memberships/{membershipIdentifier}/configuredTableAssociations/{configuredTableAssociationIdentifier}",
	}

	if input == nil {
		input = &GetConfiguredTableAssociationInput{}
	}

	output = &GetConfiguredTableAssociationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetConfiguredTableAssociation API operation for AWS Clean Rooms Service.
//
// Retrieves a configured table association.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Clean Rooms Service's
// API operation GetConfiguredTableAssociation for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     Request references a resource which does not exist.
//
//   - InternalServerException
//     Unexpected error during processing of request.
//
//   - ValidationException
//     The input fails to satisfy the specified constraints.
//
//   - ThrottlingException
//     Request was denied due to request throttling.
//
//   - AccessDeniedException
//     Caller does not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/GetConfiguredTableAssociation
func (c *CleanRooms) GetConfiguredTableAssociation(input *GetConfiguredTableAssociationInput) (*GetConfiguredTableAssociationOutput, error) {
	req, out := c.GetConfiguredTableAssociationRequest(input)
	return out, req.Send()
}

// GetConfiguredTableAssociationWithContext is the same as GetConfiguredTableAssociation with the addition of
// the ability to pass a context and additional request options.
//
// See GetConfiguredTableAssociation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CleanRooms) GetConfiguredTableAssociationWithContext(ctx aws.Context, input *GetConfiguredTableAssociationInput, opts ...request.Option) (*GetConfiguredTableAssociationOutput, error) {
	req, out := c.GetConfiguredTableAssociationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetIdMappingTable = "GetIdMappingTable"

// GetIdMappingTableRequest generates a "aws/request.Request" representing the
// client's request for the GetIdMappingTable operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetIdMappingTable for more information on using the GetIdMappingTable
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetIdMappingTableRequest method.
//	req, resp := client.GetIdMappingTableRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/GetIdMappingTable
func (c *CleanRooms) GetIdMappingTableRequest(input *GetIdMappingTableInput) (req *request.Request, output *GetIdMappingTableOutput) {
	op := &request.Operation{
		Name:       opGetIdMappingTable,
		HTTPMethod: "GET",
		HTTPPath:   "/memberships/{membershipIdentifier}/idmappingtables/{idMappingTableIdentifier}",
	}

	if input == nil {
		input = &GetIdMappingTableInput{}
	}

	output = &GetIdMappingTableOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetIdMappingTable API operation for AWS Clean Rooms Service.
//
// Retrieves an ID mapping table.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Clean Rooms Service's
// API operation GetIdMappingTable for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     Request references a resource which does not exist.
//
//   - InternalServerException
//     Unexpected error during processing of request.
//
//   - ValidationException
//     The input fails to satisfy the specified constraints.
//
//   - ThrottlingException
//     Request was denied due to request throttling.
//
//   - AccessDeniedException
//     Caller does not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/GetIdMappingTable
func (c *CleanRooms) GetIdMappingTable(input *GetIdMappingTableInput) (*GetIdMappingTableOutput, error) {
	req, out := c.GetIdMappingTableRequest(input)
	return out, req.Send()
}

// GetIdMappingTableWithContext is the same as GetIdMappingTable with the addition of
// the ability to pass a context and additional request options.
//
// See GetIdMappingTable for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CleanRooms) GetIdMappingTableWithContext(ctx aws.Context, input *GetIdMappingTableInput, opts ...request.Option) (*GetIdMappingTableOutput, error) {
	req, out := c.GetIdMappingTableRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetMembership = "GetMembership"

// GetMembershipRequest generates a "aws/request.Request" representing the
// client's request for the GetMembership operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetMembership for more information on using the GetMembership
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetMembershipRequest method.
//	req, resp := client.GetMembershipRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/GetMembership
func (c *CleanRooms) GetMembershipRequest(input *GetMembershipInput) (req *request.Request, output *GetMembershipOutput) {
	op := &request.Operation{
		Name:       opGetMembership,
		HTTPMethod: "GET",
		HTTPPath:   "/memberships/{membershipIdentifier}",
	}

	if input == nil {
		input = &GetMembershipInput{}
	}

	output = &GetMembershipOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetMembership API operation for AWS Clean Rooms Service.
//
// Retrieves a specified membership for an identifier.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Clean Rooms Service's
// API operation GetMembership for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     Request references a resource which does not exist.
//
//   - InternalServerException
//     Unexpected error during processing of request.
//
//   - ValidationException
//     The input fails to satisfy the specified constraints.
//
//   - ThrottlingException
//     Request was denied due to request throttling.
//
//   - AccessDeniedException
//     Caller does not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/GetMembership
func (c *CleanRooms) GetMembership(input *GetMembershipInput) (*GetMembershipOutput, error) {
	req, out := c.GetMembershipRequest(input)
	return out, req.Send()
}

// GetMembershipWithContext is the same as GetMembership with the addition of
// the ability to pass a context and additional request options.
//
// See GetMembership for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CleanRooms) GetMembershipWithContext(ctx aws.Context, input *GetMembershipInput, opts ...request.Option) (*GetMembershipOutput, error) {
	req, out := c.GetMembershipRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetPrivacyBudgetTemplate = "GetPrivacyBudgetTemplate"

// GetPrivacyBudgetTemplateRequest generates a "aws/request.Request" representing the
// client's request for the GetPrivacyBudgetTemplate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetPrivacyBudgetTemplate for more information on using the GetPrivacyBudgetTemplate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetPrivacyBudgetTemplateRequest method.
//	req, resp := client.GetPrivacyBudgetTemplateRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/GetPrivacyBudgetTemplate
func (c *CleanRooms) GetPrivacyBudgetTemplateRequest(input *GetPrivacyBudgetTemplateInput) (req *request.Request, output *GetPrivacyBudgetTemplateOutput) {
	op := &request.Operation{
		Name:       opGetPrivacyBudgetTemplate,
		HTTPMethod: "GET",
		HTTPPath:   "/memberships/{membershipIdentifier}/privacybudgettemplates/{privacyBudgetTemplateIdentifier}",
	}

	if input == nil {
		input = &GetPrivacyBudgetTemplateInput{}
	}

	output = &GetPrivacyBudgetTemplateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetPrivacyBudgetTemplate API operation for AWS Clean Rooms Service.
//
// Returns details for a specified privacy budget template.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Clean Rooms Service's
// API operation GetPrivacyBudgetTemplate for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     Request references a resource which does not exist.
//
//   - InternalServerException
//     Unexpected error during processing of request.
//
//   - ValidationException
//     The input fails to satisfy the specified constraints.
//
//   - ThrottlingException
//     Request was denied due to request throttling.
//
//   - AccessDeniedException
//     Caller does not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/GetPrivacyBudgetTemplate
func (c *CleanRooms) GetPrivacyBudgetTemplate(input *GetPrivacyBudgetTemplateInput) (*GetPrivacyBudgetTemplateOutput, error) {
	req, out := c.GetPrivacyBudgetTemplateRequest(input)
	return out, req.Send()
}

// GetPrivacyBudgetTemplateWithContext is the same as GetPrivacyBudgetTemplate with the addition of
// the ability to pass a context and additional request options.
//
// See GetPrivacyBudgetTemplate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CleanRooms) GetPrivacyBudgetTemplateWithContext(ctx aws.Context, input *GetPrivacyBudgetTemplateInput, opts ...request.Option) (*GetPrivacyBudgetTemplateOutput, error) {
	req, out := c.GetPrivacyBudgetTemplateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetProtectedQuery = "GetProtectedQuery"

// GetProtectedQueryRequest generates a "aws/request.Request" representing the
// client's request for the GetProtectedQuery operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetProtectedQuery for more information on using the GetProtectedQuery
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetProtectedQueryRequest method.
//	req, resp := client.GetProtectedQueryRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/GetProtectedQuery
func (c *CleanRooms) GetProtectedQueryRequest(input *GetProtectedQueryInput) (req *request.Request, output *GetProtectedQueryOutput) {
	op := &request.Operation{
		Name:       opGetProtectedQuery,
		HTTPMethod: "GET",
		HTTPPath:   "/memberships/{membershipIdentifier}/protectedQueries/{protectedQueryIdentifier}",
	}

	if input == nil {
		input = &GetProtectedQueryInput{}
	}

	output = &GetProtectedQueryOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetProtectedQuery API operation for AWS Clean Rooms Service.
//
// Returns query processing metadata.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Clean Rooms Service's
// API operation GetProtectedQuery for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     Request references a resource which does not exist.
//
//   - InternalServerException
//     Unexpected error during processing of request.
//
//   - ValidationException
//     The input fails to satisfy the specified constraints.
//
//   - ThrottlingException
//     Request was denied due to request throttling.
//
//   - AccessDeniedException
//     Caller does not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/GetProtectedQuery
func (c *CleanRooms) GetProtectedQuery(input *GetProtectedQueryInput) (*GetProtectedQueryOutput, error) {
	req, out := c.GetProtectedQueryRequest(input)
	return out, req.Send()
}

// GetProtectedQueryWithContext is the same as GetProtectedQuery with the addition of
// the ability to pass a context and additional request options.
//
// See GetProtectedQuery for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CleanRooms) GetProtectedQueryWithContext(ctx aws.Context, input *GetProtectedQueryInput, opts ...request.Option) (*GetProtectedQueryOutput, error) {
	req, out := c.GetProtectedQueryRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetSchema = "GetSchema"

// GetSchemaRequest generates a "aws/request.Request" representing the
// client's request for the GetSchema operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetSchema for more information on using the GetSchema
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetSchemaRequest method.
//	req, resp := client.GetSchemaRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/GetSchema
func (c *CleanRooms) GetSchemaRequest(input *GetSchemaInput) (req *request.Request, output *GetSchemaOutput) {
	op := &request.Operation{
		Name:       opGetSchema,
		HTTPMethod: "GET",
		HTTPPath:   "/collaborations/{collaborationIdentifier}/schemas/{name}",
	}

	if input == nil {
		input = &GetSchemaInput{}
	}

	output = &GetSchemaOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetSchema API operation for AWS Clean Rooms Service.
//
// Retrieves the schema for a relation within a collaboration.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Clean Rooms Service's
// API operation GetSchema for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     Request references a resource which does not exist.
//
//   - InternalServerException
//     Unexpected error during processing of request.
//
//   - ValidationException
//     The input fails to satisfy the specified constraints.
//
//   - ThrottlingException
//     Request was denied due to request throttling.
//
//   - AccessDeniedException
//     Caller does not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/GetSchema
func (c *CleanRooms) GetSchema(input *GetSchemaInput) (*GetSchemaOutput, error) {
	req, out := c.GetSchemaRequest(input)
	return out, req.Send()
}

// GetSchemaWithContext is the same as GetSchema with the addition of
// the ability to pass a context and additional request options.
//
// See GetSchema for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CleanRooms) GetSchemaWithContext(ctx aws.Context, input *GetSchemaInput, opts ...request.Option) (*GetSchemaOutput, error) {
	req, out := c.GetSchemaRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetSchemaAnalysisRule = "GetSchemaAnalysisRule"

// GetSchemaAnalysisRuleRequest generates a "aws/request.Request" representing the
// client's request for the GetSchemaAnalysisRule operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetSchemaAnalysisRule for more information on using the GetSchemaAnalysisRule
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetSchemaAnalysisRuleRequest method.
//	req, resp := client.GetSchemaAnalysisRuleRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/GetSchemaAnalysisRule
func (c *CleanRooms) GetSchemaAnalysisRuleRequest(input *GetSchemaAnalysisRuleInput) (req *request.Request, output *GetSchemaAnalysisRuleOutput) {
	op := &request.Operation{
		Name:       opGetSchemaAnalysisRule,
		HTTPMethod: "GET",
		HTTPPath:   "/collaborations/{collaborationIdentifier}/schemas/{name}/analysisRule/{type}",
	}

	if input == nil {
		input = &GetSchemaAnalysisRuleInput{}
	}

	output = &GetSchemaAnalysisRuleOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetSchemaAnalysisRule API operation for AWS Clean Rooms Service.
//
// Retrieves a schema analysis rule.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Clean Rooms Service's
// API operation GetSchemaAnalysisRule for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     Request references a resource which does not exist.
//
//   - InternalServerException
//     Unexpected error during processing of request.
//
//   - ValidationException
//     The input fails to satisfy the specified constraints.
//
//   - ThrottlingException
//     Request was denied due to request throttling.
//
//   - AccessDeniedException
//     Caller does not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/GetSchemaAnalysisRule
func (c *CleanRooms) GetSchemaAnalysisRule(input *GetSchemaAnalysisRuleInput) (*GetSchemaAnalysisRuleOutput, error) {
	req, out := c.GetSchemaAnalysisRuleRequest(input)
	return out, req.Send()
}

// GetSchemaAnalysisRuleWithContext is the same as GetSchemaAnalysisRule with the addition of
// the ability to pass a context and additional request options.
//
// See GetSchemaAnalysisRule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CleanRooms) GetSchemaAnalysisRuleWithContext(ctx aws.Context, input *GetSchemaAnalysisRuleInput, opts ...request.Option) (*GetSchemaAnalysisRuleOutput, error) {
	req, out := c.GetSchemaAnalysisRuleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListAnalysisTemplates = "ListAnalysisTemplates"

// ListAnalysisTemplatesRequest generates a "aws/request.Request" representing the
// client's request for the ListAnalysisTemplates operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListAnalysisTemplates for more information on using the ListAnalysisTemplates
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListAnalysisTemplatesRequest method.
//	req, resp := client.ListAnalysisTemplatesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/ListAnalysisTemplates
func (c *CleanRooms) ListAnalysisTemplatesRequest(input *ListAnalysisTemplatesInput) (req *request.Request, output *ListAnalysisTemplatesOutput) {
	op := &request.Operation{
		Name:       opListAnalysisTemplates,
		HTTPMethod: "GET",
		HTTPPath:   "/memberships/{membershipIdentifier}/analysistemplates",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListAnalysisTemplatesInput{}
	}

	output = &ListAnalysisTemplatesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListAnalysisTemplates API operation for AWS Clean Rooms Service.
//
// Lists analysis templates that the caller owns.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Clean Rooms Service's
// API operation ListAnalysisTemplates for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     Request references a resource which does not exist.
//
//   - InternalServerException
//     Unexpected error during processing of request.
//
//   - ValidationException
//     The input fails to satisfy the specified constraints.
//
//   - ThrottlingException
//     Request was denied due to request throttling.
//
//   - AccessDeniedException
//     Caller does not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/ListAnalysisTemplates
func (c *CleanRooms) ListAnalysisTemplates(input *ListAnalysisTemplatesInput) (*ListAnalysisTemplatesOutput, error) {
	req, out := c.ListAnalysisTemplatesRequest(input)
	return out, req.Send()
}

// ListAnalysisTemplatesWithContext is the same as ListAnalysisTemplates with the addition of
// the ability to pass a context and additional request options.
//
// See ListAnalysisTemplates for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CleanRooms) ListAnalysisTemplatesWithContext(ctx aws.Context, input *ListAnalysisTemplatesInput, opts ...request.Option) (*ListAnalysisTemplatesOutput, error) {
	req, out := c.ListAnalysisTemplatesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListAnalysisTemplatesPages iterates over the pages of a ListAnalysisTemplates operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListAnalysisTemplates method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListAnalysisTemplates operation.
//	pageNum := 0
//	err := client.ListAnalysisTemplatesPages(params,
//	    func(page *cleanrooms.ListAnalysisTemplatesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *CleanRooms) ListAnalysisTemplatesPages(input *ListAnalysisTemplatesInput, fn func(*ListAnalysisTemplatesOutput, bool) bool) error {
	return c.ListAnalysisTemplatesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListAnalysisTemplatesPagesWithContext same as ListAnalysisTemplatesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CleanRooms) ListAnalysisTemplatesPagesWithContext(ctx aws.Context, input *ListAnalysisTemplatesInput, fn func(*ListAnalysisTemplatesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListAnalysisTemplatesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListAnalysisTemplatesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListAnalysisTemplatesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListCollaborationAnalysisTemplates = "ListCollaborationAnalysisTemplates"

// ListCollaborationAnalysisTemplatesRequest generates a "aws/request.Request" representing the
// client's request for the ListCollaborationAnalysisTemplates operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListCollaborationAnalysisTemplates for more information on using the ListCollaborationAnalysisTemplates
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListCollaborationAnalysisTemplatesRequest method.
//	req, resp := client.ListCollaborationAnalysisTemplatesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/ListCollaborationAnalysisTemplates
func (c *CleanRooms) ListCollaborationAnalysisTemplatesRequest(input *ListCollaborationAnalysisTemplatesInput) (req *request.Request, output *ListCollaborationAnalysisTemplatesOutput) {
	op := &request.Operation{
		Name:       opListCollaborationAnalysisTemplates,
		HTTPMethod: "GET",
		HTTPPath:   "/collaborations/{collaborationIdentifier}/analysistemplates",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListCollaborationAnalysisTemplatesInput{}
	}

	output = &ListCollaborationAnalysisTemplatesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListCollaborationAnalysisTemplates API operation for AWS Clean Rooms Service.
//
// Lists analysis templates within a collaboration.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Clean Rooms Service's
// API operation ListCollaborationAnalysisTemplates for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     Request references a resource which does not exist.
//
//   - InternalServerException
//     Unexpected error during processing of request.
//
//   - ValidationException
//     The input fails to satisfy the specified constraints.
//
//   - ThrottlingException
//     Request was denied due to request throttling.
//
//   - AccessDeniedException
//     Caller does not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/ListCollaborationAnalysisTemplates
func (c *CleanRooms) ListCollaborationAnalysisTemplates(input *ListCollaborationAnalysisTemplatesInput) (*ListCollaborationAnalysisTemplatesOutput, error) {
	req, out := c.ListCollaborationAnalysisTemplatesRequest(input)
	return out, req.Send()
}

// ListCollaborationAnalysisTemplatesWithContext is the same as ListCollaborationAnalysisTemplates with the addition of
// the ability to pass a context and additional request options.
//
// See ListCollaborationAnalysisTemplates for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CleanRooms) ListCollaborationAnalysisTemplatesWithContext(ctx aws.Context, input *ListCollaborationAnalysisTemplatesInput, opts ...request.Option) (*ListCollaborationAnalysisTemplatesOutput, error) {
	req, out := c.ListCollaborationAnalysisTemplatesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListCollaborationAnalysisTemplatesPages iterates over the pages of a ListCollaborationAnalysisTemplates operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListCollaborationAnalysisTemplates method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListCollaborationAnalysisTemplates operation.
//	pageNum := 0
//	err := client.ListCollaborationAnalysisTemplatesPages(params,
//	    func(page *cleanrooms.ListCollaborationAnalysisTemplatesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *CleanRooms) ListCollaborationAnalysisTemplatesPages(input *ListCollaborationAnalysisTemplatesInput, fn func(*ListCollaborationAnalysisTemplatesOutput, bool) bool) error {
	return c.ListCollaborationAnalysisTemplatesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListCollaborationAnalysisTemplatesPagesWithContext same as ListCollaborationAnalysisTemplatesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CleanRooms) ListCollaborationAnalysisTemplatesPagesWithContext(ctx aws.Context, input *ListCollaborationAnalysisTemplatesInput, fn func(*ListCollaborationAnalysisTemplatesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListCollaborationAnalysisTemplatesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListCollaborationAnalysisTemplatesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListCollaborationAnalysisTemplatesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListCollaborationConfiguredAudienceModelAssociations = "ListCollaborationConfiguredAudienceModelAssociations"

// ListCollaborationConfiguredAudienceModelAssociationsRequest generates a "aws/request.Request" representing the
// client's request for the ListCollaborationConfiguredAudienceModelAssociations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListCollaborationConfiguredAudienceModelAssociations for more information on using the ListCollaborationConfiguredAudienceModelAssociations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListCollaborationConfiguredAudienceModelAssociationsRequest method.
//	req, resp := client.ListCollaborationConfiguredAudienceModelAssociationsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/ListCollaborationConfiguredAudienceModelAssociations
func (c *CleanRooms) ListCollaborationConfiguredAudienceModelAssociationsRequest(input *ListCollaborationConfiguredAudienceModelAssociationsInput) (req *request.Request, output *ListCollaborationConfiguredAudienceModelAssociationsOutput) {
	op := &request.Operation{
		Name:       opListCollaborationConfiguredAudienceModelAssociations,
		HTTPMethod: "GET",
		HTTPPath:   "/collaborations/{collaborationIdentifier}/configuredaudiencemodelassociations",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListCollaborationConfiguredAudienceModelAssociationsInput{}
	}

	output = &ListCollaborationConfiguredAudienceModelAssociationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListCollaborationConfiguredAudienceModelAssociations API operation for AWS Clean Rooms Service.
//
// Lists configured audience model associations within a collaboration.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Clean Rooms Service's
// API operation ListCollaborationConfiguredAudienceModelAssociations for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     Request references a resource which does not exist.
//
//   - InternalServerException
//     Unexpected error during processing of request.
//
//   - ValidationException
//     The input fails to satisfy the specified constraints.
//
//   - ThrottlingException
//     Request was denied due to request throttling.
//
//   - AccessDeniedException
//     Caller does not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/ListCollaborationConfiguredAudienceModelAssociations
func (c *CleanRooms) ListCollaborationConfiguredAudienceModelAssociations(input *ListCollaborationConfiguredAudienceModelAssociationsInput) (*ListCollaborationConfiguredAudienceModelAssociationsOutput, error) {
	req, out := c.ListCollaborationConfiguredAudienceModelAssociationsRequest(input)
	return out, req.Send()
}

// ListCollaborationConfiguredAudienceModelAssociationsWithContext is the same as ListCollaborationConfiguredAudienceModelAssociations with the addition of
// the ability to pass a context and additional request options.
//
// See ListCollaborationConfiguredAudienceModelAssociations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CleanRooms) ListCollaborationConfiguredAudienceModelAssociationsWithContext(ctx aws.Context, input *ListCollaborationConfiguredAudienceModelAssociationsInput, opts ...request.Option) (*ListCollaborationConfiguredAudienceModelAssociationsOutput, error) {
	req, out := c.ListCollaborationConfiguredAudienceModelAssociationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListCollaborationConfiguredAudienceModelAssociationsPages iterates over the pages of a ListCollaborationConfiguredAudienceModelAssociations operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListCollaborationConfiguredAudienceModelAssociations method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListCollaborationConfiguredAudienceModelAssociations operation.
//	pageNum := 0
//	err := client.ListCollaborationConfiguredAudienceModelAssociationsPages(params,
//	    func(page *cleanrooms.ListCollaborationConfiguredAudienceModelAssociationsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *CleanRooms) ListCollaborationConfiguredAudienceModelAssociationsPages(input *ListCollaborationConfiguredAudienceModelAssociationsInput, fn func(*ListCollaborationConfiguredAudienceModelAssociationsOutput, bool) bool) error {
	return c.ListCollaborationConfiguredAudienceModelAssociationsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListCollaborationConfiguredAudienceModelAssociationsPagesWithContext same as ListCollaborationConfiguredAudienceModelAssociationsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CleanRooms) ListCollaborationConfiguredAudienceModelAssociationsPagesWithContext(ctx aws.Context, input *ListCollaborationConfiguredAudienceModelAssociationsInput, fn func(*ListCollaborationConfiguredAudienceModelAssociationsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListCollaborationConfiguredAudienceModelAssociationsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListCollaborationConfiguredAudienceModelAssociationsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListCollaborationConfiguredAudienceModelAssociationsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListCollaborationIdNamespaceAssociations = "ListCollaborationIdNamespaceAssociations"

// ListCollaborationIdNamespaceAssociationsRequest generates a "aws/request.Request" representing the
// client's request for the ListCollaborationIdNamespaceAssociations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListCollaborationIdNamespaceAssociations for more information on using the ListCollaborationIdNamespaceAssociations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListCollaborationIdNamespaceAssociationsRequest method.
//	req, resp := client.ListCollaborationIdNamespaceAssociationsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/ListCollaborationIdNamespaceAssociations
func (c *CleanRooms) ListCollaborationIdNamespaceAssociationsRequest(input *ListCollaborationIdNamespaceAssociationsInput) (req *request.Request, output *ListCollaborationIdNamespaceAssociationsOutput) {
	op := &request.Operation{
		Name:       opListCollaborationIdNamespaceAssociations,
		HTTPMethod: "GET",
		HTTPPath:   "/collaborations/{collaborationIdentifier}/idnamespaceassociations",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListCollaborationIdNamespaceAssociationsInput{}
	}

	output = &ListCollaborationIdNamespaceAssociationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListCollaborationIdNamespaceAssociations API operation for AWS Clean Rooms Service.
//
// Returns a list of the ID namespace associations in a collaboration.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Clean Rooms Service's
// API operation ListCollaborationIdNamespaceAssociations for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     Request references a resource which does not exist.
//
//   - InternalServerException
//     Unexpected error during processing of request.
//
//   - ValidationException
//     The input fails to satisfy the specified constraints.
//
//   - ThrottlingException
//     Request was denied due to request throttling.
//
//   - AccessDeniedException
//     Caller does not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/ListCollaborationIdNamespaceAssociations
func (c *CleanRooms) ListCollaborationIdNamespaceAssociations(input *ListCollaborationIdNamespaceAssociationsInput) (*ListCollaborationIdNamespaceAssociationsOutput, error) {
	req, out := c.ListCollaborationIdNamespaceAssociationsRequest(input)
	return out, req.Send()
}

// ListCollaborationIdNamespaceAssociationsWithContext is the same as ListCollaborationIdNamespaceAssociations with the addition of
// the ability to pass a context and additional request options.
//
// See ListCollaborationIdNamespaceAssociations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CleanRooms) ListCollaborationIdNamespaceAssociationsWithContext(ctx aws.Context, input *ListCollaborationIdNamespaceAssociationsInput, opts ...request.Option) (*ListCollaborationIdNamespaceAssociationsOutput, error) {
	req, out := c.ListCollaborationIdNamespaceAssociationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListCollaborationIdNamespaceAssociationsPages iterates over the pages of a ListCollaborationIdNamespaceAssociations operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListCollaborationIdNamespaceAssociations method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListCollaborationIdNamespaceAssociations operation.
//	pageNum := 0
//	err := client.ListCollaborationIdNamespaceAssociationsPages(params,
//	    func(page *cleanrooms.ListCollaborationIdNamespaceAssociationsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *CleanRooms) ListCollaborationIdNamespaceAssociationsPages(input *ListCollaborationIdNamespaceAssociationsInput, fn func(*ListCollaborationIdNamespaceAssociationsOutput, bool) bool) error {
	return c.ListCollaborationIdNamespaceAssociationsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListCollaborationIdNamespaceAssociationsPagesWithContext same as ListCollaborationIdNamespaceAssociationsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CleanRooms) ListCollaborationIdNamespaceAssociationsPagesWithContext(ctx aws.Context, input *ListCollaborationIdNamespaceAssociationsInput, fn func(*ListCollaborationIdNamespaceAssociationsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListCollaborationIdNamespaceAssociationsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListCollaborationIdNamespaceAssociationsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListCollaborationIdNamespaceAssociationsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListCollaborationPrivacyBudgetTemplates = "ListCollaborationPrivacyBudgetTemplates"

// ListCollaborationPrivacyBudgetTemplatesRequest generates a "aws/request.Request" representing the
// client's request for the ListCollaborationPrivacyBudgetTemplates operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListCollaborationPrivacyBudgetTemplates for more information on using the ListCollaborationPrivacyBudgetTemplates
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListCollaborationPrivacyBudgetTemplatesRequest method.
//	req, resp := client.ListCollaborationPrivacyBudgetTemplatesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/ListCollaborationPrivacyBudgetTemplates
func (c *CleanRooms) ListCollaborationPrivacyBudgetTemplatesRequest(input *ListCollaborationPrivacyBudgetTemplatesInput) (req *request.Request, output *ListCollaborationPrivacyBudgetTemplatesOutput) {
	op := &request.Operation{
		Name:       opListCollaborationPrivacyBudgetTemplates,
		HTTPMethod: "GET",
		HTTPPath:   "/collaborations/{collaborationIdentifier}/privacybudgettemplates",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListCollaborationPrivacyBudgetTemplatesInput{}
	}

	output = &ListCollaborationPrivacyBudgetTemplatesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListCollaborationPrivacyBudgetTemplates API operation for AWS Clean Rooms Service.
//
// Returns an array that summarizes each privacy budget template in a specified
// collaboration.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Clean Rooms Service's
// API operation ListCollaborationPrivacyBudgetTemplates for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     Request references a resource which does not exist.
//
//   - InternalServerException
//     Unexpected error during processing of request.
//
//   - ValidationException
//     The input fails to satisfy the specified constraints.
//
//   - ThrottlingException
//     Request was denied due to request throttling.
//
//   - AccessDeniedException
//     Caller does not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/ListCollaborationPrivacyBudgetTemplates
func (c *CleanRooms) ListCollaborationPrivacyBudgetTemplates(input *ListCollaborationPrivacyBudgetTemplatesInput) (*ListCollaborationPrivacyBudgetTemplatesOutput, error) {
	req, out := c.ListCollaborationPrivacyBudgetTemplatesRequest(input)
	return out, req.Send()
}

// ListCollaborationPrivacyBudgetTemplatesWithContext is the same as ListCollaborationPrivacyBudgetTemplates with the addition of
// the ability to pass a context and additional request options.
//
// See ListCollaborationPrivacyBudgetTemplates for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CleanRooms) ListCollaborationPrivacyBudgetTemplatesWithContext(ctx aws.Context, input *ListCollaborationPrivacyBudgetTemplatesInput, opts ...request.Option) (*ListCollaborationPrivacyBudgetTemplatesOutput, error) {
	req, out := c.ListCollaborationPrivacyBudgetTemplatesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListCollaborationPrivacyBudgetTemplatesPages iterates over the pages of a ListCollaborationPrivacyBudgetTemplates operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListCollaborationPrivacyBudgetTemplates method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListCollaborationPrivacyBudgetTemplates operation.
//	pageNum := 0
//	err := client.ListCollaborationPrivacyBudgetTemplatesPages(params,
//	    func(page *cleanrooms.ListCollaborationPrivacyBudgetTemplatesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *CleanRooms) ListCollaborationPrivacyBudgetTemplatesPages(input *ListCollaborationPrivacyBudgetTemplatesInput, fn func(*ListCollaborationPrivacyBudgetTemplatesOutput, bool) bool) error {
	return c.ListCollaborationPrivacyBudgetTemplatesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListCollaborationPrivacyBudgetTemplatesPagesWithContext same as ListCollaborationPrivacyBudgetTemplatesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CleanRooms) ListCollaborationPrivacyBudgetTemplatesPagesWithContext(ctx aws.Context, input *ListCollaborationPrivacyBudgetTemplatesInput, fn func(*ListCollaborationPrivacyBudgetTemplatesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListCollaborationPrivacyBudgetTemplatesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListCollaborationPrivacyBudgetTemplatesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListCollaborationPrivacyBudgetTemplatesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListCollaborationPrivacyBudgets = "ListCollaborationPrivacyBudgets"

// ListCollaborationPrivacyBudgetsRequest generates a "aws/request.Request" representing the
// client's request for the ListCollaborationPrivacyBudgets operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListCollaborationPrivacyBudgets for more information on using the ListCollaborationPrivacyBudgets
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListCollaborationPrivacyBudgetsRequest method.
//	req, resp := client.ListCollaborationPrivacyBudgetsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/ListCollaborationPrivacyBudgets
func (c *CleanRooms) ListCollaborationPrivacyBudgetsRequest(input *ListCollaborationPrivacyBudgetsInput) (req *request.Request, output *ListCollaborationPrivacyBudgetsOutput) {
	op := &request.Operation{
		Name:       opListCollaborationPrivacyBudgets,
		HTTPMethod: "GET",
		HTTPPath:   "/collaborations/{collaborationIdentifier}/privacybudgets",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListCollaborationPrivacyBudgetsInput{}
	}

	output = &ListCollaborationPrivacyBudgetsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListCollaborationPrivacyBudgets API operation for AWS Clean Rooms Service.
//
// Returns an array that summarizes each privacy budget in a specified collaboration.
// The summary includes the collaboration ARN, creation time, creating account,
// and privacy budget details.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Clean Rooms Service's
// API operation ListCollaborationPrivacyBudgets for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     Request references a resource which does not exist.
//
//   - InternalServerException
//     Unexpected error during processing of request.
//
//   - ValidationException
//     The input fails to satisfy the specified constraints.
//
//   - ThrottlingException
//     Request was denied due to request throttling.
//
//   - AccessDeniedException
//     Caller does not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/ListCollaborationPrivacyBudgets
func (c *CleanRooms) ListCollaborationPrivacyBudgets(input *ListCollaborationPrivacyBudgetsInput) (*ListCollaborationPrivacyBudgetsOutput, error) {
	req, out := c.ListCollaborationPrivacyBudgetsRequest(input)
	return out, req.Send()
}

// ListCollaborationPrivacyBudgetsWithContext is the same as ListCollaborationPrivacyBudgets with the addition of
// the ability to pass a context and additional request options.
//
// See ListCollaborationPrivacyBudgets for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CleanRooms) ListCollaborationPrivacyBudgetsWithContext(ctx aws.Context, input *ListCollaborationPrivacyBudgetsInput, opts ...request.Option) (*ListCollaborationPrivacyBudgetsOutput, error) {
	req, out := c.ListCollaborationPrivacyBudgetsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListCollaborationPrivacyBudgetsPages iterates over the pages of a ListCollaborationPrivacyBudgets operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListCollaborationPrivacyBudgets method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListCollaborationPrivacyBudgets operation.
//	pageNum := 0
//	err := client.ListCollaborationPrivacyBudgetsPages(params,
//	    func(page *cleanrooms.ListCollaborationPrivacyBudgetsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *CleanRooms) ListCollaborationPrivacyBudgetsPages(input *ListCollaborationPrivacyBudgetsInput, fn func(*ListCollaborationPrivacyBudgetsOutput, bool) bool) error {
	return c.ListCollaborationPrivacyBudgetsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListCollaborationPrivacyBudgetsPagesWithContext same as ListCollaborationPrivacyBudgetsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CleanRooms) ListCollaborationPrivacyBudgetsPagesWithContext(ctx aws.Context, input *ListCollaborationPrivacyBudgetsInput, fn func(*ListCollaborationPrivacyBudgetsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListCollaborationPrivacyBudgetsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListCollaborationPrivacyBudgetsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListCollaborationPrivacyBudgetsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListCollaborations = "ListCollaborations"

// ListCollaborationsRequest generates a "aws/request.Request" representing the
// client's request for the ListCollaborations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListCollaborations for more information on using the ListCollaborations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListCollaborationsRequest method.
//	req, resp := client.ListCollaborationsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/ListCollaborations
func (c *CleanRooms) ListCollaborationsRequest(input *ListCollaborationsInput) (req *request.Request, output *ListCollaborationsOutput) {
	op := &request.Operation{
		Name:       opListCollaborations,
		HTTPMethod: "GET",
		HTTPPath:   "/collaborations",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListCollaborationsInput{}
	}

	output = &ListCollaborationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListCollaborations API operation for AWS Clean Rooms Service.
//
// Lists collaborations the caller owns, is active in, or has been invited to.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Clean Rooms Service's
// API operation ListCollaborations for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     Unexpected error during processing of request.
//
//   - ValidationException
//     The input fails to satisfy the specified constraints.
//
//   - ThrottlingException
//     Request was denied due to request throttling.
//
//   - AccessDeniedException
//     Caller does not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/ListCollaborations
func (c *CleanRooms) ListCollaborations(input *ListCollaborationsInput) (*ListCollaborationsOutput, error) {
	req, out := c.ListCollaborationsRequest(input)
	return out, req.Send()
}

// ListCollaborationsWithContext is the same as ListCollaborations with the addition of
// the ability to pass a context and additional request options.
//
// See ListCollaborations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CleanRooms) ListCollaborationsWithContext(ctx aws.Context, input *ListCollaborationsInput, opts ...request.Option) (*ListCollaborationsOutput, error) {
	req, out := c.ListCollaborationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListCollaborationsPages iterates over the pages of a ListCollaborations operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListCollaborations method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListCollaborations operation.
//	pageNum := 0
//	err := client.ListCollaborationsPages(params,
//	    func(page *cleanrooms.ListCollaborationsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *CleanRooms) ListCollaborationsPages(input *ListCollaborationsInput, fn func(*ListCollaborationsOutput, bool) bool) error {
	return c.ListCollaborationsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListCollaborationsPagesWithContext same as ListCollaborationsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CleanRooms) ListCollaborationsPagesWithContext(ctx aws.Context, input *ListCollaborationsInput, fn func(*ListCollaborationsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListCollaborationsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListCollaborationsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListCollaborationsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListConfiguredAudienceModelAssociations = "ListConfiguredAudienceModelAssociations"

// ListConfiguredAudienceModelAssociationsRequest generates a "aws/request.Request" representing the
// client's request for the ListConfiguredAudienceModelAssociations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListConfiguredAudienceModelAssociations for more information on using the ListConfiguredAudienceModelAssociations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListConfiguredAudienceModelAssociationsRequest method.
//	req, resp := client.ListConfiguredAudienceModelAssociationsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/ListConfiguredAudienceModelAssociations
func (c *CleanRooms) ListConfiguredAudienceModelAssociationsRequest(input *ListConfiguredAudienceModelAssociationsInput) (req *request.Request, output *ListConfiguredAudienceModelAssociationsOutput) {
	op := &request.Operation{
		Name:       opListConfiguredAudienceModelAssociations,
		HTTPMethod: "GET",
		HTTPPath:   "/memberships/{membershipIdentifier}/configuredaudiencemodelassociations",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListConfiguredAudienceModelAssociationsInput{}
	}

	output = &ListConfiguredAudienceModelAssociationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListConfiguredAudienceModelAssociations API operation for AWS Clean Rooms Service.
//
// Lists information about requested configured audience model associations.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Clean Rooms Service's
// API operation ListConfiguredAudienceModelAssociations for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     Request references a resource which does not exist.
//
//   - InternalServerException
//     Unexpected error during processing of request.
//
//   - ValidationException
//     The input fails to satisfy the specified constraints.
//
//   - ThrottlingException
//     Request was denied due to request throttling.
//
//   - AccessDeniedException
//     Caller does not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/ListConfiguredAudienceModelAssociations
func (c *CleanRooms) ListConfiguredAudienceModelAssociations(input *ListConfiguredAudienceModelAssociationsInput) (*ListConfiguredAudienceModelAssociationsOutput, error) {
	req, out := c.ListConfiguredAudienceModelAssociationsRequest(input)
	return out, req.Send()
}

// ListConfiguredAudienceModelAssociationsWithContext is the same as ListConfiguredAudienceModelAssociations with the addition of
// the ability to pass a context and additional request options.
//
// See ListConfiguredAudienceModelAssociations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CleanRooms) ListConfiguredAudienceModelAssociationsWithContext(ctx aws.Context, input *ListConfiguredAudienceModelAssociationsInput, opts ...request.Option) (*ListConfiguredAudienceModelAssociationsOutput, error) {
	req, out := c.ListConfiguredAudienceModelAssociationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListConfiguredAudienceModelAssociationsPages iterates over the pages of a ListConfiguredAudienceModelAssociations operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListConfiguredAudienceModelAssociations method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListConfiguredAudienceModelAssociations operation.
//	pageNum := 0
//	err := client.ListConfiguredAudienceModelAssociationsPages(params,
//	    func(page *cleanrooms.ListConfiguredAudienceModelAssociationsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *CleanRooms) ListConfiguredAudienceModelAssociationsPages(input *ListConfiguredAudienceModelAssociationsInput, fn func(*ListConfiguredAudienceModelAssociationsOutput, bool) bool) error {
	return c.ListConfiguredAudienceModelAssociationsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListConfiguredAudienceModelAssociationsPagesWithContext same as ListConfiguredAudienceModelAssociationsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CleanRooms) ListConfiguredAudienceModelAssociationsPagesWithContext(ctx aws.Context, input *ListConfiguredAudienceModelAssociationsInput, fn func(*ListConfiguredAudienceModelAssociationsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListConfiguredAudienceModelAssociationsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListConfiguredAudienceModelAssociationsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListConfiguredAudienceModelAssociationsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListConfiguredTableAssociations = "ListConfiguredTableAssociations"

// ListConfiguredTableAssociationsRequest generates a "aws/request.Request" representing the
// client's request for the ListConfiguredTableAssociations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListConfiguredTableAssociations for more information on using the ListConfiguredTableAssociations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListConfiguredTableAssociationsRequest method.
//	req, resp := client.ListConfiguredTableAssociationsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/ListConfiguredTableAssociations
func (c *CleanRooms) ListConfiguredTableAssociationsRequest(input *ListConfiguredTableAssociationsInput) (req *request.Request, output *ListConfiguredTableAssociationsOutput) {
	op := &request.Operation{
		Name:       opListConfiguredTableAssociations,
		HTTPMethod: "GET",
		HTTPPath:   "/memberships/{membershipIdentifier}/configuredTableAssociations",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListConfiguredTableAssociationsInput{}
	}

	output = &ListConfiguredTableAssociationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListConfiguredTableAssociations API operation for AWS Clean Rooms Service.
//
// Lists configured table associations for a membership.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Clean Rooms Service's
// API operation ListConfiguredTableAssociations for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     Request references a resource which does not exist.
//
//   - InternalServerException
//     Unexpected error during processing of request.
//
//   - ValidationException
//     The input fails to satisfy the specified constraints.
//
//   - ThrottlingException
//     Request was denied due to request throttling.
//
//   - AccessDeniedException
//     Caller does not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/ListConfiguredTableAssociations
func (c *CleanRooms) ListConfiguredTableAssociations(input *ListConfiguredTableAssociationsInput) (*ListConfiguredTableAssociationsOutput, error) {
	req, out := c.ListConfiguredTableAssociationsRequest(input)
	return out, req.Send()
}

// ListConfiguredTableAssociationsWithContext is the same as ListConfiguredTableAssociations with the addition of
// the ability to pass a context and additional request options.
//
// See ListConfiguredTableAssociations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CleanRooms) ListConfiguredTableAssociationsWithContext(ctx aws.Context, input *ListConfiguredTableAssociationsInput, opts ...request.Option) (*ListConfiguredTableAssociationsOutput, error) {
	req, out := c.ListConfiguredTableAssociationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListConfiguredTableAssociationsPages iterates over the pages of a ListConfiguredTableAssociations operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListConfiguredTableAssociations method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListConfiguredTableAssociations operation.
//	pageNum := 0
//	err := client.ListConfiguredTableAssociationsPages(params,
//	    func(page *cleanrooms.ListConfiguredTableAssociationsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *CleanRooms) ListConfiguredTableAssociationsPages(input *ListConfiguredTableAssociationsInput, fn func(*ListConfiguredTableAssociationsOutput, bool) bool) error {
	return c.ListConfiguredTableAssociationsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListConfiguredTableAssociationsPagesWithContext same as ListConfiguredTableAssociationsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CleanRooms) ListConfiguredTableAssociationsPagesWithContext(ctx aws.Context, input *ListConfiguredTableAssociationsInput, fn func(*ListConfiguredTableAssociationsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListConfiguredTableAssociationsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListConfiguredTableAssociationsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListConfiguredTableAssociationsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListConfiguredTables = "ListConfiguredTables"

// ListConfiguredTablesRequest generates a "aws/request.Request" representing the
// client's request for the ListConfiguredTables operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListConfiguredTables for more information on using the ListConfiguredTables
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListConfiguredTablesRequest method.
//	req, resp := client.ListConfiguredTablesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/ListConfiguredTables
func (c *CleanRooms) ListConfiguredTablesRequest(input *ListConfiguredTablesInput) (req *request.Request, output *ListConfiguredTablesOutput) {
	op := &request.Operation{
		Name:       opListConfiguredTables,
		HTTPMethod: "GET",
		HTTPPath:   "/configuredTables",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListConfiguredTablesInput{}
	}

	output = &ListConfiguredTablesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListConfiguredTables API operation for AWS Clean Rooms Service.
//
// Lists configured tables.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Clean Rooms Service's
// API operation ListConfiguredTables for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     Unexpected error during processing of request.
//
//   - ValidationException
//     The input fails to satisfy the specified constraints.
//
//   - ThrottlingException
//     Request was denied due to request throttling.
//
//   - AccessDeniedException
//     Caller does not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/ListConfiguredTables
func (c *CleanRooms) ListConfiguredTables(input *ListConfiguredTablesInput) (*ListConfiguredTablesOutput, error) {
	req, out := c.ListConfiguredTablesRequest(input)
	return out, req.Send()
}

// ListConfiguredTablesWithContext is the same as ListConfiguredTables with the addition of
// the ability to pass a context and additional request options.
//
// See ListConfiguredTables for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CleanRooms) ListConfiguredTablesWithContext(ctx aws.Context, input *ListConfiguredTablesInput, opts ...request.Option) (*ListConfiguredTablesOutput, error) {
	req, out := c.ListConfiguredTablesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListConfiguredTablesPages iterates over the pages of a ListConfiguredTables operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListConfiguredTables method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListConfiguredTables operation.
//	pageNum := 0
//	err := client.ListConfiguredTablesPages(params,
//	    func(page *cleanrooms.ListConfiguredTablesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *CleanRooms) ListConfiguredTablesPages(input *ListConfiguredTablesInput, fn func(*ListConfiguredTablesOutput, bool) bool) error {
	return c.ListConfiguredTablesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListConfiguredTablesPagesWithContext same as ListConfiguredTablesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CleanRooms) ListConfiguredTablesPagesWithContext(ctx aws.Context, input *ListConfiguredTablesInput, fn func(*ListConfiguredTablesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListConfiguredTablesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListConfiguredTablesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListConfiguredTablesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListIdMappingTables = "ListIdMappingTables"

// ListIdMappingTablesRequest generates a "aws/request.Request" representing the
// client's request for the ListIdMappingTables operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListIdMappingTables for more information on using the ListIdMappingTables
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListIdMappingTablesRequest method.
//	req, resp := client.ListIdMappingTablesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/ListIdMappingTables
func (c *CleanRooms) ListIdMappingTablesRequest(input *ListIdMappingTablesInput) (req *request.Request, output *ListIdMappingTablesOutput) {
	op := &request.Operation{
		Name:       opListIdMappingTables,
		HTTPMethod: "GET",
		HTTPPath:   "/memberships/{membershipIdentifier}/idmappingtables",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListIdMappingTablesInput{}
	}

	output = &ListIdMappingTablesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListIdMappingTables API operation for AWS Clean Rooms Service.
//
// Returns a list of ID mapping tables.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Clean Rooms Service's
// API operation ListIdMappingTables for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     Request references a resource which does not exist.
//
//   - InternalServerException
//     Unexpected error during processing of request.
//
//   - ValidationException
//     The input fails to satisfy the specified constraints.
//
//   - ThrottlingException
//     Request was denied due to request throttling.
//
//   - AccessDeniedException
//     Caller does not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/ListIdMappingTables
func (c *CleanRooms) ListIdMappingTables(input *ListIdMappingTablesInput) (*ListIdMappingTablesOutput, error) {
	req, out := c.ListIdMappingTablesRequest(input)
	return out, req.Send()
}

// ListIdMappingTablesWithContext is the same as ListIdMappingTables with the addition of
// the ability to pass a context and additional request options.
//
// See ListIdMappingTables for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CleanRooms) ListIdMappingTablesWithContext(ctx aws.Context, input *ListIdMappingTablesInput, opts ...request.Option) (*ListIdMappingTablesOutput, error) {
	req, out := c.ListIdMappingTablesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListIdMappingTablesPages iterates over the pages of a ListIdMappingTables operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListIdMappingTables method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListIdMappingTables operation.
//	pageNum := 0
//	err := client.ListIdMappingTablesPages(params,
//	    func(page *cleanrooms.ListIdMappingTablesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *CleanRooms) ListIdMappingTablesPages(input *ListIdMappingTablesInput, fn func(*ListIdMappingTablesOutput, bool) bool) error {
	return c.ListIdMappingTablesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListIdMappingTablesPagesWithContext same as ListIdMappingTablesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CleanRooms) ListIdMappingTablesPagesWithContext(ctx aws.Context, input *ListIdMappingTablesInput, fn func(*ListIdMappingTablesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListIdMappingTablesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListIdMappingTablesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListIdMappingTablesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListIdNamespaceAssociations = "ListIdNamespaceAssociations"

// ListIdNamespaceAssociationsRequest generates a "aws/request.Request" representing the
// client's request for the ListIdNamespaceAssociations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListIdNamespaceAssociations for more information on using the ListIdNamespaceAssociations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListIdNamespaceAssociationsRequest method.
//	req, resp := client.ListIdNamespaceAssociationsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/ListIdNamespaceAssociations
func (c *CleanRooms) ListIdNamespaceAssociationsRequest(input *ListIdNamespaceAssociationsInput) (req *request.Request, output *ListIdNamespaceAssociationsOutput) {
	op := &request.Operation{
		Name:       opListIdNamespaceAssociations,
		HTTPMethod: "GET",
		HTTPPath:   "/memberships/{membershipIdentifier}/idnamespaceassociations",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListIdNamespaceAssociationsInput{}
	}

	output = &ListIdNamespaceAssociationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListIdNamespaceAssociations API operation for AWS Clean Rooms Service.
//
// Returns a list of ID namespace associations.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Clean Rooms Service's
// API operation ListIdNamespaceAssociations for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     Request references a resource which does not exist.
//
//   - InternalServerException
//     Unexpected error during processing of request.
//
//   - ValidationException
//     The input fails to satisfy the specified constraints.
//
//   - ThrottlingException
//     Request was denied due to request throttling.
//
//   - AccessDeniedException
//     Caller does not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/ListIdNamespaceAssociations
func (c *CleanRooms) ListIdNamespaceAssociations(input *ListIdNamespaceAssociationsInput) (*ListIdNamespaceAssociationsOutput, error) {
	req, out := c.ListIdNamespaceAssociationsRequest(input)
	return out, req.Send()
}

// ListIdNamespaceAssociationsWithContext is the same as ListIdNamespaceAssociations with the addition of
// the ability to pass a context and additional request options.
//
// See ListIdNamespaceAssociations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CleanRooms) ListIdNamespaceAssociationsWithContext(ctx aws.Context, input *ListIdNamespaceAssociationsInput, opts ...request.Option) (*ListIdNamespaceAssociationsOutput, error) {
	req, out := c.ListIdNamespaceAssociationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListIdNamespaceAssociationsPages iterates over the pages of a ListIdNamespaceAssociations operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListIdNamespaceAssociations method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListIdNamespaceAssociations operation.
//	pageNum := 0
//	err := client.ListIdNamespaceAssociationsPages(params,
//	    func(page *cleanrooms.ListIdNamespaceAssociationsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *CleanRooms) ListIdNamespaceAssociationsPages(input *ListIdNamespaceAssociationsInput, fn func(*ListIdNamespaceAssociationsOutput, bool) bool) error {
	return c.ListIdNamespaceAssociationsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListIdNamespaceAssociationsPagesWithContext same as ListIdNamespaceAssociationsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CleanRooms) ListIdNamespaceAssociationsPagesWithContext(ctx aws.Context, input *ListIdNamespaceAssociationsInput, fn func(*ListIdNamespaceAssociationsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListIdNamespaceAssociationsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListIdNamespaceAssociationsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListIdNamespaceAssociationsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListMembers = "ListMembers"

// ListMembersRequest generates a "aws/request.Request" representing the
// client's request for the ListMembers operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListMembers for more information on using the ListMembers
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListMembersRequest method.
//	req, resp := client.ListMembersRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/ListMembers
func (c *CleanRooms) ListMembersRequest(input *ListMembersInput) (req *request.Request, output *ListMembersOutput) {
	op := &request.Operation{
		Name:       opListMembers,
		HTTPMethod: "GET",
		HTTPPath:   "/collaborations/{collaborationIdentifier}/members",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListMembersInput{}
	}

	output = &ListMembersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListMembers API operation for AWS Clean Rooms Service.
//
// Lists all members within a collaboration.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Clean Rooms Service's
// API operation ListMembers for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     Request references a resource which does not exist.
//
//   - InternalServerException
//     Unexpected error during processing of request.
//
//   - ValidationException
//     The input fails to satisfy the specified constraints.
//
//   - ThrottlingException
//     Request was denied due to request throttling.
//
//   - AccessDeniedException
//     Caller does not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/ListMembers
func (c *CleanRooms) ListMembers(input *ListMembersInput) (*ListMembersOutput, error) {
	req, out := c.ListMembersRequest(input)
	return out, req.Send()
}

// ListMembersWithContext is the same as ListMembers with the addition of
// the ability to pass a context and additional request options.
//
// See ListMembers for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CleanRooms) ListMembersWithContext(ctx aws.Context, input *ListMembersInput, opts ...request.Option) (*ListMembersOutput, error) {
	req, out := c.ListMembersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListMembersPages iterates over the pages of a ListMembers operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListMembers method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListMembers operation.
//	pageNum := 0
//	err := client.ListMembersPages(params,
//	    func(page *cleanrooms.ListMembersOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *CleanRooms) ListMembersPages(input *ListMembersInput, fn func(*ListMembersOutput, bool) bool) error {
	return c.ListMembersPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListMembersPagesWithContext same as ListMembersPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CleanRooms) ListMembersPagesWithContext(ctx aws.Context, input *ListMembersInput, fn func(*ListMembersOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListMembersInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListMembersRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListMembersOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListMemberships = "ListMemberships"

// ListMembershipsRequest generates a "aws/request.Request" representing the
// client's request for the ListMemberships operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListMemberships for more information on using the ListMemberships
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListMembershipsRequest method.
//	req, resp := client.ListMembershipsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/ListMemberships
func (c *CleanRooms) ListMembershipsRequest(input *ListMembershipsInput) (req *request.Request, output *ListMembershipsOutput) {
	op := &request.Operation{
		Name:       opListMemberships,
		HTTPMethod: "GET",
		HTTPPath:   "/memberships",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListMembershipsInput{}
	}

	output = &ListMembershipsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListMemberships API operation for AWS Clean Rooms Service.
//
// Lists all memberships resources within the caller's account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Clean Rooms Service's
// API operation ListMemberships for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     Unexpected error during processing of request.
//
//   - ValidationException
//     The input fails to satisfy the specified constraints.
//
//   - ThrottlingException
//     Request was denied due to request throttling.
//
//   - AccessDeniedException
//     Caller does not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/ListMemberships
func (c *CleanRooms) ListMemberships(input *ListMembershipsInput) (*ListMembershipsOutput, error) {
	req, out := c.ListMembershipsRequest(input)
	return out, req.Send()
}

// ListMembershipsWithContext is the same as ListMemberships with the addition of
// the ability to pass a context and additional request options.
//
// See ListMemberships for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CleanRooms) ListMembershipsWithContext(ctx aws.Context, input *ListMembershipsInput, opts ...request.Option) (*ListMembershipsOutput, error) {
	req, out := c.ListMembershipsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListMembershipsPages iterates over the pages of a ListMemberships operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListMemberships method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListMemberships operation.
//	pageNum := 0
//	err := client.ListMembershipsPages(params,
//	    func(page *cleanrooms.ListMembershipsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *CleanRooms) ListMembershipsPages(input *ListMembershipsInput, fn func(*ListMembershipsOutput, bool) bool) error {
	return c.ListMembershipsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListMembershipsPagesWithContext same as ListMembershipsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CleanRooms) ListMembershipsPagesWithContext(ctx aws.Context, input *ListMembershipsInput, fn func(*ListMembershipsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListMembershipsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListMembershipsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListMembershipsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListPrivacyBudgetTemplates = "ListPrivacyBudgetTemplates"

// ListPrivacyBudgetTemplatesRequest generates a "aws/request.Request" representing the
// client's request for the ListPrivacyBudgetTemplates operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListPrivacyBudgetTemplates for more information on using the ListPrivacyBudgetTemplates
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListPrivacyBudgetTemplatesRequest method.
//	req, resp := client.ListPrivacyBudgetTemplatesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/ListPrivacyBudgetTemplates
func (c *CleanRooms) ListPrivacyBudgetTemplatesRequest(input *ListPrivacyBudgetTemplatesInput) (req *request.Request, output *ListPrivacyBudgetTemplatesOutput) {
	op := &request.Operation{
		Name:       opListPrivacyBudgetTemplates,
		HTTPMethod: "GET",
		HTTPPath:   "/memberships/{membershipIdentifier}/privacybudgettemplates",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListPrivacyBudgetTemplatesInput{}
	}

	output = &ListPrivacyBudgetTemplatesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListPrivacyBudgetTemplates API operation for AWS Clean Rooms Service.
//
// Returns detailed information about the privacy budget templates in a specified
// membership.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Clean Rooms Service's
// API operation ListPrivacyBudgetTemplates for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     Request references a resource which does not exist.
//
//   - InternalServerException
//     Unexpected error during processing of request.
//
//   - ValidationException
//     The input fails to satisfy the specified constraints.
//
//   - ThrottlingException
//     Request was denied due to request throttling.
//
//   - AccessDeniedException
//     Caller does not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/ListPrivacyBudgetTemplates
func (c *CleanRooms) ListPrivacyBudgetTemplates(input *ListPrivacyBudgetTemplatesInput) (*ListPrivacyBudgetTemplatesOutput, error) {
	req, out := c.ListPrivacyBudgetTemplatesRequest(input)
	return out, req.Send()
}

// ListPrivacyBudgetTemplatesWithContext is the same as ListPrivacyBudgetTemplates with the addition of
// the ability to pass a context and additional request options.
//
// See ListPrivacyBudgetTemplates for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CleanRooms) ListPrivacyBudgetTemplatesWithContext(ctx aws.Context, input *ListPrivacyBudgetTemplatesInput, opts ...request.Option) (*ListPrivacyBudgetTemplatesOutput, error) {
	req, out := c.ListPrivacyBudgetTemplatesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListPrivacyBudgetTemplatesPages iterates over the pages of a ListPrivacyBudgetTemplates operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListPrivacyBudgetTemplates method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListPrivacyBudgetTemplates operation.
//	pageNum := 0
//	err := client.ListPrivacyBudgetTemplatesPages(params,
//	    func(page *cleanrooms.ListPrivacyBudgetTemplatesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *CleanRooms) ListPrivacyBudgetTemplatesPages(input *ListPrivacyBudgetTemplatesInput, fn func(*ListPrivacyBudgetTemplatesOutput, bool) bool) error {
	return c.ListPrivacyBudgetTemplatesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListPrivacyBudgetTemplatesPagesWithContext same as ListPrivacyBudgetTemplatesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CleanRooms) ListPrivacyBudgetTemplatesPagesWithContext(ctx aws.Context, input *ListPrivacyBudgetTemplatesInput, fn func(*ListPrivacyBudgetTemplatesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListPrivacyBudgetTemplatesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListPrivacyBudgetTemplatesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListPrivacyBudgetTemplatesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListPrivacyBudgets = "ListPrivacyBudgets"

// ListPrivacyBudgetsRequest generates a "aws/request.Request" representing the
// client's request for the ListPrivacyBudgets operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListPrivacyBudgets for more information on using the ListPrivacyBudgets
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListPrivacyBudgetsRequest method.
//	req, resp := client.ListPrivacyBudgetsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/ListPrivacyBudgets
func (c *CleanRooms) ListPrivacyBudgetsRequest(input *ListPrivacyBudgetsInput) (req *request.Request, output *ListPrivacyBudgetsOutput) {
	op := &request.Operation{
		Name:       opListPrivacyBudgets,
		HTTPMethod: "GET",
		HTTPPath:   "/memberships/{membershipIdentifier}/privacybudgets",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListPrivacyBudgetsInput{}
	}

	output = &ListPrivacyBudgetsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListPrivacyBudgets API operation for AWS Clean Rooms Service.
//
// Returns detailed information about the privacy budgets in a specified membership.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Clean Rooms Service's
// API operation ListPrivacyBudgets for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     Request references a resource which does not exist.
//
//   - InternalServerException
//     Unexpected error during processing of request.
//
//   - ValidationException
//     The input fails to satisfy the specified constraints.
//
//   - ThrottlingException
//     Request was denied due to request throttling.
//
//   - AccessDeniedException
//     Caller does not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/ListPrivacyBudgets
func (c *CleanRooms) ListPrivacyBudgets(input *ListPrivacyBudgetsInput) (*ListPrivacyBudgetsOutput, error) {
	req, out := c.ListPrivacyBudgetsRequest(input)
	return out, req.Send()
}

// ListPrivacyBudgetsWithContext is the same as ListPrivacyBudgets with the addition of
// the ability to pass a context and additional request options.
//
// See ListPrivacyBudgets for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CleanRooms) ListPrivacyBudgetsWithContext(ctx aws.Context, input *ListPrivacyBudgetsInput, opts ...request.Option) (*ListPrivacyBudgetsOutput, error) {
	req, out := c.ListPrivacyBudgetsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListPrivacyBudgetsPages iterates over the pages of a ListPrivacyBudgets operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListPrivacyBudgets method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListPrivacyBudgets operation.
//	pageNum := 0
//	err := client.ListPrivacyBudgetsPages(params,
//	    func(page *cleanrooms.ListPrivacyBudgetsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *CleanRooms) ListPrivacyBudgetsPages(input *ListPrivacyBudgetsInput, fn func(*ListPrivacyBudgetsOutput, bool) bool) error {
	return c.ListPrivacyBudgetsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListPrivacyBudgetsPagesWithContext same as ListPrivacyBudgetsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CleanRooms) ListPrivacyBudgetsPagesWithContext(ctx aws.Context, input *ListPrivacyBudgetsInput, fn func(*ListPrivacyBudgetsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListPrivacyBudgetsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListPrivacyBudgetsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListPrivacyBudgetsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListProtectedQueries = "ListProtectedQueries"

// ListProtectedQueriesRequest generates a "aws/request.Request" representing the
// client's request for the ListProtectedQueries operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListProtectedQueries for more information on using the ListProtectedQueries
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListProtectedQueriesRequest method.
//	req, resp := client.ListProtectedQueriesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/ListProtectedQueries
func (c *CleanRooms) ListProtectedQueriesRequest(input *ListProtectedQueriesInput) (req *request.Request, output *ListProtectedQueriesOutput) {
	op := &request.Operation{
		Name:       opListProtectedQueries,
		HTTPMethod: "GET",
		HTTPPath:   "/memberships/{membershipIdentifier}/protectedQueries",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListProtectedQueriesInput{}
	}

	output = &ListProtectedQueriesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListProtectedQueries API operation for AWS Clean Rooms Service.
//
// Lists protected queries, sorted by the most recent query.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Clean Rooms Service's
// API operation ListProtectedQueries for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     Request references a resource which does not exist.
//
//   - InternalServerException
//     Unexpected error during processing of request.
//
//   - ValidationException
//     The input fails to satisfy the specified constraints.
//
//   - ThrottlingException
//     Request was denied due to request throttling.
//
//   - AccessDeniedException
//     Caller does not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/ListProtectedQueries
func (c *CleanRooms) ListProtectedQueries(input *ListProtectedQueriesInput) (*ListProtectedQueriesOutput, error) {
	req, out := c.ListProtectedQueriesRequest(input)
	return out, req.Send()
}

// ListProtectedQueriesWithContext is the same as ListProtectedQueries with the addition of
// the ability to pass a context and additional request options.
//
// See ListProtectedQueries for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CleanRooms) ListProtectedQueriesWithContext(ctx aws.Context, input *ListProtectedQueriesInput, opts ...request.Option) (*ListProtectedQueriesOutput, error) {
	req, out := c.ListProtectedQueriesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListProtectedQueriesPages iterates over the pages of a ListProtectedQueries operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListProtectedQueries method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListProtectedQueries operation.
//	pageNum := 0
//	err := client.ListProtectedQueriesPages(params,
//	    func(page *cleanrooms.ListProtectedQueriesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *CleanRooms) ListProtectedQueriesPages(input *ListProtectedQueriesInput, fn func(*ListProtectedQueriesOutput, bool) bool) error {
	return c.ListProtectedQueriesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListProtectedQueriesPagesWithContext same as ListProtectedQueriesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CleanRooms) ListProtectedQueriesPagesWithContext(ctx aws.Context, input *ListProtectedQueriesInput, fn func(*ListProtectedQueriesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListProtectedQueriesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListProtectedQueriesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListProtectedQueriesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListSchemas = "ListSchemas"

// ListSchemasRequest generates a "aws/request.Request" representing the
// client's request for the ListSchemas operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListSchemas for more information on using the ListSchemas
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListSchemasRequest method.
//	req, resp := client.ListSchemasRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/ListSchemas
func (c *CleanRooms) ListSchemasRequest(input *ListSchemasInput) (req *request.Request, output *ListSchemasOutput) {
	op := &request.Operation{
		Name:       opListSchemas,
		HTTPMethod: "GET",
		HTTPPath:   "/collaborations/{collaborationIdentifier}/schemas",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListSchemasInput{}
	}

	output = &ListSchemasOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListSchemas API operation for AWS Clean Rooms Service.
//
// Lists the schemas for relations within a collaboration.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Clean Rooms Service's
// API operation ListSchemas for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     Request references a resource which does not exist.
//
//   - InternalServerException
//     Unexpected error during processing of request.
//
//   - ValidationException
//     The input fails to satisfy the specified constraints.
//
//   - ThrottlingException
//     Request was denied due to request throttling.
//
//   - AccessDeniedException
//     Caller does not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/ListSchemas
func (c *CleanRooms) ListSchemas(input *ListSchemasInput) (*ListSchemasOutput, error) {
	req, out := c.ListSchemasRequest(input)
	return out, req.Send()
}

// ListSchemasWithContext is the same as ListSchemas with the addition of
// the ability to pass a context and additional request options.
//
// See ListSchemas for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CleanRooms) ListSchemasWithContext(ctx aws.Context, input *ListSchemasInput, opts ...request.Option) (*ListSchemasOutput, error) {
	req, out := c.ListSchemasRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListSchemasPages iterates over the pages of a ListSchemas operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListSchemas method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListSchemas operation.
//	pageNum := 0
//	err := client.ListSchemasPages(params,
//	    func(page *cleanrooms.ListSchemasOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *CleanRooms) ListSchemasPages(input *ListSchemasInput, fn func(*ListSchemasOutput, bool) bool) error {
	return c.ListSchemasPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListSchemasPagesWithContext same as ListSchemasPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CleanRooms) ListSchemasPagesWithContext(ctx aws.Context, input *ListSchemasInput, fn func(*ListSchemasOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListSchemasInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListSchemasRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListSchemasOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTagsForResourceRequest method.
//	req, resp := client.ListTagsForResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/ListTagsForResource
func (c *CleanRooms) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "GET",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for AWS Clean Rooms Service.
//
// Lists all of the tags that have been added to a resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Clean Rooms Service's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     Request references a resource which does not exist.
//
//   - ValidationException
//     The input fails to satisfy the specified constraints.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/ListTagsForResource
func (c *CleanRooms) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CleanRooms) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPopulateIdMappingTable = "PopulateIdMappingTable"

// PopulateIdMappingTableRequest generates a "aws/request.Request" representing the
// client's request for the PopulateIdMappingTable operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PopulateIdMappingTable for more information on using the PopulateIdMappingTable
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PopulateIdMappingTableRequest method.
//	req, resp := client.PopulateIdMappingTableRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/PopulateIdMappingTable
func (c *CleanRooms) PopulateIdMappingTableRequest(input *PopulateIdMappingTableInput) (req *request.Request, output *PopulateIdMappingTableOutput) {
	op := &request.Operation{
		Name:       opPopulateIdMappingTable,
		HTTPMethod: "POST",
		HTTPPath:   "/memberships/{membershipIdentifier}/idmappingtables/{idMappingTableIdentifier}/populate",
	}

	if input == nil {
		input = &PopulateIdMappingTableInput{}
	}

	output = &PopulateIdMappingTableOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PopulateIdMappingTable API operation for AWS Clean Rooms Service.
//
// Defines the information that's necessary to populate an ID mapping table.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Clean Rooms Service's
// API operation PopulateIdMappingTable for usage and error information.
//
// Returned Error Types:
//
//   - ConflictException
//     Updating or deleting a resource can cause an inconsistent state.
//
//   - ResourceNotFoundException
//     Request references a resource which does not exist.
//
//   - InternalServerException
//     Unexpected error during processing of request.
//
//   - ValidationException
//     The input fails to satisfy the specified constraints.
//
//   - ThrottlingException
//     Request was denied due to request throttling.
//
//   - AccessDeniedException
//     Caller does not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/PopulateIdMappingTable
func (c *CleanRooms) PopulateIdMappingTable(input *PopulateIdMappingTableInput) (*PopulateIdMappingTableOutput, error) {
	req, out := c.PopulateIdMappingTableRequest(input)
	return out, req.Send()
}

// PopulateIdMappingTableWithContext is the same as PopulateIdMappingTable with the addition of
// the ability to pass a context and additional request options.
//
// See PopulateIdMappingTable for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CleanRooms) PopulateIdMappingTableWithContext(ctx aws.Context, input *PopulateIdMappingTableInput, opts ...request.Option) (*PopulateIdMappingTableOutput, error) {
	req, out := c.PopulateIdMappingTableRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPreviewPrivacyImpact = "PreviewPrivacyImpact"

// PreviewPrivacyImpactRequest generates a "aws/request.Request" representing the
// client's request for the PreviewPrivacyImpact operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PreviewPrivacyImpact for more information on using the PreviewPrivacyImpact
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PreviewPrivacyImpactRequest method.
//	req, resp := client.PreviewPrivacyImpactRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/PreviewPrivacyImpact
func (c *CleanRooms) PreviewPrivacyImpactRequest(input *PreviewPrivacyImpactInput) (req *request.Request, output *PreviewPrivacyImpactOutput) {
	op := &request.Operation{
		Name:       opPreviewPrivacyImpact,
		HTTPMethod: "POST",
		HTTPPath:   "/memberships/{membershipIdentifier}/previewprivacyimpact",
	}

	if input == nil {
		input = &PreviewPrivacyImpactInput{}
	}

	output = &PreviewPrivacyImpactOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PreviewPrivacyImpact API operation for AWS Clean Rooms Service.
//
// An estimate of the number of aggregation functions that the member who can
// query can run given epsilon and noise parameters.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Clean Rooms Service's
// API operation PreviewPrivacyImpact for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     Request references a resource which does not exist.
//
//   - InternalServerException
//     Unexpected error during processing of request.
//
//   - ValidationException
//     The input fails to satisfy the specified constraints.
//
//   - ThrottlingException
//     Request was denied due to request throttling.
//
//   - AccessDeniedException
//     Caller does not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/PreviewPrivacyImpact
func (c *CleanRooms) PreviewPrivacyImpact(input *PreviewPrivacyImpactInput) (*PreviewPrivacyImpactOutput, error) {
	req, out := c.PreviewPrivacyImpactRequest(input)
	return out, req.Send()
}

// PreviewPrivacyImpactWithContext is the same as PreviewPrivacyImpact with the addition of
// the ability to pass a context and additional request options.
//
// See PreviewPrivacyImpact for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CleanRooms) PreviewPrivacyImpactWithContext(ctx aws.Context, input *PreviewPrivacyImpactInput, opts ...request.Option) (*PreviewPrivacyImpactOutput, error) {
	req, out := c.PreviewPrivacyImpactRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartProtectedQuery = "StartProtectedQuery"

// StartProtectedQueryRequest generates a "aws/request.Request" representing the
// client's request for the StartProtectedQuery operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartProtectedQuery for more information on using the StartProtectedQuery
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StartProtectedQueryRequest method.
//	req, resp := client.StartProtectedQueryRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/StartProtectedQuery
func (c *CleanRooms) StartProtectedQueryRequest(input *StartProtectedQueryInput) (req *request.Request, output *StartProtectedQueryOutput) {
	op := &request.Operation{
		Name:       opStartProtectedQuery,
		HTTPMethod: "POST",
		HTTPPath:   "/memberships/{membershipIdentifier}/protectedQueries",
	}

	if input == nil {
		input = &StartProtectedQueryInput{}
	}

	output = &StartProtectedQueryOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartProtectedQuery API operation for AWS Clean Rooms Service.
//
// Creates a protected query that is started by Clean Rooms.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Clean Rooms Service's
// API operation StartProtectedQuery for usage and error information.
//
// Returned Error Types:
//
//   - ServiceQuotaExceededException
//     Request denied because service quota has been exceeded.
//
//   - ResourceNotFoundException
//     Request references a resource which does not exist.
//
//   - InternalServerException
//     Unexpected error during processing of request.
//
//   - ValidationException
//     The input fails to satisfy the specified constraints.
//
//   - ThrottlingException
//     Request was denied due to request throttling.
//
//   - AccessDeniedException
//     Caller does not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/StartProtectedQuery
func (c *CleanRooms) StartProtectedQuery(input *StartProtectedQueryInput) (*StartProtectedQueryOutput, error) {
	req, out := c.StartProtectedQueryRequest(input)
	return out, req.Send()
}

// StartProtectedQueryWithContext is the same as StartProtectedQuery with the addition of
// the ability to pass a context and additional request options.
//
// See StartProtectedQuery for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CleanRooms) StartProtectedQueryWithContext(ctx aws.Context, input *StartProtectedQueryInput, opts ...request.Option) (*StartProtectedQueryOutput, error) {
	req, out := c.StartProtectedQueryRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the TagResourceRequest method.
//	req, resp := client.TagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/TagResource
func (c *CleanRooms) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for AWS Clean Rooms Service.
//
// Tags a resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Clean Rooms Service's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     Request references a resource which does not exist.
//
//   - ValidationException
//     The input fails to satisfy the specified constraints.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/TagResource
func (c *CleanRooms) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CleanRooms) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UntagResourceRequest method.
//	req, resp := client.UntagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/UntagResource
func (c *CleanRooms) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "DELETE",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for AWS Clean Rooms Service.
//
// Removes a tag or list of tags from a resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Clean Rooms Service's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     Request references a resource which does not exist.
//
//   - ValidationException
//     The input fails to satisfy the specified constraints.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/UntagResource
func (c *CleanRooms) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CleanRooms) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateAnalysisTemplate = "UpdateAnalysisTemplate"

// UpdateAnalysisTemplateRequest generates a "aws/request.Request" representing the
// client's request for the UpdateAnalysisTemplate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateAnalysisTemplate for more information on using the UpdateAnalysisTemplate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateAnalysisTemplateRequest method.
//	req, resp := client.UpdateAnalysisTemplateRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/UpdateAnalysisTemplate
func (c *CleanRooms) UpdateAnalysisTemplateRequest(input *UpdateAnalysisTemplateInput) (req *request.Request, output *UpdateAnalysisTemplateOutput) {
	op := &request.Operation{
		Name:       opUpdateAnalysisTemplate,
		HTTPMethod: "PATCH",
		HTTPPath:   "/memberships/{membershipIdentifier}/analysistemplates/{analysisTemplateIdentifier}",
	}

	if input == nil {
		input = &UpdateAnalysisTemplateInput{}
	}

	output = &UpdateAnalysisTemplateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateAnalysisTemplate API operation for AWS Clean Rooms Service.
//
// Updates the analysis template metadata.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Clean Rooms Service's
// API operation UpdateAnalysisTemplate for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     Request references a resource which does not exist.
//
//   - InternalServerException
//     Unexpected error during processing of request.
//
//   - ValidationException
//     The input fails to satisfy the specified constraints.
//
//   - ThrottlingException
//     Request was denied due to request throttling.
//
//   - AccessDeniedException
//     Caller does not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/UpdateAnalysisTemplate
func (c *CleanRooms) UpdateAnalysisTemplate(input *UpdateAnalysisTemplateInput) (*UpdateAnalysisTemplateOutput, error) {
	req, out := c.UpdateAnalysisTemplateRequest(input)
	return out, req.Send()
}

// UpdateAnalysisTemplateWithContext is the same as UpdateAnalysisTemplate with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateAnalysisTemplate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CleanRooms) UpdateAnalysisTemplateWithContext(ctx aws.Context, input *UpdateAnalysisTemplateInput, opts ...request.Option) (*UpdateAnalysisTemplateOutput, error) {
	req, out := c.UpdateAnalysisTemplateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateCollaboration = "UpdateCollaboration"

// UpdateCollaborationRequest generates a "aws/request.Request" representing the
// client's request for the UpdateCollaboration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateCollaboration for more information on using the UpdateCollaboration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateCollaborationRequest method.
//	req, resp := client.UpdateCollaborationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/UpdateCollaboration
func (c *CleanRooms) UpdateCollaborationRequest(input *UpdateCollaborationInput) (req *request.Request, output *UpdateCollaborationOutput) {
	op := &request.Operation{
		Name:       opUpdateCollaboration,
		HTTPMethod: "PATCH",
		HTTPPath:   "/collaborations/{collaborationIdentifier}",
	}

	if input == nil {
		input = &UpdateCollaborationInput{}
	}

	output = &UpdateCollaborationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateCollaboration API operation for AWS Clean Rooms Service.
//
// Updates collaboration metadata and can only be called by the collaboration
// owner.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Clean Rooms Service's
// API operation UpdateCollaboration for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     Unexpected error during processing of request.
//
//   - ValidationException
//     The input fails to satisfy the specified constraints.
//
//   - ThrottlingException
//     Request was denied due to request throttling.
//
//   - AccessDeniedException
//     Caller does not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/UpdateCollaboration
func (c *CleanRooms) UpdateCollaboration(input *UpdateCollaborationInput) (*UpdateCollaborationOutput, error) {
	req, out := c.UpdateCollaborationRequest(input)
	return out, req.Send()
}

// UpdateCollaborationWithContext is the same as UpdateCollaboration with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateCollaboration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CleanRooms) UpdateCollaborationWithContext(ctx aws.Context, input *UpdateCollaborationInput, opts ...request.Option) (*UpdateCollaborationOutput, error) {
	req, out := c.UpdateCollaborationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateConfiguredAudienceModelAssociation = "UpdateConfiguredAudienceModelAssociation"

// UpdateConfiguredAudienceModelAssociationRequest generates a "aws/request.Request" representing the
// client's request for the UpdateConfiguredAudienceModelAssociation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateConfiguredAudienceModelAssociation for more information on using the UpdateConfiguredAudienceModelAssociation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateConfiguredAudienceModelAssociationRequest method.
//	req, resp := client.UpdateConfiguredAudienceModelAssociationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/UpdateConfiguredAudienceModelAssociation
func (c *CleanRooms) UpdateConfiguredAudienceModelAssociationRequest(input *UpdateConfiguredAudienceModelAssociationInput) (req *request.Request, output *UpdateConfiguredAudienceModelAssociationOutput) {
	op := &request.Operation{
		Name:       opUpdateConfiguredAudienceModelAssociation,
		HTTPMethod: "PATCH",
		HTTPPath:   "/memberships/{membershipIdentifier}/configuredaudiencemodelassociations/{configuredAudienceModelAssociationIdentifier}",
	}

	if input == nil {
		input = &UpdateConfiguredAudienceModelAssociationInput{}
	}

	output = &UpdateConfiguredAudienceModelAssociationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateConfiguredAudienceModelAssociation API operation for AWS Clean Rooms Service.
//
// Provides the details necessary to update a configured audience model association.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Clean Rooms Service's
// API operation UpdateConfiguredAudienceModelAssociation for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     Request references a resource which does not exist.
//
//   - InternalServerException
//     Unexpected error during processing of request.
//
//   - ValidationException
//     The input fails to satisfy the specified constraints.
//
//   - ThrottlingException
//     Request was denied due to request throttling.
//
//   - AccessDeniedException
//     Caller does not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/UpdateConfiguredAudienceModelAssociation
func (c *CleanRooms) UpdateConfiguredAudienceModelAssociation(input *UpdateConfiguredAudienceModelAssociationInput) (*UpdateConfiguredAudienceModelAssociationOutput, error) {
	req, out := c.UpdateConfiguredAudienceModelAssociationRequest(input)
	return out, req.Send()
}

// UpdateConfiguredAudienceModelAssociationWithContext is the same as UpdateConfiguredAudienceModelAssociation with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateConfiguredAudienceModelAssociation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CleanRooms) UpdateConfiguredAudienceModelAssociationWithContext(ctx aws.Context, input *UpdateConfiguredAudienceModelAssociationInput, opts ...request.Option) (*UpdateConfiguredAudienceModelAssociationOutput, error) {
	req, out := c.UpdateConfiguredAudienceModelAssociationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateConfiguredTable = "UpdateConfiguredTable"

// UpdateConfiguredTableRequest generates a "aws/request.Request" representing the
// client's request for the UpdateConfiguredTable operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateConfiguredTable for more information on using the UpdateConfiguredTable
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateConfiguredTableRequest method.
//	req, resp := client.UpdateConfiguredTableRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/UpdateConfiguredTable
func (c *CleanRooms) UpdateConfiguredTableRequest(input *UpdateConfiguredTableInput) (req *request.Request, output *UpdateConfiguredTableOutput) {
	op := &request.Operation{
		Name:       opUpdateConfiguredTable,
		HTTPMethod: "PATCH",
		HTTPPath:   "/configuredTables/{configuredTableIdentifier}",
	}

	if input == nil {
		input = &UpdateConfiguredTableInput{}
	}

	output = &UpdateConfiguredTableOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateConfiguredTable API operation for AWS Clean Rooms Service.
//
// Updates a configured table.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Clean Rooms Service's
// API operation UpdateConfiguredTable for usage and error information.
//
// Returned Error Types:
//
//   - ConflictException
//     Updating or deleting a resource can cause an inconsistent state.
//
//   - ResourceNotFoundException
//     Request references a resource which does not exist.
//
//   - InternalServerException
//     Unexpected error during processing of request.
//
//   - ValidationException
//     The input fails to satisfy the specified constraints.
//
//   - ThrottlingException
//     Request was denied due to request throttling.
//
//   - AccessDeniedException
//     Caller does not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/UpdateConfiguredTable
func (c *CleanRooms) UpdateConfiguredTable(input *UpdateConfiguredTableInput) (*UpdateConfiguredTableOutput, error) {
	req, out := c.UpdateConfiguredTableRequest(input)
	return out, req.Send()
}

// UpdateConfiguredTableWithContext is the same as UpdateConfiguredTable with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateConfiguredTable for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CleanRooms) UpdateConfiguredTableWithContext(ctx aws.Context, input *UpdateConfiguredTableInput, opts ...request.Option) (*UpdateConfiguredTableOutput, error) {
	req, out := c.UpdateConfiguredTableRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateConfiguredTableAnalysisRule = "UpdateConfiguredTableAnalysisRule"

// UpdateConfiguredTableAnalysisRuleRequest generates a "aws/request.Request" representing the
// client's request for the UpdateConfiguredTableAnalysisRule operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateConfiguredTableAnalysisRule for more information on using the UpdateConfiguredTableAnalysisRule
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateConfiguredTableAnalysisRuleRequest method.
//	req, resp := client.UpdateConfiguredTableAnalysisRuleRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/UpdateConfiguredTableAnalysisRule
func (c *CleanRooms) UpdateConfiguredTableAnalysisRuleRequest(input *UpdateConfiguredTableAnalysisRuleInput) (req *request.Request, output *UpdateConfiguredTableAnalysisRuleOutput) {
	op := &request.Operation{
		Name:       opUpdateConfiguredTableAnalysisRule,
		HTTPMethod: "PATCH",
		HTTPPath:   "/configuredTables/{configuredTableIdentifier}/analysisRule/{analysisRuleType}",
	}

	if input == nil {
		input = &UpdateConfiguredTableAnalysisRuleInput{}
	}

	output = &UpdateConfiguredTableAnalysisRuleOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateConfiguredTableAnalysisRule API operation for AWS Clean Rooms Service.
//
// Updates a configured table analysis rule.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Clean Rooms Service's
// API operation UpdateConfiguredTableAnalysisRule for usage and error information.
//
// Returned Error Types:
//
//   - ConflictException
//     Updating or deleting a resource can cause an inconsistent state.
//
//   - ResourceNotFoundException
//     Request references a resource which does not exist.
//
//   - InternalServerException
//     Unexpected error during processing of request.
//
//   - ValidationException
//     The input fails to satisfy the specified constraints.
//
//   - ThrottlingException
//     Request was denied due to request throttling.
//
//   - AccessDeniedException
//     Caller does not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/UpdateConfiguredTableAnalysisRule
func (c *CleanRooms) UpdateConfiguredTableAnalysisRule(input *UpdateConfiguredTableAnalysisRuleInput) (*UpdateConfiguredTableAnalysisRuleOutput, error) {
	req, out := c.UpdateConfiguredTableAnalysisRuleRequest(input)
	return out, req.Send()
}

// UpdateConfiguredTableAnalysisRuleWithContext is the same as UpdateConfiguredTableAnalysisRule with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateConfiguredTableAnalysisRule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CleanRooms) UpdateConfiguredTableAnalysisRuleWithContext(ctx aws.Context, input *UpdateConfiguredTableAnalysisRuleInput, opts ...request.Option) (*UpdateConfiguredTableAnalysisRuleOutput, error) {
	req, out := c.UpdateConfiguredTableAnalysisRuleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateConfiguredTableAssociation = "UpdateConfiguredTableAssociation"

// UpdateConfiguredTableAssociationRequest generates a "aws/request.Request" representing the
// client's request for the UpdateConfiguredTableAssociation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateConfiguredTableAssociation for more information on using the UpdateConfiguredTableAssociation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateConfiguredTableAssociationRequest method.
//	req, resp := client.UpdateConfiguredTableAssociationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/UpdateConfiguredTableAssociation
func (c *CleanRooms) UpdateConfiguredTableAssociationRequest(input *UpdateConfiguredTableAssociationInput) (req *request.Request, output *UpdateConfiguredTableAssociationOutput) {
	op := &request.Operation{
		Name:       opUpdateConfiguredTableAssociation,
		HTTPMethod: "PATCH",
		HTTPPath:   "/memberships/{membershipIdentifier}/configuredTableAssociations/{configuredTableAssociationIdentifier}",
	}

	if input == nil {
		input = &UpdateConfiguredTableAssociationInput{}
	}

	output = &UpdateConfiguredTableAssociationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateConfiguredTableAssociation API operation for AWS Clean Rooms Service.
//
// Updates a configured table association.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Clean Rooms Service's
// API operation UpdateConfiguredTableAssociation for usage and error information.
//
// Returned Error Types:
//
//   - ConflictException
//     Updating or deleting a resource can cause an inconsistent state.
//
//   - ResourceNotFoundException
//     Request references a resource which does not exist.
//
//   - InternalServerException
//     Unexpected error during processing of request.
//
//   - ValidationException
//     The input fails to satisfy the specified constraints.
//
//   - ThrottlingException
//     Request was denied due to request throttling.
//
//   - AccessDeniedException
//     Caller does not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/UpdateConfiguredTableAssociation
func (c *CleanRooms) UpdateConfiguredTableAssociation(input *UpdateConfiguredTableAssociationInput) (*UpdateConfiguredTableAssociationOutput, error) {
	req, out := c.UpdateConfiguredTableAssociationRequest(input)
	return out, req.Send()
}

// UpdateConfiguredTableAssociationWithContext is the same as UpdateConfiguredTableAssociation with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateConfiguredTableAssociation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CleanRooms) UpdateConfiguredTableAssociationWithContext(ctx aws.Context, input *UpdateConfiguredTableAssociationInput, opts ...request.Option) (*UpdateConfiguredTableAssociationOutput, error) {
	req, out := c.UpdateConfiguredTableAssociationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateIdMappingTable = "UpdateIdMappingTable"

// UpdateIdMappingTableRequest generates a "aws/request.Request" representing the
// client's request for the UpdateIdMappingTable operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateIdMappingTable for more information on using the UpdateIdMappingTable
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateIdMappingTableRequest method.
//	req, resp := client.UpdateIdMappingTableRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/UpdateIdMappingTable
func (c *CleanRooms) UpdateIdMappingTableRequest(input *UpdateIdMappingTableInput) (req *request.Request, output *UpdateIdMappingTableOutput) {
	op := &request.Operation{
		Name:       opUpdateIdMappingTable,
		HTTPMethod: "PATCH",
		HTTPPath:   "/memberships/{membershipIdentifier}/idmappingtables/{idMappingTableIdentifier}",
	}

	if input == nil {
		input = &UpdateIdMappingTableInput{}
	}

	output = &UpdateIdMappingTableOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateIdMappingTable API operation for AWS Clean Rooms Service.
//
// Provides the details that are necessary to update an ID mapping table.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Clean Rooms Service's
// API operation UpdateIdMappingTable for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     Request references a resource which does not exist.
//
//   - InternalServerException
//     Unexpected error during processing of request.
//
//   - ValidationException
//     The input fails to satisfy the specified constraints.
//
//   - ThrottlingException
//     Request was denied due to request throttling.
//
//   - AccessDeniedException
//     Caller does not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/UpdateIdMappingTable
func (c *CleanRooms) UpdateIdMappingTable(input *UpdateIdMappingTableInput) (*UpdateIdMappingTableOutput, error) {
	req, out := c.UpdateIdMappingTableRequest(input)
	return out, req.Send()
}

// UpdateIdMappingTableWithContext is the same as UpdateIdMappingTable with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateIdMappingTable for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CleanRooms) UpdateIdMappingTableWithContext(ctx aws.Context, input *UpdateIdMappingTableInput, opts ...request.Option) (*UpdateIdMappingTableOutput, error) {
	req, out := c.UpdateIdMappingTableRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateMembership = "UpdateMembership"

// UpdateMembershipRequest generates a "aws/request.Request" representing the
// client's request for the UpdateMembership operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateMembership for more information on using the UpdateMembership
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateMembershipRequest method.
//	req, resp := client.UpdateMembershipRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/UpdateMembership
func (c *CleanRooms) UpdateMembershipRequest(input *UpdateMembershipInput) (req *request.Request, output *UpdateMembershipOutput) {
	op := &request.Operation{
		Name:       opUpdateMembership,
		HTTPMethod: "PATCH",
		HTTPPath:   "/memberships/{membershipIdentifier}",
	}

	if input == nil {
		input = &UpdateMembershipInput{}
	}

	output = &UpdateMembershipOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateMembership API operation for AWS Clean Rooms Service.
//
// Updates a membership.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Clean Rooms Service's
// API operation UpdateMembership for usage and error information.
//
// Returned Error Types:
//
//   - ConflictException
//     Updating or deleting a resource can cause an inconsistent state.
//
//   - ResourceNotFoundException
//     Request references a resource which does not exist.
//
//   - InternalServerException
//     Unexpected error during processing of request.
//
//   - ValidationException
//     The input fails to satisfy the specified constraints.
//
//   - ThrottlingException
//     Request was denied due to request throttling.
//
//   - AccessDeniedException
//     Caller does not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/UpdateMembership
func (c *CleanRooms) UpdateMembership(input *UpdateMembershipInput) (*UpdateMembershipOutput, error) {
	req, out := c.UpdateMembershipRequest(input)
	return out, req.Send()
}

// UpdateMembershipWithContext is the same as UpdateMembership with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateMembership for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CleanRooms) UpdateMembershipWithContext(ctx aws.Context, input *UpdateMembershipInput, opts ...request.Option) (*UpdateMembershipOutput, error) {
	req, out := c.UpdateMembershipRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdatePrivacyBudgetTemplate = "UpdatePrivacyBudgetTemplate"

// UpdatePrivacyBudgetTemplateRequest generates a "aws/request.Request" representing the
// client's request for the UpdatePrivacyBudgetTemplate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdatePrivacyBudgetTemplate for more information on using the UpdatePrivacyBudgetTemplate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdatePrivacyBudgetTemplateRequest method.
//	req, resp := client.UpdatePrivacyBudgetTemplateRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/UpdatePrivacyBudgetTemplate
func (c *CleanRooms) UpdatePrivacyBudgetTemplateRequest(input *UpdatePrivacyBudgetTemplateInput) (req *request.Request, output *UpdatePrivacyBudgetTemplateOutput) {
	op := &request.Operation{
		Name:       opUpdatePrivacyBudgetTemplate,
		HTTPMethod: "PATCH",
		HTTPPath:   "/memberships/{membershipIdentifier}/privacybudgettemplates/{privacyBudgetTemplateIdentifier}",
	}

	if input == nil {
		input = &UpdatePrivacyBudgetTemplateInput{}
	}

	output = &UpdatePrivacyBudgetTemplateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdatePrivacyBudgetTemplate API operation for AWS Clean Rooms Service.
//
// Updates the privacy budget template for the specified membership.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Clean Rooms Service's
// API operation UpdatePrivacyBudgetTemplate for usage and error information.
//
// Returned Error Types:
//
//   - ConflictException
//     Updating or deleting a resource can cause an inconsistent state.
//
//   - ResourceNotFoundException
//     Request references a resource which does not exist.
//
//   - InternalServerException
//     Unexpected error during processing of request.
//
//   - ValidationException
//     The input fails to satisfy the specified constraints.
//
//   - ThrottlingException
//     Request was denied due to request throttling.
//
//   - AccessDeniedException
//     Caller does not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/UpdatePrivacyBudgetTemplate
func (c *CleanRooms) UpdatePrivacyBudgetTemplate(input *UpdatePrivacyBudgetTemplateInput) (*UpdatePrivacyBudgetTemplateOutput, error) {
	req, out := c.UpdatePrivacyBudgetTemplateRequest(input)
	return out, req.Send()
}

// UpdatePrivacyBudgetTemplateWithContext is the same as UpdatePrivacyBudgetTemplate with the addition of
// the ability to pass a context and additional request options.
//
// See UpdatePrivacyBudgetTemplate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CleanRooms) UpdatePrivacyBudgetTemplateWithContext(ctx aws.Context, input *UpdatePrivacyBudgetTemplateInput, opts ...request.Option) (*UpdatePrivacyBudgetTemplateOutput, error) {
	req, out := c.UpdatePrivacyBudgetTemplateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateProtectedQuery = "UpdateProtectedQuery"

// UpdateProtectedQueryRequest generates a "aws/request.Request" representing the
// client's request for the UpdateProtectedQuery operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateProtectedQuery for more information on using the UpdateProtectedQuery
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateProtectedQueryRequest method.
//	req, resp := client.UpdateProtectedQueryRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/UpdateProtectedQuery
func (c *CleanRooms) UpdateProtectedQueryRequest(input *UpdateProtectedQueryInput) (req *request.Request, output *UpdateProtectedQueryOutput) {
	op := &request.Operation{
		Name:       opUpdateProtectedQuery,
		HTTPMethod: "PATCH",
		HTTPPath:   "/memberships/{membershipIdentifier}/protectedQueries/{protectedQueryIdentifier}",
	}

	if input == nil {
		input = &UpdateProtectedQueryInput{}
	}

	output = &UpdateProtectedQueryOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateProtectedQuery API operation for AWS Clean Rooms Service.
//
// Updates the processing of a currently running query.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Clean Rooms Service's
// API operation UpdateProtectedQuery for usage and error information.
//
// Returned Error Types:
//
//   - ConflictException
//     Updating or deleting a resource can cause an inconsistent state.
//
//   - ResourceNotFoundException
//     Request references a resource which does not exist.
//
//   - InternalServerException
//     Unexpected error during processing of request.
//
//   - ValidationException
//     The input fails to satisfy the specified constraints.
//
//   - ThrottlingException
//     Request was denied due to request throttling.
//
//   - AccessDeniedException
//     Caller does not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/UpdateProtectedQuery
func (c *CleanRooms) UpdateProtectedQuery(input *UpdateProtectedQueryInput) (*UpdateProtectedQueryOutput, error) {
	req, out := c.UpdateProtectedQueryRequest(input)
	return out, req.Send()
}

// UpdateProtectedQueryWithContext is the same as UpdateProtectedQuery with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateProtectedQuery for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CleanRooms) UpdateProtectedQueryWithContext(ctx aws.Context, input *UpdateProtectedQueryInput, opts ...request.Option) (*UpdateProtectedQueryOutput, error) {
	req, out := c.UpdateProtectedQueryRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// Caller does not have sufficient access to perform this action.
type AccessDeniedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`

	// A reason code for the exception.
	Reason *string `locationName:"reason" type:"string" enum:"AccessDeniedExceptionReason"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) GoString() string {
	return s.String()
}

func newErrorAccessDeniedException(v protocol.ResponseMetadata) error {
	return &AccessDeniedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AccessDeniedException) Code() string {
	return "AccessDeniedException"
}

// Message returns the exception's message.
func (s *AccessDeniedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AccessDeniedException) OrigErr() error {
	return nil
}

func (s *AccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AccessDeniedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AccessDeniedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Column in configured table that can be used in aggregate function in query.
type AggregateColumn struct {
	_ struct{} `type:"structure"`

	// Column names in configured table of aggregate columns.
	//
	// ColumnNames is a required field
	ColumnNames []*string `locationName:"columnNames" min:"1" type:"list" required:"true"`

	// Aggregation function that can be applied to aggregate column in query.
	//
	// Function is a required field
	Function *string `locationName:"function" type:"string" required:"true" enum:"AggregateFunctionName"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AggregateColumn) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AggregateColumn) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AggregateColumn) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AggregateColumn"}
	if s.ColumnNames == nil {
		invalidParams.Add(request.NewErrParamRequired("ColumnNames"))
	}
	if s.ColumnNames != nil && len(s.ColumnNames) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ColumnNames", 1))
	}
	if s.Function == nil {
		invalidParams.Add(request.NewErrParamRequired("Function"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetColumnNames sets the ColumnNames field's value.
func (s *AggregateColumn) SetColumnNames(v []*string) *AggregateColumn {
	s.ColumnNames = v
	return s
}

// SetFunction sets the Function field's value.
func (s *AggregateColumn) SetFunction(v string) *AggregateColumn {
	s.Function = &v
	return s
}

// Constraint on query output removing output rows that do not meet a minimum
// number of distinct values of a specified column.
type AggregationConstraint struct {
	_ struct{} `type:"structure"`

	// Column in aggregation constraint for which there must be a minimum number
	// of distinct values in an output row for it to be in the query output.
	//
	// ColumnName is a required field
	ColumnName *string `locationName:"columnName" min:"1" type:"string" required:"true"`

	// The minimum number of distinct values that an output row must be an aggregation
	// of. Minimum threshold of distinct values for a specified column that must
	// exist in an output row for it to be in the query output.
	//
	// Minimum is a required field
	Minimum *int64 `locationName:"minimum" min:"2" type:"integer" required:"true"`

	// The type of aggregation the constraint allows. The only valid value is currently
	// `COUNT_DISTINCT`.
	//
	// Type is a required field
	Type *string `locationName:"type" type:"string" required:"true" enum:"AggregationType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AggregationConstraint) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AggregationConstraint) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AggregationConstraint) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AggregationConstraint"}
	if s.ColumnName == nil {
		invalidParams.Add(request.NewErrParamRequired("ColumnName"))
	}
	if s.ColumnName != nil && len(*s.ColumnName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ColumnName", 1))
	}
	if s.Minimum == nil {
		invalidParams.Add(request.NewErrParamRequired("Minimum"))
	}
	if s.Minimum != nil && *s.Minimum < 2 {
		invalidParams.Add(request.NewErrParamMinValue("Minimum", 2))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetColumnName sets the ColumnName field's value.
func (s *AggregationConstraint) SetColumnName(v string) *AggregationConstraint {
	s.ColumnName = &v
	return s
}

// SetMinimum sets the Minimum field's value.
func (s *AggregationConstraint) SetMinimum(v int64) *AggregationConstraint {
	s.Minimum = &v
	return s
}

// SetType sets the Type field's value.
func (s *AggregationConstraint) SetType(v string) *AggregationConstraint {
	s.Type = &v
	return s
}

// Optional. The member who can query can provide this placeholder for a literal
// data value in an analysis template.
type AnalysisParameter struct {
	_ struct{} `type:"structure" sensitive:"true"`

	// Optional. The default value that is applied in the analysis template. The
	// member who can query can override this value in the query editor.
	DefaultValue *string `locationName:"defaultValue" type:"string"`

	// The name of the parameter. The name must use only alphanumeric, underscore
	// (_), or hyphen (-) characters but cannot start or end with a hyphen.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The type of parameter.
	//
	// Type is a required field
	Type *string `locationName:"type" type:"string" required:"true" enum:"ParameterType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnalysisParameter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnalysisParameter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AnalysisParameter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AnalysisParameter"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDefaultValue sets the DefaultValue field's value.
func (s *AnalysisParameter) SetDefaultValue(v string) *AnalysisParameter {
	s.DefaultValue = &v
	return s
}

// SetName sets the Name field's value.
func (s *AnalysisParameter) SetName(v string) *AnalysisParameter {
	s.Name = &v
	return s
}

// SetType sets the Type field's value.
func (s *AnalysisParameter) SetType(v string) *AnalysisParameter {
	s.Type = &v
	return s
}

// A specification about how data from the configured table can be used in a
// query.
type AnalysisRule struct {
	_ struct{} `type:"structure"`

	// The unique ID for the associated collaboration.
	//
	// CollaborationId is a required field
	CollaborationId *string `locationName:"collaborationId" min:"36" type:"string" required:"true"`

	// The time the analysis rule was created.
	//
	// CreateTime is a required field
	CreateTime *time.Time `locationName:"createTime" type:"timestamp" required:"true"`

	// The name for the analysis rule.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// A policy that describes the associated data usage limitations.
	//
	// Policy is a required field
	Policy *AnalysisRulePolicy `locationName:"policy" type:"structure" required:"true"`

	// The type of analysis rule.
	//
	// Type is a required field
	Type *string `locationName:"type" type:"string" required:"true" enum:"AnalysisRuleType"`

	// The time the analysis rule was last updated.
	//
	// UpdateTime is a required field
	UpdateTime *time.Time `locationName:"updateTime" type:"timestamp" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnalysisRule) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnalysisRule) GoString() string {
	return s.String()
}

// SetCollaborationId sets the CollaborationId field's value.
func (s *AnalysisRule) SetCollaborationId(v string) *AnalysisRule {
	s.CollaborationId = &v
	return s
}

// SetCreateTime sets the CreateTime field's value.
func (s *AnalysisRule) SetCreateTime(v time.Time) *AnalysisRule {
	s.CreateTime = &v
	return s
}

// SetName sets the Name field's value.
func (s *AnalysisRule) SetName(v string) *AnalysisRule {
	s.Name = &v
	return s
}

// SetPolicy sets the Policy field's value.
func (s *AnalysisRule) SetPolicy(v *AnalysisRulePolicy) *AnalysisRule {
	s.Policy = v
	return s
}

// SetType sets the Type field's value.
func (s *AnalysisRule) SetType(v string) *AnalysisRule {
	s.Type = &v
	return s
}

// SetUpdateTime sets the UpdateTime field's value.
func (s *AnalysisRule) SetUpdateTime(v time.Time) *AnalysisRule {
	s.UpdateTime = &v
	return s
}

// A type of analysis rule that enables query structure and specified queries
// that produce aggregate statistics.
type AnalysisRuleAggregation struct {
	_ struct{} `type:"structure"`

	// The columns that query runners are allowed to use in aggregation queries.
	//
	// AggregateColumns is a required field
	AggregateColumns []*AggregateColumn `locationName:"aggregateColumns" min:"1" type:"list" required:"true"`

	// Which logical operators (if any) are to be used in an INNER JOIN match condition.
	// Default is AND.
	AllowedJoinOperators []*string `locationName:"allowedJoinOperators" type:"list" enum:"JoinOperator"`

	// The columns that query runners are allowed to select, group by, or filter
	// by.
	//
	// DimensionColumns is a required field
	DimensionColumns []*string `locationName:"dimensionColumns" type:"list" required:"true"`

	// Columns in configured table that can be used in join statements and/or as
	// aggregate columns. They can never be outputted directly.
	//
	// JoinColumns is a required field
	JoinColumns []*string `locationName:"joinColumns" type:"list" required:"true"`

	// Control that requires member who runs query to do a join with their configured
	// table and/or other configured table in query.
	JoinRequired *string `locationName:"joinRequired" type:"string" enum:"JoinRequiredOption"`

	// Columns that must meet a specific threshold value (after an aggregation function
	// is applied to it) for each output row to be returned.
	//
	// OutputConstraints is a required field
	OutputConstraints []*AggregationConstraint `locationName:"outputConstraints" min:"1" type:"list" required:"true"`

	// Set of scalar functions that are allowed to be used on dimension columns
	// and the output of aggregation of metrics.
	//
	// ScalarFunctions is a required field
	ScalarFunctions []*string `locationName:"scalarFunctions" type:"list" required:"true" enum:"ScalarFunctions"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnalysisRuleAggregation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnalysisRuleAggregation) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AnalysisRuleAggregation) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AnalysisRuleAggregation"}
	if s.AggregateColumns == nil {
		invalidParams.Add(request.NewErrParamRequired("AggregateColumns"))
	}
	if s.AggregateColumns != nil && len(s.AggregateColumns) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AggregateColumns", 1))
	}
	if s.DimensionColumns == nil {
		invalidParams.Add(request.NewErrParamRequired("DimensionColumns"))
	}
	if s.JoinColumns == nil {
		invalidParams.Add(request.NewErrParamRequired("JoinColumns"))
	}
	if s.OutputConstraints == nil {
		invalidParams.Add(request.NewErrParamRequired("OutputConstraints"))
	}
	if s.OutputConstraints != nil && len(s.OutputConstraints) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("OutputConstraints", 1))
	}
	if s.ScalarFunctions == nil {
		invalidParams.Add(request.NewErrParamRequired("ScalarFunctions"))
	}
	if s.AggregateColumns != nil {
		for i, v := range s.AggregateColumns {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "AggregateColumns", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.OutputConstraints != nil {
		for i, v := range s.OutputConstraints {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "OutputConstraints", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAggregateColumns sets the AggregateColumns field's value.
func (s *AnalysisRuleAggregation) SetAggregateColumns(v []*AggregateColumn) *AnalysisRuleAggregation {
	s.AggregateColumns = v
	return s
}

// SetAllowedJoinOperators sets the AllowedJoinOperators field's value.
func (s *AnalysisRuleAggregation) SetAllowedJoinOperators(v []*string) *AnalysisRuleAggregation {
	s.AllowedJoinOperators = v
	return s
}

// SetDimensionColumns sets the DimensionColumns field's value.
func (s *AnalysisRuleAggregation) SetDimensionColumns(v []*string) *AnalysisRuleAggregation {
	s.DimensionColumns = v
	return s
}

// SetJoinColumns sets the JoinColumns field's value.
func (s *AnalysisRuleAggregation) SetJoinColumns(v []*string) *AnalysisRuleAggregation {
	s.JoinColumns = v
	return s
}

// SetJoinRequired sets the JoinRequired field's value.
func (s *AnalysisRuleAggregation) SetJoinRequired(v string) *AnalysisRuleAggregation {
	s.JoinRequired = &v
	return s
}

// SetOutputConstraints sets the OutputConstraints field's value.
func (s *AnalysisRuleAggregation) SetOutputConstraints(v []*AggregationConstraint) *AnalysisRuleAggregation {
	s.OutputConstraints = v
	return s
}

// SetScalarFunctions sets the ScalarFunctions field's value.
func (s *AnalysisRuleAggregation) SetScalarFunctions(v []*string) *AnalysisRuleAggregation {
	s.ScalarFunctions = v
	return s
}

// A type of analysis rule that enables the table owner to approve custom SQL
// queries on their configured tables. It supports differential privacy.
type AnalysisRuleCustom struct {
	_ struct{} `type:"structure"`

	// The ARN of the analysis templates that are allowed by the custom analysis
	// rule.
	//
	// AllowedAnalyses is a required field
	AllowedAnalyses []*string `locationName:"allowedAnalyses" type:"list" required:"true"`

	// The IDs of the Amazon Web Services accounts that are allowed to query by
	// the custom analysis rule. Required when allowedAnalyses is ANY_QUERY.
	AllowedAnalysisProviders []*string `locationName:"allowedAnalysisProviders" type:"list"`

	// The differential privacy configuration.
	DifferentialPrivacy *DifferentialPrivacyConfiguration `locationName:"differentialPrivacy" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnalysisRuleCustom) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnalysisRuleCustom) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AnalysisRuleCustom) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AnalysisRuleCustom"}
	if s.AllowedAnalyses == nil {
		invalidParams.Add(request.NewErrParamRequired("AllowedAnalyses"))
	}
	if s.DifferentialPrivacy != nil {
		if err := s.DifferentialPrivacy.Validate(); err != nil {
			invalidParams.AddNested("DifferentialPrivacy", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAllowedAnalyses sets the AllowedAnalyses field's value.
func (s *AnalysisRuleCustom) SetAllowedAnalyses(v []*string) *AnalysisRuleCustom {
	s.AllowedAnalyses = v
	return s
}

// SetAllowedAnalysisProviders sets the AllowedAnalysisProviders field's value.
func (s *AnalysisRuleCustom) SetAllowedAnalysisProviders(v []*string) *AnalysisRuleCustom {
	s.AllowedAnalysisProviders = v
	return s
}

// SetDifferentialPrivacy sets the DifferentialPrivacy field's value.
func (s *AnalysisRuleCustom) SetDifferentialPrivacy(v *DifferentialPrivacyConfiguration) *AnalysisRuleCustom {
	s.DifferentialPrivacy = v
	return s
}

// Defines details for the analysis rule ID mapping table.
type AnalysisRuleIdMappingTable struct {
	_ struct{} `type:"structure"`

	// The columns that query runners are allowed to select, group by, or filter
	// by.
	DimensionColumns []*string `locationName:"dimensionColumns" type:"list"`

	// The columns that query runners are allowed to use in an INNER JOIN statement.
	//
	// JoinColumns is a required field
	JoinColumns []*string `locationName:"joinColumns" min:"2" type:"list" required:"true"`

	// The query constraints of the analysis rule ID mapping table.
	//
	// QueryConstraints is a required field
	QueryConstraints []*QueryConstraint `locationName:"queryConstraints" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnalysisRuleIdMappingTable) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnalysisRuleIdMappingTable) GoString() string {
	return s.String()
}

// SetDimensionColumns sets the DimensionColumns field's value.
func (s *AnalysisRuleIdMappingTable) SetDimensionColumns(v []*string) *AnalysisRuleIdMappingTable {
	s.DimensionColumns = v
	return s
}

// SetJoinColumns sets the JoinColumns field's value.
func (s *AnalysisRuleIdMappingTable) SetJoinColumns(v []*string) *AnalysisRuleIdMappingTable {
	s.JoinColumns = v
	return s
}

// SetQueryConstraints sets the QueryConstraints field's value.
func (s *AnalysisRuleIdMappingTable) SetQueryConstraints(v []*QueryConstraint) *AnalysisRuleIdMappingTable {
	s.QueryConstraints = v
	return s
}

// A type of analysis rule that enables row-level analysis.
type AnalysisRuleList struct {
	_ struct{} `type:"structure"`

	// The logical operators (if any) that are to be used in an INNER JOIN match
	// condition. Default is AND.
	AllowedJoinOperators []*string `locationName:"allowedJoinOperators" type:"list" enum:"JoinOperator"`

	// Columns that can be used to join a configured table with the table of the
	// member who can query and other members' configured tables.
	//
	// JoinColumns is a required field
	JoinColumns []*string `locationName:"joinColumns" min:"1" type:"list" required:"true"`

	// Columns that can be listed in the output.
	//
	// ListColumns is a required field
	ListColumns []*string `locationName:"listColumns" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnalysisRuleList) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnalysisRuleList) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AnalysisRuleList) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AnalysisRuleList"}
	if s.JoinColumns == nil {
		invalidParams.Add(request.NewErrParamRequired("JoinColumns"))
	}
	if s.JoinColumns != nil && len(s.JoinColumns) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JoinColumns", 1))
	}
	if s.ListColumns == nil {
		invalidParams.Add(request.NewErrParamRequired("ListColumns"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAllowedJoinOperators sets the AllowedJoinOperators field's value.
func (s *AnalysisRuleList) SetAllowedJoinOperators(v []*string) *AnalysisRuleList {
	s.AllowedJoinOperators = v
	return s
}

// SetJoinColumns sets the JoinColumns field's value.
func (s *AnalysisRuleList) SetJoinColumns(v []*string) *AnalysisRuleList {
	s.JoinColumns = v
	return s
}

// SetListColumns sets the ListColumns field's value.
func (s *AnalysisRuleList) SetListColumns(v []*string) *AnalysisRuleList {
	s.ListColumns = v
	return s
}

// Controls on the query specifications that can be run on configured table.
type AnalysisRulePolicy struct {
	_ struct{} `type:"structure"`

	// Controls on the query specifications that can be run on configured table.
	V1 *AnalysisRulePolicyV1 `locationName:"v1" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnalysisRulePolicy) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnalysisRulePolicy) GoString() string {
	return s.String()
}

// SetV1 sets the V1 field's value.
func (s *AnalysisRulePolicy) SetV1(v *AnalysisRulePolicyV1) *AnalysisRulePolicy {
	s.V1 = v
	return s
}

// Controls on the query specifications that can be run on configured table.
type AnalysisRulePolicyV1 struct {
	_ struct{} `type:"structure"`

	// Analysis rule type that enables only aggregation queries on a configured
	// table.
	Aggregation *AnalysisRuleAggregation `locationName:"aggregation" type:"structure"`

	// Analysis rule type that enables custom SQL queries on a configured table.
	Custom *AnalysisRuleCustom `locationName:"custom" type:"structure"`

	// The ID mapping table.
	IdMappingTable *AnalysisRuleIdMappingTable `locationName:"idMappingTable" type:"structure"`

	// Analysis rule type that enables only list queries on a configured table.
	List *AnalysisRuleList `locationName:"list" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnalysisRulePolicyV1) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnalysisRulePolicyV1) GoString() string {
	return s.String()
}

// SetAggregation sets the Aggregation field's value.
func (s *AnalysisRulePolicyV1) SetAggregation(v *AnalysisRuleAggregation) *AnalysisRulePolicyV1 {
	s.Aggregation = v
	return s
}

// SetCustom sets the Custom field's value.
func (s *AnalysisRulePolicyV1) SetCustom(v *AnalysisRuleCustom) *AnalysisRulePolicyV1 {
	s.Custom = v
	return s
}

// SetIdMappingTable sets the IdMappingTable field's value.
func (s *AnalysisRulePolicyV1) SetIdMappingTable(v *AnalysisRuleIdMappingTable) *AnalysisRulePolicyV1 {
	s.IdMappingTable = v
	return s
}

// SetList sets the List field's value.
func (s *AnalysisRulePolicyV1) SetList(v *AnalysisRuleList) *AnalysisRulePolicyV1 {
	s.List = v
	return s
}

// A relation within an analysis.
type AnalysisSchema struct {
	_ struct{} `type:"structure"`

	// The tables referenced in the analysis schema.
	ReferencedTables []*string `locationName:"referencedTables" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnalysisSchema) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnalysisSchema) GoString() string {
	return s.String()
}

// SetReferencedTables sets the ReferencedTables field's value.
func (s *AnalysisSchema) SetReferencedTables(v []*string) *AnalysisSchema {
	s.ReferencedTables = v
	return s
}

// The structure that defines the body of the analysis template.
type AnalysisSource struct {
	_ struct{} `type:"structure" sensitive:"true"`

	// The query text.
	Text *string `locationName:"text" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnalysisSource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnalysisSource) GoString() string {
	return s.String()
}

// SetText sets the Text field's value.
func (s *AnalysisSource) SetText(v string) *AnalysisSource {
	s.Text = &v
	return s
}

// The analysis template.
type AnalysisTemplate struct {
	_ struct{} `type:"structure"`

	// The parameters of the analysis template.
	AnalysisParameters []*AnalysisParameter `locationName:"analysisParameters" type:"list" sensitive:"true"`

	// The Amazon Resource Name (ARN) of the analysis template.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" type:"string" required:"true"`

	// The unique ARN for the analysis template’s associated collaboration.
	//
	// CollaborationArn is a required field
	CollaborationArn *string `locationName:"collaborationArn" type:"string" required:"true"`

	// The unique ID for the associated collaboration of the analysis template.
	//
	// CollaborationId is a required field
	CollaborationId *string `locationName:"collaborationId" min:"36" type:"string" required:"true"`

	// The time that the analysis template was created.
	//
	// CreateTime is a required field
	CreateTime *time.Time `locationName:"createTime" type:"timestamp" required:"true"`

	// The description of the analysis template.
	Description *string `locationName:"description" type:"string"`

	// The format of the analysis template.
	//
	// Format is a required field
	Format *string `locationName:"format" type:"string" required:"true" enum:"AnalysisFormat"`

	// The identifier for the analysis template.
	//
	// Id is a required field
	Id *string `locationName:"id" min:"36" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the member who created the analysis template.
	//
	// MembershipArn is a required field
	MembershipArn *string `locationName:"membershipArn" type:"string" required:"true"`

	// The identifier of a member who created the analysis template.
	//
	// MembershipId is a required field
	MembershipId *string `locationName:"membershipId" min:"36" type:"string" required:"true"`

	// The name of the analysis template.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// The entire schema object.
	//
	// Schema is a required field
	Schema *AnalysisSchema `locationName:"schema" type:"structure" required:"true"`

	// The source of the analysis template.
	//
	// Source is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by AnalysisTemplate's
	// String and GoString methods.
	//
	// Source is a required field
	Source *AnalysisSource `locationName:"source" type:"structure" required:"true" sensitive:"true"`

	// The time that the analysis template was last updated.
	//
	// UpdateTime is a required field
	UpdateTime *time.Time `locationName:"updateTime" type:"timestamp" required:"true"`

	// Information about the validations performed on the analysis template.
	Validations []*AnalysisTemplateValidationStatusDetail `locationName:"validations" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnalysisTemplate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnalysisTemplate) GoString() string {
	return s.String()
}

// SetAnalysisParameters sets the AnalysisParameters field's value.
func (s *AnalysisTemplate) SetAnalysisParameters(v []*AnalysisParameter) *AnalysisTemplate {
	s.AnalysisParameters = v
	return s
}

// SetArn sets the Arn field's value.
func (s *AnalysisTemplate) SetArn(v string) *AnalysisTemplate {
	s.Arn = &v
	return s
}

// SetCollaborationArn sets the CollaborationArn field's value.
func (s *AnalysisTemplate) SetCollaborationArn(v string) *AnalysisTemplate {
	s.CollaborationArn = &v
	return s
}

// SetCollaborationId sets the CollaborationId field's value.
func (s *AnalysisTemplate) SetCollaborationId(v string) *AnalysisTemplate {
	s.CollaborationId = &v
	return s
}

// SetCreateTime sets the CreateTime field's value.
func (s *AnalysisTemplate) SetCreateTime(v time.Time) *AnalysisTemplate {
	s.CreateTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *AnalysisTemplate) SetDescription(v string) *AnalysisTemplate {
	s.Description = &v
	return s
}

// SetFormat sets the Format field's value.
func (s *AnalysisTemplate) SetFormat(v string) *AnalysisTemplate {
	s.Format = &v
	return s
}

// SetId sets the Id field's value.
func (s *AnalysisTemplate) SetId(v string) *AnalysisTemplate {
	s.Id = &v
	return s
}

// SetMembershipArn sets the MembershipArn field's value.
func (s *AnalysisTemplate) SetMembershipArn(v string) *AnalysisTemplate {
	s.MembershipArn = &v
	return s
}

// SetMembershipId sets the MembershipId field's value.
func (s *AnalysisTemplate) SetMembershipId(v string) *AnalysisTemplate {
	s.MembershipId = &v
	return s
}

// SetName sets the Name field's value.
func (s *AnalysisTemplate) SetName(v string) *AnalysisTemplate {
	s.Name = &v
	return s
}

// SetSchema sets the Schema field's value.
func (s *AnalysisTemplate) SetSchema(v *AnalysisSchema) *AnalysisTemplate {
	s.Schema = v
	return s
}

// SetSource sets the Source field's value.
func (s *AnalysisTemplate) SetSource(v *AnalysisSource) *AnalysisTemplate {
	s.Source = v
	return s
}

// SetUpdateTime sets the UpdateTime field's value.
func (s *AnalysisTemplate) SetUpdateTime(v time.Time) *AnalysisTemplate {
	s.UpdateTime = &v
	return s
}

// SetValidations sets the Validations field's value.
func (s *AnalysisTemplate) SetValidations(v []*AnalysisTemplateValidationStatusDetail) *AnalysisTemplate {
	s.Validations = v
	return s
}

// The metadata of the analysis template.
type AnalysisTemplateSummary struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the analysis template.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" type:"string" required:"true"`

	// The unique ARN for the analysis template summary’s associated collaboration.
	//
	// CollaborationArn is a required field
	CollaborationArn *string `locationName:"collaborationArn" type:"string" required:"true"`

	// A unique identifier for the collaboration that the analysis template summary
	// belongs to. Currently accepts collaboration ID.
	//
	// CollaborationId is a required field
	CollaborationId *string `locationName:"collaborationId" min:"36" type:"string" required:"true"`

	// The time that the analysis template summary was created.
	//
	// CreateTime is a required field
	CreateTime *time.Time `locationName:"createTime" type:"timestamp" required:"true"`

	// The description of the analysis template.
	Description *string `locationName:"description" type:"string"`

	// The identifier of the analysis template.
	//
	// Id is a required field
	Id *string `locationName:"id" min:"36" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the member who created the analysis template.
	//
	// MembershipArn is a required field
	MembershipArn *string `locationName:"membershipArn" type:"string" required:"true"`

	// The identifier for a membership resource.
	//
	// MembershipId is a required field
	MembershipId *string `locationName:"membershipId" min:"36" type:"string" required:"true"`

	// The name of the analysis template.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// The time that the analysis template summary was last updated.
	//
	// UpdateTime is a required field
	UpdateTime *time.Time `locationName:"updateTime" type:"timestamp" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnalysisTemplateSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnalysisTemplateSummary) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *AnalysisTemplateSummary) SetArn(v string) *AnalysisTemplateSummary {
	s.Arn = &v
	return s
}

// SetCollaborationArn sets the CollaborationArn field's value.
func (s *AnalysisTemplateSummary) SetCollaborationArn(v string) *AnalysisTemplateSummary {
	s.CollaborationArn = &v
	return s
}

// SetCollaborationId sets the CollaborationId field's value.
func (s *AnalysisTemplateSummary) SetCollaborationId(v string) *AnalysisTemplateSummary {
	s.CollaborationId = &v
	return s
}

// SetCreateTime sets the CreateTime field's value.
func (s *AnalysisTemplateSummary) SetCreateTime(v time.Time) *AnalysisTemplateSummary {
	s.CreateTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *AnalysisTemplateSummary) SetDescription(v string) *AnalysisTemplateSummary {
	s.Description = &v
	return s
}

// SetId sets the Id field's value.
func (s *AnalysisTemplateSummary) SetId(v string) *AnalysisTemplateSummary {
	s.Id = &v
	return s
}

// SetMembershipArn sets the MembershipArn field's value.
func (s *AnalysisTemplateSummary) SetMembershipArn(v string) *AnalysisTemplateSummary {
	s.MembershipArn = &v
	return s
}

// SetMembershipId sets the MembershipId field's value.
func (s *AnalysisTemplateSummary) SetMembershipId(v string) *AnalysisTemplateSummary {
	s.MembershipId = &v
	return s
}

// SetName sets the Name field's value.
func (s *AnalysisTemplateSummary) SetName(v string) *AnalysisTemplateSummary {
	s.Name = &v
	return s
}

// SetUpdateTime sets the UpdateTime field's value.
func (s *AnalysisTemplateSummary) SetUpdateTime(v time.Time) *AnalysisTemplateSummary {
	s.UpdateTime = &v
	return s
}

// The status details of the analysis template validation. Clean Rooms Differential
// Privacy uses a general-purpose query structure to support complex SQL queries
// and validates whether an analysis template fits that general-purpose query
// structure. Validation is performed when analysis templates are created and
// fetched. Because analysis templates are immutable by design, we recommend
// that you create analysis templates after you associate the configured tables
// with their analysis rule to your collaboration.
//
// For more information, see https://docs.aws.amazon.com/clean-rooms/latest/userguide/analysis-rules-custom.html#custom-diff-privacy
// (https://docs.aws.amazon.com/clean-rooms/latest/userguide/analysis-rules-custom.html#custom-diff-privacy).
type AnalysisTemplateValidationStatusDetail struct {
	_ struct{} `type:"structure"`

	// The reasons for the validation results.
	Reasons []*AnalysisTemplateValidationStatusReason `locationName:"reasons" type:"list"`

	// The status of the validation.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"AnalysisTemplateValidationStatus"`

	// The type of validation that was performed.
	//
	// Type is a required field
	Type *string `locationName:"type" type:"string" required:"true" enum:"AnalysisTemplateValidationType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnalysisTemplateValidationStatusDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnalysisTemplateValidationStatusDetail) GoString() string {
	return s.String()
}

// SetReasons sets the Reasons field's value.
func (s *AnalysisTemplateValidationStatusDetail) SetReasons(v []*AnalysisTemplateValidationStatusReason) *AnalysisTemplateValidationStatusDetail {
	s.Reasons = v
	return s
}

// SetStatus sets the Status field's value.
func (s *AnalysisTemplateValidationStatusDetail) SetStatus(v string) *AnalysisTemplateValidationStatusDetail {
	s.Status = &v
	return s
}

// SetType sets the Type field's value.
func (s *AnalysisTemplateValidationStatusDetail) SetType(v string) *AnalysisTemplateValidationStatusDetail {
	s.Type = &v
	return s
}

// The reasons for the validation results.
type AnalysisTemplateValidationStatusReason struct {
	_ struct{} `type:"structure"`

	// The validation message.
	//
	// Message is a required field
	Message *string `locationName:"message" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnalysisTemplateValidationStatusReason) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnalysisTemplateValidationStatusReason) GoString() string {
	return s.String()
}

// SetMessage sets the Message field's value.
func (s *AnalysisTemplateValidationStatusReason) SetMessage(v string) *AnalysisTemplateValidationStatusReason {
	s.Message = &v
	return s
}

// Details of errors thrown by the call to retrieve multiple analysis templates
// within a collaboration by their identifiers.
type BatchGetCollaborationAnalysisTemplateError struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the analysis template.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" type:"string" required:"true"`

	// An error code for the error.
	//
	// Code is a required field
	Code *string `locationName:"code" type:"string" required:"true"`

	// A description of why the call failed.
	//
	// Message is a required field
	Message *string `locationName:"message" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchGetCollaborationAnalysisTemplateError) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchGetCollaborationAnalysisTemplateError) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *BatchGetCollaborationAnalysisTemplateError) SetArn(v string) *BatchGetCollaborationAnalysisTemplateError {
	s.Arn = &v
	return s
}

// SetCode sets the Code field's value.
func (s *BatchGetCollaborationAnalysisTemplateError) SetCode(v string) *BatchGetCollaborationAnalysisTemplateError {
	s.Code = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *BatchGetCollaborationAnalysisTemplateError) SetMessage(v string) *BatchGetCollaborationAnalysisTemplateError {
	s.Message = &v
	return s
}

type BatchGetCollaborationAnalysisTemplateInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) associated with the analysis template within
	// a collaboration.
	//
	// AnalysisTemplateArns is a required field
	AnalysisTemplateArns []*string `locationName:"analysisTemplateArns" min:"1" type:"list" required:"true"`

	// A unique identifier for the collaboration that the analysis templates belong
	// to. Currently accepts collaboration ID.
	//
	// CollaborationIdentifier is a required field
	CollaborationIdentifier *string `location:"uri" locationName:"collaborationIdentifier" min:"36" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchGetCollaborationAnalysisTemplateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchGetCollaborationAnalysisTemplateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchGetCollaborationAnalysisTemplateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchGetCollaborationAnalysisTemplateInput"}
	if s.AnalysisTemplateArns == nil {
		invalidParams.Add(request.NewErrParamRequired("AnalysisTemplateArns"))
	}
	if s.AnalysisTemplateArns != nil && len(s.AnalysisTemplateArns) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AnalysisTemplateArns", 1))
	}
	if s.CollaborationIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("CollaborationIdentifier"))
	}
	if s.CollaborationIdentifier != nil && len(*s.CollaborationIdentifier) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("CollaborationIdentifier", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAnalysisTemplateArns sets the AnalysisTemplateArns field's value.
func (s *BatchGetCollaborationAnalysisTemplateInput) SetAnalysisTemplateArns(v []*string) *BatchGetCollaborationAnalysisTemplateInput {
	s.AnalysisTemplateArns = v
	return s
}

// SetCollaborationIdentifier sets the CollaborationIdentifier field's value.
func (s *BatchGetCollaborationAnalysisTemplateInput) SetCollaborationIdentifier(v string) *BatchGetCollaborationAnalysisTemplateInput {
	s.CollaborationIdentifier = &v
	return s
}

type BatchGetCollaborationAnalysisTemplateOutput struct {
	_ struct{} `type:"structure"`

	// The retrieved list of analysis templates within a collaboration.
	//
	// CollaborationAnalysisTemplates is a required field
	CollaborationAnalysisTemplates []*CollaborationAnalysisTemplate `locationName:"collaborationAnalysisTemplates" type:"list" required:"true"`

	// Error reasons for collaboration analysis templates that could not be retrieved.
	// One error is returned for every collaboration analysis template that could
	// not be retrieved.
	//
	// Errors is a required field
	Errors []*BatchGetCollaborationAnalysisTemplateError `locationName:"errors" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchGetCollaborationAnalysisTemplateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchGetCollaborationAnalysisTemplateOutput) GoString() string {
	return s.String()
}

// SetCollaborationAnalysisTemplates sets the CollaborationAnalysisTemplates field's value.
func (s *BatchGetCollaborationAnalysisTemplateOutput) SetCollaborationAnalysisTemplates(v []*CollaborationAnalysisTemplate) *BatchGetCollaborationAnalysisTemplateOutput {
	s.CollaborationAnalysisTemplates = v
	return s
}

// SetErrors sets the Errors field's value.
func (s *BatchGetCollaborationAnalysisTemplateOutput) SetErrors(v []*BatchGetCollaborationAnalysisTemplateError) *BatchGetCollaborationAnalysisTemplateOutput {
	s.Errors = v
	return s
}

// An error that describes why a schema could not be fetched.
type BatchGetSchemaAnalysisRuleError struct {
	_ struct{} `type:"structure"`

	// An error code for the error.
	//
	// Code is a required field
	Code *string `locationName:"code" type:"string" required:"true"`

	// A description of why the call failed.
	//
	// Message is a required field
	Message *string `locationName:"message" type:"string" required:"true"`

	// An error name for the error.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// The analysis rule type.
	//
	// Type is a required field
	Type *string `locationName:"type" type:"string" required:"true" enum:"AnalysisRuleType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchGetSchemaAnalysisRuleError) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchGetSchemaAnalysisRuleError) GoString() string {
	return s.String()
}

// SetCode sets the Code field's value.
func (s *BatchGetSchemaAnalysisRuleError) SetCode(v string) *BatchGetSchemaAnalysisRuleError {
	s.Code = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *BatchGetSchemaAnalysisRuleError) SetMessage(v string) *BatchGetSchemaAnalysisRuleError {
	s.Message = &v
	return s
}

// SetName sets the Name field's value.
func (s *BatchGetSchemaAnalysisRuleError) SetName(v string) *BatchGetSchemaAnalysisRuleError {
	s.Name = &v
	return s
}

// SetType sets the Type field's value.
func (s *BatchGetSchemaAnalysisRuleError) SetType(v string) *BatchGetSchemaAnalysisRuleError {
	s.Type = &v
	return s
}

type BatchGetSchemaAnalysisRuleInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the collaboration that contains the schema analysis
	// rule.
	//
	// CollaborationIdentifier is a required field
	CollaborationIdentifier *string `location:"uri" locationName:"collaborationIdentifier" min:"36" type:"string" required:"true"`

	// The information that's necessary to retrieve a schema analysis rule.
	//
	// SchemaAnalysisRuleRequests is a required field
	SchemaAnalysisRuleRequests []*SchemaAnalysisRuleRequest `locationName:"schemaAnalysisRuleRequests" min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchGetSchemaAnalysisRuleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchGetSchemaAnalysisRuleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchGetSchemaAnalysisRuleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchGetSchemaAnalysisRuleInput"}
	if s.CollaborationIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("CollaborationIdentifier"))
	}
	if s.CollaborationIdentifier != nil && len(*s.CollaborationIdentifier) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("CollaborationIdentifier", 36))
	}
	if s.SchemaAnalysisRuleRequests == nil {
		invalidParams.Add(request.NewErrParamRequired("SchemaAnalysisRuleRequests"))
	}
	if s.SchemaAnalysisRuleRequests != nil && len(s.SchemaAnalysisRuleRequests) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SchemaAnalysisRuleRequests", 1))
	}
	if s.SchemaAnalysisRuleRequests != nil {
		for i, v := range s.SchemaAnalysisRuleRequests {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "SchemaAnalysisRuleRequests", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCollaborationIdentifier sets the CollaborationIdentifier field's value.
func (s *BatchGetSchemaAnalysisRuleInput) SetCollaborationIdentifier(v string) *BatchGetSchemaAnalysisRuleInput {
	s.CollaborationIdentifier = &v
	return s
}

// SetSchemaAnalysisRuleRequests sets the SchemaAnalysisRuleRequests field's value.
func (s *BatchGetSchemaAnalysisRuleInput) SetSchemaAnalysisRuleRequests(v []*SchemaAnalysisRuleRequest) *BatchGetSchemaAnalysisRuleInput {
	s.SchemaAnalysisRuleRequests = v
	return s
}

type BatchGetSchemaAnalysisRuleOutput struct {
	_ struct{} `type:"structure"`

	// The retrieved list of analysis rules.
	//
	// AnalysisRules is a required field
	AnalysisRules []*AnalysisRule `locationName:"analysisRules" type:"list" required:"true"`

	// Error reasons for schemas that could not be retrieved. One error is returned
	// for every schema that could not be retrieved.
	//
	// Errors is a required field
	Errors []*BatchGetSchemaAnalysisRuleError `locationName:"errors" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchGetSchemaAnalysisRuleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchGetSchemaAnalysisRuleOutput) GoString() string {
	return s.String()
}

// SetAnalysisRules sets the AnalysisRules field's value.
func (s *BatchGetSchemaAnalysisRuleOutput) SetAnalysisRules(v []*AnalysisRule) *BatchGetSchemaAnalysisRuleOutput {
	s.AnalysisRules = v
	return s
}

// SetErrors sets the Errors field's value.
func (s *BatchGetSchemaAnalysisRuleOutput) SetErrors(v []*BatchGetSchemaAnalysisRuleError) *BatchGetSchemaAnalysisRuleOutput {
	s.Errors = v
	return s
}

// An error describing why a schema could not be fetched.
type BatchGetSchemaError struct {
	_ struct{} `type:"structure"`

	// An error code for the error.
	//
	// Code is a required field
	Code *string `locationName:"code" type:"string" required:"true"`

	// An error message for the error.
	//
	// Message is a required field
	Message *string `locationName:"message" type:"string" required:"true"`

	// An error name for the error.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchGetSchemaError) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchGetSchemaError) GoString() string {
	return s.String()
}

// SetCode sets the Code field's value.
func (s *BatchGetSchemaError) SetCode(v string) *BatchGetSchemaError {
	s.Code = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *BatchGetSchemaError) SetMessage(v string) *BatchGetSchemaError {
	s.Message = &v
	return s
}

// SetName sets the Name field's value.
func (s *BatchGetSchemaError) SetName(v string) *BatchGetSchemaError {
	s.Name = &v
	return s
}

type BatchGetSchemaInput struct {
	_ struct{} `type:"structure"`

	// A unique identifier for the collaboration that the schemas belong to. Currently
	// accepts collaboration ID.
	//
	// CollaborationIdentifier is a required field
	CollaborationIdentifier *string `location:"uri" locationName:"collaborationIdentifier" min:"36" type:"string" required:"true"`

	// The names for the schema objects to retrieve.
	//
	// Names is a required field
	Names []*string `locationName:"names" min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchGetSchemaInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchGetSchemaInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchGetSchemaInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchGetSchemaInput"}
	if s.CollaborationIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("CollaborationIdentifier"))
	}
	if s.CollaborationIdentifier != nil && len(*s.CollaborationIdentifier) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("CollaborationIdentifier", 36))
	}
	if s.Names == nil {
		invalidParams.Add(request.NewErrParamRequired("Names"))
	}
	if s.Names != nil && len(s.Names) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Names", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCollaborationIdentifier sets the CollaborationIdentifier field's value.
func (s *BatchGetSchemaInput) SetCollaborationIdentifier(v string) *BatchGetSchemaInput {
	s.CollaborationIdentifier = &v
	return s
}

// SetNames sets the Names field's value.
func (s *BatchGetSchemaInput) SetNames(v []*string) *BatchGetSchemaInput {
	s.Names = v
	return s
}

type BatchGetSchemaOutput struct {
	_ struct{} `type:"structure"`

	// Error reasons for schemas that could not be retrieved. One error is returned
	// for every schema that could not be retrieved.
	//
	// Errors is a required field
	Errors []*BatchGetSchemaError `locationName:"errors" type:"list" required:"true"`

	// The retrieved list of schemas.
	//
	// Schemas is a required field
	Schemas []*Schema `locationName:"schemas" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchGetSchemaOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchGetSchemaOutput) GoString() string {
	return s.String()
}

// SetErrors sets the Errors field's value.
func (s *BatchGetSchemaOutput) SetErrors(v []*BatchGetSchemaError) *BatchGetSchemaOutput {
	s.Errors = v
	return s
}

// SetSchemas sets the Schemas field's value.
func (s *BatchGetSchemaOutput) SetSchemas(v []*Schema) *BatchGetSchemaOutput {
	s.Schemas = v
	return s
}

// The multi-party data share environment. The collaboration contains metadata
// about its purpose and participants.
type Collaboration struct {
	_ struct{} `type:"structure"`

	// The unique ARN for the collaboration.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" type:"string" required:"true"`

	// The time when the collaboration was created.
	//
	// CreateTime is a required field
	CreateTime *time.Time `locationName:"createTime" type:"timestamp" required:"true"`

	// The identifier used to reference members of the collaboration. Currently
	// only supports Amazon Web Services account ID.
	//
	// CreatorAccountId is a required field
	CreatorAccountId *string `locationName:"creatorAccountId" min:"12" type:"string" required:"true"`

	// A display name of the collaboration creator.
	//
	// CreatorDisplayName is a required field
	CreatorDisplayName *string `locationName:"creatorDisplayName" min:"1" type:"string" required:"true"`

	// The settings for client-side encryption for cryptographic computing.
	DataEncryptionMetadata *DataEncryptionMetadata `locationName:"dataEncryptionMetadata" type:"structure"`

	// A description of the collaboration provided by the collaboration owner.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The unique ID for the collaboration.
	//
	// Id is a required field
	Id *string `locationName:"id" min:"36" type:"string" required:"true"`

	// The status of a member in a collaboration.
	//
	// MemberStatus is a required field
	MemberStatus *string `locationName:"memberStatus" type:"string" required:"true" enum:"MemberStatus"`

	// The unique ARN for your membership within the collaboration.
	MembershipArn *string `locationName:"membershipArn" type:"string"`

	// The unique ID for your membership within the collaboration.
	MembershipId *string `locationName:"membershipId" min:"36" type:"string"`

	// A human-readable identifier provided by the collaboration owner. Display
	// names are not unique.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// An indicator as to whether query logging has been enabled or disabled for
	// the collaboration.
	//
	// QueryLogStatus is a required field
	QueryLogStatus *string `locationName:"queryLogStatus" type:"string" required:"true" enum:"CollaborationQueryLogStatus"`

	// The time the collaboration metadata was last updated.
	//
	// UpdateTime is a required field
	UpdateTime *time.Time `locationName:"updateTime" type:"timestamp" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Collaboration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Collaboration) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *Collaboration) SetArn(v string) *Collaboration {
	s.Arn = &v
	return s
}

// SetCreateTime sets the CreateTime field's value.
func (s *Collaboration) SetCreateTime(v time.Time) *Collaboration {
	s.CreateTime = &v
	return s
}

// SetCreatorAccountId sets the CreatorAccountId field's value.
func (s *Collaboration) SetCreatorAccountId(v string) *Collaboration {
	s.CreatorAccountId = &v
	return s
}

// SetCreatorDisplayName sets the CreatorDisplayName field's value.
func (s *Collaboration) SetCreatorDisplayName(v string) *Collaboration {
	s.CreatorDisplayName = &v
	return s
}

// SetDataEncryptionMetadata sets the DataEncryptionMetadata field's value.
func (s *Collaboration) SetDataEncryptionMetadata(v *DataEncryptionMetadata) *Collaboration {
	s.DataEncryptionMetadata = v
	return s
}

// SetDescription sets the Description field's value.
func (s *Collaboration) SetDescription(v string) *Collaboration {
	s.Description = &v
	return s
}

// SetId sets the Id field's value.
func (s *Collaboration) SetId(v string) *Collaboration {
	s.Id = &v
	return s
}

// SetMemberStatus sets the MemberStatus field's value.
func (s *Collaboration) SetMemberStatus(v string) *Collaboration {
	s.MemberStatus = &v
	return s
}

// SetMembershipArn sets the MembershipArn field's value.
func (s *Collaboration) SetMembershipArn(v string) *Collaboration {
	s.MembershipArn = &v
	return s
}

// SetMembershipId sets the MembershipId field's value.
func (s *Collaboration) SetMembershipId(v string) *Collaboration {
	s.MembershipId = &v
	return s
}

// SetName sets the Name field's value.
func (s *Collaboration) SetName(v string) *Collaboration {
	s.Name = &v
	return s
}

// SetQueryLogStatus sets the QueryLogStatus field's value.
func (s *Collaboration) SetQueryLogStatus(v string) *Collaboration {
	s.QueryLogStatus = &v
	return s
}

// SetUpdateTime sets the UpdateTime field's value.
func (s *Collaboration) SetUpdateTime(v time.Time) *Collaboration {
	s.UpdateTime = &v
	return s
}

// The analysis template within a collaboration.
type CollaborationAnalysisTemplate struct {
	_ struct{} `type:"structure"`

	// The analysis parameters that have been specified in the analysis template.
	AnalysisParameters []*AnalysisParameter `locationName:"analysisParameters" type:"list" sensitive:"true"`

	// The Amazon Resource Name (ARN) of the analysis template.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" type:"string" required:"true"`

	// The unique ARN for the analysis template’s associated collaboration.
	//
	// CollaborationArn is a required field
	CollaborationArn *string `locationName:"collaborationArn" type:"string" required:"true"`

	// A unique identifier for the collaboration that the analysis templates belong
	// to. Currently accepts collaboration ID.
	//
	// CollaborationId is a required field
	CollaborationId *string `locationName:"collaborationId" min:"36" type:"string" required:"true"`

	// The time that the analysis template within a collaboration was created.
	//
	// CreateTime is a required field
	CreateTime *time.Time `locationName:"createTime" type:"timestamp" required:"true"`

	// The identifier used to reference members of the collaboration. Currently
	// only supports Amazon Web Services account ID.
	//
	// CreatorAccountId is a required field
	CreatorAccountId *string `locationName:"creatorAccountId" min:"12" type:"string" required:"true"`

	// The description of the analysis template.
	Description *string `locationName:"description" type:"string"`

	// The format of the analysis template in the collaboration.
	//
	// Format is a required field
	Format *string `locationName:"format" type:"string" required:"true" enum:"AnalysisFormat"`

	// The identifier of the analysis template.
	//
	// Id is a required field
	Id *string `locationName:"id" min:"36" type:"string" required:"true"`

	// The name of the analysis template.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// The entire schema object.
	//
	// Schema is a required field
	Schema *AnalysisSchema `locationName:"schema" type:"structure" required:"true"`

	// The source of the analysis template within a collaboration.
	//
	// Source is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CollaborationAnalysisTemplate's
	// String and GoString methods.
	//
	// Source is a required field
	Source *AnalysisSource `locationName:"source" type:"structure" required:"true" sensitive:"true"`

	// The time that the analysis template in the collaboration was last updated.
	//
	// UpdateTime is a required field
	UpdateTime *time.Time `locationName:"updateTime" type:"timestamp" required:"true"`

	// The validations that were performed.
	Validations []*AnalysisTemplateValidationStatusDetail `locationName:"validations" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CollaborationAnalysisTemplate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CollaborationAnalysisTemplate) GoString() string {
	return s.String()
}

// SetAnalysisParameters sets the AnalysisParameters field's value.
func (s *CollaborationAnalysisTemplate) SetAnalysisParameters(v []*AnalysisParameter) *CollaborationAnalysisTemplate {
	s.AnalysisParameters = v
	return s
}

// SetArn sets the Arn field's value.
func (s *CollaborationAnalysisTemplate) SetArn(v string) *CollaborationAnalysisTemplate {
	s.Arn = &v
	return s
}

// SetCollaborationArn sets the CollaborationArn field's value.
func (s *CollaborationAnalysisTemplate) SetCollaborationArn(v string) *CollaborationAnalysisTemplate {
	s.CollaborationArn = &v
	return s
}

// SetCollaborationId sets the CollaborationId field's value.
func (s *CollaborationAnalysisTemplate) SetCollaborationId(v string) *CollaborationAnalysisTemplate {
	s.CollaborationId = &v
	return s
}

// SetCreateTime sets the CreateTime field's value.
func (s *CollaborationAnalysisTemplate) SetCreateTime(v time.Time) *CollaborationAnalysisTemplate {
	s.CreateTime = &v
	return s
}

// SetCreatorAccountId sets the CreatorAccountId field's value.
func (s *CollaborationAnalysisTemplate) SetCreatorAccountId(v string) *CollaborationAnalysisTemplate {
	s.CreatorAccountId = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CollaborationAnalysisTemplate) SetDescription(v string) *CollaborationAnalysisTemplate {
	s.Description = &v
	return s
}

// SetFormat sets the Format field's value.
func (s *CollaborationAnalysisTemplate) SetFormat(v string) *CollaborationAnalysisTemplate {
	s.Format = &v
	return s
}

// SetId sets the Id field's value.
func (s *CollaborationAnalysisTemplate) SetId(v string) *CollaborationAnalysisTemplate {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *CollaborationAnalysisTemplate) SetName(v string) *CollaborationAnalysisTemplate {
	s.Name = &v
	return s
}

// SetSchema sets the Schema field's value.
func (s *CollaborationAnalysisTemplate) SetSchema(v *AnalysisSchema) *CollaborationAnalysisTemplate {
	s.Schema = v
	return s
}

// SetSource sets the Source field's value.
func (s *CollaborationAnalysisTemplate) SetSource(v *AnalysisSource) *CollaborationAnalysisTemplate {
	s.Source = v
	return s
}

// SetUpdateTime sets the UpdateTime field's value.
func (s *CollaborationAnalysisTemplate) SetUpdateTime(v time.Time) *CollaborationAnalysisTemplate {
	s.UpdateTime = &v
	return s
}

// SetValidations sets the Validations field's value.
func (s *CollaborationAnalysisTemplate) SetValidations(v []*AnalysisTemplateValidationStatusDetail) *CollaborationAnalysisTemplate {
	s.Validations = v
	return s
}

// The metadata of the analysis template within a collaboration.
type CollaborationAnalysisTemplateSummary struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the analysis template.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" type:"string" required:"true"`

	// The unique ARN for the analysis template’s associated collaboration.
	//
	// CollaborationArn is a required field
	CollaborationArn *string `locationName:"collaborationArn" type:"string" required:"true"`

	// A unique identifier for the collaboration that the analysis templates belong
	// to. Currently accepts collaboration ID.
	//
	// CollaborationId is a required field
	CollaborationId *string `locationName:"collaborationId" min:"36" type:"string" required:"true"`

	// The time that the summary of the analysis template in a collaboration was
	// created.
	//
	// CreateTime is a required field
	CreateTime *time.Time `locationName:"createTime" type:"timestamp" required:"true"`

	// The identifier used to reference members of the collaboration. Currently
	// only supports Amazon Web Services account ID.
	//
	// CreatorAccountId is a required field
	CreatorAccountId *string `locationName:"creatorAccountId" min:"12" type:"string" required:"true"`

	// The description of the analysis template.
	Description *string `locationName:"description" type:"string"`

	// The identifier of the analysis template.
	//
	// Id is a required field
	Id *string `locationName:"id" min:"36" type:"string" required:"true"`

	// The name of the analysis template.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// The time that the summary of the analysis template in the collaboration was
	// last updated.
	//
	// UpdateTime is a required field
	UpdateTime *time.Time `locationName:"updateTime" type:"timestamp" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CollaborationAnalysisTemplateSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CollaborationAnalysisTemplateSummary) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *CollaborationAnalysisTemplateSummary) SetArn(v string) *CollaborationAnalysisTemplateSummary {
	s.Arn = &v
	return s
}

// SetCollaborationArn sets the CollaborationArn field's value.
func (s *CollaborationAnalysisTemplateSummary) SetCollaborationArn(v string) *CollaborationAnalysisTemplateSummary {
	s.CollaborationArn = &v
	return s
}

// SetCollaborationId sets the CollaborationId field's value.
func (s *CollaborationAnalysisTemplateSummary) SetCollaborationId(v string) *CollaborationAnalysisTemplateSummary {
	s.CollaborationId = &v
	return s
}

// SetCreateTime sets the CreateTime field's value.
func (s *CollaborationAnalysisTemplateSummary) SetCreateTime(v time.Time) *CollaborationAnalysisTemplateSummary {
	s.CreateTime = &v
	return s
}

// SetCreatorAccountId sets the CreatorAccountId field's value.
func (s *CollaborationAnalysisTemplateSummary) SetCreatorAccountId(v string) *CollaborationAnalysisTemplateSummary {
	s.CreatorAccountId = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CollaborationAnalysisTemplateSummary) SetDescription(v string) *CollaborationAnalysisTemplateSummary {
	s.Description = &v
	return s
}

// SetId sets the Id field's value.
func (s *CollaborationAnalysisTemplateSummary) SetId(v string) *CollaborationAnalysisTemplateSummary {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *CollaborationAnalysisTemplateSummary) SetName(v string) *CollaborationAnalysisTemplateSummary {
	s.Name = &v
	return s
}

// SetUpdateTime sets the UpdateTime field's value.
func (s *CollaborationAnalysisTemplateSummary) SetUpdateTime(v time.Time) *CollaborationAnalysisTemplateSummary {
	s.UpdateTime = &v
	return s
}

// The configured audience model association within a collaboration.
type CollaborationConfiguredAudienceModelAssociation struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the configured audience model association.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" type:"string" required:"true"`

	// The unique ARN for the configured audience model's associated collaboration.
	//
	// CollaborationArn is a required field
	CollaborationArn *string `locationName:"collaborationArn" type:"string" required:"true"`

	// A unique identifier for the collaboration that the configured audience model
	// associations belong to. Accepts collaboration ID.
	//
	// CollaborationId is a required field
	CollaborationId *string `locationName:"collaborationId" min:"36" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the configure audience model.
	//
	// ConfiguredAudienceModelArn is a required field
	ConfiguredAudienceModelArn *string `locationName:"configuredAudienceModelArn" min:"20" type:"string" required:"true"`

	// The time at which the configured audience model association was created.
	//
	// CreateTime is a required field
	CreateTime *time.Time `locationName:"createTime" type:"timestamp" required:"true"`

	// The identifier used to reference members of the collaboration. Only supports
	// Amazon Web Services account ID.
	//
	// CreatorAccountId is a required field
	CreatorAccountId *string `locationName:"creatorAccountId" min:"12" type:"string" required:"true"`

	// The description of the configured audience model association.
	Description *string `locationName:"description" type:"string"`

	// The identifier of the configured audience model association.
	//
	// Id is a required field
	Id *string `locationName:"id" min:"36" type:"string" required:"true"`

	// The name of the configured audience model association.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The most recent time at which the configured audience model association was
	// updated.
	//
	// UpdateTime is a required field
	UpdateTime *time.Time `locationName:"updateTime" type:"timestamp" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CollaborationConfiguredAudienceModelAssociation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CollaborationConfiguredAudienceModelAssociation) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *CollaborationConfiguredAudienceModelAssociation) SetArn(v string) *CollaborationConfiguredAudienceModelAssociation {
	s.Arn = &v
	return s
}

// SetCollaborationArn sets the CollaborationArn field's value.
func (s *CollaborationConfiguredAudienceModelAssociation) SetCollaborationArn(v string) *CollaborationConfiguredAudienceModelAssociation {
	s.CollaborationArn = &v
	return s
}

// SetCollaborationId sets the CollaborationId field's value.
func (s *CollaborationConfiguredAudienceModelAssociation) SetCollaborationId(v string) *CollaborationConfiguredAudienceModelAssociation {
	s.CollaborationId = &v
	return s
}

// SetConfiguredAudienceModelArn sets the ConfiguredAudienceModelArn field's value.
func (s *CollaborationConfiguredAudienceModelAssociation) SetConfiguredAudienceModelArn(v string) *CollaborationConfiguredAudienceModelAssociation {
	s.ConfiguredAudienceModelArn = &v
	return s
}

// SetCreateTime sets the CreateTime field's value.
func (s *CollaborationConfiguredAudienceModelAssociation) SetCreateTime(v time.Time) *CollaborationConfiguredAudienceModelAssociation {
	s.CreateTime = &v
	return s
}

// SetCreatorAccountId sets the CreatorAccountId field's value.
func (s *CollaborationConfiguredAudienceModelAssociation) SetCreatorAccountId(v string) *CollaborationConfiguredAudienceModelAssociation {
	s.CreatorAccountId = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CollaborationConfiguredAudienceModelAssociation) SetDescription(v string) *CollaborationConfiguredAudienceModelAssociation {
	s.Description = &v
	return s
}

// SetId sets the Id field's value.
func (s *CollaborationConfiguredAudienceModelAssociation) SetId(v string) *CollaborationConfiguredAudienceModelAssociation {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *CollaborationConfiguredAudienceModelAssociation) SetName(v string) *CollaborationConfiguredAudienceModelAssociation {
	s.Name = &v
	return s
}

// SetUpdateTime sets the UpdateTime field's value.
func (s *CollaborationConfiguredAudienceModelAssociation) SetUpdateTime(v time.Time) *CollaborationConfiguredAudienceModelAssociation {
	s.UpdateTime = &v
	return s
}

// A summary of the configured audience model association in the collaboration.
type CollaborationConfiguredAudienceModelAssociationSummary struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the configured audience model association.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" type:"string" required:"true"`

	// The unique ARN for the configured audience model's associated collaboration.
	//
	// CollaborationArn is a required field
	CollaborationArn *string `locationName:"collaborationArn" type:"string" required:"true"`

	// A unique identifier for the collaboration that the configured audience model
	// associations belong to. Accepts collaboration ID.
	//
	// CollaborationId is a required field
	CollaborationId *string `locationName:"collaborationId" min:"36" type:"string" required:"true"`

	// The time at which the configured audience model association was created.
	//
	// CreateTime is a required field
	CreateTime *time.Time `locationName:"createTime" type:"timestamp" required:"true"`

	// The identifier used to reference members of the collaboration. Only supports
	// Amazon Web Services account ID.
	//
	// CreatorAccountId is a required field
	CreatorAccountId *string `locationName:"creatorAccountId" min:"12" type:"string" required:"true"`

	// The description of the configured audience model association.
	Description *string `locationName:"description" type:"string"`

	// The identifier of the configured audience model association.
	//
	// Id is a required field
	Id *string `locationName:"id" min:"36" type:"string" required:"true"`

	// The name of the configured audience model association.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The most recent time at which the configured audience model association was
	// updated.
	//
	// UpdateTime is a required field
	UpdateTime *time.Time `locationName:"updateTime" type:"timestamp" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CollaborationConfiguredAudienceModelAssociationSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CollaborationConfiguredAudienceModelAssociationSummary) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *CollaborationConfiguredAudienceModelAssociationSummary) SetArn(v string) *CollaborationConfiguredAudienceModelAssociationSummary {
	s.Arn = &v
	return s
}

// SetCollaborationArn sets the CollaborationArn field's value.
func (s *CollaborationConfiguredAudienceModelAssociationSummary) SetCollaborationArn(v string) *CollaborationConfiguredAudienceModelAssociationSummary {
	s.CollaborationArn = &v
	return s
}

// SetCollaborationId sets the CollaborationId field's value.
func (s *CollaborationConfiguredAudienceModelAssociationSummary) SetCollaborationId(v string) *CollaborationConfiguredAudienceModelAssociationSummary {
	s.CollaborationId = &v
	return s
}

// SetCreateTime sets the CreateTime field's value.
func (s *CollaborationConfiguredAudienceModelAssociationSummary) SetCreateTime(v time.Time) *CollaborationConfiguredAudienceModelAssociationSummary {
	s.CreateTime = &v
	return s
}

// SetCreatorAccountId sets the CreatorAccountId field's value.
func (s *CollaborationConfiguredAudienceModelAssociationSummary) SetCreatorAccountId(v string) *CollaborationConfiguredAudienceModelAssociationSummary {
	s.CreatorAccountId = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CollaborationConfiguredAudienceModelAssociationSummary) SetDescription(v string) *CollaborationConfiguredAudienceModelAssociationSummary {
	s.Description = &v
	return s
}

// SetId sets the Id field's value.
func (s *CollaborationConfiguredAudienceModelAssociationSummary) SetId(v string) *CollaborationConfiguredAudienceModelAssociationSummary {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *CollaborationConfiguredAudienceModelAssociationSummary) SetName(v string) *CollaborationConfiguredAudienceModelAssociationSummary {
	s.Name = &v
	return s
}

// SetUpdateTime sets the UpdateTime field's value.
func (s *CollaborationConfiguredAudienceModelAssociationSummary) SetUpdateTime(v time.Time) *CollaborationConfiguredAudienceModelAssociationSummary {
	s.UpdateTime = &v
	return s
}

// Provides summary information about the collaboration ID namespace association.
type CollaborationIdNamespaceAssociationSummary struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the collaboration ID namespace association.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the collaboration that contains this collaboration
	// ID namespace association.
	//
	// CollaborationArn is a required field
	CollaborationArn *string `locationName:"collaborationArn" type:"string" required:"true"`

	// The unique identifier of the collaboration that contains this collaboration
	// ID namespace association.
	//
	// CollaborationId is a required field
	CollaborationId *string `locationName:"collaborationId" min:"36" type:"string" required:"true"`

	// The time at which the collaboration ID namespace association was created.
	//
	// CreateTime is a required field
	CreateTime *time.Time `locationName:"createTime" type:"timestamp" required:"true"`

	// The Amazon Web Services account that created this collaboration ID namespace
	// association.
	//
	// CreatorAccountId is a required field
	CreatorAccountId *string `locationName:"creatorAccountId" min:"12" type:"string" required:"true"`

	// The description of the collaboration ID namepsace association.
	Description *string `locationName:"description" type:"string"`

	// The unique identifier of the collaboration ID namespace association.
	//
	// Id is a required field
	Id *string `locationName:"id" min:"36" type:"string" required:"true"`

	// The input reference configuration that's used to create the collaboration
	// ID namespace association.
	//
	// InputReferenceConfig is a required field
	InputReferenceConfig *IdNamespaceAssociationInputReferenceConfig `locationName:"inputReferenceConfig" type:"structure" required:"true"`

	// The input reference properties that are used to create the collaboration
	// ID namespace association.
	//
	// InputReferenceProperties is a required field
	InputReferenceProperties *IdNamespaceAssociationInputReferencePropertiesSummary `locationName:"inputReferenceProperties" type:"structure" required:"true"`

	// The name of the collaboration ID namespace association.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The most recent time at which the collaboration ID namespace association
	// was updated.
	//
	// UpdateTime is a required field
	UpdateTime *time.Time `locationName:"updateTime" type:"timestamp" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CollaborationIdNamespaceAssociationSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CollaborationIdNamespaceAssociationSummary) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *CollaborationIdNamespaceAssociationSummary) SetArn(v string) *CollaborationIdNamespaceAssociationSummary {
	s.Arn = &v
	return s
}

// SetCollaborationArn sets the CollaborationArn field's value.
func (s *CollaborationIdNamespaceAssociationSummary) SetCollaborationArn(v string) *CollaborationIdNamespaceAssociationSummary {
	s.CollaborationArn = &v
	return s
}

// SetCollaborationId sets the CollaborationId field's value.
func (s *CollaborationIdNamespaceAssociationSummary) SetCollaborationId(v string) *CollaborationIdNamespaceAssociationSummary {
	s.CollaborationId = &v
	return s
}

// SetCreateTime sets the CreateTime field's value.
func (s *CollaborationIdNamespaceAssociationSummary) SetCreateTime(v time.Time) *CollaborationIdNamespaceAssociationSummary {
	s.CreateTime = &v
	return s
}

// SetCreatorAccountId sets the CreatorAccountId field's value.
func (s *CollaborationIdNamespaceAssociationSummary) SetCreatorAccountId(v string) *CollaborationIdNamespaceAssociationSummary {
	s.CreatorAccountId = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CollaborationIdNamespaceAssociationSummary) SetDescription(v string) *CollaborationIdNamespaceAssociationSummary {
	s.Description = &v
	return s
}

// SetId sets the Id field's value.
func (s *CollaborationIdNamespaceAssociationSummary) SetId(v string) *CollaborationIdNamespaceAssociationSummary {
	s.Id = &v
	return s
}

// SetInputReferenceConfig sets the InputReferenceConfig field's value.
func (s *CollaborationIdNamespaceAssociationSummary) SetInputReferenceConfig(v *IdNamespaceAssociationInputReferenceConfig) *CollaborationIdNamespaceAssociationSummary {
	s.InputReferenceConfig = v
	return s
}

// SetInputReferenceProperties sets the InputReferenceProperties field's value.
func (s *CollaborationIdNamespaceAssociationSummary) SetInputReferenceProperties(v *IdNamespaceAssociationInputReferencePropertiesSummary) *CollaborationIdNamespaceAssociationSummary {
	s.InputReferenceProperties = v
	return s
}

// SetName sets the Name field's value.
func (s *CollaborationIdNamespaceAssociationSummary) SetName(v string) *CollaborationIdNamespaceAssociationSummary {
	s.Name = &v
	return s
}

// SetUpdateTime sets the UpdateTime field's value.
func (s *CollaborationIdNamespaceAssociationSummary) SetUpdateTime(v time.Time) *CollaborationIdNamespaceAssociationSummary {
	s.UpdateTime = &v
	return s
}

// A summary of the collaboration privacy budgets. This summary includes the
// collaboration information, creation information, epsilon provided, and utility
// in terms of aggregations.
type CollaborationPrivacyBudgetSummary struct {
	_ struct{} `type:"structure"`

	// The includes epsilon provided and utility in terms of aggregations.
	//
	// Budget is a required field
	Budget *PrivacyBudget `locationName:"budget" type:"structure" required:"true"`

	// The ARN of the collaboration that includes this privacy budget.
	//
	// CollaborationArn is a required field
	CollaborationArn *string `locationName:"collaborationArn" type:"string" required:"true"`

	// The unique identifier of the collaboration that includes this privacy budget.
	//
	// CollaborationId is a required field
	CollaborationId *string `locationName:"collaborationId" min:"36" type:"string" required:"true"`

	// The time at which the privacy budget was created.
	//
	// CreateTime is a required field
	CreateTime *time.Time `locationName:"createTime" type:"timestamp" required:"true"`

	// The unique identifier of the account that created this privacy budget.
	//
	// CreatorAccountId is a required field
	CreatorAccountId *string `locationName:"creatorAccountId" min:"12" type:"string" required:"true"`

	// The unique identifier of the collaboration privacy budget.
	//
	// Id is a required field
	Id *string `locationName:"id" min:"36" type:"string" required:"true"`

	// The ARN of the collaboration privacy budget template.
	//
	// PrivacyBudgetTemplateArn is a required field
	PrivacyBudgetTemplateArn *string `locationName:"privacyBudgetTemplateArn" type:"string" required:"true"`

	// The unique identifier of the collaboration privacy budget template.
	//
	// PrivacyBudgetTemplateId is a required field
	PrivacyBudgetTemplateId *string `locationName:"privacyBudgetTemplateId" min:"36" type:"string" required:"true"`

	// The type of privacy budget template.
	//
	// Type is a required field
	Type *string `locationName:"type" type:"string" required:"true" enum:"PrivacyBudgetType"`

	// The most recent time at which the privacy budget was updated.
	//
	// UpdateTime is a required field
	UpdateTime *time.Time `locationName:"updateTime" type:"timestamp" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CollaborationPrivacyBudgetSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CollaborationPrivacyBudgetSummary) GoString() string {
	return s.String()
}

// SetBudget sets the Budget field's value.
func (s *CollaborationPrivacyBudgetSummary) SetBudget(v *PrivacyBudget) *CollaborationPrivacyBudgetSummary {
	s.Budget = v
	return s
}

// SetCollaborationArn sets the CollaborationArn field's value.
func (s *CollaborationPrivacyBudgetSummary) SetCollaborationArn(v string) *CollaborationPrivacyBudgetSummary {
	s.CollaborationArn = &v
	return s
}

// SetCollaborationId sets the CollaborationId field's value.
func (s *CollaborationPrivacyBudgetSummary) SetCollaborationId(v string) *CollaborationPrivacyBudgetSummary {
	s.CollaborationId = &v
	return s
}

// SetCreateTime sets the CreateTime field's value.
func (s *CollaborationPrivacyBudgetSummary) SetCreateTime(v time.Time) *CollaborationPrivacyBudgetSummary {
	s.CreateTime = &v
	return s
}

// SetCreatorAccountId sets the CreatorAccountId field's value.
func (s *CollaborationPrivacyBudgetSummary) SetCreatorAccountId(v string) *CollaborationPrivacyBudgetSummary {
	s.CreatorAccountId = &v
	return s
}

// SetId sets the Id field's value.
func (s *CollaborationPrivacyBudgetSummary) SetId(v string) *CollaborationPrivacyBudgetSummary {
	s.Id = &v
	return s
}

// SetPrivacyBudgetTemplateArn sets the PrivacyBudgetTemplateArn field's value.
func (s *CollaborationPrivacyBudgetSummary) SetPrivacyBudgetTemplateArn(v string) *CollaborationPrivacyBudgetSummary {
	s.PrivacyBudgetTemplateArn = &v
	return s
}

// SetPrivacyBudgetTemplateId sets the PrivacyBudgetTemplateId field's value.
func (s *CollaborationPrivacyBudgetSummary) SetPrivacyBudgetTemplateId(v string) *CollaborationPrivacyBudgetSummary {
	s.PrivacyBudgetTemplateId = &v
	return s
}

// SetType sets the Type field's value.
func (s *CollaborationPrivacyBudgetSummary) SetType(v string) *CollaborationPrivacyBudgetSummary {
	s.Type = &v
	return s
}

// SetUpdateTime sets the UpdateTime field's value.
func (s *CollaborationPrivacyBudgetSummary) SetUpdateTime(v time.Time) *CollaborationPrivacyBudgetSummary {
	s.UpdateTime = &v
	return s
}

// An array that specifies the information for a collaboration's privacy budget
// template.
type CollaborationPrivacyBudgetTemplate struct {
	_ struct{} `type:"structure"`

	// The ARN of the collaboration privacy budget template.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" type:"string" required:"true"`

	// How often the privacy budget refreshes.
	//
	// If you plan to regularly bring new data into the collaboration, use CALENDAR_MONTH
	// to automatically get a new privacy budget for the collaboration every calendar
	// month. Choosing this option allows arbitrary amounts of information to be
	// revealed about rows of the data when repeatedly queried across refreshes.
	// Avoid choosing this if the same rows will be repeatedly queried between privacy
	// budget refreshes.
	//
	// AutoRefresh is a required field
	AutoRefresh *string `locationName:"autoRefresh" type:"string" required:"true" enum:"PrivacyBudgetTemplateAutoRefresh"`

	// The ARN of the collaboration that includes this collaboration privacy budget
	// template.
	//
	// CollaborationArn is a required field
	CollaborationArn *string `locationName:"collaborationArn" type:"string" required:"true"`

	// The unique identifier of the collaboration that includes this collaboration
	// privacy budget template.
	//
	// CollaborationId is a required field
	CollaborationId *string `locationName:"collaborationId" min:"36" type:"string" required:"true"`

	// The time at which the collaboration privacy budget template was created.
	//
	// CreateTime is a required field
	CreateTime *time.Time `locationName:"createTime" type:"timestamp" required:"true"`

	// The unique identifier of the account that created this collaboration privacy
	// budget template.
	//
	// CreatorAccountId is a required field
	CreatorAccountId *string `locationName:"creatorAccountId" min:"12" type:"string" required:"true"`

	// The unique identifier of the collaboration privacy budget template.
	//
	// Id is a required field
	Id *string `locationName:"id" min:"36" type:"string" required:"true"`

	// Specifies the epsilon and noise parameters for the privacy budget template.
	//
	// Parameters is a required field
	Parameters *PrivacyBudgetTemplateParametersOutput_ `locationName:"parameters" type:"structure" required:"true"`

	// The type of privacy budget template.
	//
	// PrivacyBudgetType is a required field
	PrivacyBudgetType *string `locationName:"privacyBudgetType" type:"string" required:"true" enum:"PrivacyBudgetType"`

	// The most recent time at which the collaboration privacy budget template was
	// updated.
	//
	// UpdateTime is a required field
	UpdateTime *time.Time `locationName:"updateTime" type:"timestamp" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CollaborationPrivacyBudgetTemplate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CollaborationPrivacyBudgetTemplate) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *CollaborationPrivacyBudgetTemplate) SetArn(v string) *CollaborationPrivacyBudgetTemplate {
	s.Arn = &v
	return s
}

// SetAutoRefresh sets the AutoRefresh field's value.
func (s *CollaborationPrivacyBudgetTemplate) SetAutoRefresh(v string) *CollaborationPrivacyBudgetTemplate {
	s.AutoRefresh = &v
	return s
}

// SetCollaborationArn sets the CollaborationArn field's value.
func (s *CollaborationPrivacyBudgetTemplate) SetCollaborationArn(v string) *CollaborationPrivacyBudgetTemplate {
	s.CollaborationArn = &v
	return s
}

// SetCollaborationId sets the CollaborationId field's value.
func (s *CollaborationPrivacyBudgetTemplate) SetCollaborationId(v string) *CollaborationPrivacyBudgetTemplate {
	s.CollaborationId = &v
	return s
}

// SetCreateTime sets the CreateTime field's value.
func (s *CollaborationPrivacyBudgetTemplate) SetCreateTime(v time.Time) *CollaborationPrivacyBudgetTemplate {
	s.CreateTime = &v
	return s
}

// SetCreatorAccountId sets the CreatorAccountId field's value.
func (s *CollaborationPrivacyBudgetTemplate) SetCreatorAccountId(v string) *CollaborationPrivacyBudgetTemplate {
	s.CreatorAccountId = &v
	return s
}

// SetId sets the Id field's value.
func (s *CollaborationPrivacyBudgetTemplate) SetId(v string) *CollaborationPrivacyBudgetTemplate {
	s.Id = &v
	return s
}

// SetParameters sets the Parameters field's value.
func (s *CollaborationPrivacyBudgetTemplate) SetParameters(v *PrivacyBudgetTemplateParametersOutput_) *CollaborationPrivacyBudgetTemplate {
	s.Parameters = v
	return s
}

// SetPrivacyBudgetType sets the PrivacyBudgetType field's value.
func (s *CollaborationPrivacyBudgetTemplate) SetPrivacyBudgetType(v string) *CollaborationPrivacyBudgetTemplate {
	s.PrivacyBudgetType = &v
	return s
}

// SetUpdateTime sets the UpdateTime field's value.
func (s *CollaborationPrivacyBudgetTemplate) SetUpdateTime(v time.Time) *CollaborationPrivacyBudgetTemplate {
	s.UpdateTime = &v
	return s
}

// A summary of the collaboration's privacy budget template. This summary includes
// information about who created the privacy budget template and what collaborations
// it belongs to.
type CollaborationPrivacyBudgetTemplateSummary struct {
	_ struct{} `type:"structure"`

	// The ARN of the collaboration privacy budget template.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" type:"string" required:"true"`

	// The ARN of the collaboration that contains this collaboration privacy budget
	// template.
	//
	// CollaborationArn is a required field
	CollaborationArn *string `locationName:"collaborationArn" type:"string" required:"true"`

	// The unique identifier of the collaboration that contains this collaboration
	// privacy budget template.
	//
	// CollaborationId is a required field
	CollaborationId *string `locationName:"collaborationId" min:"36" type:"string" required:"true"`

	// The time at which the collaboration privacy budget template was created.
	//
	// CreateTime is a required field
	CreateTime *time.Time `locationName:"createTime" type:"timestamp" required:"true"`

	// The unique identifier of the account that created this collaboration privacy
	// budget template.
	//
	// CreatorAccountId is a required field
	CreatorAccountId *string `locationName:"creatorAccountId" min:"12" type:"string" required:"true"`

	// The unique identifier of the collaboration privacy budget template.
	//
	// Id is a required field
	Id *string `locationName:"id" min:"36" type:"string" required:"true"`

	// The type of the privacy budget template.
	//
	// PrivacyBudgetType is a required field
	PrivacyBudgetType *string `locationName:"privacyBudgetType" type:"string" required:"true" enum:"PrivacyBudgetType"`

	// The most recent time at which the collaboration privacy budget template was
	// updated.
	//
	// UpdateTime is a required field
	UpdateTime *time.Time `locationName:"updateTime" type:"timestamp" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CollaborationPrivacyBudgetTemplateSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CollaborationPrivacyBudgetTemplateSummary) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *CollaborationPrivacyBudgetTemplateSummary) SetArn(v string) *CollaborationPrivacyBudgetTemplateSummary {
	s.Arn = &v
	return s
}

// SetCollaborationArn sets the CollaborationArn field's value.
func (s *CollaborationPrivacyBudgetTemplateSummary) SetCollaborationArn(v string) *CollaborationPrivacyBudgetTemplateSummary {
	s.CollaborationArn = &v
	return s
}

// SetCollaborationId sets the CollaborationId field's value.
func (s *CollaborationPrivacyBudgetTemplateSummary) SetCollaborationId(v string) *CollaborationPrivacyBudgetTemplateSummary {
	s.CollaborationId = &v
	return s
}

// SetCreateTime sets the CreateTime field's value.
func (s *CollaborationPrivacyBudgetTemplateSummary) SetCreateTime(v time.Time) *CollaborationPrivacyBudgetTemplateSummary {
	s.CreateTime = &v
	return s
}

// SetCreatorAccountId sets the CreatorAccountId field's value.
func (s *CollaborationPrivacyBudgetTemplateSummary) SetCreatorAccountId(v string) *CollaborationPrivacyBudgetTemplateSummary {
	s.CreatorAccountId = &v
	return s
}

// SetId sets the Id field's value.
func (s *CollaborationPrivacyBudgetTemplateSummary) SetId(v string) *CollaborationPrivacyBudgetTemplateSummary {
	s.Id = &v
	return s
}

// SetPrivacyBudgetType sets the PrivacyBudgetType field's value.
func (s *CollaborationPrivacyBudgetTemplateSummary) SetPrivacyBudgetType(v string) *CollaborationPrivacyBudgetTemplateSummary {
	s.PrivacyBudgetType = &v
	return s
}

// SetUpdateTime sets the UpdateTime field's value.
func (s *CollaborationPrivacyBudgetTemplateSummary) SetUpdateTime(v time.Time) *CollaborationPrivacyBudgetTemplateSummary {
	s.UpdateTime = &v
	return s
}

// The metadata of the collaboration.
type CollaborationSummary struct {
	_ struct{} `type:"structure"`

	// The ARN of the collaboration.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" type:"string" required:"true"`

	// The time when the collaboration was created.
	//
	// CreateTime is a required field
	CreateTime *time.Time `locationName:"createTime" type:"timestamp" required:"true"`

	// The identifier used to reference members of the collaboration. Currently
	// only supports Amazon Web Services account ID.
	//
	// CreatorAccountId is a required field
	CreatorAccountId *string `locationName:"creatorAccountId" min:"12" type:"string" required:"true"`

	// The display name of the collaboration creator.
	//
	// CreatorDisplayName is a required field
	CreatorDisplayName *string `locationName:"creatorDisplayName" min:"1" type:"string" required:"true"`

	// The identifier for the collaboration.
	//
	// Id is a required field
	Id *string `locationName:"id" min:"36" type:"string" required:"true"`

	// The status of a member in a collaboration.
	//
	// MemberStatus is a required field
	MemberStatus *string `locationName:"memberStatus" type:"string" required:"true" enum:"MemberStatus"`

	// The ARN of a member in a collaboration.
	MembershipArn *string `locationName:"membershipArn" type:"string"`

	// The identifier of a member in a collaboration.
	MembershipId *string `locationName:"membershipId" min:"36" type:"string"`

	// A human-readable identifier provided by the collaboration owner. Display
	// names are not unique.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The time the collaboration metadata was last updated.
	//
	// UpdateTime is a required field
	UpdateTime *time.Time `locationName:"updateTime" type:"timestamp" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CollaborationSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CollaborationSummary) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *CollaborationSummary) SetArn(v string) *CollaborationSummary {
	s.Arn = &v
	return s
}

// SetCreateTime sets the CreateTime field's value.
func (s *CollaborationSummary) SetCreateTime(v time.Time) *CollaborationSummary {
	s.CreateTime = &v
	return s
}

// SetCreatorAccountId sets the CreatorAccountId field's value.
func (s *CollaborationSummary) SetCreatorAccountId(v string) *CollaborationSummary {
	s.CreatorAccountId = &v
	return s
}

// SetCreatorDisplayName sets the CreatorDisplayName field's value.
func (s *CollaborationSummary) SetCreatorDisplayName(v string) *CollaborationSummary {
	s.CreatorDisplayName = &v
	return s
}

// SetId sets the Id field's value.
func (s *CollaborationSummary) SetId(v string) *CollaborationSummary {
	s.Id = &v
	return s
}

// SetMemberStatus sets the MemberStatus field's value.
func (s *CollaborationSummary) SetMemberStatus(v string) *CollaborationSummary {
	s.MemberStatus = &v
	return s
}

// SetMembershipArn sets the MembershipArn field's value.
func (s *CollaborationSummary) SetMembershipArn(v string) *CollaborationSummary {
	s.MembershipArn = &v
	return s
}

// SetMembershipId sets the MembershipId field's value.
func (s *CollaborationSummary) SetMembershipId(v string) *CollaborationSummary {
	s.MembershipId = &v
	return s
}

// SetName sets the Name field's value.
func (s *CollaborationSummary) SetName(v string) *CollaborationSummary {
	s.Name = &v
	return s
}

// SetUpdateTime sets the UpdateTime field's value.
func (s *CollaborationSummary) SetUpdateTime(v time.Time) *CollaborationSummary {
	s.UpdateTime = &v
	return s
}

// A column within a schema relation, derived from the underlying Glue table.
type Column struct {
	_ struct{} `type:"structure"`

	// The name of the column.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// The type of the column.
	//
	// Type is a required field
	Type *string `locationName:"type" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Column) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Column) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *Column) SetName(v string) *Column {
	s.Name = &v
	return s
}

// SetType sets the Type field's value.
func (s *Column) SetType(v string) *Column {
	s.Type = &v
	return s
}

// Details about the configured audience model association.
type ConfiguredAudienceModelAssociation struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the configured audience model association.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the collaboration that contains this configured
	// audience model association.
	//
	// CollaborationArn is a required field
	CollaborationArn *string `locationName:"collaborationArn" type:"string" required:"true"`

	// A unique identifier of the collaboration that contains this configured audience
	// model association.
	//
	// CollaborationId is a required field
	CollaborationId *string `locationName:"collaborationId" min:"36" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the configured audience model that was
	// used for this configured audience model association.
	//
	// ConfiguredAudienceModelArn is a required field
	ConfiguredAudienceModelArn *string `locationName:"configuredAudienceModelArn" min:"20" type:"string" required:"true"`

	// The time at which the configured audience model association was created.
	//
	// CreateTime is a required field
	CreateTime *time.Time `locationName:"createTime" type:"timestamp" required:"true"`

	// The description of the configured audience model association.
	Description *string `locationName:"description" type:"string"`

	// A unique identifier of the configured audience model association.
	//
	// Id is a required field
	Id *string `locationName:"id" min:"36" type:"string" required:"true"`

	// When TRUE, indicates that the resource policy for the configured audience
	// model resource being associated is configured for Clean Rooms to manage permissions
	// related to the given collaboration. When FALSE, indicates that the configured
	// audience model resource owner will manage permissions related to the given
	// collaboration.
	//
	// ManageResourcePolicies is a required field
	ManageResourcePolicies *bool `locationName:"manageResourcePolicies" type:"boolean" required:"true"`

	// The Amazon Resource Name (ARN) of the membership that contains this configured
	// audience model association.
	//
	// MembershipArn is a required field
	MembershipArn *string `locationName:"membershipArn" type:"string" required:"true"`

	// A unique identifier for the membership that contains this configured audience
	// model association.
	//
	// MembershipId is a required field
	MembershipId *string `locationName:"membershipId" min:"36" type:"string" required:"true"`

	// The name of the configured audience model association.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The most recent time at which the configured audience model association was
	// updated.
	//
	// UpdateTime is a required field
	UpdateTime *time.Time `locationName:"updateTime" type:"timestamp" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConfiguredAudienceModelAssociation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConfiguredAudienceModelAssociation) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *ConfiguredAudienceModelAssociation) SetArn(v string) *ConfiguredAudienceModelAssociation {
	s.Arn = &v
	return s
}

// SetCollaborationArn sets the CollaborationArn field's value.
func (s *ConfiguredAudienceModelAssociation) SetCollaborationArn(v string) *ConfiguredAudienceModelAssociation {
	s.CollaborationArn = &v
	return s
}

// SetCollaborationId sets the CollaborationId field's value.
func (s *ConfiguredAudienceModelAssociation) SetCollaborationId(v string) *ConfiguredAudienceModelAssociation {
	s.CollaborationId = &v
	return s
}

// SetConfiguredAudienceModelArn sets the ConfiguredAudienceModelArn field's value.
func (s *ConfiguredAudienceModelAssociation) SetConfiguredAudienceModelArn(v string) *ConfiguredAudienceModelAssociation {
	s.ConfiguredAudienceModelArn = &v
	return s
}

// SetCreateTime sets the CreateTime field's value.
func (s *ConfiguredAudienceModelAssociation) SetCreateTime(v time.Time) *ConfiguredAudienceModelAssociation {
	s.CreateTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *ConfiguredAudienceModelAssociation) SetDescription(v string) *ConfiguredAudienceModelAssociation {
	s.Description = &v
	return s
}

// SetId sets the Id field's value.
func (s *ConfiguredAudienceModelAssociation) SetId(v string) *ConfiguredAudienceModelAssociation {
	s.Id = &v
	return s
}

// SetManageResourcePolicies sets the ManageResourcePolicies field's value.
func (s *ConfiguredAudienceModelAssociation) SetManageResourcePolicies(v bool) *ConfiguredAudienceModelAssociation {
	s.ManageResourcePolicies = &v
	return s
}

// SetMembershipArn sets the MembershipArn field's value.
func (s *ConfiguredAudienceModelAssociation) SetMembershipArn(v string) *ConfiguredAudienceModelAssociation {
	s.MembershipArn = &v
	return s
}

// SetMembershipId sets the MembershipId field's value.
func (s *ConfiguredAudienceModelAssociation) SetMembershipId(v string) *ConfiguredAudienceModelAssociation {
	s.MembershipId = &v
	return s
}

// SetName sets the Name field's value.
func (s *ConfiguredAudienceModelAssociation) SetName(v string) *ConfiguredAudienceModelAssociation {
	s.Name = &v
	return s
}

// SetUpdateTime sets the UpdateTime field's value.
func (s *ConfiguredAudienceModelAssociation) SetUpdateTime(v time.Time) *ConfiguredAudienceModelAssociation {
	s.UpdateTime = &v
	return s
}

// A summary of the configured audience model association.
type ConfiguredAudienceModelAssociationSummary struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the configured audience model association.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the collaboration that contains the configured
	// audience model association.
	//
	// CollaborationArn is a required field
	CollaborationArn *string `locationName:"collaborationArn" type:"string" required:"true"`

	// A unique identifier of the collaboration that configured audience model is
	// associated with.
	//
	// CollaborationId is a required field
	CollaborationId *string `locationName:"collaborationId" min:"36" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the configured audience model that was
	// used for this configured audience model association.
	//
	// ConfiguredAudienceModelArn is a required field
	ConfiguredAudienceModelArn *string `locationName:"configuredAudienceModelArn" min:"20" type:"string" required:"true"`

	// The time at which the configured audience model association was created.
	//
	// CreateTime is a required field
	CreateTime *time.Time `locationName:"createTime" type:"timestamp" required:"true"`

	// The description of the configured audience model association.
	Description *string `locationName:"description" type:"string"`

	// A unique identifier of the configured audience model association.
	//
	// Id is a required field
	Id *string `locationName:"id" min:"36" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the membership that contains the configured
	// audience model association.
	//
	// MembershipArn is a required field
	MembershipArn *string `locationName:"membershipArn" type:"string" required:"true"`

	// A unique identifier of the membership that contains the configured audience
	// model association.
	//
	// MembershipId is a required field
	MembershipId *string `locationName:"membershipId" min:"36" type:"string" required:"true"`

	// The name of the configured audience model association.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The most recent time at which the configured audience model association was
	// updated.
	//
	// UpdateTime is a required field
	UpdateTime *time.Time `locationName:"updateTime" type:"timestamp" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConfiguredAudienceModelAssociationSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConfiguredAudienceModelAssociationSummary) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *ConfiguredAudienceModelAssociationSummary) SetArn(v string) *ConfiguredAudienceModelAssociationSummary {
	s.Arn = &v
	return s
}

// SetCollaborationArn sets the CollaborationArn field's value.
func (s *ConfiguredAudienceModelAssociationSummary) SetCollaborationArn(v string) *ConfiguredAudienceModelAssociationSummary {
	s.CollaborationArn = &v
	return s
}

// SetCollaborationId sets the CollaborationId field's value.
func (s *ConfiguredAudienceModelAssociationSummary) SetCollaborationId(v string) *ConfiguredAudienceModelAssociationSummary {
	s.CollaborationId = &v
	return s
}

// SetConfiguredAudienceModelArn sets the ConfiguredAudienceModelArn field's value.
func (s *ConfiguredAudienceModelAssociationSummary) SetConfiguredAudienceModelArn(v string) *ConfiguredAudienceModelAssociationSummary {
	s.ConfiguredAudienceModelArn = &v
	return s
}

// SetCreateTime sets the CreateTime field's value.
func (s *ConfiguredAudienceModelAssociationSummary) SetCreateTime(v time.Time) *ConfiguredAudienceModelAssociationSummary {
	s.CreateTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *ConfiguredAudienceModelAssociationSummary) SetDescription(v string) *ConfiguredAudienceModelAssociationSummary {
	s.Description = &v
	return s
}

// SetId sets the Id field's value.
func (s *ConfiguredAudienceModelAssociationSummary) SetId(v string) *ConfiguredAudienceModelAssociationSummary {
	s.Id = &v
	return s
}

// SetMembershipArn sets the MembershipArn field's value.
func (s *ConfiguredAudienceModelAssociationSummary) SetMembershipArn(v string) *ConfiguredAudienceModelAssociationSummary {
	s.MembershipArn = &v
	return s
}

// SetMembershipId sets the MembershipId field's value.
func (s *ConfiguredAudienceModelAssociationSummary) SetMembershipId(v string) *ConfiguredAudienceModelAssociationSummary {
	s.MembershipId = &v
	return s
}

// SetName sets the Name field's value.
func (s *ConfiguredAudienceModelAssociationSummary) SetName(v string) *ConfiguredAudienceModelAssociationSummary {
	s.Name = &v
	return s
}

// SetUpdateTime sets the UpdateTime field's value.
func (s *ConfiguredAudienceModelAssociationSummary) SetUpdateTime(v time.Time) *ConfiguredAudienceModelAssociationSummary {
	s.UpdateTime = &v
	return s
}

// A table that has been configured for use in a collaboration.
type ConfiguredTable struct {
	_ struct{} `type:"structure"`

	// The columns within the underlying Glue table that can be utilized within
	// collaborations.
	//
	// AllowedColumns is a required field
	AllowedColumns []*string `locationName:"allowedColumns" min:"1" type:"list" required:"true"`

	// The analysis method for the configured table. The only valid value is currently
	// `DIRECT_QUERY`.
	//
	// AnalysisMethod is a required field
	AnalysisMethod *string `locationName:"analysisMethod" type:"string" required:"true" enum:"AnalysisMethod"`

	// The types of analysis rules associated with this configured table. Currently,
	// only one analysis rule may be associated with a configured table.
	//
	// AnalysisRuleTypes is a required field
	AnalysisRuleTypes []*string `locationName:"analysisRuleTypes" type:"list" required:"true" enum:"ConfiguredTableAnalysisRuleType"`

	// The unique ARN for the configured table.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" type:"string" required:"true"`

	// The time the configured table was created.
	//
	// CreateTime is a required field
	CreateTime *time.Time `locationName:"createTime" type:"timestamp" required:"true"`

	// A description for the configured table.
	Description *string `locationName:"description" type:"string"`

	// The unique ID for the configured table.
	//
	// Id is a required field
	Id *string `locationName:"id" min:"36" type:"string" required:"true"`

	// A name for the configured table.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The Glue table that this configured table represents.
	//
	// TableReference is a required field
	TableReference *TableReference `locationName:"tableReference" type:"structure" required:"true"`

	// The time the configured table was last updated
	//
	// UpdateTime is a required field
	UpdateTime *time.Time `locationName:"updateTime" type:"timestamp" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConfiguredTable) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConfiguredTable) GoString() string {
	return s.String()
}

// SetAllowedColumns sets the AllowedColumns field's value.
func (s *ConfiguredTable) SetAllowedColumns(v []*string) *ConfiguredTable {
	s.AllowedColumns = v
	return s
}

// SetAnalysisMethod sets the AnalysisMethod field's value.
func (s *ConfiguredTable) SetAnalysisMethod(v string) *ConfiguredTable {
	s.AnalysisMethod = &v
	return s
}

// SetAnalysisRuleTypes sets the AnalysisRuleTypes field's value.
func (s *ConfiguredTable) SetAnalysisRuleTypes(v []*string) *ConfiguredTable {
	s.AnalysisRuleTypes = v
	return s
}

// SetArn sets the Arn field's value.
func (s *ConfiguredTable) SetArn(v string) *ConfiguredTable {
	s.Arn = &v
	return s
}

// SetCreateTime sets the CreateTime field's value.
func (s *ConfiguredTable) SetCreateTime(v time.Time) *ConfiguredTable {
	s.CreateTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *ConfiguredTable) SetDescription(v string) *ConfiguredTable {
	s.Description = &v
	return s
}

// SetId sets the Id field's value.
func (s *ConfiguredTable) SetId(v string) *ConfiguredTable {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *ConfiguredTable) SetName(v string) *ConfiguredTable {
	s.Name = &v
	return s
}

// SetTableReference sets the TableReference field's value.
func (s *ConfiguredTable) SetTableReference(v *TableReference) *ConfiguredTable {
	s.TableReference = v
	return s
}

// SetUpdateTime sets the UpdateTime field's value.
func (s *ConfiguredTable) SetUpdateTime(v time.Time) *ConfiguredTable {
	s.UpdateTime = &v
	return s
}

// A configured table analysis rule, which limits how data for this table can
// be used.
type ConfiguredTableAnalysisRule struct {
	_ struct{} `type:"structure"`

	// The unique ARN for the configured table.
	//
	// ConfiguredTableArn is a required field
	ConfiguredTableArn *string `locationName:"configuredTableArn" type:"string" required:"true"`

	// The unique ID for the configured table.
	//
	// ConfiguredTableId is a required field
	ConfiguredTableId *string `locationName:"configuredTableId" min:"36" type:"string" required:"true"`

	// The time the configured table analysis rule was created.
	//
	// CreateTime is a required field
	CreateTime *time.Time `locationName:"createTime" type:"timestamp" required:"true"`

	// The policy that controls SQL query rules.
	//
	// Policy is a required field
	Policy *ConfiguredTableAnalysisRulePolicy `locationName:"policy" type:"structure" required:"true"`

	// The type of configured table analysis rule.
	//
	// Type is a required field
	Type *string `locationName:"type" type:"string" required:"true" enum:"ConfiguredTableAnalysisRuleType"`

	// The time the configured table analysis rule was last updated.
	//
	// UpdateTime is a required field
	UpdateTime *time.Time `locationName:"updateTime" type:"timestamp" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConfiguredTableAnalysisRule) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConfiguredTableAnalysisRule) GoString() string {
	return s.String()
}

// SetConfiguredTableArn sets the ConfiguredTableArn field's value.
func (s *ConfiguredTableAnalysisRule) SetConfiguredTableArn(v string) *ConfiguredTableAnalysisRule {
	s.ConfiguredTableArn = &v
	return s
}

// SetConfiguredTableId sets the ConfiguredTableId field's value.
func (s *ConfiguredTableAnalysisRule) SetConfiguredTableId(v string) *ConfiguredTableAnalysisRule {
	s.ConfiguredTableId = &v
	return s
}

// SetCreateTime sets the CreateTime field's value.
func (s *ConfiguredTableAnalysisRule) SetCreateTime(v time.Time) *ConfiguredTableAnalysisRule {
	s.CreateTime = &v
	return s
}

// SetPolicy sets the Policy field's value.
func (s *ConfiguredTableAnalysisRule) SetPolicy(v *ConfiguredTableAnalysisRulePolicy) *ConfiguredTableAnalysisRule {
	s.Policy = v
	return s
}

// SetType sets the Type field's value.
func (s *ConfiguredTableAnalysisRule) SetType(v string) *ConfiguredTableAnalysisRule {
	s.Type = &v
	return s
}

// SetUpdateTime sets the UpdateTime field's value.
func (s *ConfiguredTableAnalysisRule) SetUpdateTime(v time.Time) *ConfiguredTableAnalysisRule {
	s.UpdateTime = &v
	return s
}

// Controls on the query specifications that can be run on a configured table.
type ConfiguredTableAnalysisRulePolicy struct {
	_ struct{} `type:"structure"`

	// Controls on the query specifications that can be run on a configured table.
	V1 *ConfiguredTableAnalysisRulePolicyV1 `locationName:"v1" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConfiguredTableAnalysisRulePolicy) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConfiguredTableAnalysisRulePolicy) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ConfiguredTableAnalysisRulePolicy) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ConfiguredTableAnalysisRulePolicy"}
	if s.V1 != nil {
		if err := s.V1.Validate(); err != nil {
			invalidParams.AddNested("V1", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetV1 sets the V1 field's value.
func (s *ConfiguredTableAnalysisRulePolicy) SetV1(v *ConfiguredTableAnalysisRulePolicyV1) *ConfiguredTableAnalysisRulePolicy {
	s.V1 = v
	return s
}

// Controls on the query specifications that can be run on a configured table.
type ConfiguredTableAnalysisRulePolicyV1 struct {
	_ struct{} `type:"structure"`

	// Analysis rule type that enables only aggregation queries on a configured
	// table.
	Aggregation *AnalysisRuleAggregation `locationName:"aggregation" type:"structure"`

	// A type of analysis rule that enables the table owner to approve custom SQL
	// queries on their configured tables. It supports differential privacy.
	Custom *AnalysisRuleCustom `locationName:"custom" type:"structure"`

	// Analysis rule type that enables only list queries on a configured table.
	List *AnalysisRuleList `locationName:"list" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConfiguredTableAnalysisRulePolicyV1) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConfiguredTableAnalysisRulePolicyV1) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ConfiguredTableAnalysisRulePolicyV1) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ConfiguredTableAnalysisRulePolicyV1"}
	if s.Aggregation != nil {
		if err := s.Aggregation.Validate(); err != nil {
			invalidParams.AddNested("Aggregation", err.(request.ErrInvalidParams))
		}
	}
	if s.Custom != nil {
		if err := s.Custom.Validate(); err != nil {
			invalidParams.AddNested("Custom", err.(request.ErrInvalidParams))
		}
	}
	if s.List != nil {
		if err := s.List.Validate(); err != nil {
			invalidParams.AddNested("List", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAggregation sets the Aggregation field's value.
func (s *ConfiguredTableAnalysisRulePolicyV1) SetAggregation(v *AnalysisRuleAggregation) *ConfiguredTableAnalysisRulePolicyV1 {
	s.Aggregation = v
	return s
}

// SetCustom sets the Custom field's value.
func (s *ConfiguredTableAnalysisRulePolicyV1) SetCustom(v *AnalysisRuleCustom) *ConfiguredTableAnalysisRulePolicyV1 {
	s.Custom = v
	return s
}

// SetList sets the List field's value.
func (s *ConfiguredTableAnalysisRulePolicyV1) SetList(v *AnalysisRuleList) *ConfiguredTableAnalysisRulePolicyV1 {
	s.List = v
	return s
}

// A configured table association links a configured table to a collaboration.
type ConfiguredTableAssociation struct {
	_ struct{} `type:"structure"`

	// The unique ARN for the configured table association.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" type:"string" required:"true"`

	// The unique ARN for the configured table that the association refers to.
	//
	// ConfiguredTableArn is a required field
	ConfiguredTableArn *string `locationName:"configuredTableArn" type:"string" required:"true"`

	// The unique ID for the configured table that the association refers to.
	//
	// ConfiguredTableId is a required field
	ConfiguredTableId *string `locationName:"configuredTableId" min:"36" type:"string" required:"true"`

	// The time the configured table association was created.
	//
	// CreateTime is a required field
	CreateTime *time.Time `locationName:"createTime" type:"timestamp" required:"true"`

	// A description of the configured table association.
	Description *string `locationName:"description" type:"string"`

	// The unique ID for the configured table association.
	//
	// Id is a required field
	Id *string `locationName:"id" min:"36" type:"string" required:"true"`

	// The unique ARN for the membership this configured table association belongs
	// to.
	//
	// MembershipArn is a required field
	MembershipArn *string `locationName:"membershipArn" type:"string" required:"true"`

	// The unique ID for the membership this configured table association belongs
	// to.
	//
	// MembershipId is a required field
	MembershipId *string `locationName:"membershipId" min:"36" type:"string" required:"true"`

	// The name of the configured table association, in lowercase. The table is
	// identified by this name when running protected queries against the underlying
	// data.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// The service will assume this role to access catalog metadata and query the
	// table.
	//
	// RoleArn is a required field
	RoleArn *string `locationName:"roleArn" min:"32" type:"string" required:"true"`

	// The time the configured table association was last updated.
	//
	// UpdateTime is a required field
	UpdateTime *time.Time `locationName:"updateTime" type:"timestamp" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConfiguredTableAssociation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConfiguredTableAssociation) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *ConfiguredTableAssociation) SetArn(v string) *ConfiguredTableAssociation {
	s.Arn = &v
	return s
}

// SetConfiguredTableArn sets the ConfiguredTableArn field's value.
func (s *ConfiguredTableAssociation) SetConfiguredTableArn(v string) *ConfiguredTableAssociation {
	s.ConfiguredTableArn = &v
	return s
}

// SetConfiguredTableId sets the ConfiguredTableId field's value.
func (s *ConfiguredTableAssociation) SetConfiguredTableId(v string) *ConfiguredTableAssociation {
	s.ConfiguredTableId = &v
	return s
}

// SetCreateTime sets the CreateTime field's value.
func (s *ConfiguredTableAssociation) SetCreateTime(v time.Time) *ConfiguredTableAssociation {
	s.CreateTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *ConfiguredTableAssociation) SetDescription(v string) *ConfiguredTableAssociation {
	s.Description = &v
	return s
}

// SetId sets the Id field's value.
func (s *ConfiguredTableAssociation) SetId(v string) *ConfiguredTableAssociation {
	s.Id = &v
	return s
}

// SetMembershipArn sets the MembershipArn field's value.
func (s *ConfiguredTableAssociation) SetMembershipArn(v string) *ConfiguredTableAssociation {
	s.MembershipArn = &v
	return s
}

// SetMembershipId sets the MembershipId field's value.
func (s *ConfiguredTableAssociation) SetMembershipId(v string) *ConfiguredTableAssociation {
	s.MembershipId = &v
	return s
}

// SetName sets the Name field's value.
func (s *ConfiguredTableAssociation) SetName(v string) *ConfiguredTableAssociation {
	s.Name = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *ConfiguredTableAssociation) SetRoleArn(v string) *ConfiguredTableAssociation {
	s.RoleArn = &v
	return s
}

// SetUpdateTime sets the UpdateTime field's value.
func (s *ConfiguredTableAssociation) SetUpdateTime(v time.Time) *ConfiguredTableAssociation {
	s.UpdateTime = &v
	return s
}

// The configured table association summary for the objects listed by the request.
type ConfiguredTableAssociationSummary struct {
	_ struct{} `type:"structure"`

	// The unique ARN for the configured table association.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" type:"string" required:"true"`

	// The unique configured table ID that this configured table association refers
	// to.
	//
	// ConfiguredTableId is a required field
	ConfiguredTableId *string `locationName:"configuredTableId" min:"36" type:"string" required:"true"`

	// The time the configured table association was created.
	//
	// CreateTime is a required field
	CreateTime *time.Time `locationName:"createTime" type:"timestamp" required:"true"`

	// The unique ID for the configured table association.
	//
	// Id is a required field
	Id *string `locationName:"id" min:"36" type:"string" required:"true"`

	// The unique ARN for the membership that the configured table association belongs
	// to.
	//
	// MembershipArn is a required field
	MembershipArn *string `locationName:"membershipArn" type:"string" required:"true"`

	// The unique ID for the membership that the configured table association belongs
	// to.
	//
	// MembershipId is a required field
	MembershipId *string `locationName:"membershipId" min:"36" type:"string" required:"true"`

	// The name of the configured table association. The table is identified by
	// this name when running Protected Queries against the underlying data.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// The time the configured table association was last updated.
	//
	// UpdateTime is a required field
	UpdateTime *time.Time `locationName:"updateTime" type:"timestamp" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConfiguredTableAssociationSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConfiguredTableAssociationSummary) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *ConfiguredTableAssociationSummary) SetArn(v string) *ConfiguredTableAssociationSummary {
	s.Arn = &v
	return s
}

// SetConfiguredTableId sets the ConfiguredTableId field's value.
func (s *ConfiguredTableAssociationSummary) SetConfiguredTableId(v string) *ConfiguredTableAssociationSummary {
	s.ConfiguredTableId = &v
	return s
}

// SetCreateTime sets the CreateTime field's value.
func (s *ConfiguredTableAssociationSummary) SetCreateTime(v time.Time) *ConfiguredTableAssociationSummary {
	s.CreateTime = &v
	return s
}

// SetId sets the Id field's value.
func (s *ConfiguredTableAssociationSummary) SetId(v string) *ConfiguredTableAssociationSummary {
	s.Id = &v
	return s
}

// SetMembershipArn sets the MembershipArn field's value.
func (s *ConfiguredTableAssociationSummary) SetMembershipArn(v string) *ConfiguredTableAssociationSummary {
	s.MembershipArn = &v
	return s
}

// SetMembershipId sets the MembershipId field's value.
func (s *ConfiguredTableAssociationSummary) SetMembershipId(v string) *ConfiguredTableAssociationSummary {
	s.MembershipId = &v
	return s
}

// SetName sets the Name field's value.
func (s *ConfiguredTableAssociationSummary) SetName(v string) *ConfiguredTableAssociationSummary {
	s.Name = &v
	return s
}

// SetUpdateTime sets the UpdateTime field's value.
func (s *ConfiguredTableAssociationSummary) SetUpdateTime(v time.Time) *ConfiguredTableAssociationSummary {
	s.UpdateTime = &v
	return s
}

// The configured table summary for the objects listed by the request.
type ConfiguredTableSummary struct {
	_ struct{} `type:"structure"`

	// The analysis method for the configured tables. The only valid value is currently
	// `DIRECT_QUERY`.
	//
	// AnalysisMethod is a required field
	AnalysisMethod *string `locationName:"analysisMethod" type:"string" required:"true" enum:"AnalysisMethod"`

	// The types of analysis rules associated with this configured table.
	//
	// AnalysisRuleTypes is a required field
	AnalysisRuleTypes []*string `locationName:"analysisRuleTypes" type:"list" required:"true" enum:"ConfiguredTableAnalysisRuleType"`

	// The unique ARN of the configured table.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" type:"string" required:"true"`

	// The time the configured table was created.
	//
	// CreateTime is a required field
	CreateTime *time.Time `locationName:"createTime" type:"timestamp" required:"true"`

	// The unique ID of the configured table.
	//
	// Id is a required field
	Id *string `locationName:"id" min:"36" type:"string" required:"true"`

	// The name of the configured table.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The time the configured table was last updated.
	//
	// UpdateTime is a required field
	UpdateTime *time.Time `locationName:"updateTime" type:"timestamp" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConfiguredTableSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConfiguredTableSummary) GoString() string {
	return s.String()
}

// SetAnalysisMethod sets the AnalysisMethod field's value.
func (s *ConfiguredTableSummary) SetAnalysisMethod(v string) *ConfiguredTableSummary {
	s.AnalysisMethod = &v
	return s
}

// SetAnalysisRuleTypes sets the AnalysisRuleTypes field's value.
func (s *ConfiguredTableSummary) SetAnalysisRuleTypes(v []*string) *ConfiguredTableSummary {
	s.AnalysisRuleTypes = v
	return s
}

// SetArn sets the Arn field's value.
func (s *ConfiguredTableSummary) SetArn(v string) *ConfiguredTableSummary {
	s.Arn = &v
	return s
}

// SetCreateTime sets the CreateTime field's value.
func (s *ConfiguredTableSummary) SetCreateTime(v time.Time) *ConfiguredTableSummary {
	s.CreateTime = &v
	return s
}

// SetId sets the Id field's value.
func (s *ConfiguredTableSummary) SetId(v string) *ConfiguredTableSummary {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *ConfiguredTableSummary) SetName(v string) *ConfiguredTableSummary {
	s.Name = &v
	return s
}

// SetUpdateTime sets the UpdateTime field's value.
func (s *ConfiguredTableSummary) SetUpdateTime(v time.Time) *ConfiguredTableSummary {
	s.UpdateTime = &v
	return s
}

// Updating or deleting a resource can cause an inconsistent state.
type ConflictException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`

	// A reason code for the exception.
	Reason *string `locationName:"reason" type:"string" enum:"ConflictExceptionReason"`

	// The ID of the conflicting resource.
	ResourceId *string `locationName:"resourceId" type:"string"`

	// The type of the conflicting resource.
	ResourceType *string `locationName:"resourceType" type:"string" enum:"ResourceType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) GoString() string {
	return s.String()
}

func newErrorConflictException(v protocol.ResponseMetadata) error {
	return &ConflictException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConflictException) Code() string {
	return "ConflictException"
}

// Message returns the exception's message.
func (s *ConflictException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConflictException) OrigErr() error {
	return nil
}

func (s *ConflictException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConflictException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConflictException) RequestID() string {
	return s.RespMetadata.RequestID
}

type CreateAnalysisTemplateInput struct {
	_ struct{} `type:"structure"`

	// The parameters of the analysis template.
	AnalysisParameters []*AnalysisParameter `locationName:"analysisParameters" type:"list" sensitive:"true"`

	// The description of the analysis template.
	Description *string `locationName:"description" type:"string"`

	// The format of the analysis template.
	//
	// Format is a required field
	Format *string `locationName:"format" type:"string" required:"true" enum:"AnalysisFormat"`

	// The identifier for a membership resource.
	//
	// MembershipIdentifier is a required field
	MembershipIdentifier *string `location:"uri" locationName:"membershipIdentifier" min:"36" type:"string" required:"true"`

	// The name of the analysis template.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// The information in the analysis template. Currently supports text, the query
	// text for the analysis template.
	//
	// Source is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateAnalysisTemplateInput's
	// String and GoString methods.
	//
	// Source is a required field
	Source *AnalysisSource `locationName:"source" type:"structure" required:"true" sensitive:"true"`

	// An optional label that you can assign to a resource when you create it. Each
	// tag consists of a key and an optional value, both of which you define. When
	// you use tagging, you can also use tag-based access control in IAM policies
	// to control access to this resource.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAnalysisTemplateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAnalysisTemplateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateAnalysisTemplateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateAnalysisTemplateInput"}
	if s.Format == nil {
		invalidParams.Add(request.NewErrParamRequired("Format"))
	}
	if s.MembershipIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("MembershipIdentifier"))
	}
	if s.MembershipIdentifier != nil && len(*s.MembershipIdentifier) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("MembershipIdentifier", 36))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Source == nil {
		invalidParams.Add(request.NewErrParamRequired("Source"))
	}
	if s.AnalysisParameters != nil {
		for i, v := range s.AnalysisParameters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "AnalysisParameters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAnalysisParameters sets the AnalysisParameters field's value.
func (s *CreateAnalysisTemplateInput) SetAnalysisParameters(v []*AnalysisParameter) *CreateAnalysisTemplateInput {
	s.AnalysisParameters = v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateAnalysisTemplateInput) SetDescription(v string) *CreateAnalysisTemplateInput {
	s.Description = &v
	return s
}

// SetFormat sets the Format field's value.
func (s *CreateAnalysisTemplateInput) SetFormat(v string) *CreateAnalysisTemplateInput {
	s.Format = &v
	return s
}

// SetMembershipIdentifier sets the MembershipIdentifier field's value.
func (s *CreateAnalysisTemplateInput) SetMembershipIdentifier(v string) *CreateAnalysisTemplateInput {
	s.MembershipIdentifier = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateAnalysisTemplateInput) SetName(v string) *CreateAnalysisTemplateInput {
	s.Name = &v
	return s
}

// SetSource sets the Source field's value.
func (s *CreateAnalysisTemplateInput) SetSource(v *AnalysisSource) *CreateAnalysisTemplateInput {
	s.Source = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateAnalysisTemplateInput) SetTags(v map[string]*string) *CreateAnalysisTemplateInput {
	s.Tags = v
	return s
}

type CreateAnalysisTemplateOutput struct {
	_ struct{} `type:"structure"`

	// The analysis template.
	//
	// AnalysisTemplate is a required field
	AnalysisTemplate *AnalysisTemplate `locationName:"analysisTemplate" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAnalysisTemplateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAnalysisTemplateOutput) GoString() string {
	return s.String()
}

// SetAnalysisTemplate sets the AnalysisTemplate field's value.
func (s *CreateAnalysisTemplateOutput) SetAnalysisTemplate(v *AnalysisTemplate) *CreateAnalysisTemplateOutput {
	s.AnalysisTemplate = v
	return s
}

type CreateCollaborationInput struct {
	_ struct{} `type:"structure"`

	// The display name of the collaboration creator.
	//
	// CreatorDisplayName is a required field
	CreatorDisplayName *string `locationName:"creatorDisplayName" min:"1" type:"string" required:"true"`

	// The abilities granted to the collaboration creator.
	//
	// CreatorMemberAbilities is a required field
	CreatorMemberAbilities []*string `locationName:"creatorMemberAbilities" type:"list" required:"true" enum:"MemberAbility"`

	// The collaboration creator's payment responsibilities set by the collaboration
	// creator.
	//
	// If the collaboration creator hasn't specified anyone as the member paying
	// for query compute costs, then the member who can query is the default payer.
	CreatorPaymentConfiguration *PaymentConfiguration `locationName:"creatorPaymentConfiguration" type:"structure"`

	// The settings for client-side encryption with Cryptographic Computing for
	// Clean Rooms.
	DataEncryptionMetadata *DataEncryptionMetadata `locationName:"dataEncryptionMetadata" type:"structure"`

	// A description of the collaboration provided by the collaboration owner.
	//
	// Description is a required field
	Description *string `locationName:"description" min:"1" type:"string" required:"true"`

	// A list of initial members, not including the creator. This list is immutable.
	//
	// Members is a required field
	Members []*MemberSpecification `locationName:"members" type:"list" required:"true"`

	// The display name for a collaboration.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// An indicator as to whether query logging has been enabled or disabled for
	// the collaboration.
	//
	// QueryLogStatus is a required field
	QueryLogStatus *string `locationName:"queryLogStatus" type:"string" required:"true" enum:"CollaborationQueryLogStatus"`

	// An optional label that you can assign to a resource when you create it. Each
	// tag consists of a key and an optional value, both of which you define. When
	// you use tagging, you can also use tag-based access control in IAM policies
	// to control access to this resource.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateCollaborationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateCollaborationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateCollaborationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateCollaborationInput"}
	if s.CreatorDisplayName == nil {
		invalidParams.Add(request.NewErrParamRequired("CreatorDisplayName"))
	}
	if s.CreatorDisplayName != nil && len(*s.CreatorDisplayName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CreatorDisplayName", 1))
	}
	if s.CreatorMemberAbilities == nil {
		invalidParams.Add(request.NewErrParamRequired("CreatorMemberAbilities"))
	}
	if s.Description == nil {
		invalidParams.Add(request.NewErrParamRequired("Description"))
	}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.Members == nil {
		invalidParams.Add(request.NewErrParamRequired("Members"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.QueryLogStatus == nil {
		invalidParams.Add(request.NewErrParamRequired("QueryLogStatus"))
	}
	if s.CreatorPaymentConfiguration != nil {
		if err := s.CreatorPaymentConfiguration.Validate(); err != nil {
			invalidParams.AddNested("CreatorPaymentConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.DataEncryptionMetadata != nil {
		if err := s.DataEncryptionMetadata.Validate(); err != nil {
			invalidParams.AddNested("DataEncryptionMetadata", err.(request.ErrInvalidParams))
		}
	}
	if s.Members != nil {
		for i, v := range s.Members {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Members", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCreatorDisplayName sets the CreatorDisplayName field's value.
func (s *CreateCollaborationInput) SetCreatorDisplayName(v string) *CreateCollaborationInput {
	s.CreatorDisplayName = &v
	return s
}

// SetCreatorMemberAbilities sets the CreatorMemberAbilities field's value.
func (s *CreateCollaborationInput) SetCreatorMemberAbilities(v []*string) *CreateCollaborationInput {
	s.CreatorMemberAbilities = v
	return s
}

// SetCreatorPaymentConfiguration sets the CreatorPaymentConfiguration field's value.
func (s *CreateCollaborationInput) SetCreatorPaymentConfiguration(v *PaymentConfiguration) *CreateCollaborationInput {
	s.CreatorPaymentConfiguration = v
	return s
}

// SetDataEncryptionMetadata sets the DataEncryptionMetadata field's value.
func (s *CreateCollaborationInput) SetDataEncryptionMetadata(v *DataEncryptionMetadata) *CreateCollaborationInput {
	s.DataEncryptionMetadata = v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateCollaborationInput) SetDescription(v string) *CreateCollaborationInput {
	s.Description = &v
	return s
}

// SetMembers sets the Members field's value.
func (s *CreateCollaborationInput) SetMembers(v []*MemberSpecification) *CreateCollaborationInput {
	s.Members = v
	return s
}

// SetName sets the Name field's value.
func (s *CreateCollaborationInput) SetName(v string) *CreateCollaborationInput {
	s.Name = &v
	return s
}

// SetQueryLogStatus sets the QueryLogStatus field's value.
func (s *CreateCollaborationInput) SetQueryLogStatus(v string) *CreateCollaborationInput {
	s.QueryLogStatus = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateCollaborationInput) SetTags(v map[string]*string) *CreateCollaborationInput {
	s.Tags = v
	return s
}

type CreateCollaborationOutput struct {
	_ struct{} `type:"structure"`

	// The entire created collaboration object.
	//
	// Collaboration is a required field
	Collaboration *Collaboration `locationName:"collaboration" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateCollaborationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateCollaborationOutput) GoString() string {
	return s.String()
}

// SetCollaboration sets the Collaboration field's value.
func (s *CreateCollaborationOutput) SetCollaboration(v *Collaboration) *CreateCollaborationOutput {
	s.Collaboration = v
	return s
}

type CreateConfiguredAudienceModelAssociationInput struct {
	_ struct{} `type:"structure"`

	// A unique identifier for the configured audience model that you want to associate.
	//
	// ConfiguredAudienceModelArn is a required field
	ConfiguredAudienceModelArn *string `locationName:"configuredAudienceModelArn" min:"20" type:"string" required:"true"`

	// The name of the configured audience model association.
	//
	// ConfiguredAudienceModelAssociationName is a required field
	ConfiguredAudienceModelAssociationName *string `locationName:"configuredAudienceModelAssociationName" min:"1" type:"string" required:"true"`

	// A description of the configured audience model association.
	Description *string `locationName:"description" type:"string"`

	// When TRUE, indicates that the resource policy for the configured audience
	// model resource being associated is configured for Clean Rooms to manage permissions
	// related to the given collaboration. When FALSE, indicates that the configured
	// audience model resource owner will manage permissions related to the given
	// collaboration.
	//
	// Setting this to TRUE requires you to have permissions to create, update,
	// and delete the resource policy for the cleanrooms-ml resource when you call
	// the DeleteConfiguredAudienceModelAssociation resource. In addition, if you
	// are the collaboration creator and specify TRUE, you must have the same permissions
	// when you call the DeleteMember and DeleteCollaboration APIs.
	//
	// ManageResourcePolicies is a required field
	ManageResourcePolicies *bool `locationName:"manageResourcePolicies" type:"boolean" required:"true"`

	// A unique identifier for one of your memberships for a collaboration. The
	// configured audience model is associated to the collaboration that this membership
	// belongs to. Accepts a membership ID.
	//
	// MembershipIdentifier is a required field
	MembershipIdentifier *string `location:"uri" locationName:"membershipIdentifier" min:"36" type:"string" required:"true"`

	// An optional label that you can assign to a resource when you create it. Each
	// tag consists of a key and an optional value, both of which you define. When
	// you use tagging, you can also use tag-based access control in IAM policies
	// to control access to this resource.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateConfiguredAudienceModelAssociationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateConfiguredAudienceModelAssociationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateConfiguredAudienceModelAssociationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateConfiguredAudienceModelAssociationInput"}
	if s.ConfiguredAudienceModelArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfiguredAudienceModelArn"))
	}
	if s.ConfiguredAudienceModelArn != nil && len(*s.ConfiguredAudienceModelArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("ConfiguredAudienceModelArn", 20))
	}
	if s.ConfiguredAudienceModelAssociationName == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfiguredAudienceModelAssociationName"))
	}
	if s.ConfiguredAudienceModelAssociationName != nil && len(*s.ConfiguredAudienceModelAssociationName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConfiguredAudienceModelAssociationName", 1))
	}
	if s.ManageResourcePolicies == nil {
		invalidParams.Add(request.NewErrParamRequired("ManageResourcePolicies"))
	}
	if s.MembershipIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("MembershipIdentifier"))
	}
	if s.MembershipIdentifier != nil && len(*s.MembershipIdentifier) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("MembershipIdentifier", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfiguredAudienceModelArn sets the ConfiguredAudienceModelArn field's value.
func (s *CreateConfiguredAudienceModelAssociationInput) SetConfiguredAudienceModelArn(v string) *CreateConfiguredAudienceModelAssociationInput {
	s.ConfiguredAudienceModelArn = &v
	return s
}

// SetConfiguredAudienceModelAssociationName sets the ConfiguredAudienceModelAssociationName field's value.
func (s *CreateConfiguredAudienceModelAssociationInput) SetConfiguredAudienceModelAssociationName(v string) *CreateConfiguredAudienceModelAssociationInput {
	s.ConfiguredAudienceModelAssociationName = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateConfiguredAudienceModelAssociationInput) SetDescription(v string) *CreateConfiguredAudienceModelAssociationInput {
	s.Description = &v
	return s
}

// SetManageResourcePolicies sets the ManageResourcePolicies field's value.
func (s *CreateConfiguredAudienceModelAssociationInput) SetManageResourcePolicies(v bool) *CreateConfiguredAudienceModelAssociationInput {
	s.ManageResourcePolicies = &v
	return s
}

// SetMembershipIdentifier sets the MembershipIdentifier field's value.
func (s *CreateConfiguredAudienceModelAssociationInput) SetMembershipIdentifier(v string) *CreateConfiguredAudienceModelAssociationInput {
	s.MembershipIdentifier = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateConfiguredAudienceModelAssociationInput) SetTags(v map[string]*string) *CreateConfiguredAudienceModelAssociationInput {
	s.Tags = v
	return s
}

type CreateConfiguredAudienceModelAssociationOutput struct {
	_ struct{} `type:"structure"`

	// Information about the configured audience model association.
	//
	// ConfiguredAudienceModelAssociation is a required field
	ConfiguredAudienceModelAssociation *ConfiguredAudienceModelAssociation `locationName:"configuredAudienceModelAssociation" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateConfiguredAudienceModelAssociationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateConfiguredAudienceModelAssociationOutput) GoString() string {
	return s.String()
}

// SetConfiguredAudienceModelAssociation sets the ConfiguredAudienceModelAssociation field's value.
func (s *CreateConfiguredAudienceModelAssociationOutput) SetConfiguredAudienceModelAssociation(v *ConfiguredAudienceModelAssociation) *CreateConfiguredAudienceModelAssociationOutput {
	s.ConfiguredAudienceModelAssociation = v
	return s
}

type CreateConfiguredTableAnalysisRuleInput struct {
	_ struct{} `type:"structure"`

	// The entire created configured table analysis rule object.
	//
	// AnalysisRulePolicy is a required field
	AnalysisRulePolicy *ConfiguredTableAnalysisRulePolicy `locationName:"analysisRulePolicy" type:"structure" required:"true"`

	// The type of analysis rule.
	//
	// AnalysisRuleType is a required field
	AnalysisRuleType *string `locationName:"analysisRuleType" type:"string" required:"true" enum:"ConfiguredTableAnalysisRuleType"`

	// The identifier for the configured table to create the analysis rule for.
	// Currently accepts the configured table ID.
	//
	// ConfiguredTableIdentifier is a required field
	ConfiguredTableIdentifier *string `location:"uri" locationName:"configuredTableIdentifier" min:"36" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateConfiguredTableAnalysisRuleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateConfiguredTableAnalysisRuleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateConfiguredTableAnalysisRuleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateConfiguredTableAnalysisRuleInput"}
	if s.AnalysisRulePolicy == nil {
		invalidParams.Add(request.NewErrParamRequired("AnalysisRulePolicy"))
	}
	if s.AnalysisRuleType == nil {
		invalidParams.Add(request.NewErrParamRequired("AnalysisRuleType"))
	}
	if s.ConfiguredTableIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfiguredTableIdentifier"))
	}
	if s.ConfiguredTableIdentifier != nil && len(*s.ConfiguredTableIdentifier) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("ConfiguredTableIdentifier", 36))
	}
	if s.AnalysisRulePolicy != nil {
		if err := s.AnalysisRulePolicy.Validate(); err != nil {
			invalidParams.AddNested("AnalysisRulePolicy", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAnalysisRulePolicy sets the AnalysisRulePolicy field's value.
func (s *CreateConfiguredTableAnalysisRuleInput) SetAnalysisRulePolicy(v *ConfiguredTableAnalysisRulePolicy) *CreateConfiguredTableAnalysisRuleInput {
	s.AnalysisRulePolicy = v
	return s
}

// SetAnalysisRuleType sets the AnalysisRuleType field's value.
func (s *CreateConfiguredTableAnalysisRuleInput) SetAnalysisRuleType(v string) *CreateConfiguredTableAnalysisRuleInput {
	s.AnalysisRuleType = &v
	return s
}

// SetConfiguredTableIdentifier sets the ConfiguredTableIdentifier field's value.
func (s *CreateConfiguredTableAnalysisRuleInput) SetConfiguredTableIdentifier(v string) *CreateConfiguredTableAnalysisRuleInput {
	s.ConfiguredTableIdentifier = &v
	return s
}

type CreateConfiguredTableAnalysisRuleOutput struct {
	_ struct{} `type:"structure"`

	// The entire created analysis rule.
	//
	// AnalysisRule is a required field
	AnalysisRule *ConfiguredTableAnalysisRule `locationName:"analysisRule" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateConfiguredTableAnalysisRuleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateConfiguredTableAnalysisRuleOutput) GoString() string {
	return s.String()
}

// SetAnalysisRule sets the AnalysisRule field's value.
func (s *CreateConfiguredTableAnalysisRuleOutput) SetAnalysisRule(v *ConfiguredTableAnalysisRule) *CreateConfiguredTableAnalysisRuleOutput {
	s.AnalysisRule = v
	return s
}

type CreateConfiguredTableAssociationInput struct {
	_ struct{} `type:"structure"`

	// A unique identifier for the configured table to be associated to. Currently
	// accepts a configured table ID.
	//
	// ConfiguredTableIdentifier is a required field
	ConfiguredTableIdentifier *string `locationName:"configuredTableIdentifier" min:"36" type:"string" required:"true"`

	// A description for the configured table association.
	Description *string `locationName:"description" type:"string"`

	// A unique identifier for one of your memberships for a collaboration. The
	// configured table is associated to the collaboration that this membership
	// belongs to. Currently accepts a membership ID.
	//
	// MembershipIdentifier is a required field
	MembershipIdentifier *string `location:"uri" locationName:"membershipIdentifier" min:"36" type:"string" required:"true"`

	// The name of the configured table association. This name is used to query
	// the underlying configured table.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// The service will assume this role to access catalog metadata and query the
	// table.
	//
	// RoleArn is a required field
	RoleArn *string `locationName:"roleArn" min:"32" type:"string" required:"true"`

	// An optional label that you can assign to a resource when you create it. Each
	// tag consists of a key and an optional value, both of which you define. When
	// you use tagging, you can also use tag-based access control in IAM policies
	// to control access to this resource.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateConfiguredTableAssociationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateConfiguredTableAssociationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateConfiguredTableAssociationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateConfiguredTableAssociationInput"}
	if s.ConfiguredTableIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfiguredTableIdentifier"))
	}
	if s.ConfiguredTableIdentifier != nil && len(*s.ConfiguredTableIdentifier) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("ConfiguredTableIdentifier", 36))
	}
	if s.MembershipIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("MembershipIdentifier"))
	}
	if s.MembershipIdentifier != nil && len(*s.MembershipIdentifier) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("MembershipIdentifier", 36))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.RoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleArn"))
	}
	if s.RoleArn != nil && len(*s.RoleArn) < 32 {
		invalidParams.Add(request.NewErrParamMinLen("RoleArn", 32))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfiguredTableIdentifier sets the ConfiguredTableIdentifier field's value.
func (s *CreateConfiguredTableAssociationInput) SetConfiguredTableIdentifier(v string) *CreateConfiguredTableAssociationInput {
	s.ConfiguredTableIdentifier = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateConfiguredTableAssociationInput) SetDescription(v string) *CreateConfiguredTableAssociationInput {
	s.Description = &v
	return s
}

// SetMembershipIdentifier sets the MembershipIdentifier field's value.
func (s *CreateConfiguredTableAssociationInput) SetMembershipIdentifier(v string) *CreateConfiguredTableAssociationInput {
	s.MembershipIdentifier = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateConfiguredTableAssociationInput) SetName(v string) *CreateConfiguredTableAssociationInput {
	s.Name = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *CreateConfiguredTableAssociationInput) SetRoleArn(v string) *CreateConfiguredTableAssociationInput {
	s.RoleArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateConfiguredTableAssociationInput) SetTags(v map[string]*string) *CreateConfiguredTableAssociationInput {
	s.Tags = v
	return s
}

type CreateConfiguredTableAssociationOutput struct {
	_ struct{} `type:"structure"`

	// The entire configured table association object.
	//
	// ConfiguredTableAssociation is a required field
	ConfiguredTableAssociation *ConfiguredTableAssociation `locationName:"configuredTableAssociation" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateConfiguredTableAssociationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateConfiguredTableAssociationOutput) GoString() string {
	return s.String()
}

// SetConfiguredTableAssociation sets the ConfiguredTableAssociation field's value.
func (s *CreateConfiguredTableAssociationOutput) SetConfiguredTableAssociation(v *ConfiguredTableAssociation) *CreateConfiguredTableAssociationOutput {
	s.ConfiguredTableAssociation = v
	return s
}

type CreateConfiguredTableInput struct {
	_ struct{} `type:"structure"`

	// The columns of the underlying table that can be used by collaborations or
	// analysis rules.
	//
	// AllowedColumns is a required field
	AllowedColumns []*string `locationName:"allowedColumns" min:"1" type:"list" required:"true"`

	// The analysis method for the configured tables. The only valid value is currently
	// `DIRECT_QUERY`.
	//
	// AnalysisMethod is a required field
	AnalysisMethod *string `locationName:"analysisMethod" type:"string" required:"true" enum:"AnalysisMethod"`

	// A description for the configured table.
	Description *string `locationName:"description" type:"string"`

	// The name of the configured table.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// A reference to the Glue table being configured.
	//
	// TableReference is a required field
	TableReference *TableReference `locationName:"tableReference" type:"structure" required:"true"`

	// An optional label that you can assign to a resource when you create it. Each
	// tag consists of a key and an optional value, both of which you define. When
	// you use tagging, you can also use tag-based access control in IAM policies
	// to control access to this resource.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateConfiguredTableInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateConfiguredTableInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateConfiguredTableInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateConfiguredTableInput"}
	if s.AllowedColumns == nil {
		invalidParams.Add(request.NewErrParamRequired("AllowedColumns"))
	}
	if s.AllowedColumns != nil && len(s.AllowedColumns) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AllowedColumns", 1))
	}
	if s.AnalysisMethod == nil {
		invalidParams.Add(request.NewErrParamRequired("AnalysisMethod"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.TableReference == nil {
		invalidParams.Add(request.NewErrParamRequired("TableReference"))
	}
	if s.TableReference != nil {
		if err := s.TableReference.Validate(); err != nil {
			invalidParams.AddNested("TableReference", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAllowedColumns sets the AllowedColumns field's value.
func (s *CreateConfiguredTableInput) SetAllowedColumns(v []*string) *CreateConfiguredTableInput {
	s.AllowedColumns = v
	return s
}

// SetAnalysisMethod sets the AnalysisMethod field's value.
func (s *CreateConfiguredTableInput) SetAnalysisMethod(v string) *CreateConfiguredTableInput {
	s.AnalysisMethod = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateConfiguredTableInput) SetDescription(v string) *CreateConfiguredTableInput {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateConfiguredTableInput) SetName(v string) *CreateConfiguredTableInput {
	s.Name = &v
	return s
}

// SetTableReference sets the TableReference field's value.
func (s *CreateConfiguredTableInput) SetTableReference(v *TableReference) *CreateConfiguredTableInput {
	s.TableReference = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateConfiguredTableInput) SetTags(v map[string]*string) *CreateConfiguredTableInput {
	s.Tags = v
	return s
}

type CreateConfiguredTableOutput struct {
	_ struct{} `type:"structure"`

	// The created configured table.
	//
	// ConfiguredTable is a required field
	ConfiguredTable *ConfiguredTable `locationName:"configuredTable" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateConfiguredTableOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateConfiguredTableOutput) GoString() string {
	return s.String()
}

// SetConfiguredTable sets the ConfiguredTable field's value.
func (s *CreateConfiguredTableOutput) SetConfiguredTable(v *ConfiguredTable) *CreateConfiguredTableOutput {
	s.ConfiguredTable = v
	return s
}

type CreateIdMappingTableInput struct {
	_ struct{} `type:"structure"`

	// A description of the ID mapping table.
	Description *string `locationName:"description" type:"string"`

	// The input reference configuration needed to create the ID mapping table.
	//
	// InputReferenceConfig is a required field
	InputReferenceConfig *IdMappingTableInputReferenceConfig `locationName:"inputReferenceConfig" type:"structure" required:"true"`

	// The Amazon Resource Name (ARN) of the Amazon Web Services KMS key. This value
	// is used to encrypt the mapping table data that is stored by Clean Rooms.
	KmsKeyArn *string `locationName:"kmsKeyArn" min:"20" type:"string"`

	// The unique identifier of the membership that contains the ID mapping table.
	//
	// MembershipIdentifier is a required field
	MembershipIdentifier *string `location:"uri" locationName:"membershipIdentifier" min:"36" type:"string" required:"true"`

	// A name for the ID mapping table.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// An optional label that you can assign to a resource when you create it. Each
	// tag consists of a key and an optional value, both of which you define. When
	// you use tagging, you can also use tag-based access control in IAM policies
	// to control access to this resource.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateIdMappingTableInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateIdMappingTableInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateIdMappingTableInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateIdMappingTableInput"}
	if s.InputReferenceConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("InputReferenceConfig"))
	}
	if s.KmsKeyArn != nil && len(*s.KmsKeyArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("KmsKeyArn", 20))
	}
	if s.MembershipIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("MembershipIdentifier"))
	}
	if s.MembershipIdentifier != nil && len(*s.MembershipIdentifier) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("MembershipIdentifier", 36))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.InputReferenceConfig != nil {
		if err := s.InputReferenceConfig.Validate(); err != nil {
			invalidParams.AddNested("InputReferenceConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *CreateIdMappingTableInput) SetDescription(v string) *CreateIdMappingTableInput {
	s.Description = &v
	return s
}

// SetInputReferenceConfig sets the InputReferenceConfig field's value.
func (s *CreateIdMappingTableInput) SetInputReferenceConfig(v *IdMappingTableInputReferenceConfig) *CreateIdMappingTableInput {
	s.InputReferenceConfig = v
	return s
}

// SetKmsKeyArn sets the KmsKeyArn field's value.
func (s *CreateIdMappingTableInput) SetKmsKeyArn(v string) *CreateIdMappingTableInput {
	s.KmsKeyArn = &v
	return s
}

// SetMembershipIdentifier sets the MembershipIdentifier field's value.
func (s *CreateIdMappingTableInput) SetMembershipIdentifier(v string) *CreateIdMappingTableInput {
	s.MembershipIdentifier = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateIdMappingTableInput) SetName(v string) *CreateIdMappingTableInput {
	s.Name = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateIdMappingTableInput) SetTags(v map[string]*string) *CreateIdMappingTableInput {
	s.Tags = v
	return s
}

type CreateIdMappingTableOutput struct {
	_ struct{} `type:"structure"`

	// The ID mapping table that was created.
	//
	// IdMappingTable is a required field
	IdMappingTable *IdMappingTable `locationName:"idMappingTable" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateIdMappingTableOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateIdMappingTableOutput) GoString() string {
	return s.String()
}

// SetIdMappingTable sets the IdMappingTable field's value.
func (s *CreateIdMappingTableOutput) SetIdMappingTable(v *IdMappingTable) *CreateIdMappingTableOutput {
	s.IdMappingTable = v
	return s
}

type CreateMembershipInput struct {
	_ struct{} `type:"structure"`

	// The unique ID for the associated collaboration.
	//
	// CollaborationIdentifier is a required field
	CollaborationIdentifier *string `locationName:"collaborationIdentifier" min:"36" type:"string" required:"true"`

	// The default protected query result configuration as specified by the member
	// who can receive results.
	DefaultResultConfiguration *MembershipProtectedQueryResultConfiguration `locationName:"defaultResultConfiguration" type:"structure"`

	// The payment responsibilities accepted by the collaboration member.
	//
	// Not required if the collaboration member has the member ability to run queries.
	//
	// Required if the collaboration member doesn't have the member ability to run
	// queries but is configured as a payer by the collaboration creator.
	PaymentConfiguration *MembershipPaymentConfiguration `locationName:"paymentConfiguration" type:"structure"`

	// An indicator as to whether query logging has been enabled or disabled for
	// the membership.
	//
	// QueryLogStatus is a required field
	QueryLogStatus *string `locationName:"queryLogStatus" type:"string" required:"true" enum:"MembershipQueryLogStatus"`

	// An optional label that you can assign to a resource when you create it. Each
	// tag consists of a key and an optional value, both of which you define. When
	// you use tagging, you can also use tag-based access control in IAM policies
	// to control access to this resource.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateMembershipInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateMembershipInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateMembershipInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateMembershipInput"}
	if s.CollaborationIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("CollaborationIdentifier"))
	}
	if s.CollaborationIdentifier != nil && len(*s.CollaborationIdentifier) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("CollaborationIdentifier", 36))
	}
	if s.QueryLogStatus == nil {
		invalidParams.Add(request.NewErrParamRequired("QueryLogStatus"))
	}
	if s.DefaultResultConfiguration != nil {
		if err := s.DefaultResultConfiguration.Validate(); err != nil {
			invalidParams.AddNested("DefaultResultConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.PaymentConfiguration != nil {
		if err := s.PaymentConfiguration.Validate(); err != nil {
			invalidParams.AddNested("PaymentConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCollaborationIdentifier sets the CollaborationIdentifier field's value.
func (s *CreateMembershipInput) SetCollaborationIdentifier(v string) *CreateMembershipInput {
	s.CollaborationIdentifier = &v
	return s
}

// SetDefaultResultConfiguration sets the DefaultResultConfiguration field's value.
func (s *CreateMembershipInput) SetDefaultResultConfiguration(v *MembershipProtectedQueryResultConfiguration) *CreateMembershipInput {
	s.DefaultResultConfiguration = v
	return s
}

// SetPaymentConfiguration sets the PaymentConfiguration field's value.
func (s *CreateMembershipInput) SetPaymentConfiguration(v *MembershipPaymentConfiguration) *CreateMembershipInput {
	s.PaymentConfiguration = v
	return s
}

// SetQueryLogStatus sets the QueryLogStatus field's value.
func (s *CreateMembershipInput) SetQueryLogStatus(v string) *CreateMembershipInput {
	s.QueryLogStatus = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateMembershipInput) SetTags(v map[string]*string) *CreateMembershipInput {
	s.Tags = v
	return s
}

type CreateMembershipOutput struct {
	_ struct{} `type:"structure"`

	// The membership that was created.
	//
	// Membership is a required field
	Membership *Membership `locationName:"membership" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateMembershipOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateMembershipOutput) GoString() string {
	return s.String()
}

// SetMembership sets the Membership field's value.
func (s *CreateMembershipOutput) SetMembership(v *Membership) *CreateMembershipOutput {
	s.Membership = v
	return s
}

type CreatePrivacyBudgetTemplateInput struct {
	_ struct{} `type:"structure"`

	// How often the privacy budget refreshes.
	//
	// If you plan to regularly bring new data into the collaboration, you can use
	// CALENDAR_MONTH to automatically get a new privacy budget for the collaboration
	// every calendar month. Choosing this option allows arbitrary amounts of information
	// to be revealed about rows of the data when repeatedly queries across refreshes.
	// Avoid choosing this if the same rows will be repeatedly queried between privacy
	// budget refreshes.
	//
	// AutoRefresh is a required field
	AutoRefresh *string `locationName:"autoRefresh" type:"string" required:"true" enum:"PrivacyBudgetTemplateAutoRefresh"`

	// A unique identifier for one of your memberships for a collaboration. The
	// privacy budget template is created in the collaboration that this membership
	// belongs to. Accepts a membership ID.
	//
	// MembershipIdentifier is a required field
	MembershipIdentifier *string `location:"uri" locationName:"membershipIdentifier" min:"36" type:"string" required:"true"`

	// Specifies your parameters for the privacy budget template.
	//
	// Parameters is a required field
	Parameters *PrivacyBudgetTemplateParametersInput_ `locationName:"parameters" type:"structure" required:"true"`

	// Specifies the type of the privacy budget template.
	//
	// PrivacyBudgetType is a required field
	PrivacyBudgetType *string `locationName:"privacyBudgetType" type:"string" required:"true" enum:"PrivacyBudgetType"`

	// An optional label that you can assign to a resource when you create it. Each
	// tag consists of a key and an optional value, both of which you define. When
	// you use tagging, you can also use tag-based access control in IAM policies
	// to control access to this resource.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreatePrivacyBudgetTemplateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreatePrivacyBudgetTemplateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreatePrivacyBudgetTemplateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreatePrivacyBudgetTemplateInput"}
	if s.AutoRefresh == nil {
		invalidParams.Add(request.NewErrParamRequired("AutoRefresh"))
	}
	if s.MembershipIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("MembershipIdentifier"))
	}
	if s.MembershipIdentifier != nil && len(*s.MembershipIdentifier) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("MembershipIdentifier", 36))
	}
	if s.Parameters == nil {
		invalidParams.Add(request.NewErrParamRequired("Parameters"))
	}
	if s.PrivacyBudgetType == nil {
		invalidParams.Add(request.NewErrParamRequired("PrivacyBudgetType"))
	}
	if s.Parameters != nil {
		if err := s.Parameters.Validate(); err != nil {
			invalidParams.AddNested("Parameters", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAutoRefresh sets the AutoRefresh field's value.
func (s *CreatePrivacyBudgetTemplateInput) SetAutoRefresh(v string) *CreatePrivacyBudgetTemplateInput {
	s.AutoRefresh = &v
	return s
}

// SetMembershipIdentifier sets the MembershipIdentifier field's value.
func (s *CreatePrivacyBudgetTemplateInput) SetMembershipIdentifier(v string) *CreatePrivacyBudgetTemplateInput {
	s.MembershipIdentifier = &v
	return s
}

// SetParameters sets the Parameters field's value.
func (s *CreatePrivacyBudgetTemplateInput) SetParameters(v *PrivacyBudgetTemplateParametersInput_) *CreatePrivacyBudgetTemplateInput {
	s.Parameters = v
	return s
}

// SetPrivacyBudgetType sets the PrivacyBudgetType field's value.
func (s *CreatePrivacyBudgetTemplateInput) SetPrivacyBudgetType(v string) *CreatePrivacyBudgetTemplateInput {
	s.PrivacyBudgetType = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreatePrivacyBudgetTemplateInput) SetTags(v map[string]*string) *CreatePrivacyBudgetTemplateInput {
	s.Tags = v
	return s
}

type CreatePrivacyBudgetTemplateOutput struct {
	_ struct{} `type:"structure"`

	// A summary of the elements in the privacy budget template.
	//
	// PrivacyBudgetTemplate is a required field
	PrivacyBudgetTemplate *PrivacyBudgetTemplate `locationName:"privacyBudgetTemplate" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreatePrivacyBudgetTemplateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreatePrivacyBudgetTemplateOutput) GoString() string {
	return s.String()
}

// SetPrivacyBudgetTemplate sets the PrivacyBudgetTemplate field's value.
func (s *CreatePrivacyBudgetTemplateOutput) SetPrivacyBudgetTemplate(v *PrivacyBudgetTemplate) *CreatePrivacyBudgetTemplateOutput {
	s.PrivacyBudgetTemplate = v
	return s
}

// The settings for client-side encryption for cryptographic computing.
type DataEncryptionMetadata struct {
	_ struct{} `type:"structure"`

	// Indicates whether encrypted tables can contain cleartext data (TRUE) or are
	// to cryptographically process every column (FALSE).
	//
	// AllowCleartext is a required field
	AllowCleartext *bool `locationName:"allowCleartext" type:"boolean" required:"true"`

	// Indicates whether Fingerprint columns can contain duplicate entries (TRUE)
	// or are to contain only non-repeated values (FALSE).
	//
	// AllowDuplicates is a required field
	AllowDuplicates *bool `locationName:"allowDuplicates" type:"boolean" required:"true"`

	// Indicates whether Fingerprint columns can be joined on any other Fingerprint
	// column with a different name (TRUE) or can only be joined on Fingerprint
	// columns of the same name (FALSE).
	//
	// AllowJoinsOnColumnsWithDifferentNames is a required field
	AllowJoinsOnColumnsWithDifferentNames *bool `locationName:"allowJoinsOnColumnsWithDifferentNames" type:"boolean" required:"true"`

	// Indicates whether NULL values are to be copied as NULL to encrypted tables
	// (TRUE) or cryptographically processed (FALSE).
	//
	// PreserveNulls is a required field
	PreserveNulls *bool `locationName:"preserveNulls" type:"boolean" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataEncryptionMetadata) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataEncryptionMetadata) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DataEncryptionMetadata) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DataEncryptionMetadata"}
	if s.AllowCleartext == nil {
		invalidParams.Add(request.NewErrParamRequired("AllowCleartext"))
	}
	if s.AllowDuplicates == nil {
		invalidParams.Add(request.NewErrParamRequired("AllowDuplicates"))
	}
	if s.AllowJoinsOnColumnsWithDifferentNames == nil {
		invalidParams.Add(request.NewErrParamRequired("AllowJoinsOnColumnsWithDifferentNames"))
	}
	if s.PreserveNulls == nil {
		invalidParams.Add(request.NewErrParamRequired("PreserveNulls"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAllowCleartext sets the AllowCleartext field's value.
func (s *DataEncryptionMetadata) SetAllowCleartext(v bool) *DataEncryptionMetadata {
	s.AllowCleartext = &v
	return s
}

// SetAllowDuplicates sets the AllowDuplicates field's value.
func (s *DataEncryptionMetadata) SetAllowDuplicates(v bool) *DataEncryptionMetadata {
	s.AllowDuplicates = &v
	return s
}

// SetAllowJoinsOnColumnsWithDifferentNames sets the AllowJoinsOnColumnsWithDifferentNames field's value.
func (s *DataEncryptionMetadata) SetAllowJoinsOnColumnsWithDifferentNames(v bool) *DataEncryptionMetadata {
	s.AllowJoinsOnColumnsWithDifferentNames = &v
	return s
}

// SetPreserveNulls sets the PreserveNulls field's value.
func (s *DataEncryptionMetadata) SetPreserveNulls(v bool) *DataEncryptionMetadata {
	s.PreserveNulls = &v
	return s
}

type DeleteAnalysisTemplateInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The identifier for the analysis template resource.
	//
	// AnalysisTemplateIdentifier is a required field
	AnalysisTemplateIdentifier *string `location:"uri" locationName:"analysisTemplateIdentifier" min:"36" type:"string" required:"true"`

	// The identifier for a membership resource.
	//
	// MembershipIdentifier is a required field
	MembershipIdentifier *string `location:"uri" locationName:"membershipIdentifier" min:"36" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAnalysisTemplateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAnalysisTemplateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteAnalysisTemplateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteAnalysisTemplateInput"}
	if s.AnalysisTemplateIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("AnalysisTemplateIdentifier"))
	}
	if s.AnalysisTemplateIdentifier != nil && len(*s.AnalysisTemplateIdentifier) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("AnalysisTemplateIdentifier", 36))
	}
	if s.MembershipIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("MembershipIdentifier"))
	}
	if s.MembershipIdentifier != nil && len(*s.MembershipIdentifier) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("MembershipIdentifier", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAnalysisTemplateIdentifier sets the AnalysisTemplateIdentifier field's value.
func (s *DeleteAnalysisTemplateInput) SetAnalysisTemplateIdentifier(v string) *DeleteAnalysisTemplateInput {
	s.AnalysisTemplateIdentifier = &v
	return s
}

// SetMembershipIdentifier sets the MembershipIdentifier field's value.
func (s *DeleteAnalysisTemplateInput) SetMembershipIdentifier(v string) *DeleteAnalysisTemplateInput {
	s.MembershipIdentifier = &v
	return s
}

type DeleteAnalysisTemplateOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAnalysisTemplateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAnalysisTemplateOutput) GoString() string {
	return s.String()
}

type DeleteCollaborationInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The identifier for the collaboration.
	//
	// CollaborationIdentifier is a required field
	CollaborationIdentifier *string `location:"uri" locationName:"collaborationIdentifier" min:"36" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteCollaborationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteCollaborationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteCollaborationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteCollaborationInput"}
	if s.CollaborationIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("CollaborationIdentifier"))
	}
	if s.CollaborationIdentifier != nil && len(*s.CollaborationIdentifier) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("CollaborationIdentifier", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCollaborationIdentifier sets the CollaborationIdentifier field's value.
func (s *DeleteCollaborationInput) SetCollaborationIdentifier(v string) *DeleteCollaborationInput {
	s.CollaborationIdentifier = &v
	return s
}

type DeleteCollaborationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteCollaborationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteCollaborationOutput) GoString() string {
	return s.String()
}

type DeleteConfiguredAudienceModelAssociationInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// A unique identifier of the configured audience model association that you
	// want to delete.
	//
	// ConfiguredAudienceModelAssociationIdentifier is a required field
	ConfiguredAudienceModelAssociationIdentifier *string `location:"uri" locationName:"configuredAudienceModelAssociationIdentifier" min:"36" type:"string" required:"true"`

	// A unique identifier of the membership that contains the audience model association
	// that you want to delete.
	//
	// MembershipIdentifier is a required field
	MembershipIdentifier *string `location:"uri" locationName:"membershipIdentifier" min:"36" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteConfiguredAudienceModelAssociationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteConfiguredAudienceModelAssociationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteConfiguredAudienceModelAssociationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteConfiguredAudienceModelAssociationInput"}
	if s.ConfiguredAudienceModelAssociationIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfiguredAudienceModelAssociationIdentifier"))
	}
	if s.ConfiguredAudienceModelAssociationIdentifier != nil && len(*s.ConfiguredAudienceModelAssociationIdentifier) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("ConfiguredAudienceModelAssociationIdentifier", 36))
	}
	if s.MembershipIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("MembershipIdentifier"))
	}
	if s.MembershipIdentifier != nil && len(*s.MembershipIdentifier) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("MembershipIdentifier", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfiguredAudienceModelAssociationIdentifier sets the ConfiguredAudienceModelAssociationIdentifier field's value.
func (s *DeleteConfiguredAudienceModelAssociationInput) SetConfiguredAudienceModelAssociationIdentifier(v string) *DeleteConfiguredAudienceModelAssociationInput {
	s.ConfiguredAudienceModelAssociationIdentifier = &v
	return s
}

// SetMembershipIdentifier sets the MembershipIdentifier field's value.
func (s *DeleteConfiguredAudienceModelAssociationInput) SetMembershipIdentifier(v string) *DeleteConfiguredAudienceModelAssociationInput {
	s.MembershipIdentifier = &v
	return s
}

type DeleteConfiguredAudienceModelAssociationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteConfiguredAudienceModelAssociationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteConfiguredAudienceModelAssociationOutput) GoString() string {
	return s.String()
}

type DeleteConfiguredTableAnalysisRuleInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The analysis rule type to be deleted. Configured table analysis rules are
	// uniquely identified by their configured table identifier and analysis rule
	// type.
	//
	// AnalysisRuleType is a required field
	AnalysisRuleType *string `location:"uri" locationName:"analysisRuleType" type:"string" required:"true" enum:"ConfiguredTableAnalysisRuleType"`

	// The unique identifier for the configured table that the analysis rule applies
	// to. Currently accepts the configured table ID.
	//
	// ConfiguredTableIdentifier is a required field
	ConfiguredTableIdentifier *string `location:"uri" locationName:"configuredTableIdentifier" min:"36" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteConfiguredTableAnalysisRuleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteConfiguredTableAnalysisRuleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteConfiguredTableAnalysisRuleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteConfiguredTableAnalysisRuleInput"}
	if s.AnalysisRuleType == nil {
		invalidParams.Add(request.NewErrParamRequired("AnalysisRuleType"))
	}
	if s.AnalysisRuleType != nil && len(*s.AnalysisRuleType) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AnalysisRuleType", 1))
	}
	if s.ConfiguredTableIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfiguredTableIdentifier"))
	}
	if s.ConfiguredTableIdentifier != nil && len(*s.ConfiguredTableIdentifier) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("ConfiguredTableIdentifier", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAnalysisRuleType sets the AnalysisRuleType field's value.
func (s *DeleteConfiguredTableAnalysisRuleInput) SetAnalysisRuleType(v string) *DeleteConfiguredTableAnalysisRuleInput {
	s.AnalysisRuleType = &v
	return s
}

// SetConfiguredTableIdentifier sets the ConfiguredTableIdentifier field's value.
func (s *DeleteConfiguredTableAnalysisRuleInput) SetConfiguredTableIdentifier(v string) *DeleteConfiguredTableAnalysisRuleInput {
	s.ConfiguredTableIdentifier = &v
	return s
}

// An empty response that indicates a successful delete.
type DeleteConfiguredTableAnalysisRuleOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteConfiguredTableAnalysisRuleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteConfiguredTableAnalysisRuleOutput) GoString() string {
	return s.String()
}

type DeleteConfiguredTableAssociationInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The unique ID for the configured table association to be deleted. Currently
	// accepts the configured table ID.
	//
	// ConfiguredTableAssociationIdentifier is a required field
	ConfiguredTableAssociationIdentifier *string `location:"uri" locationName:"configuredTableAssociationIdentifier" min:"36" type:"string" required:"true"`

	// A unique identifier for the membership that the configured table association
	// belongs to. Currently accepts the membership ID.
	//
	// MembershipIdentifier is a required field
	MembershipIdentifier *string `location:"uri" locationName:"membershipIdentifier" min:"36" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteConfiguredTableAssociationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteConfiguredTableAssociationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteConfiguredTableAssociationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteConfiguredTableAssociationInput"}
	if s.ConfiguredTableAssociationIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfiguredTableAssociationIdentifier"))
	}
	if s.ConfiguredTableAssociationIdentifier != nil && len(*s.ConfiguredTableAssociationIdentifier) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("ConfiguredTableAssociationIdentifier", 36))
	}
	if s.MembershipIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("MembershipIdentifier"))
	}
	if s.MembershipIdentifier != nil && len(*s.MembershipIdentifier) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("MembershipIdentifier", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfiguredTableAssociationIdentifier sets the ConfiguredTableAssociationIdentifier field's value.
func (s *DeleteConfiguredTableAssociationInput) SetConfiguredTableAssociationIdentifier(v string) *DeleteConfiguredTableAssociationInput {
	s.ConfiguredTableAssociationIdentifier = &v
	return s
}

// SetMembershipIdentifier sets the MembershipIdentifier field's value.
func (s *DeleteConfiguredTableAssociationInput) SetMembershipIdentifier(v string) *DeleteConfiguredTableAssociationInput {
	s.MembershipIdentifier = &v
	return s
}

type DeleteConfiguredTableAssociationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteConfiguredTableAssociationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteConfiguredTableAssociationOutput) GoString() string {
	return s.String()
}

type DeleteConfiguredTableInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The unique ID for the configured table to delete.
	//
	// ConfiguredTableIdentifier is a required field
	ConfiguredTableIdentifier *string `location:"uri" locationName:"configuredTableIdentifier" min:"36" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteConfiguredTableInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteConfiguredTableInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteConfiguredTableInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteConfiguredTableInput"}
	if s.ConfiguredTableIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfiguredTableIdentifier"))
	}
	if s.ConfiguredTableIdentifier != nil && len(*s.ConfiguredTableIdentifier) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("ConfiguredTableIdentifier", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfiguredTableIdentifier sets the ConfiguredTableIdentifier field's value.
func (s *DeleteConfiguredTableInput) SetConfiguredTableIdentifier(v string) *DeleteConfiguredTableInput {
	s.ConfiguredTableIdentifier = &v
	return s
}

// The empty output for a successful deletion.
type DeleteConfiguredTableOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteConfiguredTableOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteConfiguredTableOutput) GoString() string {
	return s.String()
}

type DeleteIdMappingTableInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The unique identifier of the ID mapping table that you want to delete.
	//
	// IdMappingTableIdentifier is a required field
	IdMappingTableIdentifier *string `location:"uri" locationName:"idMappingTableIdentifier" min:"36" type:"string" required:"true"`

	// The unique identifier of the membership that contains the ID mapping table
	// that you want to delete.
	//
	// MembershipIdentifier is a required field
	MembershipIdentifier *string `location:"uri" locationName:"membershipIdentifier" min:"36" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteIdMappingTableInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteIdMappingTableInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteIdMappingTableInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteIdMappingTableInput"}
	if s.IdMappingTableIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("IdMappingTableIdentifier"))
	}
	if s.IdMappingTableIdentifier != nil && len(*s.IdMappingTableIdentifier) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("IdMappingTableIdentifier", 36))
	}
	if s.MembershipIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("MembershipIdentifier"))
	}
	if s.MembershipIdentifier != nil && len(*s.MembershipIdentifier) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("MembershipIdentifier", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIdMappingTableIdentifier sets the IdMappingTableIdentifier field's value.
func (s *DeleteIdMappingTableInput) SetIdMappingTableIdentifier(v string) *DeleteIdMappingTableInput {
	s.IdMappingTableIdentifier = &v
	return s
}

// SetMembershipIdentifier sets the MembershipIdentifier field's value.
func (s *DeleteIdMappingTableInput) SetMembershipIdentifier(v string) *DeleteIdMappingTableInput {
	s.MembershipIdentifier = &v
	return s
}

type DeleteIdMappingTableOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteIdMappingTableOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteIdMappingTableOutput) GoString() string {
	return s.String()
}

type DeleteIdNamespaceAssociationInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The unique identifier of the ID namespace association that you want to delete.
	//
	// IdNamespaceAssociationIdentifier is a required field
	IdNamespaceAssociationIdentifier *string `location:"uri" locationName:"idNamespaceAssociationIdentifier" min:"36" type:"string" required:"true"`

	// The unique identifier of the membership that contains the ID namespace association
	// that you want to delete.
	//
	// MembershipIdentifier is a required field
	MembershipIdentifier *string `location:"uri" locationName:"membershipIdentifier" min:"36" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteIdNamespaceAssociationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteIdNamespaceAssociationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteIdNamespaceAssociationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteIdNamespaceAssociationInput"}
	if s.IdNamespaceAssociationIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("IdNamespaceAssociationIdentifier"))
	}
	if s.IdNamespaceAssociationIdentifier != nil && len(*s.IdNamespaceAssociationIdentifier) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("IdNamespaceAssociationIdentifier", 36))
	}
	if s.MembershipIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("MembershipIdentifier"))
	}
	if s.MembershipIdentifier != nil && len(*s.MembershipIdentifier) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("MembershipIdentifier", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIdNamespaceAssociationIdentifier sets the IdNamespaceAssociationIdentifier field's value.
func (s *DeleteIdNamespaceAssociationInput) SetIdNamespaceAssociationIdentifier(v string) *DeleteIdNamespaceAssociationInput {
	s.IdNamespaceAssociationIdentifier = &v
	return s
}

// SetMembershipIdentifier sets the MembershipIdentifier field's value.
func (s *DeleteIdNamespaceAssociationInput) SetMembershipIdentifier(v string) *DeleteIdNamespaceAssociationInput {
	s.MembershipIdentifier = &v
	return s
}

type DeleteIdNamespaceAssociationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteIdNamespaceAssociationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteIdNamespaceAssociationOutput) GoString() string {
	return s.String()
}

type DeleteMemberInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The account ID of the member to remove.
	//
	// AccountId is a required field
	AccountId *string `location:"uri" locationName:"accountId" min:"12" type:"string" required:"true"`

	// The unique identifier for the associated collaboration.
	//
	// CollaborationIdentifier is a required field
	CollaborationIdentifier *string `location:"uri" locationName:"collaborationIdentifier" min:"36" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteMemberInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteMemberInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteMemberInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteMemberInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 12))
	}
	if s.CollaborationIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("CollaborationIdentifier"))
	}
	if s.CollaborationIdentifier != nil && len(*s.CollaborationIdentifier) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("CollaborationIdentifier", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *DeleteMemberInput) SetAccountId(v string) *DeleteMemberInput {
	s.AccountId = &v
	return s
}

// SetCollaborationIdentifier sets the CollaborationIdentifier field's value.
func (s *DeleteMemberInput) SetCollaborationIdentifier(v string) *DeleteMemberInput {
	s.CollaborationIdentifier = &v
	return s
}

type DeleteMemberOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteMemberOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteMemberOutput) GoString() string {
	return s.String()
}

type DeleteMembershipInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The identifier for a membership resource.
	//
	// MembershipIdentifier is a required field
	MembershipIdentifier *string `location:"uri" locationName:"membershipIdentifier" min:"36" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteMembershipInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteMembershipInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteMembershipInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteMembershipInput"}
	if s.MembershipIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("MembershipIdentifier"))
	}
	if s.MembershipIdentifier != nil && len(*s.MembershipIdentifier) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("MembershipIdentifier", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMembershipIdentifier sets the MembershipIdentifier field's value.
func (s *DeleteMembershipInput) SetMembershipIdentifier(v string) *DeleteMembershipInput {
	s.MembershipIdentifier = &v
	return s
}

type DeleteMembershipOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteMembershipOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteMembershipOutput) GoString() string {
	return s.String()
}

type DeletePrivacyBudgetTemplateInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// A unique identifier for one of your memberships for a collaboration. The
	// privacy budget template is deleted from the collaboration that this membership
	// belongs to. Accepts a membership ID.
	//
	// MembershipIdentifier is a required field
	MembershipIdentifier *string `location:"uri" locationName:"membershipIdentifier" min:"36" type:"string" required:"true"`

	// A unique identifier for your privacy budget template.
	//
	// PrivacyBudgetTemplateIdentifier is a required field
	PrivacyBudgetTemplateIdentifier *string `location:"uri" locationName:"privacyBudgetTemplateIdentifier" min:"36" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeletePrivacyBudgetTemplateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeletePrivacyBudgetTemplateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeletePrivacyBudgetTemplateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeletePrivacyBudgetTemplateInput"}
	if s.MembershipIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("MembershipIdentifier"))
	}
	if s.MembershipIdentifier != nil && len(*s.MembershipIdentifier) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("MembershipIdentifier", 36))
	}
	if s.PrivacyBudgetTemplateIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("PrivacyBudgetTemplateIdentifier"))
	}
	if s.PrivacyBudgetTemplateIdentifier != nil && len(*s.PrivacyBudgetTemplateIdentifier) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("PrivacyBudgetTemplateIdentifier", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMembershipIdentifier sets the MembershipIdentifier field's value.
func (s *DeletePrivacyBudgetTemplateInput) SetMembershipIdentifier(v string) *DeletePrivacyBudgetTemplateInput {
	s.MembershipIdentifier = &v
	return s
}

// SetPrivacyBudgetTemplateIdentifier sets the PrivacyBudgetTemplateIdentifier field's value.
func (s *DeletePrivacyBudgetTemplateInput) SetPrivacyBudgetTemplateIdentifier(v string) *DeletePrivacyBudgetTemplateInput {
	s.PrivacyBudgetTemplateIdentifier = &v
	return s
}

type DeletePrivacyBudgetTemplateOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeletePrivacyBudgetTemplateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeletePrivacyBudgetTemplateOutput) GoString() string {
	return s.String()
}

// Specifies the name of the column that contains the unique identifier of your
// users, whose privacy you want to protect.
type DifferentialPrivacyColumn struct {
	_ struct{} `type:"structure"`

	// The name of the column, such as user_id, that contains the unique identifier
	// of your users, whose privacy you want to protect. If you want to turn on
	// differential privacy for two or more tables in a collaboration, you must
	// configure the same column as the user identifier column in both analysis
	// rules.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DifferentialPrivacyColumn) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DifferentialPrivacyColumn) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DifferentialPrivacyColumn) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DifferentialPrivacyColumn"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *DifferentialPrivacyColumn) SetName(v string) *DifferentialPrivacyColumn {
	s.Name = &v
	return s
}

// Specifies the unique identifier for your users.
type DifferentialPrivacyConfiguration struct {
	_ struct{} `type:"structure"`

	// The name of the column (such as user_id) that contains the unique identifier
	// of your users whose privacy you want to protect. If you want to turn on diﬀerential
	// privacy for two or more tables in a collaboration, you must conﬁgure the
	// same column as the user identiﬁer column in both analysis rules.
	//
	// Columns is a required field
	Columns []*DifferentialPrivacyColumn `locationName:"columns" min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DifferentialPrivacyConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DifferentialPrivacyConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DifferentialPrivacyConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DifferentialPrivacyConfiguration"}
	if s.Columns == nil {
		invalidParams.Add(request.NewErrParamRequired("Columns"))
	}
	if s.Columns != nil && len(s.Columns) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Columns", 1))
	}
	if s.Columns != nil {
		for i, v := range s.Columns {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Columns", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetColumns sets the Columns field's value.
func (s *DifferentialPrivacyConfiguration) SetColumns(v []*DifferentialPrivacyColumn) *DifferentialPrivacyConfiguration {
	s.Columns = v
	return s
}

// An array that contains the sensitivity parameters.
type DifferentialPrivacyParameters struct {
	_ struct{} `type:"structure"`

	// Provides the sensitivity parameters that you can use to better understand
	// the total amount of noise in query results.
	//
	// SensitivityParameters is a required field
	SensitivityParameters []*DifferentialPrivacySensitivityParameters `locationName:"sensitivityParameters" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DifferentialPrivacyParameters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DifferentialPrivacyParameters) GoString() string {
	return s.String()
}

// SetSensitivityParameters sets the SensitivityParameters field's value.
func (s *DifferentialPrivacyParameters) SetSensitivityParameters(v []*DifferentialPrivacySensitivityParameters) *DifferentialPrivacyParameters {
	s.SensitivityParameters = v
	return s
}

// Provides an estimate of the number of aggregation functions that the member
// who can query can run given the epsilon and noise parameters.
type DifferentialPrivacyPreviewAggregation struct {
	_ struct{} `type:"structure"`

	// The maximum number of aggregations that the member who can query can run
	// given the epsilon and noise parameters.
	//
	// MaxCount is a required field
	MaxCount *int64 `locationName:"maxCount" type:"integer" required:"true"`

	// The type of aggregation function.
	//
	// Type is a required field
	Type *string `locationName:"type" type:"string" required:"true" enum:"DifferentialPrivacyAggregationType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DifferentialPrivacyPreviewAggregation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DifferentialPrivacyPreviewAggregation) GoString() string {
	return s.String()
}

// SetMaxCount sets the MaxCount field's value.
func (s *DifferentialPrivacyPreviewAggregation) SetMaxCount(v int64) *DifferentialPrivacyPreviewAggregation {
	s.MaxCount = &v
	return s
}

// SetType sets the Type field's value.
func (s *DifferentialPrivacyPreviewAggregation) SetType(v string) *DifferentialPrivacyPreviewAggregation {
	s.Type = &v
	return s
}

// The epsilon and noise parameters that you want to preview.
type DifferentialPrivacyPreviewParametersInput_ struct {
	_ struct{} `type:"structure"`

	// The epsilon value that you want to preview.
	//
	// Epsilon is a required field
	Epsilon *int64 `locationName:"epsilon" min:"1" type:"integer" required:"true"`

	// Noise added per query is measured in terms of the number of users whose contributions
	// you want to obscure. This value governs the rate at which the privacy budget
	// is depleted.
	//
	// UsersNoisePerQuery is a required field
	UsersNoisePerQuery *int64 `locationName:"usersNoisePerQuery" min:"10" type:"integer" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DifferentialPrivacyPreviewParametersInput_) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DifferentialPrivacyPreviewParametersInput_) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DifferentialPrivacyPreviewParametersInput_) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DifferentialPrivacyPreviewParametersInput_"}
	if s.Epsilon == nil {
		invalidParams.Add(request.NewErrParamRequired("Epsilon"))
	}
	if s.Epsilon != nil && *s.Epsilon < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Epsilon", 1))
	}
	if s.UsersNoisePerQuery == nil {
		invalidParams.Add(request.NewErrParamRequired("UsersNoisePerQuery"))
	}
	if s.UsersNoisePerQuery != nil && *s.UsersNoisePerQuery < 10 {
		invalidParams.Add(request.NewErrParamMinValue("UsersNoisePerQuery", 10))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEpsilon sets the Epsilon field's value.
func (s *DifferentialPrivacyPreviewParametersInput_) SetEpsilon(v int64) *DifferentialPrivacyPreviewParametersInput_ {
	s.Epsilon = &v
	return s
}

// SetUsersNoisePerQuery sets the UsersNoisePerQuery field's value.
func (s *DifferentialPrivacyPreviewParametersInput_) SetUsersNoisePerQuery(v int64) *DifferentialPrivacyPreviewParametersInput_ {
	s.UsersNoisePerQuery = &v
	return s
}

// Specifies the configured epsilon value and the utility in terms of total
// aggregations, as well as the remaining aggregations available.
type DifferentialPrivacyPrivacyBudget struct {
	_ struct{} `type:"structure"`

	// This information includes the configured epsilon value and the utility in
	// terms of total aggregations, as well as the remaining aggregations.
	//
	// Aggregations is a required field
	Aggregations []*DifferentialPrivacyPrivacyBudgetAggregation `locationName:"aggregations" type:"list" required:"true"`

	// The epsilon value that you configured.
	//
	// Epsilon is a required field
	Epsilon *int64 `locationName:"epsilon" min:"1" type:"integer" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DifferentialPrivacyPrivacyBudget) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DifferentialPrivacyPrivacyBudget) GoString() string {
	return s.String()
}

// SetAggregations sets the Aggregations field's value.
func (s *DifferentialPrivacyPrivacyBudget) SetAggregations(v []*DifferentialPrivacyPrivacyBudgetAggregation) *DifferentialPrivacyPrivacyBudget {
	s.Aggregations = v
	return s
}

// SetEpsilon sets the Epsilon field's value.
func (s *DifferentialPrivacyPrivacyBudget) SetEpsilon(v int64) *DifferentialPrivacyPrivacyBudget {
	s.Epsilon = &v
	return s
}

// Information about the total number of aggregations, as well as the remaining
// aggregations.
type DifferentialPrivacyPrivacyBudgetAggregation struct {
	_ struct{} `type:"structure"`

	// The maximum number of aggregation functions that you can perform with the
	// given privacy budget.
	//
	// MaxCount is a required field
	MaxCount *int64 `locationName:"maxCount" type:"integer" required:"true"`

	// The remaining number of aggregation functions that can be run with the available
	// privacy budget.
	//
	// RemainingCount is a required field
	RemainingCount *int64 `locationName:"remainingCount" type:"integer" required:"true"`

	// The different types of aggregation functions that you can perform.
	//
	// Type is a required field
	Type *string `locationName:"type" type:"string" required:"true" enum:"DifferentialPrivacyAggregationType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DifferentialPrivacyPrivacyBudgetAggregation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DifferentialPrivacyPrivacyBudgetAggregation) GoString() string {
	return s.String()
}

// SetMaxCount sets the MaxCount field's value.
func (s *DifferentialPrivacyPrivacyBudgetAggregation) SetMaxCount(v int64) *DifferentialPrivacyPrivacyBudgetAggregation {
	s.MaxCount = &v
	return s
}

// SetRemainingCount sets the RemainingCount field's value.
func (s *DifferentialPrivacyPrivacyBudgetAggregation) SetRemainingCount(v int64) *DifferentialPrivacyPrivacyBudgetAggregation {
	s.RemainingCount = &v
	return s
}

// SetType sets the Type field's value.
func (s *DifferentialPrivacyPrivacyBudgetAggregation) SetType(v string) *DifferentialPrivacyPrivacyBudgetAggregation {
	s.Type = &v
	return s
}

// Information about the number of aggregation functions that the member who
// can query can run given the epsilon and noise parameters.
type DifferentialPrivacyPrivacyImpact struct {
	_ struct{} `type:"structure"`

	// The number of aggregation functions that you can perform.
	//
	// Aggregations is a required field
	Aggregations []*DifferentialPrivacyPreviewAggregation `locationName:"aggregations" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DifferentialPrivacyPrivacyImpact) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DifferentialPrivacyPrivacyImpact) GoString() string {
	return s.String()
}

// SetAggregations sets the Aggregations field's value.
func (s *DifferentialPrivacyPrivacyImpact) SetAggregations(v []*DifferentialPrivacyPreviewAggregation) *DifferentialPrivacyPrivacyImpact {
	s.Aggregations = v
	return s
}

// Provides the sensitivity parameters.
type DifferentialPrivacySensitivityParameters struct {
	_ struct{} `type:"structure"`

	// The aggregation expression that was run.
	//
	// AggregationExpression is a required field
	AggregationExpression *string `locationName:"aggregationExpression" min:"1" type:"string" required:"true"`

	// The type of aggregation function that was run.
	//
	// AggregationType is a required field
	AggregationType *string `locationName:"aggregationType" type:"string" required:"true" enum:"DifferentialPrivacyAggregationType"`

	// The upper bound of the aggregation expression.
	MaxColumnValue *float64 `locationName:"maxColumnValue" type:"float"`

	// The lower bound of the aggregation expression.
	MinColumnValue *float64 `locationName:"minColumnValue" type:"float"`

	// The maximum number of rows contributed by a user in a SQL query.
	//
	// UserContributionLimit is a required field
	UserContributionLimit *int64 `locationName:"userContributionLimit" type:"integer" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DifferentialPrivacySensitivityParameters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DifferentialPrivacySensitivityParameters) GoString() string {
	return s.String()
}

// SetAggregationExpression sets the AggregationExpression field's value.
func (s *DifferentialPrivacySensitivityParameters) SetAggregationExpression(v string) *DifferentialPrivacySensitivityParameters {
	s.AggregationExpression = &v
	return s
}

// SetAggregationType sets the AggregationType field's value.
func (s *DifferentialPrivacySensitivityParameters) SetAggregationType(v string) *DifferentialPrivacySensitivityParameters {
	s.AggregationType = &v
	return s
}

// SetMaxColumnValue sets the MaxColumnValue field's value.
func (s *DifferentialPrivacySensitivityParameters) SetMaxColumnValue(v float64) *DifferentialPrivacySensitivityParameters {
	s.MaxColumnValue = &v
	return s
}

// SetMinColumnValue sets the MinColumnValue field's value.
func (s *DifferentialPrivacySensitivityParameters) SetMinColumnValue(v float64) *DifferentialPrivacySensitivityParameters {
	s.MinColumnValue = &v
	return s
}

// SetUserContributionLimit sets the UserContributionLimit field's value.
func (s *DifferentialPrivacySensitivityParameters) SetUserContributionLimit(v int64) *DifferentialPrivacySensitivityParameters {
	s.UserContributionLimit = &v
	return s
}

// The epsilon and noise parameter values that you want to use for the differential
// privacy template.
type DifferentialPrivacyTemplateParametersInput_ struct {
	_ struct{} `type:"structure"`

	// The epsilon value that you want to use.
	//
	// Epsilon is a required field
	Epsilon *int64 `locationName:"epsilon" min:"1" type:"integer" required:"true"`

	// Noise added per query is measured in terms of the number of users whose contributions
	// you want to obscure. This value governs the rate at which the privacy budget
	// is depleted.
	//
	// UsersNoisePerQuery is a required field
	UsersNoisePerQuery *int64 `locationName:"usersNoisePerQuery" min:"10" type:"integer" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DifferentialPrivacyTemplateParametersInput_) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DifferentialPrivacyTemplateParametersInput_) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DifferentialPrivacyTemplateParametersInput_) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DifferentialPrivacyTemplateParametersInput_"}
	if s.Epsilon == nil {
		invalidParams.Add(request.NewErrParamRequired("Epsilon"))
	}
	if s.Epsilon != nil && *s.Epsilon < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Epsilon", 1))
	}
	if s.UsersNoisePerQuery == nil {
		invalidParams.Add(request.NewErrParamRequired("UsersNoisePerQuery"))
	}
	if s.UsersNoisePerQuery != nil && *s.UsersNoisePerQuery < 10 {
		invalidParams.Add(request.NewErrParamMinValue("UsersNoisePerQuery", 10))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEpsilon sets the Epsilon field's value.
func (s *DifferentialPrivacyTemplateParametersInput_) SetEpsilon(v int64) *DifferentialPrivacyTemplateParametersInput_ {
	s.Epsilon = &v
	return s
}

// SetUsersNoisePerQuery sets the UsersNoisePerQuery field's value.
func (s *DifferentialPrivacyTemplateParametersInput_) SetUsersNoisePerQuery(v int64) *DifferentialPrivacyTemplateParametersInput_ {
	s.UsersNoisePerQuery = &v
	return s
}

// The epsilon and noise parameter values that were used for the differential
// privacy template.
type DifferentialPrivacyTemplateParametersOutput_ struct {
	_ struct{} `type:"structure"`

	// The epsilon value that you specified.
	//
	// Epsilon is a required field
	Epsilon *int64 `locationName:"epsilon" min:"1" type:"integer" required:"true"`

	// Noise added per query is measured in terms of the number of users whose contributions
	// you want to obscure. This value governs the rate at which the privacy budget
	// is depleted.
	//
	// UsersNoisePerQuery is a required field
	UsersNoisePerQuery *int64 `locationName:"usersNoisePerQuery" min:"10" type:"integer" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DifferentialPrivacyTemplateParametersOutput_) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DifferentialPrivacyTemplateParametersOutput_) GoString() string {
	return s.String()
}

// SetEpsilon sets the Epsilon field's value.
func (s *DifferentialPrivacyTemplateParametersOutput_) SetEpsilon(v int64) *DifferentialPrivacyTemplateParametersOutput_ {
	s.Epsilon = &v
	return s
}

// SetUsersNoisePerQuery sets the UsersNoisePerQuery field's value.
func (s *DifferentialPrivacyTemplateParametersOutput_) SetUsersNoisePerQuery(v int64) *DifferentialPrivacyTemplateParametersOutput_ {
	s.UsersNoisePerQuery = &v
	return s
}

// The epsilon and noise parameter values that you want to update in the differential
// privacy template.
type DifferentialPrivacyTemplateUpdateParameters struct {
	_ struct{} `type:"structure"`

	// The updated epsilon value that you want to use.
	Epsilon *int64 `locationName:"epsilon" min:"1" type:"integer"`

	// The updated value of noise added per query. It is measured in terms of the
	// number of users whose contributions you want to obscure. This value governs
	// the rate at which the privacy budget is depleted.
	UsersNoisePerQuery *int64 `locationName:"usersNoisePerQuery" min:"10" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DifferentialPrivacyTemplateUpdateParameters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DifferentialPrivacyTemplateUpdateParameters) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DifferentialPrivacyTemplateUpdateParameters) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DifferentialPrivacyTemplateUpdateParameters"}
	if s.Epsilon != nil && *s.Epsilon < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Epsilon", 1))
	}
	if s.UsersNoisePerQuery != nil && *s.UsersNoisePerQuery < 10 {
		invalidParams.Add(request.NewErrParamMinValue("UsersNoisePerQuery", 10))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEpsilon sets the Epsilon field's value.
func (s *DifferentialPrivacyTemplateUpdateParameters) SetEpsilon(v int64) *DifferentialPrivacyTemplateUpdateParameters {
	s.Epsilon = &v
	return s
}

// SetUsersNoisePerQuery sets the UsersNoisePerQuery field's value.
func (s *DifferentialPrivacyTemplateUpdateParameters) SetUsersNoisePerQuery(v int64) *DifferentialPrivacyTemplateUpdateParameters {
	s.UsersNoisePerQuery = &v
	return s
}

type GetAnalysisTemplateInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The identifier for the analysis template resource.
	//
	// AnalysisTemplateIdentifier is a required field
	AnalysisTemplateIdentifier *string `location:"uri" locationName:"analysisTemplateIdentifier" min:"36" type:"string" required:"true"`

	// The identifier for a membership resource.
	//
	// MembershipIdentifier is a required field
	MembershipIdentifier *string `location:"uri" locationName:"membershipIdentifier" min:"36" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAnalysisTemplateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAnalysisTemplateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetAnalysisTemplateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetAnalysisTemplateInput"}
	if s.AnalysisTemplateIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("AnalysisTemplateIdentifier"))
	}
	if s.AnalysisTemplateIdentifier != nil && len(*s.AnalysisTemplateIdentifier) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("AnalysisTemplateIdentifier", 36))
	}
	if s.MembershipIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("MembershipIdentifier"))
	}
	if s.MembershipIdentifier != nil && len(*s.MembershipIdentifier) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("MembershipIdentifier", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAnalysisTemplateIdentifier sets the AnalysisTemplateIdentifier field's value.
func (s *GetAnalysisTemplateInput) SetAnalysisTemplateIdentifier(v string) *GetAnalysisTemplateInput {
	s.AnalysisTemplateIdentifier = &v
	return s
}

// SetMembershipIdentifier sets the MembershipIdentifier field's value.
func (s *GetAnalysisTemplateInput) SetMembershipIdentifier(v string) *GetAnalysisTemplateInput {
	s.MembershipIdentifier = &v
	return s
}

type GetAnalysisTemplateOutput struct {
	_ struct{} `type:"structure"`

	// The analysis template.
	//
	// AnalysisTemplate is a required field
	AnalysisTemplate *AnalysisTemplate `locationName:"analysisTemplate" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAnalysisTemplateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAnalysisTemplateOutput) GoString() string {
	return s.String()
}

// SetAnalysisTemplate sets the AnalysisTemplate field's value.
func (s *GetAnalysisTemplateOutput) SetAnalysisTemplate(v *AnalysisTemplate) *GetAnalysisTemplateOutput {
	s.AnalysisTemplate = v
	return s
}

type GetCollaborationAnalysisTemplateInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The Amazon Resource Name (ARN) associated with the analysis template within
	// a collaboration.
	//
	// AnalysisTemplateArn is a required field
	AnalysisTemplateArn *string `location:"uri" locationName:"analysisTemplateArn" type:"string" required:"true"`

	// A unique identifier for the collaboration that the analysis templates belong
	// to. Currently accepts collaboration ID.
	//
	// CollaborationIdentifier is a required field
	CollaborationIdentifier *string `location:"uri" locationName:"collaborationIdentifier" min:"36" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetCollaborationAnalysisTemplateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetCollaborationAnalysisTemplateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetCollaborationAnalysisTemplateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetCollaborationAnalysisTemplateInput"}
	if s.AnalysisTemplateArn == nil {
		invalidParams.Add(request.NewErrParamRequired("AnalysisTemplateArn"))
	}
	if s.AnalysisTemplateArn != nil && len(*s.AnalysisTemplateArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AnalysisTemplateArn", 1))
	}
	if s.CollaborationIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("CollaborationIdentifier"))
	}
	if s.CollaborationIdentifier != nil && len(*s.CollaborationIdentifier) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("CollaborationIdentifier", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAnalysisTemplateArn sets the AnalysisTemplateArn field's value.
func (s *GetCollaborationAnalysisTemplateInput) SetAnalysisTemplateArn(v string) *GetCollaborationAnalysisTemplateInput {
	s.AnalysisTemplateArn = &v
	return s
}

// SetCollaborationIdentifier sets the CollaborationIdentifier field's value.
func (s *GetCollaborationAnalysisTemplateInput) SetCollaborationIdentifier(v string) *GetCollaborationAnalysisTemplateInput {
	s.CollaborationIdentifier = &v
	return s
}

type GetCollaborationAnalysisTemplateOutput struct {
	_ struct{} `type:"structure"`

	// The analysis template within a collaboration.
	//
	// CollaborationAnalysisTemplate is a required field
	CollaborationAnalysisTemplate *CollaborationAnalysisTemplate `locationName:"collaborationAnalysisTemplate" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetCollaborationAnalysisTemplateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetCollaborationAnalysisTemplateOutput) GoString() string {
	return s.String()
}

// SetCollaborationAnalysisTemplate sets the CollaborationAnalysisTemplate field's value.
func (s *GetCollaborationAnalysisTemplateOutput) SetCollaborationAnalysisTemplate(v *CollaborationAnalysisTemplate) *GetCollaborationAnalysisTemplateOutput {
	s.CollaborationAnalysisTemplate = v
	return s
}

type GetCollaborationConfiguredAudienceModelAssociationInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// A unique identifier for the collaboration that the configured audience model
	// association belongs to. Accepts a collaboration ID.
	//
	// CollaborationIdentifier is a required field
	CollaborationIdentifier *string `location:"uri" locationName:"collaborationIdentifier" min:"36" type:"string" required:"true"`

	// A unique identifier for the configured audience model association that you
	// want to retrieve.
	//
	// ConfiguredAudienceModelAssociationIdentifier is a required field
	ConfiguredAudienceModelAssociationIdentifier *string `location:"uri" locationName:"configuredAudienceModelAssociationIdentifier" min:"36" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetCollaborationConfiguredAudienceModelAssociationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetCollaborationConfiguredAudienceModelAssociationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetCollaborationConfiguredAudienceModelAssociationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetCollaborationConfiguredAudienceModelAssociationInput"}
	if s.CollaborationIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("CollaborationIdentifier"))
	}
	if s.CollaborationIdentifier != nil && len(*s.CollaborationIdentifier) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("CollaborationIdentifier", 36))
	}
	if s.ConfiguredAudienceModelAssociationIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfiguredAudienceModelAssociationIdentifier"))
	}
	if s.ConfiguredAudienceModelAssociationIdentifier != nil && len(*s.ConfiguredAudienceModelAssociationIdentifier) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("ConfiguredAudienceModelAssociationIdentifier", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCollaborationIdentifier sets the CollaborationIdentifier field's value.
func (s *GetCollaborationConfiguredAudienceModelAssociationInput) SetCollaborationIdentifier(v string) *GetCollaborationConfiguredAudienceModelAssociationInput {
	s.CollaborationIdentifier = &v
	return s
}

// SetConfiguredAudienceModelAssociationIdentifier sets the ConfiguredAudienceModelAssociationIdentifier field's value.
func (s *GetCollaborationConfiguredAudienceModelAssociationInput) SetConfiguredAudienceModelAssociationIdentifier(v string) *GetCollaborationConfiguredAudienceModelAssociationInput {
	s.ConfiguredAudienceModelAssociationIdentifier = &v
	return s
}

type GetCollaborationConfiguredAudienceModelAssociationOutput struct {
	_ struct{} `type:"structure"`

	// The metadata of the configured audience model association.
	//
	// CollaborationConfiguredAudienceModelAssociation is a required field
	CollaborationConfiguredAudienceModelAssociation *CollaborationConfiguredAudienceModelAssociation `locationName:"collaborationConfiguredAudienceModelAssociation" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetCollaborationConfiguredAudienceModelAssociationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetCollaborationConfiguredAudienceModelAssociationOutput) GoString() string {
	return s.String()
}

// SetCollaborationConfiguredAudienceModelAssociation sets the CollaborationConfiguredAudienceModelAssociation field's value.
func (s *GetCollaborationConfiguredAudienceModelAssociationOutput) SetCollaborationConfiguredAudienceModelAssociation(v *CollaborationConfiguredAudienceModelAssociation) *GetCollaborationConfiguredAudienceModelAssociationOutput {
	s.CollaborationConfiguredAudienceModelAssociation = v
	return s
}

type GetCollaborationInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The identifier for the collaboration.
	//
	// CollaborationIdentifier is a required field
	CollaborationIdentifier *string `location:"uri" locationName:"collaborationIdentifier" min:"36" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetCollaborationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetCollaborationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetCollaborationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetCollaborationInput"}
	if s.CollaborationIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("CollaborationIdentifier"))
	}
	if s.CollaborationIdentifier != nil && len(*s.CollaborationIdentifier) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("CollaborationIdentifier", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCollaborationIdentifier sets the CollaborationIdentifier field's value.
func (s *GetCollaborationInput) SetCollaborationIdentifier(v string) *GetCollaborationInput {
	s.CollaborationIdentifier = &v
	return s
}

type GetCollaborationOutput struct {
	_ struct{} `type:"structure"`

	// The entire collaboration for this identifier.
	//
	// Collaboration is a required field
	Collaboration *Collaboration `locationName:"collaboration" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetCollaborationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetCollaborationOutput) GoString() string {
	return s.String()
}

// SetCollaboration sets the Collaboration field's value.
func (s *GetCollaborationOutput) SetCollaboration(v *Collaboration) *GetCollaborationOutput {
	s.Collaboration = v
	return s
}

type GetCollaborationPrivacyBudgetTemplateInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// A unique identifier for one of your collaborations.
	//
	// CollaborationIdentifier is a required field
	CollaborationIdentifier *string `location:"uri" locationName:"collaborationIdentifier" min:"36" type:"string" required:"true"`

	// A unique identifier for one of your privacy budget templates.
	//
	// PrivacyBudgetTemplateIdentifier is a required field
	PrivacyBudgetTemplateIdentifier *string `location:"uri" locationName:"privacyBudgetTemplateIdentifier" min:"36" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetCollaborationPrivacyBudgetTemplateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetCollaborationPrivacyBudgetTemplateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetCollaborationPrivacyBudgetTemplateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetCollaborationPrivacyBudgetTemplateInput"}
	if s.CollaborationIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("CollaborationIdentifier"))
	}
	if s.CollaborationIdentifier != nil && len(*s.CollaborationIdentifier) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("CollaborationIdentifier", 36))
	}
	if s.PrivacyBudgetTemplateIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("PrivacyBudgetTemplateIdentifier"))
	}
	if s.PrivacyBudgetTemplateIdentifier != nil && len(*s.PrivacyBudgetTemplateIdentifier) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("PrivacyBudgetTemplateIdentifier", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCollaborationIdentifier sets the CollaborationIdentifier field's value.
func (s *GetCollaborationPrivacyBudgetTemplateInput) SetCollaborationIdentifier(v string) *GetCollaborationPrivacyBudgetTemplateInput {
	s.CollaborationIdentifier = &v
	return s
}

// SetPrivacyBudgetTemplateIdentifier sets the PrivacyBudgetTemplateIdentifier field's value.
func (s *GetCollaborationPrivacyBudgetTemplateInput) SetPrivacyBudgetTemplateIdentifier(v string) *GetCollaborationPrivacyBudgetTemplateInput {
	s.PrivacyBudgetTemplateIdentifier = &v
	return s
}

type GetCollaborationPrivacyBudgetTemplateOutput struct {
	_ struct{} `type:"structure"`

	// Returns the details of the privacy budget template that you requested.
	//
	// CollaborationPrivacyBudgetTemplate is a required field
	CollaborationPrivacyBudgetTemplate *CollaborationPrivacyBudgetTemplate `locationName:"collaborationPrivacyBudgetTemplate" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetCollaborationPrivacyBudgetTemplateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetCollaborationPrivacyBudgetTemplateOutput) GoString() string {
	return s.String()
}

// SetCollaborationPrivacyBudgetTemplate sets the CollaborationPrivacyBudgetTemplate field's value.
func (s *GetCollaborationPrivacyBudgetTemplateOutput) SetCollaborationPrivacyBudgetTemplate(v *CollaborationPrivacyBudgetTemplate) *GetCollaborationPrivacyBudgetTemplateOutput {
	s.CollaborationPrivacyBudgetTemplate = v
	return s
}

type GetConfiguredAudienceModelAssociationInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// A unique identifier for the configured audience model association that you
	// want to retrieve.
	//
	// ConfiguredAudienceModelAssociationIdentifier is a required field
	ConfiguredAudienceModelAssociationIdentifier *string `location:"uri" locationName:"configuredAudienceModelAssociationIdentifier" min:"36" type:"string" required:"true"`

	// A unique identifier for the membership that contains the configured audience
	// model association that you want to retrieve.
	//
	// MembershipIdentifier is a required field
	MembershipIdentifier *string `location:"uri" locationName:"membershipIdentifier" min:"36" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetConfiguredAudienceModelAssociationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetConfiguredAudienceModelAssociationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetConfiguredAudienceModelAssociationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetConfiguredAudienceModelAssociationInput"}
	if s.ConfiguredAudienceModelAssociationIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfiguredAudienceModelAssociationIdentifier"))
	}
	if s.ConfiguredAudienceModelAssociationIdentifier != nil && len(*s.ConfiguredAudienceModelAssociationIdentifier) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("ConfiguredAudienceModelAssociationIdentifier", 36))
	}
	if s.MembershipIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("MembershipIdentifier"))
	}
	if s.MembershipIdentifier != nil && len(*s.MembershipIdentifier) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("MembershipIdentifier", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfiguredAudienceModelAssociationIdentifier sets the ConfiguredAudienceModelAssociationIdentifier field's value.
func (s *GetConfiguredAudienceModelAssociationInput) SetConfiguredAudienceModelAssociationIdentifier(v string) *GetConfiguredAudienceModelAssociationInput {
	s.ConfiguredAudienceModelAssociationIdentifier = &v
	return s
}

// SetMembershipIdentifier sets the MembershipIdentifier field's value.
func (s *GetConfiguredAudienceModelAssociationInput) SetMembershipIdentifier(v string) *GetConfiguredAudienceModelAssociationInput {
	s.MembershipIdentifier = &v
	return s
}

type GetConfiguredAudienceModelAssociationOutput struct {
	_ struct{} `type:"structure"`

	// Information about the configured audience model association that you requested.
	//
	// ConfiguredAudienceModelAssociation is a required field
	ConfiguredAudienceModelAssociation *ConfiguredAudienceModelAssociation `locationName:"configuredAudienceModelAssociation" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetConfiguredAudienceModelAssociationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetConfiguredAudienceModelAssociationOutput) GoString() string {
	return s.String()
}

// SetConfiguredAudienceModelAssociation sets the ConfiguredAudienceModelAssociation field's value.
func (s *GetConfiguredAudienceModelAssociationOutput) SetConfiguredAudienceModelAssociation(v *ConfiguredAudienceModelAssociation) *GetConfiguredAudienceModelAssociationOutput {
	s.ConfiguredAudienceModelAssociation = v
	return s
}

type GetConfiguredTableAnalysisRuleInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The analysis rule to be retrieved. Configured table analysis rules are uniquely
	// identified by their configured table identifier and analysis rule type.
	//
	// AnalysisRuleType is a required field
	AnalysisRuleType *string `location:"uri" locationName:"analysisRuleType" type:"string" required:"true" enum:"ConfiguredTableAnalysisRuleType"`

	// The unique identifier for the configured table to retrieve. Currently accepts
	// the configured table ID.
	//
	// ConfiguredTableIdentifier is a required field
	ConfiguredTableIdentifier *string `location:"uri" locationName:"configuredTableIdentifier" min:"36" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetConfiguredTableAnalysisRuleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetConfiguredTableAnalysisRuleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetConfiguredTableAnalysisRuleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetConfiguredTableAnalysisRuleInput"}
	if s.AnalysisRuleType == nil {
		invalidParams.Add(request.NewErrParamRequired("AnalysisRuleType"))
	}
	if s.AnalysisRuleType != nil && len(*s.AnalysisRuleType) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AnalysisRuleType", 1))
	}
	if s.ConfiguredTableIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfiguredTableIdentifier"))
	}
	if s.ConfiguredTableIdentifier != nil && len(*s.ConfiguredTableIdentifier) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("ConfiguredTableIdentifier", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAnalysisRuleType sets the AnalysisRuleType field's value.
func (s *GetConfiguredTableAnalysisRuleInput) SetAnalysisRuleType(v string) *GetConfiguredTableAnalysisRuleInput {
	s.AnalysisRuleType = &v
	return s
}

// SetConfiguredTableIdentifier sets the ConfiguredTableIdentifier field's value.
func (s *GetConfiguredTableAnalysisRuleInput) SetConfiguredTableIdentifier(v string) *GetConfiguredTableAnalysisRuleInput {
	s.ConfiguredTableIdentifier = &v
	return s
}

type GetConfiguredTableAnalysisRuleOutput struct {
	_ struct{} `type:"structure"`

	// The entire analysis rule output.
	//
	// AnalysisRule is a required field
	AnalysisRule *ConfiguredTableAnalysisRule `locationName:"analysisRule" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetConfiguredTableAnalysisRuleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetConfiguredTableAnalysisRuleOutput) GoString() string {
	return s.String()
}

// SetAnalysisRule sets the AnalysisRule field's value.
func (s *GetConfiguredTableAnalysisRuleOutput) SetAnalysisRule(v *ConfiguredTableAnalysisRule) *GetConfiguredTableAnalysisRuleOutput {
	s.AnalysisRule = v
	return s
}

type GetConfiguredTableAssociationInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The unique ID for the configured table association to retrieve. Currently
	// accepts the configured table ID.
	//
	// ConfiguredTableAssociationIdentifier is a required field
	ConfiguredTableAssociationIdentifier *string `location:"uri" locationName:"configuredTableAssociationIdentifier" min:"36" type:"string" required:"true"`

	// A unique identifier for the membership that the configured table association
	// belongs to. Currently accepts the membership ID.
	//
	// MembershipIdentifier is a required field
	MembershipIdentifier *string `location:"uri" locationName:"membershipIdentifier" min:"36" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetConfiguredTableAssociationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetConfiguredTableAssociationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetConfiguredTableAssociationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetConfiguredTableAssociationInput"}
	if s.ConfiguredTableAssociationIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfiguredTableAssociationIdentifier"))
	}
	if s.ConfiguredTableAssociationIdentifier != nil && len(*s.ConfiguredTableAssociationIdentifier) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("ConfiguredTableAssociationIdentifier", 36))
	}
	if s.MembershipIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("MembershipIdentifier"))
	}
	if s.MembershipIdentifier != nil && len(*s.MembershipIdentifier) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("MembershipIdentifier", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfiguredTableAssociationIdentifier sets the ConfiguredTableAssociationIdentifier field's value.
func (s *GetConfiguredTableAssociationInput) SetConfiguredTableAssociationIdentifier(v string) *GetConfiguredTableAssociationInput {
	s.ConfiguredTableAssociationIdentifier = &v
	return s
}

// SetMembershipIdentifier sets the MembershipIdentifier field's value.
func (s *GetConfiguredTableAssociationInput) SetMembershipIdentifier(v string) *GetConfiguredTableAssociationInput {
	s.MembershipIdentifier = &v
	return s
}

type GetConfiguredTableAssociationOutput struct {
	_ struct{} `type:"structure"`

	// The entire configured table association object.
	//
	// ConfiguredTableAssociation is a required field
	ConfiguredTableAssociation *ConfiguredTableAssociation `locationName:"configuredTableAssociation" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetConfiguredTableAssociationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetConfiguredTableAssociationOutput) GoString() string {
	return s.String()
}

// SetConfiguredTableAssociation sets the ConfiguredTableAssociation field's value.
func (s *GetConfiguredTableAssociationOutput) SetConfiguredTableAssociation(v *ConfiguredTableAssociation) *GetConfiguredTableAssociationOutput {
	s.ConfiguredTableAssociation = v
	return s
}

type GetConfiguredTableInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The unique ID for the configured table to retrieve.
	//
	// ConfiguredTableIdentifier is a required field
	ConfiguredTableIdentifier *string `location:"uri" locationName:"configuredTableIdentifier" min:"36" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetConfiguredTableInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetConfiguredTableInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetConfiguredTableInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetConfiguredTableInput"}
	if s.ConfiguredTableIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfiguredTableIdentifier"))
	}
	if s.ConfiguredTableIdentifier != nil && len(*s.ConfiguredTableIdentifier) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("ConfiguredTableIdentifier", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfiguredTableIdentifier sets the ConfiguredTableIdentifier field's value.
func (s *GetConfiguredTableInput) SetConfiguredTableIdentifier(v string) *GetConfiguredTableInput {
	s.ConfiguredTableIdentifier = &v
	return s
}

type GetConfiguredTableOutput struct {
	_ struct{} `type:"structure"`

	// The retrieved configured table.
	//
	// ConfiguredTable is a required field
	ConfiguredTable *ConfiguredTable `locationName:"configuredTable" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetConfiguredTableOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetConfiguredTableOutput) GoString() string {
	return s.String()
}

// SetConfiguredTable sets the ConfiguredTable field's value.
func (s *GetConfiguredTableOutput) SetConfiguredTable(v *ConfiguredTable) *GetConfiguredTableOutput {
	s.ConfiguredTable = v
	return s
}

type GetIdMappingTableInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The unique identifier of the ID mapping table identifier that you want to
	// retrieve.
	//
	// IdMappingTableIdentifier is a required field
	IdMappingTableIdentifier *string `location:"uri" locationName:"idMappingTableIdentifier" min:"36" type:"string" required:"true"`

	// The unique identifier of the membership that contains the ID mapping table
	// that you want to retrieve.
	//
	// MembershipIdentifier is a required field
	MembershipIdentifier *string `location:"uri" locationName:"membershipIdentifier" min:"36" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetIdMappingTableInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetIdMappingTableInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetIdMappingTableInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetIdMappingTableInput"}
	if s.IdMappingTableIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("IdMappingTableIdentifier"))
	}
	if s.IdMappingTableIdentifier != nil && len(*s.IdMappingTableIdentifier) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("IdMappingTableIdentifier", 36))
	}
	if s.MembershipIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("MembershipIdentifier"))
	}
	if s.MembershipIdentifier != nil && len(*s.MembershipIdentifier) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("MembershipIdentifier", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIdMappingTableIdentifier sets the IdMappingTableIdentifier field's value.
func (s *GetIdMappingTableInput) SetIdMappingTableIdentifier(v string) *GetIdMappingTableInput {
	s.IdMappingTableIdentifier = &v
	return s
}

// SetMembershipIdentifier sets the MembershipIdentifier field's value.
func (s *GetIdMappingTableInput) SetMembershipIdentifier(v string) *GetIdMappingTableInput {
	s.MembershipIdentifier = &v
	return s
}

type GetIdMappingTableOutput struct {
	_ struct{} `type:"structure"`

	// The ID mapping table that you requested.
	//
	// IdMappingTable is a required field
	IdMappingTable *IdMappingTable `locationName:"idMappingTable" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetIdMappingTableOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetIdMappingTableOutput) GoString() string {
	return s.String()
}

// SetIdMappingTable sets the IdMappingTable field's value.
func (s *GetIdMappingTableOutput) SetIdMappingTable(v *IdMappingTable) *GetIdMappingTableOutput {
	s.IdMappingTable = v
	return s
}

type GetMembershipInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The identifier for a membership resource.
	//
	// MembershipIdentifier is a required field
	MembershipIdentifier *string `location:"uri" locationName:"membershipIdentifier" min:"36" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetMembershipInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetMembershipInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetMembershipInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetMembershipInput"}
	if s.MembershipIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("MembershipIdentifier"))
	}
	if s.MembershipIdentifier != nil && len(*s.MembershipIdentifier) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("MembershipIdentifier", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMembershipIdentifier sets the MembershipIdentifier field's value.
func (s *GetMembershipInput) SetMembershipIdentifier(v string) *GetMembershipInput {
	s.MembershipIdentifier = &v
	return s
}

type GetMembershipOutput struct {
	_ struct{} `type:"structure"`

	// The membership retrieved for the provided identifier.
	//
	// Membership is a required field
	Membership *Membership `locationName:"membership" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetMembershipOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetMembershipOutput) GoString() string {
	return s.String()
}

// SetMembership sets the Membership field's value.
func (s *GetMembershipOutput) SetMembership(v *Membership) *GetMembershipOutput {
	s.Membership = v
	return s
}

type GetPrivacyBudgetTemplateInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// A unique identifier for one of your memberships for a collaboration. The
	// privacy budget template is retrieved from the collaboration that this membership
	// belongs to. Accepts a membership ID.
	//
	// MembershipIdentifier is a required field
	MembershipIdentifier *string `location:"uri" locationName:"membershipIdentifier" min:"36" type:"string" required:"true"`

	// A unique identifier for your privacy budget template.
	//
	// PrivacyBudgetTemplateIdentifier is a required field
	PrivacyBudgetTemplateIdentifier *string `location:"uri" locationName:"privacyBudgetTemplateIdentifier" min:"36" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetPrivacyBudgetTemplateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetPrivacyBudgetTemplateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetPrivacyBudgetTemplateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetPrivacyBudgetTemplateInput"}
	if s.MembershipIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("MembershipIdentifier"))
	}
	if s.MembershipIdentifier != nil && len(*s.MembershipIdentifier) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("MembershipIdentifier", 36))
	}
	if s.PrivacyBudgetTemplateIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("PrivacyBudgetTemplateIdentifier"))
	}
	if s.PrivacyBudgetTemplateIdentifier != nil && len(*s.PrivacyBudgetTemplateIdentifier) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("PrivacyBudgetTemplateIdentifier", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMembershipIdentifier sets the MembershipIdentifier field's value.
func (s *GetPrivacyBudgetTemplateInput) SetMembershipIdentifier(v string) *GetPrivacyBudgetTemplateInput {
	s.MembershipIdentifier = &v
	return s
}

// SetPrivacyBudgetTemplateIdentifier sets the PrivacyBudgetTemplateIdentifier field's value.
func (s *GetPrivacyBudgetTemplateInput) SetPrivacyBudgetTemplateIdentifier(v string) *GetPrivacyBudgetTemplateInput {
	s.PrivacyBudgetTemplateIdentifier = &v
	return s
}

type GetPrivacyBudgetTemplateOutput struct {
	_ struct{} `type:"structure"`

	// Returns the details of the privacy budget template that you requested.
	//
	// PrivacyBudgetTemplate is a required field
	PrivacyBudgetTemplate *PrivacyBudgetTemplate `locationName:"privacyBudgetTemplate" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetPrivacyBudgetTemplateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetPrivacyBudgetTemplateOutput) GoString() string {
	return s.String()
}

// SetPrivacyBudgetTemplate sets the PrivacyBudgetTemplate field's value.
func (s *GetPrivacyBudgetTemplateOutput) SetPrivacyBudgetTemplate(v *PrivacyBudgetTemplate) *GetPrivacyBudgetTemplateOutput {
	s.PrivacyBudgetTemplate = v
	return s
}

type GetProtectedQueryInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The identifier for a membership in a protected query instance.
	//
	// MembershipIdentifier is a required field
	MembershipIdentifier *string `location:"uri" locationName:"membershipIdentifier" min:"36" type:"string" required:"true"`

	// The identifier for a protected query instance.
	//
	// ProtectedQueryIdentifier is a required field
	ProtectedQueryIdentifier *string `location:"uri" locationName:"protectedQueryIdentifier" min:"36" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetProtectedQueryInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetProtectedQueryInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetProtectedQueryInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetProtectedQueryInput"}
	if s.MembershipIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("MembershipIdentifier"))
	}
	if s.MembershipIdentifier != nil && len(*s.MembershipIdentifier) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("MembershipIdentifier", 36))
	}
	if s.ProtectedQueryIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("ProtectedQueryIdentifier"))
	}
	if s.ProtectedQueryIdentifier != nil && len(*s.ProtectedQueryIdentifier) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("ProtectedQueryIdentifier", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMembershipIdentifier sets the MembershipIdentifier field's value.
func (s *GetProtectedQueryInput) SetMembershipIdentifier(v string) *GetProtectedQueryInput {
	s.MembershipIdentifier = &v
	return s
}

// SetProtectedQueryIdentifier sets the ProtectedQueryIdentifier field's value.
func (s *GetProtectedQueryInput) SetProtectedQueryIdentifier(v string) *GetProtectedQueryInput {
	s.ProtectedQueryIdentifier = &v
	return s
}

type GetProtectedQueryOutput struct {
	_ struct{} `type:"structure"`

	// The query processing metadata.
	//
	// ProtectedQuery is a required field
	ProtectedQuery *ProtectedQuery `locationName:"protectedQuery" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetProtectedQueryOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetProtectedQueryOutput) GoString() string {
	return s.String()
}

// SetProtectedQuery sets the ProtectedQuery field's value.
func (s *GetProtectedQueryOutput) SetProtectedQuery(v *ProtectedQuery) *GetProtectedQueryOutput {
	s.ProtectedQuery = v
	return s
}

type GetSchemaAnalysisRuleInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// A unique identifier for the collaboration that the schema belongs to. Currently
	// accepts a collaboration ID.
	//
	// CollaborationIdentifier is a required field
	CollaborationIdentifier *string `location:"uri" locationName:"collaborationIdentifier" min:"36" type:"string" required:"true"`

	// The name of the schema to retrieve the analysis rule for.
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"name" type:"string" required:"true"`

	// The type of the schema analysis rule to retrieve. Schema analysis rules are
	// uniquely identified by a combination of the collaboration, the schema name,
	// and their type.
	//
	// Type is a required field
	Type *string `location:"uri" locationName:"type" type:"string" required:"true" enum:"AnalysisRuleType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSchemaAnalysisRuleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSchemaAnalysisRuleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetSchemaAnalysisRuleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetSchemaAnalysisRuleInput"}
	if s.CollaborationIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("CollaborationIdentifier"))
	}
	if s.CollaborationIdentifier != nil && len(*s.CollaborationIdentifier) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("CollaborationIdentifier", 36))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}
	if s.Type != nil && len(*s.Type) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Type", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCollaborationIdentifier sets the CollaborationIdentifier field's value.
func (s *GetSchemaAnalysisRuleInput) SetCollaborationIdentifier(v string) *GetSchemaAnalysisRuleInput {
	s.CollaborationIdentifier = &v
	return s
}

// SetName sets the Name field's value.
func (s *GetSchemaAnalysisRuleInput) SetName(v string) *GetSchemaAnalysisRuleInput {
	s.Name = &v
	return s
}

// SetType sets the Type field's value.
func (s *GetSchemaAnalysisRuleInput) SetType(v string) *GetSchemaAnalysisRuleInput {
	s.Type = &v
	return s
}

type GetSchemaAnalysisRuleOutput struct {
	_ struct{} `type:"structure"`

	// A specification about how data from the configured table can be used.
	//
	// AnalysisRule is a required field
	AnalysisRule *AnalysisRule `locationName:"analysisRule" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSchemaAnalysisRuleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSchemaAnalysisRuleOutput) GoString() string {
	return s.String()
}

// SetAnalysisRule sets the AnalysisRule field's value.
func (s *GetSchemaAnalysisRuleOutput) SetAnalysisRule(v *AnalysisRule) *GetSchemaAnalysisRuleOutput {
	s.AnalysisRule = v
	return s
}

type GetSchemaInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// A unique identifier for the collaboration that the schema belongs to. Currently
	// accepts a collaboration ID.
	//
	// CollaborationIdentifier is a required field
	CollaborationIdentifier *string `location:"uri" locationName:"collaborationIdentifier" min:"36" type:"string" required:"true"`

	// The name of the relation to retrieve the schema for.
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"name" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSchemaInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSchemaInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetSchemaInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetSchemaInput"}
	if s.CollaborationIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("CollaborationIdentifier"))
	}
	if s.CollaborationIdentifier != nil && len(*s.CollaborationIdentifier) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("CollaborationIdentifier", 36))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCollaborationIdentifier sets the CollaborationIdentifier field's value.
func (s *GetSchemaInput) SetCollaborationIdentifier(v string) *GetSchemaInput {
	s.CollaborationIdentifier = &v
	return s
}

// SetName sets the Name field's value.
func (s *GetSchemaInput) SetName(v string) *GetSchemaInput {
	s.Name = &v
	return s
}

type GetSchemaOutput struct {
	_ struct{} `type:"structure"`

	// The entire schema object.
	//
	// Schema is a required field
	Schema *Schema `locationName:"schema" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSchemaOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSchemaOutput) GoString() string {
	return s.String()
}

// SetSchema sets the Schema field's value.
func (s *GetSchemaOutput) SetSchema(v *Schema) *GetSchemaOutput {
	s.Schema = v
	return s
}

// A reference to a table within an Glue data catalog.
type GlueTableReference struct {
	_ struct{} `type:"structure"`

	// The name of the database the Glue table belongs to.
	//
	// DatabaseName is a required field
	DatabaseName *string `locationName:"databaseName" type:"string" required:"true"`

	// The name of the Glue table.
	//
	// TableName is a required field
	TableName *string `locationName:"tableName" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GlueTableReference) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GlueTableReference) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GlueTableReference) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GlueTableReference"}
	if s.DatabaseName == nil {
		invalidParams.Add(request.NewErrParamRequired("DatabaseName"))
	}
	if s.TableName == nil {
		invalidParams.Add(request.NewErrParamRequired("TableName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDatabaseName sets the DatabaseName field's value.
func (s *GlueTableReference) SetDatabaseName(v string) *GlueTableReference {
	s.DatabaseName = &v
	return s
}

// SetTableName sets the TableName field's value.
func (s *GlueTableReference) SetTableName(v string) *GlueTableReference {
	s.TableName = &v
	return s
}

// Describes information about the ID mapping table.
type IdMappingTable struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the ID mapping table.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the collaboration that contains this ID
	// mapping table.
	//
	// CollaborationArn is a required field
	CollaborationArn *string `locationName:"collaborationArn" type:"string" required:"true"`

	// The unique identifier of the collaboration that contains this ID mapping
	// table.
	//
	// CollaborationId is a required field
	CollaborationId *string `locationName:"collaborationId" min:"36" type:"string" required:"true"`

	// The time at which the ID mapping table was created.
	//
	// CreateTime is a required field
	CreateTime *time.Time `locationName:"createTime" type:"timestamp" required:"true"`

	// The description of the ID mapping table.
	Description *string `locationName:"description" type:"string"`

	// The unique identifier of the ID mapping table.
	//
	// Id is a required field
	Id *string `locationName:"id" min:"36" type:"string" required:"true"`

	// The input reference configuration for the ID mapping table.
	//
	// InputReferenceConfig is a required field
	InputReferenceConfig *IdMappingTableInputReferenceConfig `locationName:"inputReferenceConfig" type:"structure" required:"true"`

	// The input reference properties for the ID mapping table.
	//
	// InputReferenceProperties is a required field
	InputReferenceProperties *IdMappingTableInputReferenceProperties `locationName:"inputReferenceProperties" type:"structure" required:"true"`

	// The Amazon Resource Name (ARN) of the Amazon Web Services KMS key.
	KmsKeyArn *string `locationName:"kmsKeyArn" min:"20" type:"string"`

	// The Amazon Resource Name (ARN) of the membership resource for the ID mapping
	// table.
	//
	// MembershipArn is a required field
	MembershipArn *string `locationName:"membershipArn" type:"string" required:"true"`

	// The unique identifier of the membership resource for the ID mapping table.
	//
	// MembershipId is a required field
	MembershipId *string `locationName:"membershipId" min:"36" type:"string" required:"true"`

	// The name of the ID mapping table.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// The most recent time at which the ID mapping table was updated.
	//
	// UpdateTime is a required field
	UpdateTime *time.Time `locationName:"updateTime" type:"timestamp" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IdMappingTable) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IdMappingTable) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *IdMappingTable) SetArn(v string) *IdMappingTable {
	s.Arn = &v
	return s
}

// SetCollaborationArn sets the CollaborationArn field's value.
func (s *IdMappingTable) SetCollaborationArn(v string) *IdMappingTable {
	s.CollaborationArn = &v
	return s
}

// SetCollaborationId sets the CollaborationId field's value.
func (s *IdMappingTable) SetCollaborationId(v string) *IdMappingTable {
	s.CollaborationId = &v
	return s
}

// SetCreateTime sets the CreateTime field's value.
func (s *IdMappingTable) SetCreateTime(v time.Time) *IdMappingTable {
	s.CreateTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *IdMappingTable) SetDescription(v string) *IdMappingTable {
	s.Description = &v
	return s
}

// SetId sets the Id field's value.
func (s *IdMappingTable) SetId(v string) *IdMappingTable {
	s.Id = &v
	return s
}

// SetInputReferenceConfig sets the InputReferenceConfig field's value.
func (s *IdMappingTable) SetInputReferenceConfig(v *IdMappingTableInputReferenceConfig) *IdMappingTable {
	s.InputReferenceConfig = v
	return s
}

// SetInputReferenceProperties sets the InputReferenceProperties field's value.
func (s *IdMappingTable) SetInputReferenceProperties(v *IdMappingTableInputReferenceProperties) *IdMappingTable {
	s.InputReferenceProperties = v
	return s
}

// SetKmsKeyArn sets the KmsKeyArn field's value.
func (s *IdMappingTable) SetKmsKeyArn(v string) *IdMappingTable {
	s.KmsKeyArn = &v
	return s
}

// SetMembershipArn sets the MembershipArn field's value.
func (s *IdMappingTable) SetMembershipArn(v string) *IdMappingTable {
	s.MembershipArn = &v
	return s
}

// SetMembershipId sets the MembershipId field's value.
func (s *IdMappingTable) SetMembershipId(v string) *IdMappingTable {
	s.MembershipId = &v
	return s
}

// SetName sets the Name field's value.
func (s *IdMappingTable) SetName(v string) *IdMappingTable {
	s.Name = &v
	return s
}

// SetUpdateTime sets the UpdateTime field's value.
func (s *IdMappingTable) SetUpdateTime(v time.Time) *IdMappingTable {
	s.UpdateTime = &v
	return s
}

// Provides the input reference configuration for the ID mapping table.
type IdMappingTableInputReferenceConfig struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the referenced resource in Entity Resolution.
	// Valid values are ID mapping workflow ARNs.
	//
	// InputReferenceArn is a required field
	InputReferenceArn *string `locationName:"inputReferenceArn" min:"20" type:"string" required:"true"`

	// When TRUE, Clean Rooms manages permissions for the ID mapping table resource.
	//
	// When FALSE, the resource owner manages permissions for the ID mapping table
	// resource.
	//
	// ManageResourcePolicies is a required field
	ManageResourcePolicies *bool `locationName:"manageResourcePolicies" type:"boolean" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IdMappingTableInputReferenceConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IdMappingTableInputReferenceConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *IdMappingTableInputReferenceConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "IdMappingTableInputReferenceConfig"}
	if s.InputReferenceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("InputReferenceArn"))
	}
	if s.InputReferenceArn != nil && len(*s.InputReferenceArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("InputReferenceArn", 20))
	}
	if s.ManageResourcePolicies == nil {
		invalidParams.Add(request.NewErrParamRequired("ManageResourcePolicies"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInputReferenceArn sets the InputReferenceArn field's value.
func (s *IdMappingTableInputReferenceConfig) SetInputReferenceArn(v string) *IdMappingTableInputReferenceConfig {
	s.InputReferenceArn = &v
	return s
}

// SetManageResourcePolicies sets the ManageResourcePolicies field's value.
func (s *IdMappingTableInputReferenceConfig) SetManageResourcePolicies(v bool) *IdMappingTableInputReferenceConfig {
	s.ManageResourcePolicies = &v
	return s
}

// The input reference properties for the ID mapping table.
type IdMappingTableInputReferenceProperties struct {
	_ struct{} `type:"structure"`

	// The input source of the ID mapping table.
	//
	// IdMappingTableInputSource is a required field
	IdMappingTableInputSource []*IdMappingTableInputSource `locationName:"idMappingTableInputSource" min:"2" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IdMappingTableInputReferenceProperties) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IdMappingTableInputReferenceProperties) GoString() string {
	return s.String()
}

// SetIdMappingTableInputSource sets the IdMappingTableInputSource field's value.
func (s *IdMappingTableInputReferenceProperties) SetIdMappingTableInputSource(v []*IdMappingTableInputSource) *IdMappingTableInputReferenceProperties {
	s.IdMappingTableInputSource = v
	return s
}

// The input source of the ID mapping table.
type IdMappingTableInputSource struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the ID namespace association.
	//
	// IdNamespaceAssociationId is a required field
	IdNamespaceAssociationId *string `locationName:"idNamespaceAssociationId" type:"string" required:"true"`

	// The type of the input source of the ID mapping table.
	//
	// Type is a required field
	Type *string `locationName:"type" type:"string" required:"true" enum:"IdNamespaceType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IdMappingTableInputSource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IdMappingTableInputSource) GoString() string {
	return s.String()
}

// SetIdNamespaceAssociationId sets the IdNamespaceAssociationId field's value.
func (s *IdMappingTableInputSource) SetIdNamespaceAssociationId(v string) *IdMappingTableInputSource {
	s.IdNamespaceAssociationId = &v
	return s
}

// SetType sets the Type field's value.
func (s *IdMappingTableInputSource) SetType(v string) *IdMappingTableInputSource {
	s.Type = &v
	return s
}

// Additional properties that are specific to the type of the associated schema.
type IdMappingTableSchemaTypeProperties struct {
	_ struct{} `type:"structure"`

	// Defines which ID namespace associations are used to create the ID mapping
	// table.
	//
	// IdMappingTableInputSource is a required field
	IdMappingTableInputSource []*IdMappingTableInputSource `locationName:"idMappingTableInputSource" min:"2" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IdMappingTableSchemaTypeProperties) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IdMappingTableSchemaTypeProperties) GoString() string {
	return s.String()
}

// SetIdMappingTableInputSource sets the IdMappingTableInputSource field's value.
func (s *IdMappingTableSchemaTypeProperties) SetIdMappingTableInputSource(v []*IdMappingTableInputSource) *IdMappingTableSchemaTypeProperties {
	s.IdMappingTableInputSource = v
	return s
}

// Detailed information about the ID mapping table.
type IdMappingTableSummary struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of this ID mapping table.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the collaboration that contains this ID
	// mapping table.
	//
	// CollaborationArn is a required field
	CollaborationArn *string `locationName:"collaborationArn" type:"string" required:"true"`

	// The unique identifier of the collaboration that contains this ID mapping
	// table.
	//
	// CollaborationId is a required field
	CollaborationId *string `locationName:"collaborationId" min:"36" type:"string" required:"true"`

	// The time at which this ID mapping table was created.
	//
	// CreateTime is a required field
	CreateTime *time.Time `locationName:"createTime" type:"timestamp" required:"true"`

	// The description of this ID mapping table.
	Description *string `locationName:"description" type:"string"`

	// The unique identifier of this ID mapping table.
	//
	// Id is a required field
	Id *string `locationName:"id" min:"36" type:"string" required:"true"`

	// The input reference configuration for the ID mapping table.
	//
	// InputReferenceConfig is a required field
	InputReferenceConfig *IdMappingTableInputReferenceConfig `locationName:"inputReferenceConfig" type:"structure" required:"true"`

	// The Amazon Resource Name (ARN) of the membership resource for this ID mapping
	// table.
	//
	// MembershipArn is a required field
	MembershipArn *string `locationName:"membershipArn" type:"string" required:"true"`

	// The unique identifier of the membership resource for this ID mapping table.
	//
	// MembershipId is a required field
	MembershipId *string `locationName:"membershipId" min:"36" type:"string" required:"true"`

	// The name of this ID mapping table.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// The most recent time at which this ID mapping table was updated.
	//
	// UpdateTime is a required field
	UpdateTime *time.Time `locationName:"updateTime" type:"timestamp" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IdMappingTableSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IdMappingTableSummary) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *IdMappingTableSummary) SetArn(v string) *IdMappingTableSummary {
	s.Arn = &v
	return s
}

// SetCollaborationArn sets the CollaborationArn field's value.
func (s *IdMappingTableSummary) SetCollaborationArn(v string) *IdMappingTableSummary {
	s.CollaborationArn = &v
	return s
}

// SetCollaborationId sets the CollaborationId field's value.
func (s *IdMappingTableSummary) SetCollaborationId(v string) *IdMappingTableSummary {
	s.CollaborationId = &v
	return s
}

// SetCreateTime sets the CreateTime field's value.
func (s *IdMappingTableSummary) SetCreateTime(v time.Time) *IdMappingTableSummary {
	s.CreateTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *IdMappingTableSummary) SetDescription(v string) *IdMappingTableSummary {
	s.Description = &v
	return s
}

// SetId sets the Id field's value.
func (s *IdMappingTableSummary) SetId(v string) *IdMappingTableSummary {
	s.Id = &v
	return s
}

// SetInputReferenceConfig sets the InputReferenceConfig field's value.
func (s *IdMappingTableSummary) SetInputReferenceConfig(v *IdMappingTableInputReferenceConfig) *IdMappingTableSummary {
	s.InputReferenceConfig = v
	return s
}

// SetMembershipArn sets the MembershipArn field's value.
func (s *IdMappingTableSummary) SetMembershipArn(v string) *IdMappingTableSummary {
	s.MembershipArn = &v
	return s
}

// SetMembershipId sets the MembershipId field's value.
func (s *IdMappingTableSummary) SetMembershipId(v string) *IdMappingTableSummary {
	s.MembershipId = &v
	return s
}

// SetName sets the Name field's value.
func (s *IdMappingTableSummary) SetName(v string) *IdMappingTableSummary {
	s.Name = &v
	return s
}

// SetUpdateTime sets the UpdateTime field's value.
func (s *IdMappingTableSummary) SetUpdateTime(v time.Time) *IdMappingTableSummary {
	s.UpdateTime = &v
	return s
}

// Provides the information for the ID namespace association input reference
// configuration.
type IdNamespaceAssociationInputReferenceConfig struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the Entity Resolution resource that is
	// being associated to the collaboration. Valid resource ARNs are from the ID
	// namespaces that you own.
	//
	// InputReferenceArn is a required field
	InputReferenceArn *string `locationName:"inputReferenceArn" type:"string" required:"true"`

	// When TRUE, Clean Rooms manages permissions for the ID namespace association
	// resource.
	//
	// When FALSE, the resource owner manages permissions for the ID namespace association
	// resource.
	//
	// ManageResourcePolicies is a required field
	ManageResourcePolicies *bool `locationName:"manageResourcePolicies" type:"boolean" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IdNamespaceAssociationInputReferenceConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IdNamespaceAssociationInputReferenceConfig) GoString() string {
	return s.String()
}

// SetInputReferenceArn sets the InputReferenceArn field's value.
func (s *IdNamespaceAssociationInputReferenceConfig) SetInputReferenceArn(v string) *IdNamespaceAssociationInputReferenceConfig {
	s.InputReferenceArn = &v
	return s
}

// SetManageResourcePolicies sets the ManageResourcePolicies field's value.
func (s *IdNamespaceAssociationInputReferenceConfig) SetManageResourcePolicies(v bool) *IdNamespaceAssociationInputReferenceConfig {
	s.ManageResourcePolicies = &v
	return s
}

// Detailed information about the ID namespace association input reference properties.
type IdNamespaceAssociationInputReferencePropertiesSummary struct {
	_ struct{} `type:"structure"`

	// The ID namespace type for this ID namespace association.
	//
	// IdNamespaceType is a required field
	IdNamespaceType *string `locationName:"idNamespaceType" type:"string" required:"true" enum:"IdNamespaceType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IdNamespaceAssociationInputReferencePropertiesSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IdNamespaceAssociationInputReferencePropertiesSummary) GoString() string {
	return s.String()
}

// SetIdNamespaceType sets the IdNamespaceType field's value.
func (s *IdNamespaceAssociationInputReferencePropertiesSummary) SetIdNamespaceType(v string) *IdNamespaceAssociationInputReferencePropertiesSummary {
	s.IdNamespaceType = &v
	return s
}

// Detailed information about the ID namespace association.
type IdNamespaceAssociationSummary struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of this ID namespace association.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the collaboration that contains this ID
	// namespace association.
	//
	// CollaborationArn is a required field
	CollaborationArn *string `locationName:"collaborationArn" type:"string" required:"true"`

	// The unique identifier of the collaboration that contains this ID namespace
	// association.
	//
	// CollaborationId is a required field
	CollaborationId *string `locationName:"collaborationId" min:"36" type:"string" required:"true"`

	// The time at which this ID namespace association was created.
	//
	// CreateTime is a required field
	CreateTime *time.Time `locationName:"createTime" type:"timestamp" required:"true"`

	// The description of the ID namespace association.
	Description *string `locationName:"description" type:"string"`

	// The unique identifier of this ID namespace association.
	//
	// Id is a required field
	Id *string `locationName:"id" min:"36" type:"string" required:"true"`

	// The input reference configuration details for this ID namespace association.
	//
	// InputReferenceConfig is a required field
	InputReferenceConfig *IdNamespaceAssociationInputReferenceConfig `locationName:"inputReferenceConfig" type:"structure" required:"true"`

	// The input reference properties for this ID namespace association.
	//
	// InputReferenceProperties is a required field
	InputReferenceProperties *IdNamespaceAssociationInputReferencePropertiesSummary `locationName:"inputReferenceProperties" type:"structure" required:"true"`

	// The Amazon Resource Name (ARN) of the membership resource for this ID namespace
	// association.
	//
	// MembershipArn is a required field
	MembershipArn *string `locationName:"membershipArn" type:"string" required:"true"`

	// The unique identifier of the membership resource for this ID namespace association.
	//
	// MembershipId is a required field
	MembershipId *string `locationName:"membershipId" min:"36" type:"string" required:"true"`

	// The name of the ID namespace association.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The most recent time at which this ID namespace association has been updated.
	//
	// UpdateTime is a required field
	UpdateTime *time.Time `locationName:"updateTime" type:"timestamp" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IdNamespaceAssociationSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IdNamespaceAssociationSummary) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *IdNamespaceAssociationSummary) SetArn(v string) *IdNamespaceAssociationSummary {
	s.Arn = &v
	return s
}

// SetCollaborationArn sets the CollaborationArn field's value.
func (s *IdNamespaceAssociationSummary) SetCollaborationArn(v string) *IdNamespaceAssociationSummary {
	s.CollaborationArn = &v
	return s
}

// SetCollaborationId sets the CollaborationId field's value.
func (s *IdNamespaceAssociationSummary) SetCollaborationId(v string) *IdNamespaceAssociationSummary {
	s.CollaborationId = &v
	return s
}

// SetCreateTime sets the CreateTime field's value.
func (s *IdNamespaceAssociationSummary) SetCreateTime(v time.Time) *IdNamespaceAssociationSummary {
	s.CreateTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *IdNamespaceAssociationSummary) SetDescription(v string) *IdNamespaceAssociationSummary {
	s.Description = &v
	return s
}

// SetId sets the Id field's value.
func (s *IdNamespaceAssociationSummary) SetId(v string) *IdNamespaceAssociationSummary {
	s.Id = &v
	return s
}

// SetInputReferenceConfig sets the InputReferenceConfig field's value.
func (s *IdNamespaceAssociationSummary) SetInputReferenceConfig(v *IdNamespaceAssociationInputReferenceConfig) *IdNamespaceAssociationSummary {
	s.InputReferenceConfig = v
	return s
}

// SetInputReferenceProperties sets the InputReferenceProperties field's value.
func (s *IdNamespaceAssociationSummary) SetInputReferenceProperties(v *IdNamespaceAssociationInputReferencePropertiesSummary) *IdNamespaceAssociationSummary {
	s.InputReferenceProperties = v
	return s
}

// SetMembershipArn sets the MembershipArn field's value.
func (s *IdNamespaceAssociationSummary) SetMembershipArn(v string) *IdNamespaceAssociationSummary {
	s.MembershipArn = &v
	return s
}

// SetMembershipId sets the MembershipId field's value.
func (s *IdNamespaceAssociationSummary) SetMembershipId(v string) *IdNamespaceAssociationSummary {
	s.MembershipId = &v
	return s
}

// SetName sets the Name field's value.
func (s *IdNamespaceAssociationSummary) SetName(v string) *IdNamespaceAssociationSummary {
	s.Name = &v
	return s
}

// SetUpdateTime sets the UpdateTime field's value.
func (s *IdNamespaceAssociationSummary) SetUpdateTime(v time.Time) *IdNamespaceAssociationSummary {
	s.UpdateTime = &v
	return s
}

// Unexpected error during processing of request.
type InternalServerException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) GoString() string {
	return s.String()
}

func newErrorInternalServerException(v protocol.ResponseMetadata) error {
	return &InternalServerException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServerException) Code() string {
	return "InternalServerException"
}

// Message returns the exception's message.
func (s *InternalServerException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServerException) OrigErr() error {
	return nil
}

func (s *InternalServerException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServerException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServerException) RequestID() string {
	return s.RespMetadata.RequestID
}

type ListAnalysisTemplatesInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The maximum number of results that are returned for an API request call.
	// The service chooses a default number if you don't set one. The service might
	// return a `nextToken` even if the `maxResults` value has not been met.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The identifier for a membership resource.
	//
	// MembershipIdentifier is a required field
	MembershipIdentifier *string `location:"uri" locationName:"membershipIdentifier" min:"36" type:"string" required:"true"`

	// The pagination token that's used to fetch the next set of results.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAnalysisTemplatesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAnalysisTemplatesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListAnalysisTemplatesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListAnalysisTemplatesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.MembershipIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("MembershipIdentifier"))
	}
	if s.MembershipIdentifier != nil && len(*s.MembershipIdentifier) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("MembershipIdentifier", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListAnalysisTemplatesInput) SetMaxResults(v int64) *ListAnalysisTemplatesInput {
	s.MaxResults = &v
	return s
}

// SetMembershipIdentifier sets the MembershipIdentifier field's value.
func (s *ListAnalysisTemplatesInput) SetMembershipIdentifier(v string) *ListAnalysisTemplatesInput {
	s.MembershipIdentifier = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAnalysisTemplatesInput) SetNextToken(v string) *ListAnalysisTemplatesInput {
	s.NextToken = &v
	return s
}

type ListAnalysisTemplatesOutput struct {
	_ struct{} `type:"structure"`

	// Lists analysis template metadata.
	//
	// AnalysisTemplateSummaries is a required field
	AnalysisTemplateSummaries []*AnalysisTemplateSummary `locationName:"analysisTemplateSummaries" type:"list" required:"true"`

	// The pagination token that's used to fetch the next set of results.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAnalysisTemplatesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAnalysisTemplatesOutput) GoString() string {
	return s.String()
}

// SetAnalysisTemplateSummaries sets the AnalysisTemplateSummaries field's value.
func (s *ListAnalysisTemplatesOutput) SetAnalysisTemplateSummaries(v []*AnalysisTemplateSummary) *ListAnalysisTemplatesOutput {
	s.AnalysisTemplateSummaries = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAnalysisTemplatesOutput) SetNextToken(v string) *ListAnalysisTemplatesOutput {
	s.NextToken = &v
	return s
}

type ListCollaborationAnalysisTemplatesInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// A unique identifier for the collaboration that the analysis templates belong
	// to. Currently accepts collaboration ID.
	//
	// CollaborationIdentifier is a required field
	CollaborationIdentifier *string `location:"uri" locationName:"collaborationIdentifier" min:"36" type:"string" required:"true"`

	// The maximum number of results that are returned for an API request call.
	// The service chooses a default number if you don't set one. The service might
	// return a `nextToken` even if the `maxResults` value has not been met.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The pagination token that's used to fetch the next set of results.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCollaborationAnalysisTemplatesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCollaborationAnalysisTemplatesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListCollaborationAnalysisTemplatesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListCollaborationAnalysisTemplatesInput"}
	if s.CollaborationIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("CollaborationIdentifier"))
	}
	if s.CollaborationIdentifier != nil && len(*s.CollaborationIdentifier) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("CollaborationIdentifier", 36))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCollaborationIdentifier sets the CollaborationIdentifier field's value.
func (s *ListCollaborationAnalysisTemplatesInput) SetCollaborationIdentifier(v string) *ListCollaborationAnalysisTemplatesInput {
	s.CollaborationIdentifier = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListCollaborationAnalysisTemplatesInput) SetMaxResults(v int64) *ListCollaborationAnalysisTemplatesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListCollaborationAnalysisTemplatesInput) SetNextToken(v string) *ListCollaborationAnalysisTemplatesInput {
	s.NextToken = &v
	return s
}

type ListCollaborationAnalysisTemplatesOutput struct {
	_ struct{} `type:"structure"`

	// The metadata of the analysis template within a collaboration.
	//
	// CollaborationAnalysisTemplateSummaries is a required field
	CollaborationAnalysisTemplateSummaries []*CollaborationAnalysisTemplateSummary `locationName:"collaborationAnalysisTemplateSummaries" type:"list" required:"true"`

	// The pagination token that's used to fetch the next set of results.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCollaborationAnalysisTemplatesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCollaborationAnalysisTemplatesOutput) GoString() string {
	return s.String()
}

// SetCollaborationAnalysisTemplateSummaries sets the CollaborationAnalysisTemplateSummaries field's value.
func (s *ListCollaborationAnalysisTemplatesOutput) SetCollaborationAnalysisTemplateSummaries(v []*CollaborationAnalysisTemplateSummary) *ListCollaborationAnalysisTemplatesOutput {
	s.CollaborationAnalysisTemplateSummaries = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListCollaborationAnalysisTemplatesOutput) SetNextToken(v string) *ListCollaborationAnalysisTemplatesOutput {
	s.NextToken = &v
	return s
}

type ListCollaborationConfiguredAudienceModelAssociationsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// A unique identifier for the collaboration that the configured audience model
	// association belongs to. Accepts a collaboration ID.
	//
	// CollaborationIdentifier is a required field
	CollaborationIdentifier *string `location:"uri" locationName:"collaborationIdentifier" min:"36" type:"string" required:"true"`

	// The maximum number of results that are returned for an API request call.
	// The service chooses a default number if you don't set one. The service might
	// return a `nextToken` even if the `maxResults` value has not been met.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The pagination token that's used to fetch the next set of results.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCollaborationConfiguredAudienceModelAssociationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCollaborationConfiguredAudienceModelAssociationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListCollaborationConfiguredAudienceModelAssociationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListCollaborationConfiguredAudienceModelAssociationsInput"}
	if s.CollaborationIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("CollaborationIdentifier"))
	}
	if s.CollaborationIdentifier != nil && len(*s.CollaborationIdentifier) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("CollaborationIdentifier", 36))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCollaborationIdentifier sets the CollaborationIdentifier field's value.
func (s *ListCollaborationConfiguredAudienceModelAssociationsInput) SetCollaborationIdentifier(v string) *ListCollaborationConfiguredAudienceModelAssociationsInput {
	s.CollaborationIdentifier = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListCollaborationConfiguredAudienceModelAssociationsInput) SetMaxResults(v int64) *ListCollaborationConfiguredAudienceModelAssociationsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListCollaborationConfiguredAudienceModelAssociationsInput) SetNextToken(v string) *ListCollaborationConfiguredAudienceModelAssociationsInput {
	s.NextToken = &v
	return s
}

type ListCollaborationConfiguredAudienceModelAssociationsOutput struct {
	_ struct{} `type:"structure"`

	// The metadata of the configured audience model association within a collaboration.
	//
	// CollaborationConfiguredAudienceModelAssociationSummaries is a required field
	CollaborationConfiguredAudienceModelAssociationSummaries []*CollaborationConfiguredAudienceModelAssociationSummary `locationName:"collaborationConfiguredAudienceModelAssociationSummaries" type:"list" required:"true"`

	// The pagination token that's used to fetch the next set of results.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCollaborationConfiguredAudienceModelAssociationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCollaborationConfiguredAudienceModelAssociationsOutput) GoString() string {
	return s.String()
}

// SetCollaborationConfiguredAudienceModelAssociationSummaries sets the CollaborationConfiguredAudienceModelAssociationSummaries field's value.
func (s *ListCollaborationConfiguredAudienceModelAssociationsOutput) SetCollaborationConfiguredAudienceModelAssociationSummaries(v []*CollaborationConfiguredAudienceModelAssociationSummary) *ListCollaborationConfiguredAudienceModelAssociationsOutput {
	s.CollaborationConfiguredAudienceModelAssociationSummaries = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListCollaborationConfiguredAudienceModelAssociationsOutput) SetNextToken(v string) *ListCollaborationConfiguredAudienceModelAssociationsOutput {
	s.NextToken = &v
	return s
}

type ListCollaborationIdNamespaceAssociationsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The unique identifier of the collaboration that contains the ID namespace
	// associations that you want to retrieve.
	//
	// CollaborationIdentifier is a required field
	CollaborationIdentifier *string `location:"uri" locationName:"collaborationIdentifier" min:"36" type:"string" required:"true"`

	// The maximum size of the results that is returned per call. Service chooses
	// a default if it has not been set. Service may return a nextToken even if
	// the maximum results has not been met.>
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The pagination token that's used to fetch the next set of results.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCollaborationIdNamespaceAssociationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCollaborationIdNamespaceAssociationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListCollaborationIdNamespaceAssociationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListCollaborationIdNamespaceAssociationsInput"}
	if s.CollaborationIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("CollaborationIdentifier"))
	}
	if s.CollaborationIdentifier != nil && len(*s.CollaborationIdentifier) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("CollaborationIdentifier", 36))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCollaborationIdentifier sets the CollaborationIdentifier field's value.
func (s *ListCollaborationIdNamespaceAssociationsInput) SetCollaborationIdentifier(v string) *ListCollaborationIdNamespaceAssociationsInput {
	s.CollaborationIdentifier = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListCollaborationIdNamespaceAssociationsInput) SetMaxResults(v int64) *ListCollaborationIdNamespaceAssociationsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListCollaborationIdNamespaceAssociationsInput) SetNextToken(v string) *ListCollaborationIdNamespaceAssociationsInput {
	s.NextToken = &v
	return s
}

type ListCollaborationIdNamespaceAssociationsOutput struct {
	_ struct{} `type:"structure"`

	// The summary information of the collaboration ID namespace associations that
	// you requested.
	//
	// CollaborationIdNamespaceAssociationSummaries is a required field
	CollaborationIdNamespaceAssociationSummaries []*CollaborationIdNamespaceAssociationSummary `locationName:"collaborationIdNamespaceAssociationSummaries" type:"list" required:"true"`

	// The token value provided to access the next page of results.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCollaborationIdNamespaceAssociationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCollaborationIdNamespaceAssociationsOutput) GoString() string {
	return s.String()
}

// SetCollaborationIdNamespaceAssociationSummaries sets the CollaborationIdNamespaceAssociationSummaries field's value.
func (s *ListCollaborationIdNamespaceAssociationsOutput) SetCollaborationIdNamespaceAssociationSummaries(v []*CollaborationIdNamespaceAssociationSummary) *ListCollaborationIdNamespaceAssociationsOutput {
	s.CollaborationIdNamespaceAssociationSummaries = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListCollaborationIdNamespaceAssociationsOutput) SetNextToken(v string) *ListCollaborationIdNamespaceAssociationsOutput {
	s.NextToken = &v
	return s
}

type ListCollaborationPrivacyBudgetTemplatesInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// A unique identifier for one of your collaborations.
	//
	// CollaborationIdentifier is a required field
	CollaborationIdentifier *string `location:"uri" locationName:"collaborationIdentifier" min:"36" type:"string" required:"true"`

	// The maximum number of results that are returned for an API request call.
	// The service chooses a default number if you don't set one. The service might
	// return a `nextToken` even if the `maxResults` value has not been met.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The pagination token that's used to fetch the next set of results.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCollaborationPrivacyBudgetTemplatesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCollaborationPrivacyBudgetTemplatesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListCollaborationPrivacyBudgetTemplatesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListCollaborationPrivacyBudgetTemplatesInput"}
	if s.CollaborationIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("CollaborationIdentifier"))
	}
	if s.CollaborationIdentifier != nil && len(*s.CollaborationIdentifier) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("CollaborationIdentifier", 36))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCollaborationIdentifier sets the CollaborationIdentifier field's value.
func (s *ListCollaborationPrivacyBudgetTemplatesInput) SetCollaborationIdentifier(v string) *ListCollaborationPrivacyBudgetTemplatesInput {
	s.CollaborationIdentifier = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListCollaborationPrivacyBudgetTemplatesInput) SetMaxResults(v int64) *ListCollaborationPrivacyBudgetTemplatesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListCollaborationPrivacyBudgetTemplatesInput) SetNextToken(v string) *ListCollaborationPrivacyBudgetTemplatesInput {
	s.NextToken = &v
	return s
}

type ListCollaborationPrivacyBudgetTemplatesOutput struct {
	_ struct{} `type:"structure"`

	// An array that summarizes the collaboration privacy budget templates. The
	// summary includes collaboration information, creation information, the privacy
	// budget type.
	//
	// CollaborationPrivacyBudgetTemplateSummaries is a required field
	CollaborationPrivacyBudgetTemplateSummaries []*CollaborationPrivacyBudgetTemplateSummary `locationName:"collaborationPrivacyBudgetTemplateSummaries" type:"list" required:"true"`

	// The pagination token that's used to fetch the next set of results.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCollaborationPrivacyBudgetTemplatesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCollaborationPrivacyBudgetTemplatesOutput) GoString() string {
	return s.String()
}

// SetCollaborationPrivacyBudgetTemplateSummaries sets the CollaborationPrivacyBudgetTemplateSummaries field's value.
func (s *ListCollaborationPrivacyBudgetTemplatesOutput) SetCollaborationPrivacyBudgetTemplateSummaries(v []*CollaborationPrivacyBudgetTemplateSummary) *ListCollaborationPrivacyBudgetTemplatesOutput {
	s.CollaborationPrivacyBudgetTemplateSummaries = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListCollaborationPrivacyBudgetTemplatesOutput) SetNextToken(v string) *ListCollaborationPrivacyBudgetTemplatesOutput {
	s.NextToken = &v
	return s
}

type ListCollaborationPrivacyBudgetsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// A unique identifier for one of your collaborations.
	//
	// CollaborationIdentifier is a required field
	CollaborationIdentifier *string `location:"uri" locationName:"collaborationIdentifier" min:"36" type:"string" required:"true"`

	// The maximum number of results that are returned for an API request call.
	// The service chooses a default number if you don't set one. The service might
	// return a `nextToken` even if the `maxResults` value has not been met.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The pagination token that's used to fetch the next set of results.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`

	// Specifies the type of the privacy budget.
	//
	// PrivacyBudgetType is a required field
	PrivacyBudgetType *string `location:"querystring" locationName:"privacyBudgetType" type:"string" required:"true" enum:"PrivacyBudgetType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCollaborationPrivacyBudgetsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCollaborationPrivacyBudgetsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListCollaborationPrivacyBudgetsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListCollaborationPrivacyBudgetsInput"}
	if s.CollaborationIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("CollaborationIdentifier"))
	}
	if s.CollaborationIdentifier != nil && len(*s.CollaborationIdentifier) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("CollaborationIdentifier", 36))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.PrivacyBudgetType == nil {
		invalidParams.Add(request.NewErrParamRequired("PrivacyBudgetType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCollaborationIdentifier sets the CollaborationIdentifier field's value.
func (s *ListCollaborationPrivacyBudgetsInput) SetCollaborationIdentifier(v string) *ListCollaborationPrivacyBudgetsInput {
	s.CollaborationIdentifier = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListCollaborationPrivacyBudgetsInput) SetMaxResults(v int64) *ListCollaborationPrivacyBudgetsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListCollaborationPrivacyBudgetsInput) SetNextToken(v string) *ListCollaborationPrivacyBudgetsInput {
	s.NextToken = &v
	return s
}

// SetPrivacyBudgetType sets the PrivacyBudgetType field's value.
func (s *ListCollaborationPrivacyBudgetsInput) SetPrivacyBudgetType(v string) *ListCollaborationPrivacyBudgetsInput {
	s.PrivacyBudgetType = &v
	return s
}

type ListCollaborationPrivacyBudgetsOutput struct {
	_ struct{} `type:"structure"`

	// Summaries of the collaboration privacy budgets.
	//
	// CollaborationPrivacyBudgetSummaries is a required field
	CollaborationPrivacyBudgetSummaries []*CollaborationPrivacyBudgetSummary `locationName:"collaborationPrivacyBudgetSummaries" type:"list" required:"true"`

	// The pagination token that's used to fetch the next set of results.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCollaborationPrivacyBudgetsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCollaborationPrivacyBudgetsOutput) GoString() string {
	return s.String()
}

// SetCollaborationPrivacyBudgetSummaries sets the CollaborationPrivacyBudgetSummaries field's value.
func (s *ListCollaborationPrivacyBudgetsOutput) SetCollaborationPrivacyBudgetSummaries(v []*CollaborationPrivacyBudgetSummary) *ListCollaborationPrivacyBudgetsOutput {
	s.CollaborationPrivacyBudgetSummaries = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListCollaborationPrivacyBudgetsOutput) SetNextToken(v string) *ListCollaborationPrivacyBudgetsOutput {
	s.NextToken = &v
	return s
}

type ListCollaborationsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The maximum number of results that are returned for an API request call.
	// The service chooses a default number if you don't set one. The service might
	// return a `nextToken` even if the `maxResults` value has not been met.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The caller's status in a collaboration.
	MemberStatus *string `location:"querystring" locationName:"memberStatus" type:"string" enum:"FilterableMemberStatus"`

	// The pagination token that's used to fetch the next set of results.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCollaborationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCollaborationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListCollaborationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListCollaborationsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListCollaborationsInput) SetMaxResults(v int64) *ListCollaborationsInput {
	s.MaxResults = &v
	return s
}

// SetMemberStatus sets the MemberStatus field's value.
func (s *ListCollaborationsInput) SetMemberStatus(v string) *ListCollaborationsInput {
	s.MemberStatus = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListCollaborationsInput) SetNextToken(v string) *ListCollaborationsInput {
	s.NextToken = &v
	return s
}

type ListCollaborationsOutput struct {
	_ struct{} `type:"structure"`

	// The list of collaborations.
	//
	// CollaborationList is a required field
	CollaborationList []*CollaborationSummary `locationName:"collaborationList" type:"list" required:"true"`

	// The pagination token that's used to fetch the next set of results.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCollaborationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCollaborationsOutput) GoString() string {
	return s.String()
}

// SetCollaborationList sets the CollaborationList field's value.
func (s *ListCollaborationsOutput) SetCollaborationList(v []*CollaborationSummary) *ListCollaborationsOutput {
	s.CollaborationList = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListCollaborationsOutput) SetNextToken(v string) *ListCollaborationsOutput {
	s.NextToken = &v
	return s
}

type ListConfiguredAudienceModelAssociationsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The maximum number of results that are returned for an API request call.
	// The service chooses a default number if you don't set one. The service might
	// return a `nextToken` even if the `maxResults` value has not been met.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// A unique identifier for a membership that contains the configured audience
	// model associations that you want to retrieve.
	//
	// MembershipIdentifier is a required field
	MembershipIdentifier *string `location:"uri" locationName:"membershipIdentifier" min:"36" type:"string" required:"true"`

	// The pagination token that's used to fetch the next set of results.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListConfiguredAudienceModelAssociationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListConfiguredAudienceModelAssociationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListConfiguredAudienceModelAssociationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListConfiguredAudienceModelAssociationsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.MembershipIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("MembershipIdentifier"))
	}
	if s.MembershipIdentifier != nil && len(*s.MembershipIdentifier) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("MembershipIdentifier", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListConfiguredAudienceModelAssociationsInput) SetMaxResults(v int64) *ListConfiguredAudienceModelAssociationsInput {
	s.MaxResults = &v
	return s
}

// SetMembershipIdentifier sets the MembershipIdentifier field's value.
func (s *ListConfiguredAudienceModelAssociationsInput) SetMembershipIdentifier(v string) *ListConfiguredAudienceModelAssociationsInput {
	s.MembershipIdentifier = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListConfiguredAudienceModelAssociationsInput) SetNextToken(v string) *ListConfiguredAudienceModelAssociationsInput {
	s.NextToken = &v
	return s
}

type ListConfiguredAudienceModelAssociationsOutput struct {
	_ struct{} `type:"structure"`

	// Summaries of the configured audience model associations that you requested.
	//
	// ConfiguredAudienceModelAssociationSummaries is a required field
	ConfiguredAudienceModelAssociationSummaries []*ConfiguredAudienceModelAssociationSummary `locationName:"configuredAudienceModelAssociationSummaries" type:"list" required:"true"`

	// The token value provided to access the next page of results.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListConfiguredAudienceModelAssociationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListConfiguredAudienceModelAssociationsOutput) GoString() string {
	return s.String()
}

// SetConfiguredAudienceModelAssociationSummaries sets the ConfiguredAudienceModelAssociationSummaries field's value.
func (s *ListConfiguredAudienceModelAssociationsOutput) SetConfiguredAudienceModelAssociationSummaries(v []*ConfiguredAudienceModelAssociationSummary) *ListConfiguredAudienceModelAssociationsOutput {
	s.ConfiguredAudienceModelAssociationSummaries = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListConfiguredAudienceModelAssociationsOutput) SetNextToken(v string) *ListConfiguredAudienceModelAssociationsOutput {
	s.NextToken = &v
	return s
}

type ListConfiguredTableAssociationsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The maximum number of results that are returned for an API request call.
	// The service chooses a default number if you don't set one. The service might
	// return a `nextToken` even if the `maxResults` value has not been met.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// A unique identifier for the membership to list configured table associations
	// for. Currently accepts the membership ID.
	//
	// MembershipIdentifier is a required field
	MembershipIdentifier *string `location:"uri" locationName:"membershipIdentifier" min:"36" type:"string" required:"true"`

	// The pagination token that's used to fetch the next set of results.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListConfiguredTableAssociationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListConfiguredTableAssociationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListConfiguredTableAssociationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListConfiguredTableAssociationsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.MembershipIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("MembershipIdentifier"))
	}
	if s.MembershipIdentifier != nil && len(*s.MembershipIdentifier) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("MembershipIdentifier", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListConfiguredTableAssociationsInput) SetMaxResults(v int64) *ListConfiguredTableAssociationsInput {
	s.MaxResults = &v
	return s
}

// SetMembershipIdentifier sets the MembershipIdentifier field's value.
func (s *ListConfiguredTableAssociationsInput) SetMembershipIdentifier(v string) *ListConfiguredTableAssociationsInput {
	s.MembershipIdentifier = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListConfiguredTableAssociationsInput) SetNextToken(v string) *ListConfiguredTableAssociationsInput {
	s.NextToken = &v
	return s
}

type ListConfiguredTableAssociationsOutput struct {
	_ struct{} `type:"structure"`

	// The retrieved list of configured table associations.
	//
	// ConfiguredTableAssociationSummaries is a required field
	ConfiguredTableAssociationSummaries []*ConfiguredTableAssociationSummary `locationName:"configuredTableAssociationSummaries" type:"list" required:"true"`

	// The pagination token that's used to fetch the next set of results.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListConfiguredTableAssociationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListConfiguredTableAssociationsOutput) GoString() string {
	return s.String()
}

// SetConfiguredTableAssociationSummaries sets the ConfiguredTableAssociationSummaries field's value.
func (s *ListConfiguredTableAssociationsOutput) SetConfiguredTableAssociationSummaries(v []*ConfiguredTableAssociationSummary) *ListConfiguredTableAssociationsOutput {
	s.ConfiguredTableAssociationSummaries = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListConfiguredTableAssociationsOutput) SetNextToken(v string) *ListConfiguredTableAssociationsOutput {
	s.NextToken = &v
	return s
}

type ListConfiguredTablesInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The maximum number of results that are returned for an API request call.
	// The service chooses a default number if you don't set one. The service might
	// return a `nextToken` even if the `maxResults` value has not been met.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The pagination token that's used to fetch the next set of results.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListConfiguredTablesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListConfiguredTablesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListConfiguredTablesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListConfiguredTablesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListConfiguredTablesInput) SetMaxResults(v int64) *ListConfiguredTablesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListConfiguredTablesInput) SetNextToken(v string) *ListConfiguredTablesInput {
	s.NextToken = &v
	return s
}

type ListConfiguredTablesOutput struct {
	_ struct{} `type:"structure"`

	// The configured tables listed by the request.
	//
	// ConfiguredTableSummaries is a required field
	ConfiguredTableSummaries []*ConfiguredTableSummary `locationName:"configuredTableSummaries" type:"list" required:"true"`

	// The pagination token that's used to fetch the next set of results.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListConfiguredTablesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListConfiguredTablesOutput) GoString() string {
	return s.String()
}

// SetConfiguredTableSummaries sets the ConfiguredTableSummaries field's value.
func (s *ListConfiguredTablesOutput) SetConfiguredTableSummaries(v []*ConfiguredTableSummary) *ListConfiguredTablesOutput {
	s.ConfiguredTableSummaries = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListConfiguredTablesOutput) SetNextToken(v string) *ListConfiguredTablesOutput {
	s.NextToken = &v
	return s
}

type ListIdMappingTablesInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The maximum size of the results that is returned per call. Service chooses
	// a default if it has not been set. Service may return a nextToken even if
	// the maximum results has not been met.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The unique identifier of the membership that contains the ID mapping tables
	// that you want to view.
	//
	// MembershipIdentifier is a required field
	MembershipIdentifier *string `location:"uri" locationName:"membershipIdentifier" min:"36" type:"string" required:"true"`

	// The pagination token that's used to fetch the next set of results.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListIdMappingTablesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListIdMappingTablesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListIdMappingTablesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListIdMappingTablesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.MembershipIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("MembershipIdentifier"))
	}
	if s.MembershipIdentifier != nil && len(*s.MembershipIdentifier) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("MembershipIdentifier", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListIdMappingTablesInput) SetMaxResults(v int64) *ListIdMappingTablesInput {
	s.MaxResults = &v
	return s
}

// SetMembershipIdentifier sets the MembershipIdentifier field's value.
func (s *ListIdMappingTablesInput) SetMembershipIdentifier(v string) *ListIdMappingTablesInput {
	s.MembershipIdentifier = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListIdMappingTablesInput) SetNextToken(v string) *ListIdMappingTablesInput {
	s.NextToken = &v
	return s
}

type ListIdMappingTablesOutput struct {
	_ struct{} `type:"structure"`

	// The summary information of the ID mapping tables that you requested.
	//
	// IdMappingTableSummaries is a required field
	IdMappingTableSummaries []*IdMappingTableSummary `locationName:"idMappingTableSummaries" type:"list" required:"true"`

	// The token value provided to access the next page of results.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListIdMappingTablesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListIdMappingTablesOutput) GoString() string {
	return s.String()
}

// SetIdMappingTableSummaries sets the IdMappingTableSummaries field's value.
func (s *ListIdMappingTablesOutput) SetIdMappingTableSummaries(v []*IdMappingTableSummary) *ListIdMappingTablesOutput {
	s.IdMappingTableSummaries = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListIdMappingTablesOutput) SetNextToken(v string) *ListIdMappingTablesOutput {
	s.NextToken = &v
	return s
}

type ListIdNamespaceAssociationsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The maximum size of the results that is returned per call. Service chooses
	// a default if it has not been set. Service may return a nextToken even if
	// the maximum results has not been met.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The unique identifier of the membership that contains the ID namespace association
	// that you want to view.
	//
	// MembershipIdentifier is a required field
	MembershipIdentifier *string `location:"uri" locationName:"membershipIdentifier" min:"36" type:"string" required:"true"`

	// The pagination token that's used to fetch the next set of results.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListIdNamespaceAssociationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListIdNamespaceAssociationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListIdNamespaceAssociationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListIdNamespaceAssociationsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.MembershipIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("MembershipIdentifier"))
	}
	if s.MembershipIdentifier != nil && len(*s.MembershipIdentifier) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("MembershipIdentifier", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListIdNamespaceAssociationsInput) SetMaxResults(v int64) *ListIdNamespaceAssociationsInput {
	s.MaxResults = &v
	return s
}

// SetMembershipIdentifier sets the MembershipIdentifier field's value.
func (s *ListIdNamespaceAssociationsInput) SetMembershipIdentifier(v string) *ListIdNamespaceAssociationsInput {
	s.MembershipIdentifier = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListIdNamespaceAssociationsInput) SetNextToken(v string) *ListIdNamespaceAssociationsInput {
	s.NextToken = &v
	return s
}

type ListIdNamespaceAssociationsOutput struct {
	_ struct{} `type:"structure"`

	// The summary information of the ID namespace associations that you requested.
	//
	// IdNamespaceAssociationSummaries is a required field
	IdNamespaceAssociationSummaries []*IdNamespaceAssociationSummary `locationName:"idNamespaceAssociationSummaries" type:"list" required:"true"`

	// The token value provided to access the next page of results.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListIdNamespaceAssociationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListIdNamespaceAssociationsOutput) GoString() string {
	return s.String()
}

// SetIdNamespaceAssociationSummaries sets the IdNamespaceAssociationSummaries field's value.
func (s *ListIdNamespaceAssociationsOutput) SetIdNamespaceAssociationSummaries(v []*IdNamespaceAssociationSummary) *ListIdNamespaceAssociationsOutput {
	s.IdNamespaceAssociationSummaries = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListIdNamespaceAssociationsOutput) SetNextToken(v string) *ListIdNamespaceAssociationsOutput {
	s.NextToken = &v
	return s
}

type ListMembersInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The identifier of the collaboration in which the members are listed.
	//
	// CollaborationIdentifier is a required field
	CollaborationIdentifier *string `location:"uri" locationName:"collaborationIdentifier" min:"36" type:"string" required:"true"`

	// The maximum number of results that are returned for an API request call.
	// The service chooses a default number if you don't set one. The service might
	// return a `nextToken` even if the `maxResults` value has not been met.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The pagination token that's used to fetch the next set of results.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListMembersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListMembersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListMembersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListMembersInput"}
	if s.CollaborationIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("CollaborationIdentifier"))
	}
	if s.CollaborationIdentifier != nil && len(*s.CollaborationIdentifier) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("CollaborationIdentifier", 36))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCollaborationIdentifier sets the CollaborationIdentifier field's value.
func (s *ListMembersInput) SetCollaborationIdentifier(v string) *ListMembersInput {
	s.CollaborationIdentifier = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListMembersInput) SetMaxResults(v int64) *ListMembersInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListMembersInput) SetNextToken(v string) *ListMembersInput {
	s.NextToken = &v
	return s
}

type ListMembersOutput struct {
	_ struct{} `type:"structure"`

	// The list of members returned by the ListMembers operation.
	//
	// MemberSummaries is a required field
	MemberSummaries []*MemberSummary `locationName:"memberSummaries" type:"list" required:"true"`

	// The pagination token that's used to fetch the next set of results.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListMembersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListMembersOutput) GoString() string {
	return s.String()
}

// SetMemberSummaries sets the MemberSummaries field's value.
func (s *ListMembersOutput) SetMemberSummaries(v []*MemberSummary) *ListMembersOutput {
	s.MemberSummaries = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListMembersOutput) SetNextToken(v string) *ListMembersOutput {
	s.NextToken = &v
	return s
}

type ListMembershipsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The maximum number of results that are returned for an API request call.
	// The service chooses a default number if you don't set one. The service might
	// return a `nextToken` even if the `maxResults` value has not been met.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The pagination token that's used to fetch the next set of results.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`

	// A filter which will return only memberships in the specified status.
	Status *string `location:"querystring" locationName:"status" type:"string" enum:"MembershipStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListMembershipsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListMembershipsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListMembershipsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListMembershipsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListMembershipsInput) SetMaxResults(v int64) *ListMembershipsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListMembershipsInput) SetNextToken(v string) *ListMembershipsInput {
	s.NextToken = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ListMembershipsInput) SetStatus(v string) *ListMembershipsInput {
	s.Status = &v
	return s
}

type ListMembershipsOutput struct {
	_ struct{} `type:"structure"`

	// The list of memberships returned from the ListMemberships operation.
	//
	// MembershipSummaries is a required field
	MembershipSummaries []*MembershipSummary `locationName:"membershipSummaries" type:"list" required:"true"`

	// The pagination token that's used to fetch the next set of results.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListMembershipsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListMembershipsOutput) GoString() string {
	return s.String()
}

// SetMembershipSummaries sets the MembershipSummaries field's value.
func (s *ListMembershipsOutput) SetMembershipSummaries(v []*MembershipSummary) *ListMembershipsOutput {
	s.MembershipSummaries = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListMembershipsOutput) SetNextToken(v string) *ListMembershipsOutput {
	s.NextToken = &v
	return s
}

type ListPrivacyBudgetTemplatesInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The maximum number of results that are returned for an API request call.
	// The service chooses a default number if you don't set one. The service might
	// return a `nextToken` even if the `maxResults` value has not been met.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// A unique identifier for one of your memberships for a collaboration. The
	// privacy budget templates are retrieved from the collaboration that this membership
	// belongs to. Accepts a membership ID.
	//
	// MembershipIdentifier is a required field
	MembershipIdentifier *string `location:"uri" locationName:"membershipIdentifier" min:"36" type:"string" required:"true"`

	// The pagination token that's used to fetch the next set of results.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPrivacyBudgetTemplatesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPrivacyBudgetTemplatesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListPrivacyBudgetTemplatesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListPrivacyBudgetTemplatesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.MembershipIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("MembershipIdentifier"))
	}
	if s.MembershipIdentifier != nil && len(*s.MembershipIdentifier) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("MembershipIdentifier", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListPrivacyBudgetTemplatesInput) SetMaxResults(v int64) *ListPrivacyBudgetTemplatesInput {
	s.MaxResults = &v
	return s
}

// SetMembershipIdentifier sets the MembershipIdentifier field's value.
func (s *ListPrivacyBudgetTemplatesInput) SetMembershipIdentifier(v string) *ListPrivacyBudgetTemplatesInput {
	s.MembershipIdentifier = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListPrivacyBudgetTemplatesInput) SetNextToken(v string) *ListPrivacyBudgetTemplatesInput {
	s.NextToken = &v
	return s
}

type ListPrivacyBudgetTemplatesOutput struct {
	_ struct{} `type:"structure"`

	// The pagination token that's used to fetch the next set of results.
	NextToken *string `locationName:"nextToken" type:"string"`

	// An array that summarizes the privacy budget templates. The summary includes
	// collaboration information, creation information, and privacy budget type.
	//
	// PrivacyBudgetTemplateSummaries is a required field
	PrivacyBudgetTemplateSummaries []*PrivacyBudgetTemplateSummary `locationName:"privacyBudgetTemplateSummaries" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPrivacyBudgetTemplatesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPrivacyBudgetTemplatesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListPrivacyBudgetTemplatesOutput) SetNextToken(v string) *ListPrivacyBudgetTemplatesOutput {
	s.NextToken = &v
	return s
}

// SetPrivacyBudgetTemplateSummaries sets the PrivacyBudgetTemplateSummaries field's value.
func (s *ListPrivacyBudgetTemplatesOutput) SetPrivacyBudgetTemplateSummaries(v []*PrivacyBudgetTemplateSummary) *ListPrivacyBudgetTemplatesOutput {
	s.PrivacyBudgetTemplateSummaries = v
	return s
}

type ListPrivacyBudgetsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The maximum number of results that are returned for an API request call.
	// The service chooses a default number if you don't set one. The service might
	// return a `nextToken` even if the `maxResults` value has not been met.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// A unique identifier for one of your memberships for a collaboration. The
	// privacy budget is retrieved from the collaboration that this membership belongs
	// to. Accepts a membership ID.
	//
	// MembershipIdentifier is a required field
	MembershipIdentifier *string `location:"uri" locationName:"membershipIdentifier" min:"36" type:"string" required:"true"`

	// The pagination token that's used to fetch the next set of results.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`

	// The privacy budget type.
	//
	// PrivacyBudgetType is a required field
	PrivacyBudgetType *string `location:"querystring" locationName:"privacyBudgetType" type:"string" required:"true" enum:"PrivacyBudgetType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPrivacyBudgetsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPrivacyBudgetsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListPrivacyBudgetsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListPrivacyBudgetsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.MembershipIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("MembershipIdentifier"))
	}
	if s.MembershipIdentifier != nil && len(*s.MembershipIdentifier) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("MembershipIdentifier", 36))
	}
	if s.PrivacyBudgetType == nil {
		invalidParams.Add(request.NewErrParamRequired("PrivacyBudgetType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListPrivacyBudgetsInput) SetMaxResults(v int64) *ListPrivacyBudgetsInput {
	s.MaxResults = &v
	return s
}

// SetMembershipIdentifier sets the MembershipIdentifier field's value.
func (s *ListPrivacyBudgetsInput) SetMembershipIdentifier(v string) *ListPrivacyBudgetsInput {
	s.MembershipIdentifier = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListPrivacyBudgetsInput) SetNextToken(v string) *ListPrivacyBudgetsInput {
	s.NextToken = &v
	return s
}

// SetPrivacyBudgetType sets the PrivacyBudgetType field's value.
func (s *ListPrivacyBudgetsInput) SetPrivacyBudgetType(v string) *ListPrivacyBudgetsInput {
	s.PrivacyBudgetType = &v
	return s
}

type ListPrivacyBudgetsOutput struct {
	_ struct{} `type:"structure"`

	// The pagination token that's used to fetch the next set of results.
	NextToken *string `locationName:"nextToken" type:"string"`

	// An array that summarizes the privacy budgets. The summary includes collaboration
	// information, membership information, privacy budget template information,
	// and privacy budget details.
	//
	// PrivacyBudgetSummaries is a required field
	PrivacyBudgetSummaries []*PrivacyBudgetSummary `locationName:"privacyBudgetSummaries" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPrivacyBudgetsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPrivacyBudgetsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListPrivacyBudgetsOutput) SetNextToken(v string) *ListPrivacyBudgetsOutput {
	s.NextToken = &v
	return s
}

// SetPrivacyBudgetSummaries sets the PrivacyBudgetSummaries field's value.
func (s *ListPrivacyBudgetsOutput) SetPrivacyBudgetSummaries(v []*PrivacyBudgetSummary) *ListPrivacyBudgetsOutput {
	s.PrivacyBudgetSummaries = v
	return s
}

type ListProtectedQueriesInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The maximum number of results that are returned for an API request call.
	// The service chooses a default number if you don't set one. The service might
	// return a `nextToken` even if the `maxResults` value has not been met.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The identifier for the membership in the collaboration.
	//
	// MembershipIdentifier is a required field
	MembershipIdentifier *string `location:"uri" locationName:"membershipIdentifier" min:"36" type:"string" required:"true"`

	// The pagination token that's used to fetch the next set of results.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`

	// A filter on the status of the protected query.
	Status *string `location:"querystring" locationName:"status" type:"string" enum:"ProtectedQueryStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListProtectedQueriesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListProtectedQueriesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListProtectedQueriesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListProtectedQueriesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.MembershipIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("MembershipIdentifier"))
	}
	if s.MembershipIdentifier != nil && len(*s.MembershipIdentifier) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("MembershipIdentifier", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListProtectedQueriesInput) SetMaxResults(v int64) *ListProtectedQueriesInput {
	s.MaxResults = &v
	return s
}

// SetMembershipIdentifier sets the MembershipIdentifier field's value.
func (s *ListProtectedQueriesInput) SetMembershipIdentifier(v string) *ListProtectedQueriesInput {
	s.MembershipIdentifier = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListProtectedQueriesInput) SetNextToken(v string) *ListProtectedQueriesInput {
	s.NextToken = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ListProtectedQueriesInput) SetStatus(v string) *ListProtectedQueriesInput {
	s.Status = &v
	return s
}

type ListProtectedQueriesOutput struct {
	_ struct{} `type:"structure"`

	// The pagination token that's used to fetch the next set of results.
	NextToken *string `locationName:"nextToken" type:"string"`

	// A list of protected queries.
	//
	// ProtectedQueries is a required field
	ProtectedQueries []*ProtectedQuerySummary `locationName:"protectedQueries" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListProtectedQueriesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListProtectedQueriesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListProtectedQueriesOutput) SetNextToken(v string) *ListProtectedQueriesOutput {
	s.NextToken = &v
	return s
}

// SetProtectedQueries sets the ProtectedQueries field's value.
func (s *ListProtectedQueriesOutput) SetProtectedQueries(v []*ProtectedQuerySummary) *ListProtectedQueriesOutput {
	s.ProtectedQueries = v
	return s
}

type ListSchemasInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// A unique identifier for the collaboration that the schema belongs to. Currently
	// accepts a collaboration ID.
	//
	// CollaborationIdentifier is a required field
	CollaborationIdentifier *string `location:"uri" locationName:"collaborationIdentifier" min:"36" type:"string" required:"true"`

	// The maximum number of results that are returned for an API request call.
	// The service chooses a default number if you don't set one. The service might
	// return a `nextToken` even if the `maxResults` value has not been met.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The pagination token that's used to fetch the next set of results.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`

	// If present, filter schemas by schema type.
	SchemaType *string `location:"querystring" locationName:"schemaType" type:"string" enum:"SchemaType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSchemasInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSchemasInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListSchemasInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListSchemasInput"}
	if s.CollaborationIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("CollaborationIdentifier"))
	}
	if s.CollaborationIdentifier != nil && len(*s.CollaborationIdentifier) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("CollaborationIdentifier", 36))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCollaborationIdentifier sets the CollaborationIdentifier field's value.
func (s *ListSchemasInput) SetCollaborationIdentifier(v string) *ListSchemasInput {
	s.CollaborationIdentifier = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListSchemasInput) SetMaxResults(v int64) *ListSchemasInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListSchemasInput) SetNextToken(v string) *ListSchemasInput {
	s.NextToken = &v
	return s
}

// SetSchemaType sets the SchemaType field's value.
func (s *ListSchemasInput) SetSchemaType(v string) *ListSchemasInput {
	s.SchemaType = &v
	return s
}

type ListSchemasOutput struct {
	_ struct{} `type:"structure"`

	// The pagination token that's used to fetch the next set of results.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The retrieved list of schemas.
	//
	// SchemaSummaries is a required field
	SchemaSummaries []*SchemaSummary `locationName:"schemaSummaries" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSchemasOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSchemasOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListSchemasOutput) SetNextToken(v string) *ListSchemasOutput {
	s.NextToken = &v
	return s
}

// SetSchemaSummaries sets the SchemaSummaries field's value.
func (s *ListSchemasOutput) SetSchemaSummaries(v []*SchemaSummary) *ListSchemasOutput {
	s.SchemaSummaries = v
	return s
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The Amazon Resource Name (ARN) associated with the resource you want to list
	// tags on.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ListTagsForResourceInput) SetResourceArn(v string) *ListTagsForResourceInput {
	s.ResourceArn = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// A map of objects specifying each key name and value.
	//
	// Tags is a required field
	Tags map[string]*string `locationName:"tags" type:"map" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v map[string]*string) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

// Basic metadata used to construct a new member.
type MemberSpecification struct {
	_ struct{} `type:"structure"`

	// The identifier used to reference members of the collaboration. Currently
	// only supports Amazon Web Services account ID.
	//
	// AccountId is a required field
	AccountId *string `locationName:"accountId" min:"12" type:"string" required:"true"`

	// The member's display name.
	//
	// DisplayName is a required field
	DisplayName *string `locationName:"displayName" min:"1" type:"string" required:"true"`

	// The abilities granted to the collaboration member.
	//
	// MemberAbilities is a required field
	MemberAbilities []*string `locationName:"memberAbilities" type:"list" required:"true" enum:"MemberAbility"`

	// The collaboration member's payment responsibilities set by the collaboration
	// creator.
	//
	// If the collaboration creator hasn't speciﬁed anyone as the member paying
	// for query compute costs, then the member who can query is the default payer.
	PaymentConfiguration *PaymentConfiguration `locationName:"paymentConfiguration" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MemberSpecification) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MemberSpecification) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MemberSpecification) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "MemberSpecification"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 12))
	}
	if s.DisplayName == nil {
		invalidParams.Add(request.NewErrParamRequired("DisplayName"))
	}
	if s.DisplayName != nil && len(*s.DisplayName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DisplayName", 1))
	}
	if s.MemberAbilities == nil {
		invalidParams.Add(request.NewErrParamRequired("MemberAbilities"))
	}
	if s.PaymentConfiguration != nil {
		if err := s.PaymentConfiguration.Validate(); err != nil {
			invalidParams.AddNested("PaymentConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *MemberSpecification) SetAccountId(v string) *MemberSpecification {
	s.AccountId = &v
	return s
}

// SetDisplayName sets the DisplayName field's value.
func (s *MemberSpecification) SetDisplayName(v string) *MemberSpecification {
	s.DisplayName = &v
	return s
}

// SetMemberAbilities sets the MemberAbilities field's value.
func (s *MemberSpecification) SetMemberAbilities(v []*string) *MemberSpecification {
	s.MemberAbilities = v
	return s
}

// SetPaymentConfiguration sets the PaymentConfiguration field's value.
func (s *MemberSpecification) SetPaymentConfiguration(v *PaymentConfiguration) *MemberSpecification {
	s.PaymentConfiguration = v
	return s
}

// The member object listed by the request.
type MemberSummary struct {
	_ struct{} `type:"structure"`

	// The abilities granted to the collaboration member.
	//
	// Abilities is a required field
	Abilities []*string `locationName:"abilities" type:"list" required:"true" enum:"MemberAbility"`

	// The identifier used to reference members of the collaboration. Currently
	// only supports Amazon Web Services account ID.
	//
	// AccountId is a required field
	AccountId *string `locationName:"accountId" min:"12" type:"string" required:"true"`

	// The time when the member was created.
	//
	// CreateTime is a required field
	CreateTime *time.Time `locationName:"createTime" type:"timestamp" required:"true"`

	// The member's display name.
	//
	// DisplayName is a required field
	DisplayName *string `locationName:"displayName" min:"1" type:"string" required:"true"`

	// The unique ARN for the member's associated membership, if present.
	MembershipArn *string `locationName:"membershipArn" type:"string"`

	// The unique ID for the member's associated membership, if present.
	MembershipId *string `locationName:"membershipId" min:"36" type:"string"`

	// The collaboration member's payment responsibilities set by the collaboration
	// creator.
	//
	// PaymentConfiguration is a required field
	PaymentConfiguration *PaymentConfiguration `locationName:"paymentConfiguration" type:"structure" required:"true"`

	// The status of the member.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"MemberStatus"`

	// The time the member metadata was last updated.
	//
	// UpdateTime is a required field
	UpdateTime *time.Time `locationName:"updateTime" type:"timestamp" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MemberSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MemberSummary) GoString() string {
	return s.String()
}

// SetAbilities sets the Abilities field's value.
func (s *MemberSummary) SetAbilities(v []*string) *MemberSummary {
	s.Abilities = v
	return s
}

// SetAccountId sets the AccountId field's value.
func (s *MemberSummary) SetAccountId(v string) *MemberSummary {
	s.AccountId = &v
	return s
}

// SetCreateTime sets the CreateTime field's value.
func (s *MemberSummary) SetCreateTime(v time.Time) *MemberSummary {
	s.CreateTime = &v
	return s
}

// SetDisplayName sets the DisplayName field's value.
func (s *MemberSummary) SetDisplayName(v string) *MemberSummary {
	s.DisplayName = &v
	return s
}

// SetMembershipArn sets the MembershipArn field's value.
func (s *MemberSummary) SetMembershipArn(v string) *MemberSummary {
	s.MembershipArn = &v
	return s
}

// SetMembershipId sets the MembershipId field's value.
func (s *MemberSummary) SetMembershipId(v string) *MemberSummary {
	s.MembershipId = &v
	return s
}

// SetPaymentConfiguration sets the PaymentConfiguration field's value.
func (s *MemberSummary) SetPaymentConfiguration(v *PaymentConfiguration) *MemberSummary {
	s.PaymentConfiguration = v
	return s
}

// SetStatus sets the Status field's value.
func (s *MemberSummary) SetStatus(v string) *MemberSummary {
	s.Status = &v
	return s
}

// SetUpdateTime sets the UpdateTime field's value.
func (s *MemberSummary) SetUpdateTime(v time.Time) *MemberSummary {
	s.UpdateTime = &v
	return s
}

// The membership object.
type Membership struct {
	_ struct{} `type:"structure"`

	// The unique ARN for the membership.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" type:"string" required:"true"`

	// The unique ARN for the membership's associated collaboration.
	//
	// CollaborationArn is a required field
	CollaborationArn *string `locationName:"collaborationArn" type:"string" required:"true"`

	// The identifier used to reference members of the collaboration. Currently
	// only supports Amazon Web Services account ID.
	//
	// CollaborationCreatorAccountId is a required field
	CollaborationCreatorAccountId *string `locationName:"collaborationCreatorAccountId" min:"12" type:"string" required:"true"`

	// The display name of the collaboration creator.
	//
	// CollaborationCreatorDisplayName is a required field
	CollaborationCreatorDisplayName *string `locationName:"collaborationCreatorDisplayName" min:"1" type:"string" required:"true"`

	// The unique ID for the membership's collaboration.
	//
	// CollaborationId is a required field
	CollaborationId *string `locationName:"collaborationId" min:"36" type:"string" required:"true"`

	// The name of the membership's collaboration.
	//
	// CollaborationName is a required field
	CollaborationName *string `locationName:"collaborationName" min:"1" type:"string" required:"true"`

	// The time when the membership was created.
	//
	// CreateTime is a required field
	CreateTime *time.Time `locationName:"createTime" type:"timestamp" required:"true"`

	// The default protected query result configuration as specified by the member
	// who can receive results.
	DefaultResultConfiguration *MembershipProtectedQueryResultConfiguration `locationName:"defaultResultConfiguration" type:"structure"`

	// The unique ID of the membership.
	//
	// Id is a required field
	Id *string `locationName:"id" min:"36" type:"string" required:"true"`

	// The abilities granted to the collaboration member.
	//
	// MemberAbilities is a required field
	MemberAbilities []*string `locationName:"memberAbilities" type:"list" required:"true" enum:"MemberAbility"`

	// The payment responsibilities accepted by the collaboration member.
	//
	// PaymentConfiguration is a required field
	PaymentConfiguration *MembershipPaymentConfiguration `locationName:"paymentConfiguration" type:"structure" required:"true"`

	// An indicator as to whether query logging has been enabled or disabled for
	// the membership.
	//
	// QueryLogStatus is a required field
	QueryLogStatus *string `locationName:"queryLogStatus" type:"string" required:"true" enum:"MembershipQueryLogStatus"`

	// The status of the membership.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"MembershipStatus"`

	// The time the membership metadata was last updated.
	//
	// UpdateTime is a required field
	UpdateTime *time.Time `locationName:"updateTime" type:"timestamp" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Membership) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Membership) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *Membership) SetArn(v string) *Membership {
	s.Arn = &v
	return s
}

// SetCollaborationArn sets the CollaborationArn field's value.
func (s *Membership) SetCollaborationArn(v string) *Membership {
	s.CollaborationArn = &v
	return s
}

// SetCollaborationCreatorAccountId sets the CollaborationCreatorAccountId field's value.
func (s *Membership) SetCollaborationCreatorAccountId(v string) *Membership {
	s.CollaborationCreatorAccountId = &v
	return s
}

// SetCollaborationCreatorDisplayName sets the CollaborationCreatorDisplayName field's value.
func (s *Membership) SetCollaborationCreatorDisplayName(v string) *Membership {
	s.CollaborationCreatorDisplayName = &v
	return s
}

// SetCollaborationId sets the CollaborationId field's value.
func (s *Membership) SetCollaborationId(v string) *Membership {
	s.CollaborationId = &v
	return s
}

// SetCollaborationName sets the CollaborationName field's value.
func (s *Membership) SetCollaborationName(v string) *Membership {
	s.CollaborationName = &v
	return s
}

// SetCreateTime sets the CreateTime field's value.
func (s *Membership) SetCreateTime(v time.Time) *Membership {
	s.CreateTime = &v
	return s
}

// SetDefaultResultConfiguration sets the DefaultResultConfiguration field's value.
func (s *Membership) SetDefaultResultConfiguration(v *MembershipProtectedQueryResultConfiguration) *Membership {
	s.DefaultResultConfiguration = v
	return s
}

// SetId sets the Id field's value.
func (s *Membership) SetId(v string) *Membership {
	s.Id = &v
	return s
}

// SetMemberAbilities sets the MemberAbilities field's value.
func (s *Membership) SetMemberAbilities(v []*string) *Membership {
	s.MemberAbilities = v
	return s
}

// SetPaymentConfiguration sets the PaymentConfiguration field's value.
func (s *Membership) SetPaymentConfiguration(v *MembershipPaymentConfiguration) *Membership {
	s.PaymentConfiguration = v
	return s
}

// SetQueryLogStatus sets the QueryLogStatus field's value.
func (s *Membership) SetQueryLogStatus(v string) *Membership {
	s.QueryLogStatus = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *Membership) SetStatus(v string) *Membership {
	s.Status = &v
	return s
}

// SetUpdateTime sets the UpdateTime field's value.
func (s *Membership) SetUpdateTime(v time.Time) *Membership {
	s.UpdateTime = &v
	return s
}

// An object representing the payment responsibilities accepted by the collaboration
// member.
type MembershipPaymentConfiguration struct {
	_ struct{} `type:"structure"`

	// The payment responsibilities accepted by the collaboration member for query
	// compute costs.
	//
	// QueryCompute is a required field
	QueryCompute *MembershipQueryComputePaymentConfig `locationName:"queryCompute" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MembershipPaymentConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MembershipPaymentConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MembershipPaymentConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "MembershipPaymentConfiguration"}
	if s.QueryCompute == nil {
		invalidParams.Add(request.NewErrParamRequired("QueryCompute"))
	}
	if s.QueryCompute != nil {
		if err := s.QueryCompute.Validate(); err != nil {
			invalidParams.AddNested("QueryCompute", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetQueryCompute sets the QueryCompute field's value.
func (s *MembershipPaymentConfiguration) SetQueryCompute(v *MembershipQueryComputePaymentConfig) *MembershipPaymentConfiguration {
	s.QueryCompute = v
	return s
}

// Contains configurations for protected query results.
type MembershipProtectedQueryOutputConfiguration struct {
	_ struct{} `type:"structure"`

	// Contains the configuration to write the query results to S3.
	S3 *ProtectedQueryS3OutputConfiguration `locationName:"s3" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MembershipProtectedQueryOutputConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MembershipProtectedQueryOutputConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MembershipProtectedQueryOutputConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "MembershipProtectedQueryOutputConfiguration"}
	if s.S3 != nil {
		if err := s.S3.Validate(); err != nil {
			invalidParams.AddNested("S3", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetS3 sets the S3 field's value.
func (s *MembershipProtectedQueryOutputConfiguration) SetS3(v *ProtectedQueryS3OutputConfiguration) *MembershipProtectedQueryOutputConfiguration {
	s.S3 = v
	return s
}

// Contains configurations for protected query results.
type MembershipProtectedQueryResultConfiguration struct {
	_ struct{} `type:"structure"`

	// Configuration for protected query results.
	//
	// OutputConfiguration is a required field
	OutputConfiguration *MembershipProtectedQueryOutputConfiguration `locationName:"outputConfiguration" type:"structure" required:"true"`

	// The unique ARN for an IAM role that is used by Clean Rooms to write protected
	// query results to the result location, given by the member who can receive
	// results.
	RoleArn *string `locationName:"roleArn" min:"32" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MembershipProtectedQueryResultConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MembershipProtectedQueryResultConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MembershipProtectedQueryResultConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "MembershipProtectedQueryResultConfiguration"}
	if s.OutputConfiguration == nil {
		invalidParams.Add(request.NewErrParamRequired("OutputConfiguration"))
	}
	if s.RoleArn != nil && len(*s.RoleArn) < 32 {
		invalidParams.Add(request.NewErrParamMinLen("RoleArn", 32))
	}
	if s.OutputConfiguration != nil {
		if err := s.OutputConfiguration.Validate(); err != nil {
			invalidParams.AddNested("OutputConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetOutputConfiguration sets the OutputConfiguration field's value.
func (s *MembershipProtectedQueryResultConfiguration) SetOutputConfiguration(v *MembershipProtectedQueryOutputConfiguration) *MembershipProtectedQueryResultConfiguration {
	s.OutputConfiguration = v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *MembershipProtectedQueryResultConfiguration) SetRoleArn(v string) *MembershipProtectedQueryResultConfiguration {
	s.RoleArn = &v
	return s
}

// An object representing the payment responsibilities accepted by the collaboration
// member for query compute costs.
type MembershipQueryComputePaymentConfig struct {
	_ struct{} `type:"structure"`

	// Indicates whether the collaboration member has accepted to pay for query
	// compute costs (TRUE) or has not accepted to pay for query compute costs (FALSE).
	//
	// If the collaboration creator has not specified anyone to pay for query compute
	// costs, then the member who can query is the default payer.
	//
	// An error message is returned for the following reasons:
	//
	//    * If you set the value to FALSE but you are responsible to pay for query
	//    compute costs.
	//
	//    * If you set the value to TRUE but you are not responsible to pay for
	//    query compute costs.
	//
	// IsResponsible is a required field
	IsResponsible *bool `locationName:"isResponsible" type:"boolean" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MembershipQueryComputePaymentConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MembershipQueryComputePaymentConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MembershipQueryComputePaymentConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "MembershipQueryComputePaymentConfig"}
	if s.IsResponsible == nil {
		invalidParams.Add(request.NewErrParamRequired("IsResponsible"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIsResponsible sets the IsResponsible field's value.
func (s *MembershipQueryComputePaymentConfig) SetIsResponsible(v bool) *MembershipQueryComputePaymentConfig {
	s.IsResponsible = &v
	return s
}

// The membership object listed by the request.
type MembershipSummary struct {
	_ struct{} `type:"structure"`

	// The unique ARN for the membership.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" type:"string" required:"true"`

	// The unique ARN for the membership's associated collaboration.
	//
	// CollaborationArn is a required field
	CollaborationArn *string `locationName:"collaborationArn" type:"string" required:"true"`

	// The identifier of the Amazon Web Services principal that created the collaboration.
	// Currently only supports Amazon Web Services account ID.
	//
	// CollaborationCreatorAccountId is a required field
	CollaborationCreatorAccountId *string `locationName:"collaborationCreatorAccountId" min:"12" type:"string" required:"true"`

	// The display name of the collaboration creator.
	//
	// CollaborationCreatorDisplayName is a required field
	CollaborationCreatorDisplayName *string `locationName:"collaborationCreatorDisplayName" min:"1" type:"string" required:"true"`

	// The unique ID for the membership's collaboration.
	//
	// CollaborationId is a required field
	CollaborationId *string `locationName:"collaborationId" min:"36" type:"string" required:"true"`

	// The name for the membership's collaboration.
	//
	// CollaborationName is a required field
	CollaborationName *string `locationName:"collaborationName" min:"1" type:"string" required:"true"`

	// The time when the membership was created.
	//
	// CreateTime is a required field
	CreateTime *time.Time `locationName:"createTime" type:"timestamp" required:"true"`

	// The unique ID for the membership's collaboration.
	//
	// Id is a required field
	Id *string `locationName:"id" min:"36" type:"string" required:"true"`

	// The abilities granted to the collaboration member.
	//
	// MemberAbilities is a required field
	MemberAbilities []*string `locationName:"memberAbilities" type:"list" required:"true" enum:"MemberAbility"`

	// The payment responsibilities accepted by the collaboration member.
	//
	// PaymentConfiguration is a required field
	PaymentConfiguration *MembershipPaymentConfiguration `locationName:"paymentConfiguration" type:"structure" required:"true"`

	// The status of the membership.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"MembershipStatus"`

	// The time the membership metadata was last updated.
	//
	// UpdateTime is a required field
	UpdateTime *time.Time `locationName:"updateTime" type:"timestamp" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MembershipSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MembershipSummary) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *MembershipSummary) SetArn(v string) *MembershipSummary {
	s.Arn = &v
	return s
}

// SetCollaborationArn sets the CollaborationArn field's value.
func (s *MembershipSummary) SetCollaborationArn(v string) *MembershipSummary {
	s.CollaborationArn = &v
	return s
}

// SetCollaborationCreatorAccountId sets the CollaborationCreatorAccountId field's value.
func (s *MembershipSummary) SetCollaborationCreatorAccountId(v string) *MembershipSummary {
	s.CollaborationCreatorAccountId = &v
	return s
}

// SetCollaborationCreatorDisplayName sets the CollaborationCreatorDisplayName field's value.
func (s *MembershipSummary) SetCollaborationCreatorDisplayName(v string) *MembershipSummary {
	s.CollaborationCreatorDisplayName = &v
	return s
}

// SetCollaborationId sets the CollaborationId field's value.
func (s *MembershipSummary) SetCollaborationId(v string) *MembershipSummary {
	s.CollaborationId = &v
	return s
}

// SetCollaborationName sets the CollaborationName field's value.
func (s *MembershipSummary) SetCollaborationName(v string) *MembershipSummary {
	s.CollaborationName = &v
	return s
}

// SetCreateTime sets the CreateTime field's value.
func (s *MembershipSummary) SetCreateTime(v time.Time) *MembershipSummary {
	s.CreateTime = &v
	return s
}

// SetId sets the Id field's value.
func (s *MembershipSummary) SetId(v string) *MembershipSummary {
	s.Id = &v
	return s
}

// SetMemberAbilities sets the MemberAbilities field's value.
func (s *MembershipSummary) SetMemberAbilities(v []*string) *MembershipSummary {
	s.MemberAbilities = v
	return s
}

// SetPaymentConfiguration sets the PaymentConfiguration field's value.
func (s *MembershipSummary) SetPaymentConfiguration(v *MembershipPaymentConfiguration) *MembershipSummary {
	s.PaymentConfiguration = v
	return s
}

// SetStatus sets the Status field's value.
func (s *MembershipSummary) SetStatus(v string) *MembershipSummary {
	s.Status = &v
	return s
}

// SetUpdateTime sets the UpdateTime field's value.
func (s *MembershipSummary) SetUpdateTime(v time.Time) *MembershipSummary {
	s.UpdateTime = &v
	return s
}

// An object representing the collaboration member's payment responsibilities
// set by the collaboration creator.
type PaymentConfiguration struct {
	_ struct{} `type:"structure"`

	// The collaboration member's payment responsibilities set by the collaboration
	// creator for query compute costs.
	//
	// QueryCompute is a required field
	QueryCompute *QueryComputePaymentConfig `locationName:"queryCompute" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PaymentConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PaymentConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PaymentConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PaymentConfiguration"}
	if s.QueryCompute == nil {
		invalidParams.Add(request.NewErrParamRequired("QueryCompute"))
	}
	if s.QueryCompute != nil {
		if err := s.QueryCompute.Validate(); err != nil {
			invalidParams.AddNested("QueryCompute", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetQueryCompute sets the QueryCompute field's value.
func (s *PaymentConfiguration) SetQueryCompute(v *QueryComputePaymentConfig) *PaymentConfiguration {
	s.QueryCompute = v
	return s
}

type PopulateIdMappingTableInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The unique identifier of the ID mapping table that you want to populate.
	//
	// IdMappingTableIdentifier is a required field
	IdMappingTableIdentifier *string `location:"uri" locationName:"idMappingTableIdentifier" min:"36" type:"string" required:"true"`

	// The unique identifier of the membership that contains the ID mapping table
	// that you want to populate.
	//
	// MembershipIdentifier is a required field
	MembershipIdentifier *string `location:"uri" locationName:"membershipIdentifier" min:"36" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PopulateIdMappingTableInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PopulateIdMappingTableInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PopulateIdMappingTableInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PopulateIdMappingTableInput"}
	if s.IdMappingTableIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("IdMappingTableIdentifier"))
	}
	if s.IdMappingTableIdentifier != nil && len(*s.IdMappingTableIdentifier) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("IdMappingTableIdentifier", 36))
	}
	if s.MembershipIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("MembershipIdentifier"))
	}
	if s.MembershipIdentifier != nil && len(*s.MembershipIdentifier) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("MembershipIdentifier", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIdMappingTableIdentifier sets the IdMappingTableIdentifier field's value.
func (s *PopulateIdMappingTableInput) SetIdMappingTableIdentifier(v string) *PopulateIdMappingTableInput {
	s.IdMappingTableIdentifier = &v
	return s
}

// SetMembershipIdentifier sets the MembershipIdentifier field's value.
func (s *PopulateIdMappingTableInput) SetMembershipIdentifier(v string) *PopulateIdMappingTableInput {
	s.MembershipIdentifier = &v
	return s
}

type PopulateIdMappingTableOutput struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the mapping job that will populate the ID mapping
	// table.
	//
	// IdMappingJobId is a required field
	IdMappingJobId *string `locationName:"idMappingJobId" min:"36" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PopulateIdMappingTableOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PopulateIdMappingTableOutput) GoString() string {
	return s.String()
}

// SetIdMappingJobId sets the IdMappingJobId field's value.
func (s *PopulateIdMappingTableOutput) SetIdMappingJobId(v string) *PopulateIdMappingTableOutput {
	s.IdMappingJobId = &v
	return s
}

type PreviewPrivacyImpactInput struct {
	_ struct{} `type:"structure"`

	// A unique identifier for one of your memberships for a collaboration. Accepts
	// a membership ID.
	//
	// MembershipIdentifier is a required field
	MembershipIdentifier *string `location:"uri" locationName:"membershipIdentifier" min:"36" type:"string" required:"true"`

	// Specifies the desired epsilon and noise parameters to preview.
	//
	// Parameters is a required field
	Parameters *PreviewPrivacyImpactParametersInput_ `locationName:"parameters" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PreviewPrivacyImpactInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PreviewPrivacyImpactInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PreviewPrivacyImpactInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PreviewPrivacyImpactInput"}
	if s.MembershipIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("MembershipIdentifier"))
	}
	if s.MembershipIdentifier != nil && len(*s.MembershipIdentifier) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("MembershipIdentifier", 36))
	}
	if s.Parameters == nil {
		invalidParams.Add(request.NewErrParamRequired("Parameters"))
	}
	if s.Parameters != nil {
		if err := s.Parameters.Validate(); err != nil {
			invalidParams.AddNested("Parameters", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMembershipIdentifier sets the MembershipIdentifier field's value.
func (s *PreviewPrivacyImpactInput) SetMembershipIdentifier(v string) *PreviewPrivacyImpactInput {
	s.MembershipIdentifier = &v
	return s
}

// SetParameters sets the Parameters field's value.
func (s *PreviewPrivacyImpactInput) SetParameters(v *PreviewPrivacyImpactParametersInput_) *PreviewPrivacyImpactInput {
	s.Parameters = v
	return s
}

type PreviewPrivacyImpactOutput struct {
	_ struct{} `type:"structure"`

	// An estimate of the number of aggregation functions that the member who can
	// query can run given the epsilon and noise parameters. This does not change
	// the privacy budget.
	//
	// PrivacyImpact is a required field
	PrivacyImpact *PrivacyImpact `locationName:"privacyImpact" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PreviewPrivacyImpactOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PreviewPrivacyImpactOutput) GoString() string {
	return s.String()
}

// SetPrivacyImpact sets the PrivacyImpact field's value.
func (s *PreviewPrivacyImpactOutput) SetPrivacyImpact(v *PrivacyImpact) *PreviewPrivacyImpactOutput {
	s.PrivacyImpact = v
	return s
}

// Specifies the updated epsilon and noise parameters to preview. The preview
// allows you to see how the maximum number of each type of aggregation function
// would change with the new parameters.
type PreviewPrivacyImpactParametersInput_ struct {
	_ struct{} `type:"structure"`

	// An array that specifies the epsilon and noise parameters.
	DifferentialPrivacy *DifferentialPrivacyPreviewParametersInput_ `locationName:"differentialPrivacy" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PreviewPrivacyImpactParametersInput_) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PreviewPrivacyImpactParametersInput_) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PreviewPrivacyImpactParametersInput_) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PreviewPrivacyImpactParametersInput_"}
	if s.DifferentialPrivacy != nil {
		if err := s.DifferentialPrivacy.Validate(); err != nil {
			invalidParams.AddNested("DifferentialPrivacy", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDifferentialPrivacy sets the DifferentialPrivacy field's value.
func (s *PreviewPrivacyImpactParametersInput_) SetDifferentialPrivacy(v *DifferentialPrivacyPreviewParametersInput_) *PreviewPrivacyImpactParametersInput_ {
	s.DifferentialPrivacy = v
	return s
}

// The epsilon parameter value and number of each aggregation function that
// you can perform.
type PrivacyBudget struct {
	_ struct{} `type:"structure"`

	// An object that specifies the epsilon parameter and the utility in terms of
	// total aggregations, as well as the remaining aggregations available.
	DifferentialPrivacy *DifferentialPrivacyPrivacyBudget `locationName:"differentialPrivacy" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PrivacyBudget) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PrivacyBudget) GoString() string {
	return s.String()
}

// SetDifferentialPrivacy sets the DifferentialPrivacy field's value.
func (s *PrivacyBudget) SetDifferentialPrivacy(v *DifferentialPrivacyPrivacyBudget) *PrivacyBudget {
	s.DifferentialPrivacy = v
	return s
}

// An array that summaries the specified privacy budget. This summary includes
// collaboration information, creation information, membership information,
// and privacy budget information.
type PrivacyBudgetSummary struct {
	_ struct{} `type:"structure"`

	// The provided privacy budget.
	//
	// Budget is a required field
	Budget *PrivacyBudget `locationName:"budget" type:"structure" required:"true"`

	// The ARN of the collaboration that contains this privacy budget.
	//
	// CollaborationArn is a required field
	CollaborationArn *string `locationName:"collaborationArn" type:"string" required:"true"`

	// The unique identifier of the collaboration that contains this privacy budget.
	//
	// CollaborationId is a required field
	CollaborationId *string `locationName:"collaborationId" min:"36" type:"string" required:"true"`

	// The time at which the privacy budget was created.
	//
	// CreateTime is a required field
	CreateTime *time.Time `locationName:"createTime" type:"timestamp" required:"true"`

	// The unique identifier of the privacy budget.
	//
	// Id is a required field
	Id *string `locationName:"id" min:"36" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the member who created the privacy budget
	// summary.
	//
	// MembershipArn is a required field
	MembershipArn *string `locationName:"membershipArn" type:"string" required:"true"`

	// The identifier for a membership resource.
	//
	// MembershipId is a required field
	MembershipId *string `locationName:"membershipId" min:"36" type:"string" required:"true"`

	// The ARN of the privacy budget template.
	//
	// PrivacyBudgetTemplateArn is a required field
	PrivacyBudgetTemplateArn *string `locationName:"privacyBudgetTemplateArn" type:"string" required:"true"`

	// The unique identifier of the privacy budget template.
	//
	// PrivacyBudgetTemplateId is a required field
	PrivacyBudgetTemplateId *string `locationName:"privacyBudgetTemplateId" min:"36" type:"string" required:"true"`

	// Specifies the type of the privacy budget.
	//
	// Type is a required field
	Type *string `locationName:"type" type:"string" required:"true" enum:"PrivacyBudgetType"`

	// The most recent time at which the privacy budget was updated.
	//
	// UpdateTime is a required field
	UpdateTime *time.Time `locationName:"updateTime" type:"timestamp" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PrivacyBudgetSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PrivacyBudgetSummary) GoString() string {
	return s.String()
}

// SetBudget sets the Budget field's value.
func (s *PrivacyBudgetSummary) SetBudget(v *PrivacyBudget) *PrivacyBudgetSummary {
	s.Budget = v
	return s
}

// SetCollaborationArn sets the CollaborationArn field's value.
func (s *PrivacyBudgetSummary) SetCollaborationArn(v string) *PrivacyBudgetSummary {
	s.CollaborationArn = &v
	return s
}

// SetCollaborationId sets the CollaborationId field's value.
func (s *PrivacyBudgetSummary) SetCollaborationId(v string) *PrivacyBudgetSummary {
	s.CollaborationId = &v
	return s
}

// SetCreateTime sets the CreateTime field's value.
func (s *PrivacyBudgetSummary) SetCreateTime(v time.Time) *PrivacyBudgetSummary {
	s.CreateTime = &v
	return s
}

// SetId sets the Id field's value.
func (s *PrivacyBudgetSummary) SetId(v string) *PrivacyBudgetSummary {
	s.Id = &v
	return s
}

// SetMembershipArn sets the MembershipArn field's value.
func (s *PrivacyBudgetSummary) SetMembershipArn(v string) *PrivacyBudgetSummary {
	s.MembershipArn = &v
	return s
}

// SetMembershipId sets the MembershipId field's value.
func (s *PrivacyBudgetSummary) SetMembershipId(v string) *PrivacyBudgetSummary {
	s.MembershipId = &v
	return s
}

// SetPrivacyBudgetTemplateArn sets the PrivacyBudgetTemplateArn field's value.
func (s *PrivacyBudgetSummary) SetPrivacyBudgetTemplateArn(v string) *PrivacyBudgetSummary {
	s.PrivacyBudgetTemplateArn = &v
	return s
}

// SetPrivacyBudgetTemplateId sets the PrivacyBudgetTemplateId field's value.
func (s *PrivacyBudgetSummary) SetPrivacyBudgetTemplateId(v string) *PrivacyBudgetSummary {
	s.PrivacyBudgetTemplateId = &v
	return s
}

// SetType sets the Type field's value.
func (s *PrivacyBudgetSummary) SetType(v string) *PrivacyBudgetSummary {
	s.Type = &v
	return s
}

// SetUpdateTime sets the UpdateTime field's value.
func (s *PrivacyBudgetSummary) SetUpdateTime(v time.Time) *PrivacyBudgetSummary {
	s.UpdateTime = &v
	return s
}

// An object that defines the privacy budget template.
type PrivacyBudgetTemplate struct {
	_ struct{} `type:"structure"`

	// The ARN of the privacy budget template.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" type:"string" required:"true"`

	// How often the privacy budget refreshes.
	//
	// If you plan to regularly bring new data into the collaboration, use CALENDAR_MONTH
	// to automatically get a new privacy budget for the collaboration every calendar
	// month. Choosing this option allows arbitrary amounts of information to be
	// revealed about rows of the data when repeatedly queried across refreshes.
	// Avoid choosing this if the same rows will be repeatedly queried between privacy
	// budget refreshes.
	//
	// AutoRefresh is a required field
	AutoRefresh *string `locationName:"autoRefresh" type:"string" required:"true" enum:"PrivacyBudgetTemplateAutoRefresh"`

	// The ARN of the collaboration that contains this privacy budget template.
	//
	// CollaborationArn is a required field
	CollaborationArn *string `locationName:"collaborationArn" type:"string" required:"true"`

	// The unique ID of the collaboration that contains this privacy budget template.
	//
	// CollaborationId is a required field
	CollaborationId *string `locationName:"collaborationId" min:"36" type:"string" required:"true"`

	// The time at which the privacy budget template was created.
	//
	// CreateTime is a required field
	CreateTime *time.Time `locationName:"createTime" type:"timestamp" required:"true"`

	// The unique identifier of the privacy budget template.
	//
	// Id is a required field
	Id *string `locationName:"id" min:"36" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the member who created the privacy budget
	// template.
	//
	// MembershipArn is a required field
	MembershipArn *string `locationName:"membershipArn" type:"string" required:"true"`

	// The identifier for a membership resource.
	//
	// MembershipId is a required field
	MembershipId *string `locationName:"membershipId" min:"36" type:"string" required:"true"`

	// Specifies the epsilon and noise parameters for the privacy budget template.
	//
	// Parameters is a required field
	Parameters *PrivacyBudgetTemplateParametersOutput_ `locationName:"parameters" type:"structure" required:"true"`

	// Specifies the type of the privacy budget template.
	//
	// PrivacyBudgetType is a required field
	PrivacyBudgetType *string `locationName:"privacyBudgetType" type:"string" required:"true" enum:"PrivacyBudgetType"`

	// The most recent time at which the privacy budget template was updated.
	//
	// UpdateTime is a required field
	UpdateTime *time.Time `locationName:"updateTime" type:"timestamp" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PrivacyBudgetTemplate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PrivacyBudgetTemplate) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *PrivacyBudgetTemplate) SetArn(v string) *PrivacyBudgetTemplate {
	s.Arn = &v
	return s
}

// SetAutoRefresh sets the AutoRefresh field's value.
func (s *PrivacyBudgetTemplate) SetAutoRefresh(v string) *PrivacyBudgetTemplate {
	s.AutoRefresh = &v
	return s
}

// SetCollaborationArn sets the CollaborationArn field's value.
func (s *PrivacyBudgetTemplate) SetCollaborationArn(v string) *PrivacyBudgetTemplate {
	s.CollaborationArn = &v
	return s
}

// SetCollaborationId sets the CollaborationId field's value.
func (s *PrivacyBudgetTemplate) SetCollaborationId(v string) *PrivacyBudgetTemplate {
	s.CollaborationId = &v
	return s
}

// SetCreateTime sets the CreateTime field's value.
func (s *PrivacyBudgetTemplate) SetCreateTime(v time.Time) *PrivacyBudgetTemplate {
	s.CreateTime = &v
	return s
}

// SetId sets the Id field's value.
func (s *PrivacyBudgetTemplate) SetId(v string) *PrivacyBudgetTemplate {
	s.Id = &v
	return s
}

// SetMembershipArn sets the MembershipArn field's value.
func (s *PrivacyBudgetTemplate) SetMembershipArn(v string) *PrivacyBudgetTemplate {
	s.MembershipArn = &v
	return s
}

// SetMembershipId sets the MembershipId field's value.
func (s *PrivacyBudgetTemplate) SetMembershipId(v string) *PrivacyBudgetTemplate {
	s.MembershipId = &v
	return s
}

// SetParameters sets the Parameters field's value.
func (s *PrivacyBudgetTemplate) SetParameters(v *PrivacyBudgetTemplateParametersOutput_) *PrivacyBudgetTemplate {
	s.Parameters = v
	return s
}

// SetPrivacyBudgetType sets the PrivacyBudgetType field's value.
func (s *PrivacyBudgetTemplate) SetPrivacyBudgetType(v string) *PrivacyBudgetTemplate {
	s.PrivacyBudgetType = &v
	return s
}

// SetUpdateTime sets the UpdateTime field's value.
func (s *PrivacyBudgetTemplate) SetUpdateTime(v time.Time) *PrivacyBudgetTemplate {
	s.UpdateTime = &v
	return s
}

// The epsilon and noise parameters that you want to use for the privacy budget
// template.
type PrivacyBudgetTemplateParametersInput_ struct {
	_ struct{} `type:"structure"`

	// An object that specifies the epsilon and noise parameters.
	DifferentialPrivacy *DifferentialPrivacyTemplateParametersInput_ `locationName:"differentialPrivacy" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PrivacyBudgetTemplateParametersInput_) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PrivacyBudgetTemplateParametersInput_) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PrivacyBudgetTemplateParametersInput_) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PrivacyBudgetTemplateParametersInput_"}
	if s.DifferentialPrivacy != nil {
		if err := s.DifferentialPrivacy.Validate(); err != nil {
			invalidParams.AddNested("DifferentialPrivacy", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDifferentialPrivacy sets the DifferentialPrivacy field's value.
func (s *PrivacyBudgetTemplateParametersInput_) SetDifferentialPrivacy(v *DifferentialPrivacyTemplateParametersInput_) *PrivacyBudgetTemplateParametersInput_ {
	s.DifferentialPrivacy = v
	return s
}

// The epsilon and noise parameters that were used in the privacy budget template.
type PrivacyBudgetTemplateParametersOutput_ struct {
	_ struct{} `type:"structure"`

	// The epsilon and noise parameters.
	DifferentialPrivacy *DifferentialPrivacyTemplateParametersOutput_ `locationName:"differentialPrivacy" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PrivacyBudgetTemplateParametersOutput_) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PrivacyBudgetTemplateParametersOutput_) GoString() string {
	return s.String()
}

// SetDifferentialPrivacy sets the DifferentialPrivacy field's value.
func (s *PrivacyBudgetTemplateParametersOutput_) SetDifferentialPrivacy(v *DifferentialPrivacyTemplateParametersOutput_) *PrivacyBudgetTemplateParametersOutput_ {
	s.DifferentialPrivacy = v
	return s
}

// A summary of the privacy budget template. The summary includes membership
// information, collaboration information, and creation information.
type PrivacyBudgetTemplateSummary struct {
	_ struct{} `type:"structure"`

	// The ARN of the privacy budget template.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" type:"string" required:"true"`

	// The ARN of the collaboration that contains this privacy budget template.
	//
	// CollaborationArn is a required field
	CollaborationArn *string `locationName:"collaborationArn" type:"string" required:"true"`

	// The unique ID of the collaboration that contains this privacy budget template.
	//
	// CollaborationId is a required field
	CollaborationId *string `locationName:"collaborationId" min:"36" type:"string" required:"true"`

	// The time at which the privacy budget template was created.
	//
	// CreateTime is a required field
	CreateTime *time.Time `locationName:"createTime" type:"timestamp" required:"true"`

	// The unique identifier of the privacy budget template.
	//
	// Id is a required field
	Id *string `locationName:"id" min:"36" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the member who created the privacy budget
	// template.
	//
	// MembershipArn is a required field
	MembershipArn *string `locationName:"membershipArn" type:"string" required:"true"`

	// The identifier for a membership resource.
	//
	// MembershipId is a required field
	MembershipId *string `locationName:"membershipId" min:"36" type:"string" required:"true"`

	// The type of the privacy budget template.
	//
	// PrivacyBudgetType is a required field
	PrivacyBudgetType *string `locationName:"privacyBudgetType" type:"string" required:"true" enum:"PrivacyBudgetType"`

	// The most recent time at which the privacy budget template was updated.
	//
	// UpdateTime is a required field
	UpdateTime *time.Time `locationName:"updateTime" type:"timestamp" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PrivacyBudgetTemplateSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PrivacyBudgetTemplateSummary) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *PrivacyBudgetTemplateSummary) SetArn(v string) *PrivacyBudgetTemplateSummary {
	s.Arn = &v
	return s
}

// SetCollaborationArn sets the CollaborationArn field's value.
func (s *PrivacyBudgetTemplateSummary) SetCollaborationArn(v string) *PrivacyBudgetTemplateSummary {
	s.CollaborationArn = &v
	return s
}

// SetCollaborationId sets the CollaborationId field's value.
func (s *PrivacyBudgetTemplateSummary) SetCollaborationId(v string) *PrivacyBudgetTemplateSummary {
	s.CollaborationId = &v
	return s
}

// SetCreateTime sets the CreateTime field's value.
func (s *PrivacyBudgetTemplateSummary) SetCreateTime(v time.Time) *PrivacyBudgetTemplateSummary {
	s.CreateTime = &v
	return s
}

// SetId sets the Id field's value.
func (s *PrivacyBudgetTemplateSummary) SetId(v string) *PrivacyBudgetTemplateSummary {
	s.Id = &v
	return s
}

// SetMembershipArn sets the MembershipArn field's value.
func (s *PrivacyBudgetTemplateSummary) SetMembershipArn(v string) *PrivacyBudgetTemplateSummary {
	s.MembershipArn = &v
	return s
}

// SetMembershipId sets the MembershipId field's value.
func (s *PrivacyBudgetTemplateSummary) SetMembershipId(v string) *PrivacyBudgetTemplateSummary {
	s.MembershipId = &v
	return s
}

// SetPrivacyBudgetType sets the PrivacyBudgetType field's value.
func (s *PrivacyBudgetTemplateSummary) SetPrivacyBudgetType(v string) *PrivacyBudgetTemplateSummary {
	s.PrivacyBudgetType = &v
	return s
}

// SetUpdateTime sets the UpdateTime field's value.
func (s *PrivacyBudgetTemplateSummary) SetUpdateTime(v time.Time) *PrivacyBudgetTemplateSummary {
	s.UpdateTime = &v
	return s
}

// The epsilon and noise parameters that you want to update in the privacy budget
// template.
type PrivacyBudgetTemplateUpdateParameters struct {
	_ struct{} `type:"structure"`

	// An object that specifies the new values for the epsilon and noise parameters.
	DifferentialPrivacy *DifferentialPrivacyTemplateUpdateParameters `locationName:"differentialPrivacy" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PrivacyBudgetTemplateUpdateParameters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PrivacyBudgetTemplateUpdateParameters) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PrivacyBudgetTemplateUpdateParameters) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PrivacyBudgetTemplateUpdateParameters"}
	if s.DifferentialPrivacy != nil {
		if err := s.DifferentialPrivacy.Validate(); err != nil {
			invalidParams.AddNested("DifferentialPrivacy", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDifferentialPrivacy sets the DifferentialPrivacy field's value.
func (s *PrivacyBudgetTemplateUpdateParameters) SetDifferentialPrivacy(v *DifferentialPrivacyTemplateUpdateParameters) *PrivacyBudgetTemplateUpdateParameters {
	s.DifferentialPrivacy = v
	return s
}

// Provides an estimate of the number of aggregation functions that the member
// who can query can run given the epsilon and noise parameters.
type PrivacyImpact struct {
	_ struct{} `type:"structure"`

	// An object that lists the number and type of aggregation functions you can
	// perform.
	DifferentialPrivacy *DifferentialPrivacyPrivacyImpact `locationName:"differentialPrivacy" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PrivacyImpact) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PrivacyImpact) GoString() string {
	return s.String()
}

// SetDifferentialPrivacy sets the DifferentialPrivacy field's value.
func (s *PrivacyImpact) SetDifferentialPrivacy(v *DifferentialPrivacyPrivacyImpact) *PrivacyImpact {
	s.DifferentialPrivacy = v
	return s
}

// The parameters for an Clean Rooms protected query.
type ProtectedQuery struct {
	_ struct{} `type:"structure"`

	// The time at which the protected query was created.
	//
	// CreateTime is a required field
	CreateTime *time.Time `locationName:"createTime" type:"timestamp" required:"true"`

	// The sensitivity parameters of the differential privacy results of the protected
	// query.
	DifferentialPrivacy *DifferentialPrivacyParameters `locationName:"differentialPrivacy" type:"structure"`

	// An error thrown by the protected query.
	Error *ProtectedQueryError `locationName:"error" type:"structure"`

	// The identifier for a protected query instance.
	//
	// Id is a required field
	Id *string `locationName:"id" min:"36" type:"string" required:"true"`

	// The ARN of the membership.
	//
	// MembershipArn is a required field
	MembershipArn *string `locationName:"membershipArn" type:"string" required:"true"`

	// The identifier for the membership.
	//
	// MembershipId is a required field
	MembershipId *string `locationName:"membershipId" min:"36" type:"string" required:"true"`

	// The result of the protected query.
	Result *ProtectedQueryResult `locationName:"result" type:"structure"`

	// Contains any details needed to write the query results.
	ResultConfiguration *ProtectedQueryResultConfiguration `locationName:"resultConfiguration" type:"structure"`

	// The protected query SQL parameters.
	//
	// SqlParameters is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by ProtectedQuery's
	// String and GoString methods.
	SqlParameters *ProtectedQuerySQLParameters `locationName:"sqlParameters" type:"structure" sensitive:"true"`

	// Statistics about protected query execution.
	Statistics *ProtectedQueryStatistics `locationName:"statistics" type:"structure"`

	// The status of the query.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"ProtectedQueryStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ProtectedQuery) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ProtectedQuery) GoString() string {
	return s.String()
}

// SetCreateTime sets the CreateTime field's value.
func (s *ProtectedQuery) SetCreateTime(v time.Time) *ProtectedQuery {
	s.CreateTime = &v
	return s
}

// SetDifferentialPrivacy sets the DifferentialPrivacy field's value.
func (s *ProtectedQuery) SetDifferentialPrivacy(v *DifferentialPrivacyParameters) *ProtectedQuery {
	s.DifferentialPrivacy = v
	return s
}

// SetError sets the Error field's value.
func (s *ProtectedQuery) SetError(v *ProtectedQueryError) *ProtectedQuery {
	s.Error = v
	return s
}

// SetId sets the Id field's value.
func (s *ProtectedQuery) SetId(v string) *ProtectedQuery {
	s.Id = &v
	return s
}

// SetMembershipArn sets the MembershipArn field's value.
func (s *ProtectedQuery) SetMembershipArn(v string) *ProtectedQuery {
	s.MembershipArn = &v
	return s
}

// SetMembershipId sets the MembershipId field's value.
func (s *ProtectedQuery) SetMembershipId(v string) *ProtectedQuery {
	s.MembershipId = &v
	return s
}

// SetResult sets the Result field's value.
func (s *ProtectedQuery) SetResult(v *ProtectedQueryResult) *ProtectedQuery {
	s.Result = v
	return s
}

// SetResultConfiguration sets the ResultConfiguration field's value.
func (s *ProtectedQuery) SetResultConfiguration(v *ProtectedQueryResultConfiguration) *ProtectedQuery {
	s.ResultConfiguration = v
	return s
}

// SetSqlParameters sets the SqlParameters field's value.
func (s *ProtectedQuery) SetSqlParameters(v *ProtectedQuerySQLParameters) *ProtectedQuery {
	s.SqlParameters = v
	return s
}

// SetStatistics sets the Statistics field's value.
func (s *ProtectedQuery) SetStatistics(v *ProtectedQueryStatistics) *ProtectedQuery {
	s.Statistics = v
	return s
}

// SetStatus sets the Status field's value.
func (s *ProtectedQuery) SetStatus(v string) *ProtectedQuery {
	s.Status = &v
	return s
}

// Details of errors thrown by the protected query.
type ProtectedQueryError struct {
	_ struct{} `type:"structure"`

	// An error code for the error.
	//
	// Code is a required field
	Code *string `locationName:"code" type:"string" required:"true"`

	// A description of why the query failed.
	//
	// Message is a required field
	Message *string `locationName:"message" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ProtectedQueryError) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ProtectedQueryError) GoString() string {
	return s.String()
}

// SetCode sets the Code field's value.
func (s *ProtectedQueryError) SetCode(v string) *ProtectedQueryError {
	s.Code = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *ProtectedQueryError) SetMessage(v string) *ProtectedQueryError {
	s.Message = &v
	return s
}

// Contains configuration details for protected query output.
type ProtectedQueryOutputConfiguration struct {
	_ struct{} `type:"structure"`

	// Required configuration for a protected query with an `S3` output type.
	S3 *ProtectedQueryS3OutputConfiguration `locationName:"s3" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ProtectedQueryOutputConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ProtectedQueryOutputConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ProtectedQueryOutputConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ProtectedQueryOutputConfiguration"}
	if s.S3 != nil {
		if err := s.S3.Validate(); err != nil {
			invalidParams.AddNested("S3", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetS3 sets the S3 field's value.
func (s *ProtectedQueryOutputConfiguration) SetS3(v *ProtectedQueryS3OutputConfiguration) *ProtectedQueryOutputConfiguration {
	s.S3 = v
	return s
}

// Contains details about the protected query output.
type ProtectedQueryOutput_ struct {
	_ struct{} `type:"structure"`

	// The list of member Amazon Web Services account(s) that received the results
	// of the query.
	MemberList []*ProtectedQuerySingleMemberOutput_ `locationName:"memberList" type:"list"`

	// If present, the output for a protected query with an `S3` output type.
	S3 *ProtectedQueryS3Output_ `locationName:"s3" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ProtectedQueryOutput_) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ProtectedQueryOutput_) GoString() string {
	return s.String()
}

// SetMemberList sets the MemberList field's value.
func (s *ProtectedQueryOutput_) SetMemberList(v []*ProtectedQuerySingleMemberOutput_) *ProtectedQueryOutput_ {
	s.MemberList = v
	return s
}

// SetS3 sets the S3 field's value.
func (s *ProtectedQueryOutput_) SetS3(v *ProtectedQueryS3Output_) *ProtectedQueryOutput_ {
	s.S3 = v
	return s
}

// Details about the query results.
type ProtectedQueryResult struct {
	_ struct{} `type:"structure"`

	// The output of the protected query.
	//
	// Output is a required field
	Output *ProtectedQueryOutput_ `locationName:"output" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ProtectedQueryResult) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ProtectedQueryResult) GoString() string {
	return s.String()
}

// SetOutput sets the Output field's value.
func (s *ProtectedQueryResult) SetOutput(v *ProtectedQueryOutput_) *ProtectedQueryResult {
	s.Output = v
	return s
}

// Contains configurations for protected query results.
type ProtectedQueryResultConfiguration struct {
	_ struct{} `type:"structure"`

	// Configuration for protected query results.
	//
	// OutputConfiguration is a required field
	OutputConfiguration *ProtectedQueryOutputConfiguration `locationName:"outputConfiguration" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ProtectedQueryResultConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ProtectedQueryResultConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ProtectedQueryResultConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ProtectedQueryResultConfiguration"}
	if s.OutputConfiguration == nil {
		invalidParams.Add(request.NewErrParamRequired("OutputConfiguration"))
	}
	if s.OutputConfiguration != nil {
		if err := s.OutputConfiguration.Validate(); err != nil {
			invalidParams.AddNested("OutputConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetOutputConfiguration sets the OutputConfiguration field's value.
func (s *ProtectedQueryResultConfiguration) SetOutputConfiguration(v *ProtectedQueryOutputConfiguration) *ProtectedQueryResultConfiguration {
	s.OutputConfiguration = v
	return s
}

// Contains the configuration to write the query results to S3.
type ProtectedQueryS3OutputConfiguration struct {
	_ struct{} `type:"structure"`

	// The S3 bucket to unload the protected query results.
	//
	// Bucket is a required field
	Bucket *string `locationName:"bucket" min:"3" type:"string" required:"true"`

	// The S3 prefix to unload the protected query results.
	KeyPrefix *string `locationName:"keyPrefix" type:"string"`

	// Intended file format of the result.
	//
	// ResultFormat is a required field
	ResultFormat *string `locationName:"resultFormat" type:"string" required:"true" enum:"ResultFormat"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ProtectedQueryS3OutputConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ProtectedQueryS3OutputConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ProtectedQueryS3OutputConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ProtectedQueryS3OutputConfiguration"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.Bucket != nil && len(*s.Bucket) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("Bucket", 3))
	}
	if s.ResultFormat == nil {
		invalidParams.Add(request.NewErrParamRequired("ResultFormat"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *ProtectedQueryS3OutputConfiguration) SetBucket(v string) *ProtectedQueryS3OutputConfiguration {
	s.Bucket = &v
	return s
}

// SetKeyPrefix sets the KeyPrefix field's value.
func (s *ProtectedQueryS3OutputConfiguration) SetKeyPrefix(v string) *ProtectedQueryS3OutputConfiguration {
	s.KeyPrefix = &v
	return s
}

// SetResultFormat sets the ResultFormat field's value.
func (s *ProtectedQueryS3OutputConfiguration) SetResultFormat(v string) *ProtectedQueryS3OutputConfiguration {
	s.ResultFormat = &v
	return s
}

// Contains output information for protected queries with an S3 output type.
type ProtectedQueryS3Output_ struct {
	_ struct{} `type:"structure"`

	// The S3 location of the result.
	//
	// Location is a required field
	Location *string `locationName:"location" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ProtectedQueryS3Output_) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ProtectedQueryS3Output_) GoString() string {
	return s.String()
}

// SetLocation sets the Location field's value.
func (s *ProtectedQueryS3Output_) SetLocation(v string) *ProtectedQueryS3Output_ {
	s.Location = &v
	return s
}

// The parameters for the SQL type Protected Query.
type ProtectedQuerySQLParameters struct {
	_ struct{} `type:"structure" sensitive:"true"`

	// The Amazon Resource Name (ARN) associated with the analysis template within
	// a collaboration.
	AnalysisTemplateArn *string `locationName:"analysisTemplateArn" type:"string"`

	// The protected query SQL parameters.
	Parameters map[string]*string `locationName:"parameters" type:"map"`

	// The query string to be submitted.
	QueryString *string `locationName:"queryString" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ProtectedQuerySQLParameters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ProtectedQuerySQLParameters) GoString() string {
	return s.String()
}

// SetAnalysisTemplateArn sets the AnalysisTemplateArn field's value.
func (s *ProtectedQuerySQLParameters) SetAnalysisTemplateArn(v string) *ProtectedQuerySQLParameters {
	s.AnalysisTemplateArn = &v
	return s
}

// SetParameters sets the Parameters field's value.
func (s *ProtectedQuerySQLParameters) SetParameters(v map[string]*string) *ProtectedQuerySQLParameters {
	s.Parameters = v
	return s
}

// SetQueryString sets the QueryString field's value.
func (s *ProtectedQuerySQLParameters) SetQueryString(v string) *ProtectedQuerySQLParameters {
	s.QueryString = &v
	return s
}

// Details about the member who received the query result.
type ProtectedQuerySingleMemberOutput_ struct {
	_ struct{} `type:"structure"`

	// The Amazon Web Services account ID of the member in the collaboration who
	// can receive results for the query.
	//
	// AccountId is a required field
	AccountId *string `locationName:"accountId" min:"12" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ProtectedQuerySingleMemberOutput_) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ProtectedQuerySingleMemberOutput_) GoString() string {
	return s.String()
}

// SetAccountId sets the AccountId field's value.
func (s *ProtectedQuerySingleMemberOutput_) SetAccountId(v string) *ProtectedQuerySingleMemberOutput_ {
	s.AccountId = &v
	return s
}

// Contains statistics about the execution of the protected query.
type ProtectedQueryStatistics struct {
	_ struct{} `type:"structure"`

	// The duration of the Protected Query, from creation until query completion.
	TotalDurationInMillis *int64 `locationName:"totalDurationInMillis" type:"long"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ProtectedQueryStatistics) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ProtectedQueryStatistics) GoString() string {
	return s.String()
}

// SetTotalDurationInMillis sets the TotalDurationInMillis field's value.
func (s *ProtectedQueryStatistics) SetTotalDurationInMillis(v int64) *ProtectedQueryStatistics {
	s.TotalDurationInMillis = &v
	return s
}

// The protected query summary for the objects listed by the request.
type ProtectedQuerySummary struct {
	_ struct{} `type:"structure"`

	// The time the protected query was created.
	//
	// CreateTime is a required field
	CreateTime *time.Time `locationName:"createTime" type:"timestamp" required:"true"`

	// The unique ID of the protected query.
	//
	// Id is a required field
	Id *string `locationName:"id" min:"36" type:"string" required:"true"`

	// The unique ARN for the membership that initiated the protected query.
	//
	// MembershipArn is a required field
	MembershipArn *string `locationName:"membershipArn" type:"string" required:"true"`

	// The unique ID for the membership that initiated the protected query.
	//
	// MembershipId is a required field
	MembershipId *string `locationName:"membershipId" min:"36" type:"string" required:"true"`

	// The status of the protected query. Value values are `SUBMITTED`, `STARTED`,
	// `CANCELLED`, `CANCELLING`, `FAILED`, `SUCCESS`, `TIMED_OUT`.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"ProtectedQueryStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ProtectedQuerySummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ProtectedQuerySummary) GoString() string {
	return s.String()
}

// SetCreateTime sets the CreateTime field's value.
func (s *ProtectedQuerySummary) SetCreateTime(v time.Time) *ProtectedQuerySummary {
	s.CreateTime = &v
	return s
}

// SetId sets the Id field's value.
func (s *ProtectedQuerySummary) SetId(v string) *ProtectedQuerySummary {
	s.Id = &v
	return s
}

// SetMembershipArn sets the MembershipArn field's value.
func (s *ProtectedQuerySummary) SetMembershipArn(v string) *ProtectedQuerySummary {
	s.MembershipArn = &v
	return s
}

// SetMembershipId sets the MembershipId field's value.
func (s *ProtectedQuerySummary) SetMembershipId(v string) *ProtectedQuerySummary {
	s.MembershipId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ProtectedQuerySummary) SetStatus(v string) *ProtectedQuerySummary {
	s.Status = &v
	return s
}

// An object representing the collaboration member's payment responsibilities
// set by the collaboration creator for query compute costs.
type QueryComputePaymentConfig struct {
	_ struct{} `type:"structure"`

	// Indicates whether the collaboration creator has configured the collaboration
	// member to pay for query compute costs (TRUE) or has not configured the collaboration
	// member to pay for query compute costs (FALSE).
	//
	// Exactly one member can be configured to pay for query compute costs. An error
	// is returned if the collaboration creator sets a TRUE value for more than
	// one member in the collaboration.
	//
	// If the collaboration creator hasn't specified anyone as the member paying
	// for query compute costs, then the member who can query is the default payer.
	// An error is returned if the collaboration creator sets a FALSE value for
	// the member who can query.
	//
	// IsResponsible is a required field
	IsResponsible *bool `locationName:"isResponsible" type:"boolean" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s QueryComputePaymentConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s QueryComputePaymentConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *QueryComputePaymentConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "QueryComputePaymentConfig"}
	if s.IsResponsible == nil {
		invalidParams.Add(request.NewErrParamRequired("IsResponsible"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIsResponsible sets the IsResponsible field's value.
func (s *QueryComputePaymentConfig) SetIsResponsible(v bool) *QueryComputePaymentConfig {
	s.IsResponsible = &v
	return s
}

// Provides any necessary query constraint information.
type QueryConstraint struct {
	_ struct{} `type:"structure"`

	// An array of column names that specifies which columns are required in the
	// JOIN statement.
	RequireOverlap *QueryConstraintRequireOverlap `locationName:"requireOverlap" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s QueryConstraint) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s QueryConstraint) GoString() string {
	return s.String()
}

// SetRequireOverlap sets the RequireOverlap field's value.
func (s *QueryConstraint) SetRequireOverlap(v *QueryConstraintRequireOverlap) *QueryConstraint {
	s.RequireOverlap = v
	return s
}

// Provides the name of the columns that are required to overlap.
type QueryConstraintRequireOverlap struct {
	_ struct{} `type:"structure"`

	// The columns that are required to overlap.
	Columns []*string `locationName:"columns" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s QueryConstraintRequireOverlap) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s QueryConstraintRequireOverlap) GoString() string {
	return s.String()
}

// SetColumns sets the Columns field's value.
func (s *QueryConstraintRequireOverlap) SetColumns(v []*string) *QueryConstraintRequireOverlap {
	s.Columns = v
	return s
}

// Request references a resource which does not exist.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`

	// The Id of the missing resource.
	//
	// ResourceId is a required field
	ResourceId *string `locationName:"resourceId" type:"string" required:"true"`

	// The type of the missing resource.
	//
	// ResourceType is a required field
	ResourceType *string `locationName:"resourceType" type:"string" required:"true" enum:"ResourceType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// A schema is a relation within a collaboration.
type Schema struct {
	_ struct{} `type:"structure"`

	// The analysis method for the schema. The only valid value is currently DIRECT_QUERY.
	AnalysisMethod *string `locationName:"analysisMethod" type:"string" enum:"AnalysisMethod"`

	// The analysis rule types that are associated with the schema. Currently, only
	// one entry is present.
	//
	// AnalysisRuleTypes is a required field
	AnalysisRuleTypes []*string `locationName:"analysisRuleTypes" type:"list" required:"true" enum:"AnalysisRuleType"`

	// The unique Amazon Resource Name (ARN) for the collaboration that the schema
	// belongs to.
	//
	// CollaborationArn is a required field
	CollaborationArn *string `locationName:"collaborationArn" type:"string" required:"true"`

	// The unique ID for the collaboration that the schema belongs to.
	//
	// CollaborationId is a required field
	CollaborationId *string `locationName:"collaborationId" min:"36" type:"string" required:"true"`

	// The columns for the relation that this schema represents.
	//
	// Columns is a required field
	Columns []*Column `locationName:"columns" type:"list" required:"true"`

	// The time at which the schema was created.
	//
	// CreateTime is a required field
	CreateTime *time.Time `locationName:"createTime" type:"timestamp" required:"true"`

	// The unique account ID for the Amazon Web Services account that owns the schema.
	//
	// CreatorAccountId is a required field
	CreatorAccountId *string `locationName:"creatorAccountId" min:"12" type:"string" required:"true"`

	// A description for the schema.
	//
	// Description is a required field
	Description *string `locationName:"description" type:"string" required:"true"`

	// A name for the schema. The schema relation is referred to by this name when
	// queried by a protected query.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// The partition keys for the dataset underlying this schema.
	//
	// PartitionKeys is a required field
	PartitionKeys []*Column `locationName:"partitionKeys" type:"list" required:"true"`

	// Details about the status of the schema. Currently, only one entry is present.
	//
	// SchemaStatusDetails is a required field
	SchemaStatusDetails []*SchemaStatusDetail `locationName:"schemaStatusDetails" type:"list" required:"true"`

	// The schema type properties.
	SchemaTypeProperties *SchemaTypeProperties `locationName:"schemaTypeProperties" type:"structure"`

	// The type of schema.
	//
	// Type is a required field
	Type *string `locationName:"type" type:"string" required:"true" enum:"SchemaType"`

	// The most recent time at which the schema was updated.
	//
	// UpdateTime is a required field
	UpdateTime *time.Time `locationName:"updateTime" type:"timestamp" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Schema) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Schema) GoString() string {
	return s.String()
}

// SetAnalysisMethod sets the AnalysisMethod field's value.
func (s *Schema) SetAnalysisMethod(v string) *Schema {
	s.AnalysisMethod = &v
	return s
}

// SetAnalysisRuleTypes sets the AnalysisRuleTypes field's value.
func (s *Schema) SetAnalysisRuleTypes(v []*string) *Schema {
	s.AnalysisRuleTypes = v
	return s
}

// SetCollaborationArn sets the CollaborationArn field's value.
func (s *Schema) SetCollaborationArn(v string) *Schema {
	s.CollaborationArn = &v
	return s
}

// SetCollaborationId sets the CollaborationId field's value.
func (s *Schema) SetCollaborationId(v string) *Schema {
	s.CollaborationId = &v
	return s
}

// SetColumns sets the Columns field's value.
func (s *Schema) SetColumns(v []*Column) *Schema {
	s.Columns = v
	return s
}

// SetCreateTime sets the CreateTime field's value.
func (s *Schema) SetCreateTime(v time.Time) *Schema {
	s.CreateTime = &v
	return s
}

// SetCreatorAccountId sets the CreatorAccountId field's value.
func (s *Schema) SetCreatorAccountId(v string) *Schema {
	s.CreatorAccountId = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *Schema) SetDescription(v string) *Schema {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *Schema) SetName(v string) *Schema {
	s.Name = &v
	return s
}

// SetPartitionKeys sets the PartitionKeys field's value.
func (s *Schema) SetPartitionKeys(v []*Column) *Schema {
	s.PartitionKeys = v
	return s
}

// SetSchemaStatusDetails sets the SchemaStatusDetails field's value.
func (s *Schema) SetSchemaStatusDetails(v []*SchemaStatusDetail) *Schema {
	s.SchemaStatusDetails = v
	return s
}

// SetSchemaTypeProperties sets the SchemaTypeProperties field's value.
func (s *Schema) SetSchemaTypeProperties(v *SchemaTypeProperties) *Schema {
	s.SchemaTypeProperties = v
	return s
}

// SetType sets the Type field's value.
func (s *Schema) SetType(v string) *Schema {
	s.Type = &v
	return s
}

// SetUpdateTime sets the UpdateTime field's value.
func (s *Schema) SetUpdateTime(v time.Time) *Schema {
	s.UpdateTime = &v
	return s
}

// Defines the information that's necessary to retrieve an analysis rule schema.
// Schema analysis rules are uniquely identiﬁed by a combination of the schema
// name and the analysis rule type for a given collaboration.
type SchemaAnalysisRuleRequest struct {
	_ struct{} `type:"structure"`

	// The name of the analysis rule schema that you are requesting.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// The type of analysis rule schema that you are requesting.
	//
	// Type is a required field
	Type *string `locationName:"type" type:"string" required:"true" enum:"AnalysisRuleType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SchemaAnalysisRuleRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SchemaAnalysisRuleRequest) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SchemaAnalysisRuleRequest) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SchemaAnalysisRuleRequest"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *SchemaAnalysisRuleRequest) SetName(v string) *SchemaAnalysisRuleRequest {
	s.Name = &v
	return s
}

// SetType sets the Type field's value.
func (s *SchemaAnalysisRuleRequest) SetType(v string) *SchemaAnalysisRuleRequest {
	s.Type = &v
	return s
}

// Information about the schema status.
//
// A status of READY means that based on the schema analysis rule, queries of
// the given analysis rule type are properly configured to run queries on this
// schema.
type SchemaStatusDetail struct {
	_ struct{} `type:"structure"`

	// The analysis rule type for which the schema status has been evaluated.
	AnalysisRuleType *string `locationName:"analysisRuleType" type:"string" enum:"AnalysisRuleType"`

	// The configuration details of the schema analysis rule for the given type.
	Configurations []*string `locationName:"configurations" type:"list" enum:"SchemaConfiguration"`

	// The reasons why the schema status is set to its current state.
	Reasons []*SchemaStatusReason `locationName:"reasons" type:"list"`

	// The status of the schema.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"SchemaStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SchemaStatusDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SchemaStatusDetail) GoString() string {
	return s.String()
}

// SetAnalysisRuleType sets the AnalysisRuleType field's value.
func (s *SchemaStatusDetail) SetAnalysisRuleType(v string) *SchemaStatusDetail {
	s.AnalysisRuleType = &v
	return s
}

// SetConfigurations sets the Configurations field's value.
func (s *SchemaStatusDetail) SetConfigurations(v []*string) *SchemaStatusDetail {
	s.Configurations = v
	return s
}

// SetReasons sets the Reasons field's value.
func (s *SchemaStatusDetail) SetReasons(v []*SchemaStatusReason) *SchemaStatusDetail {
	s.Reasons = v
	return s
}

// SetStatus sets the Status field's value.
func (s *SchemaStatusDetail) SetStatus(v string) *SchemaStatusDetail {
	s.Status = &v
	return s
}

// A reason why the schema status is set to its current value.
type SchemaStatusReason struct {
	_ struct{} `type:"structure"`

	// The schema status reason code.
	//
	// Code is a required field
	Code *string `locationName:"code" type:"string" required:"true" enum:"SchemaStatusReasonCode"`

	// An explanation of the schema status reason code.
	//
	// Message is a required field
	Message *string `locationName:"message" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SchemaStatusReason) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SchemaStatusReason) GoString() string {
	return s.String()
}

// SetCode sets the Code field's value.
func (s *SchemaStatusReason) SetCode(v string) *SchemaStatusReason {
	s.Code = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *SchemaStatusReason) SetMessage(v string) *SchemaStatusReason {
	s.Message = &v
	return s
}

// The schema summary for the objects listed by the request.
type SchemaSummary struct {
	_ struct{} `type:"structure"`

	// The analysis method for the associated schema. The only valid value is currently
	// `DIRECT_QUERY`.
	AnalysisMethod *string `locationName:"analysisMethod" type:"string" enum:"AnalysisMethod"`

	// The types of analysis rules that are associated with this schema object.
	//
	// AnalysisRuleTypes is a required field
	AnalysisRuleTypes []*string `locationName:"analysisRuleTypes" type:"list" required:"true" enum:"AnalysisRuleType"`

	// The unique ARN for the collaboration that the schema belongs to.
	//
	// CollaborationArn is a required field
	CollaborationArn *string `locationName:"collaborationArn" type:"string" required:"true"`

	// The unique ID for the collaboration that the schema belongs to.
	//
	// CollaborationId is a required field
	CollaborationId *string `locationName:"collaborationId" min:"36" type:"string" required:"true"`

	// The time the schema object was created.
	//
	// CreateTime is a required field
	CreateTime *time.Time `locationName:"createTime" type:"timestamp" required:"true"`

	// The unique account ID for the Amazon Web Services account that owns the schema.
	//
	// CreatorAccountId is a required field
	CreatorAccountId *string `locationName:"creatorAccountId" min:"12" type:"string" required:"true"`

	// The name for the schema object.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// The type of schema object.
	//
	// Type is a required field
	Type *string `locationName:"type" type:"string" required:"true" enum:"SchemaType"`

	// The time the schema object was last updated.
	//
	// UpdateTime is a required field
	UpdateTime *time.Time `locationName:"updateTime" type:"timestamp" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SchemaSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SchemaSummary) GoString() string {
	return s.String()
}

// SetAnalysisMethod sets the AnalysisMethod field's value.
func (s *SchemaSummary) SetAnalysisMethod(v string) *SchemaSummary {
	s.AnalysisMethod = &v
	return s
}

// SetAnalysisRuleTypes sets the AnalysisRuleTypes field's value.
func (s *SchemaSummary) SetAnalysisRuleTypes(v []*string) *SchemaSummary {
	s.AnalysisRuleTypes = v
	return s
}

// SetCollaborationArn sets the CollaborationArn field's value.
func (s *SchemaSummary) SetCollaborationArn(v string) *SchemaSummary {
	s.CollaborationArn = &v
	return s
}

// SetCollaborationId sets the CollaborationId field's value.
func (s *SchemaSummary) SetCollaborationId(v string) *SchemaSummary {
	s.CollaborationId = &v
	return s
}

// SetCreateTime sets the CreateTime field's value.
func (s *SchemaSummary) SetCreateTime(v time.Time) *SchemaSummary {
	s.CreateTime = &v
	return s
}

// SetCreatorAccountId sets the CreatorAccountId field's value.
func (s *SchemaSummary) SetCreatorAccountId(v string) *SchemaSummary {
	s.CreatorAccountId = &v
	return s
}

// SetName sets the Name field's value.
func (s *SchemaSummary) SetName(v string) *SchemaSummary {
	s.Name = &v
	return s
}

// SetType sets the Type field's value.
func (s *SchemaSummary) SetType(v string) *SchemaSummary {
	s.Type = &v
	return s
}

// SetUpdateTime sets the UpdateTime field's value.
func (s *SchemaSummary) SetUpdateTime(v time.Time) *SchemaSummary {
	s.UpdateTime = &v
	return s
}

// Information about the schema type properties.
type SchemaTypeProperties struct {
	_ struct{} `type:"structure"`

	// The ID mapping table for the schema type properties.
	IdMappingTable *IdMappingTableSchemaTypeProperties `locationName:"idMappingTable" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SchemaTypeProperties) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SchemaTypeProperties) GoString() string {
	return s.String()
}

// SetIdMappingTable sets the IdMappingTable field's value.
func (s *SchemaTypeProperties) SetIdMappingTable(v *IdMappingTableSchemaTypeProperties) *SchemaTypeProperties {
	s.IdMappingTable = v
	return s
}

// Request denied because service quota has been exceeded.
type ServiceQuotaExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`

	// The name of the quota.
	//
	// QuotaName is a required field
	QuotaName *string `locationName:"quotaName" type:"string" required:"true"`

	// The value of the quota.
	//
	// QuotaValue is a required field
	QuotaValue *float64 `locationName:"quotaValue" type:"double" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) GoString() string {
	return s.String()
}

func newErrorServiceQuotaExceededException(v protocol.ResponseMetadata) error {
	return &ServiceQuotaExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServiceQuotaExceededException) Code() string {
	return "ServiceQuotaExceededException"
}

// Message returns the exception's message.
func (s *ServiceQuotaExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServiceQuotaExceededException) OrigErr() error {
	return nil
}

func (s *ServiceQuotaExceededException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServiceQuotaExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServiceQuotaExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

type StartProtectedQueryInput struct {
	_ struct{} `type:"structure"`

	// A unique identifier for the membership to run this query against. Currently
	// accepts a membership ID.
	//
	// MembershipIdentifier is a required field
	MembershipIdentifier *string `location:"uri" locationName:"membershipIdentifier" min:"36" type:"string" required:"true"`

	// The details needed to write the query results.
	ResultConfiguration *ProtectedQueryResultConfiguration `locationName:"resultConfiguration" type:"structure"`

	// The protected SQL query parameters.
	//
	// SqlParameters is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by StartProtectedQueryInput's
	// String and GoString methods.
	//
	// SqlParameters is a required field
	SqlParameters *ProtectedQuerySQLParameters `locationName:"sqlParameters" type:"structure" required:"true" sensitive:"true"`

	// The type of the protected query to be started.
	//
	// Type is a required field
	Type *string `locationName:"type" type:"string" required:"true" enum:"ProtectedQueryType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartProtectedQueryInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartProtectedQueryInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartProtectedQueryInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartProtectedQueryInput"}
	if s.MembershipIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("MembershipIdentifier"))
	}
	if s.MembershipIdentifier != nil && len(*s.MembershipIdentifier) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("MembershipIdentifier", 36))
	}
	if s.SqlParameters == nil {
		invalidParams.Add(request.NewErrParamRequired("SqlParameters"))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}
	if s.ResultConfiguration != nil {
		if err := s.ResultConfiguration.Validate(); err != nil {
			invalidParams.AddNested("ResultConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMembershipIdentifier sets the MembershipIdentifier field's value.
func (s *StartProtectedQueryInput) SetMembershipIdentifier(v string) *StartProtectedQueryInput {
	s.MembershipIdentifier = &v
	return s
}

// SetResultConfiguration sets the ResultConfiguration field's value.
func (s *StartProtectedQueryInput) SetResultConfiguration(v *ProtectedQueryResultConfiguration) *StartProtectedQueryInput {
	s.ResultConfiguration = v
	return s
}

// SetSqlParameters sets the SqlParameters field's value.
func (s *StartProtectedQueryInput) SetSqlParameters(v *ProtectedQuerySQLParameters) *StartProtectedQueryInput {
	s.SqlParameters = v
	return s
}

// SetType sets the Type field's value.
func (s *StartProtectedQueryInput) SetType(v string) *StartProtectedQueryInput {
	s.Type = &v
	return s
}

type StartProtectedQueryOutput struct {
	_ struct{} `type:"structure"`

	// The protected query.
	//
	// ProtectedQuery is a required field
	ProtectedQuery *ProtectedQuery `locationName:"protectedQuery" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartProtectedQueryOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartProtectedQueryOutput) GoString() string {
	return s.String()
}

// SetProtectedQuery sets the ProtectedQuery field's value.
func (s *StartProtectedQueryOutput) SetProtectedQuery(v *ProtectedQuery) *StartProtectedQueryOutput {
	s.ProtectedQuery = v
	return s
}

// A pointer to the dataset that underlies this table. Currently, this can only
// be an Glue table.
type TableReference struct {
	_ struct{} `type:"structure"`

	// If present, a reference to the Glue table referred to by this table reference.
	Glue *GlueTableReference `locationName:"glue" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TableReference) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TableReference) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TableReference) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TableReference"}
	if s.Glue != nil {
		if err := s.Glue.Validate(); err != nil {
			invalidParams.AddNested("Glue", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGlue sets the Glue field's value.
func (s *TableReference) SetGlue(v *GlueTableReference) *TableReference {
	s.Glue = v
	return s
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) associated with the resource you want to tag.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" type:"string" required:"true"`

	// A map of objects specifying each key name and value.
	//
	// Tags is a required field
	Tags map[string]*string `locationName:"tags" type:"map" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *TagResourceInput) SetResourceArn(v string) *TagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v map[string]*string) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) GoString() string {
	return s.String()
}

// Request was denied due to request throttling.
type ThrottlingException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) GoString() string {
	return s.String()
}

func newErrorThrottlingException(v protocol.ResponseMetadata) error {
	return &ThrottlingException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ThrottlingException) Code() string {
	return "ThrottlingException"
}

// Message returns the exception's message.
func (s *ThrottlingException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ThrottlingException) OrigErr() error {
	return nil
}

func (s *ThrottlingException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ThrottlingException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ThrottlingException) RequestID() string {
	return s.RespMetadata.RequestID
}

type UntagResourceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The Amazon Resource Name (ARN) associated with the resource you want to remove
	// the tag from.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" type:"string" required:"true"`

	// A list of key names of tags to be removed.
	//
	// TagKeys is a required field
	TagKeys []*string `location:"querystring" locationName:"tagKeys" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *UntagResourceInput) SetResourceArn(v string) *UntagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

type UpdateAnalysisTemplateInput struct {
	_ struct{} `type:"structure"`

	// The identifier for the analysis template resource.
	//
	// AnalysisTemplateIdentifier is a required field
	AnalysisTemplateIdentifier *string `location:"uri" locationName:"analysisTemplateIdentifier" min:"36" type:"string" required:"true"`

	// A new description for the analysis template.
	Description *string `locationName:"description" type:"string"`

	// The identifier for a membership resource.
	//
	// MembershipIdentifier is a required field
	MembershipIdentifier *string `location:"uri" locationName:"membershipIdentifier" min:"36" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateAnalysisTemplateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateAnalysisTemplateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateAnalysisTemplateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateAnalysisTemplateInput"}
	if s.AnalysisTemplateIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("AnalysisTemplateIdentifier"))
	}
	if s.AnalysisTemplateIdentifier != nil && len(*s.AnalysisTemplateIdentifier) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("AnalysisTemplateIdentifier", 36))
	}
	if s.MembershipIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("MembershipIdentifier"))
	}
	if s.MembershipIdentifier != nil && len(*s.MembershipIdentifier) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("MembershipIdentifier", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAnalysisTemplateIdentifier sets the AnalysisTemplateIdentifier field's value.
func (s *UpdateAnalysisTemplateInput) SetAnalysisTemplateIdentifier(v string) *UpdateAnalysisTemplateInput {
	s.AnalysisTemplateIdentifier = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *UpdateAnalysisTemplateInput) SetDescription(v string) *UpdateAnalysisTemplateInput {
	s.Description = &v
	return s
}

// SetMembershipIdentifier sets the MembershipIdentifier field's value.
func (s *UpdateAnalysisTemplateInput) SetMembershipIdentifier(v string) *UpdateAnalysisTemplateInput {
	s.MembershipIdentifier = &v
	return s
}

type UpdateAnalysisTemplateOutput struct {
	_ struct{} `type:"structure"`

	// The analysis template.
	//
	// AnalysisTemplate is a required field
	AnalysisTemplate *AnalysisTemplate `locationName:"analysisTemplate" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateAnalysisTemplateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateAnalysisTemplateOutput) GoString() string {
	return s.String()
}

// SetAnalysisTemplate sets the AnalysisTemplate field's value.
func (s *UpdateAnalysisTemplateOutput) SetAnalysisTemplate(v *AnalysisTemplate) *UpdateAnalysisTemplateOutput {
	s.AnalysisTemplate = v
	return s
}

type UpdateCollaborationInput struct {
	_ struct{} `type:"structure"`

	// The identifier for the collaboration.
	//
	// CollaborationIdentifier is a required field
	CollaborationIdentifier *string `location:"uri" locationName:"collaborationIdentifier" min:"36" type:"string" required:"true"`

	// A description of the collaboration.
	Description *string `locationName:"description" min:"1" type:"string"`

	// A human-readable identifier provided by the collaboration owner. Display
	// names are not unique.
	Name *string `locationName:"name" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateCollaborationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateCollaborationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateCollaborationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateCollaborationInput"}
	if s.CollaborationIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("CollaborationIdentifier"))
	}
	if s.CollaborationIdentifier != nil && len(*s.CollaborationIdentifier) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("CollaborationIdentifier", 36))
	}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCollaborationIdentifier sets the CollaborationIdentifier field's value.
func (s *UpdateCollaborationInput) SetCollaborationIdentifier(v string) *UpdateCollaborationInput {
	s.CollaborationIdentifier = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *UpdateCollaborationInput) SetDescription(v string) *UpdateCollaborationInput {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateCollaborationInput) SetName(v string) *UpdateCollaborationInput {
	s.Name = &v
	return s
}

type UpdateCollaborationOutput struct {
	_ struct{} `type:"structure"`

	// The entire collaboration that has been updated.
	//
	// Collaboration is a required field
	Collaboration *Collaboration `locationName:"collaboration" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateCollaborationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateCollaborationOutput) GoString() string {
	return s.String()
}

// SetCollaboration sets the Collaboration field's value.
func (s *UpdateCollaborationOutput) SetCollaboration(v *Collaboration) *UpdateCollaborationOutput {
	s.Collaboration = v
	return s
}

type UpdateConfiguredAudienceModelAssociationInput struct {
	_ struct{} `type:"structure"`

	// A unique identifier for the configured audience model association that you
	// want to update.
	//
	// ConfiguredAudienceModelAssociationIdentifier is a required field
	ConfiguredAudienceModelAssociationIdentifier *string `location:"uri" locationName:"configuredAudienceModelAssociationIdentifier" min:"36" type:"string" required:"true"`

	// A new description for the configured audience model association.
	Description *string `locationName:"description" type:"string"`

	// A unique identifier of the membership that contains the configured audience
	// model association that you want to update.
	//
	// MembershipIdentifier is a required field
	MembershipIdentifier *string `location:"uri" locationName:"membershipIdentifier" min:"36" type:"string" required:"true"`

	// A new name for the configured audience model association.
	Name *string `locationName:"name" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateConfiguredAudienceModelAssociationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateConfiguredAudienceModelAssociationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateConfiguredAudienceModelAssociationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateConfiguredAudienceModelAssociationInput"}
	if s.ConfiguredAudienceModelAssociationIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfiguredAudienceModelAssociationIdentifier"))
	}
	if s.ConfiguredAudienceModelAssociationIdentifier != nil && len(*s.ConfiguredAudienceModelAssociationIdentifier) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("ConfiguredAudienceModelAssociationIdentifier", 36))
	}
	if s.MembershipIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("MembershipIdentifier"))
	}
	if s.MembershipIdentifier != nil && len(*s.MembershipIdentifier) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("MembershipIdentifier", 36))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfiguredAudienceModelAssociationIdentifier sets the ConfiguredAudienceModelAssociationIdentifier field's value.
func (s *UpdateConfiguredAudienceModelAssociationInput) SetConfiguredAudienceModelAssociationIdentifier(v string) *UpdateConfiguredAudienceModelAssociationInput {
	s.ConfiguredAudienceModelAssociationIdentifier = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *UpdateConfiguredAudienceModelAssociationInput) SetDescription(v string) *UpdateConfiguredAudienceModelAssociationInput {
	s.Description = &v
	return s
}

// SetMembershipIdentifier sets the MembershipIdentifier field's value.
func (s *UpdateConfiguredAudienceModelAssociationInput) SetMembershipIdentifier(v string) *UpdateConfiguredAudienceModelAssociationInput {
	s.MembershipIdentifier = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateConfiguredAudienceModelAssociationInput) SetName(v string) *UpdateConfiguredAudienceModelAssociationInput {
	s.Name = &v
	return s
}

type UpdateConfiguredAudienceModelAssociationOutput struct {
	_ struct{} `type:"structure"`

	// Details about the configured audience model association that you updated.
	//
	// ConfiguredAudienceModelAssociation is a required field
	ConfiguredAudienceModelAssociation *ConfiguredAudienceModelAssociation `locationName:"configuredAudienceModelAssociation" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateConfiguredAudienceModelAssociationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateConfiguredAudienceModelAssociationOutput) GoString() string {
	return s.String()
}

// SetConfiguredAudienceModelAssociation sets the ConfiguredAudienceModelAssociation field's value.
func (s *UpdateConfiguredAudienceModelAssociationOutput) SetConfiguredAudienceModelAssociation(v *ConfiguredAudienceModelAssociation) *UpdateConfiguredAudienceModelAssociationOutput {
	s.ConfiguredAudienceModelAssociation = v
	return s
}

type UpdateConfiguredTableAnalysisRuleInput struct {
	_ struct{} `type:"structure"`

	// The new analysis rule policy for the configured table analysis rule.
	//
	// AnalysisRulePolicy is a required field
	AnalysisRulePolicy *ConfiguredTableAnalysisRulePolicy `locationName:"analysisRulePolicy" type:"structure" required:"true"`

	// The analysis rule type to be updated. Configured table analysis rules are
	// uniquely identified by their configured table identifier and analysis rule
	// type.
	//
	// AnalysisRuleType is a required field
	AnalysisRuleType *string `location:"uri" locationName:"analysisRuleType" type:"string" required:"true" enum:"ConfiguredTableAnalysisRuleType"`

	// The unique identifier for the configured table that the analysis rule applies
	// to. Currently accepts the configured table ID.
	//
	// ConfiguredTableIdentifier is a required field
	ConfiguredTableIdentifier *string `location:"uri" locationName:"configuredTableIdentifier" min:"36" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateConfiguredTableAnalysisRuleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateConfiguredTableAnalysisRuleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateConfiguredTableAnalysisRuleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateConfiguredTableAnalysisRuleInput"}
	if s.AnalysisRulePolicy == nil {
		invalidParams.Add(request.NewErrParamRequired("AnalysisRulePolicy"))
	}
	if s.AnalysisRuleType == nil {
		invalidParams.Add(request.NewErrParamRequired("AnalysisRuleType"))
	}
	if s.AnalysisRuleType != nil && len(*s.AnalysisRuleType) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AnalysisRuleType", 1))
	}
	if s.ConfiguredTableIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfiguredTableIdentifier"))
	}
	if s.ConfiguredTableIdentifier != nil && len(*s.ConfiguredTableIdentifier) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("ConfiguredTableIdentifier", 36))
	}
	if s.AnalysisRulePolicy != nil {
		if err := s.AnalysisRulePolicy.Validate(); err != nil {
			invalidParams.AddNested("AnalysisRulePolicy", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAnalysisRulePolicy sets the AnalysisRulePolicy field's value.
func (s *UpdateConfiguredTableAnalysisRuleInput) SetAnalysisRulePolicy(v *ConfiguredTableAnalysisRulePolicy) *UpdateConfiguredTableAnalysisRuleInput {
	s.AnalysisRulePolicy = v
	return s
}

// SetAnalysisRuleType sets the AnalysisRuleType field's value.
func (s *UpdateConfiguredTableAnalysisRuleInput) SetAnalysisRuleType(v string) *UpdateConfiguredTableAnalysisRuleInput {
	s.AnalysisRuleType = &v
	return s
}

// SetConfiguredTableIdentifier sets the ConfiguredTableIdentifier field's value.
func (s *UpdateConfiguredTableAnalysisRuleInput) SetConfiguredTableIdentifier(v string) *UpdateConfiguredTableAnalysisRuleInput {
	s.ConfiguredTableIdentifier = &v
	return s
}

type UpdateConfiguredTableAnalysisRuleOutput struct {
	_ struct{} `type:"structure"`

	// The entire updated analysis rule.
	//
	// AnalysisRule is a required field
	AnalysisRule *ConfiguredTableAnalysisRule `locationName:"analysisRule" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateConfiguredTableAnalysisRuleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateConfiguredTableAnalysisRuleOutput) GoString() string {
	return s.String()
}

// SetAnalysisRule sets the AnalysisRule field's value.
func (s *UpdateConfiguredTableAnalysisRuleOutput) SetAnalysisRule(v *ConfiguredTableAnalysisRule) *UpdateConfiguredTableAnalysisRuleOutput {
	s.AnalysisRule = v
	return s
}

type UpdateConfiguredTableAssociationInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier for the configured table association to update. Currently
	// accepts the configured table association ID.
	//
	// ConfiguredTableAssociationIdentifier is a required field
	ConfiguredTableAssociationIdentifier *string `location:"uri" locationName:"configuredTableAssociationIdentifier" min:"36" type:"string" required:"true"`

	// A new description for the configured table association.
	Description *string `locationName:"description" type:"string"`

	// The unique ID for the membership that the configured table association belongs
	// to.
	//
	// MembershipIdentifier is a required field
	MembershipIdentifier *string `location:"uri" locationName:"membershipIdentifier" min:"36" type:"string" required:"true"`

	// The service will assume this role to access catalog metadata and query the
	// table.
	RoleArn *string `locationName:"roleArn" min:"32" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateConfiguredTableAssociationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateConfiguredTableAssociationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateConfiguredTableAssociationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateConfiguredTableAssociationInput"}
	if s.ConfiguredTableAssociationIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfiguredTableAssociationIdentifier"))
	}
	if s.ConfiguredTableAssociationIdentifier != nil && len(*s.ConfiguredTableAssociationIdentifier) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("ConfiguredTableAssociationIdentifier", 36))
	}
	if s.MembershipIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("MembershipIdentifier"))
	}
	if s.MembershipIdentifier != nil && len(*s.MembershipIdentifier) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("MembershipIdentifier", 36))
	}
	if s.RoleArn != nil && len(*s.RoleArn) < 32 {
		invalidParams.Add(request.NewErrParamMinLen("RoleArn", 32))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfiguredTableAssociationIdentifier sets the ConfiguredTableAssociationIdentifier field's value.
func (s *UpdateConfiguredTableAssociationInput) SetConfiguredTableAssociationIdentifier(v string) *UpdateConfiguredTableAssociationInput {
	s.ConfiguredTableAssociationIdentifier = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *UpdateConfiguredTableAssociationInput) SetDescription(v string) *UpdateConfiguredTableAssociationInput {
	s.Description = &v
	return s
}

// SetMembershipIdentifier sets the MembershipIdentifier field's value.
func (s *UpdateConfiguredTableAssociationInput) SetMembershipIdentifier(v string) *UpdateConfiguredTableAssociationInput {
	s.MembershipIdentifier = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *UpdateConfiguredTableAssociationInput) SetRoleArn(v string) *UpdateConfiguredTableAssociationInput {
	s.RoleArn = &v
	return s
}

type UpdateConfiguredTableAssociationOutput struct {
	_ struct{} `type:"structure"`

	// The entire updated configured table association.
	//
	// ConfiguredTableAssociation is a required field
	ConfiguredTableAssociation *ConfiguredTableAssociation `locationName:"configuredTableAssociation" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateConfiguredTableAssociationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateConfiguredTableAssociationOutput) GoString() string {
	return s.String()
}

// SetConfiguredTableAssociation sets the ConfiguredTableAssociation field's value.
func (s *UpdateConfiguredTableAssociationOutput) SetConfiguredTableAssociation(v *ConfiguredTableAssociation) *UpdateConfiguredTableAssociationOutput {
	s.ConfiguredTableAssociation = v
	return s
}

type UpdateConfiguredTableInput struct {
	_ struct{} `type:"structure"`

	// The identifier for the configured table to update. Currently accepts the
	// configured table ID.
	//
	// ConfiguredTableIdentifier is a required field
	ConfiguredTableIdentifier *string `location:"uri" locationName:"configuredTableIdentifier" min:"36" type:"string" required:"true"`

	// A new description for the configured table.
	Description *string `locationName:"description" type:"string"`

	// A new name for the configured table.
	Name *string `locationName:"name" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateConfiguredTableInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateConfiguredTableInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateConfiguredTableInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateConfiguredTableInput"}
	if s.ConfiguredTableIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfiguredTableIdentifier"))
	}
	if s.ConfiguredTableIdentifier != nil && len(*s.ConfiguredTableIdentifier) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("ConfiguredTableIdentifier", 36))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfiguredTableIdentifier sets the ConfiguredTableIdentifier field's value.
func (s *UpdateConfiguredTableInput) SetConfiguredTableIdentifier(v string) *UpdateConfiguredTableInput {
	s.ConfiguredTableIdentifier = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *UpdateConfiguredTableInput) SetDescription(v string) *UpdateConfiguredTableInput {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateConfiguredTableInput) SetName(v string) *UpdateConfiguredTableInput {
	s.Name = &v
	return s
}

type UpdateConfiguredTableOutput struct {
	_ struct{} `type:"structure"`

	// The updated configured table.
	//
	// ConfiguredTable is a required field
	ConfiguredTable *ConfiguredTable `locationName:"configuredTable" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateConfiguredTableOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateConfiguredTableOutput) GoString() string {
	return s.String()
}

// SetConfiguredTable sets the ConfiguredTable field's value.
func (s *UpdateConfiguredTableOutput) SetConfiguredTable(v *ConfiguredTable) *UpdateConfiguredTableOutput {
	s.ConfiguredTable = v
	return s
}

type UpdateIdMappingTableInput struct {
	_ struct{} `type:"structure"`

	// A new description for the ID mapping table.
	Description *string `locationName:"description" type:"string"`

	// The unique identifier of the ID mapping table that you want to update.
	//
	// IdMappingTableIdentifier is a required field
	IdMappingTableIdentifier *string `location:"uri" locationName:"idMappingTableIdentifier" min:"36" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the Amazon Web Services KMS key.
	KmsKeyArn *string `locationName:"kmsKeyArn" min:"20" type:"string"`

	// The unique identifier of the membership that contains the ID mapping table
	// that you want to update.
	//
	// MembershipIdentifier is a required field
	MembershipIdentifier *string `location:"uri" locationName:"membershipIdentifier" min:"36" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateIdMappingTableInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateIdMappingTableInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateIdMappingTableInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateIdMappingTableInput"}
	if s.IdMappingTableIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("IdMappingTableIdentifier"))
	}
	if s.IdMappingTableIdentifier != nil && len(*s.IdMappingTableIdentifier) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("IdMappingTableIdentifier", 36))
	}
	if s.KmsKeyArn != nil && len(*s.KmsKeyArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("KmsKeyArn", 20))
	}
	if s.MembershipIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("MembershipIdentifier"))
	}
	if s.MembershipIdentifier != nil && len(*s.MembershipIdentifier) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("MembershipIdentifier", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *UpdateIdMappingTableInput) SetDescription(v string) *UpdateIdMappingTableInput {
	s.Description = &v
	return s
}

// SetIdMappingTableIdentifier sets the IdMappingTableIdentifier field's value.
func (s *UpdateIdMappingTableInput) SetIdMappingTableIdentifier(v string) *UpdateIdMappingTableInput {
	s.IdMappingTableIdentifier = &v
	return s
}

// SetKmsKeyArn sets the KmsKeyArn field's value.
func (s *UpdateIdMappingTableInput) SetKmsKeyArn(v string) *UpdateIdMappingTableInput {
	s.KmsKeyArn = &v
	return s
}

// SetMembershipIdentifier sets the MembershipIdentifier field's value.
func (s *UpdateIdMappingTableInput) SetMembershipIdentifier(v string) *UpdateIdMappingTableInput {
	s.MembershipIdentifier = &v
	return s
}

type UpdateIdMappingTableOutput struct {
	_ struct{} `type:"structure"`

	// The updated ID mapping table.
	//
	// IdMappingTable is a required field
	IdMappingTable *IdMappingTable `locationName:"idMappingTable" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateIdMappingTableOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateIdMappingTableOutput) GoString() string {
	return s.String()
}

// SetIdMappingTable sets the IdMappingTable field's value.
func (s *UpdateIdMappingTableOutput) SetIdMappingTable(v *IdMappingTable) *UpdateIdMappingTableOutput {
	s.IdMappingTable = v
	return s
}

type UpdateMembershipInput struct {
	_ struct{} `type:"structure"`

	// The default protected query result configuration as specified by the member
	// who can receive results.
	DefaultResultConfiguration *MembershipProtectedQueryResultConfiguration `locationName:"defaultResultConfiguration" type:"structure"`

	// The unique identifier of the membership.
	//
	// MembershipIdentifier is a required field
	MembershipIdentifier *string `location:"uri" locationName:"membershipIdentifier" min:"36" type:"string" required:"true"`

	// An indicator as to whether query logging has been enabled or disabled for
	// the membership.
	QueryLogStatus *string `locationName:"queryLogStatus" type:"string" enum:"MembershipQueryLogStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateMembershipInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateMembershipInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateMembershipInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateMembershipInput"}
	if s.MembershipIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("MembershipIdentifier"))
	}
	if s.MembershipIdentifier != nil && len(*s.MembershipIdentifier) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("MembershipIdentifier", 36))
	}
	if s.DefaultResultConfiguration != nil {
		if err := s.DefaultResultConfiguration.Validate(); err != nil {
			invalidParams.AddNested("DefaultResultConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDefaultResultConfiguration sets the DefaultResultConfiguration field's value.
func (s *UpdateMembershipInput) SetDefaultResultConfiguration(v *MembershipProtectedQueryResultConfiguration) *UpdateMembershipInput {
	s.DefaultResultConfiguration = v
	return s
}

// SetMembershipIdentifier sets the MembershipIdentifier field's value.
func (s *UpdateMembershipInput) SetMembershipIdentifier(v string) *UpdateMembershipInput {
	s.MembershipIdentifier = &v
	return s
}

// SetQueryLogStatus sets the QueryLogStatus field's value.
func (s *UpdateMembershipInput) SetQueryLogStatus(v string) *UpdateMembershipInput {
	s.QueryLogStatus = &v
	return s
}

type UpdateMembershipOutput struct {
	_ struct{} `type:"structure"`

	// The membership object.
	//
	// Membership is a required field
	Membership *Membership `locationName:"membership" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateMembershipOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateMembershipOutput) GoString() string {
	return s.String()
}

// SetMembership sets the Membership field's value.
func (s *UpdateMembershipOutput) SetMembership(v *Membership) *UpdateMembershipOutput {
	s.Membership = v
	return s
}

type UpdatePrivacyBudgetTemplateInput struct {
	_ struct{} `type:"structure"`

	// A unique identifier for one of your memberships for a collaboration. The
	// privacy budget template is updated in the collaboration that this membership
	// belongs to. Accepts a membership ID.
	//
	// MembershipIdentifier is a required field
	MembershipIdentifier *string `location:"uri" locationName:"membershipIdentifier" min:"36" type:"string" required:"true"`

	// Specifies the epsilon and noise parameters for the privacy budget template.
	Parameters *PrivacyBudgetTemplateUpdateParameters `locationName:"parameters" type:"structure"`

	// A unique identifier for your privacy budget template that you want to update.
	//
	// PrivacyBudgetTemplateIdentifier is a required field
	PrivacyBudgetTemplateIdentifier *string `location:"uri" locationName:"privacyBudgetTemplateIdentifier" min:"36" type:"string" required:"true"`

	// Specifies the type of the privacy budget template.
	//
	// PrivacyBudgetType is a required field
	PrivacyBudgetType *string `locationName:"privacyBudgetType" type:"string" required:"true" enum:"PrivacyBudgetType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdatePrivacyBudgetTemplateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdatePrivacyBudgetTemplateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdatePrivacyBudgetTemplateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdatePrivacyBudgetTemplateInput"}
	if s.MembershipIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("MembershipIdentifier"))
	}
	if s.MembershipIdentifier != nil && len(*s.MembershipIdentifier) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("MembershipIdentifier", 36))
	}
	if s.PrivacyBudgetTemplateIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("PrivacyBudgetTemplateIdentifier"))
	}
	if s.PrivacyBudgetTemplateIdentifier != nil && len(*s.PrivacyBudgetTemplateIdentifier) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("PrivacyBudgetTemplateIdentifier", 36))
	}
	if s.PrivacyBudgetType == nil {
		invalidParams.Add(request.NewErrParamRequired("PrivacyBudgetType"))
	}
	if s.Parameters != nil {
		if err := s.Parameters.Validate(); err != nil {
			invalidParams.AddNested("Parameters", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMembershipIdentifier sets the MembershipIdentifier field's value.
func (s *UpdatePrivacyBudgetTemplateInput) SetMembershipIdentifier(v string) *UpdatePrivacyBudgetTemplateInput {
	s.MembershipIdentifier = &v
	return s
}

// SetParameters sets the Parameters field's value.
func (s *UpdatePrivacyBudgetTemplateInput) SetParameters(v *PrivacyBudgetTemplateUpdateParameters) *UpdatePrivacyBudgetTemplateInput {
	s.Parameters = v
	return s
}

// SetPrivacyBudgetTemplateIdentifier sets the PrivacyBudgetTemplateIdentifier field's value.
func (s *UpdatePrivacyBudgetTemplateInput) SetPrivacyBudgetTemplateIdentifier(v string) *UpdatePrivacyBudgetTemplateInput {
	s.PrivacyBudgetTemplateIdentifier = &v
	return s
}

// SetPrivacyBudgetType sets the PrivacyBudgetType field's value.
func (s *UpdatePrivacyBudgetTemplateInput) SetPrivacyBudgetType(v string) *UpdatePrivacyBudgetTemplateInput {
	s.PrivacyBudgetType = &v
	return s
}

type UpdatePrivacyBudgetTemplateOutput struct {
	_ struct{} `type:"structure"`

	// Summary of the privacy budget template.
	//
	// PrivacyBudgetTemplate is a required field
	PrivacyBudgetTemplate *PrivacyBudgetTemplate `locationName:"privacyBudgetTemplate" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdatePrivacyBudgetTemplateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdatePrivacyBudgetTemplateOutput) GoString() string {
	return s.String()
}

// SetPrivacyBudgetTemplate sets the PrivacyBudgetTemplate field's value.
func (s *UpdatePrivacyBudgetTemplateOutput) SetPrivacyBudgetTemplate(v *PrivacyBudgetTemplate) *UpdatePrivacyBudgetTemplateOutput {
	s.PrivacyBudgetTemplate = v
	return s
}

type UpdateProtectedQueryInput struct {
	_ struct{} `type:"structure"`

	// The identifier for a member of a protected query instance.
	//
	// MembershipIdentifier is a required field
	MembershipIdentifier *string `location:"uri" locationName:"membershipIdentifier" min:"36" type:"string" required:"true"`

	// The identifier for a protected query instance.
	//
	// ProtectedQueryIdentifier is a required field
	ProtectedQueryIdentifier *string `location:"uri" locationName:"protectedQueryIdentifier" min:"36" type:"string" required:"true"`

	// The target status of a query. Used to update the execution status of a currently
	// running query.
	//
	// TargetStatus is a required field
	TargetStatus *string `locationName:"targetStatus" type:"string" required:"true" enum:"TargetProtectedQueryStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateProtectedQueryInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateProtectedQueryInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateProtectedQueryInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateProtectedQueryInput"}
	if s.MembershipIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("MembershipIdentifier"))
	}
	if s.MembershipIdentifier != nil && len(*s.MembershipIdentifier) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("MembershipIdentifier", 36))
	}
	if s.ProtectedQueryIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("ProtectedQueryIdentifier"))
	}
	if s.ProtectedQueryIdentifier != nil && len(*s.ProtectedQueryIdentifier) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("ProtectedQueryIdentifier", 36))
	}
	if s.TargetStatus == nil {
		invalidParams.Add(request.NewErrParamRequired("TargetStatus"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMembershipIdentifier sets the MembershipIdentifier field's value.
func (s *UpdateProtectedQueryInput) SetMembershipIdentifier(v string) *UpdateProtectedQueryInput {
	s.MembershipIdentifier = &v
	return s
}

// SetProtectedQueryIdentifier sets the ProtectedQueryIdentifier field's value.
func (s *UpdateProtectedQueryInput) SetProtectedQueryIdentifier(v string) *UpdateProtectedQueryInput {
	s.ProtectedQueryIdentifier = &v
	return s
}

// SetTargetStatus sets the TargetStatus field's value.
func (s *UpdateProtectedQueryInput) SetTargetStatus(v string) *UpdateProtectedQueryInput {
	s.TargetStatus = &v
	return s
}

type UpdateProtectedQueryOutput struct {
	_ struct{} `type:"structure"`

	// The protected query output.
	//
	// ProtectedQuery is a required field
	ProtectedQuery *ProtectedQuery `locationName:"protectedQuery" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateProtectedQueryOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateProtectedQueryOutput) GoString() string {
	return s.String()
}

// SetProtectedQuery sets the ProtectedQuery field's value.
func (s *UpdateProtectedQueryOutput) SetProtectedQuery(v *ProtectedQuery) *UpdateProtectedQueryOutput {
	s.ProtectedQuery = v
	return s
}

// The input fails to satisfy the specified constraints.
type ValidationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// Validation errors for specific input parameters.
	FieldList []*ValidationExceptionField `locationName:"fieldList" type:"list"`

	Message_ *string `locationName:"message" type:"string"`

	// A reason code for the exception.
	Reason *string `locationName:"reason" type:"string" enum:"ValidationExceptionReason"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) GoString() string {
	return s.String()
}

func newErrorValidationException(v protocol.ResponseMetadata) error {
	return &ValidationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ValidationException) Code() string {
	return "ValidationException"
}

// Message returns the exception's message.
func (s *ValidationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ValidationException) OrigErr() error {
	return nil
}

func (s *ValidationException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ValidationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ValidationException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Describes validation errors for specific input parameters.
type ValidationExceptionField struct {
	_ struct{} `type:"structure"`

	// A message for the input validation error.
	//
	// Message is a required field
	Message *string `locationName:"message" type:"string" required:"true"`

	// The name of the input parameter.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationExceptionField) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationExceptionField) GoString() string {
	return s.String()
}

// SetMessage sets the Message field's value.
func (s *ValidationExceptionField) SetMessage(v string) *ValidationExceptionField {
	s.Message = &v
	return s
}

// SetName sets the Name field's value.
func (s *ValidationExceptionField) SetName(v string) *ValidationExceptionField {
	s.Name = &v
	return s
}

const (
	// AccessDeniedExceptionReasonInsufficientPermissions is a AccessDeniedExceptionReason enum value
	AccessDeniedExceptionReasonInsufficientPermissions = "INSUFFICIENT_PERMISSIONS"
)

// AccessDeniedExceptionReason_Values returns all elements of the AccessDeniedExceptionReason enum
func AccessDeniedExceptionReason_Values() []string {
	return []string{
		AccessDeniedExceptionReasonInsufficientPermissions,
	}
}

const (
	// AggregateFunctionNameSum is a AggregateFunctionName enum value
	AggregateFunctionNameSum = "SUM"

	// AggregateFunctionNameSumDistinct is a AggregateFunctionName enum value
	AggregateFunctionNameSumDistinct = "SUM_DISTINCT"

	// AggregateFunctionNameCount is a AggregateFunctionName enum value
	AggregateFunctionNameCount = "COUNT"

	// AggregateFunctionNameCountDistinct is a AggregateFunctionName enum value
	AggregateFunctionNameCountDistinct = "COUNT_DISTINCT"

	// AggregateFunctionNameAvg is a AggregateFunctionName enum value
	AggregateFunctionNameAvg = "AVG"
)

// AggregateFunctionName_Values returns all elements of the AggregateFunctionName enum
func AggregateFunctionName_Values() []string {
	return []string{
		AggregateFunctionNameSum,
		AggregateFunctionNameSumDistinct,
		AggregateFunctionNameCount,
		AggregateFunctionNameCountDistinct,
		AggregateFunctionNameAvg,
	}
}

const (
	// AggregationTypeCountDistinct is a AggregationType enum value
	AggregationTypeCountDistinct = "COUNT_DISTINCT"
)

// AggregationType_Values returns all elements of the AggregationType enum
func AggregationType_Values() []string {
	return []string{
		AggregationTypeCountDistinct,
	}
}

const (
	// AnalysisFormatSql is a AnalysisFormat enum value
	AnalysisFormatSql = "SQL"
)

// AnalysisFormat_Values returns all elements of the AnalysisFormat enum
func AnalysisFormat_Values() []string {
	return []string{
		AnalysisFormatSql,
	}
}

const (
	// AnalysisMethodDirectQuery is a AnalysisMethod enum value
	AnalysisMethodDirectQuery = "DIRECT_QUERY"
)

// AnalysisMethod_Values returns all elements of the AnalysisMethod enum
func AnalysisMethod_Values() []string {
	return []string{
		AnalysisMethodDirectQuery,
	}
}

const (
	// AnalysisRuleTypeAggregation is a AnalysisRuleType enum value
	AnalysisRuleTypeAggregation = "AGGREGATION"

	// AnalysisRuleTypeList is a AnalysisRuleType enum value
	AnalysisRuleTypeList = "LIST"

	// AnalysisRuleTypeCustom is a AnalysisRuleType enum value
	AnalysisRuleTypeCustom = "CUSTOM"

	// AnalysisRuleTypeIdMappingTable is a AnalysisRuleType enum value
	AnalysisRuleTypeIdMappingTable = "ID_MAPPING_TABLE"
)

// AnalysisRuleType_Values returns all elements of the AnalysisRuleType enum
func AnalysisRuleType_Values() []string {
	return []string{
		AnalysisRuleTypeAggregation,
		AnalysisRuleTypeList,
		AnalysisRuleTypeCustom,
		AnalysisRuleTypeIdMappingTable,
	}
}

const (
	// AnalysisTemplateValidationStatusValid is a AnalysisTemplateValidationStatus enum value
	AnalysisTemplateValidationStatusValid = "VALID"

	// AnalysisTemplateValidationStatusInvalid is a AnalysisTemplateValidationStatus enum value
	AnalysisTemplateValidationStatusInvalid = "INVALID"

	// AnalysisTemplateValidationStatusUnableToValidate is a AnalysisTemplateValidationStatus enum value
	AnalysisTemplateValidationStatusUnableToValidate = "UNABLE_TO_VALIDATE"
)

// AnalysisTemplateValidationStatus_Values returns all elements of the AnalysisTemplateValidationStatus enum
func AnalysisTemplateValidationStatus_Values() []string {
	return []string{
		AnalysisTemplateValidationStatusValid,
		AnalysisTemplateValidationStatusInvalid,
		AnalysisTemplateValidationStatusUnableToValidate,
	}
}

const (
	// AnalysisTemplateValidationTypeDifferentialPrivacy is a AnalysisTemplateValidationType enum value
	AnalysisTemplateValidationTypeDifferentialPrivacy = "DIFFERENTIAL_PRIVACY"
)

// AnalysisTemplateValidationType_Values returns all elements of the AnalysisTemplateValidationType enum
func AnalysisTemplateValidationType_Values() []string {
	return []string{
		AnalysisTemplateValidationTypeDifferentialPrivacy,
	}
}

const (
	// CollaborationQueryLogStatusEnabled is a CollaborationQueryLogStatus enum value
	CollaborationQueryLogStatusEnabled = "ENABLED"

	// CollaborationQueryLogStatusDisabled is a CollaborationQueryLogStatus enum value
	CollaborationQueryLogStatusDisabled = "DISABLED"
)

// CollaborationQueryLogStatus_Values returns all elements of the CollaborationQueryLogStatus enum
func CollaborationQueryLogStatus_Values() []string {
	return []string{
		CollaborationQueryLogStatusEnabled,
		CollaborationQueryLogStatusDisabled,
	}
}

const (
	// ConfiguredTableAnalysisRuleTypeAggregation is a ConfiguredTableAnalysisRuleType enum value
	ConfiguredTableAnalysisRuleTypeAggregation = "AGGREGATION"

	// ConfiguredTableAnalysisRuleTypeList is a ConfiguredTableAnalysisRuleType enum value
	ConfiguredTableAnalysisRuleTypeList = "LIST"

	// ConfiguredTableAnalysisRuleTypeCustom is a ConfiguredTableAnalysisRuleType enum value
	ConfiguredTableAnalysisRuleTypeCustom = "CUSTOM"
)

// ConfiguredTableAnalysisRuleType_Values returns all elements of the ConfiguredTableAnalysisRuleType enum
func ConfiguredTableAnalysisRuleType_Values() []string {
	return []string{
		ConfiguredTableAnalysisRuleTypeAggregation,
		ConfiguredTableAnalysisRuleTypeList,
		ConfiguredTableAnalysisRuleTypeCustom,
	}
}

const (
	// ConflictExceptionReasonAlreadyExists is a ConflictExceptionReason enum value
	ConflictExceptionReasonAlreadyExists = "ALREADY_EXISTS"

	// ConflictExceptionReasonSubresourcesExist is a ConflictExceptionReason enum value
	ConflictExceptionReasonSubresourcesExist = "SUBRESOURCES_EXIST"

	// ConflictExceptionReasonInvalidState is a ConflictExceptionReason enum value
	ConflictExceptionReasonInvalidState = "INVALID_STATE"
)

// ConflictExceptionReason_Values returns all elements of the ConflictExceptionReason enum
func ConflictExceptionReason_Values() []string {
	return []string{
		ConflictExceptionReasonAlreadyExists,
		ConflictExceptionReasonSubresourcesExist,
		ConflictExceptionReasonInvalidState,
	}
}

const (
	// DifferentialPrivacyAggregationTypeAvg is a DifferentialPrivacyAggregationType enum value
	DifferentialPrivacyAggregationTypeAvg = "AVG"

	// DifferentialPrivacyAggregationTypeCount is a DifferentialPrivacyAggregationType enum value
	DifferentialPrivacyAggregationTypeCount = "COUNT"

	// DifferentialPrivacyAggregationTypeCountDistinct is a DifferentialPrivacyAggregationType enum value
	DifferentialPrivacyAggregationTypeCountDistinct = "COUNT_DISTINCT"

	// DifferentialPrivacyAggregationTypeSum is a DifferentialPrivacyAggregationType enum value
	DifferentialPrivacyAggregationTypeSum = "SUM"

	// DifferentialPrivacyAggregationTypeStddev is a DifferentialPrivacyAggregationType enum value
	DifferentialPrivacyAggregationTypeStddev = "STDDEV"
)

// DifferentialPrivacyAggregationType_Values returns all elements of the DifferentialPrivacyAggregationType enum
func DifferentialPrivacyAggregationType_Values() []string {
	return []string{
		DifferentialPrivacyAggregationTypeAvg,
		DifferentialPrivacyAggregationTypeCount,
		DifferentialPrivacyAggregationTypeCountDistinct,
		DifferentialPrivacyAggregationTypeSum,
		DifferentialPrivacyAggregationTypeStddev,
	}
}

const (
	// FilterableMemberStatusInvited is a FilterableMemberStatus enum value
	FilterableMemberStatusInvited = "INVITED"

	// FilterableMemberStatusActive is a FilterableMemberStatus enum value
	FilterableMemberStatusActive = "ACTIVE"
)

// FilterableMemberStatus_Values returns all elements of the FilterableMemberStatus enum
func FilterableMemberStatus_Values() []string {
	return []string{
		FilterableMemberStatusInvited,
		FilterableMemberStatusActive,
	}
}

const (
	// IdNamespaceTypeSource is a IdNamespaceType enum value
	IdNamespaceTypeSource = "SOURCE"

	// IdNamespaceTypeTarget is a IdNamespaceType enum value
	IdNamespaceTypeTarget = "TARGET"
)

// IdNamespaceType_Values returns all elements of the IdNamespaceType enum
func IdNamespaceType_Values() []string {
	return []string{
		IdNamespaceTypeSource,
		IdNamespaceTypeTarget,
	}
}

const (
	// JoinOperatorOr is a JoinOperator enum value
	JoinOperatorOr = "OR"

	// JoinOperatorAnd is a JoinOperator enum value
	JoinOperatorAnd = "AND"
)

// JoinOperator_Values returns all elements of the JoinOperator enum
func JoinOperator_Values() []string {
	return []string{
		JoinOperatorOr,
		JoinOperatorAnd,
	}
}

const (
	// JoinRequiredOptionQueryRunner is a JoinRequiredOption enum value
	JoinRequiredOptionQueryRunner = "QUERY_RUNNER"
)

// JoinRequiredOption_Values returns all elements of the JoinRequiredOption enum
func JoinRequiredOption_Values() []string {
	return []string{
		JoinRequiredOptionQueryRunner,
	}
}

const (
	// MemberAbilityCanQuery is a MemberAbility enum value
	MemberAbilityCanQuery = "CAN_QUERY"

	// MemberAbilityCanReceiveResults is a MemberAbility enum value
	MemberAbilityCanReceiveResults = "CAN_RECEIVE_RESULTS"
)

// MemberAbility_Values returns all elements of the MemberAbility enum
func MemberAbility_Values() []string {
	return []string{
		MemberAbilityCanQuery,
		MemberAbilityCanReceiveResults,
	}
}

const (
	// MemberStatusInvited is a MemberStatus enum value
	MemberStatusInvited = "INVITED"

	// MemberStatusActive is a MemberStatus enum value
	MemberStatusActive = "ACTIVE"

	// MemberStatusLeft is a MemberStatus enum value
	MemberStatusLeft = "LEFT"

	// MemberStatusRemoved is a MemberStatus enum value
	MemberStatusRemoved = "REMOVED"
)

// MemberStatus_Values returns all elements of the MemberStatus enum
func MemberStatus_Values() []string {
	return []string{
		MemberStatusInvited,
		MemberStatusActive,
		MemberStatusLeft,
		MemberStatusRemoved,
	}
}

const (
	// MembershipQueryLogStatusEnabled is a MembershipQueryLogStatus enum value
	MembershipQueryLogStatusEnabled = "ENABLED"

	// MembershipQueryLogStatusDisabled is a MembershipQueryLogStatus enum value
	MembershipQueryLogStatusDisabled = "DISABLED"
)

// MembershipQueryLogStatus_Values returns all elements of the MembershipQueryLogStatus enum
func MembershipQueryLogStatus_Values() []string {
	return []string{
		MembershipQueryLogStatusEnabled,
		MembershipQueryLogStatusDisabled,
	}
}

const (
	// MembershipStatusActive is a MembershipStatus enum value
	MembershipStatusActive = "ACTIVE"

	// MembershipStatusRemoved is a MembershipStatus enum value
	MembershipStatusRemoved = "REMOVED"

	// MembershipStatusCollaborationDeleted is a MembershipStatus enum value
	MembershipStatusCollaborationDeleted = "COLLABORATION_DELETED"
)

// MembershipStatus_Values returns all elements of the MembershipStatus enum
func MembershipStatus_Values() []string {
	return []string{
		MembershipStatusActive,
		MembershipStatusRemoved,
		MembershipStatusCollaborationDeleted,
	}
}

const (
	// ParameterTypeSmallint is a ParameterType enum value
	ParameterTypeSmallint = "SMALLINT"

	// ParameterTypeInteger is a ParameterType enum value
	ParameterTypeInteger = "INTEGER"

	// ParameterTypeBigint is a ParameterType enum value
	ParameterTypeBigint = "BIGINT"

	// ParameterTypeDecimal is a ParameterType enum value
	ParameterTypeDecimal = "DECIMAL"

	// ParameterTypeReal is a ParameterType enum value
	ParameterTypeReal = "REAL"

	// ParameterTypeDoublePrecision is a ParameterType enum value
	ParameterTypeDoublePrecision = "DOUBLE_PRECISION"

	// ParameterTypeBoolean is a ParameterType enum value
	ParameterTypeBoolean = "BOOLEAN"

	// ParameterTypeChar is a ParameterType enum value
	ParameterTypeChar = "CHAR"

	// ParameterTypeVarchar is a ParameterType enum value
	ParameterTypeVarchar = "VARCHAR"

	// ParameterTypeDate is a ParameterType enum value
	ParameterTypeDate = "DATE"

	// ParameterTypeTimestamp is a ParameterType enum value
	ParameterTypeTimestamp = "TIMESTAMP"

	// ParameterTypeTimestamptz is a ParameterType enum value
	ParameterTypeTimestamptz = "TIMESTAMPTZ"

	// ParameterTypeTime is a ParameterType enum value
	ParameterTypeTime = "TIME"

	// ParameterTypeTimetz is a ParameterType enum value
	ParameterTypeTimetz = "TIMETZ"

	// ParameterTypeVarbyte is a ParameterType enum value
	ParameterTypeVarbyte = "VARBYTE"
)

// ParameterType_Values returns all elements of the ParameterType enum
func ParameterType_Values() []string {
	return []string{
		ParameterTypeSmallint,
		ParameterTypeInteger,
		ParameterTypeBigint,
		ParameterTypeDecimal,
		ParameterTypeReal,
		ParameterTypeDoublePrecision,
		ParameterTypeBoolean,
		ParameterTypeChar,
		ParameterTypeVarchar,
		ParameterTypeDate,
		ParameterTypeTimestamp,
		ParameterTypeTimestamptz,
		ParameterTypeTime,
		ParameterTypeTimetz,
		ParameterTypeVarbyte,
	}
}

const (
	// PrivacyBudgetTemplateAutoRefreshCalendarMonth is a PrivacyBudgetTemplateAutoRefresh enum value
	PrivacyBudgetTemplateAutoRefreshCalendarMonth = "CALENDAR_MONTH"

	// PrivacyBudgetTemplateAutoRefreshNone is a PrivacyBudgetTemplateAutoRefresh enum value
	PrivacyBudgetTemplateAutoRefreshNone = "NONE"
)

// PrivacyBudgetTemplateAutoRefresh_Values returns all elements of the PrivacyBudgetTemplateAutoRefresh enum
func PrivacyBudgetTemplateAutoRefresh_Values() []string {
	return []string{
		PrivacyBudgetTemplateAutoRefreshCalendarMonth,
		PrivacyBudgetTemplateAutoRefreshNone,
	}
}

const (
	// PrivacyBudgetTypeDifferentialPrivacy is a PrivacyBudgetType enum value
	PrivacyBudgetTypeDifferentialPrivacy = "DIFFERENTIAL_PRIVACY"
)

// PrivacyBudgetType_Values returns all elements of the PrivacyBudgetType enum
func PrivacyBudgetType_Values() []string {
	return []string{
		PrivacyBudgetTypeDifferentialPrivacy,
	}
}

const (
	// ProtectedQueryStatusSubmitted is a ProtectedQueryStatus enum value
	ProtectedQueryStatusSubmitted = "SUBMITTED"

	// ProtectedQueryStatusStarted is a ProtectedQueryStatus enum value
	ProtectedQueryStatusStarted = "STARTED"

	// ProtectedQueryStatusCancelled is a ProtectedQueryStatus enum value
	ProtectedQueryStatusCancelled = "CANCELLED"

	// ProtectedQueryStatusCancelling is a ProtectedQueryStatus enum value
	ProtectedQueryStatusCancelling = "CANCELLING"

	// ProtectedQueryStatusFailed is a ProtectedQueryStatus enum value
	ProtectedQueryStatusFailed = "FAILED"

	// ProtectedQueryStatusSuccess is a ProtectedQueryStatus enum value
	ProtectedQueryStatusSuccess = "SUCCESS"

	// ProtectedQueryStatusTimedOut is a ProtectedQueryStatus enum value
	ProtectedQueryStatusTimedOut = "TIMED_OUT"
)

// ProtectedQueryStatus_Values returns all elements of the ProtectedQueryStatus enum
func ProtectedQueryStatus_Values() []string {
	return []string{
		ProtectedQueryStatusSubmitted,
		ProtectedQueryStatusStarted,
		ProtectedQueryStatusCancelled,
		ProtectedQueryStatusCancelling,
		ProtectedQueryStatusFailed,
		ProtectedQueryStatusSuccess,
		ProtectedQueryStatusTimedOut,
	}
}

const (
	// ProtectedQueryTypeSql is a ProtectedQueryType enum value
	ProtectedQueryTypeSql = "SQL"
)

// ProtectedQueryType_Values returns all elements of the ProtectedQueryType enum
func ProtectedQueryType_Values() []string {
	return []string{
		ProtectedQueryTypeSql,
	}
}

const (
	// ResourceTypeConfiguredTable is a ResourceType enum value
	ResourceTypeConfiguredTable = "CONFIGURED_TABLE"

	// ResourceTypeCollaboration is a ResourceType enum value
	ResourceTypeCollaboration = "COLLABORATION"

	// ResourceTypeMembership is a ResourceType enum value
	ResourceTypeMembership = "MEMBERSHIP"

	// ResourceTypeConfiguredTableAssociation is a ResourceType enum value
	ResourceTypeConfiguredTableAssociation = "CONFIGURED_TABLE_ASSOCIATION"
)

// ResourceType_Values returns all elements of the ResourceType enum
func ResourceType_Values() []string {
	return []string{
		ResourceTypeConfiguredTable,
		ResourceTypeCollaboration,
		ResourceTypeMembership,
		ResourceTypeConfiguredTableAssociation,
	}
}

const (
	// ResultFormatCsv is a ResultFormat enum value
	ResultFormatCsv = "CSV"

	// ResultFormatParquet is a ResultFormat enum value
	ResultFormatParquet = "PARQUET"
)

// ResultFormat_Values returns all elements of the ResultFormat enum
func ResultFormat_Values() []string {
	return []string{
		ResultFormatCsv,
		ResultFormatParquet,
	}
}

const (
	// ScalarFunctionsAbs is a ScalarFunctions enum value
	ScalarFunctionsAbs = "ABS"

	// ScalarFunctionsCast is a ScalarFunctions enum value
	ScalarFunctionsCast = "CAST"

	// ScalarFunctionsCeiling is a ScalarFunctions enum value
	ScalarFunctionsCeiling = "CEILING"

	// ScalarFunctionsCoalesce is a ScalarFunctions enum value
	ScalarFunctionsCoalesce = "COALESCE"

	// ScalarFunctionsConvert is a ScalarFunctions enum value
	ScalarFunctionsConvert = "CONVERT"

	// ScalarFunctionsCurrentDate is a ScalarFunctions enum value
	ScalarFunctionsCurrentDate = "CURRENT_DATE"

	// ScalarFunctionsDateadd is a ScalarFunctions enum value
	ScalarFunctionsDateadd = "DATEADD"

	// ScalarFunctionsExtract is a ScalarFunctions enum value
	ScalarFunctionsExtract = "EXTRACT"

	// ScalarFunctionsFloor is a ScalarFunctions enum value
	ScalarFunctionsFloor = "FLOOR"

	// ScalarFunctionsGetdate is a ScalarFunctions enum value
	ScalarFunctionsGetdate = "GETDATE"

	// ScalarFunctionsLn is a ScalarFunctions enum value
	ScalarFunctionsLn = "LN"

	// ScalarFunctionsLog is a ScalarFunctions enum value
	ScalarFunctionsLog = "LOG"

	// ScalarFunctionsLower is a ScalarFunctions enum value
	ScalarFunctionsLower = "LOWER"

	// ScalarFunctionsRound is a ScalarFunctions enum value
	ScalarFunctionsRound = "ROUND"

	// ScalarFunctionsRtrim is a ScalarFunctions enum value
	ScalarFunctionsRtrim = "RTRIM"

	// ScalarFunctionsSqrt is a ScalarFunctions enum value
	ScalarFunctionsSqrt = "SQRT"

	// ScalarFunctionsSubstring is a ScalarFunctions enum value
	ScalarFunctionsSubstring = "SUBSTRING"

	// ScalarFunctionsToChar is a ScalarFunctions enum value
	ScalarFunctionsToChar = "TO_CHAR"

	// ScalarFunctionsToDate is a ScalarFunctions enum value
	ScalarFunctionsToDate = "TO_DATE"

	// ScalarFunctionsToNumber is a ScalarFunctions enum value
	ScalarFunctionsToNumber = "TO_NUMBER"

	// ScalarFunctionsToTimestamp is a ScalarFunctions enum value
	ScalarFunctionsToTimestamp = "TO_TIMESTAMP"

	// ScalarFunctionsTrim is a ScalarFunctions enum value
	ScalarFunctionsTrim = "TRIM"

	// ScalarFunctionsTrunc is a ScalarFunctions enum value
	ScalarFunctionsTrunc = "TRUNC"

	// ScalarFunctionsUpper is a ScalarFunctions enum value
	ScalarFunctionsUpper = "UPPER"
)

// ScalarFunctions_Values returns all elements of the ScalarFunctions enum
func ScalarFunctions_Values() []string {
	return []string{
		ScalarFunctionsAbs,
		ScalarFunctionsCast,
		ScalarFunctionsCeiling,
		ScalarFunctionsCoalesce,
		ScalarFunctionsConvert,
		ScalarFunctionsCurrentDate,
		ScalarFunctionsDateadd,
		ScalarFunctionsExtract,
		ScalarFunctionsFloor,
		ScalarFunctionsGetdate,
		ScalarFunctionsLn,
		ScalarFunctionsLog,
		ScalarFunctionsLower,
		ScalarFunctionsRound,
		ScalarFunctionsRtrim,
		ScalarFunctionsSqrt,
		ScalarFunctionsSubstring,
		ScalarFunctionsToChar,
		ScalarFunctionsToDate,
		ScalarFunctionsToNumber,
		ScalarFunctionsToTimestamp,
		ScalarFunctionsTrim,
		ScalarFunctionsTrunc,
		ScalarFunctionsUpper,
	}
}

const (
	// SchemaConfigurationDifferentialPrivacy is a SchemaConfiguration enum value
	SchemaConfigurationDifferentialPrivacy = "DIFFERENTIAL_PRIVACY"

	// SchemaConfigurationCustomAnalysisNotAllowed is a SchemaConfiguration enum value
	SchemaConfigurationCustomAnalysisNotAllowed = "CUSTOM_ANALYSIS_NOT_ALLOWED"

	// SchemaConfigurationNoMemberAccountAllowedToProvideAnalysis is a SchemaConfiguration enum value
	SchemaConfigurationNoMemberAccountAllowedToProvideAnalysis = "NO_MEMBER_ACCOUNT_ALLOWED_TO_PROVIDE_ANALYSIS"

	// SchemaConfigurationDifferentialPrivacyBudgetNotConfigured is a SchemaConfiguration enum value
	SchemaConfigurationDifferentialPrivacyBudgetNotConfigured = "DIFFERENTIAL_PRIVACY_BUDGET_NOT_CONFIGURED"

	// SchemaConfigurationIdMappingTableNotPopulated is a SchemaConfiguration enum value
	SchemaConfigurationIdMappingTableNotPopulated = "ID_MAPPING_TABLE_NOT_POPULATED"
)

// SchemaConfiguration_Values returns all elements of the SchemaConfiguration enum
func SchemaConfiguration_Values() []string {
	return []string{
		SchemaConfigurationDifferentialPrivacy,
		SchemaConfigurationCustomAnalysisNotAllowed,
		SchemaConfigurationNoMemberAccountAllowedToProvideAnalysis,
		SchemaConfigurationDifferentialPrivacyBudgetNotConfigured,
		SchemaConfigurationIdMappingTableNotPopulated,
	}
}

const (
	// SchemaStatusReady is a SchemaStatus enum value
	SchemaStatusReady = "READY"

	// SchemaStatusNotReady is a SchemaStatus enum value
	SchemaStatusNotReady = "NOT_READY"
)

// SchemaStatus_Values returns all elements of the SchemaStatus enum
func SchemaStatus_Values() []string {
	return []string{
		SchemaStatusReady,
		SchemaStatusNotReady,
	}
}

const (
	// SchemaStatusReasonCodeAnalysisRuleMissing is a SchemaStatusReasonCode enum value
	SchemaStatusReasonCodeAnalysisRuleMissing = "ANALYSIS_RULE_MISSING"

	// SchemaStatusReasonCodeAnalysisTemplatesNotConfigured is a SchemaStatusReasonCode enum value
	SchemaStatusReasonCodeAnalysisTemplatesNotConfigured = "ANALYSIS_TEMPLATES_NOT_CONFIGURED"

	// SchemaStatusReasonCodeAnalysisProvidersNotConfigured is a SchemaStatusReasonCode enum value
	SchemaStatusReasonCodeAnalysisProvidersNotConfigured = "ANALYSIS_PROVIDERS_NOT_CONFIGURED"

	// SchemaStatusReasonCodeDifferentialPrivacyPolicyNotConfigured is a SchemaStatusReasonCode enum value
	SchemaStatusReasonCodeDifferentialPrivacyPolicyNotConfigured = "DIFFERENTIAL_PRIVACY_POLICY_NOT_CONFIGURED"

	// SchemaStatusReasonCodeIdMappingTableNotPopulated is a SchemaStatusReasonCode enum value
	SchemaStatusReasonCodeIdMappingTableNotPopulated = "ID_MAPPING_TABLE_NOT_POPULATED"
)

// SchemaStatusReasonCode_Values returns all elements of the SchemaStatusReasonCode enum
func SchemaStatusReasonCode_Values() []string {
	return []string{
		SchemaStatusReasonCodeAnalysisRuleMissing,
		SchemaStatusReasonCodeAnalysisTemplatesNotConfigured,
		SchemaStatusReasonCodeAnalysisProvidersNotConfigured,
		SchemaStatusReasonCodeDifferentialPrivacyPolicyNotConfigured,
		SchemaStatusReasonCodeIdMappingTableNotPopulated,
	}
}

const (
	// SchemaTypeTable is a SchemaType enum value
	SchemaTypeTable = "TABLE"

	// SchemaTypeIdMappingTable is a SchemaType enum value
	SchemaTypeIdMappingTable = "ID_MAPPING_TABLE"
)

// SchemaType_Values returns all elements of the SchemaType enum
func SchemaType_Values() []string {
	return []string{
		SchemaTypeTable,
		SchemaTypeIdMappingTable,
	}
}

const (
	// TargetProtectedQueryStatusCancelled is a TargetProtectedQueryStatus enum value
	TargetProtectedQueryStatusCancelled = "CANCELLED"
)

// TargetProtectedQueryStatus_Values returns all elements of the TargetProtectedQueryStatus enum
func TargetProtectedQueryStatus_Values() []string {
	return []string{
		TargetProtectedQueryStatusCancelled,
	}
}

const (
	// ValidationExceptionReasonFieldValidationFailed is a ValidationExceptionReason enum value
	ValidationExceptionReasonFieldValidationFailed = "FIELD_VALIDATION_FAILED"

	// ValidationExceptionReasonInvalidConfiguration is a ValidationExceptionReason enum value
	ValidationExceptionReasonInvalidConfiguration = "INVALID_CONFIGURATION"

	// ValidationExceptionReasonInvalidQuery is a ValidationExceptionReason enum value
	ValidationExceptionReasonInvalidQuery = "INVALID_QUERY"

	// ValidationExceptionReasonIamSynchronizationDelay is a ValidationExceptionReason enum value
	ValidationExceptionReasonIamSynchronizationDelay = "IAM_SYNCHRONIZATION_DELAY"
)

// ValidationExceptionReason_Values returns all elements of the ValidationExceptionReason enum
func ValidationExceptionReason_Values() []string {
	return []string{
		ValidationExceptionReasonFieldValidationFailed,
		ValidationExceptionReasonInvalidConfiguration,
		ValidationExceptionReasonInvalidQuery,
		ValidationExceptionReasonIamSynchronizationDelay,
	}
}
