/*****************************************************************************
*                                                                            *
*  OpenNI 1.x Alpha                                                          *
*  Copyright (C) 2012 PrimeSense Ltd.                                        *
*                                                                            *
*  This file is part of OpenNI.                                              *
*                                                                            *
*  Licensed under the Apache License, Version 2.0 (the "License");           *
*  you may not use this file except in compliance with the License.          *
*  You may obtain a copy of the License at                                   *
*                                                                            *
*      http://www.apache.org/licenses/LICENSE-2.0                            *
*                                                                            *
*  Unless required by applicable law or agreed to in writing, software       *
*  distributed under the License is distributed on an "AS IS" BASIS,         *
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  *
*  See the License for the specific language governing permissions and       *
*  limitations under the License.                                            *
*                                                                            *
*****************************************************************************/
package org.openni;

import java.util.NoSuchElementException;

/**
 * Provides string names for all skeleton joints. <BR><BR>
 */
public enum SkeletonJoint
{
	HEAD(1),
	NECK(2),
	TORSO(3),
	WAIST(4),
	LEFT_COLLAR(5),
	LEFT_SHOULDER(6),
	LEFT_ELBOW(7),
	LEFT_WRIST(8),
	LEFT_HAND(9),
	LEFT_FINGER_TIP(10),
	RIGHT_COLLAR(11),
	RIGHT_SHOULDER(12),
	RIGHT_ELBOW(13),
	RIGHT_WRIST(14),
	RIGHT_HAND(15),
	RIGHT_FINGER_TIP(16),
	LEFT_HIP(17),
	LEFT_KNEE(18),
	LEFT_ANKLE(19),
	LEFT_FOOT(20),
	RIGHT_HIP(21),
	RIGHT_KNEE(22),
	RIGHT_ANKLE(23),
	RIGHT_FOOT(24);

	SkeletonJoint(int val)
	{
		this.val = val;
	}
	
	public int toNative() { return this.val; }
	
	public static SkeletonJoint fromNative(int value)
	{
		for (SkeletonJoint type : SkeletonJoint.values()) 
		{
			if (type.val == value)
				return type;
		}
		
		throw new NoSuchElementException();
	}
	
	private final int val;
}
