//==============================================================================
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Library General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//==============================================================================

//==============================================================================
// File: cFlamer.hpp
// Project: Shooting Star
// Author: Jarmo Hekkanen <jarski@2ndpoint.fi>
// Copyrights (c) 2003 2ndPoint ry (www.2ndpoint.fi)
//------------------------------------------------------------------------------
// Revision history
//==============================================================================
#ifndef cFlamer_hpp
#define cFlamer_hpp
//==============================================================================
// Includes
#include "cWeapon.hpp"
#include "cPointer.hpp"
#include "cFlameSystem.hpp"
#include "cParticleSystem.hpp"
//------------------------------------------------------------------------------
// Namespaces
using namespace std;
namespace ShootingStar {
//------------------------------------------------------------------------------
// Forward declarations
class cParticleSystem;
class cFlameSystem;
class cMixer;
//==============================================================================
	
//! Flamer
class cFlamer : public cWeapon
{
	// Constructor & Destructor
	public:
		//! Constructor
		cFlamer (void);
		//! Destructor
		virtual ~cFlamer (void);
	
	// Public methods
	public:
		virtual void Update (Uint32 deltaTime);
		virtual string GetName (void) const { return "Flame thrower"; };
		
		virtual void OnSetActive (void);
		virtual void BeginFiring (void);
		virtual void EndFiring (void);
	
	// Member variables
	private:
		Uint32 mSound;
		int mChannel;
		cPointer<cFlameSystem> mFlame;
		cPointer<cParticleSystem> mLighter;
};

//==============================================================================
}		// End of the ShootingStar namespace
#endif // cFlamer_hpp
//------------------------------------------------------------------------------
// EOF
//==============================================================================
